/*
 * help.cpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  help.cpp  --  help windows for Bracketing_to_HDR
*/
#include <cstdio>

#include <FL/Fl.H>              // Fl::w(), Fl::h()
#include <FL/Fl_Box.H>
#include <FL/Fl_Button.H>
#include <FL/fl_draw.H>         // fl_font()...

#include "help.hpp"
#include "br_version.hpp"       // BR_VERSION_STRING

#  ifndef LOCAL_TUTORIAL
#    include <FL/Fl_Output.H>
#  endif

/**================================================================
 *
 * class HelpAbout
 *
 *================================================================*/
 
/**----------------------------------------------------------------
 * Ctor()
 *
 * @param wid: widget [window] from which HelpAbout was ask for; 
 *   allows to position the help window relative to `wid'; not used 
 *   here till now, because we center to the screen.
 *----------------------------------------------------------------*/ 
HelpAbout::HelpAbout (Fl_Widget* /* wid */)
  : Fl_Window (0,0, "About \"Bracketing to HDR\"")
{
  static char s1 [80];
  sprintf(s1, "\"Bracketing to HDR\"  -  Version %s", BR_VERSION_STRING);
  static char* s2 = "Plugin for CinePaint";
  static char* s3 = "Merges bracketed exposures of a (still) scene into\none High Dynamic Range image (radiance map).";
  static char* s4 = "(c) 2005 Hartmut Sbosny\n<hartmut.sbosny@@gmx.de>";
  
  // Formerly simply so...
/*
  int X,Y, W=400,H=245;
  X = (Fl::w() - W) / 2;    // zentriert im Schirm
  Y = (Fl::h() - H) / 2;
  resize (X,Y,W,H);
  color(FL_LIGHT2);
  (new Fl_Box(0, 25,W,30, s1)) -> labelsize(21);
  (new Fl_Box(0, 50,W,30, s2)) -> labelsize(21);
  (new Fl_Box(0,100,W,30, s3)) -> labelsize(16);
  (new Fl_Box(0,150,W,30, s4)) -> labelsize(16);
  Fl_Button* b = new Fl_Button(W/2-40, H-40, 80,30, "Close");
  b -> color(FL_LIGHT2);
  b -> callback((Fl_Callback*)cb_close_, this);
*/
  // ...but didn't look well if fonts were not found. Now a bit fancy...
  int face = fl_font();  // previous face for restoring
  int size = fl_size();  // previous size for restoring
  
  int w1,h1, w3,h3;
  fl_font (face, 21);
  w1=h1=0; fl_measure (s1, w1,h1);   
  fl_font (face, 16);
  w3=h3=0; fl_measure (s3, w3,h3);   
  //printf("w1=%d, h1=%d;  w3=%d, h3=%d\n", w1,h1, w3,h3);
  
  int X,Y, W,H;
  W = w3+70; 
  H = 25 + h1+4+h1 + 29 + h3+18+h3 + 23 + 30+10; 
  if (W < 400) W=400;   // W = max (400, ...);
  if (H < 245) H=245;   // H = max (245, ...);
  //X = wid->x() + (wid->w() - W) / 2;  // zentriert zu `wid'
  //Y = wid->y() + (wid->h() - H) / 2; 
  X = (Fl::w() - W) / 2;                // zentriert im Schirm
  Y = (Fl::h() - H) / 2;
  //printf("X=%d, Y=%d, W=%d, H=%d\n", X,Y,W,H);
  
  resize (X,Y,W,H);
  color(FL_LIGHT2);
  
  (new Fl_Box(0, 25,            W,30, s1)) -> labelsize(21);
  (new Fl_Box(0, 25+h1+4,       W,30, s2)) -> labelsize(21);
  (new Fl_Box(0, 29+2*h1+29,    W,30, s3)) -> labelsize(16);
  (new Fl_Box(0, 58+2*h1+h3+18, W,30, s4)) -> labelsize(16);
      
  {Fl_Button* o = new Fl_Button(W/2-40, H-40, 80,30, "Close");
   o -> color(color());
   o -> callback((Fl_Callback*)cb_close_, this);
  } 
  fl_font(face,size);
  resizable(this);      // Why without effect???
  end(); // Fl_Window
}


/**================================================================
 *
 * class HelpTutorial
 *
 *================================================================*/
 
/**---------
 * Ctor()
 *---------*/
#ifdef LOCAL_TUTORIAL

HelpTutorial::HelpTutorial ()
{ 
  load("/home/hart/DocumentsLink/Notizen/HDR_Tutorial/HDR_Tutorial-de.html");
}

#else

// For drawing of web addresses use Fl_Output (and not Fl_Box) because this
//  allows text selection via mouse and paste and copy; even maybe after
//  selection "the system" offers automatically (like KDE) to open it using 
//  one of its browsers.

HelpTutorial::HelpTutorial () 
  : Fl_Window (400, 250, "Help :: HDR-Tutorial...")
{ 
  char* link_de = " http://people.freenet.de/hsbosny/HDR_Tutorial/HDR_Tutorial-de.html ";
  char* link_en = " http://people.freenet.de/hsbosny/HDR_Tutorial/HDR_Tutorial-en.html ";
  char* text_de = "Eine deutsche Anleitung finden Sie unter";
  char* text_en = "An english tutorial you will find at";
  
  color(FL_LIGHT2);
  int face = fl_font();  // previous face for restoring
  int size = fl_size();  // previous size for restoring
  int fsz = 16;          // font size for Fl_Output
  int fsz2 = 18;         // font size for the headline
  
  int w1=0, h1=0;
  fl_font (face, fsz);   // set only for fl_measure()
  fl_measure (link_de, w1,h1);
  if (w1 + 40 > w()) {
    resize(x(), y(), w1+40, h());
  }
  int H = 40;
  {Fl_Box* o = new Fl_Box(20,H,w1,fsz2, "HDR-Tutorial...");
   o -> labelsize(fsz2);
   o -> align(FL_ALIGN_LEFT | FL_ALIGN_INSIDE);
   o -> color(color());
  }
  H += fsz2+20;
  {Fl_Box* o = new Fl_Box (20,H,w1,h1, text_en);
   o -> labelsize(fsz);
   o -> align(FL_ALIGN_LEFT | FL_ALIGN_INSIDE);
   o -> color(color());
  }
  H += h1+2;
  {Fl_Output* o = new Fl_Output (20,H,w1,h1);
   o -> value (link_en);
   o -> color(FL_LIGHT3);
   o -> textsize(fsz);
   o -> box(FL_FLAT_BOX);
  }
  H += h1+20;
  {Fl_Box* o = new Fl_Box (20,H,w1,h1, text_de);
   o -> labelsize(fsz);
   o -> align(FL_ALIGN_LEFT | FL_ALIGN_INSIDE);
   o -> color(color());
  }
  H += h1+2;
  {Fl_Output* o = new Fl_Output (20,H,w1,h1);
   o -> value (link_de);
   o -> color(FL_LIGHT3);
   o -> textsize(fsz);
   o -> box(FL_FLAT_BOX);
  }
  {Fl_Button* o = new Fl_Button(w()/2-40, h()-40, 80,30, "Close");
   o -> color(color());
   o -> callback((Fl_Callback*)cb_close_, this);
  }
  fl_font(face,size);
  resizable (this);         // Why without effect???
  end(); // Fl_Window
}

#endif  // LOCAL_TUTORIAL (else)


// END OF FILE
