/*
 * br_types_plot.hpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  br_types_plot.hpp

  Types for plotting (of Curves) in the bracketing_to_hdr project. 
   Not in "br_types.hpp" because of dependency on "CurveTnt.hpp".
*/
#ifndef br_types_plot_hpp
#define br_types_plot_hpp


#include "CurveTnt.hpp"     // CurveTntPlot<..>

/**--------------------------------------------------------------------
 * Contents:
 *   PlotDataT      -- the type of the (curve) data to plot
 *   Array1DPlot    -- the type of corresponding 1D-Arrays; (not used)
 *   CurvePlotClass -- the type of the CurveTntPlot specialization for it
 *
 * As far as Camera::get_FollowCurve() is fixed to double, PlotDataT too!
 *---------------------------------------------------------------------*/
typedef double                        PlotDataT; 
//typedef TNT::Array1D<PlotDataT>       Array1DPlot;  
typedef TNT::CurveTntPlot<PlotDataT>  CurvePlotClass;


#endif // br_types_plot_hpp

// END OF FILE
