/*
 * FilePtr.hpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
   FilePtr.hpp
*/
#ifndef FilePtr_hpp
#define FilePtr_hpp


#include <cstdio>       // printf()
#include <exception>    // class exeption
//#include <fstream>    //



// ============================================================
// Provisorische Ausnahme-Klasse; von std::exception abgeleitet
// ============================================================
class Ausnahme : public std::exception 
{
public:
  virtual void report () const throw() {}  // oder abstrakt?;
};


class ausn_file_io : public Ausnahme 
{
  const char *fname;

public:
  ausn_file_io (const char *fn) throw()  
    { fname = fn; }

  virtual ~ausn_file_io () throw()
    { printf ("Destruktor von %s\n", __func__); }

  virtual const char* what() const throw()
    { return "Datei I/O"; }

  virtual void report () const throw();
};



// ===================
// Die FilePtr-Klasse:
// ===================
/*  Konstruktor wirft ausn_file_io bei Misserfolg.
*/
class FilePtr 
{
  FILE* f;

public:
  FilePtr (const char *fname, const char *mode);
  FilePtr (FILE* p)     { f = p; }          // uebernimmt extern belegtes
  ~FilePtr ()           { if (f) fclose (f); }
  operator FILE*()      { return f; }       // cast zu FILE*
};


#if 0
/** 
  Das Folgende ist der Versuch, auch fuer fstream Abfrage und Fehlermeldung
  in eine eigene Klasse auszulagern, die dann genau wie ein geoeffneter
  fstream benutzt werden kann; letztere durch Definition eines cast-Op
  zu fstream& (analog zu FilePtr). Hakt leider daran, dass in
      Fstream f(name);
      f << i;
  `f' vom Compiler nicht als "gemeinter" fstream erkannt wird, woran auch.
  Klappt erst mit expliziter Cast-Anweisung
      (fstream&) f << i;

  Nun gut, das nuetzt keinem. Den <<-Op fuer Fstream zu definieren, bringt
  auch nichts, fuer die Verwendung ``f << i'' muesste das gemaess

      Fstream& operator<< (Fstream& o, const int& i)

  geschehen, also fuer alle eingebauten Datentypen noch einmal.
    
  Eine Variante faellt mir noch ein: Dazu den ()-Op, die Funktionssyntax 
  ``Fstream()'' nutzen. Dann muesste man nur noch schreiben ``f() << i''.
*/
class Ofstream 
{
  std::ofstream f;

public:
  Ofstream (const char* fname) : f(fname)
  {
    if (!f) {
      printf ("%s(): Kann \"%s\" nicht oeffnen\n", __func__, fname);
      throw ausn_file_io (fname);
    }
  }

  operator std::ofstream&()    { return f; }      // cast zu ofstream-Ref
  operator std::ofstream&()()  { return f; }      // ()-Op
};
#endif



#endif  // FilePtr_hpp

// END OF FILE
