# Copyright (c) 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'dependencies': [
    'browser/speech/proto/speech_proto.gyp:speech_proto',
    '../base/base.gyp:base_static',
    '../crypto/crypto.gyp:crypto',
    '../google_apis/google_apis.gyp:google_apis',
    '../net/net.gyp:net',
    '../skia/skia.gyp:skia',
    '../sql/sql.gyp:sql',
    '../third_party/re2/re2.gyp:re2',
    '../third_party/zlib/zlib.gyp:zip',
    '../third_party/zlib/zlib.gyp:zlib',
    '../ui/snapshot/snapshot.gyp:snapshot',
    '../ui/ui.gyp:ui',
    '../ui/ui.gyp:ui_resources',
  ],
  'include_dirs': [
    '..',
    '<(INTERMEDIATE_DIR)',
  ],
  'sources': [
    'port/browser/event_with_latency_info.h',
    'port/browser/location_provider.h',
    'port/browser/render_view_host_delegate_view.h',
    'port/browser/render_widget_host_view_port.h',
    'port/browser/smooth_scroll_gesture.h',
    'port/browser/web_contents_view_port.h',
    'public/browser/access_token_store.h',
    'public/browser/android/compositor.h',
    'public/browser/android/compositor_client.h',
    'public/browser/android/content_view_core.h',
    'public/browser/android/content_view_layer_renderer.h',
    'public/browser/android/devtools_auth.h',
    'public/browser/android/download_controller_android.h',
    'public/browser/android/synchronous_compositor_client.h',
    'public/browser/android/synchronous_compositor.h',
    'public/browser/browser_accessibility_state.h',
    'public/browser/browser_child_process_host.h',
    'public/browser/browser_child_process_host_delegate.cc',
    'public/browser/browser_child_process_host_delegate.h',
    'public/browser/browser_child_process_host_iterator.cc',
    'public/browser/browser_child_process_host_iterator.h',
    'public/browser/browser_child_process_observer.cc',
    'public/browser/browser_child_process_observer.h',
    'public/browser/browser_context.h',
    'public/browser/browser_ipc_logging.h',
    'public/browser/browser_main_parts.cc',
    'public/browser/browser_main_parts.h',
    'public/browser/browser_main_runner.h',
    'public/browser/browser_message_filter.cc',
    'public/browser/browser_message_filter.h',
    'public/browser/browser_plugin_guest_delegate.cc',
    'public/browser/browser_plugin_guest_delegate.h',
    'public/browser/browser_ppapi_host.h',
    'public/browser/browser_shutdown.h',
    'public/browser/browser_url_handler.h',
    'public/browser/browser_thread.h',
    'public/browser/browser_thread_delegate.h',
    'public/browser/cert_store.h',
    'public/browser/child_process_data.h',
    'public/browser/child_process_security_policy.h',
    'public/browser/color_chooser.h',
    'public/browser/compositor_util.h',
    'public/browser/certificate_request_result_type.h',
    'public/browser/content_browser_client.cc',
    'public/browser/content_browser_client.h',
    'public/browser/cookie_store_factory.h',
    'public/browser/devtools_agent_host.h',
    'public/browser/devtools_client_host.h',
    'public/browser/devtools_external_agent_proxy.h',
    'public/browser/devtools_external_agent_proxy_delegate.h',
    'public/browser/download_danger_type.h',
    'public/browser/devtools_frontend_host_delegate.h',
    'public/browser/devtools_http_handler.h',
    'public/browser/devtools_http_handler_delegate.h',
    'public/browser/devtools_manager.h',
    'public/browser/dom_operation_notification_details.h',
    'public/browser/dom_storage_context.h',
    'public/browser/download_destination_observer.h',
    'public/browser/download_interrupt_reason_values.h',
    'public/browser/download_interrupt_reasons.h',
    'public/browser/download_item.h',
    'public/browser/download_manager.h',
    'public/browser/download_manager_delegate.cc',
    'public/browser/download_manager_delegate.h',
    'public/browser/download_save_info.cc',
    'public/browser/download_save_info.h',
    'public/browser/download_url_parameters.cc',
    'public/browser/download_url_parameters.h',
    'public/browser/favicon_status.cc',
    'public/browser/favicon_status.h',
    'public/browser/file_descriptor_info.h',
    'public/browser/font_list_async.h',
    'public/browser/geolocation_permission_context.h',
    'public/browser/geolocation_provider.h',
    'public/browser/global_request_id.h',
    'public/browser/gpu_data_manager.h',
    'public/browser/gpu_data_manager_observer.h',
    'public/browser/histogram_fetcher.h',
    'public/browser/host_zoom_map.h',
    'public/browser/indexed_db_context.h',
    'public/browser/indexed_db_info.cc',
    'public/browser/indexed_db_info.h',
    'public/browser/interstitial_page.h',
    'public/browser/invalidate_type.h',
    'public/browser/javascript_dialog_manager.cc',
    'public/browser/javascript_dialog_manager.h',
    'public/browser/keyboard_listener.h',
    'public/browser/load_from_memory_cache_details.cc',
    'public/browser/load_from_memory_cache_details.h',
    'public/browser/load_notification_details.h',
    'public/browser/local_storage_usage_info.cc',
    'public/browser/local_storage_usage_info.h',
    'public/browser/media_devices_monitor.h',
    'public/browser/native_web_keyboard_event.h',
    'public/browser/navigation_controller.cc',
    'public/browser/navigation_controller.h',
    'public/browser/navigation_details.cc',
    'public/browser/navigation_details.h',
    'public/browser/navigation_entry.h',
    'public/browser/navigation_type.h',
    'public/browser/notification_details.h',
    'public/browser/notification_observer.h',
    'public/browser/notification_registrar.cc',
    'public/browser/notification_registrar.h',
    'public/browser/notification_service.h',
    'public/browser/notification_source.h',
    'public/browser/notification_types.h',
    'public/browser/overscroll_configuration.h',
    'public/browser/page_navigator.cc',
    'public/browser/page_navigator.h',
    'public/browser/pepper_flash_settings_helper.h',
    'public/browser/plugin_data_remover.h',
    'public/browser/plugin_service.h',
    'public/browser/plugin_service_filter.h',
    'public/browser/power_save_blocker.h',
    'public/browser/profiler_controller.h',
    'public/browser/profiler_subscriber.h',
    'public/browser/quota_permission_context.h',
    'public/browser/render_frame_host.h',
    'public/browser/render_process_host.h',
    'public/browser/render_process_host_factory.h',
    'public/browser/render_view_host.h',
    'public/browser/render_view_host_observer.cc',
    'public/browser/render_view_host_observer.h',
    'public/browser/render_widget_host.h',
    'public/browser/render_widget_host_view.h',
    'public/browser/render_widget_host_view_mac_delegate.h',
    'public/browser/resource_context.h',
    'public/browser/resource_controller.h',
    'public/browser/resource_dispatcher_host.h',
    'public/browser/resource_dispatcher_host_delegate.cc',
    'public/browser/resource_dispatcher_host_delegate.h',
    'public/browser/resource_dispatcher_host_login_delegate.h',
    'public/browser/resource_request_details.cc',
    'public/browser/resource_request_details.h',
    'public/browser/resource_request_info.h',
    'public/browser/resource_throttle.h',
    'public/browser/save_page_type.h',
    'public/browser/session_storage_namespace.h',
    'public/browser/session_storage_usage_info.h',
    'public/browser/site_instance.h',
    'public/browser/speech_recognition_event_listener.h',
    'public/browser/speech_recognition_manager.h',
    'public/browser/speech_recognition_manager_delegate.h',
    'public/browser/speech_recognition_session_config.cc',
    'public/browser/speech_recognition_session_config.h',
    'public/browser/speech_recognition_session_context.cc',
    'public/browser/speech_recognition_session_context.h',
    'public/browser/storage_partition.h',
    'public/browser/stream_handle.h',
    'public/browser/trace_controller.h',
    'public/browser/trace_subscriber.h',
    'public/browser/user_metrics.h',
    'public/browser/utility_process_host.h',
    'public/browser/web_contents.cc',
    'public/browser/web_contents.h',
    'public/browser/web_contents_delegate.cc',
    'public/browser/web_contents_delegate.h',
    'public/browser/web_contents_observer.cc',
    'public/browser/web_contents_observer.h',
    'public/browser/web_contents_user_data.h',
    'public/browser/web_contents_view.h',
    'public/browser/web_contents_view_delegate.h',
    'public/browser/web_drag_dest_delegate.h',
    'public/browser/web_ui.h',
    'public/browser/web_ui_controller.cc',
    'public/browser/web_ui_controller.h',
    'public/browser/web_ui_controller_factory.h',
    'public/browser/web_ui_data_source.h',
    'public/browser/url_data_source.cc',
    'public/browser/url_data_source.h',
    'public/browser/web_ui_message_handler.h',
    'public/browser/worker_service.h',
    'public/browser/worker_service_observer.h',
    'public/browser/zygote_host_linux.h',
    'browser/accessibility/accessibility_tree_formatter.cc',
    'browser/accessibility/accessibility_tree_formatter.h',
    'browser/accessibility/accessibility_tree_formatter_android.cc',
    'browser/accessibility/accessibility_tree_formatter_gtk.cc',
    'browser/accessibility/accessibility_tree_formatter_mac.mm',
    'browser/accessibility/accessibility_tree_formatter_utils_win.cc',
    'browser/accessibility/accessibility_tree_formatter_utils_win.h',
    'browser/accessibility/accessibility_tree_formatter_win.cc',
    'browser/accessibility/accessibility_ui.cc',
    'browser/accessibility/accessibility_ui.h',
    'browser/accessibility/browser_accessibility.cc',
    'browser/accessibility/browser_accessibility.h',
    'browser/accessibility/browser_accessibility_android.cc',
    'browser/accessibility/browser_accessibility_android.h',
    'browser/accessibility/browser_accessibility_cocoa.h',
    'browser/accessibility/browser_accessibility_cocoa.mm',
    'browser/accessibility/browser_accessibility_delegate_mac.h',
    'browser/accessibility/browser_accessibility_gtk.cc',
    'browser/accessibility/browser_accessibility_gtk.h',
    'browser/accessibility/browser_accessibility_mac.h',
    'browser/accessibility/browser_accessibility_mac.mm',
    'browser/accessibility/browser_accessibility_manager.cc',
    'browser/accessibility/browser_accessibility_manager.h',
    'browser/accessibility/browser_accessibility_manager_android.cc',
    'browser/accessibility/browser_accessibility_manager_android.h',
    'browser/accessibility/browser_accessibility_manager_gtk.cc',
    'browser/accessibility/browser_accessibility_manager_gtk.h',
    'browser/accessibility/browser_accessibility_manager_mac.h',
    'browser/accessibility/browser_accessibility_manager_mac.mm',
    'browser/accessibility/browser_accessibility_manager_win.cc',
    'browser/accessibility/browser_accessibility_manager_win.h',
    'browser/accessibility/browser_accessibility_state_impl.cc',
    'browser/accessibility/browser_accessibility_state_impl_win.cc',
    'browser/accessibility/browser_accessibility_state_impl.h',
    'browser/accessibility/browser_accessibility_win.cc',
    'browser/accessibility/browser_accessibility_win.h',
    'browser/android/android_browser_process.cc',
    'browser/android/android_browser_process.h',
    'browser/android/browser_jni_registrar.cc',
    'browser/android/browser_jni_registrar.h',
    'browser/android/browser_media_player_manager.cc',
    'browser/android/browser_media_player_manager.h',
    'browser/android/browser_startup_config.cc',
    'browser/android/browser_startup_config.h',
    'browser/android/child_process_launcher_android.cc',
    'browser/android/child_process_launcher_android.h',
    'browser/android/content_settings.cc',
    'browser/android/content_settings.h',
    'browser/android/content_startup_flags.cc',
    'browser/android/content_startup_flags.h',
    'browser/android/content_video_view.cc',
    'browser/android/content_video_view.h',
    'browser/android/content_view_core_impl.cc',
    'browser/android/content_view_core_impl.h',
    'browser/android/content_view_render_view.cc',
    'browser/android/content_view_render_view.h',
    'browser/android/content_view_statics.cc',
    'browser/android/content_view_statics.h',
    'browser/android/date_time_chooser_android.cc',
    'browser/android/date_time_chooser_android.h',
    'browser/android/download_controller_android_impl.cc',
    'browser/android/download_controller_android_impl.h',
    'browser/android/devtools_auth.cc',
    'browser/android/edge_effect.h',
    'browser/android/edge_effect.cc',
    'browser/android/in_process/synchronous_compositor_impl.cc',
    'browser/android/in_process/synchronous_compositor_impl.h',
    'browser/android/in_process/synchronous_compositor_output_surface.cc',
    'browser/android/in_process/synchronous_compositor_output_surface.h',
    'browser/android/in_process/synchronous_input_event_filter.cc',
    'browser/android/in_process/synchronous_input_event_filter.h',
    'browser/android/interstitial_page_delegate_android.cc',
    'browser/android/interstitial_page_delegate_android.h',
    'browser/android/load_url_params.cc',
    'browser/android/load_url_params.h',
    'browser/android/media_resource_getter_impl.cc',
    'browser/android/media_resource_getter_impl.h',
    'browser/android/overscroll_glow.h',
    'browser/android/overscroll_glow.cc',
    'browser/android/surface_texture_peer_browser_impl.cc',
    'browser/android/surface_texture_peer_browser_impl.h',
    'browser/android/touch_point.cc',
    'browser/android/touch_point.h',
    'browser/android/tracing_intent_handler.cc',
    'browser/android/tracing_intent_handler.h',
    'browser/android/vibration_message_filter.cc',
    'browser/android/vibration_message_filter.h',
    'browser/android/web_contents_observer_android.cc',
    'browser/android/web_contents_observer_android.h',
    'browser/appcache/appcache_dispatcher_host.cc',
    'browser/appcache/appcache_dispatcher_host.h',
    'browser/appcache/appcache_frontend_proxy.cc',
    'browser/appcache/appcache_frontend_proxy.h',
    'browser/appcache/chrome_appcache_service.cc',
    'browser/appcache/chrome_appcache_service.h',
    'browser/aura/browser_compositor_output_surface.cc',
    'browser/aura/browser_compositor_output_surface.h',
    'browser/aura/browser_compositor_output_surface_proxy.cc',
    'browser/aura/browser_compositor_output_surface_proxy.h',
    'browser/aura/gpu_process_transport_factory.cc',
    'browser/aura/gpu_process_transport_factory.h',
    'browser/aura/image_transport_factory.cc',
    'browser/aura/image_transport_factory.h',
    'browser/aura/no_transport_image_transport_factory.cc',
    'browser/aura/no_transport_image_transport_factory.h',
    'browser/aura/reflector_impl.cc',
    'browser/aura/reflector_impl.h',
    'browser/aura/software_browser_compositor_output_surface.cc',
    'browser/aura/software_browser_compositor_output_surface.h',
    'browser/aura/software_output_device_win.cc',
    'browser/aura/software_output_device_win.h',
    'browser/aura/software_output_device_x11.cc',
    'browser/aura/software_output_device_x11.h',
    'browser/browser_child_process_host_impl.cc',
    'browser/browser_child_process_host_impl.h',
    'browser/browser_context.cc',
    'browser/browser_ipc_logging.cc',
    'browser/browser_main.cc',
    'browser/browser_main.h',
    'browser/browser_main_loop.cc',
    'browser/browser_main_loop.h',
    'browser/browser_main_runner.cc',
    'browser/browser_plugin/browser_plugin_embedder.cc',
    'browser/browser_plugin/browser_plugin_embedder.h',
    'browser/browser_plugin/browser_plugin_geolocation_permission_context.cc',
    'browser/browser_plugin/browser_plugin_geolocation_permission_context.h',
    'browser/browser_plugin/browser_plugin_guest.cc',
    'browser/browser_plugin/browser_plugin_guest.h',
    'browser/browser_plugin/browser_plugin_guest_helper.cc',
    'browser/browser_plugin/browser_plugin_guest_helper.h',
    'browser/browser_plugin/browser_plugin_guest_manager.cc',
    'browser/browser_plugin/browser_plugin_guest_manager.h',
    'browser/browser_plugin/browser_plugin_host_factory.h',
    'browser/browser_plugin/browser_plugin_message_filter.cc',
    'browser/browser_plugin/browser_plugin_message_filter.h',
    'browser/browser_plugin/browser_plugin_popup_menu_helper_mac.h',
    'browser/browser_plugin/browser_plugin_popup_menu_helper_mac.mm',
    'browser/browser_process_sub_thread.cc',
    'browser/browser_process_sub_thread.h',
    'browser/browser_thread_impl.cc',
    'browser/browser_thread_impl.h',
    'browser/browser_url_handler_impl.cc',
    'browser/browser_url_handler_impl.h',
    'browser/browsing_instance.cc',
    'browser/browsing_instance.h',
    'browser/byte_stream.cc',
    'browser/byte_stream.h',
    'browser/cert_store_impl.cc',
    'browser/cert_store_impl.h',
    'browser/child_process_launcher.cc',
    'browser/child_process_launcher.h',
    'browser/child_process_security_policy_impl.cc',
    'browser/child_process_security_policy_impl.h',
    'browser/cross_site_request_manager.cc',
    'browser/cross_site_request_manager.h',
    'browser/devtools/devtools_agent_host_impl.cc',
    'browser/devtools/devtools_agent_host_impl.h',
    'browser/devtools/devtools_browser_target.cc',
    'browser/devtools/devtools_browser_target.h',
    'browser/devtools/devtools_external_agent_proxy_impl.cc',
    'browser/devtools/devtools_external_agent_proxy_impl.h',
    'browser/devtools/devtools_frontend_host.cc',
    'browser/devtools/devtools_frontend_host.h',
    'browser/devtools/devtools_http_handler_impl.cc',
    'browser/devtools/devtools_http_handler_impl.h',
    'browser/devtools/devtools_manager_impl.cc',
    'browser/devtools/devtools_manager_impl.h',
    'browser/devtools/devtools_netlog_observer.cc',
    'browser/devtools/devtools_netlog_observer.h',
    'browser/devtools/devtools_protocol.cc',
    'browser/devtools/devtools_protocol.h',
    'browser/devtools/devtools_protocol_constants.cc',
    'browser/devtools/devtools_protocol_constants.h',
    'browser/devtools/devtools_tracing_handler.h',
    'browser/devtools/devtools_tracing_handler.cc',
    'browser/devtools/ipc_devtools_agent_host.cc',
    'browser/devtools/ipc_devtools_agent_host.h',
    'browser/devtools/render_view_devtools_agent_host.cc',
    'browser/devtools/render_view_devtools_agent_host.h',
    'browser/devtools/renderer_overrides_handler.cc',
    'browser/devtools/renderer_overrides_handler.h',
    'browser/devtools/tethering_handler.h',
    'browser/devtools/tethering_handler.cc',
    'browser/devtools/worker_devtools_manager.cc',
    'browser/devtools/worker_devtools_manager.h',
    'browser/devtools/worker_devtools_message_filter.cc',
    'browser/devtools/worker_devtools_message_filter.h',
    'browser/device_monitor_linux.cc',
    'browser/device_monitor_linux.h',
    'browser/device_monitor_mac.h',
    'browser/device_monitor_mac.mm',
    'browser/device_orientation/accelerometer_mac.cc',
    'browser/device_orientation/accelerometer_mac.h',
    'browser/device_orientation/data_fetcher.h',
    'browser/device_orientation/data_fetcher_impl_android.cc',
    'browser/device_orientation/data_fetcher_impl_android.h',
    'browser/device_orientation/data_fetcher_impl_win.cc',
    'browser/device_orientation/data_fetcher_impl_win.h',
    'browser/device_orientation/data_fetcher_orientation_android.cc',
    'browser/device_orientation/data_fetcher_orientation_android.h',
    'browser/device_orientation/data_fetcher_shared_memory_android.cc',
    'browser/device_orientation/data_fetcher_shared_memory_default.cc',
    'browser/device_orientation/data_fetcher_shared_memory.h',
    'browser/device_orientation/device_data.h',
    'browser/device_orientation/device_motion_message_filter.cc',
    'browser/device_orientation/device_motion_message_filter.h',
    'browser/device_orientation/device_motion_provider.cc',
    'browser/device_orientation/device_motion_provider.h',
    'browser/device_orientation/device_motion_service.cc',
    'browser/device_orientation/device_motion_service.h',
    'browser/device_orientation/device_orientation_message_filter.cc',
    'browser/device_orientation/device_orientation_message_filter.h',
    'browser/device_orientation/message_filter.cc',
    'browser/device_orientation/message_filter.h',
    'browser/device_orientation/observer_delegate.cc',
    'browser/device_orientation/observer_delegate.h',
    'browser/device_orientation/orientation.cc',
    'browser/device_orientation/orientation.h',
    'browser/device_orientation/orientation_message_filter.cc',
    'browser/device_orientation/orientation_message_filter.h',
    'browser/device_orientation/provider.cc',
    'browser/device_orientation/provider.h',
    'browser/device_orientation/provider_impl.cc',
    'browser/device_orientation/provider_impl.h',
    'browser/dom_storage/dom_storage_area.cc',
    'browser/dom_storage/dom_storage_area.h',
    'browser/dom_storage/dom_storage_context_impl.cc',
    'browser/dom_storage/dom_storage_context_impl.h',
    'browser/dom_storage/dom_storage_context_wrapper.cc',
    'browser/dom_storage/dom_storage_context_wrapper.h',
    'browser/dom_storage/dom_storage_database.cc',
    'browser/dom_storage/dom_storage_database.h',
    'browser/dom_storage/dom_storage_database_adapter.h',
    'browser/dom_storage/dom_storage_host.cc',
    'browser/dom_storage/dom_storage_host.h',
    'browser/dom_storage/dom_storage_message_filter.cc',
    'browser/dom_storage/dom_storage_message_filter.h',
    'browser/dom_storage/dom_storage_namespace.cc',
    'browser/dom_storage/dom_storage_namespace.h',
    'browser/dom_storage/dom_storage_session.cc',
    'browser/dom_storage/dom_storage_session.h',
    'browser/dom_storage/dom_storage_task_runner.cc',
    'browser/dom_storage/dom_storage_task_runner.h',
    'browser/dom_storage/local_storage_database_adapter.cc',
    'browser/dom_storage/local_storage_database_adapter.h',
    'browser/dom_storage/session_storage_database.cc',
    'browser/dom_storage/session_storage_database.h',
    'browser/dom_storage/session_storage_database_adapter.cc',
    'browser/dom_storage/session_storage_database_adapter.h',
    'browser/dom_storage/session_storage_namespace_impl.cc',
    'browser/dom_storage/session_storage_namespace_impl.h',
    'browser/download/base_file.cc',
    'browser/download/base_file.h',
    'browser/download/base_file_linux.cc',
    'browser/download/base_file_mac.cc',
    'browser/download/base_file_posix.cc',
    'browser/download/base_file_win.cc',
    'browser/download/download_create_info.cc',
    'browser/download/download_create_info.h',
    'browser/download/download_file.h',
    'browser/download/download_file_factory.cc',
    'browser/download/download_file_factory.h',
    'browser/download/download_file_impl.cc',
    'browser/download/download_file_impl.h',
    'browser/download/download_interrupt_reasons_impl.cc',
    'browser/download/download_interrupt_reasons_impl.h',
    'browser/download/download_item_factory.h',
    'browser/download/download_item_impl.cc',
    'browser/download/download_item_impl.h',
    'browser/download/download_item_impl_delegate.cc',
    'browser/download/download_item_impl_delegate.h',
    'browser/download/download_manager_impl.cc',
    'browser/download/download_manager_impl.h',
    'browser/download/download_net_log_parameters.cc',
    'browser/download/download_net_log_parameters.h',
    'browser/download/download_request_handle.cc',
    'browser/download/download_request_handle.h',
    'browser/download/download_resource_handler.cc',
    'browser/download/download_resource_handler.h',
    'browser/download/download_stats.cc',
    'browser/download/download_stats.h',
    'browser/download/drag_download_file.cc',
    'browser/download/drag_download_file.h',
    'browser/download/drag_download_util.cc',
    'browser/download/drag_download_util.h',
    'browser/download/file_metadata_linux.cc',
    'browser/download/file_metadata_linux.h',
    'browser/download/file_metadata_mac.h',
    'browser/download/file_metadata_mac.mm',
    'browser/download/mhtml_generation_manager.cc',
    'browser/download/mhtml_generation_manager.h',
    'browser/download/rate_estimator.cc',
    'browser/download/rate_estimator.h',
    'browser/download/save_file.cc',
    'browser/download/save_file.h',
    'browser/download/save_file_manager.cc',
    'browser/download/save_file_manager.h',
    'browser/download/save_file_resource_handler.cc',
    'browser/download/save_file_resource_handler.h',
    'browser/download/save_item.cc',
    'browser/download/save_item.h',
    'browser/download/save_package.cc',
    'browser/download/save_package.h',
    'browser/download/save_types.cc',
    'browser/download/save_types.h',
    'browser/fileapi/browser_file_system_helper.cc',
    'browser/fileapi/browser_file_system_helper.h',
    'browser/fileapi/chrome_blob_storage_context.cc',
    'browser/fileapi/chrome_blob_storage_context.h',
    'browser/fileapi/fileapi_message_filter.cc',
    'browser/fileapi/fileapi_message_filter.h',
    'browser/font_list_async.cc',
    'browser/gamepad/gamepad_data_fetcher.h',
    'browser/gamepad/gamepad_platform_data_fetcher.h',
    'browser/gamepad/gamepad_platform_data_fetcher_linux.cc',
    'browser/gamepad/gamepad_platform_data_fetcher_linux.h',
    'browser/gamepad/gamepad_platform_data_fetcher_mac.h',
    'browser/gamepad/gamepad_platform_data_fetcher_mac.mm',
    'browser/gamepad/gamepad_platform_data_fetcher_win.cc',
    'browser/gamepad/gamepad_platform_data_fetcher_win.h',
    'browser/gamepad/gamepad_provider.cc',
    'browser/gamepad/gamepad_provider.h',
    'browser/gamepad/gamepad_service.cc',
    'browser/gamepad/gamepad_service.h',
    'browser/gamepad/gamepad_standard_mappings.h',
    'browser/gamepad/gamepad_standard_mappings_linux.cc',
    'browser/gamepad/gamepad_standard_mappings_mac.mm',
    'browser/gamepad/gamepad_standard_mappings_win.cc',
    'browser/gamepad/xbox_data_fetcher_mac.cc',
    'browser/gamepad/xbox_data_fetcher_mac.h',
    'browser/geolocation/core_location_data_provider_mac.h',
    'browser/geolocation/core_location_data_provider_mac.mm',
    'browser/geolocation/core_location_provider_mac.h',
    'browser/geolocation/core_location_provider_mac.mm',
    'browser/geolocation/device_data_provider.cc',
    'browser/geolocation/device_data_provider.h',
    'browser/geolocation/empty_device_data_provider.cc',
    'browser/geolocation/empty_device_data_provider.h',
    'browser/geolocation/geolocation_dispatcher_host.cc',
    'browser/geolocation/geolocation_dispatcher_host.h',
    'browser/geolocation/geolocation_provider_impl.cc',
    'browser/geolocation/geolocation_provider_impl.h',
    'browser/geolocation/gps_location_provider_linux.cc',
    'browser/geolocation/gps_location_provider_linux.h',
    'browser/geolocation/location_api_adapter_android.cc',
    'browser/geolocation/location_api_adapter_android.h',
    'browser/geolocation/location_arbitrator.h',
    'browser/geolocation/location_arbitrator_impl.cc',
    'browser/geolocation/location_arbitrator_impl.h',
    'browser/geolocation/location_provider_android.cc',
    'browser/geolocation/location_provider_android.h',
    'browser/geolocation/location_provider_base.cc',
    'browser/geolocation/location_provider_base.h',
    'browser/geolocation/network_location_provider.cc',
    'browser/geolocation/network_location_provider.h',
    'browser/geolocation/network_location_request.cc',
    'browser/geolocation/network_location_request.h',
    'browser/geolocation/osx_wifi.h',
    'browser/geolocation/wifi_data_provider_chromeos.cc',
    'browser/geolocation/wifi_data_provider_chromeos.h',
    'browser/geolocation/wifi_data_provider_common.cc',
    'browser/geolocation/wifi_data_provider_common.h',
    'browser/geolocation/wifi_data_provider_common_win.cc',
    'browser/geolocation/wifi_data_provider_common_win.h',
    'browser/geolocation/wifi_data_provider_corewlan_mac.mm',
    'browser/geolocation/wifi_data_provider_linux.cc',
    'browser/geolocation/wifi_data_provider_linux.h',
    'browser/geolocation/wifi_data_provider_mac.cc',
    'browser/geolocation/wifi_data_provider_mac.h',
    'browser/geolocation/wifi_data_provider_win.cc',
    'browser/geolocation/wifi_data_provider_win.h',
    'browser/gpu/browser_gpu_channel_host_factory.cc',
    'browser/gpu/browser_gpu_channel_host_factory.h',
    'browser/gpu/compositor_util.cc',
    'browser/gpu/gpu_data_manager_impl.cc',
    'browser/gpu/gpu_data_manager_impl.h',
    'browser/gpu/gpu_data_manager_impl_private.cc',
    'browser/gpu/gpu_data_manager_impl_private.h',
    'browser/gpu/gpu_internals_ui.cc',
    'browser/gpu/gpu_internals_ui.h',
    'browser/gpu/gpu_process_host.cc',
    'browser/gpu/gpu_process_host.h',
    'browser/gpu/gpu_process_host_ui_shim.cc',
    'browser/gpu/gpu_process_host_ui_shim.h',
    'browser/gpu/gpu_surface_tracker.cc',
    'browser/gpu/gpu_surface_tracker.h',
    'browser/gpu/shader_disk_cache.cc',
    'browser/gpu/shader_disk_cache.h',
    'browser/histogram_controller.cc',
    'browser/histogram_controller.h',
    'browser/histogram_internals_request_job.cc',
    'browser/histogram_internals_request_job.h',
    'browser/histogram_message_filter.cc',
    'browser/histogram_message_filter.h',
    'browser/histogram_subscriber.h',
    'browser/histogram_synchronizer.cc',
    'browser/histogram_synchronizer.h',
    'browser/host_zoom_map_impl.cc',
    'browser/host_zoom_map_impl.h',
    'browser/indexed_db/indexed_db.h',
    'browser/indexed_db/indexed_db_backing_store.cc',
    'browser/indexed_db/indexed_db_backing_store.h',
    'browser/indexed_db/indexed_db_callbacks.cc',
    'browser/indexed_db/indexed_db_callbacks.h',
    'browser/indexed_db/indexed_db_connection.cc',
    'browser/indexed_db/indexed_db_connection.h',
    'browser/indexed_db/indexed_db_context_impl.cc',
    'browser/indexed_db/indexed_db_context_impl.h',
    'browser/indexed_db/indexed_db_cursor.cc',
    'browser/indexed_db/indexed_db_cursor.h',
    'browser/indexed_db/indexed_db_database.cc',
    'browser/indexed_db/indexed_db_database.h',
    'browser/indexed_db/indexed_db_database_callbacks.cc',
    'browser/indexed_db/indexed_db_database_callbacks.h',
    'browser/indexed_db/indexed_db_database_error.h',
    'browser/indexed_db/indexed_db_dispatcher_host.cc',
    'browser/indexed_db/indexed_db_dispatcher_host.h',
    'browser/indexed_db/indexed_db_factory.cc',
    'browser/indexed_db/indexed_db_factory.h',
    'browser/indexed_db/indexed_db_index_writer.cc',
    'browser/indexed_db/indexed_db_index_writer.h',
    'browser/indexed_db/indexed_db_internals_ui.cc',
    'browser/indexed_db/indexed_db_internals_ui.h',
    'browser/indexed_db/indexed_db_leveldb_coding.cc',
    'browser/indexed_db/indexed_db_leveldb_coding.h',
    'browser/indexed_db/indexed_db_metadata.cc',
    'browser/indexed_db/indexed_db_metadata.h',
    'browser/indexed_db/indexed_db_quota_client.cc',
    'browser/indexed_db/indexed_db_quota_client.h',
    'browser/indexed_db/indexed_db_transaction.cc',
    'browser/indexed_db/indexed_db_transaction.h',
    'browser/indexed_db/indexed_db_transaction_coordinator.cc',
    'browser/indexed_db/indexed_db_transaction_coordinator.h',
    'browser/indexed_db/leveldb/avltree.h',
    'browser/indexed_db/leveldb/fixed_array.h',
    'browser/indexed_db/leveldb/leveldb_comparator.h',
    'browser/indexed_db/leveldb/leveldb_database.cc',
    'browser/indexed_db/leveldb/leveldb_database.h',
    'browser/indexed_db/leveldb/leveldb_iterator.h',
    'browser/indexed_db/leveldb/leveldb_transaction.cc',
    'browser/indexed_db/leveldb/leveldb_transaction.h',
    'browser/indexed_db/leveldb/leveldb_write_batch.cc',
    'browser/indexed_db/leveldb/leveldb_write_batch.h',
    'browser/loader/async_resource_handler.cc',
    'browser/loader/async_resource_handler.h',
    'browser/loader/buffered_resource_handler.cc',
    'browser/loader/buffered_resource_handler.h',
    'browser/loader/certificate_resource_handler.cc',
    'browser/loader/certificate_resource_handler.h',
    'browser/loader/cross_site_resource_handler.cc',
    'browser/loader/cross_site_resource_handler.h',
    'browser/loader/doomed_resource_handler.cc',
    'browser/loader/doomed_resource_handler.h',
    'browser/loader/global_routing_id.h',
    'browser/loader/layered_resource_handler.cc',
    'browser/loader/layered_resource_handler.h',
    'browser/loader/offline_policy.cc',
    'browser/loader/offline_policy.h',
    'browser/loader/power_save_block_resource_throttle.cc',
    'browser/loader/power_save_block_resource_throttle.h',
    'browser/loader/redirect_to_file_resource_handler.cc',
    'browser/loader/redirect_to_file_resource_handler.h',
    'browser/loader/render_view_host_tracker.cc',
    'browser/loader/render_view_host_tracker.h',
    'browser/loader/resource_buffer.cc',
    'browser/loader/resource_buffer.h',
    'browser/loader/resource_dispatcher_host_impl.cc',
    'browser/loader/resource_dispatcher_host_impl.h',
    'browser/loader/resource_handler.cc',
    'browser/loader/resource_handler.h',
    'browser/loader/resource_loader.cc',
    'browser/loader/resource_loader.h',
    'browser/loader/resource_loader_delegate.h',
    'browser/loader/resource_message_delegate.cc',
    'browser/loader/resource_message_delegate.h',
    'browser/loader/resource_message_filter.cc',
    'browser/loader/resource_message_filter.h',
    'browser/loader/resource_request_info_impl.cc',
    'browser/loader/resource_request_info_impl.h',
    'browser/loader/resource_scheduler.cc',
    'browser/loader/resource_scheduler.h',
    'browser/loader/resource_scheduler_filter.cc',
    'browser/loader/resource_scheduler_filter.h',
    'browser/loader/stream_resource_handler.cc',
    'browser/loader/stream_resource_handler.h',
    'browser/loader/sync_resource_handler.cc',
    'browser/loader/sync_resource_handler.h',
    'browser/loader/throttling_resource_handler.cc',
    'browser/loader/throttling_resource_handler.h',
    'browser/loader/transfer_navigation_resource_throttle.cc',
    'browser/loader/transfer_navigation_resource_throttle.h',
    'browser/loader/upload_data_stream_builder.cc',
    'browser/loader/upload_data_stream_builder.h',
    'browser/mach_broker_mac.h',
    'browser/mach_broker_mac.mm',
    'browser/media/media_internals.cc',
    'browser/media/media_internals.h',
    'browser/media/media_internals_handler.cc',
    'browser/media/media_internals_handler.h',
    'browser/media/media_internals_proxy.cc',
    'browser/media/media_internals_proxy.h',
    'browser/media/media_internals_ui.cc',
    'browser/media/media_internals_ui.h',
    'browser/media/webrtc_identity_store.cc',
    'browser/media/webrtc_identity_store.h',
    'browser/media/webrtc_identity_store_backend.cc',
    'browser/media/webrtc_identity_store_backend.h',
    'browser/media/webrtc_internals.cc',
    'browser/media/webrtc_internals.h',
    'browser/media/webrtc_internals_message_handler.cc',
    'browser/media/webrtc_internals_message_handler.h',
    'browser/media/webrtc_internals_ui.cc',
    'browser/media/webrtc_internals_ui.h',
    'browser/media/webrtc_internals_ui_observer.h',
    'browser/media_devices_monitor.cc',
    'browser/mime_registry_message_filter.cc',
    'browser/mime_registry_message_filter.h',
    'browser/net/browser_online_state_observer.cc',
    'browser/net/browser_online_state_observer.h',
    'browser/net/sqlite_persistent_cookie_store.cc',
    'browser/net/sqlite_persistent_cookie_store.h',
    'browser/net/view_blob_internals_job_factory.cc',
    'browser/net/view_blob_internals_job_factory.h',
    'browser/net/view_http_cache_job_factory.cc',
    'browser/net/view_http_cache_job_factory.h',
    'browser/notification_service_impl.cc',
    'browser/notification_service_impl.h',
    'browser/pepper_flash_settings_helper_impl.cc',
    'browser/pepper_flash_settings_helper_impl.h',
    'browser/plugin_data_remover_impl.cc',
    'browser/plugin_data_remover_impl.h',
    'browser/plugin_loader_posix.cc',
    'browser/plugin_loader_posix.h',
    'browser/plugin_process_host.cc',
    'browser/plugin_process_host.h',
    'browser/plugin_process_host_mac.cc',
    'browser/plugin_service_impl.cc',
    'browser/plugin_service_impl.h',
    'browser/power_monitor_message_broadcaster.cc',
    'browser/power_monitor_message_broadcaster.h',
    'browser/power_save_blocker_android.cc',
    'browser/power_save_blocker_android.h',
    'browser/power_save_blocker_chromeos.cc',
    'browser/power_save_blocker_impl.cc',
    'browser/power_save_blocker_impl.h',
    'browser/power_save_blocker_mac.cc',
    'browser/power_save_blocker_ozone.cc',
    'browser/power_save_blocker_win.cc',
    'browser/power_save_blocker_x11.cc',
    'browser/ppapi_plugin_process_host.cc',
    'browser/ppapi_plugin_process_host.h',
    'browser/profiler_controller_impl.cc',
    'browser/profiler_controller_impl.h',
    'browser/profiler_message_filter.cc',
    'browser/profiler_message_filter.h',
    'browser/quota_dispatcher_host.cc',
    'browser/quota_dispatcher_host.h',
    'browser/renderer_host/backing_store.cc',
    'browser/renderer_host/backing_store.h',
    'browser/renderer_host/backing_store_aura.cc',
    'browser/renderer_host/backing_store_aura.h',
    'browser/renderer_host/backing_store_gtk.cc',
    'browser/renderer_host/backing_store_gtk.h',
    'browser/renderer_host/backing_store_mac.h',
    'browser/renderer_host/backing_store_mac.mm',
    'browser/renderer_host/backing_store_manager.cc',
    'browser/renderer_host/backing_store_manager.h',
    'browser/renderer_host/backing_store_win.cc',
    'browser/renderer_host/backing_store_win.h',
    'browser/renderer_host/basic_mouse_wheel_smooth_scroll_gesture.cc',
    'browser/renderer_host/basic_mouse_wheel_smooth_scroll_gesture.h',
    'browser/renderer_host/clipboard_message_filter.cc',
    'browser/renderer_host/clipboard_message_filter.h',
    'browser/renderer_host/clipboard_message_filter_mac.mm',
    'browser/renderer_host/compositing_iosurface_context_mac.h',
    'browser/renderer_host/compositing_iosurface_context_mac.mm',
    'browser/renderer_host/compositing_iosurface_layer_mac.h',
    'browser/renderer_host/compositing_iosurface_layer_mac.mm',
    'browser/renderer_host/compositing_iosurface_mac.h',
    'browser/renderer_host/compositing_iosurface_mac.mm',
    'browser/renderer_host/compositing_iosurface_shader_programs_mac.cc',
    'browser/renderer_host/compositing_iosurface_shader_programs_mac.h',
    'browser/renderer_host/compositing_iosurface_transformer_mac.cc',
    'browser/renderer_host/compositing_iosurface_transformer_mac.h',
    'browser/renderer_host/compositor_impl_android.cc',
    'browser/renderer_host/compositor_impl_android.h',
    'browser/renderer_host/database_message_filter.cc',
    'browser/renderer_host/database_message_filter.h',
    'browser/renderer_host/dip_util.cc',
    'browser/renderer_host/dip_util.h',
    'browser/renderer_host/file_utilities_message_filter.cc',
    'browser/renderer_host/file_utilities_message_filter.h',
    'browser/renderer_host/gamepad_browser_message_filter.cc',
    'browser/renderer_host/gamepad_browser_message_filter.h',
    'browser/renderer_host/gpu_message_filter.cc',
    'browser/renderer_host/gpu_message_filter.h',
    'browser/renderer_host/gtk_im_context_wrapper.cc',
    'browser/renderer_host/gtk_im_context_wrapper.h',
    'browser/renderer_host/gtk_key_bindings_handler.cc',
    'browser/renderer_host/gtk_key_bindings_handler.h',
    'browser/renderer_host/gtk_plugin_container.cc',
    'browser/renderer_host/gtk_plugin_container.h',
    'browser/renderer_host/gtk_plugin_container_manager.cc',
    'browser/renderer_host/gtk_plugin_container_manager.h',
    'browser/renderer_host/gtk_window_utils.cc',
    'browser/renderer_host/gtk_window_utils.h',
    'browser/renderer_host/image_transport_factory_android.cc',
    'browser/renderer_host/image_transport_factory_android.h',
    'browser/renderer_host/ime_adapter_android.cc',
    'browser/renderer_host/ime_adapter_android.h',
    'browser/renderer_host/input/gesture_event_filter.cc',
    'browser/renderer_host/input/gesture_event_filter.h',
    'browser/renderer_host/input/immediate_input_router.cc',
    'browser/renderer_host/input/immediate_input_router.h',
    'browser/renderer_host/input/input_router.h',
    'browser/renderer_host/input/input_router_client.h',
    'browser/renderer_host/input/tap_suppression_controller.cc',
    'browser/renderer_host/input/tap_suppression_controller.h',
    'browser/renderer_host/input/tap_suppression_controller_client.h',
    'browser/renderer_host/input/touch_event_queue.cc',
    'browser/renderer_host/input/touch_event_queue.h',
    'browser/renderer_host/input/touchpad_tap_suppression_controller_aura.cc',
    'browser/renderer_host/input/touchpad_tap_suppression_controller.cc',
    'browser/renderer_host/input/touchpad_tap_suppression_controller.h',
    'browser/renderer_host/input/touchscreen_tap_suppression_controller.cc',
    'browser/renderer_host/input/touchscreen_tap_suppression_controller.h',
    'browser/renderer_host/input/touchscreen_tap_suppression_controller_stub.cc',
    'browser/renderer_host/input/web_input_event_builders_android.cc',
    'browser/renderer_host/input/web_input_event_builders_android.h',
    'browser/renderer_host/input/web_input_event_builders_win.cc',
    'browser/renderer_host/input/web_input_event_builders_win.h',
    'browser/renderer_host/input/web_input_event_util.cc',
    'browser/renderer_host/input/web_input_event_util.h',
    'browser/renderer_host/input/web_input_event_util_posix.cc',
    'browser/renderer_host/input/web_input_event_util_posix.h',
    'browser/renderer_host/java/java_bound_object.cc',
    'browser/renderer_host/java/java_bound_object.h',
    'browser/renderer_host/java/java_bridge_channel_host.cc',
    'browser/renderer_host/java/java_bridge_channel_host.h',
    'browser/renderer_host/java/java_bridge_dispatcher_host.cc',
    'browser/renderer_host/java/java_bridge_dispatcher_host.h',
    'browser/renderer_host/java/java_bridge_dispatcher_host_manager.cc',
    'browser/renderer_host/java/java_bridge_dispatcher_host_manager.h',
    'browser/renderer_host/java/java_method.cc',
    'browser/renderer_host/java/java_method.h',
    'browser/renderer_host/java/java_type.cc',
    'browser/renderer_host/java/java_type.h',
    'browser/renderer_host/media/audio_input_device_manager.cc',
    'browser/renderer_host/media/audio_input_device_manager.h',
    'browser/renderer_host/media/audio_input_renderer_host.cc',
    'browser/renderer_host/media/audio_input_renderer_host.h',
    'browser/renderer_host/media/audio_input_sync_writer.cc',
    'browser/renderer_host/media/audio_input_sync_writer.h',
    'browser/renderer_host/media/audio_mirroring_manager.cc',
    'browser/renderer_host/media/audio_mirroring_manager.h',
    'browser/renderer_host/media/audio_renderer_host.cc',
    'browser/renderer_host/media/audio_renderer_host.h',
    'browser/renderer_host/media/audio_sync_reader.cc',
    'browser/renderer_host/media/audio_sync_reader.h',
    'browser/renderer_host/media/device_request_message_filter.cc',
    'browser/renderer_host/media/device_request_message_filter.h',
    'browser/renderer_host/media/media_stream_dispatcher_host.cc',
    'browser/renderer_host/media/media_stream_dispatcher_host.h',
    'browser/renderer_host/media/media_stream_manager.cc',
    'browser/renderer_host/media/media_stream_manager.h',
    'browser/renderer_host/media/media_stream_provider.h',
    'browser/renderer_host/media/media_stream_requester.h',
    'browser/renderer_host/media/media_stream_ui_proxy.cc',
    'browser/renderer_host/media/media_stream_ui_proxy.h',
    'browser/renderer_host/media/midi_dispatcher_host.cc',
    'browser/renderer_host/media/midi_dispatcher_host.h',
    'browser/renderer_host/media/midi_host.cc',
    'browser/renderer_host/media/midi_host.h',
    'browser/renderer_host/media/video_capture_buffer_pool.cc',
    'browser/renderer_host/media/video_capture_buffer_pool.h',
    'browser/renderer_host/media/video_capture_controller.cc',
    'browser/renderer_host/media/video_capture_controller.h',
    'browser/renderer_host/media/video_capture_controller_event_handler.cc',
    'browser/renderer_host/media/video_capture_controller_event_handler.h',
    'browser/renderer_host/media/video_capture_host.cc',
    'browser/renderer_host/media/video_capture_host.h',
    'browser/renderer_host/media/video_capture_manager.cc',
    'browser/renderer_host/media/video_capture_manager.h',
    'browser/renderer_host/media/video_capture_oracle.cc',
    'browser/renderer_host/media/video_capture_oracle.h',
    'browser/renderer_host/media/web_contents_audio_input_stream.cc',
    'browser/renderer_host/media/web_contents_audio_input_stream.h',
    'browser/renderer_host/media/web_contents_capture_util.cc',
    'browser/renderer_host/media/web_contents_capture_util.h',
    'browser/renderer_host/media/web_contents_tracker.cc',
    'browser/renderer_host/media/web_contents_tracker.h',
    'browser/renderer_host/media/web_contents_video_capture_device.cc',
    'browser/renderer_host/media/web_contents_video_capture_device.h',
    'browser/renderer_host/memory_benchmark_message_filter.cc',
    'browser/renderer_host/memory_benchmark_message_filter.h',
    'browser/renderer_host/native_web_keyboard_event.cc',
    'browser/renderer_host/native_web_keyboard_event_android.cc',
    'browser/renderer_host/native_web_keyboard_event_aura.cc',
    'browser/renderer_host/native_web_keyboard_event_gtk.cc',
    'browser/renderer_host/native_web_keyboard_event_mac.mm',
    'browser/renderer_host/native_web_keyboard_event_win.cc',
    'browser/renderer_host/overscroll_configuration.cc',
    'browser/renderer_host/overscroll_controller.cc',
    'browser/renderer_host/overscroll_controller.h',
    'browser/renderer_host/overscroll_controller_delegate.h',
    'browser/renderer_host/pepper/browser_ppapi_host_impl.cc',
    'browser/renderer_host/pepper/browser_ppapi_host_impl.h',
    'browser/renderer_host/pepper/content_browser_pepper_host_factory.cc',
    'browser/renderer_host/pepper/content_browser_pepper_host_factory.h',
    'browser/renderer_host/pepper/pepper_browser_font_singleton_host.cc',
    'browser/renderer_host/pepper/pepper_browser_font_singleton_host.h',
    'browser/renderer_host/pepper/pepper_external_file_ref_backend.cc',
    'browser/renderer_host/pepper/pepper_external_file_ref_backend.h',
    'browser/renderer_host/pepper/pepper_file_ref_host.cc',
    'browser/renderer_host/pepper/pepper_file_ref_host.h',
    'browser/renderer_host/pepper/pepper_file_system_browser_host.cc',
    'browser/renderer_host/pepper/pepper_file_system_browser_host.h',
    'browser/renderer_host/pepper/pepper_flash_file_message_filter.cc',
    'browser/renderer_host/pepper/pepper_flash_file_message_filter.h',
    'browser/renderer_host/pepper/pepper_gamepad_host.cc',
    'browser/renderer_host/pepper/pepper_gamepad_host.h',
    'browser/renderer_host/pepper/pepper_host_resolver_message_filter.cc',
    'browser/renderer_host/pepper/pepper_host_resolver_message_filter.h',
    'browser/renderer_host/pepper/pepper_internal_file_ref_backend.cc',
    'browser/renderer_host/pepper/pepper_internal_file_ref_backend.h',
    'browser/renderer_host/pepper/pepper_lookup_request.h',
    'browser/renderer_host/pepper/pepper_message_filter.cc',
    'browser/renderer_host/pepper/pepper_message_filter.h',
    'browser/renderer_host/pepper/pepper_network_proxy_host.cc',
    'browser/renderer_host/pepper/pepper_network_proxy_host.h',
    'browser/renderer_host/pepper/pepper_print_settings_manager.cc',
    'browser/renderer_host/pepper/pepper_print_settings_manager.h',
    'browser/renderer_host/pepper/pepper_printing_host.cc',
    'browser/renderer_host/pepper/pepper_printing_host.h',
    'browser/renderer_host/pepper/pepper_renderer_connection.cc',
    'browser/renderer_host/pepper/pepper_renderer_connection.h',
    'browser/renderer_host/pepper/pepper_security_helper.cc',
    'browser/renderer_host/pepper/pepper_security_helper.h',
    'browser/renderer_host/pepper/pepper_socket_utils.cc',
    'browser/renderer_host/pepper/pepper_socket_utils.h',
    'browser/renderer_host/pepper/pepper_tcp_server_socket_message_filter.cc',
    'browser/renderer_host/pepper/pepper_tcp_server_socket_message_filter.h',
    'browser/renderer_host/pepper/pepper_tcp_socket.cc',
    'browser/renderer_host/pepper/pepper_tcp_socket.h',
    'browser/renderer_host/pepper/pepper_truetype_font_list.h',
    'browser/renderer_host/pepper/pepper_truetype_font_list_android.cc',
    'browser/renderer_host/pepper/pepper_truetype_font_list_host.cc',
    'browser/renderer_host/pepper/pepper_truetype_font_list_host.h',
    'browser/renderer_host/pepper/pepper_truetype_font_list_linux.cc',
    'browser/renderer_host/pepper/pepper_truetype_font_list_mac.mm',
    'browser/renderer_host/pepper/pepper_truetype_font_list_win.cc',
    'browser/renderer_host/pepper/pepper_udp_socket_message_filter.cc',
    'browser/renderer_host/pepper/pepper_udp_socket_message_filter.h',
    'browser/renderer_host/popup_menu_helper_mac.h',
    'browser/renderer_host/popup_menu_helper_mac.mm',
    'browser/renderer_host/render_frame_host_impl.cc',
    'browser/renderer_host/render_frame_host_impl.h',
    'browser/renderer_host/render_message_filter.cc',
    'browser/renderer_host/render_message_filter.h',
    'browser/renderer_host/render_process_host_impl.cc',
    'browser/renderer_host/render_process_host_impl.h',
    'browser/renderer_host/render_sandbox_host_linux.cc',
    'browser/renderer_host/render_sandbox_host_linux.h',
    'browser/renderer_host/render_view_host_delegate.cc',
    'browser/renderer_host/render_view_host_delegate.h',
    'browser/renderer_host/render_view_host_factory.cc',
    'browser/renderer_host/render_view_host_factory.h',
    'browser/renderer_host/render_view_host_impl.cc',
    'browser/renderer_host/render_view_host_impl.h',
    'browser/renderer_host/render_widget_helper.cc',
    'browser/renderer_host/render_widget_helper.h',
    'browser/renderer_host/render_widget_host_delegate.cc',
    'browser/renderer_host/render_widget_host_delegate.h',
    'browser/renderer_host/render_widget_host_impl.cc',
    'browser/renderer_host/render_widget_host_impl.h',
    'browser/renderer_host/render_widget_host_view_android.cc',
    'browser/renderer_host/render_widget_host_view_android.h',
    'browser/renderer_host/render_widget_host_view_aura.cc',
    'browser/renderer_host/render_widget_host_view_aura.h',
    'browser/renderer_host/render_widget_host_view_base.cc',
    'browser/renderer_host/render_widget_host_view_base.h',
    'browser/renderer_host/render_widget_host_view_gtk.cc',
    'browser/renderer_host/render_widget_host_view_gtk.h',
    'browser/renderer_host/render_widget_host_view_guest.cc',
    'browser/renderer_host/render_widget_host_view_guest.h',
    'browser/renderer_host/render_widget_host_view_mac_dictionary_helper.h',
    'browser/renderer_host/render_widget_host_view_mac_dictionary_helper.mm',
    'browser/renderer_host/render_widget_host_view_mac_editcommand_helper.h',
    'browser/renderer_host/render_widget_host_view_mac_editcommand_helper.mm',
    'browser/renderer_host/render_widget_host_view_mac.h',
    'browser/renderer_host/render_widget_host_view_mac.mm',
    'browser/renderer_host/render_widget_host_view_win.cc',
    'browser/renderer_host/render_widget_host_view_win.h',
    'browser/renderer_host/smooth_scroll_calculator.cc',
    'browser/renderer_host/smooth_scroll_calculator.h',
    'browser/renderer_host/smooth_scroll_gesture_controller.cc',
    'browser/renderer_host/smooth_scroll_gesture_controller.h',
    'browser/renderer_host/socket_stream_dispatcher_host.cc',
    'browser/renderer_host/socket_stream_dispatcher_host.h',
    'browser/renderer_host/socket_stream_host.cc',
    'browser/renderer_host/socket_stream_host.h',
    'browser/renderer_host/surface_texture_transport_client_android.cc',
    'browser/renderer_host/surface_texture_transport_client_android.h',
    'browser/renderer_host/text_input_client_mac.h',
    'browser/renderer_host/text_input_client_mac.mm',
    'browser/renderer_host/text_input_client_message_filter.h',
    'browser/renderer_host/text_input_client_message_filter.mm',
    'browser/renderer_host/touch_smooth_scroll_gesture_android.cc',
    'browser/renderer_host/touch_smooth_scroll_gesture_android.h',
    'browser/renderer_host/touch_smooth_scroll_gesture_aura.cc',
    'browser/renderer_host/touch_smooth_scroll_gesture_aura.h',
    'browser/renderer_host/ui_events_helper.cc',
    'browser/renderer_host/ui_events_helper.h',
    'browser/renderer_host/web_input_event_aura.cc',
    'browser/renderer_host/web_input_event_aura.h',
    'browser/renderer_host/web_input_event_aurawin.cc',
    'browser/renderer_host/web_input_event_aurax11.cc',
    'browser/renderer_host/webmenurunner_mac.h',
    'browser/renderer_host/webmenurunner_mac.mm',
    'browser/resolve_proxy_msg_helper.cc',
    'browser/resolve_proxy_msg_helper.h',
    'browser/resource_context_impl.cc',
    'browser/resource_context_impl.h',
    'browser/safe_util_win.cc',
    'browser/safe_util_win.h',
    'browser/site_instance_impl.cc',
    'browser/site_instance_impl.h',
    'browser/speech/audio_buffer.cc',
    'browser/speech/audio_buffer.h',
    'browser/speech/audio_encoder.cc',
    'browser/speech/audio_encoder.h',
    'browser/speech/chunked_byte_buffer.cc',
    'browser/speech/chunked_byte_buffer.h',
    'browser/speech/endpointer/endpointer.cc',
    'browser/speech/endpointer/endpointer.h',
    'browser/speech/endpointer/energy_endpointer.cc',
    'browser/speech/endpointer/energy_endpointer.h',
    'browser/speech/endpointer/energy_endpointer_params.cc',
    'browser/speech/endpointer/energy_endpointer_params.h',
    'browser/speech/google_one_shot_remote_engine.cc',
    'browser/speech/google_one_shot_remote_engine.h',
    'browser/speech/google_streaming_remote_engine.cc',
    'browser/speech/google_streaming_remote_engine.h',
    'browser/speech/input_tag_speech_dispatcher_host.cc',
    'browser/speech/input_tag_speech_dispatcher_host.h',
    'browser/speech/speech_recognition_dispatcher_host.cc',
    'browser/speech/speech_recognition_dispatcher_host.h',
    'browser/speech/speech_recognition_engine.cc',
    'browser/speech/speech_recognition_engine.h',
    'browser/speech/speech_recognition_manager_impl.cc',
    'browser/speech/speech_recognition_manager_impl.h',
    'browser/speech/speech_recognizer.h',
    'browser/speech/speech_recognizer_impl.cc',
    'browser/speech/speech_recognizer_impl.h',
    'browser/speech/speech_recognizer_impl_android.cc',
    'browser/speech/speech_recognizer_impl_android.h',
    'browser/ssl/ssl_cert_error_handler.cc',
    'browser/ssl/ssl_cert_error_handler.h',
    'browser/ssl/ssl_client_auth_handler.cc',
    'browser/ssl/ssl_client_auth_handler.h',
    'browser/ssl/ssl_error_handler.cc',
    'browser/ssl/ssl_error_handler.h',
    'browser/ssl/ssl_host_state.cc',
    'browser/ssl/ssl_host_state.h',
    'browser/ssl/ssl_manager.cc',
    'browser/ssl/ssl_manager.h',
    'browser/ssl/ssl_policy_backend.cc',
    'browser/ssl/ssl_policy_backend.h',
    'browser/ssl/ssl_policy.cc',
    'browser/ssl/ssl_policy.h',
    'browser/ssl/ssl_request_info.cc',
    'browser/ssl/ssl_request_info.h',
    'browser/startup_task_runner.cc',
    'browser/startup_task_runner.h',
    'browser/streams/stream.cc',
    'browser/streams/stream.h',
    'browser/streams/stream_context.cc',
    'browser/streams/stream_handle_impl.cc',
    'browser/streams/stream_handle_impl.h',
    'browser/streams/stream_context.h',
    'browser/streams/stream_read_observer.h',
    'browser/streams/stream_registry.cc',
    'browser/streams/stream_registry.h',
    'browser/streams/stream_url_request_job.cc',
    'browser/streams/stream_url_request_job.h',
    'browser/streams/stream_write_observer.h',
    'browser/storage_partition_impl.cc',
    'browser/storage_partition_impl.h',
    'browser/storage_partition_impl_map.cc',
    'browser/storage_partition_impl_map.h',
    'browser/system_message_window_win.cc',
    'browser/system_message_window_win.h',
    'browser/tcmalloc_internals_request_job.cc',
    'browser/tcmalloc_internals_request_job.h',
    'browser/tracing/trace_controller_impl.cc',
    'browser/tracing/trace_controller_impl.h',
    'browser/tracing/trace_message_filter.cc',
    'browser/tracing/trace_message_filter.h',
    'browser/tracing/trace_subscriber_stdio.cc',
    'browser/tracing/trace_subscriber_stdio.h',
    'browser/tracing/tracing_ui.cc',
    'browser/tracing/tracing_ui.h',
    'browser/udev_linux.cc',
    'browser/udev_linux.h',
    'browser/user_metrics.cc',
    'browser/utility_process_host_impl.cc',
    'browser/utility_process_host_impl.h',
    'browser/web_contents/aura/image_window_delegate.cc',
    'browser/web_contents/aura/image_window_delegate.h',
    'browser/web_contents/aura/shadow_layer_delegate.cc',
    'browser/web_contents/aura/shadow_layer_delegate.h',
    'browser/web_contents/aura/window_slider.cc',
    'browser/web_contents/aura/window_slider.h',
    'browser/web_contents/debug_urls.cc',
    'browser/web_contents/debug_urls.h',
    'browser/web_contents/drag_utils_gtk.cc',
    'browser/web_contents/drag_utils_gtk.h',
    'browser/web_contents/frame_tree_node.cc',
    'browser/web_contents/frame_tree_node.h',
    'browser/web_contents/interstitial_page_impl.cc',
    'browser/web_contents/interstitial_page_impl.h',
    'browser/web_contents/navigation_controller_impl.cc',
    'browser/web_contents/navigation_controller_impl.h',
    'browser/web_contents/navigation_entry_impl.cc',
    'browser/web_contents/navigation_entry_impl.h',
    'browser/web_contents/render_view_host_manager.cc',
    'browser/web_contents/render_view_host_manager.h',
    'browser/web_contents/touch_editable_impl_aura.cc',
    'browser/web_contents/touch_editable_impl_aura.h',
    'browser/web_contents/web_contents_drag_win.cc',
    'browser/web_contents/web_contents_drag_win.h',
    'browser/web_contents/web_contents_impl.cc',
    'browser/web_contents/web_contents_impl.h',
    'browser/web_contents/web_contents_screenshot_manager.cc',
    'browser/web_contents/web_contents_screenshot_manager.h',
    'browser/web_contents/web_contents_view_android.cc',
    'browser/web_contents/web_contents_view_android.h',
    'browser/web_contents/web_contents_view_aura.cc',
    'browser/web_contents/web_contents_view_aura.h',
    'browser/web_contents/web_contents_view_gtk.cc',
    'browser/web_contents/web_contents_view_gtk.h',
    'browser/web_contents/web_contents_view_guest.cc',
    'browser/web_contents/web_contents_view_guest.h',
    'browser/web_contents/web_contents_view_mac.h',
    'browser/web_contents/web_contents_view_mac.mm',
    'browser/web_contents/web_contents_view_win.cc',
    'browser/web_contents/web_contents_view_win.h',
    'browser/web_contents/web_drag_dest_gtk.cc',
    'browser/web_contents/web_drag_dest_gtk.h',
    'browser/web_contents/web_drag_dest_mac.h',
    'browser/web_contents/web_drag_dest_mac.mm',
    'browser/web_contents/web_drag_dest_win.cc',
    'browser/web_contents/web_drag_dest_win.h',
    'browser/web_contents/web_drag_source_gtk.cc',
    'browser/web_contents/web_drag_source_gtk.h',
    'browser/web_contents/web_drag_source_mac.h',
    'browser/web_contents/web_drag_source_mac.mm',
    'browser/web_contents/web_drag_source_win.cc',
    'browser/web_contents/web_drag_source_win.h',
    'browser/web_contents/web_drag_utils_win.cc',
    'browser/web_contents/web_drag_utils_win.h',
    'browser/webui/content_web_ui_controller_factory.cc',
    'browser/webui/content_web_ui_controller_factory.h',
    'browser/webui/generic_handler.cc',
    'browser/webui/generic_handler.h',
    'browser/webui/shared_resources_data_source.cc',
    'browser/webui/shared_resources_data_source.h',
    'browser/webui/url_data_manager.cc',
    'browser/webui/url_data_manager.h',
    'browser/webui/url_data_manager_backend.cc',
    'browser/webui/url_data_manager_backend.h',
    'browser/webui/url_data_source_impl.cc',
    'browser/webui/url_data_source_impl.h',
    'browser/webui/web_ui_data_source_impl.cc',
    'browser/webui/web_ui_data_source_impl.h',
    'browser/webui/web_ui_controller_factory_registry.cc',
    'browser/webui/web_ui_controller_factory_registry.h',
    'browser/webui/web_ui_impl.cc',
    'browser/webui/web_ui_impl.h',
    'browser/webui/web_ui_message_handler.cc',
    'browser/worker_host/message_port_service.cc',
    'browser/worker_host/message_port_service.h',
    'browser/worker_host/worker_document_set.cc',
    'browser/worker_host/worker_document_set.h',
    'browser/worker_host/worker_message_filter.cc',
    'browser/worker_host/worker_message_filter.h',
    'browser/worker_host/worker_process_host.cc',
    'browser/worker_host/worker_process_host.h',
    'browser/worker_host/worker_service_impl.cc',
    'browser/worker_host/worker_service_impl.h',
    'browser/worker_host/worker_storage_partition.cc',
    'browser/worker_host/worker_storage_partition.h',
    'browser/zygote_host/zygote_host_impl_linux.cc',
    'browser/zygote_host/zygote_host_impl_linux.h',
    'zygote/zygote_linux.cc',
    'zygote/zygote_linux.h',
    'zygote/zygote_main_linux.cc',
    # These files are generated by GRIT.
    '<(SHARED_INTERMEDIATE_DIR)/webkit/grit/devtools_resources.h',
    '<(SHARED_INTERMEDIATE_DIR)/webkit/grit/devtools_resources_map.cc',
    '<(SHARED_INTERMEDIATE_DIR)/webkit/grit/devtools_resources_map.h',
    '<(SHARED_INTERMEDIATE_DIR)/content/browser/tracing/grit/tracing_resources.h',
    '<(SHARED_INTERMEDIATE_DIR)/ui/ui_resources/grit/webui_resources_map.cc',
  ],
  'conditions': [
    ['OS!="win" and OS!="mac" and OS!="linux"', {
      'sources': [
        'browser/gamepad/gamepad_platform_data_fetcher.cc',
      ]
    }],
    ['OS=="ios"', {
      'sources/': [
        # iOS only needs a small portion of content; exclude all the
        # implementation, and re-include what is used.
        ['exclude', '\\.(cc|mm)$'],
        ['include', '_ios\\.(cc|mm)$'],
        ['include', '^public/browser/browser_main_parts\\.cc$'],
        ['include', '^public/browser/content_browser_client\\.cc$'],
        ['include', '^public/browser/favicon_status\\.cc$'],
        ['include', '^public/browser/navigation_details\\.cc$'],
        ['include', '^public/browser/notification_registrar\\.cc$'],
        ['include', '^public/browser/page_navigator\\.cc$'],
        ['include', '^public/browser/web_ui_controller\\.cc'],
        ['include', '^browser/browser_context\\.cc$'],
        ['include', '^browser/browser_main_loop\\.cc$'],
        ['include', '^browser/browser_main_runner\\.cc$'],
        ['include', '^browser/browser_process_sub_thread\\.cc$'],
        ['include', '^browser/browser_thread_impl\\.cc$'],
        ['include', '^browser/browser_url_handler_impl\\.cc$'],
        ['include', '^browser/cert_store_impl\\.cc$'],
        ['include', '^browser/download/download_create_info\\.cc$'],
        ['include', '^browser/notification_service_impl\\.cc$'],
        ['include', '^browser/storage_partition_impl\\.cc$'],
        ['include', '^browser/user_metrics\\.cc$'],
        ['include', '^browser/web_contents/navigation_entry_impl\\.cc$'],
      ],
    }, {  # OS!="ios"
      'dependencies': [
        'browser/devtools/devtools_resources.gyp:devtools_resources',
        '../cc/cc.gyp:cc',
        '../net/net.gyp:http_server',
        '../printing/printing.gyp:printing',
        '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
        '../ui/surface/surface.gyp:surface',
        '../webkit/common/webkit_common.gyp:webkit_common',
        '../webkit/storage_browser.gyp:webkit_storage_browser',
        '../webkit/storage_common.gyp:webkit_storage_common',
        '../webkit/webkit_resources.gyp:webkit_resources',
        '../webkit/webkit_resources.gyp:webkit_strings',
      ],
    }],
    ['OS!="ios" and chrome_multiple_dll!=1', {
      'dependencies': [
        '../third_party/WebKit/public/blink.gyp:blink',
      ],
    }],
    ['OS!="mac" and OS!="ios"', {
      'dependencies': [
        '../sandbox/sandbox.gyp:sandbox',
      ],
    }],
    ['OS!="android" and OS!="ios"', {
      'dependencies': [
        'browser/tracing/tracing_resources.gyp:tracing_resources',
        '../third_party/libyuv/libyuv.gyp:libyuv',
      ],
    }],
    ['enable_webrtc==1', {
      'dependencies': [
        '../jingle/jingle.gyp:jingle_glue',
      ],
      'sources': [
        'browser/renderer_host/media/peer_connection_tracker_host.cc',
        'browser/renderer_host/media/peer_connection_tracker_host.h',
        'browser/renderer_host/media/webrtc_identity_service_host.cc',
        'browser/renderer_host/media/webrtc_identity_service_host.h',
        'browser/renderer_host/p2p/socket_host.cc',
        'browser/renderer_host/p2p/socket_host.h',
        'browser/renderer_host/p2p/socket_host_tcp.cc',
        'browser/renderer_host/p2p/socket_host_tcp.h',
        'browser/renderer_host/p2p/socket_host_tcp_server.cc',
        'browser/renderer_host/p2p/socket_host_tcp_server.h',
        'browser/renderer_host/p2p/socket_host_udp.cc',
        'browser/renderer_host/p2p/socket_host_udp.h',
        'browser/renderer_host/p2p/socket_dispatcher_host.cc',
        'browser/renderer_host/p2p/socket_dispatcher_host.h',
      ],
    }],
    ['enable_webrtc==1 and (OS=="linux" or OS=="mac" or OS=="win")', {
      'sources': [
        'browser/renderer_host/media/desktop_capture_device.cc',
        'browser/renderer_host/media/desktop_capture_device.h',
      ],
      'dependencies': [
        '../third_party/webrtc/modules/modules.gyp:desktop_capture',
      ],
      'defines': [
        'ENABLE_SCREEN_CAPTURE=1',
      ],
    }],
    ['OS=="win"', {
      'dependencies': [
        # For accessibility
        '../third_party/iaccessible2/iaccessible2.gyp:iaccessible2',
        '../third_party/isimpledom/isimpledom.gyp:isimpledom',
        '../win8/win8.gyp:win8_util',
      ],
      'defines': [
        # This prevents the inclusion of atlhost.h which paired
        # with the windows 8 sdk it does the wrong thing.
        '__ATLHOST_H__',
      ],
      'link_settings': {
        'libraries': [
          '-lcomctl32.lib',
          '-ldinput8.lib',
          '-ldwmapi.lib',
          '-ldxguid.lib',
          '-lsensorsapi.lib',
          '-lportabledeviceguids.lib',
        ],
        'msvs_settings': {
          'VCLinkerTool': {
            'DelayLoadDLLs': [
              'dinput8.dll',
              'user32.dll',
              'dwmapi.dll',
            ],
          },
        },
      },
    }],
    ['toolkit_uses_gtk == 1', {
      'dependencies': [
        '../build/linux/system.gyp:dbus',
        # For FcLangSetAdd call in render_sandbox_host_linux.cc
        '../build/linux/system.gyp:fontconfig',
        '../build/linux/system.gyp:gtk',
        # For XShm* in backing_store_x.cc
        '../build/linux/system.gyp:x11',
        '../dbus/dbus.gyp:dbus',
      ],
    }],
    ['OS=="linux"', {
      'dependencies': [
        '../build/linux/system.gyp:udev',
        '../sandbox/sandbox.gyp:libc_urandom_override',
      ],
    }],
    ['OS=="linux" and use_aura==1', {
      'dependencies': [
        '../build/linux/system.gyp:dbus',
        '../build/linux/system.gyp:fontconfig',
        '../dbus/dbus.gyp:dbus',
      ],
    }],
    ['use_x11==1', {
      'dependencies': [
        '../build/linux/system.gyp:x11',
      ],
    }],
    ['use_pango==1', {
      'dependencies': [
        '../build/linux/system.gyp:pangocairo',
      ],
    }],
    ['OS=="android"', {
      'dependencies': [
        '../media/media.gyp:media',
        'content.gyp:content_jni_headers',
      ],
      'link_settings': {
        'libraries': [
          '-ljnigraphics',
        ],
      },
      'sources/': [
        ['exclude', '^browser/device_orientation/data_fetcher_shared_memory_default.cc$'],
        ['exclude', '^browser/geolocation/network_location_provider\\.(cc|h)$'],
        ['exclude', '^browser/geolocation/network_location_request\\.(cc|h)$'],
        ['exclude', '^browser/tracing/tracing_ui'],
        ['exclude', '^browser/speech/'],
        ['include', '^browser/speech/speech_recognition_dispatcher_host\\.(cc|h)$'],
        ['include', '^browser/speech/speech_recognition_manager_impl\\.(cc|h)$'],
        ['include', '^browser/speech/speech_recognizer\\.h$'],
        ['include', '^browser/speech/speech_recognizer_impl_android\\.(cc|h)$'],
      ],
    }, {  # OS!="android"
      'sources/': [
        ['exclude', '^browser/renderer_host/java/'],
        ['exclude', '^browser/speech/speech_recognizer_impl_android\\.(cc|h)'],
      ],
    }],
    ['OS=="mac"', {
      'sources': [
        # Build necessary Mozilla sources
        '../third_party/mozilla/ComplexTextInputPanel.h',
        '../third_party/mozilla/ComplexTextInputPanel.mm',
        '../third_party/mozilla/NSPasteboard+Utils.h',
        '../third_party/mozilla/NSPasteboard+Utils.mm',
        '../third_party/mozilla/NSString+Utils.h',
        '../third_party/mozilla/NSString+Utils.mm',
        '../third_party/mozilla/NSURL+Utils.h',
        '../third_party/mozilla/NSURL+Utils.m',
      ],
      'dependencies': [
        '../third_party/sudden_motion_sensor/sudden_motion_sensor.gyp:sudden_motion_sensor',
      ],
      'link_settings': {
        'libraries': [
          '$(SDKROOT)/usr/lib/libbsm.dylib',
        ],
      },
    }],
    ['chromeos==1', {
      'dependencies': [
        '../build/linux/system.gyp:dbus',
      ],
      'sources!': [
        'browser/geolocation/wifi_data_provider_linux.cc',
        'browser/power_save_blocker_ozone.cc',
        'browser/power_save_blocker_x11.cc',
        'browser/renderer_host/gtk_key_bindings_handler.cc',
        'browser/renderer_host/gtk_key_bindings_handler.h',
      ],
    }],
    ['os_bsd==1', {
      'sources/': [
        ['exclude', '^browser/gamepad/gamepad_platform_data_fetcher_linux\\.cc$'],
        ['exclude', '^browser/geolocation/wifi_data_provider_linux\\.cc$'],
      ],
    }],
    ['use_aura!=1 and OS!="win"', {
      'sources!': [
        'browser/renderer_host/input/touchscreen_tap_suppression_controller.cc',
        'browser/renderer_host/ui_events_helper.cc',
        'browser/renderer_host/ui_events_helper.h',
        'browser/renderer_host/tap_suppression_controller.cc',
      ],
    }, {
      'sources!': [
        'browser/renderer_host/input/touchscreen_tap_suppression_controller_stub.cc',
      ],
    }],
    ['use_aura==1', {
      'dependencies': [
        '../ui/aura/aura.gyp:aura',
        '../ui/base/strings/ui_strings.gyp:ui_strings',
        '../ui/compositor/compositor.gyp:compositor',
      ],
      'sources/': [
        ['exclude', '^browser/renderer_host/gtk_im_context_wrapper.cc'],
        ['exclude', '^browser/renderer_host/gtk_im_context_wrapper.h'],
        ['exclude', '^browser/renderer_host/input/touchpad_tap_suppression_controller.cc'],
        ['exclude', '^browser/renderer_host/native_web_keyboard_event_win.cc'],
        ['exclude', '^browser/renderer_host/render_widget_host.h'],
        ['exclude', '^browser/renderer_host/render_widget_host_view_win.cc'],
        ['exclude', '^browser/renderer_host/render_widget_host_view_win.h'],
        ['exclude', '^browser/web_contents/web_contents_drag_win.cc'],
        ['exclude', '^browser/web_contents/web_contents_drag_win.h'],
        ['exclude', '^browser/web_contents/web_contents_view_win.cc'],
        ['exclude', '^browser/web_contents/web_contents_view_win.h'],
        ['exclude', '^browser/web_contents/web_drag_dest_win.cc'],
        ['exclude', '^browser/web_contents/web_drag_dest_win.h'],
        ['exclude', '^browser/web_contents/web_drag_source_win.cc'],
        ['exclude', '^browser/web_contents/web_drag_source_win.h'],
      ],
    }, {
      'sources/': [
        ['exclude', '^browser/aura/'],
        ['exclude', '^browser/renderer_host/input/touchpad_tap_suppression_controller_aura.cc'],
        ['exclude', '^browser/renderer_host/render_widget_host_view_aura.cc'],
        ['exclude', '^browser/renderer_host/render_widget_host_view_aura.h'],
        ['exclude', '^browser/web_contents/touch_editable_impl_aura.cc'],
        ['exclude', '^browser/web_contents/touch_editable_impl_aura.h'],
      ],
    }],
    ['enable_plugins==1', {
      'dependencies': [
        '../ppapi/ppapi_internal.gyp:ppapi_ipc',
      ],
    }, {  # enable_plugins==0
      'sources!': [
        'browser/pepper_flash_settings_helper_impl.cc',
        'browser/pepper_flash_settings_helper_impl.h',
        'browser/plugin_data_remover_impl.cc',
        'browser/plugin_data_remover_impl.h',
        'browser/plugin_loader_posix.cc',
        'browser/plugin_loader_posix.h',
        'browser/plugin_process_host.cc',
        'browser/plugin_process_host.h',
        'browser/plugin_service_impl.cc',
        'browser/plugin_service_impl.h',
        'browser/ppapi_plugin_process_host.cc',
        'public/browser/plugin_service.h',
      ],
      'sources/': [
        ['exclude', '^browser/renderer_host/pepper/'],
      ],
    }],
    ['input_speech==0', {
      'sources/': [
        ['exclude', '^browser/speech/input_tag_speech_dispatcher_host\\.(cc|h)$'],
      ],
    }, {  # input_speech==1
      'dependencies': [
        '../third_party/flac/flac.gyp:libflac',
        '../third_party/speex/speex.gyp:libspeex',
      ],
    }],
    ['linux_use_libgps==1', {
      'dependencies': [
        '../build/linux/system.gyp:libgps',
      ],
    }],
  ],
}
