/*
 * Copyright (C) 2008 Apple Inc. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 *
 */

#include "config.h"
#include "core/platform/ThreadGlobalData.h"

#include "core/dom/EventNames.h"
#include "core/inspector/InspectorCounters.h"
#include "core/loader/cache/CachedResourceRequestInitiators.h"
#include "core/platform/ThreadTimers.h"
#include "wtf/MainThread.h"
#include "wtf/ThreadSpecific.h"
#include "wtf/Threading.h"
#include "wtf/WTFThreadData.h"
#include "wtf/text/StringImpl.h"

using namespace WTF;

namespace WebCore {

ThreadSpecific<ThreadGlobalData>* ThreadGlobalData::staticData;

ThreadGlobalData::ThreadGlobalData()
    : m_cachedResourceRequestInitiators(adoptPtr(new CachedResourceRequestInitiators))
    , m_eventNames(adoptPtr(new EventNames))
    , m_threadTimers(adoptPtr(new ThreadTimers))
#ifndef NDEBUG
    , m_isMainThread(isMainThread())
#endif
    , m_inspectorCounters(adoptPtr(new ThreadLocalInspectorCounters()))
{
    // This constructor will have been called on the main thread before being called on
    // any other thread, and is only called once per thread - this makes this a convenient
    // point to call methods that internally perform a one-time initialization that is not
    // threadsafe.
    wtfThreadData();
    StringImpl::empty();
}

ThreadGlobalData::~ThreadGlobalData()
{
}

void ThreadGlobalData::destroy()
{
    m_inspectorCounters.clear();
    m_eventNames.clear();
    m_threadTimers.clear();
}

} // namespace WebCore
