// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_KEYCODES_KEYBOARD_CODE_CONVERSION_H_
#define UI_BASE_KEYCODES_KEYBOARD_CODE_CONVERSION_H_

#include "base/basictypes.h"
#include "ui/base/keycodes/keyboard_codes.h"
#include "ui/base/ui_export.h"

namespace ui {

// A helper function to get the character generated by a key event in a
// platform independent way. It supports control characters as well.
// It assumes a US keyboard layout is used, so it may only be used when there
// is no native event or no better way to get the character.
// For example, if a virtual keyboard implementation can only generate key
// events with key_code and flags information, then there is no way for us to
// determine the actual character that should be generate by the key. Because
// a key_code only represents a physical key on the keyboard, it has nothing
// to do with the actual character printed on that key. In such case, the only
// thing we can do is to assume that we are using a US keyboard and get the
// character according to US keyboard layout definition.
// If a virtual keyboard implementation wants to support other keyboard
// layouts, that may generate different text for a certain key than on a US
// keyboard, a special native event object should be introduced to carry extra
// information to help determine the correct character.
// Take XKeyEvent as an example, it contains not only keycode and modifier
// flags but also group and other extra XKB information to help determine the
// correct character. That's why we can use XLookupString() function to get
// the correct text generated by a X key event (See how is GetCharacter()
// implemented in event_x.cc).
UI_EXPORT uint16 GetCharacterFromKeyCode(KeyboardCode key_code, int flags);

}  // namespace ui

#endif  // UI_BASE_KEYCODES_KEYBOARD_CODE_CONVERSION_H_
