/*
 * Copyright (c) 2008, 2009, Google Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "core/platform/chromium/ClipboardUtilitiesChromium.h"

#include "core/platform/KURL.h"
#include "core/platform/Pasteboard.h"

#include <public/WebClipboard.h>
#include <wtf/text/StringBuilder.h>
#include <wtf/text/WTFString.h>

namespace WebCore {

WebKit::WebClipboard::Buffer currentPasteboardBuffer()
{
    return Pasteboard::generalPasteboard()->isSelectionMode() ?
        WebKit::WebClipboard::BufferSelection :
        WebKit::WebClipboard::BufferStandard;
}

#if OS(WINDOWS)
void replaceNewlinesWithWindowsStyleNewlines(String& str)
{
    DEFINE_STATIC_LOCAL(String, windowsNewline, (ASCIILiteral("\r\n")));
    StringBuilder result;
    for (unsigned index = 0; index < str.length(); ++index) {
        if (str[index] != '\n' || (index > 0 && str[index - 1] == '\r'))
            result.append(str[index]);
        else
            result.append(windowsNewline);
    }
    str = result.toString();
}
#endif

void replaceNBSPWithSpace(String& str)
{
    static const UChar NonBreakingSpaceCharacter = 0xA0;
    static const UChar SpaceCharacter = ' ';
    str.replace(NonBreakingSpaceCharacter, SpaceCharacter);
}

String convertURIListToURL(const String& uriList)
{
    Vector<String> items;
    // Line separator is \r\n per RFC 2483 - however, for compatibility
    // reasons we allow just \n here.
    uriList.split('\n', items);
    // Process the input and return the first valid URL. In case no URLs can
    // be found, return an empty string. This is in line with the HTML5 spec.
    for (size_t i = 0; i < items.size(); ++i) {
        String& line = items[i];
        line = line.stripWhiteSpace();
        if (line.isEmpty())
            continue;
        if (line[0] == '#')
            continue;
        KURL url = KURL(ParsedURLString, line);
        if (url.isValid())
            return url;
    }
    return String();
}

} // namespace WebCore
