/*
    This file is part of the Blink open source project.
    This file has been auto-generated by CodeGeneratorV8.pm. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include "config.h"
#include "V8TestObj.h"

#include "HTMLNames.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptProfile.h"
#include "V8DOMStringList.h"
#include "V8Document.h"
#include "V8Float32Array.h"
#include "V8Node.h"
#include "V8SVGDocument.h"
#include "V8SVGPoint.h"
#include "V8ScriptProfile.h"
#include "V8TestCallback.h"
#include "V8TestNode.h"
#include "V8TestObj.h"
#include "V8TestSubObj.h"
#include "V8bool.h"
#include "bindings/v8/BindingState.h"
#include "bindings/v8/Dictionary.h"
#include "bindings/v8/ScriptController.h"
#include "bindings/v8/ScriptValue.h"
#include "bindings/v8/SerializedScriptValue.h"
#include "bindings/v8/V8Binding.h"
#include "bindings/v8/V8DOMActivityLogger.h"
#include "bindings/v8/V8DOMWrapper.h"
#include "bindings/v8/V8EventListenerList.h"
#include "core/dom/ContextFeatures.h"
#include "core/dom/DOMStringList.h"
#include "core/dom/ExceptionCode.h"
#include "core/page/Frame.h"
#include "core/page/PageConsole.h"
#include "core/page/UseCounter.h"
#include "core/svg/properties/SVGPropertyTearOff.h"
#include "core/svg/properties/SVGStaticPropertyTearOff.h"
#include <wtf/Float32Array.h>
#include <wtf/GetPtr.h>
#include <wtf/RefCounted.h>
#include <wtf/RefPtr.h>
#include <wtf/UnusedParam.h>
#include <wtf/Vector.h>

#if ENABLE(Condition1)
#include "V8TestObjectA.h"
#endif

#if ENABLE(Condition1) && ENABLE(Condition2)
#include "V8TestObjectB.h"
#endif

#if ENABLE(Condition1) || ENABLE(Condition2)
#include "V8TestObjectC.h"
#endif

#if ENABLE(BINDING_INTEGRITY)
#if defined(OS_WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7TestObj@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore7TestObjE[]; }
#endif
#endif // ENABLE(BINDING_INTEGRITY)

namespace WebCore {

#if ENABLE(BINDING_INTEGRITY)
// This checks if a DOM object that is about to be wrapped is valid.
// Specifically, it checks that a vtable of the DOM object is equal to
// a vtable of an expected class.
// Due to a dangling pointer, the DOM object you are wrapping might be
// already freed or realloced. If freed, the check will fail because
// a free list pointer should be stored at the head of the DOM object.
// If realloced, the check will fail because the vtable of the DOM object
// differs from the expected vtable (unless the same class of DOM object
// is realloced on the slot).
inline void checkTypeOrDieTrying(TestObj* object)
{
    void* actualVTablePointer = *(reinterpret_cast<void**>(object));
#if defined(OS_WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7TestObj@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore7TestObjE[2];
#endif
    if (actualVTablePointer != expectedVTablePointer)
        CRASH();
}
#endif // ENABLE(BINDING_INTEGRITY)

#if defined(OS_WIN)
// In ScriptWrappable, the use of extern function prototypes inside templated static methods has an issue on windows.
// These prototypes do not pick up the surrounding namespace, so drop out of WebCore as a workaround.
} // namespace WebCore
using WebCore::ScriptWrappable;
using WebCore::V8TestObj;
using WebCore::TestObj;
#endif
void initializeScriptWrappableForInterface(TestObj* object)
{
    if (ScriptWrappable::wrapperCanBeStoredInObject(object))
        ScriptWrappable::setTypeInfoInObject(object, &V8TestObj::info);
}
#if defined(OS_WIN)
namespace WebCore {
#endif
WrapperTypeInfo V8TestObj::info = { V8TestObj::GetTemplate, V8TestObj::derefObject, 0, 0, 0, V8TestObj::installPerContextPrototypeProperties, 0, WrapperTypeObjectPrototype };

namespace TestObjV8Internal {

template <typename T> void V8_USE(T) { }

static v8::Handle<v8::Value> readOnlyLongAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->readOnlyLongAttr(), info.GetIsolate());
}

static v8::Handle<v8::Value> readOnlyLongAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::readOnlyLongAttrAttrGetter(name, info);
}

static v8::Handle<v8::Value> readOnlyStringAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->readOnlyStringAttr(), info.GetIsolate(), ReturnUnsafeHandle);
}

static v8::Handle<v8::Value> readOnlyStringAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::readOnlyStringAttrAttrGetter(name, info);
}

static v8::Handle<v8::Value> readOnlyTestObjAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    RefPtr<TestObj> result = imp->readOnlyTestObjAttr();
    v8::Handle<v8::Value> wrapper = result.get() ? v8::Handle<v8::Value>(DOMDataStore::getWrapper(result.get(), info.GetIsolate())) : v8Undefined();
    if (wrapper.IsEmpty()) {
        wrapper = toV8(result.get(), info.Holder(), info.GetIsolate());
        if (!wrapper.IsEmpty())
            V8HiddenPropertyName::setNamedHiddenReference(info.Holder(), "readOnlyTestObjAttr", wrapper);
    }
    return wrapper;
}

static v8::Handle<v8::Value> readOnlyTestObjAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::readOnlyTestObjAttrAttrGetter(name, info);
}

static v8::Handle<v8::Value> staticReadOnlyLongAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return v8Integer(TestObj::staticReadOnlyLongAttr(), info.GetIsolate());
}

static v8::Handle<v8::Value> staticReadOnlyLongAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::staticReadOnlyLongAttrAttrGetter(name, info);
}

static v8::Handle<v8::Value> staticStringAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return v8String(TestObj::staticStringAttr(), info.GetIsolate(), ReturnUnsafeHandle);
}

static v8::Handle<v8::Value> staticStringAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::staticStringAttrAttrGetter(name, info);
}

static void staticStringAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    V8TRYCATCH_FOR_V8STRINGRESOURCE_VOID(V8StringResource<>, v, value);
    TestObj::setStaticStringAttr(v);
    return;
}

static void staticStringAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::staticStringAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> enumAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->enumAttr(), info.GetIsolate(), ReturnUnsafeHandle);
}

static v8::Handle<v8::Value> enumAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::enumAttrAttrGetter(name, info);
}

static void enumAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE_VOID(V8StringResource<>, v, value);
    String string = v;
    if (!(string == "" || string == "EnumValue1" || string == "EnumValue2" || string == "EnumValue3"))
        return;
    imp->setEnumAttr(v);
    return;
}

static void enumAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::enumAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> readOnlyEnumAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->readOnlyEnumAttr(), info.GetIsolate(), ReturnUnsafeHandle);
}

static v8::Handle<v8::Value> readOnlyEnumAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::readOnlyEnumAttrAttrGetter(name, info);
}

static v8::Handle<v8::Value> shortAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->shortAttr(), info.GetIsolate());
}

static v8::Handle<v8::Value> shortAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::shortAttrAttrGetter(name, info);
}

static void shortAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setShortAttr(v);
    return;
}

static void shortAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::shortAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> unsignedShortAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->unsignedShortAttr(), info.GetIsolate());
}

static v8::Handle<v8::Value> unsignedShortAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::unsignedShortAttrAttrGetter(name, info);
}

static void unsignedShortAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toUInt32(value));
    imp->setUnsignedShortAttr(v);
    return;
}

static void unsignedShortAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::unsignedShortAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> longAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->longAttr(), info.GetIsolate());
}

static v8::Handle<v8::Value> longAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::longAttrAttrGetter(name, info);
}

static void longAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setLongAttr(v);
    return;
}

static void longAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::longAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> longLongAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Number::New(static_cast<double>(imp->longLongAttr()));
}

static v8::Handle<v8::Value> longLongAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::longLongAttrAttrGetter(name, info);
}

static void longLongAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(long long, v, toInt64(value));
    imp->setLongLongAttr(v);
    return;
}

static void longLongAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::longLongAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> unsignedLongLongAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Number::New(static_cast<double>(imp->unsignedLongLongAttr()));
}

static v8::Handle<v8::Value> unsignedLongLongAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::unsignedLongLongAttrAttrGetter(name, info);
}

static void unsignedLongLongAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(unsigned long long, v, toUInt64(value));
    imp->setUnsignedLongLongAttr(v);
    return;
}

static void unsignedLongLongAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::unsignedLongLongAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> stringAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->stringAttr(), info.GetIsolate(), ReturnUnsafeHandle);
}

static v8::Handle<v8::Value> stringAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::stringAttrAttrGetter(name, info);
}

static void stringAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE_VOID(V8StringResource<>, v, value);
    imp->setStringAttr(v);
    return;
}

static void stringAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::stringAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> testObjAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return toV8Fast(imp->testObjAttr(), info, imp);
}

static v8::Handle<v8::Value> testObjAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    UseCounter::count(activeDOMWindow(BindingState::instance()), UseCounter::TestFeature);
    return TestObjV8Internal::testObjAttrAttrGetter(name, info);
}

static void testObjAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(TestObj*, v, V8TestObj::HasInstance(value, info.GetIsolate(), worldType(info.GetIsolate())) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0);
    imp->setTestObjAttr(WTF::getPtr(v));
    return;
}

static void testObjAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    UseCounter::count(activeDOMWindow(BindingState::instance()), UseCounter::TestFeature);
    TestObjV8Internal::testObjAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> XMLObjAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return toV8Fast(imp->xmlObjAttr(), info, imp);
}

static v8::Handle<v8::Value> XMLObjAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::XMLObjAttrAttrGetter(name, info);
}

static void XMLObjAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(TestObj*, v, V8TestObj::HasInstance(value, info.GetIsolate(), worldType(info.GetIsolate())) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0);
    imp->setXMLObjAttr(WTF::getPtr(v));
    return;
}

static void XMLObjAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::XMLObjAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> createAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Boolean(imp->isCreate(), info.GetIsolate());
}

static v8::Handle<v8::Value> createAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::createAttrGetter(name, info);
}

static void createAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(bool, v, value->BooleanValue());
    imp->setCreate(v);
    return;
}

static void createAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::createAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> reflectedStringAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->fastGetAttribute(WebCore::HTMLNames::reflectedstringattrAttr), info.GetIsolate(), ReturnUnsafeHandle);
}

static v8::Handle<v8::Value> reflectedStringAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::reflectedStringAttrAttrGetter(name, info);
}

static void reflectedStringAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE_VOID(V8StringResource<WithNullCheck>, v, value);
    imp->setAttribute(WebCore::HTMLNames::reflectedstringattrAttr, v);
    return;
}

static void reflectedStringAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::reflectedStringAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> reflectedIntegralAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->getIntegralAttribute(WebCore::HTMLNames::reflectedintegralattrAttr), info.GetIsolate());
}

static v8::Handle<v8::Value> reflectedIntegralAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::reflectedIntegralAttrAttrGetter(name, info);
}

static void reflectedIntegralAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setIntegralAttribute(WebCore::HTMLNames::reflectedintegralattrAttr, v);
    return;
}

static void reflectedIntegralAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::reflectedIntegralAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> reflectedUnsignedIntegralAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8UnsignedInteger(std::max(0, imp->getIntegralAttribute(WebCore::HTMLNames::reflectedunsignedintegralattrAttr)), info.GetIsolate());
}

static v8::Handle<v8::Value> reflectedUnsignedIntegralAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::reflectedUnsignedIntegralAttrAttrGetter(name, info);
}

static void reflectedUnsignedIntegralAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(unsigned, v, toUInt32(value));
    imp->setUnsignedIntegralAttribute(WebCore::HTMLNames::reflectedunsignedintegralattrAttr, v);
    return;
}

static void reflectedUnsignedIntegralAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::reflectedUnsignedIntegralAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> reflectedBooleanAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Boolean(imp->fastHasAttribute(WebCore::HTMLNames::reflectedbooleanattrAttr), info.GetIsolate());
}

static v8::Handle<v8::Value> reflectedBooleanAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::reflectedBooleanAttrAttrGetter(name, info);
}

static void reflectedBooleanAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(bool, v, value->BooleanValue());
    imp->setBooleanAttribute(WebCore::HTMLNames::reflectedbooleanattrAttr, v);
    return;
}

static void reflectedBooleanAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::reflectedBooleanAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> reflectedURLAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->getURLAttribute(WebCore::HTMLNames::reflectedurlattrAttr), info.GetIsolate(), ReturnUnsafeHandle);
}

static v8::Handle<v8::Value> reflectedURLAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::reflectedURLAttrAttrGetter(name, info);
}

static void reflectedURLAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE_VOID(V8StringResource<WithNullCheck>, v, value);
    imp->setAttribute(WebCore::HTMLNames::reflectedurlattrAttr, v);
    return;
}

static void reflectedURLAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::reflectedURLAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> reflectedStringAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->fastGetAttribute(WebCore::HTMLNames::customContentStringAttrAttr), info.GetIsolate(), ReturnUnsafeHandle);
}

static v8::Handle<v8::Value> reflectedStringAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::reflectedStringAttrAttrGetter(name, info);
}

static void reflectedStringAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE_VOID(V8StringResource<WithNullCheck>, v, value);
    imp->setAttribute(WebCore::HTMLNames::customContentStringAttrAttr, v);
    return;
}

static void reflectedStringAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::reflectedStringAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> reflectedCustomIntegralAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->getIntegralAttribute(WebCore::HTMLNames::customContentIntegralAttrAttr), info.GetIsolate());
}

static v8::Handle<v8::Value> reflectedCustomIntegralAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::reflectedCustomIntegralAttrAttrGetter(name, info);
}

static void reflectedCustomIntegralAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setIntegralAttribute(WebCore::HTMLNames::customContentIntegralAttrAttr, v);
    return;
}

static void reflectedCustomIntegralAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::reflectedCustomIntegralAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> reflectedCustomBooleanAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Boolean(imp->fastHasAttribute(WebCore::HTMLNames::customContentBooleanAttrAttr), info.GetIsolate());
}

static v8::Handle<v8::Value> reflectedCustomBooleanAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::reflectedCustomBooleanAttrAttrGetter(name, info);
}

static void reflectedCustomBooleanAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(bool, v, value->BooleanValue());
    imp->setBooleanAttribute(WebCore::HTMLNames::customContentBooleanAttrAttr, v);
    return;
}

static void reflectedCustomBooleanAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::reflectedCustomBooleanAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> reflectedCustomURLAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->getURLAttribute(WebCore::HTMLNames::customContentURLAttrAttr), info.GetIsolate(), ReturnUnsafeHandle);
}

static v8::Handle<v8::Value> reflectedCustomURLAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::reflectedCustomURLAttrAttrGetter(name, info);
}

static void reflectedCustomURLAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE_VOID(V8StringResource<WithNullCheck>, v, value);
    imp->setAttribute(WebCore::HTMLNames::customContentURLAttrAttr, v);
    return;
}

static void reflectedCustomURLAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::reflectedCustomURLAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> typedArrayAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return toV8Fast(imp->typedArrayAttr(), info, imp);
}

static v8::Handle<v8::Value> typedArrayAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::typedArrayAttrAttrGetter(name, info);
}

static void typedArrayAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(Float32Array*, v, V8Float32Array::HasInstance(value, info.GetIsolate(), worldType(info.GetIsolate())) ? V8Float32Array::toNative(v8::Handle<v8::Object>::Cast(value)) : 0);
    imp->setTypedArrayAttr(WTF::getPtr(v));
    return;
}

static void typedArrayAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::typedArrayAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> attrWithGetterExceptionAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ExceptionCode ec = 0;
    int v = imp->attrWithGetterException(ec);
    if (UNLIKELY(ec))
        return setDOMException(ec, info.GetIsolate());
    return v8Integer(v, info.GetIsolate());
}

static v8::Handle<v8::Value> attrWithGetterExceptionAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::attrWithGetterExceptionAttrGetter(name, info);
}

static void attrWithGetterExceptionAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setAttrWithGetterException(v);
    return;
}

static void attrWithGetterExceptionAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::attrWithGetterExceptionAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> attrWithSetterExceptionAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->attrWithSetterException(), info.GetIsolate());
}

static v8::Handle<v8::Value> attrWithSetterExceptionAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::attrWithSetterExceptionAttrGetter(name, info);
}

static void attrWithSetterExceptionAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    ExceptionCode ec = 0;
    imp->setAttrWithSetterException(v, ec);
    if (UNLIKELY(ec))
        setDOMException(ec, info.GetIsolate());
    return;
}

static void attrWithSetterExceptionAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::attrWithSetterExceptionAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> stringAttrWithGetterExceptionAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ExceptionCode ec = 0;
    String v = imp->stringAttrWithGetterException(ec);
    if (UNLIKELY(ec))
        return setDOMException(ec, info.GetIsolate());
    return v8String(v, info.GetIsolate(), ReturnUnsafeHandle);
}

static v8::Handle<v8::Value> stringAttrWithGetterExceptionAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::stringAttrWithGetterExceptionAttrGetter(name, info);
}

static void stringAttrWithGetterExceptionAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE_VOID(V8StringResource<>, v, value);
    imp->setStringAttrWithGetterException(v);
    return;
}

static void stringAttrWithGetterExceptionAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::stringAttrWithGetterExceptionAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> stringAttrWithSetterExceptionAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->stringAttrWithSetterException(), info.GetIsolate(), ReturnUnsafeHandle);
}

static v8::Handle<v8::Value> stringAttrWithSetterExceptionAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::stringAttrWithSetterExceptionAttrGetter(name, info);
}

static void stringAttrWithSetterExceptionAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE_VOID(V8StringResource<>, v, value);
    ExceptionCode ec = 0;
    imp->setStringAttrWithSetterException(v, ec);
    if (UNLIKELY(ec))
        setDOMException(ec, info.GetIsolate());
    return;
}

static void stringAttrWithSetterExceptionAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::stringAttrWithSetterExceptionAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> customAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return V8TestObj::customAttrAttrGetterCustom(name, info);
}

static void customAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    V8TestObj::customAttrAttrSetterCustom(name, value, info);
}

static v8::Handle<v8::Value> withScriptStateAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    return v8Integer(imp->withScriptStateAttribute(&state), info.GetIsolate());
}

static v8::Handle<v8::Value> withScriptStateAttributeAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::withScriptStateAttributeAttrGetter(name, info);
}

static void withScriptStateAttributeAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return;
    ScriptState& state = *currentState;
    imp->setWithScriptStateAttribute(&state, v);
    if (state.hadException())
        throwError(state.exception(), info.GetIsolate());
    return;
}

static void withScriptStateAttributeAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::withScriptStateAttributeAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> withScriptExecutionContextAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    return toV8Fast(imp->withScriptExecutionContextAttribute(scriptContext), info, imp);
}

static v8::Handle<v8::Value> withScriptExecutionContextAttributeAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::withScriptExecutionContextAttributeAttrGetter(name, info);
}

static void withScriptExecutionContextAttributeAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(TestObj*, v, V8TestObj::HasInstance(value, info.GetIsolate(), worldType(info.GetIsolate())) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0);
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    imp->setWithScriptExecutionContextAttribute(scriptContext, WTF::getPtr(v));
    return;
}

static void withScriptExecutionContextAttributeAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::withScriptExecutionContextAttributeAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> withScriptStateAttributeRaisesAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ExceptionCode ec = 0;
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    RefPtr<TestObj> v = imp->withScriptStateAttributeRaises(&state, ec);
    if (UNLIKELY(ec))
        return setDOMException(ec, info.GetIsolate());
    if (state.hadException())
        return throwError(state.exception(), info.GetIsolate());
    return toV8Fast(v.release(), info, imp);
}

static v8::Handle<v8::Value> withScriptStateAttributeRaisesAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::withScriptStateAttributeRaisesAttrGetter(name, info);
}

static void withScriptStateAttributeRaisesAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(TestObj*, v, V8TestObj::HasInstance(value, info.GetIsolate(), worldType(info.GetIsolate())) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0);
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return;
    ScriptState& state = *currentState;
    imp->setWithScriptStateAttributeRaises(&state, WTF::getPtr(v));
    if (state.hadException())
        throwError(state.exception(), info.GetIsolate());
    return;
}

static void withScriptStateAttributeRaisesAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::withScriptStateAttributeRaisesAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> withScriptExecutionContextAttributeRaisesAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ExceptionCode ec = 0;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    RefPtr<TestObj> v = imp->withScriptExecutionContextAttributeRaises(scriptContext, ec);
    if (UNLIKELY(ec))
        return setDOMException(ec, info.GetIsolate());
    return toV8Fast(v.release(), info, imp);
}

static v8::Handle<v8::Value> withScriptExecutionContextAttributeRaisesAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::withScriptExecutionContextAttributeRaisesAttrGetter(name, info);
}

static void withScriptExecutionContextAttributeRaisesAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(TestObj*, v, V8TestObj::HasInstance(value, info.GetIsolate(), worldType(info.GetIsolate())) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0);
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    imp->setWithScriptExecutionContextAttributeRaises(scriptContext, WTF::getPtr(v));
    return;
}

static void withScriptExecutionContextAttributeRaisesAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::withScriptExecutionContextAttributeRaisesAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    return toV8Fast(imp->withScriptExecutionContextAndScriptStateAttribute(&state, scriptContext), info, imp);
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateAttributeAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::withScriptExecutionContextAndScriptStateAttributeAttrGetter(name, info);
}

static void withScriptExecutionContextAndScriptStateAttributeAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(TestObj*, v, V8TestObj::HasInstance(value, info.GetIsolate(), worldType(info.GetIsolate())) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0);
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return;
    ScriptState& state = *currentState;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    imp->setWithScriptExecutionContextAndScriptStateAttribute(&state, scriptContext, WTF::getPtr(v));
    if (state.hadException())
        throwError(state.exception(), info.GetIsolate());
    return;
}

static void withScriptExecutionContextAndScriptStateAttributeAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::withScriptExecutionContextAndScriptStateAttributeAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateAttributeRaisesAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ExceptionCode ec = 0;
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    RefPtr<TestObj> v = imp->withScriptExecutionContextAndScriptStateAttributeRaises(&state, scriptContext, ec);
    if (UNLIKELY(ec))
        return setDOMException(ec, info.GetIsolate());
    if (state.hadException())
        return throwError(state.exception(), info.GetIsolate());
    return toV8Fast(v.release(), info, imp);
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateAttributeRaisesAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::withScriptExecutionContextAndScriptStateAttributeRaisesAttrGetter(name, info);
}

static void withScriptExecutionContextAndScriptStateAttributeRaisesAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(TestObj*, v, V8TestObj::HasInstance(value, info.GetIsolate(), worldType(info.GetIsolate())) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0);
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return;
    ScriptState& state = *currentState;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    imp->setWithScriptExecutionContextAndScriptStateAttributeRaises(&state, scriptContext, WTF::getPtr(v));
    if (state.hadException())
        throwError(state.exception(), info.GetIsolate());
    return;
}

static void withScriptExecutionContextAndScriptStateAttributeRaisesAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::withScriptExecutionContextAndScriptStateAttributeRaisesAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateWithSpacesAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    return toV8Fast(imp->withScriptExecutionContextAndScriptStateWithSpacesAttribute(&state, scriptContext), info, imp);
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateWithSpacesAttributeAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::withScriptExecutionContextAndScriptStateWithSpacesAttributeAttrGetter(name, info);
}

static void withScriptExecutionContextAndScriptStateWithSpacesAttributeAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(TestObj*, v, V8TestObj::HasInstance(value, info.GetIsolate(), worldType(info.GetIsolate())) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0);
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return;
    ScriptState& state = *currentState;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    imp->setWithScriptExecutionContextAndScriptStateWithSpacesAttribute(&state, scriptContext, WTF::getPtr(v));
    if (state.hadException())
        throwError(state.exception(), info.GetIsolate());
    return;
}

static void withScriptExecutionContextAndScriptStateWithSpacesAttributeAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::withScriptExecutionContextAndScriptStateWithSpacesAttributeAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> enforcedRangeLongAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->enforcedRangeLongAttr(), info.GetIsolate());
}

static v8::Handle<v8::Value> enforcedRangeLongAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::enforcedRangeLongAttrAttrGetter(name, info);
}

static void enforcedRangeLongAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_WITH_TYPECHECK_VOID(int, v, toInt32(value, EnforceRange, ok), info.GetIsolate());
    imp->setEnforcedRangeLongAttr(v);
    return;
}

static void enforcedRangeLongAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::enforcedRangeLongAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> enforcedRangeUnsignedLongAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8UnsignedInteger(imp->enforcedRangeUnsignedLongAttr(), info.GetIsolate());
}

static v8::Handle<v8::Value> enforcedRangeUnsignedLongAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::enforcedRangeUnsignedLongAttrAttrGetter(name, info);
}

static void enforcedRangeUnsignedLongAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_WITH_TYPECHECK_VOID(unsigned, v, toUInt32(value, EnforceRange, ok), info.GetIsolate());
    imp->setEnforcedRangeUnsignedLongAttr(v);
    return;
}

static void enforcedRangeUnsignedLongAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::enforcedRangeUnsignedLongAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> enforcedRangeLongLongAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Number::New(static_cast<double>(imp->enforcedRangeLongLongAttr()));
}

static v8::Handle<v8::Value> enforcedRangeLongLongAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::enforcedRangeLongLongAttrAttrGetter(name, info);
}

static void enforcedRangeLongLongAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_WITH_TYPECHECK_VOID(long long, v, toInt64(value, EnforceRange, ok), info.GetIsolate());
    imp->setEnforcedRangeLongLongAttr(v);
    return;
}

static void enforcedRangeLongLongAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::enforcedRangeLongLongAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> enforcedRangeUnsignedLongLongAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Number::New(static_cast<double>(imp->enforcedRangeUnsignedLongLongAttr()));
}

static v8::Handle<v8::Value> enforcedRangeUnsignedLongLongAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::enforcedRangeUnsignedLongLongAttrAttrGetter(name, info);
}

static void enforcedRangeUnsignedLongLongAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_WITH_TYPECHECK_VOID(unsigned long long, v, toUInt64(value, EnforceRange, ok), info.GetIsolate());
    imp->setEnforcedRangeUnsignedLongLongAttr(v);
    return;
}

static void enforcedRangeUnsignedLongLongAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::enforcedRangeUnsignedLongLongAttrAttrSetter(name, value, info);
}

#if ENABLE(Condition1)

static v8::Handle<v8::Value> conditionalAttr1AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->conditionalAttr1(), info.GetIsolate());
}

#endif // ENABLE(Condition1)

#if ENABLE(Condition1)

static v8::Handle<v8::Value> conditionalAttr1AttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::conditionalAttr1AttrGetter(name, info);
}

#endif // ENABLE(Condition1)

#if ENABLE(Condition1)

static void conditionalAttr1AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setConditionalAttr1(v);
    return;
}

#endif // ENABLE(Condition1)

#if ENABLE(Condition1)

static void conditionalAttr1AttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::conditionalAttr1AttrSetter(name, value, info);
}

#endif // ENABLE(Condition1)

#if ENABLE(Condition1) && ENABLE(Condition2)

static v8::Handle<v8::Value> conditionalAttr2AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->conditionalAttr2(), info.GetIsolate());
}

#endif // ENABLE(Condition1) && ENABLE(Condition2)

#if ENABLE(Condition1) && ENABLE(Condition2)

static v8::Handle<v8::Value> conditionalAttr2AttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::conditionalAttr2AttrGetter(name, info);
}

#endif // ENABLE(Condition1) && ENABLE(Condition2)

#if ENABLE(Condition1) && ENABLE(Condition2)

static void conditionalAttr2AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setConditionalAttr2(v);
    return;
}

#endif // ENABLE(Condition1) && ENABLE(Condition2)

#if ENABLE(Condition1) && ENABLE(Condition2)

static void conditionalAttr2AttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::conditionalAttr2AttrSetter(name, value, info);
}

#endif // ENABLE(Condition1) && ENABLE(Condition2)

#if ENABLE(Condition1) || ENABLE(Condition2)

static v8::Handle<v8::Value> conditionalAttr3AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->conditionalAttr3(), info.GetIsolate());
}

#endif // ENABLE(Condition1) || ENABLE(Condition2)

#if ENABLE(Condition1) || ENABLE(Condition2)

static v8::Handle<v8::Value> conditionalAttr3AttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::conditionalAttr3AttrGetter(name, info);
}

#endif // ENABLE(Condition1) || ENABLE(Condition2)

#if ENABLE(Condition1) || ENABLE(Condition2)

static void conditionalAttr3AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setConditionalAttr3(v);
    return;
}

#endif // ENABLE(Condition1) || ENABLE(Condition2)

#if ENABLE(Condition1) || ENABLE(Condition2)

static void conditionalAttr3AttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::conditionalAttr3AttrSetter(name, value, info);
}

#endif // ENABLE(Condition1) || ENABLE(Condition2)

static v8::Handle<v8::Value> cachedAttribute1AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return imp->cachedAttribute1().v8Value();
}

static v8::Handle<v8::Value> cachedAttribute1AttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::cachedAttribute1AttrGetter(name, info);
}

static v8::Handle<v8::Value> cachedAttribute2AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return imp->cachedAttribute2().v8Value();
}

static v8::Handle<v8::Value> cachedAttribute2AttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::cachedAttribute2AttrGetter(name, info);
}

static v8::Handle<v8::Value> anyAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return imp->anyAttribute().v8Value();
}

static v8::Handle<v8::Value> anyAttributeAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::anyAttributeAttrGetter(name, info);
}

static void anyAttributeAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(ScriptValue, v, ScriptValue(value));
    imp->setAnyAttribute(WTF::getPtr(v));
    return;
}

static void anyAttributeAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::anyAttributeAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> enabledAtRuntimeAttr1AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->enabledAtRuntimeAttr1(), info.GetIsolate());
}

static v8::Handle<v8::Value> enabledAtRuntimeAttr1AttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::enabledAtRuntimeAttr1AttrGetter(name, info);
}

static void enabledAtRuntimeAttr1AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setEnabledAtRuntimeAttr1(v);
    return;
}

static void enabledAtRuntimeAttr1AttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::enabledAtRuntimeAttr1AttrSetter(name, value, info);
}

static v8::Handle<v8::Value> enabledAtRuntimeAttr2AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->enabledAtRuntimeAttr2(), info.GetIsolate());
}

static v8::Handle<v8::Value> enabledAtRuntimeAttr2AttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::enabledAtRuntimeAttr2AttrGetter(name, info);
}

static void enabledAtRuntimeAttr2AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setEnabledAtRuntimeAttr2(v);
    return;
}

static void enabledAtRuntimeAttr2AttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::enabledAtRuntimeAttr2AttrSetter(name, value, info);
}

static v8::Handle<v8::Value> enabledPerContextAttr1AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->enabledPerContextAttr1(), info.GetIsolate());
}

static v8::Handle<v8::Value> enabledPerContextAttr1AttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::enabledPerContextAttr1AttrGetter(name, info);
}

static void enabledPerContextAttr1AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setEnabledPerContextAttr1(v);
    return;
}

static void enabledPerContextAttr1AttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::enabledPerContextAttr1AttrSetter(name, value, info);
}

static v8::Handle<v8::Value> enabledPerContextAttr2AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->enabledPerContextAttr2(), info.GetIsolate());
}

static v8::Handle<v8::Value> enabledPerContextAttr2AttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::enabledPerContextAttr2AttrGetter(name, info);
}

static void enabledPerContextAttr2AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setEnabledPerContextAttr2(v);
    return;
}

static void enabledPerContextAttr2AttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::enabledPerContextAttr2AttrSetter(name, value, info);
}

static v8::Handle<v8::Value> floatArrayAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Array(imp->floatArray(), info.GetIsolate());
}

static v8::Handle<v8::Value> floatArrayAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::floatArrayAttrGetter(name, info);
}

static void floatArrayAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(Vector<float>, v, toNativeArray<float>(value));
    imp->setFloatArray(v);
    return;
}

static void floatArrayAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::floatArrayAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> doubleArrayAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Array(imp->doubleArray(), info.GetIsolate());
}

static v8::Handle<v8::Value> doubleArrayAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::doubleArrayAttrGetter(name, info);
}

static void doubleArrayAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(Vector<double>, v, toNativeArray<double>(value));
    imp->setDoubleArray(v);
    return;
}

static void doubleArrayAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::doubleArrayAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> contentDocumentAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    if (!BindingSecurity::shouldAllowAccessToNode(BindingState::instance(), imp->contentDocument()))
        return v8::Handle<v8::Value>(v8Null(info.GetIsolate()));

    return toV8Fast(imp->contentDocument(), info, imp);
}

static v8::Handle<v8::Value> contentDocumentAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::contentDocumentAttrGetter(name, info);
}

static v8::Handle<v8::Value> mutablePointAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return toV8Fast(WTF::getPtr(SVGStaticPropertyTearOff<TestObj, FloatPoint>::create(imp, imp->mutablePoint(), &TestObj::updateMutablePoint)), info, imp);
}

static v8::Handle<v8::Value> mutablePointAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::mutablePointAttrGetter(name, info);
}

static void mutablePointAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(RefPtr<SVGPropertyTearOff<FloatPoint> >, v, V8SVGPoint::HasInstance(value, info.GetIsolate(), worldType(info.GetIsolate())) ? V8SVGPoint::toNative(v8::Handle<v8::Object>::Cast(value)) : 0);
    imp->setMutablePoint(WTF::getPtr(v));
    return;
}

static void mutablePointAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::mutablePointAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> immutablePointAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return toV8Fast(WTF::getPtr(SVGPropertyTearOff<FloatPoint>::create(imp->immutablePoint())), info, imp);
}

static v8::Handle<v8::Value> immutablePointAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::immutablePointAttrGetter(name, info);
}

static void immutablePointAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(RefPtr<SVGPropertyTearOff<FloatPoint> >, v, V8SVGPoint::HasInstance(value, info.GetIsolate(), worldType(info.GetIsolate())) ? V8SVGPoint::toNative(v8::Handle<v8::Object>::Cast(value)) : 0);
    imp->setImmutablePoint(WTF::getPtr(v));
    return;
}

static void immutablePointAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::immutablePointAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> strawberryAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->blueberry(), info.GetIsolate());
}

static v8::Handle<v8::Value> strawberryAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::strawberryAttrGetter(name, info);
}

static void strawberryAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setBlueberry(v);
    return;
}

static void strawberryAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::strawberryAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> strictFloatAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Number::New(imp->strictFloat());
}

static v8::Handle<v8::Value> strictFloatAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::strictFloatAttrGetter(name, info);
}

static void strictFloatAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(float, v, static_cast<float>(value->NumberValue()));
    imp->setStrictFloat(v);
    return;
}

static void strictFloatAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::strictFloatAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> descriptionAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->description(), info.GetIsolate());
}

static v8::Handle<v8::Value> descriptionAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::descriptionAttrGetter(name, info);
}

static v8::Handle<v8::Value> idAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->id(), info.GetIsolate());
}

static v8::Handle<v8::Value> idAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::idAttrGetter(name, info);
}

static void idAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setId(v);
    return;
}

static void idAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::idAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> hashAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->hash(), info.GetIsolate(), ReturnUnsafeHandle);
}

static v8::Handle<v8::Value> hashAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::hashAttrGetter(name, info);
}

static v8::Handle<v8::Value> replaceableAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->replaceableAttribute(), info.GetIsolate());
}

static v8::Handle<v8::Value> replaceableAttributeAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::replaceableAttributeAttrGetter(name, info);
}

static v8::Handle<v8::Value> nullableDoubleAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    bool isNull = false;
    double v = imp->nullableDoubleAttribute(isNull);
    if (isNull)
        return v8Null(info.GetIsolate());
    return v8::Number::New(v);
}

static v8::Handle<v8::Value> nullableDoubleAttributeAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::nullableDoubleAttributeAttrGetter(name, info);
}

static v8::Handle<v8::Value> nullableLongAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    bool isNull = false;
    int v = imp->nullableLongAttribute(isNull);
    if (isNull)
        return v8Null(info.GetIsolate());
    return v8Integer(v, info.GetIsolate());
}

static v8::Handle<v8::Value> nullableLongAttributeAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::nullableLongAttributeAttrGetter(name, info);
}

static v8::Handle<v8::Value> nullableBooleanAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    bool isNull = false;
    bool v = imp->nullableBooleanAttribute(isNull);
    if (isNull)
        return v8Null(info.GetIsolate());
    return v8Boolean(v, info.GetIsolate());
}

static v8::Handle<v8::Value> nullableBooleanAttributeAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::nullableBooleanAttributeAttrGetter(name, info);
}

static v8::Handle<v8::Value> nullableStringAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    bool isNull = false;
    String v = imp->nullableStringAttribute(isNull);
    if (isNull)
        return v8Null(info.GetIsolate());
    return v8String(v, info.GetIsolate(), ReturnUnsafeHandle);
}

static v8::Handle<v8::Value> nullableStringAttributeAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::nullableStringAttributeAttrGetter(name, info);
}

static v8::Handle<v8::Value> nullableLongSettableAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    bool isNull = false;
    int v = imp->nullableLongSettableAttribute(isNull);
    if (isNull)
        return v8Null(info.GetIsolate());
    return v8Integer(v, info.GetIsolate());
}

static v8::Handle<v8::Value> nullableLongSettableAttributeAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::nullableLongSettableAttributeAttrGetter(name, info);
}

static void nullableLongSettableAttributeAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setNullableLongSettableAttribute(v);
    return;
}

static void nullableLongSettableAttributeAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::nullableLongSettableAttributeAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> nullableStringValueAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ExceptionCode ec = 0;
    bool isNull = false;
    int v = imp->nullableStringValue(isNull, ec);
    if (isNull)
        return v8Null(info.GetIsolate());
    if (UNLIKELY(ec))
        return setDOMException(ec, info.GetIsolate());
    return v8Integer(v, info.GetIsolate());
}

static v8::Handle<v8::Value> nullableStringValueAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::nullableStringValueAttrGetter(name, info);
}

static void nullableStringValueAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setNullableStringValue(v);
    return;
}

static void nullableStringValueAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::nullableStringValueAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> perWorldReadOnlyAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    RefPtr<TestObj> result = imp->perWorldReadOnlyAttribute();
    v8::Handle<v8::Value> wrapper = result.get() ? v8::Handle<v8::Value>(DOMDataStore::getWrapper(result.get(), info.GetIsolate())) : v8Undefined();
    if (wrapper.IsEmpty()) {
        wrapper = toV8(result.get(), info.Holder(), info.GetIsolate());
        if (!wrapper.IsEmpty())
            V8HiddenPropertyName::setNamedHiddenReference(info.Holder(), "perWorldReadOnlyAttribute", wrapper);
    }
    return wrapper;
}

static v8::Handle<v8::Value> perWorldReadOnlyAttributeAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::perWorldReadOnlyAttributeAttrGetter(name, info);
}

static v8::Handle<v8::Value> perWorldReadOnlyAttributeAttrGetterForMainWorld(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    RefPtr<TestObj> result = imp->perWorldReadOnlyAttribute();
    v8::Handle<v8::Value> wrapper = result.get() ? v8::Handle<v8::Value>(DOMDataStore::getWrapperForMainWorld(result.get())) : v8Undefined();
    if (wrapper.IsEmpty()) {
        wrapper = toV8(result.get(), info.Holder(), info.GetIsolate());
        if (!wrapper.IsEmpty())
            V8HiddenPropertyName::setNamedHiddenReference(info.Holder(), "perWorldReadOnlyAttribute", wrapper);
    }
    return wrapper;
}

static v8::Handle<v8::Value> perWorldReadOnlyAttributeAttrGetterCallbackForMainWorld(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::perWorldReadOnlyAttributeAttrGetterForMainWorld(name, info);
}

static v8::Handle<v8::Value> perWorldAttributeAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return toV8Fast(imp->perWorldAttribute(), info, imp);
}

static v8::Handle<v8::Value> perWorldAttributeAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::perWorldAttributeAttrGetter(name, info);
}

static v8::Handle<v8::Value> perWorldAttributeAttrGetterForMainWorld(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return toV8FastForMainWorld(imp->perWorldAttribute(), info, imp);
}

static v8::Handle<v8::Value> perWorldAttributeAttrGetterCallbackForMainWorld(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::perWorldAttributeAttrGetterForMainWorld(name, info);
}

static void perWorldAttributeAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(TestObj*, v, V8TestObj::HasInstance(value, info.GetIsolate(), worldType(info.GetIsolate())) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0);
    imp->setPerWorldAttribute(WTF::getPtr(v));
    return;
}

static void perWorldAttributeAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::perWorldAttributeAttrSetter(name, value, info);
}

static void perWorldAttributeAttrSetterForMainWorld(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(TestObj*, v, V8TestObj::HasInstance(value, info.GetIsolate(), worldType(info.GetIsolate())) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0);
    imp->setPerWorldAttribute(WTF::getPtr(v));
    return;
}

static void perWorldAttributeAttrSetterCallbackForMainWorld(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::perWorldAttributeAttrSetterForMainWorld(name, value, info);
}

static v8::Handle<v8::Value> activityLoggedAttr1AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->activityLoggedAttr1(), info.GetIsolate());
}

static v8::Handle<v8::Value> activityLoggedAttr1AttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    V8PerContextData* contextData = V8PerContextData::from(info.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger())
        contextData->activityLogger()->log("TestObject.activityLoggedAttr1", 0, 0, "Getter");
    return TestObjV8Internal::activityLoggedAttr1AttrGetter(name, info);
}

static void activityLoggedAttr1AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setActivityLoggedAttr1(v);
    return;
}

static void activityLoggedAttr1AttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    V8PerContextData* contextData = V8PerContextData::from(info.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger()) {
        v8::Handle<v8::Value> loggerArg[] = { value };
        contextData->activityLogger()->log("TestObject.activityLoggedAttr1", 1, &loggerArg[0], "Setter");
    }
    TestObjV8Internal::activityLoggedAttr1AttrSetter(name, value, info);
}

static v8::Handle<v8::Value> activityLoggedAttr2AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->activityLoggedAttr2(), info.GetIsolate());
}

static v8::Handle<v8::Value> activityLoggedAttr2AttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    V8PerContextData* contextData = V8PerContextData::from(info.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger())
        contextData->activityLogger()->log("TestObject.activityLoggedAttr2", 0, 0, "Getter");
    return TestObjV8Internal::activityLoggedAttr2AttrGetter(name, info);
}

static v8::Handle<v8::Value> activityLoggedAttr2AttrGetterForMainWorld(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->activityLoggedAttr2(), info.GetIsolate());
}

static v8::Handle<v8::Value> activityLoggedAttr2AttrGetterCallbackForMainWorld(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    V8PerContextData* contextData = V8PerContextData::from(info.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger())
        contextData->activityLogger()->log("TestObject.activityLoggedAttr2", 0, 0, "Getter");
    return TestObjV8Internal::activityLoggedAttr2AttrGetterForMainWorld(name, info);
}

static void activityLoggedAttr2AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setActivityLoggedAttr2(v);
    return;
}

static void activityLoggedAttr2AttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    V8PerContextData* contextData = V8PerContextData::from(info.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger()) {
        v8::Handle<v8::Value> loggerArg[] = { value };
        contextData->activityLogger()->log("TestObject.activityLoggedAttr2", 1, &loggerArg[0], "Setter");
    }
    TestObjV8Internal::activityLoggedAttr2AttrSetter(name, value, info);
}

static void activityLoggedAttr2AttrSetterForMainWorld(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setActivityLoggedAttr2(v);
    return;
}

static void activityLoggedAttr2AttrSetterCallbackForMainWorld(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    V8PerContextData* contextData = V8PerContextData::from(info.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger()) {
        v8::Handle<v8::Value> loggerArg[] = { value };
        contextData->activityLogger()->log("TestObject.activityLoggedAttr2", 1, &loggerArg[0], "Setter");
    }
    TestObjV8Internal::activityLoggedAttr2AttrSetterForMainWorld(name, value, info);
}

static v8::Handle<v8::Value> activityLoggedInIsolatedWorldsAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->activityLoggedInIsolatedWorldsAttr(), info.GetIsolate());
}

static v8::Handle<v8::Value> activityLoggedInIsolatedWorldsAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    V8PerContextData* contextData = V8PerContextData::from(info.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger())
        contextData->activityLogger()->log("TestObject.activityLoggedInIsolatedWorldsAttr", 0, 0, "Getter");
    return TestObjV8Internal::activityLoggedInIsolatedWorldsAttrAttrGetter(name, info);
}

static v8::Handle<v8::Value> activityLoggedInIsolatedWorldsAttrAttrGetterForMainWorld(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->activityLoggedInIsolatedWorldsAttr(), info.GetIsolate());
}

static v8::Handle<v8::Value> activityLoggedInIsolatedWorldsAttrAttrGetterCallbackForMainWorld(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::activityLoggedInIsolatedWorldsAttrAttrGetterForMainWorld(name, info);
}

static void activityLoggedInIsolatedWorldsAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setActivityLoggedInIsolatedWorldsAttr(v);
    return;
}

static void activityLoggedInIsolatedWorldsAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    V8PerContextData* contextData = V8PerContextData::from(info.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger()) {
        v8::Handle<v8::Value> loggerArg[] = { value };
        contextData->activityLogger()->log("TestObject.activityLoggedInIsolatedWorldsAttr", 1, &loggerArg[0], "Setter");
    }
    TestObjV8Internal::activityLoggedInIsolatedWorldsAttrAttrSetter(name, value, info);
}

static void activityLoggedInIsolatedWorldsAttrAttrSetterForMainWorld(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setActivityLoggedInIsolatedWorldsAttr(v);
    return;
}

static void activityLoggedInIsolatedWorldsAttrAttrSetterCallbackForMainWorld(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::activityLoggedInIsolatedWorldsAttrAttrSetterForMainWorld(name, value, info);
}

static v8::Handle<v8::Value> activityLoggedAttrSetter1AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->activityLoggedAttrSetter1(), info.GetIsolate());
}

static v8::Handle<v8::Value> activityLoggedAttrSetter1AttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::activityLoggedAttrSetter1AttrGetter(name, info);
}

static void activityLoggedAttrSetter1AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setActivityLoggedAttrSetter1(v);
    return;
}

static void activityLoggedAttrSetter1AttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    V8PerContextData* contextData = V8PerContextData::from(info.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger()) {
        v8::Handle<v8::Value> loggerArg[] = { value };
        contextData->activityLogger()->log("TestObject.activityLoggedAttrSetter1", 1, &loggerArg[0], "Setter");
    }
    TestObjV8Internal::activityLoggedAttrSetter1AttrSetter(name, value, info);
}

static v8::Handle<v8::Value> activityLoggedAttrSetter2AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->activityLoggedAttrSetter2(), info.GetIsolate());
}

static v8::Handle<v8::Value> activityLoggedAttrSetter2AttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::activityLoggedAttrSetter2AttrGetter(name, info);
}

static v8::Handle<v8::Value> activityLoggedAttrSetter2AttrGetterForMainWorld(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->activityLoggedAttrSetter2(), info.GetIsolate());
}

static v8::Handle<v8::Value> activityLoggedAttrSetter2AttrGetterCallbackForMainWorld(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::activityLoggedAttrSetter2AttrGetterForMainWorld(name, info);
}

static void activityLoggedAttrSetter2AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setActivityLoggedAttrSetter2(v);
    return;
}

static void activityLoggedAttrSetter2AttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    V8PerContextData* contextData = V8PerContextData::from(info.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger()) {
        v8::Handle<v8::Value> loggerArg[] = { value };
        contextData->activityLogger()->log("TestObject.activityLoggedAttrSetter2", 1, &loggerArg[0], "Setter");
    }
    TestObjV8Internal::activityLoggedAttrSetter2AttrSetter(name, value, info);
}

static void activityLoggedAttrSetter2AttrSetterForMainWorld(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setActivityLoggedAttrSetter2(v);
    return;
}

static void activityLoggedAttrSetter2AttrSetterCallbackForMainWorld(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    V8PerContextData* contextData = V8PerContextData::from(info.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger()) {
        v8::Handle<v8::Value> loggerArg[] = { value };
        contextData->activityLogger()->log("TestObject.activityLoggedAttrSetter2", 1, &loggerArg[0], "Setter");
    }
    TestObjV8Internal::activityLoggedAttrSetter2AttrSetterForMainWorld(name, value, info);
}

static v8::Handle<v8::Value> activityLoggedInIsolatedWorldsAttrSetterAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->activityLoggedInIsolatedWorldsAttrSetter(), info.GetIsolate());
}

static v8::Handle<v8::Value> activityLoggedInIsolatedWorldsAttrSetterAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::activityLoggedInIsolatedWorldsAttrSetterAttrGetter(name, info);
}

static v8::Handle<v8::Value> activityLoggedInIsolatedWorldsAttrSetterAttrGetterForMainWorld(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->activityLoggedInIsolatedWorldsAttrSetter(), info.GetIsolate());
}

static v8::Handle<v8::Value> activityLoggedInIsolatedWorldsAttrSetterAttrGetterCallbackForMainWorld(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::activityLoggedInIsolatedWorldsAttrSetterAttrGetterForMainWorld(name, info);
}

static void activityLoggedInIsolatedWorldsAttrSetterAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setActivityLoggedInIsolatedWorldsAttrSetter(v);
    return;
}

static void activityLoggedInIsolatedWorldsAttrSetterAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    V8PerContextData* contextData = V8PerContextData::from(info.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger()) {
        v8::Handle<v8::Value> loggerArg[] = { value };
        contextData->activityLogger()->log("TestObject.activityLoggedInIsolatedWorldsAttrSetter", 1, &loggerArg[0], "Setter");
    }
    TestObjV8Internal::activityLoggedInIsolatedWorldsAttrSetterAttrSetter(name, value, info);
}

static void activityLoggedInIsolatedWorldsAttrSetterAttrSetterForMainWorld(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setActivityLoggedInIsolatedWorldsAttrSetter(v);
    return;
}

static void activityLoggedInIsolatedWorldsAttrSetterAttrSetterCallbackForMainWorld(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::activityLoggedInIsolatedWorldsAttrSetterAttrSetterForMainWorld(name, value, info);
}

static v8::Handle<v8::Value> activityLoggedAttrGetter1AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->activityLoggedAttrGetter1(), info.GetIsolate());
}

static v8::Handle<v8::Value> activityLoggedAttrGetter1AttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    V8PerContextData* contextData = V8PerContextData::from(info.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger())
        contextData->activityLogger()->log("TestObject.activityLoggedAttrGetter1", 0, 0, "Getter");
    return TestObjV8Internal::activityLoggedAttrGetter1AttrGetter(name, info);
}

static void activityLoggedAttrGetter1AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setActivityLoggedAttrGetter1(v);
    return;
}

static void activityLoggedAttrGetter1AttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::activityLoggedAttrGetter1AttrSetter(name, value, info);
}

static v8::Handle<v8::Value> activityLoggedAttrGetter2AttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->activityLoggedAttrGetter2(), info.GetIsolate());
}

static v8::Handle<v8::Value> activityLoggedAttrGetter2AttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    V8PerContextData* contextData = V8PerContextData::from(info.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger())
        contextData->activityLogger()->log("TestObject.activityLoggedAttrGetter2", 0, 0, "Getter");
    return TestObjV8Internal::activityLoggedAttrGetter2AttrGetter(name, info);
}

static v8::Handle<v8::Value> activityLoggedAttrGetter2AttrGetterForMainWorld(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->activityLoggedAttrGetter2(), info.GetIsolate());
}

static v8::Handle<v8::Value> activityLoggedAttrGetter2AttrGetterCallbackForMainWorld(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    V8PerContextData* contextData = V8PerContextData::from(info.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger())
        contextData->activityLogger()->log("TestObject.activityLoggedAttrGetter2", 0, 0, "Getter");
    return TestObjV8Internal::activityLoggedAttrGetter2AttrGetterForMainWorld(name, info);
}

static void activityLoggedAttrGetter2AttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setActivityLoggedAttrGetter2(v);
    return;
}

static void activityLoggedAttrGetter2AttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::activityLoggedAttrGetter2AttrSetter(name, value, info);
}

static void activityLoggedAttrGetter2AttrSetterForMainWorld(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setActivityLoggedAttrGetter2(v);
    return;
}

static void activityLoggedAttrGetter2AttrSetterCallbackForMainWorld(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::activityLoggedAttrGetter2AttrSetterForMainWorld(name, value, info);
}

static v8::Handle<v8::Value> activityLoggedInIsolatedWorldsAttrGetterAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->activityLoggedInIsolatedWorldsAttrGetter(), info.GetIsolate());
}

static v8::Handle<v8::Value> activityLoggedInIsolatedWorldsAttrGetterAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    V8PerContextData* contextData = V8PerContextData::from(info.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger())
        contextData->activityLogger()->log("TestObject.activityLoggedInIsolatedWorldsAttrGetter", 0, 0, "Getter");
    return TestObjV8Internal::activityLoggedInIsolatedWorldsAttrGetterAttrGetter(name, info);
}

static v8::Handle<v8::Value> activityLoggedInIsolatedWorldsAttrGetterAttrGetterForMainWorld(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->activityLoggedInIsolatedWorldsAttrGetter(), info.GetIsolate());
}

static v8::Handle<v8::Value> activityLoggedInIsolatedWorldsAttrGetterAttrGetterCallbackForMainWorld(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::activityLoggedInIsolatedWorldsAttrGetterAttrGetterForMainWorld(name, info);
}

static void activityLoggedInIsolatedWorldsAttrGetterAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setActivityLoggedInIsolatedWorldsAttrGetter(v);
    return;
}

static void activityLoggedInIsolatedWorldsAttrGetterAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::activityLoggedInIsolatedWorldsAttrGetterAttrSetter(name, value, info);
}

static void activityLoggedInIsolatedWorldsAttrGetterAttrSetterForMainWorld(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setActivityLoggedInIsolatedWorldsAttrGetter(v);
    return;
}

static void activityLoggedInIsolatedWorldsAttrGetterAttrSetterCallbackForMainWorld(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObjV8Internal::activityLoggedInIsolatedWorldsAttrGetterAttrSetterForMainWorld(name, value, info);
}

static v8::Handle<v8::Value> deprecatedStaticReadOnlyAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return v8Integer(TestObj::deprecatedStaticReadOnlyAttr(), info.GetIsolate());
}

static v8::Handle<v8::Value> deprecatedStaticReadOnlyAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    UseCounter::countDeprecation(activeDOMWindow(BindingState::instance()), UseCounter::StaticReadonlyAttribute);
    return TestObjV8Internal::deprecatedStaticReadOnlyAttrAttrGetter(name, info);
}

static v8::Handle<v8::Value> deprecatedStaticAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    return v8Integer(TestObj::deprecatedStaticAttr(), info.GetIsolate());
}

static v8::Handle<v8::Value> deprecatedStaticAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    UseCounter::countDeprecation(activeDOMWindow(BindingState::instance()), UseCounter::StaticAttribute);
    return TestObjV8Internal::deprecatedStaticAttrAttrGetter(name, info);
}

static void deprecatedStaticAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    V8TRYCATCH_VOID(int, v, toInt32(value));
    TestObj::setDeprecatedStaticAttr(v);
    return;
}

static void deprecatedStaticAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    UseCounter::countDeprecation(activeDOMWindow(BindingState::instance()), UseCounter::StaticAttribute);
    TestObjV8Internal::deprecatedStaticAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> deprecatedReadonlyAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->deprecatedReadonlyAttr(), info.GetIsolate());
}

static v8::Handle<v8::Value> deprecatedReadonlyAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    UseCounter::countDeprecation(activeDOMWindow(BindingState::instance()), UseCounter::ReadonlyAttribute);
    return TestObjV8Internal::deprecatedReadonlyAttrAttrGetter(name, info);
}

static v8::Handle<v8::Value> deprecatedAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8Integer(imp->deprecatedAttr(), info.GetIsolate());
}

static v8::Handle<v8::Value> deprecatedAttrAttrGetterCallback(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    UseCounter::countDeprecation(activeDOMWindow(BindingState::instance()), UseCounter::Attribute);
    return TestObjV8Internal::deprecatedAttrAttrGetter(name, info);
}

static void deprecatedAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8TRYCATCH_VOID(int, v, toInt32(value));
    imp->setDeprecatedAttr(v);
    return;
}

static void deprecatedAttrAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    UseCounter::countDeprecation(activeDOMWindow(BindingState::instance()), UseCounter::Attribute);
    TestObjV8Internal::deprecatedAttrAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> TestObjConstructorGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    v8::Handle<v8::Value> data = info.Data();
    ASSERT(data->IsExternal());
    V8PerContextData* perContextData = V8PerContextData::from(info.Holder()->CreationContext());
    if (!perContextData)
        return v8Undefined();
    return perContextData->constructorForType(WrapperTypeInfo::unwrap(data));
}
static void TestObjReplaceableAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    info.This()->ForceSet(name, value);
}

static void TestObjReplaceableAttrSetterCallback(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    return TestObjV8Internal::TestObjReplaceableAttrSetter(name, value, info);
}

static v8::Handle<v8::Value> voidMethodMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    imp->voidMethod();
    return v8Undefined();
}

static v8::Handle<v8::Value> voidMethodMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::voidMethodMethod(args);
}

static v8::Handle<v8::Value> voidMethodWithArgsMethod(const v8::Arguments& args)
{
    if (args.Length() < 3)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(args[0]));
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, strArg, args[1]);
    V8TRYCATCH(TestObj*, objArg, V8TestObj::HasInstance(args[2], args.GetIsolate(), worldType(args.GetIsolate())) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(args[2])) : 0);
    imp->voidMethodWithArgs(longArg, strArg, objArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> voidMethodWithArgsMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::voidMethodWithArgsMethod(args);
}

static v8::Handle<v8::Value> longMethodMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    return v8Integer(imp->longMethod(), args.GetIsolate());
}

static v8::Handle<v8::Value> longMethodMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::longMethodMethod(args);
}

static v8::Handle<v8::Value> longMethodWithArgsMethod(const v8::Arguments& args)
{
    if (args.Length() < 3)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(args[0]));
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, strArg, args[1]);
    V8TRYCATCH(TestObj*, objArg, V8TestObj::HasInstance(args[2], args.GetIsolate(), worldType(args.GetIsolate())) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(args[2])) : 0);
    return v8Integer(imp->longMethodWithArgs(longArg, strArg, objArg), args.GetIsolate());
}

static v8::Handle<v8::Value> longMethodWithArgsMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::longMethodWithArgsMethod(args);
}

static v8::Handle<v8::Value> objMethodMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    return toV8(imp->objMethod(), args.Holder(), args.GetIsolate());
}

static v8::Handle<v8::Value> objMethodMethodCallback(const v8::Arguments& args)
{
    UseCounter::count(activeDOMWindow(BindingState::instance()), UseCounter::TestFeature);
    return TestObjV8Internal::objMethodMethod(args);
}

static v8::Handle<v8::Value> objMethodWithArgsMethod(const v8::Arguments& args)
{
    if (args.Length() < 3)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(args[0]));
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, strArg, args[1]);
    V8TRYCATCH(TestObj*, objArg, V8TestObj::HasInstance(args[2], args.GetIsolate(), worldType(args.GetIsolate())) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(args[2])) : 0);
    return toV8(imp->objMethodWithArgs(longArg, strArg, objArg), args.Holder(), args.GetIsolate());
}

static v8::Handle<v8::Value> objMethodWithArgsMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::objMethodWithArgsMethod(args);
}

static v8::Handle<v8::Value> methodWithSequenceArgMethod(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(Vector<RefPtr<ScriptProfile> >, sequenceArg, (toRefPtrNativeArray<ScriptProfile, V8ScriptProfile>(args[0], args.GetIsolate())));
    imp->methodWithSequenceArg(sequenceArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithSequenceArgMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::methodWithSequenceArgMethod(args);
}

static v8::Handle<v8::Value> methodReturningSequenceMethod(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(args[0]));
    return v8Array(imp->methodReturningSequence(longArg), args.GetIsolate());
}

static v8::Handle<v8::Value> methodReturningSequenceMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::methodReturningSequenceMethod(args);
}

static v8::Handle<v8::Value> methodWithEnumArgMethod(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, enumArg, args[0]);
    String string = enumArg;
    if (!(string == "" || string == "EnumValue1" || string == "EnumValue2" || string == "EnumValue3"))
        return throwTypeError(0, args.GetIsolate());
    imp->methodWithEnumArg(enumArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithEnumArgMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::methodWithEnumArgMethod(args);
}

static v8::Handle<v8::Value> methodThatRequiresAllArgsAndThrowsMethod(const v8::Arguments& args)
{
    if (args.Length() < 2)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, strArg, args[0]);
    V8TRYCATCH(TestObj*, objArg, V8TestObj::HasInstance(args[1], args.GetIsolate(), worldType(args.GetIsolate())) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(args[1])) : 0);
    RefPtr<TestObj> result = imp->methodThatRequiresAllArgsAndThrows(strArg, objArg, ec);
    if (UNLIKELY(ec))
        goto fail;
    return toV8(result.release(), args.Holder(), args.GetIsolate());
    }
    fail:
    return setDOMException(ec, args.GetIsolate());
}

static v8::Handle<v8::Value> methodThatRequiresAllArgsAndThrowsMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::methodThatRequiresAllArgsAndThrowsMethod(args);
}

static v8::Handle<v8::Value> serializedValueMethod(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    bool serializedArgDidThrow = false;
    RefPtr<SerializedScriptValue> serializedArg = SerializedScriptValue::create(args[0], 0, 0, serializedArgDidThrow, args.GetIsolate());
    if (serializedArgDidThrow)
        return v8Undefined();
    imp->serializedValue(serializedArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> serializedValueMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::serializedValueMethod(args);
}

static v8::Handle<v8::Value> optionsObjectMethod(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(Dictionary, oo, Dictionary(args[0], args.GetIsolate()));
    if (!oo.isUndefinedOrNull() && !oo.isObject())
        return throwTypeError("Not an object.", args.GetIsolate());
    V8TRYCATCH(Dictionary, ooo, Dictionary(args[1], args.GetIsolate()));
    if (!ooo.isUndefinedOrNull() && !ooo.isObject())
        return throwTypeError("Not an object.", args.GetIsolate());
    imp->optionsObject(oo, ooo);
    return v8Undefined();
}

static v8::Handle<v8::Value> optionsObjectMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::optionsObjectMethod(args);
}

static v8::Handle<v8::Value> methodWithExceptionMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    imp->methodWithException(ec);
    if (UNLIKELY(ec))
        goto fail;
    return v8Undefined();
    }
    fail:
    return setDOMException(ec, args.GetIsolate());
}

static v8::Handle<v8::Value> methodWithExceptionMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::methodWithExceptionMethod(args);
}

static v8::Handle<v8::Value> customMethodMethodCallback(const v8::Arguments& args)
{
    UseCounter::count(activeDOMWindow(BindingState::instance()), UseCounter::CustomTestFeature);
    return V8TestObj::customMethodMethodCustom(args);
}

static v8::Handle<v8::Value> customMethodWithArgsMethodCallback(const v8::Arguments& args)
{
    return V8TestObj::customMethodWithArgsMethodCustom(args);
}

static v8::Handle<v8::Value> addEventListenerMethod(const v8::Arguments& args)
{
    RefPtr<EventListener> listener = V8EventListenerList::getEventListener(args[1], false, ListenerFindOrCreate);
    if (listener) {
        V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<WithNullCheck>, stringResource, args[0]);
        V8TestObj::toNative(args.Holder())->addEventListener(stringResource, listener, args[2]->BooleanValue());
        createHiddenDependency(args.Holder(), args[1], V8TestObj::eventListenerCacheIndex, args.GetIsolate());
    }
    return v8Undefined();
}

static v8::Handle<v8::Value> addEventListenerMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::addEventListenerMethod(args);
}

static v8::Handle<v8::Value> removeEventListenerMethod(const v8::Arguments& args)
{
    RefPtr<EventListener> listener = V8EventListenerList::getEventListener(args[1], false, ListenerFindOnly);
    if (listener) {
        V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<WithNullCheck>, stringResource, args[0]);
        V8TestObj::toNative(args.Holder())->removeEventListener(stringResource, listener.get(), args[2]->BooleanValue());
        removeHiddenDependency(args.Holder(), args[1], V8TestObj::eventListenerCacheIndex, args.GetIsolate());
    }
    return v8Undefined();
}

static v8::Handle<v8::Value> removeEventListenerMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::removeEventListenerMethod(args);
}

static v8::Handle<v8::Value> withScriptStateVoidMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    imp->withScriptStateVoid(&state);
    if (state.hadException()) {
        v8::Local<v8::Value> exception = state.exception();
        state.clearException();
        return throwError(exception, args.GetIsolate());
    }
    return v8Undefined();
}

static v8::Handle<v8::Value> withScriptStateVoidMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::withScriptStateVoidMethod(args);
}

static v8::Handle<v8::Value> withScriptStateObjMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    RefPtr<TestObj> result = imp->withScriptStateObj(&state);
    if (state.hadException()) {
        v8::Local<v8::Value> exception = state.exception();
        state.clearException();
        return throwError(exception, args.GetIsolate());
    }
    return toV8(result.release(), args.Holder(), args.GetIsolate());
}

static v8::Handle<v8::Value> withScriptStateObjMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::withScriptStateObjMethod(args);
}

static v8::Handle<v8::Value> withScriptStateVoidExceptionMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    imp->withScriptStateVoidException(&state, ec);
    if (UNLIKELY(ec))
        goto fail;
    if (state.hadException()) {
        v8::Local<v8::Value> exception = state.exception();
        state.clearException();
        return throwError(exception, args.GetIsolate());
    }
    return v8Undefined();
    }
    fail:
    return setDOMException(ec, args.GetIsolate());
}

static v8::Handle<v8::Value> withScriptStateVoidExceptionMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::withScriptStateVoidExceptionMethod(args);
}

static v8::Handle<v8::Value> withScriptStateObjExceptionMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    RefPtr<TestObj> result = imp->withScriptStateObjException(&state, ec);
    if (UNLIKELY(ec))
        goto fail;
    if (state.hadException()) {
        v8::Local<v8::Value> exception = state.exception();
        state.clearException();
        return throwError(exception, args.GetIsolate());
    }
    return toV8(result.release(), args.Holder(), args.GetIsolate());
    }
    fail:
    return setDOMException(ec, args.GetIsolate());
}

static v8::Handle<v8::Value> withScriptStateObjExceptionMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::withScriptStateObjExceptionMethod(args);
}

static v8::Handle<v8::Value> withScriptExecutionContextMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    imp->withScriptExecutionContext(scriptContext);
    return v8Undefined();
}

static v8::Handle<v8::Value> withScriptExecutionContextMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::withScriptExecutionContextMethod(args);
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    imp->withScriptExecutionContextAndScriptState(&state, scriptContext);
    if (state.hadException()) {
        v8::Local<v8::Value> exception = state.exception();
        state.clearException();
        return throwError(exception, args.GetIsolate());
    }
    return v8Undefined();
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::withScriptExecutionContextAndScriptStateMethod(args);
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateObjExceptionMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    RefPtr<TestObj> result = imp->withScriptExecutionContextAndScriptStateObjException(&state, scriptContext, ec);
    if (UNLIKELY(ec))
        goto fail;
    if (state.hadException()) {
        v8::Local<v8::Value> exception = state.exception();
        state.clearException();
        return throwError(exception, args.GetIsolate());
    }
    return toV8(result.release(), args.Holder(), args.GetIsolate());
    }
    fail:
    return setDOMException(ec, args.GetIsolate());
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateObjExceptionMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::withScriptExecutionContextAndScriptStateObjExceptionMethod(args);
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateWithSpacesMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ScriptState* currentState = ScriptState::current();
    if (!currentState)
        return v8Undefined();
    ScriptState& state = *currentState;
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    RefPtr<TestObj> result = imp->withScriptExecutionContextAndScriptStateWithSpaces(&state, scriptContext);
    if (state.hadException()) {
        v8::Local<v8::Value> exception = state.exception();
        state.clearException();
        return throwError(exception, args.GetIsolate());
    }
    return toV8(result.release(), args.Holder(), args.GetIsolate());
}

static v8::Handle<v8::Value> withScriptExecutionContextAndScriptStateWithSpacesMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::withScriptExecutionContextAndScriptStateWithSpacesMethod(args);
}

static v8::Handle<v8::Value> methodWithOptionalArgMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    if (args.Length() <= 0) {
        imp->methodWithOptionalArg();
        return v8Undefined();
    }
    V8TRYCATCH(int, opt, toInt32(args[0]));
    imp->methodWithOptionalArg(opt);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithOptionalArgMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::methodWithOptionalArgMethod(args);
}

static v8::Handle<v8::Value> methodWithNonOptionalArgAndOptionalArgMethod(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, nonOpt, toInt32(args[0]));
    if (args.Length() <= 1) {
        imp->methodWithNonOptionalArgAndOptionalArg(nonOpt);
        return v8Undefined();
    }
    V8TRYCATCH(int, opt, toInt32(args[1]));
    imp->methodWithNonOptionalArgAndOptionalArg(nonOpt, opt);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithNonOptionalArgAndOptionalArgMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::methodWithNonOptionalArgAndOptionalArgMethod(args);
}

static v8::Handle<v8::Value> methodWithNonOptionalArgAndTwoOptionalArgsMethod(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, nonOpt, toInt32(args[0]));
    if (args.Length() <= 1) {
        imp->methodWithNonOptionalArgAndTwoOptionalArgs(nonOpt);
        return v8Undefined();
    }
    V8TRYCATCH(int, opt1, toInt32(args[1]));
    if (args.Length() <= 2) {
        imp->methodWithNonOptionalArgAndTwoOptionalArgs(nonOpt, opt1);
        return v8Undefined();
    }
    V8TRYCATCH(int, opt2, toInt32(args[2]));
    imp->methodWithNonOptionalArgAndTwoOptionalArgs(nonOpt, opt1, opt2);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithNonOptionalArgAndTwoOptionalArgsMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::methodWithNonOptionalArgAndTwoOptionalArgsMethod(args);
}

static v8::Handle<v8::Value> methodWithOptionalStringMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    if (args.Length() <= 0) {
        imp->methodWithOptionalString();
        return v8Undefined();
    }
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, str, args[0]);
    imp->methodWithOptionalString(str);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithOptionalStringMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::methodWithOptionalStringMethod(args);
}

static v8::Handle<v8::Value> methodWithOptionalStringIsUndefinedMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, str, args[0]);
    imp->methodWithOptionalStringIsUndefined(str);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithOptionalStringIsUndefinedMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::methodWithOptionalStringIsUndefinedMethod(args);
}

static v8::Handle<v8::Value> methodWithOptionalStringIsNullStringMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, str, argumentOrNull(args, 0));
    imp->methodWithOptionalStringIsNullString(str);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithOptionalStringIsNullStringMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::methodWithOptionalStringIsNullStringMethod(args);
}

static v8::Handle<v8::Value> methodWithCallbackArgMethod(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    if (args.Length() <= 0 || !args[0]->IsFunction())
        return throwTypeError(0, args.GetIsolate());
    RefPtr<TestCallback> callback = V8TestCallback::create(args[0], getScriptExecutionContext());
    imp->methodWithCallbackArg(callback);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithCallbackArgMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::methodWithCallbackArgMethod(args);
}

static v8::Handle<v8::Value> methodWithNonCallbackArgAndCallbackArgMethod(const v8::Arguments& args)
{
    if (args.Length() < 2)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, nonCallback, toInt32(args[0]));
    if (args.Length() <= 1 || !args[1]->IsFunction())
        return throwTypeError(0, args.GetIsolate());
    RefPtr<TestCallback> callback = V8TestCallback::create(args[1], getScriptExecutionContext());
    imp->methodWithNonCallbackArgAndCallbackArg(nonCallback, callback);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithNonCallbackArgAndCallbackArgMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::methodWithNonCallbackArgAndCallbackArgMethod(args);
}

static v8::Handle<v8::Value> methodWithCallbackAndOptionalArgMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    RefPtr<TestCallback> callback;
    if (args.Length() > 0 && !args[0]->IsNull() && !args[0]->IsUndefined()) {
        if (!args[0]->IsFunction())
            return throwTypeError(0, args.GetIsolate());
        callback = V8TestCallback::create(args[0], getScriptExecutionContext());
    }
    imp->methodWithCallbackAndOptionalArg(callback);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithCallbackAndOptionalArgMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::methodWithCallbackAndOptionalArgMethod(args);
}

static v8::Handle<v8::Value> staticMethodWithCallbackAndOptionalArgMethod(const v8::Arguments& args)
{
    RefPtr<TestCallback> callback;
    if (args.Length() > 0 && !args[0]->IsNull() && !args[0]->IsUndefined()) {
        if (!args[0]->IsFunction())
            return throwTypeError(0, args.GetIsolate());
        callback = V8TestCallback::create(args[0], getScriptExecutionContext());
    }
    TestObj::staticMethodWithCallbackAndOptionalArg(callback);
    return v8Undefined();
}

static v8::Handle<v8::Value> staticMethodWithCallbackAndOptionalArgMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::staticMethodWithCallbackAndOptionalArgMethod(args);
}

static v8::Handle<v8::Value> staticMethodWithCallbackArgMethod(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    if (args.Length() <= 0 || !args[0]->IsFunction())
        return throwTypeError(0, args.GetIsolate());
    RefPtr<TestCallback> callback = V8TestCallback::create(args[0], getScriptExecutionContext());
    TestObj::staticMethodWithCallbackArg(callback);
    return v8Undefined();
}

static v8::Handle<v8::Value> staticMethodWithCallbackArgMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::staticMethodWithCallbackArgMethod(args);
}

static v8::Handle<v8::Value> methodWithEnforceRangeInt32Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH_WITH_TYPECHECK(int, value, toInt32(args[0], EnforceRange, ok), args.GetIsolate());
    imp->methodWithEnforceRangeInt32(value);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithEnforceRangeInt32MethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::methodWithEnforceRangeInt32Method(args);
}

static v8::Handle<v8::Value> methodWithEnforceRangeUInt32Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH_WITH_TYPECHECK(unsigned, value, toUInt32(args[0], EnforceRange, ok), args.GetIsolate());
    imp->methodWithEnforceRangeUInt32(value);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithEnforceRangeUInt32MethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::methodWithEnforceRangeUInt32Method(args);
}

static v8::Handle<v8::Value> methodWithEnforceRangeInt64Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH_WITH_TYPECHECK(long long, value, toInt64(args[0], EnforceRange, ok), args.GetIsolate());
    imp->methodWithEnforceRangeInt64(value);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithEnforceRangeInt64MethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::methodWithEnforceRangeInt64Method(args);
}

static v8::Handle<v8::Value> methodWithEnforceRangeUInt64Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH_WITH_TYPECHECK(unsigned long long, value, toUInt64(args[0], EnforceRange, ok), args.GetIsolate());
    imp->methodWithEnforceRangeUInt64(value);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithEnforceRangeUInt64MethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::methodWithEnforceRangeUInt64Method(args);
}

#if ENABLE(Condition1)

static v8::Handle<v8::Value> conditionalMethod1Method(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    return v8String(imp->conditionalMethod1(), args.GetIsolate(), ReturnUnsafeHandle);
}

#endif // ENABLE(Condition1)

#if ENABLE(Condition1)

static v8::Handle<v8::Value> conditionalMethod1MethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::conditionalMethod1Method(args);
}

#endif // ENABLE(Condition1)

#if ENABLE(Condition1) && ENABLE(Condition2)

static v8::Handle<v8::Value> conditionalMethod2Method(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    imp->conditionalMethod2();
    return v8Undefined();
}

#endif // ENABLE(Condition1) && ENABLE(Condition2)

#if ENABLE(Condition1) && ENABLE(Condition2)

static v8::Handle<v8::Value> conditionalMethod2MethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::conditionalMethod2Method(args);
}

#endif // ENABLE(Condition1) && ENABLE(Condition2)

#if ENABLE(Condition1) || ENABLE(Condition2)

static v8::Handle<v8::Value> conditionalMethod3Method(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    imp->conditionalMethod3();
    return v8Undefined();
}

#endif // ENABLE(Condition1) || ENABLE(Condition2)

#if ENABLE(Condition1) || ENABLE(Condition2)

static v8::Handle<v8::Value> conditionalMethod3MethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::conditionalMethod3Method(args);
}

#endif // ENABLE(Condition1) || ENABLE(Condition2)

static v8::Handle<v8::Value> overloadedMethod1Method(const v8::Arguments& args)
{
    if (args.Length() < 2)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(TestObj*, objArg, V8TestObj::HasInstance(args[0], args.GetIsolate(), worldType(args.GetIsolate())) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(args[0])) : 0);
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, strArg, args[1]);
    imp->overloadedMethod(objArg, strArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod2Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(TestObj*, objArg, V8TestObj::HasInstance(args[0], args.GetIsolate(), worldType(args.GetIsolate())) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(args[0])) : 0);
    if (args.Length() <= 1) {
        imp->overloadedMethod(objArg);
        return v8Undefined();
    }
    V8TRYCATCH(int, longArg, toInt32(args[1]));
    imp->overloadedMethod(objArg, longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod3Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, strArg, args[0]);
    imp->overloadedMethod(strArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod4Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(args[0]));
    imp->overloadedMethod(longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod5Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    if (args.Length() <= 0 || !args[0]->IsFunction())
        return throwTypeError(0, args.GetIsolate());
    RefPtr<TestCallback> callback = V8TestCallback::create(args[0], getScriptExecutionContext());
    imp->overloadedMethod(callback);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod6Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(RefPtr<DOMStringList>, listArg, toDOMStringList(args[0], args.GetIsolate()));
    imp->overloadedMethod(listArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod7Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(Vector<String>, arrayArg, toNativeArray<String>(args[0]));
    imp->overloadedMethod(arrayArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod8Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(TestObj*, objArg, V8TestObj::HasInstance(args[0], args.GetIsolate(), worldType(args.GetIsolate())) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(args[0])) : 0);
    imp->overloadedMethod(objArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod9Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(Vector<String>, arrayArg, toNativeArray<String>(args[0]));
    imp->overloadedMethod(arrayArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod10Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(Vector<unsigned>, arrayArg, toNativeArray<unsigned>(args[0]));
    imp->overloadedMethod(arrayArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethod11Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, strArg, args[0]);
    imp->overloadedMethod(strArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedMethodMethod(const v8::Arguments& args)
{
    if ((args.Length() == 2 && (args[0]->IsNull() || V8TestObj::HasInstance(args[0], args.GetIsolate(), worldType(args.GetIsolate()))) && (args[1]->IsNull() || args[1]->IsUndefined() || args[1]->IsString() || args[1]->IsObject())))
        return overloadedMethod1Method(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || V8TestObj::HasInstance(args[0], args.GetIsolate(), worldType(args.GetIsolate())))) || (args.Length() == 2 && (args[0]->IsNull() || V8TestObj::HasInstance(args[0], args.GetIsolate(), worldType(args.GetIsolate())))))
        return overloadedMethod2Method(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || args[0]->IsUndefined() || args[0]->IsString() || args[0]->IsObject())))
        return overloadedMethod3Method(args);
    if (args.Length() == 1)
        return overloadedMethod4Method(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || args[0]->IsFunction())))
        return overloadedMethod5Method(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || V8DOMStringList::HasInstance(args[0], args.GetIsolate(), worldType(args.GetIsolate())))))
        return overloadedMethod6Method(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || args[0]->IsArray())))
        return overloadedMethod7Method(args);
    if ((args.Length() == 1 && (V8TestObj::HasInstance(args[0], args.GetIsolate(), worldType(args.GetIsolate())))))
        return overloadedMethod8Method(args);
    if ((args.Length() == 1 && (args[0]->IsArray())))
        return overloadedMethod9Method(args);
    if ((args.Length() == 1 && (args[0]->IsArray())))
        return overloadedMethod10Method(args);
    if (args.Length() == 1)
        return overloadedMethod11Method(args);
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    return throwTypeError(0, args.GetIsolate());
}

static v8::Handle<v8::Value> overloadedMethodMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::overloadedMethodMethod(args);
}

static v8::Handle<v8::Value> classMethodMethod(const v8::Arguments& args)
{
    TestObj::classMethod();
    return v8Undefined();
}

static v8::Handle<v8::Value> classMethodMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::classMethodMethod(args);
}

static v8::Handle<v8::Value> classMethodWithOptionalMethod(const v8::Arguments& args)
{
    if (args.Length() <= 0) {
        return v8Integer(TestObj::classMethodWithOptional(), args.GetIsolate());
    }
    V8TRYCATCH(int, arg, toInt32(args[0]));
    return v8Integer(TestObj::classMethodWithOptional(arg), args.GetIsolate());
}

static v8::Handle<v8::Value> classMethodWithOptionalMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::classMethodWithOptionalMethod(args);
}

static v8::Handle<v8::Value> classMethod2MethodCallback(const v8::Arguments& args)
{
    return V8TestObj::classMethod2MethodCustom(args);
}

#if ENABLE(Condition1)

static v8::Handle<v8::Value> overloadedMethod11Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    V8TRYCATCH(int, arg, toInt32(args[0]));
    TestObj::overloadedMethod1(arg);
    return v8Undefined();
}

#endif // ENABLE(Condition1)

#if ENABLE(Condition1)

static v8::Handle<v8::Value> overloadedMethod12Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, type, args[0]);
    TestObj::overloadedMethod1(type);
    return v8Undefined();
}

#endif // ENABLE(Condition1)

#if ENABLE(Condition1)

static v8::Handle<v8::Value> overloadedMethod1Method(const v8::Arguments& args)
{
    if (args.Length() == 1)
        return overloadedMethod11Method(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || args[0]->IsUndefined() || args[0]->IsString() || args[0]->IsObject())))
        return overloadedMethod12Method(args);
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    return throwTypeError(0, args.GetIsolate());
}

#endif // ENABLE(Condition1)

#if ENABLE(Condition1)

static v8::Handle<v8::Value> overloadedMethod1MethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::overloadedMethod1Method(args);
}

#endif // ENABLE(Condition1)

static v8::Handle<v8::Value> classMethodWithClampMethod(const v8::Arguments& args)
{
    if (args.Length() < 2)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    unsigned short objArgsShort = 0;
    V8TRYCATCH(double, objArgsShortNativeValue, args[0]->NumberValue());
    if (!std::isnan(objArgsShortNativeValue))
        objArgsShort = clampTo<unsigned short>(objArgsShortNativeValue);
    unsigned long objArgsLong = 0;
    V8TRYCATCH(double, objArgsLongNativeValue, args[1]->NumberValue());
    if (!std::isnan(objArgsLongNativeValue))
        objArgsLong = clampTo<unsigned long>(objArgsLongNativeValue);
    imp->classMethodWithClamp(objArgsShort, objArgsLong);
    return v8Undefined();
}

static v8::Handle<v8::Value> classMethodWithClampMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::classMethodWithClampMethod(args);
}

static v8::Handle<v8::Value> enabledAtRuntimeMethod1Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(args[0]));
    imp->enabledAtRuntimeMethod1(longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> enabledAtRuntimeMethod1MethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::enabledAtRuntimeMethod1Method(args);
}

static v8::Handle<v8::Value> enabledAtRuntimeMethod2Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(args[0]));
    imp->enabledAtRuntimeMethod2(longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> enabledAtRuntimeMethod2MethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::enabledAtRuntimeMethod2Method(args);
}

static v8::Handle<v8::Value> enabledPerContextMethod1Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(args[0]));
    imp->enabledPerContextMethod1(longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> enabledPerContextMethod1MethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::enabledPerContextMethod1Method(args);
}

static v8::Handle<v8::Value> enabledPerContextMethod2Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(args[0]));
    imp->enabledPerContextMethod2(longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> enabledPerContextMethod2MethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::enabledPerContextMethod2Method(args);
}

static v8::Handle<v8::Value> methodWithUnsignedLongSequenceMethod(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(Vector<unsigned>, unsignedLongSequence, toNativeArray<unsigned>(args[0]));
    imp->methodWithUnsignedLongSequence(unsignedLongSequence);
    return v8Undefined();
}

static v8::Handle<v8::Value> methodWithUnsignedLongSequenceMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::methodWithUnsignedLongSequenceMethod(args);
}

static v8::Handle<v8::Value> stringArrayFunctionMethod(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    V8TRYCATCH(Vector<String>, values, toNativeArray<String>(args[0]));
    Vector<String> result = imp->stringArrayFunction(values, ec);
    if (UNLIKELY(ec))
        goto fail;
    return v8Array(result, args.GetIsolate());
    }
    fail:
    return setDOMException(ec, args.GetIsolate());
}

static v8::Handle<v8::Value> stringArrayFunctionMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::stringArrayFunctionMethod(args);
}

static v8::Handle<v8::Value> domStringListFunctionMethod(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    V8TRYCATCH(RefPtr<DOMStringList>, values, toDOMStringList(args[0], args.GetIsolate()));
    RefPtr<DOMStringList> result = imp->domStringListFunction(values, ec);
    if (UNLIKELY(ec))
        goto fail;
    return toV8(result.release(), args.Holder(), args.GetIsolate());
    }
    fail:
    return setDOMException(ec, args.GetIsolate());
}

static v8::Handle<v8::Value> domStringListFunctionMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::domStringListFunctionMethod(args);
}

static v8::Handle<v8::Value> getSVGDocumentMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    if (!BindingSecurity::shouldAllowAccessToNode(BindingState::instance(), imp->getSVGDocument(ec)))
        return v8::Handle<v8::Value>(v8Null(args.GetIsolate()));
    RefPtr<SVGDocument> result = imp->getSVGDocument(ec);
    if (UNLIKELY(ec))
        goto fail;
    return toV8(result.release(), args.Holder(), args.GetIsolate());
    }
    fail:
    return setDOMException(ec, args.GetIsolate());
}

static v8::Handle<v8::Value> getSVGDocumentMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::getSVGDocumentMethod(args);
}

static v8::Handle<v8::Value> convert1Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(TestNode*, value, V8TestNode::HasInstance(args[0], args.GetIsolate(), worldType(args.GetIsolate())) ? V8TestNode::toNative(v8::Handle<v8::Object>::Cast(args[0])) : 0);
    imp->convert1(value);
    return v8Undefined();
}

static v8::Handle<v8::Value> convert1MethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::convert1Method(args);
}

static v8::Handle<v8::Value> convert2Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(TestNode*, value, V8TestNode::HasInstance(args[0], args.GetIsolate(), worldType(args.GetIsolate())) ? V8TestNode::toNative(v8::Handle<v8::Object>::Cast(args[0])) : 0);
    imp->convert2(value);
    return v8Undefined();
}

static v8::Handle<v8::Value> convert2MethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::convert2Method(args);
}

static v8::Handle<v8::Value> convert4Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(TestNode*, value, V8TestNode::HasInstance(args[0], args.GetIsolate(), worldType(args.GetIsolate())) ? V8TestNode::toNative(v8::Handle<v8::Object>::Cast(args[0])) : 0);
    imp->convert4(value);
    return v8Undefined();
}

static v8::Handle<v8::Value> convert4MethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::convert4Method(args);
}

static v8::Handle<v8::Value> convert5Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(TestNode*, value, V8TestNode::HasInstance(args[0], args.GetIsolate(), worldType(args.GetIsolate())) ? V8TestNode::toNative(v8::Handle<v8::Object>::Cast(args[0])) : 0);
    imp->convert5(value);
    return v8Undefined();
}

static v8::Handle<v8::Value> convert5MethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::convert5Method(args);
}

static v8::Handle<v8::Value> mutablePointFunctionMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    return toV8(WTF::getPtr(SVGPropertyTearOff<FloatPoint>::create(imp->mutablePointFunction())), args.Holder(), args.GetIsolate());
}

static v8::Handle<v8::Value> mutablePointFunctionMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::mutablePointFunctionMethod(args);
}

static v8::Handle<v8::Value> immutablePointFunctionMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    return toV8(WTF::getPtr(SVGPropertyTearOff<FloatPoint>::create(imp->immutablePointFunction())), args.Holder(), args.GetIsolate());
}

static v8::Handle<v8::Value> immutablePointFunctionMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::immutablePointFunctionMethod(args);
}

static v8::Handle<v8::Value> orangeMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    imp->banana();
    return v8Undefined();
}

static v8::Handle<v8::Value> orangeMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::orangeMethod(args);
}

static v8::Handle<v8::Value> strictFunctionMethod(const v8::Arguments& args)
{
    if (args.Length() < 3)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, str, args[0]);
    V8TRYCATCH(float, a, static_cast<float>(args[1]->NumberValue()));
    V8TRYCATCH(int, b, toInt32(args[2]));
    RefPtr<bool> result = imp->strictFunction(str, a, b, ec);
    if (UNLIKELY(ec))
        goto fail;
    return toV8(result.release(), args.Holder(), args.GetIsolate());
    }
    fail:
    return setDOMException(ec, args.GetIsolate());
}

static v8::Handle<v8::Value> strictFunctionMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::strictFunctionMethod(args);
}

static v8::Handle<v8::Value> variadicStringMethodMethod(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, head, args[0]);
    V8TRYCATCH(Vector<String>, tail, toNativeArguments<String>(args, 1));
    imp->variadicStringMethod(head, tail);
    return v8Undefined();
}

static v8::Handle<v8::Value> variadicStringMethodMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::variadicStringMethodMethod(args);
}

static v8::Handle<v8::Value> variadicDoubleMethodMethod(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(double, head, static_cast<double>(args[0]->NumberValue()));
    V8TRYCATCH(Vector<double>, tail, toNativeArguments<double>(args, 1));
    imp->variadicDoubleMethod(head, tail);
    return v8Undefined();
}

static v8::Handle<v8::Value> variadicDoubleMethodMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::variadicDoubleMethodMethod(args);
}

static v8::Handle<v8::Value> variadicNodeMethodMethod(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(Node*, head, V8Node::HasInstance(args[0], args.GetIsolate(), worldType(args.GetIsolate())) ? V8Node::toNative(v8::Handle<v8::Object>::Cast(args[0])) : 0);
    Vector<RefPtr<Node> > tail;
    for (int i = 1; i < args.Length(); ++i) {
        if (!V8Node::HasInstance(args[i], args.GetIsolate(), worldType(args.GetIsolate())))
            return throwTypeError(0, args.GetIsolate());
        tail.append(V8Node::toNative(v8::Handle<v8::Object>::Cast(args[i])));
    }
    imp->variadicNodeMethod(head, tail);
    return v8Undefined();
}

static v8::Handle<v8::Value> variadicNodeMethodMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::variadicNodeMethodMethod(args);
}

static v8::Handle<v8::Value> perWorldMethodMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    imp->perWorldMethod();
    return v8Undefined();
}

static v8::Handle<v8::Value> perWorldMethodMethodForMainWorld(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    imp->perWorldMethod();
    return v8Undefined();
}

static v8::Handle<v8::Value> perWorldMethodMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::perWorldMethodMethod(args);
}

static v8::Handle<v8::Value> perWorldMethodMethodCallbackForMainWorld(const v8::Arguments& args)
{
    return TestObjV8Internal::perWorldMethodMethodForMainWorld(args);
}

static v8::Handle<v8::Value> overloadedPerWorldMethod1Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(args[0]));
    imp->overloadedPerWorldMethod(longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedPerWorldMethod1MethodForMainWorld(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(args[0]));
    imp->overloadedPerWorldMethod(longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedPerWorldMethod2Method(const v8::Arguments& args)
{
    if (args.Length() < 2)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, strArg, args[0]);
    V8TRYCATCH(int, longArg, toInt32(args[1]));
    imp->overloadedPerWorldMethod(strArg, longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedPerWorldMethod2MethodForMainWorld(const v8::Arguments& args)
{
    if (args.Length() < 2)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, strArg, args[0]);
    V8TRYCATCH(int, longArg, toInt32(args[1]));
    imp->overloadedPerWorldMethod(strArg, longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedPerWorldMethodMethod(const v8::Arguments& args)
{
    if (args.Length() == 1)
        return overloadedPerWorldMethod1Method(args);
    if (args.Length() == 2)
        return overloadedPerWorldMethod2Method(args);
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    return throwTypeError(0, args.GetIsolate());
}

static v8::Handle<v8::Value> overloadedPerWorldMethodMethodForMainWorld(const v8::Arguments& args)
{
    if (args.Length() == 1)
        return overloadedPerWorldMethod1MethodForMainWorld(args);
    if (args.Length() == 2)
        return overloadedPerWorldMethod2MethodForMainWorld(args);
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    return throwTypeError(0, args.GetIsolate());
}

static v8::Handle<v8::Value> overloadedPerWorldMethodMethodCallback(const v8::Arguments& args)
{
    return TestObjV8Internal::overloadedPerWorldMethodMethod(args);
}

static v8::Handle<v8::Value> overloadedPerWorldMethodMethodCallbackForMainWorld(const v8::Arguments& args)
{
    return TestObjV8Internal::overloadedPerWorldMethodMethodForMainWorld(args);
}

static v8::Handle<v8::Value> activityLoggedMethod1Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(args[0]));
    imp->activityLoggedMethod1(longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> activityLoggedMethod1MethodCallback(const v8::Arguments& args)
{
    V8PerContextData* contextData = V8PerContextData::from(args.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger()) {
        Vector<v8::Handle<v8::Value> > loggerArgs = toVectorOfArguments(args);
        contextData->activityLogger()->log("TestObject.activityLoggedMethod1", args.Length(), loggerArgs.data(), "Method");
    }
    return TestObjV8Internal::activityLoggedMethod1Method(args);
}

static v8::Handle<v8::Value> activityLoggedMethod2Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(args[0]));
    imp->activityLoggedMethod2(longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> activityLoggedMethod2MethodForMainWorld(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(args[0]));
    imp->activityLoggedMethod2(longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> activityLoggedMethod2MethodCallback(const v8::Arguments& args)
{
    V8PerContextData* contextData = V8PerContextData::from(args.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger()) {
        Vector<v8::Handle<v8::Value> > loggerArgs = toVectorOfArguments(args);
        contextData->activityLogger()->log("TestObject.activityLoggedMethod2", args.Length(), loggerArgs.data(), "Method");
    }
    return TestObjV8Internal::activityLoggedMethod2Method(args);
}

static v8::Handle<v8::Value> activityLoggedMethod2MethodCallbackForMainWorld(const v8::Arguments& args)
{
    V8PerContextData* contextData = V8PerContextData::from(args.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger()) {
        Vector<v8::Handle<v8::Value> > loggerArgs = toVectorOfArguments(args);
        contextData->activityLogger()->log("TestObject.activityLoggedMethod2", args.Length(), loggerArgs.data(), "Method");
    }
    return TestObjV8Internal::activityLoggedMethod2MethodForMainWorld(args);
}

static v8::Handle<v8::Value> activityLoggedInIsolatedWorldMethodMethod(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(args[0]));
    imp->activityLoggedInIsolatedWorldMethod(longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> activityLoggedInIsolatedWorldMethodMethodForMainWorld(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(args[0]));
    imp->activityLoggedInIsolatedWorldMethod(longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> activityLoggedInIsolatedWorldMethodMethodCallback(const v8::Arguments& args)
{
    V8PerContextData* contextData = V8PerContextData::from(args.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger()) {
        Vector<v8::Handle<v8::Value> > loggerArgs = toVectorOfArguments(args);
        contextData->activityLogger()->log("TestObject.activityLoggedInIsolatedWorldMethod", args.Length(), loggerArgs.data(), "Method");
    }
    return TestObjV8Internal::activityLoggedInIsolatedWorldMethodMethod(args);
}

static v8::Handle<v8::Value> activityLoggedInIsolatedWorldMethodMethodCallbackForMainWorld(const v8::Arguments& args)
{
    return TestObjV8Internal::activityLoggedInIsolatedWorldMethodMethodForMainWorld(args);
}

static v8::Handle<v8::Value> overloadedActivityLoggedMethod1Method(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(args[0]));
    imp->overloadedActivityLoggedMethod(longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedActivityLoggedMethod1MethodForMainWorld(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH(int, longArg, toInt32(args[0]));
    imp->overloadedActivityLoggedMethod(longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedActivityLoggedMethod2Method(const v8::Arguments& args)
{
    if (args.Length() < 2)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, strArg, args[0]);
    V8TRYCATCH(int, longArg, toInt32(args[1]));
    imp->overloadedActivityLoggedMethod(strArg, longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedActivityLoggedMethod2MethodForMainWorld(const v8::Arguments& args)
{
    if (args.Length() < 2)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8TRYCATCH_FOR_V8STRINGRESOURCE(V8StringResource<>, strArg, args[0]);
    V8TRYCATCH(int, longArg, toInt32(args[1]));
    imp->overloadedActivityLoggedMethod(strArg, longArg);
    return v8Undefined();
}

static v8::Handle<v8::Value> overloadedActivityLoggedMethodMethod(const v8::Arguments& args)
{
    if (args.Length() == 1)
        return overloadedActivityLoggedMethod1Method(args);
    if (args.Length() == 2)
        return overloadedActivityLoggedMethod2Method(args);
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    return throwTypeError(0, args.GetIsolate());
}

static v8::Handle<v8::Value> overloadedActivityLoggedMethodMethodForMainWorld(const v8::Arguments& args)
{
    if (args.Length() == 1)
        return overloadedActivityLoggedMethod1MethodForMainWorld(args);
    if (args.Length() == 2)
        return overloadedActivityLoggedMethod2MethodForMainWorld(args);
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    return throwTypeError(0, args.GetIsolate());
}

static v8::Handle<v8::Value> overloadedActivityLoggedMethodMethodCallback(const v8::Arguments& args)
{
    V8PerContextData* contextData = V8PerContextData::from(args.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger()) {
        Vector<v8::Handle<v8::Value> > loggerArgs = toVectorOfArguments(args);
        contextData->activityLogger()->log("TestObject.overloadedActivityLoggedMethod", args.Length(), loggerArgs.data(), "Method");
    }
    return TestObjV8Internal::overloadedActivityLoggedMethodMethod(args);
}

static v8::Handle<v8::Value> overloadedActivityLoggedMethodMethodCallbackForMainWorld(const v8::Arguments& args)
{
    V8PerContextData* contextData = V8PerContextData::from(args.GetIsolate()->GetCurrentContext());
    if (contextData && contextData->activityLogger()) {
        Vector<v8::Handle<v8::Value> > loggerArgs = toVectorOfArguments(args);
        contextData->activityLogger()->log("TestObject.overloadedActivityLoggedMethod", args.Length(), loggerArgs.data(), "Method");
    }
    return TestObjV8Internal::overloadedActivityLoggedMethodMethodForMainWorld(args);
}

static v8::Handle<v8::Value> deprecatedMethodMethod(const v8::Arguments& args)
{
    TestObj* imp = V8TestObj::toNative(args.Holder());
    imp->deprecatedMethod();
    return v8Undefined();
}

static v8::Handle<v8::Value> deprecatedMethodMethodCallback(const v8::Arguments& args)
{
    UseCounter::countDeprecation(activeDOMWindow(BindingState::instance()), UseCounter::Method);
    return TestObjV8Internal::deprecatedMethodMethod(args);
}

static v8::Handle<v8::Value> deprecatedStaticMethodMethod(const v8::Arguments& args)
{
    TestObj::deprecatedStaticMethod();
    return v8Undefined();
}

static v8::Handle<v8::Value> deprecatedStaticMethodMethodCallback(const v8::Arguments& args)
{
    UseCounter::countDeprecation(activeDOMWindow(BindingState::instance()), UseCounter::StaticMethod);
    return TestObjV8Internal::deprecatedStaticMethodMethod(args);
}

static v8::Handle<v8::Value> constructor(const v8::Arguments& args)
{
    if (args.Length() < 1)
        return throwNotEnoughArgumentsError(args.GetIsolate());
    if (args.Length() <= 0 || !args[0]->IsFunction())
        return throwTypeError(0, args.GetIsolate());
    RefPtr<TestCallback> testCallback = V8TestCallback::create(args[0], getScriptExecutionContext());

    RefPtr<TestObj> impl = TestObj::create(testCallback);
    v8::Handle<v8::Object> wrapper = args.Holder();

    V8DOMWrapper::associateObjectWithWrapper(impl.release(), &V8TestObj::info, wrapper, args.GetIsolate(), WrapperConfiguration::Dependent);
    return wrapper;
}

} // namespace TestObjV8Internal

static const V8DOMConfiguration::BatchedAttribute V8TestObjAttrs[] = {
    // Attribute 'readOnlyLongAttr' (Type: 'readonly attribute' ExtAttr: '')
    {"readOnlyLongAttr", TestObjV8Internal::readOnlyLongAttrAttrGetterCallback, 0, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'readOnlyStringAttr' (Type: 'readonly attribute' ExtAttr: '')
    {"readOnlyStringAttr", TestObjV8Internal::readOnlyStringAttrAttrGetterCallback, 0, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'readOnlyTestObjAttr' (Type: 'readonly attribute' ExtAttr: '')
    {"readOnlyTestObjAttr", TestObjV8Internal::readOnlyTestObjAttrAttrGetterCallback, 0, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'staticReadOnlyLongAttr' (Type: 'readonly attribute' ExtAttr: '')
    {"staticReadOnlyLongAttr", TestObjV8Internal::staticReadOnlyLongAttrAttrGetterCallback, 0, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'staticStringAttr' (Type: 'attribute' ExtAttr: '')
    {"staticStringAttr", TestObjV8Internal::staticStringAttrAttrGetterCallback, TestObjV8Internal::staticStringAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'TestSubObj' (Type: 'readonly attribute' ExtAttr: '')
    {"TestSubObj", TestObjV8Internal::TestObjConstructorGetter, 0, 0, 0, &V8TestSubObj::info, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None | v8::DontEnum), 0 /* on instance */},
    // Attribute 'enumAttr' (Type: 'attribute' ExtAttr: '')
    {"enumAttr", TestObjV8Internal::enumAttrAttrGetterCallback, TestObjV8Internal::enumAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'readOnlyEnumAttr' (Type: 'readonly attribute' ExtAttr: '')
    {"readOnlyEnumAttr", TestObjV8Internal::readOnlyEnumAttrAttrGetterCallback, 0, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'shortAttr' (Type: 'attribute' ExtAttr: '')
    {"shortAttr", TestObjV8Internal::shortAttrAttrGetterCallback, TestObjV8Internal::shortAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'unsignedShortAttr' (Type: 'attribute' ExtAttr: '')
    {"unsignedShortAttr", TestObjV8Internal::unsignedShortAttrAttrGetterCallback, TestObjV8Internal::unsignedShortAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'longAttr' (Type: 'attribute' ExtAttr: '')
    {"longAttr", TestObjV8Internal::longAttrAttrGetterCallback, TestObjV8Internal::longAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'longLongAttr' (Type: 'attribute' ExtAttr: '')
    {"longLongAttr", TestObjV8Internal::longLongAttrAttrGetterCallback, TestObjV8Internal::longLongAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'unsignedLongLongAttr' (Type: 'attribute' ExtAttr: '')
    {"unsignedLongLongAttr", TestObjV8Internal::unsignedLongLongAttrAttrGetterCallback, TestObjV8Internal::unsignedLongLongAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'stringAttr' (Type: 'attribute' ExtAttr: '')
    {"stringAttr", TestObjV8Internal::stringAttrAttrGetterCallback, TestObjV8Internal::stringAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'testObjAttr' (Type: 'attribute' ExtAttr: 'MeasureAs')
    {"testObjAttr", TestObjV8Internal::testObjAttrAttrGetterCallback, TestObjV8Internal::testObjAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'XMLObjAttr' (Type: 'attribute' ExtAttr: '')
    {"XMLObjAttr", TestObjV8Internal::XMLObjAttrAttrGetterCallback, TestObjV8Internal::XMLObjAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'create' (Type: 'attribute' ExtAttr: '')
    {"create", TestObjV8Internal::createAttrGetterCallback, TestObjV8Internal::createAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedStringAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedStringAttr", TestObjV8Internal::reflectedStringAttrAttrGetterCallback, TestObjV8Internal::reflectedStringAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedIntegralAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedIntegralAttr", TestObjV8Internal::reflectedIntegralAttrAttrGetterCallback, TestObjV8Internal::reflectedIntegralAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedUnsignedIntegralAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedUnsignedIntegralAttr", TestObjV8Internal::reflectedUnsignedIntegralAttrAttrGetterCallback, TestObjV8Internal::reflectedUnsignedIntegralAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedBooleanAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedBooleanAttr", TestObjV8Internal::reflectedBooleanAttrAttrGetterCallback, TestObjV8Internal::reflectedBooleanAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedURLAttr' (Type: 'attribute' ExtAttr: 'URL Reflect')
    {"reflectedURLAttr", TestObjV8Internal::reflectedURLAttrAttrGetterCallback, TestObjV8Internal::reflectedURLAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedStringAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedStringAttr", TestObjV8Internal::reflectedStringAttrAttrGetterCallback, TestObjV8Internal::reflectedStringAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedCustomIntegralAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedCustomIntegralAttr", TestObjV8Internal::reflectedCustomIntegralAttrAttrGetterCallback, TestObjV8Internal::reflectedCustomIntegralAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedCustomBooleanAttr' (Type: 'attribute' ExtAttr: 'Reflect')
    {"reflectedCustomBooleanAttr", TestObjV8Internal::reflectedCustomBooleanAttrAttrGetterCallback, TestObjV8Internal::reflectedCustomBooleanAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'reflectedCustomURLAttr' (Type: 'attribute' ExtAttr: 'URL Reflect')
    {"reflectedCustomURLAttr", TestObjV8Internal::reflectedCustomURLAttrAttrGetterCallback, TestObjV8Internal::reflectedCustomURLAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'typedArrayAttr' (Type: 'attribute' ExtAttr: '')
    {"typedArrayAttr", TestObjV8Internal::typedArrayAttrAttrGetterCallback, TestObjV8Internal::typedArrayAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'attrWithGetterException' (Type: 'attribute' ExtAttr: 'GetterRaisesException')
    {"attrWithGetterException", TestObjV8Internal::attrWithGetterExceptionAttrGetterCallback, TestObjV8Internal::attrWithGetterExceptionAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'attrWithSetterException' (Type: 'attribute' ExtAttr: 'SetterRaisesException')
    {"attrWithSetterException", TestObjV8Internal::attrWithSetterExceptionAttrGetterCallback, TestObjV8Internal::attrWithSetterExceptionAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'stringAttrWithGetterException' (Type: 'attribute' ExtAttr: 'GetterRaisesException')
    {"stringAttrWithGetterException", TestObjV8Internal::stringAttrWithGetterExceptionAttrGetterCallback, TestObjV8Internal::stringAttrWithGetterExceptionAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'stringAttrWithSetterException' (Type: 'attribute' ExtAttr: 'SetterRaisesException')
    {"stringAttrWithSetterException", TestObjV8Internal::stringAttrWithSetterExceptionAttrGetterCallback, TestObjV8Internal::stringAttrWithSetterExceptionAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'customAttr' (Type: 'attribute' ExtAttr: 'Custom')
    {"customAttr", TestObjV8Internal::customAttrAttrGetterCallback, TestObjV8Internal::customAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptStateAttribute' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptStateAttribute", TestObjV8Internal::withScriptStateAttributeAttrGetterCallback, TestObjV8Internal::withScriptStateAttributeAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptExecutionContextAttribute' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptExecutionContextAttribute", TestObjV8Internal::withScriptExecutionContextAttributeAttrGetterCallback, TestObjV8Internal::withScriptExecutionContextAttributeAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptStateAttributeRaises' (Type: 'attribute' ExtAttr: 'GetterRaisesException CallWith')
    {"withScriptStateAttributeRaises", TestObjV8Internal::withScriptStateAttributeRaisesAttrGetterCallback, TestObjV8Internal::withScriptStateAttributeRaisesAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptExecutionContextAttributeRaises' (Type: 'attribute' ExtAttr: 'GetterRaisesException CallWith')
    {"withScriptExecutionContextAttributeRaises", TestObjV8Internal::withScriptExecutionContextAttributeRaisesAttrGetterCallback, TestObjV8Internal::withScriptExecutionContextAttributeRaisesAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptExecutionContextAndScriptStateAttribute' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptExecutionContextAndScriptStateAttribute", TestObjV8Internal::withScriptExecutionContextAndScriptStateAttributeAttrGetterCallback, TestObjV8Internal::withScriptExecutionContextAndScriptStateAttributeAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptExecutionContextAndScriptStateAttributeRaises' (Type: 'attribute' ExtAttr: 'GetterRaisesException CallWith')
    {"withScriptExecutionContextAndScriptStateAttributeRaises", TestObjV8Internal::withScriptExecutionContextAndScriptStateAttributeRaisesAttrGetterCallback, TestObjV8Internal::withScriptExecutionContextAndScriptStateAttributeRaisesAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'withScriptExecutionContextAndScriptStateWithSpacesAttribute' (Type: 'attribute' ExtAttr: 'CallWith')
    {"withScriptExecutionContextAndScriptStateWithSpacesAttribute", TestObjV8Internal::withScriptExecutionContextAndScriptStateWithSpacesAttributeAttrGetterCallback, TestObjV8Internal::withScriptExecutionContextAndScriptStateWithSpacesAttributeAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'enforcedRangeLongAttr' (Type: 'attribute' ExtAttr: 'EnforceRange')
    {"enforcedRangeLongAttr", TestObjV8Internal::enforcedRangeLongAttrAttrGetterCallback, TestObjV8Internal::enforcedRangeLongAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'enforcedRangeUnsignedLongAttr' (Type: 'attribute' ExtAttr: 'EnforceRange')
    {"enforcedRangeUnsignedLongAttr", TestObjV8Internal::enforcedRangeUnsignedLongAttrAttrGetterCallback, TestObjV8Internal::enforcedRangeUnsignedLongAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'enforcedRangeLongLongAttr' (Type: 'attribute' ExtAttr: 'EnforceRange')
    {"enforcedRangeLongLongAttr", TestObjV8Internal::enforcedRangeLongLongAttrAttrGetterCallback, TestObjV8Internal::enforcedRangeLongLongAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'enforcedRangeUnsignedLongLongAttr' (Type: 'attribute' ExtAttr: 'EnforceRange')
    {"enforcedRangeUnsignedLongLongAttr", TestObjV8Internal::enforcedRangeUnsignedLongLongAttrAttrGetterCallback, TestObjV8Internal::enforcedRangeUnsignedLongLongAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
#if ENABLE(Condition1)
    // Attribute 'conditionalAttr1' (Type: 'attribute' ExtAttr: 'Conditional')
    {"conditionalAttr1", TestObjV8Internal::conditionalAttr1AttrGetterCallback, TestObjV8Internal::conditionalAttr1AttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
#endif // ENABLE(Condition1)
#if ENABLE(Condition1) && ENABLE(Condition2)
    // Attribute 'conditionalAttr2' (Type: 'attribute' ExtAttr: 'Conditional')
    {"conditionalAttr2", TestObjV8Internal::conditionalAttr2AttrGetterCallback, TestObjV8Internal::conditionalAttr2AttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
#endif // ENABLE(Condition1) && ENABLE(Condition2)
#if ENABLE(Condition1) || ENABLE(Condition2)
    // Attribute 'conditionalAttr3' (Type: 'attribute' ExtAttr: 'Conditional')
    {"conditionalAttr3", TestObjV8Internal::conditionalAttr3AttrGetterCallback, TestObjV8Internal::conditionalAttr3AttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
#endif // ENABLE(Condition1) || ENABLE(Condition2)
#if ENABLE(Condition1)
    // Attribute 'conditionalAttr4' (Type: 'attribute' ExtAttr: 'Conditional')
    {"conditionalAttr4", TestObjV8Internal::TestObjConstructorGetter, TestObjV8Internal::TestObjReplaceableAttrSetterCallback, 0, 0, &V8TestObjectA::info, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None | v8::DontEnum), 0 /* on instance */},
#endif // ENABLE(Condition1)
#if ENABLE(Condition1) && ENABLE(Condition2)
    // Attribute 'conditionalAttr5' (Type: 'attribute' ExtAttr: 'Conditional')
    {"conditionalAttr5", TestObjV8Internal::TestObjConstructorGetter, TestObjV8Internal::TestObjReplaceableAttrSetterCallback, 0, 0, &V8TestObjectB::info, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None | v8::DontEnum), 0 /* on instance */},
#endif // ENABLE(Condition1) && ENABLE(Condition2)
#if ENABLE(Condition1) || ENABLE(Condition2)
    // Attribute 'conditionalAttr6' (Type: 'attribute' ExtAttr: 'Conditional')
    {"conditionalAttr6", TestObjV8Internal::TestObjConstructorGetter, TestObjV8Internal::TestObjReplaceableAttrSetterCallback, 0, 0, &V8TestObjectC::info, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None | v8::DontEnum), 0 /* on instance */},
#endif // ENABLE(Condition1) || ENABLE(Condition2)
    // Attribute 'cachedAttribute1' (Type: 'readonly attribute' ExtAttr: 'CachedAttribute')
    {"cachedAttribute1", TestObjV8Internal::cachedAttribute1AttrGetterCallback, 0, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'cachedAttribute2' (Type: 'readonly attribute' ExtAttr: 'CachedAttribute')
    {"cachedAttribute2", TestObjV8Internal::cachedAttribute2AttrGetterCallback, 0, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'anyAttribute' (Type: 'attribute' ExtAttr: '')
    {"anyAttribute", TestObjV8Internal::anyAttributeAttrGetterCallback, TestObjV8Internal::anyAttributeAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'floatArray' (Type: 'attribute' ExtAttr: '')
    {"floatArray", TestObjV8Internal::floatArrayAttrGetterCallback, TestObjV8Internal::floatArrayAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'doubleArray' (Type: 'attribute' ExtAttr: '')
    {"doubleArray", TestObjV8Internal::doubleArrayAttrGetterCallback, TestObjV8Internal::doubleArrayAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'contentDocument' (Type: 'readonly attribute' ExtAttr: 'CheckSecurityForNode')
    {"contentDocument", TestObjV8Internal::contentDocumentAttrGetterCallback, 0, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'mutablePoint' (Type: 'attribute' ExtAttr: '')
    {"mutablePoint", TestObjV8Internal::mutablePointAttrGetterCallback, TestObjV8Internal::mutablePointAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'immutablePoint' (Type: 'attribute' ExtAttr: 'Immutable')
    {"immutablePoint", TestObjV8Internal::immutablePointAttrGetterCallback, TestObjV8Internal::immutablePointAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'strawberry' (Type: 'attribute' ExtAttr: 'ImplementedAs')
    {"strawberry", TestObjV8Internal::strawberryAttrGetterCallback, TestObjV8Internal::strawberryAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'strictFloat' (Type: 'attribute' ExtAttr: 'StrictTypeChecking')
    {"strictFloat", TestObjV8Internal::strictFloatAttrGetterCallback, TestObjV8Internal::strictFloatAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'description' (Type: 'readonly attribute' ExtAttr: '')
    {"description", TestObjV8Internal::descriptionAttrGetterCallback, 0, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'id' (Type: 'attribute' ExtAttr: '')
    {"id", TestObjV8Internal::idAttrGetterCallback, TestObjV8Internal::idAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'hash' (Type: 'readonly attribute' ExtAttr: '')
    {"hash", TestObjV8Internal::hashAttrGetterCallback, 0, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'replaceableAttribute' (Type: 'readonly attribute' ExtAttr: 'Replaceable')
    {"replaceableAttribute", TestObjV8Internal::replaceableAttributeAttrGetterCallback, TestObjV8Internal::TestObjReplaceableAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'nullableDoubleAttribute' (Type: 'readonly attribute' ExtAttr: '')
    {"nullableDoubleAttribute", TestObjV8Internal::nullableDoubleAttributeAttrGetterCallback, 0, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'nullableLongAttribute' (Type: 'readonly attribute' ExtAttr: '')
    {"nullableLongAttribute", TestObjV8Internal::nullableLongAttributeAttrGetterCallback, 0, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'nullableBooleanAttribute' (Type: 'readonly attribute' ExtAttr: '')
    {"nullableBooleanAttribute", TestObjV8Internal::nullableBooleanAttributeAttrGetterCallback, 0, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'nullableStringAttribute' (Type: 'readonly attribute' ExtAttr: '')
    {"nullableStringAttribute", TestObjV8Internal::nullableStringAttributeAttrGetterCallback, 0, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'nullableLongSettableAttribute' (Type: 'attribute' ExtAttr: '')
    {"nullableLongSettableAttribute", TestObjV8Internal::nullableLongSettableAttributeAttrGetterCallback, TestObjV8Internal::nullableLongSettableAttributeAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'nullableStringValue' (Type: 'attribute' ExtAttr: 'GetterRaisesException')
    {"nullableStringValue", TestObjV8Internal::nullableStringValueAttrGetterCallback, TestObjV8Internal::nullableStringValueAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'perWorldReadOnlyAttribute' (Type: 'readonly attribute' ExtAttr: 'PerWorldBindings')
    {"perWorldReadOnlyAttribute", TestObjV8Internal::perWorldReadOnlyAttributeAttrGetterCallback, 0, TestObjV8Internal::perWorldReadOnlyAttributeAttrGetterCallbackForMainWorld, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'perWorldAttribute' (Type: 'attribute' ExtAttr: 'PerWorldBindings')
    {"perWorldAttribute", TestObjV8Internal::perWorldAttributeAttrGetterCallback, TestObjV8Internal::perWorldAttributeAttrSetterCallback, TestObjV8Internal::perWorldAttributeAttrGetterCallbackForMainWorld, TestObjV8Internal::perWorldAttributeAttrSetterCallbackForMainWorld, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'activityLoggedAttr1' (Type: 'attribute' ExtAttr: 'ActivityLog')
    {"activityLoggedAttr1", TestObjV8Internal::activityLoggedAttr1AttrGetterCallback, TestObjV8Internal::activityLoggedAttr1AttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'activityLoggedAttr2' (Type: 'attribute' ExtAttr: 'PerWorldBindings ActivityLog')
    {"activityLoggedAttr2", TestObjV8Internal::activityLoggedAttr2AttrGetterCallback, TestObjV8Internal::activityLoggedAttr2AttrSetterCallback, TestObjV8Internal::activityLoggedAttr2AttrGetterCallbackForMainWorld, TestObjV8Internal::activityLoggedAttr2AttrSetterCallbackForMainWorld, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'activityLoggedInIsolatedWorldsAttr' (Type: 'attribute' ExtAttr: 'PerWorldBindings ActivityLog')
    {"activityLoggedInIsolatedWorldsAttr", TestObjV8Internal::activityLoggedInIsolatedWorldsAttrAttrGetterCallback, TestObjV8Internal::activityLoggedInIsolatedWorldsAttrAttrSetterCallback, TestObjV8Internal::activityLoggedInIsolatedWorldsAttrAttrGetterCallbackForMainWorld, TestObjV8Internal::activityLoggedInIsolatedWorldsAttrAttrSetterCallbackForMainWorld, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'activityLoggedAttrSetter1' (Type: 'attribute' ExtAttr: 'ActivityLog')
    {"activityLoggedAttrSetter1", TestObjV8Internal::activityLoggedAttrSetter1AttrGetterCallback, TestObjV8Internal::activityLoggedAttrSetter1AttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'activityLoggedAttrSetter2' (Type: 'attribute' ExtAttr: 'PerWorldBindings ActivityLog')
    {"activityLoggedAttrSetter2", TestObjV8Internal::activityLoggedAttrSetter2AttrGetterCallback, TestObjV8Internal::activityLoggedAttrSetter2AttrSetterCallback, TestObjV8Internal::activityLoggedAttrSetter2AttrGetterCallbackForMainWorld, TestObjV8Internal::activityLoggedAttrSetter2AttrSetterCallbackForMainWorld, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'activityLoggedInIsolatedWorldsAttrSetter' (Type: 'attribute' ExtAttr: 'PerWorldBindings ActivityLog')
    {"activityLoggedInIsolatedWorldsAttrSetter", TestObjV8Internal::activityLoggedInIsolatedWorldsAttrSetterAttrGetterCallback, TestObjV8Internal::activityLoggedInIsolatedWorldsAttrSetterAttrSetterCallback, TestObjV8Internal::activityLoggedInIsolatedWorldsAttrSetterAttrGetterCallbackForMainWorld, TestObjV8Internal::activityLoggedInIsolatedWorldsAttrSetterAttrSetterCallbackForMainWorld, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'activityLoggedAttrGetter1' (Type: 'attribute' ExtAttr: 'ActivityLog')
    {"activityLoggedAttrGetter1", TestObjV8Internal::activityLoggedAttrGetter1AttrGetterCallback, TestObjV8Internal::activityLoggedAttrGetter1AttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'activityLoggedAttrGetter2' (Type: 'attribute' ExtAttr: 'PerWorldBindings ActivityLog')
    {"activityLoggedAttrGetter2", TestObjV8Internal::activityLoggedAttrGetter2AttrGetterCallback, TestObjV8Internal::activityLoggedAttrGetter2AttrSetterCallback, TestObjV8Internal::activityLoggedAttrGetter2AttrGetterCallbackForMainWorld, TestObjV8Internal::activityLoggedAttrGetter2AttrSetterCallbackForMainWorld, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'activityLoggedInIsolatedWorldsAttrGetter' (Type: 'attribute' ExtAttr: 'PerWorldBindings ActivityLog')
    {"activityLoggedInIsolatedWorldsAttrGetter", TestObjV8Internal::activityLoggedInIsolatedWorldsAttrGetterAttrGetterCallback, TestObjV8Internal::activityLoggedInIsolatedWorldsAttrGetterAttrSetterCallback, TestObjV8Internal::activityLoggedInIsolatedWorldsAttrGetterAttrGetterCallbackForMainWorld, TestObjV8Internal::activityLoggedInIsolatedWorldsAttrGetterAttrSetterCallbackForMainWorld, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'deprecatedStaticReadOnlyAttr' (Type: 'readonly attribute' ExtAttr: 'DeprecateAs')
    {"deprecatedStaticReadOnlyAttr", TestObjV8Internal::deprecatedStaticReadOnlyAttrAttrGetterCallback, 0, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'deprecatedStaticAttr' (Type: 'attribute' ExtAttr: 'DeprecateAs')
    {"deprecatedStaticAttr", TestObjV8Internal::deprecatedStaticAttrAttrGetterCallback, TestObjV8Internal::deprecatedStaticAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'deprecatedReadonlyAttr' (Type: 'readonly attribute' ExtAttr: 'DeprecateAs')
    {"deprecatedReadonlyAttr", TestObjV8Internal::deprecatedReadonlyAttrAttrGetterCallback, 0, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'deprecatedAttr' (Type: 'attribute' ExtAttr: 'DeprecateAs')
    {"deprecatedAttr", TestObjV8Internal::deprecatedAttrAttrGetterCallback, TestObjV8Internal::deprecatedAttrAttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
};

static const V8DOMConfiguration::BatchedMethod V8TestObjMethods[] = {
    {"voidMethod", TestObjV8Internal::voidMethodMethodCallback, 0, 0},
    {"longMethod", TestObjV8Internal::longMethodMethodCallback, 0, 0},
    {"objMethod", TestObjV8Internal::objMethodMethodCallback, 0, 0},
    {"methodReturningSequence", TestObjV8Internal::methodReturningSequenceMethodCallback, 0, 1},
    {"methodWithEnumArg", TestObjV8Internal::methodWithEnumArgMethodCallback, 0, 1},
    {"serializedValue", TestObjV8Internal::serializedValueMethodCallback, 0, 1},
    {"optionsObject", TestObjV8Internal::optionsObjectMethodCallback, 0, 1},
    {"methodWithException", TestObjV8Internal::methodWithExceptionMethodCallback, 0, 0},
    {"customMethod", TestObjV8Internal::customMethodMethodCallback, 0, 0},
    {"customMethodWithArgs", TestObjV8Internal::customMethodWithArgsMethodCallback, 0, 3},
    {"addEventListener", TestObjV8Internal::addEventListenerMethodCallback, 0, 2},
    {"removeEventListener", TestObjV8Internal::removeEventListenerMethodCallback, 0, 2},
    {"withScriptStateVoid", TestObjV8Internal::withScriptStateVoidMethodCallback, 0, 0},
    {"withScriptStateObj", TestObjV8Internal::withScriptStateObjMethodCallback, 0, 0},
    {"withScriptStateVoidException", TestObjV8Internal::withScriptStateVoidExceptionMethodCallback, 0, 0},
    {"withScriptStateObjException", TestObjV8Internal::withScriptStateObjExceptionMethodCallback, 0, 0},
    {"withScriptExecutionContext", TestObjV8Internal::withScriptExecutionContextMethodCallback, 0, 0},
    {"withScriptExecutionContextAndScriptState", TestObjV8Internal::withScriptExecutionContextAndScriptStateMethodCallback, 0, 0},
    {"withScriptExecutionContextAndScriptStateObjException", TestObjV8Internal::withScriptExecutionContextAndScriptStateObjExceptionMethodCallback, 0, 0},
    {"withScriptExecutionContextAndScriptStateWithSpaces", TestObjV8Internal::withScriptExecutionContextAndScriptStateWithSpacesMethodCallback, 0, 0},
    {"methodWithOptionalArg", TestObjV8Internal::methodWithOptionalArgMethodCallback, 0, 0},
    {"methodWithNonOptionalArgAndOptionalArg", TestObjV8Internal::methodWithNonOptionalArgAndOptionalArgMethodCallback, 0, 1},
    {"methodWithNonOptionalArgAndTwoOptionalArgs", TestObjV8Internal::methodWithNonOptionalArgAndTwoOptionalArgsMethodCallback, 0, 1},
    {"methodWithOptionalString", TestObjV8Internal::methodWithOptionalStringMethodCallback, 0, 0},
    {"methodWithOptionalStringIsUndefined", TestObjV8Internal::methodWithOptionalStringIsUndefinedMethodCallback, 0, 0},
    {"methodWithOptionalStringIsNullString", TestObjV8Internal::methodWithOptionalStringIsNullStringMethodCallback, 0, 0},
    {"methodWithCallbackArg", TestObjV8Internal::methodWithCallbackArgMethodCallback, 0, 1},
    {"methodWithNonCallbackArgAndCallbackArg", TestObjV8Internal::methodWithNonCallbackArgAndCallbackArgMethodCallback, 0, 2},
    {"methodWithCallbackAndOptionalArg", TestObjV8Internal::methodWithCallbackAndOptionalArgMethodCallback, 0, 0},
    {"methodWithEnforceRangeInt32", TestObjV8Internal::methodWithEnforceRangeInt32MethodCallback, 0, 1},
    {"methodWithEnforceRangeUInt32", TestObjV8Internal::methodWithEnforceRangeUInt32MethodCallback, 0, 1},
    {"methodWithEnforceRangeInt64", TestObjV8Internal::methodWithEnforceRangeInt64MethodCallback, 0, 1},
    {"methodWithEnforceRangeUInt64", TestObjV8Internal::methodWithEnforceRangeUInt64MethodCallback, 0, 1},
#if ENABLE(Condition1)
    {"conditionalMethod1", TestObjV8Internal::conditionalMethod1MethodCallback, 0, 0},
#endif
#if ENABLE(Condition1) && ENABLE(Condition2)
    {"conditionalMethod2", TestObjV8Internal::conditionalMethod2MethodCallback, 0, 0},
#endif
#if ENABLE(Condition1) || ENABLE(Condition2)
    {"conditionalMethod3", TestObjV8Internal::conditionalMethod3MethodCallback, 0, 0},
#endif
    {"overloadedMethod", TestObjV8Internal::overloadedMethodMethodCallback, 0, 2},
    {"classMethodWithClamp", TestObjV8Internal::classMethodWithClampMethodCallback, 0, 2},
    {"getSVGDocument", TestObjV8Internal::getSVGDocumentMethodCallback, 0, 0},
    {"mutablePointFunction", TestObjV8Internal::mutablePointFunctionMethodCallback, 0, 0},
    {"immutablePointFunction", TestObjV8Internal::immutablePointFunctionMethodCallback, 0, 0},
    {"orange", TestObjV8Internal::orangeMethodCallback, 0, 0},
    {"strictFunction", TestObjV8Internal::strictFunctionMethodCallback, 0, 3},
    {"variadicStringMethod", TestObjV8Internal::variadicStringMethodMethodCallback, 0, 2},
    {"variadicDoubleMethod", TestObjV8Internal::variadicDoubleMethodMethodCallback, 0, 2},
    {"perWorldMethod", TestObjV8Internal::perWorldMethodMethodCallback, TestObjV8Internal::perWorldMethodMethodCallbackForMainWorld, 0},
    {"overloadedPerWorldMethod", TestObjV8Internal::overloadedPerWorldMethodMethodCallback, TestObjV8Internal::overloadedPerWorldMethodMethodCallbackForMainWorld, 1},
    {"activityLoggedMethod1", TestObjV8Internal::activityLoggedMethod1MethodCallback, 0, 1},
    {"activityLoggedMethod2", TestObjV8Internal::activityLoggedMethod2MethodCallback, TestObjV8Internal::activityLoggedMethod2MethodCallbackForMainWorld, 1},
    {"activityLoggedInIsolatedWorldMethod", TestObjV8Internal::activityLoggedInIsolatedWorldMethodMethodCallback, TestObjV8Internal::activityLoggedInIsolatedWorldMethodMethodCallbackForMainWorld, 1},
    {"overloadedActivityLoggedMethod", TestObjV8Internal::overloadedActivityLoggedMethodMethodCallback, TestObjV8Internal::overloadedActivityLoggedMethodMethodCallbackForMainWorld, 1},
    {"deprecatedMethod", TestObjV8Internal::deprecatedMethodMethodCallback, 0, 0},
};

static const V8DOMConfiguration::BatchedConstant V8TestObjConsts[] = {
#if ENABLE(Condition1)
    {"CONDITIONAL_CONST", 0},
#endif
    {"CONST_VALUE_0", 0},
    {"CONST_VALUE_1", 1},
    {"CONST_VALUE_2", 2},
    {"CONST_VALUE_4", 4},
    {"CONST_VALUE_8", 8},
    {"CONST_VALUE_9", -1},
    {"CONST_VALUE_10", "my constant string"},
    {"CONST_VALUE_11", -1},
    {"CONST_VALUE_12", 1},
    {"CONST_VALUE_13", 0X20},
    {"CONST_VALUE_14", 6844},
    {"CONST_JAVASCRIPT", 15},
    {"DEPRECATED_CONSTANT", 1},
};


#if ENABLE(Condition1)
COMPILE_ASSERT(0 == TestObj::CONDITIONAL_CONST, TestObjEnumCONDITIONAL_CONSTIsWrongUseDoNotCheckConstants);
#endif
COMPILE_ASSERT(0 == TestObj::CONST_VALUE_0, TestObjEnumCONST_VALUE_0IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == TestObj::CONST_VALUE_1, TestObjEnumCONST_VALUE_1IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == TestObj::CONST_VALUE_2, TestObjEnumCONST_VALUE_2IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == TestObj::CONST_VALUE_4, TestObjEnumCONST_VALUE_4IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(8 == TestObj::CONST_VALUE_8, TestObjEnumCONST_VALUE_8IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(-1 == TestObj::CONST_VALUE_9, TestObjEnumCONST_VALUE_9IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT("my constant string" == TestObj::CONST_VALUE_10, TestObjEnumCONST_VALUE_10IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0xffffffff == TestObj::CONST_VALUE_11, TestObjEnumCONST_VALUE_11IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x01 == TestObj::CONST_VALUE_12, TestObjEnumCONST_VALUE_12IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0X20 == TestObj::CONST_VALUE_13, TestObjEnumCONST_VALUE_13IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x1abc == TestObj::CONST_VALUE_14, TestObjEnumCONST_VALUE_14IsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(15 == TestObj::CONST_IMPL, TestObjEnumCONST_IMPLIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == TestObj::DEPRECATED_CONSTANT, TestObjEnumDEPRECATED_CONSTANTIsWrongUseDoNotCheckConstants);

v8::Handle<v8::Value> V8TestObj::constructorCallback(const v8::Arguments& args)
{
    if (!args.IsConstructCall())
        return throwTypeError("DOM object constructor cannot be called as a function.", args.GetIsolate());

    if (ConstructorMode::current() == ConstructorMode::WrapExistingObject)
        return args.Holder();

    return TestObjV8Internal::constructor(args);
}

static v8::Persistent<v8::FunctionTemplate> ConfigureV8TestObjTemplate(v8::Persistent<v8::FunctionTemplate> desc, v8::Isolate* isolate, WrapperWorldType currentWorldType)
{
    desc->ReadOnlyPrototype();

    v8::Local<v8::Signature> defaultSignature;
    defaultSignature = V8DOMConfiguration::configureTemplate(desc, "TestObject", v8::Persistent<v8::FunctionTemplate>(), V8TestObj::internalFieldCount,
        V8TestObjAttrs, WTF_ARRAY_LENGTH(V8TestObjAttrs),
        V8TestObjMethods, WTF_ARRAY_LENGTH(V8TestObjMethods), isolate, currentWorldType);
    UNUSED_PARAM(defaultSignature); // In some cases, it will not be used.
    desc->SetCallHandler(V8TestObj::constructorCallback);
    desc->SetLength(1);
    v8::Local<v8::ObjectTemplate> instance = desc->InstanceTemplate();
    v8::Local<v8::ObjectTemplate> proto = desc->PrototypeTemplate();
    UNUSED_PARAM(instance); // In some cases, it will not be used.
    UNUSED_PARAM(proto); // In some cases, it will not be used.
    if (RuntimeEnabledFeatures::enabledAtRuntimeAttr1Enabled()) {
        static const V8DOMConfiguration::BatchedAttribute attrData =\
        // Attribute 'enabledAtRuntimeAttr1' (Type: 'attribute' ExtAttr: 'EnabledAtRuntime')
        {"enabledAtRuntimeAttr1", TestObjV8Internal::enabledAtRuntimeAttr1AttrGetterCallback, TestObjV8Internal::enabledAtRuntimeAttr1AttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */};
        V8DOMConfiguration::configureAttribute(instance, proto, attrData, isolate, currentWorldType);
    }
    if (RuntimeEnabledFeatures::featureNameEnabled()) {
        static const V8DOMConfiguration::BatchedAttribute attrData =\
        // Attribute 'enabledAtRuntimeAttr2' (Type: 'attribute' ExtAttr: 'EnabledAtRuntime')
        {"enabledAtRuntimeAttr2", TestObjV8Internal::enabledAtRuntimeAttr2AttrGetterCallback, TestObjV8Internal::enabledAtRuntimeAttr2AttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */};
        V8DOMConfiguration::configureAttribute(instance, proto, attrData, isolate, currentWorldType);
    }

    // Custom Signature 'voidMethodWithArgs'
    const int voidMethodWithArgsArgc = 3;
    v8::Handle<v8::FunctionTemplate> voidMethodWithArgsArgv[voidMethodWithArgsArgc] = { v8::Handle<v8::FunctionTemplate>(), v8::Handle<v8::FunctionTemplate>(), V8PerIsolateData::from(isolate)->rawTemplate(&V8TestObj::info, currentWorldType) };
    v8::Handle<v8::Signature> voidMethodWithArgsSignature = v8::Signature::New(desc, voidMethodWithArgsArgc, voidMethodWithArgsArgv);
    proto->Set(v8::String::NewSymbol("voidMethodWithArgs"), v8::FunctionTemplate::New(TestObjV8Internal::voidMethodWithArgsMethodCallback, v8Undefined(), voidMethodWithArgsSignature, 3));

    // Custom Signature 'longMethodWithArgs'
    const int longMethodWithArgsArgc = 3;
    v8::Handle<v8::FunctionTemplate> longMethodWithArgsArgv[longMethodWithArgsArgc] = { v8::Handle<v8::FunctionTemplate>(), v8::Handle<v8::FunctionTemplate>(), V8PerIsolateData::from(isolate)->rawTemplate(&V8TestObj::info, currentWorldType) };
    v8::Handle<v8::Signature> longMethodWithArgsSignature = v8::Signature::New(desc, longMethodWithArgsArgc, longMethodWithArgsArgv);
    proto->Set(v8::String::NewSymbol("longMethodWithArgs"), v8::FunctionTemplate::New(TestObjV8Internal::longMethodWithArgsMethodCallback, v8Undefined(), longMethodWithArgsSignature, 3));

    // Custom Signature 'objMethodWithArgs'
    const int objMethodWithArgsArgc = 3;
    v8::Handle<v8::FunctionTemplate> objMethodWithArgsArgv[objMethodWithArgsArgc] = { v8::Handle<v8::FunctionTemplate>(), v8::Handle<v8::FunctionTemplate>(), V8PerIsolateData::from(isolate)->rawTemplate(&V8TestObj::info, currentWorldType) };
    v8::Handle<v8::Signature> objMethodWithArgsSignature = v8::Signature::New(desc, objMethodWithArgsArgc, objMethodWithArgsArgv);
    proto->Set(v8::String::NewSymbol("objMethodWithArgs"), v8::FunctionTemplate::New(TestObjV8Internal::objMethodWithArgsMethodCallback, v8Undefined(), objMethodWithArgsSignature, 3));

    // Custom Signature 'methodWithSequenceArg'
    const int methodWithSequenceArgArgc = 1;
    v8::Handle<v8::FunctionTemplate> methodWithSequenceArgArgv[methodWithSequenceArgArgc] = { V8PerIsolateData::from(isolate)->rawTemplate(&V8sequence<ScriptProfile>::info, currentWorldType) };
    v8::Handle<v8::Signature> methodWithSequenceArgSignature = v8::Signature::New(desc, methodWithSequenceArgArgc, methodWithSequenceArgArgv);
    proto->Set(v8::String::NewSymbol("methodWithSequenceArg"), v8::FunctionTemplate::New(TestObjV8Internal::methodWithSequenceArgMethodCallback, v8Undefined(), methodWithSequenceArgSignature, 1));

    // Custom Signature 'methodThatRequiresAllArgsAndThrows'
    const int methodThatRequiresAllArgsAndThrowsArgc = 2;
    v8::Handle<v8::FunctionTemplate> methodThatRequiresAllArgsAndThrowsArgv[methodThatRequiresAllArgsAndThrowsArgc] = { v8::Handle<v8::FunctionTemplate>(), V8PerIsolateData::from(isolate)->rawTemplate(&V8TestObj::info, currentWorldType) };
    v8::Handle<v8::Signature> methodThatRequiresAllArgsAndThrowsSignature = v8::Signature::New(desc, methodThatRequiresAllArgsAndThrowsArgc, methodThatRequiresAllArgsAndThrowsArgv);
    proto->Set(v8::String::NewSymbol("methodThatRequiresAllArgsAndThrows"), v8::FunctionTemplate::New(TestObjV8Internal::methodThatRequiresAllArgsAndThrowsMethodCallback, v8Undefined(), methodThatRequiresAllArgsAndThrowsSignature, 2));
    desc->Set(v8::String::NewSymbol("staticMethodWithCallbackAndOptionalArg"), v8::FunctionTemplate::New(TestObjV8Internal::staticMethodWithCallbackAndOptionalArgMethodCallback, v8Undefined(), v8::Local<v8::Signature>(), 0));
    desc->Set(v8::String::NewSymbol("staticMethodWithCallbackArg"), v8::FunctionTemplate::New(TestObjV8Internal::staticMethodWithCallbackArgMethodCallback, v8Undefined(), v8::Local<v8::Signature>(), 1));
    desc->Set(v8::String::NewSymbol("classMethod"), v8::FunctionTemplate::New(TestObjV8Internal::classMethodMethodCallback, v8Undefined(), v8::Local<v8::Signature>(), 0));
    desc->Set(v8::String::NewSymbol("classMethodWithOptional"), v8::FunctionTemplate::New(TestObjV8Internal::classMethodWithOptionalMethodCallback, v8Undefined(), v8::Local<v8::Signature>(), 0));
    desc->Set(v8::String::NewSymbol("classMethod2"), v8::FunctionTemplate::New(TestObjV8Internal::classMethod2MethodCallback, v8Undefined(), v8::Local<v8::Signature>(), 1));
#if ENABLE(Condition1)
    desc->Set(v8::String::NewSymbol("overloadedMethod1"), v8::FunctionTemplate::New(TestObjV8Internal::overloadedMethod1MethodCallback, v8Undefined(), v8::Local<v8::Signature>(), 1));
#endif // ENABLE(Condition1)
    if (RuntimeEnabledFeatures::enabledAtRuntimeMethod1Enabled())
        proto->Set(v8::String::NewSymbol("enabledAtRuntimeMethod1"), v8::FunctionTemplate::New(TestObjV8Internal::enabledAtRuntimeMethod1MethodCallback, v8Undefined(), defaultSignature, 1));
    if (RuntimeEnabledFeatures::featureNameEnabled())
        proto->Set(v8::String::NewSymbol("enabledAtRuntimeMethod2"), v8::FunctionTemplate::New(TestObjV8Internal::enabledAtRuntimeMethod2MethodCallback, v8Undefined(), defaultSignature, 1));

    // Custom Signature 'methodWithUnsignedLongSequence'
    const int methodWithUnsignedLongSequenceArgc = 1;
    v8::Handle<v8::FunctionTemplate> methodWithUnsignedLongSequenceArgv[methodWithUnsignedLongSequenceArgc] = { v8::Handle<v8::FunctionTemplate>() };
    v8::Handle<v8::Signature> methodWithUnsignedLongSequenceSignature = v8::Signature::New(desc, methodWithUnsignedLongSequenceArgc, methodWithUnsignedLongSequenceArgv);
    proto->Set(v8::String::NewSymbol("methodWithUnsignedLongSequence"), v8::FunctionTemplate::New(TestObjV8Internal::methodWithUnsignedLongSequenceMethodCallback, v8Undefined(), methodWithUnsignedLongSequenceSignature, 1));

    // Custom Signature 'stringArrayFunction'
    const int stringArrayFunctionArgc = 1;
    v8::Handle<v8::FunctionTemplate> stringArrayFunctionArgv[stringArrayFunctionArgc] = { V8PerIsolateData::from(isolate)->rawTemplate(&V8DOMString[]::info, currentWorldType) };
    v8::Handle<v8::Signature> stringArrayFunctionSignature = v8::Signature::New(desc, stringArrayFunctionArgc, stringArrayFunctionArgv);
    proto->Set(v8::String::NewSymbol("stringArrayFunction"), v8::FunctionTemplate::New(TestObjV8Internal::stringArrayFunctionMethodCallback, v8Undefined(), stringArrayFunctionSignature, 1));

    // Custom Signature 'domStringListFunction'
    const int domStringListFunctionArgc = 1;
    v8::Handle<v8::FunctionTemplate> domStringListFunctionArgv[domStringListFunctionArgc] = { V8PerIsolateData::from(isolate)->rawTemplate(&V8DOMStringList::info, currentWorldType) };
    v8::Handle<v8::Signature> domStringListFunctionSignature = v8::Signature::New(desc, domStringListFunctionArgc, domStringListFunctionArgv);
    proto->Set(v8::String::NewSymbol("domStringListFunction"), v8::FunctionTemplate::New(TestObjV8Internal::domStringListFunctionMethodCallback, v8Undefined(), domStringListFunctionSignature, 1));

    // Custom Signature 'convert1'
    const int convert1Argc = 1;
    v8::Handle<v8::FunctionTemplate> convert1Argv[convert1Argc] = { V8PerIsolateData::from(isolate)->rawTemplate(&V8TestNode::info, currentWorldType) };
    v8::Handle<v8::Signature> convert1Signature = v8::Signature::New(desc, convert1Argc, convert1Argv);
    proto->Set(v8::String::NewSymbol("convert1"), v8::FunctionTemplate::New(TestObjV8Internal::convert1MethodCallback, v8Undefined(), convert1Signature, 1));

    // Custom Signature 'convert2'
    const int convert2Argc = 1;
    v8::Handle<v8::FunctionTemplate> convert2Argv[convert2Argc] = { V8PerIsolateData::from(isolate)->rawTemplate(&V8TestNode::info, currentWorldType) };
    v8::Handle<v8::Signature> convert2Signature = v8::Signature::New(desc, convert2Argc, convert2Argv);
    proto->Set(v8::String::NewSymbol("convert2"), v8::FunctionTemplate::New(TestObjV8Internal::convert2MethodCallback, v8Undefined(), convert2Signature, 1));

    // Custom Signature 'convert4'
    const int convert4Argc = 1;
    v8::Handle<v8::FunctionTemplate> convert4Argv[convert4Argc] = { V8PerIsolateData::from(isolate)->rawTemplate(&V8TestNode::info, currentWorldType) };
    v8::Handle<v8::Signature> convert4Signature = v8::Signature::New(desc, convert4Argc, convert4Argv);
    proto->Set(v8::String::NewSymbol("convert4"), v8::FunctionTemplate::New(TestObjV8Internal::convert4MethodCallback, v8Undefined(), convert4Signature, 1));

    // Custom Signature 'convert5'
    const int convert5Argc = 1;
    v8::Handle<v8::FunctionTemplate> convert5Argv[convert5Argc] = { V8PerIsolateData::from(isolate)->rawTemplate(&V8TestNode::info, currentWorldType) };
    v8::Handle<v8::Signature> convert5Signature = v8::Signature::New(desc, convert5Argc, convert5Argv);
    proto->Set(v8::String::NewSymbol("convert5"), v8::FunctionTemplate::New(TestObjV8Internal::convert5MethodCallback, v8Undefined(), convert5Signature, 1));

    // Custom Signature 'variadicNodeMethod'
    const int variadicNodeMethodArgc = 2;
    v8::Handle<v8::FunctionTemplate> variadicNodeMethodArgv[variadicNodeMethodArgc] = { V8PerIsolateData::from(isolate)->rawTemplate(&V8Node::info, currentWorldType), V8PerIsolateData::from(isolate)->rawTemplate(&V8Node::info, currentWorldType) };
    v8::Handle<v8::Signature> variadicNodeMethodSignature = v8::Signature::New(desc, variadicNodeMethodArgc, variadicNodeMethodArgv);
    proto->Set(v8::String::NewSymbol("variadicNodeMethod"), v8::FunctionTemplate::New(TestObjV8Internal::variadicNodeMethodMethodCallback, v8Undefined(), variadicNodeMethodSignature, 2));
    desc->Set(v8::String::NewSymbol("deprecatedStaticMethod"), v8::FunctionTemplate::New(TestObjV8Internal::deprecatedStaticMethodMethodCallback, v8Undefined(), v8::Local<v8::Signature>(), 0));
    V8DOMConfiguration::batchConfigureConstants(desc, proto, V8TestObjConsts, WTF_ARRAY_LENGTH(V8TestObjConsts), isolate);

    // Custom toString template
    desc->Set(v8::String::NewSymbol("toString"), V8PerIsolateData::current()->toStringTemplate());
    return desc;
}

v8::Persistent<v8::FunctionTemplate> V8TestObj::GetTemplate(v8::Isolate* isolate, WrapperWorldType currentWorldType)
{
    V8PerIsolateData* data = V8PerIsolateData::from(isolate);
    V8PerIsolateData::TemplateMap::iterator result = data->templateMap(currentWorldType).find(&info);
    if (result != data->templateMap(currentWorldType).end())
        return result->value;

    v8::HandleScope handleScope;
    v8::Persistent<v8::FunctionTemplate> templ =
        ConfigureV8TestObjTemplate(data->rawTemplate(&info, currentWorldType), isolate, currentWorldType);
    data->templateMap(currentWorldType).add(&info, templ);
    return templ;
}

bool V8TestObj::HasInstance(v8::Handle<v8::Value> value, v8::Isolate* isolate, WrapperWorldType currentWorldType)
{
    return V8PerIsolateData::from(isolate)->hasInstance(&info, value, currentWorldType);
}

bool V8TestObj::HasInstanceInAnyWorld(v8::Handle<v8::Value> value, v8::Isolate* isolate)
{
    return V8PerIsolateData::from(isolate)->hasInstance(&info, value, MainWorld)
        || V8PerIsolateData::from(isolate)->hasInstance(&info, value, IsolatedWorld)
        || V8PerIsolateData::from(isolate)->hasInstance(&info, value, WorkerWorld);
}

void V8TestObj::installPerContextProperties(v8::Handle<v8::Object> instance, TestObj* impl, v8::Isolate* isolate)
{
    v8::Local<v8::Object> proto = v8::Local<v8::Object>::Cast(instance->GetPrototype());
    if (ContextFeatures::enabledPerContextAttr1Enabled(impl->document())) {
        static const V8DOMConfiguration::BatchedAttribute attrData =\
        // Attribute 'enabledPerContextAttr1' (Type: 'attribute' ExtAttr: 'EnabledPerContext')
        {"enabledPerContextAttr1", TestObjV8Internal::enabledPerContextAttr1AttrGetterCallback, TestObjV8Internal::enabledPerContextAttr1AttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */};
        V8DOMConfiguration::configureAttribute(instance, proto, attrData, isolate);
    }
    if (ContextFeatures::featureNameEnabled(impl->document())) {
        static const V8DOMConfiguration::BatchedAttribute attrData =\
        // Attribute 'enabledPerContextAttr2' (Type: 'attribute' ExtAttr: 'EnabledPerContext')
        {"enabledPerContextAttr2", TestObjV8Internal::enabledPerContextAttr2AttrGetterCallback, TestObjV8Internal::enabledPerContextAttr2AttrSetterCallback, 0, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */};
        V8DOMConfiguration::configureAttribute(instance, proto, attrData, isolate);
    }
}

void V8TestObj::installPerContextPrototypeProperties(v8::Handle<v8::Object> proto, v8::Isolate* isolate)
{
    UNUSED_PARAM(proto);
    v8::Local<v8::Signature> defaultSignature = v8::Signature::New(GetTemplate(isolate, worldType(isolate)));
    UNUSED_PARAM(defaultSignature); // In some cases, it will not be used.

    ScriptExecutionContext* context = toScriptExecutionContext(proto->CreationContext());
    if (context && context->isDocument() && ContextFeatures::enabledPerContextMethod1Enabled(toDocument(context))) {
        proto->Set(v8::String::NewSymbol("enabledPerContextMethod1"), v8::FunctionTemplate::New(TestObjV8Internal::enabledPerContextMethod1MethodCallback, v8Undefined(), defaultSignature, 1)->GetFunction());
    }
    if (context && context->isDocument() && ContextFeatures::featureNameEnabled(toDocument(context))) {
        proto->Set(v8::String::NewSymbol("enabledPerContextMethod2"), v8::FunctionTemplate::New(TestObjV8Internal::enabledPerContextMethod2MethodCallback, v8Undefined(), defaultSignature, 1)->GetFunction());
    }
}


v8::Handle<v8::Object> V8TestObj::createWrapper(PassRefPtr<TestObj> impl, v8::Handle<v8::Object> creationContext, v8::Isolate* isolate)
{
    ASSERT(impl.get());
    ASSERT(DOMDataStore::getWrapper(impl.get(), isolate).IsEmpty());

#if ENABLE(BINDING_INTEGRITY)
    checkTypeOrDieTrying(impl.get());
#endif

    v8::Handle<v8::Object> wrapper = V8DOMWrapper::createWrapper(creationContext, &info, impl.get(), isolate);
    if (UNLIKELY(wrapper.IsEmpty()))
        return wrapper;

    installPerContextProperties(wrapper, impl.get(), isolate);
    V8DOMWrapper::associateObjectWithWrapper(impl, &info, wrapper, isolate, hasDependentLifetime ? WrapperConfiguration::Dependent : WrapperConfiguration::Independent);
    return wrapper;
}
void V8TestObj::derefObject(void* object)
{
    static_cast<TestObj*>(object)->deref();
}

} // namespace WebCore
