/*
 * Copyright (C) 2009 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WebRuntimeFeatures.h"

#include "WebMediaPlayerClientImpl.h"
#include "RuntimeEnabledFeatures.h"
#include "modules/websockets/WebSocket.h"

#include <wtf/UnusedParam.h>

using namespace WebCore;

namespace WebKit {

void WebRuntimeFeatures::enableStableFeatures(bool enable)
{
    // FIXME: Actually respect the enable arg once the 3-part
    // change dance with content/ is over.
    ASSERT_UNUSED(enable, enable);

    // These are copied directly from RenderThreadImpl::InitializeWebKit.
    // All the "false" values should be removed, and all the flags
    // which default to "true" in RuntimeEnabledFeatures.cpp
    // should be moved here or enableTestingFeatures instead.
    enableApplicationCache(true);
    enableDatabase(true);
    enableDeviceMotion(false);
    enableDeviceOrientation(true);
    enableEncryptedMedia(true);
    enableExperimentalCanvasFeatures(false);
    enableExperimentalWebSocket(false);
    enableFileSystem(true);
    enableFullScreenAPI(true);
    enableGamepad(true);
    enableGeolocation(true);
    enableIndexedDatabase(true);
    enableJavaScriptI18NAPI(true);
    enableLocalStorage(true);
    enableMediaPlayer(true);
    enableMediaSource(true);
    enableMediaStream(true);
    enableNotifications(true);
    enablePeerConnection(true);
    enableQuota(true);
    enableScriptedSpeech(true);
    enableSeamlessIFrames(false);
    enableSessionStorage(true);
    enableSpeechInput(true);
    enableSpeechSynthesis(false);
    enableWebAudio(true);
    enableWebMIDI(false);
}

void WebRuntimeFeatures::enableExperimentalFeatures(bool enable)
{
    // FIXME: Actually respect the enable arg once the 3-part
    // change dance with content/ is over.
    ASSERT_UNUSED(enable, enable);

    enableCSSCompositing(true);
    enableCSSExclusions(true);
    enableCSSRegions(true);
    enableCustomDOMElements(true);
    enableDialogElement(true);
    enableExperimentalContentSecurityPolicyFeatures(true);
    enableFontLoadEvents(true);
    enableSeamlessIFrames(true);
    enableStyleScoped(true);
}

void WebRuntimeFeatures::enableTestOnlyFeatures(bool enable)
{
    // FIXME: This will be populated with features which
    // are currently initialized true, but always set
    // to false in enableStableFeatures.
    // This method should be used by ContentShell
    // to enable features which should be enabled for
    // the layout tests but are not yet "experimental".

    // FIXME: These are exactly copied from TestInterfaces.cpp
    // Most of these are redundant with enableStableFeatures
    // and should be removed in a follow-up patch.
    enableCanvasPath(true);
    enableCustomDOMElements(true);
    enableEncryptedMedia(true);
    enableExperimentalCanvasFeatures(true);
    enableExperimentalContentSecurityPolicyFeatures(true);
    enableExperimentalShadowDOM(true);
    enableFileSystem(true);
    enableFontLoadEvents(true);
    enableGamepad(true);
    enableGeolocation(true);
    enableIndexedDatabase(true);
    enableInputTypeDateTime(true);
    enableInputTypeWeek(true);
    enableJavaScriptI18NAPI(true);
    enableMediaSource(true);
    enableMediaStream(true);
    enablePeerConnection(true);
    enableRequestAutocomplete(true);
    enableScriptedSpeech(true);
    enableSeamlessIFrames(true);
    enableStyleScoped(true);
    enableVideoTrack(true);
    enableWebAudio(true);
    enableWebMIDI(true);
}

void WebRuntimeFeatures::enableDatabase(bool enable)
{
    RuntimeEnabledFeatures::setDatabaseEnabled(enable);
}

bool WebRuntimeFeatures::isDatabaseEnabled()
{
    return RuntimeEnabledFeatures::databaseEnabled();
}

// FIXME: Remove the ability to enable this feature at runtime.
void WebRuntimeFeatures::enableLocalStorage(bool enable)
{
    RuntimeEnabledFeatures::setLocalStorageEnabled(enable);
}

// FIXME: Remove the ability to enable this feature at runtime.
bool WebRuntimeFeatures::isLocalStorageEnabled()
{
    return RuntimeEnabledFeatures::localStorageEnabled();
}

// FIXME: Remove the ability to enable this feature at runtime.
void WebRuntimeFeatures::enableSessionStorage(bool enable)
{
    RuntimeEnabledFeatures::setSessionStorageEnabled(enable);
}

// FIXME: Remove the ability to enable this feature at runtime.
bool WebRuntimeFeatures::isSessionStorageEnabled()
{
    return RuntimeEnabledFeatures::sessionStorageEnabled();
}

void WebRuntimeFeatures::enableMediaPlayer(bool enable)
{
    WebMediaPlayerClientImpl::setIsEnabled(enable);
}

bool WebRuntimeFeatures::isMediaPlayerEnabled()
{
    return WebMediaPlayerClientImpl::isEnabled();
}

void WebRuntimeFeatures::enableNotifications(bool enable)
{
#if ENABLE(NOTIFICATIONS) || ENABLE(LEGACY_NOTIFICATIONS)
    RuntimeEnabledFeatures::setWebkitNotificationsEnabled(enable);
#endif
}

bool WebRuntimeFeatures::isNotificationsEnabled()
{
#if ENABLE(NOTIFICATIONS) || ENABLE(LEGACY_NOTIFICATIONS)
    return RuntimeEnabledFeatures::webkitNotificationsEnabled();
#else
    return false;
#endif
}

void WebRuntimeFeatures::enableApplicationCache(bool enable)
{
    RuntimeEnabledFeatures::setApplicationCacheEnabled(enable);
}

bool WebRuntimeFeatures::isApplicationCacheEnabled()
{
    return RuntimeEnabledFeatures::applicationCacheEnabled();
}

void WebRuntimeFeatures::enableGeolocation(bool enable)
{
    RuntimeEnabledFeatures::setGeolocationEnabled(enable);
}

bool WebRuntimeFeatures::isGeolocationEnabled()
{
    return RuntimeEnabledFeatures::geolocationEnabled();
}

void WebRuntimeFeatures::enableIndexedDatabase(bool enable)
{
    RuntimeEnabledFeatures::setIndexedDBEnabled(enable);
}

bool WebRuntimeFeatures::isIndexedDatabaseEnabled()
{
    return RuntimeEnabledFeatures::indexedDBEnabled();
}

void WebRuntimeFeatures::enableWebAudio(bool enable)
{
    RuntimeEnabledFeatures::setAudioContextEnabled(enable);
}

bool WebRuntimeFeatures::isWebAudioEnabled()
{
    return RuntimeEnabledFeatures::audioContextEnabled();
}

void WebRuntimeFeatures::enableTouch(bool enable)
{
    RuntimeEnabledFeatures::setTouchEnabled(enable);
}

bool WebRuntimeFeatures::isTouchEnabled()
{
    return RuntimeEnabledFeatures::touchEnabled();
}

void WebRuntimeFeatures::enableDeviceMotion(bool enable)
{
    RuntimeEnabledFeatures::setDeviceMotionEnabled(enable);
}

bool WebRuntimeFeatures::isDeviceMotionEnabled()
{
    return RuntimeEnabledFeatures::deviceMotionEnabled();
}

void WebRuntimeFeatures::enableDeviceOrientation(bool enable)
{
    RuntimeEnabledFeatures::setDeviceOrientationEnabled(enable);
}

bool WebRuntimeFeatures::isDeviceOrientationEnabled()
{
    return RuntimeEnabledFeatures::deviceOrientationEnabled();
}

void WebRuntimeFeatures::enableSpeechInput(bool enable)
{
    RuntimeEnabledFeatures::setSpeechInputEnabled(enable);
}

bool WebRuntimeFeatures::isSpeechInputEnabled()
{
    return RuntimeEnabledFeatures::speechInputEnabled();
}

void WebRuntimeFeatures::enableScriptedSpeech(bool enable)
{
    RuntimeEnabledFeatures::setScriptedSpeechEnabled(enable);
}

bool WebRuntimeFeatures::isScriptedSpeechEnabled()
{
    return RuntimeEnabledFeatures::scriptedSpeechEnabled();
}

void WebRuntimeFeatures::enableXHRResponseBlob(bool enable)
{
}

bool WebRuntimeFeatures::isXHRResponseBlobEnabled()
{
    return true;
}

void WebRuntimeFeatures::enableFileSystem(bool enable)
{
    RuntimeEnabledFeatures::setFileSystemEnabled(enable);
}

bool WebRuntimeFeatures::isFileSystemEnabled()
{
    return RuntimeEnabledFeatures::fileSystemEnabled();
}

void WebRuntimeFeatures::enableJavaScriptI18NAPI(bool enable)
{
    RuntimeEnabledFeatures::setJavaScriptI18NAPIEnabled(enable);
}

bool WebRuntimeFeatures::isJavaScriptI18NAPIEnabled()
{
    return RuntimeEnabledFeatures::javaScriptI18NAPIEnabled();
}

void WebRuntimeFeatures::enableQuota(bool enable)
{
    RuntimeEnabledFeatures::setQuotaEnabled(enable);
}

bool WebRuntimeFeatures::isQuotaEnabled()
{
    return RuntimeEnabledFeatures::quotaEnabled();
}

void WebRuntimeFeatures::enableMediaStream(bool enable)
{
    RuntimeEnabledFeatures::setMediaStreamEnabled(enable);
}

bool WebRuntimeFeatures::isMediaStreamEnabled()
{
    return RuntimeEnabledFeatures::mediaStreamEnabled();
}

void WebRuntimeFeatures::enablePeerConnection(bool enable)
{
    RuntimeEnabledFeatures::setPeerConnectionEnabled(enable);
}

bool WebRuntimeFeatures::isPeerConnectionEnabled()
{
    return RuntimeEnabledFeatures::peerConnectionEnabled();
}

void WebRuntimeFeatures::enableFullScreenAPI(bool enable)
{
    RuntimeEnabledFeatures::setFullscreenEnabled(enable);
}

bool WebRuntimeFeatures::isFullScreenAPIEnabled()
{
    return RuntimeEnabledFeatures::fullscreenEnabled();
}

void WebRuntimeFeatures::enableMediaSource(bool enable)
{
    RuntimeEnabledFeatures::setMediaSourceEnabled(enable);
}

bool WebRuntimeFeatures::isMediaSourceEnabled()
{
    return RuntimeEnabledFeatures::mediaSourceEnabled();
}

void WebRuntimeFeatures::enableEncryptedMedia(bool enable)
{
    RuntimeEnabledFeatures::setEncryptedMediaEnabled(enable);
}

bool WebRuntimeFeatures::isEncryptedMediaEnabled()
{
    return RuntimeEnabledFeatures::encryptedMediaEnabled();
}

void WebRuntimeFeatures::enableVideoTrack(bool enable)
{
    RuntimeEnabledFeatures::setWebkitVideoTrackEnabled(enable);
}

bool WebRuntimeFeatures::isVideoTrackEnabled()
{
    return RuntimeEnabledFeatures::webkitVideoTrackEnabled();
}

void WebRuntimeFeatures::enableGamepad(bool enable)
{
    RuntimeEnabledFeatures::setWebkitGetGamepadsEnabled(enable);
}

bool WebRuntimeFeatures::isGamepadEnabled()
{
    return RuntimeEnabledFeatures::webkitGetGamepadsEnabled();
}

void WebRuntimeFeatures::enableExperimentalShadowDOM(bool enable)
{
    RuntimeEnabledFeatures::setExperimentalShadowDOMEnabled(enable);
}

bool WebRuntimeFeatures::isExperimentalShadowDOMEnabled()
{
    return RuntimeEnabledFeatures::experimentalShadowDOMEnabled();
}

void WebRuntimeFeatures::enableCustomDOMElements(bool enable)
{
    RuntimeEnabledFeatures::setCustomDOMElementsEnabled(enable);
}

bool WebRuntimeFeatures::isCustomDOMElementsEnabled()
{
    return RuntimeEnabledFeatures::customDOMElementsEnabled();
}

void WebRuntimeFeatures::enableStyleScoped(bool enable)
{
    RuntimeEnabledFeatures::setStyleScopedEnabled(enable);
}

bool WebRuntimeFeatures::isStyleScopedEnabled()
{
    return RuntimeEnabledFeatures::styleScopedEnabled();
}

void WebRuntimeFeatures::enableInputTypeDateTime(bool enable)
{
    RuntimeEnabledFeatures::setInputTypeDateTimeEnabled(enable);
}

bool WebRuntimeFeatures::isInputTypeDateTimeEnabled()
{
    return RuntimeEnabledFeatures::inputTypeDateTimeEnabled();
}

void WebRuntimeFeatures::enableInputTypeWeek(bool enable)
{
    RuntimeEnabledFeatures::setInputTypeWeekEnabled(enable);
}

bool WebRuntimeFeatures::isInputTypeWeekEnabled()
{
    return RuntimeEnabledFeatures::inputTypeWeekEnabled();
}

void WebRuntimeFeatures::enableDialogElement(bool enable)
{
    RuntimeEnabledFeatures::setDialogElementEnabled(enable);
}

bool WebRuntimeFeatures::isDialogElementEnabled()
{
    return RuntimeEnabledFeatures::dialogElementEnabled();
}

void WebRuntimeFeatures::enableLazyLayout(bool enable)
{
    RuntimeEnabledFeatures::setLazyLayoutEnabled(enable);
}

bool WebRuntimeFeatures::isLazyLayoutEnabled()
{
    return RuntimeEnabledFeatures::lazyLayoutEnabled();
}

void WebRuntimeFeatures::enableExperimentalContentSecurityPolicyFeatures(bool enable)
{
    RuntimeEnabledFeatures::setExperimentalContentSecurityPolicyFeaturesEnabled(enable);
}

bool WebRuntimeFeatures::isExperimentalContentSecurityPolicyFeaturesEnabled()
{
    return RuntimeEnabledFeatures::experimentalContentSecurityPolicyFeaturesEnabled();
}

void WebRuntimeFeatures::enableSeamlessIFrames(bool enable)
{
    return RuntimeEnabledFeatures::setSeamlessIFramesEnabled(enable);
}

bool WebRuntimeFeatures::areSeamlessIFramesEnabled()
{
    return RuntimeEnabledFeatures::seamlessIFramesEnabled();
}

void WebRuntimeFeatures::enableCanvasPath(bool enable)
{
    RuntimeEnabledFeatures::setCanvasPathEnabled(enable);
}

bool WebRuntimeFeatures::isCanvasPathEnabled()
{
    return RuntimeEnabledFeatures::canvasPathEnabled();
}

void WebRuntimeFeatures::enableCSSExclusions(bool enable)
{
    RuntimeEnabledFeatures::setCSSExclusionsEnabled(enable);
}

bool WebRuntimeFeatures::isCSSExclusionsEnabled()
{
    return RuntimeEnabledFeatures::cssExclusionsEnabled();
}

void WebRuntimeFeatures::enableCSSRegions(bool enable)
{
    RuntimeEnabledFeatures::setCSSRegionsEnabled(enable);
}

bool WebRuntimeFeatures::isCSSRegionsEnabled()
{
    return RuntimeEnabledFeatures::cssRegionsEnabled();
}

void WebRuntimeFeatures::enableCSSCompositing(bool enable)
{
    RuntimeEnabledFeatures::setCSSCompositingEnabled(enable);
}

bool WebRuntimeFeatures::isCSSCompositingEnabled()
{
    return RuntimeEnabledFeatures::cssCompositingEnabled();
}

void WebRuntimeFeatures::enableFontLoadEvents(bool enable)
{
    RuntimeEnabledFeatures::setFontLoadEventsEnabled(enable);
}

bool WebRuntimeFeatures::isFontLoadEventsEnabled()
{
    return RuntimeEnabledFeatures::fontLoadEventsEnabled();
}

void WebRuntimeFeatures::enableRequestAutocomplete(bool enable)
{
    RuntimeEnabledFeatures::setRequestAutocompleteEnabled(enable);
}

bool WebRuntimeFeatures::isRequestAutocompleteEnabled()
{
    return RuntimeEnabledFeatures::requestAutocompleteEnabled();
}

void WebRuntimeFeatures::enableWebPInAcceptHeader(bool enable)
{
    RuntimeEnabledFeatures::setWebPInAcceptHeaderEnabled(enable);
}

bool WebRuntimeFeatures::isWebPInAcceptHeaderEnabled()
{
    return RuntimeEnabledFeatures::webPInAcceptHeaderEnabled();
}

void WebRuntimeFeatures::enableDirectoryUpload(bool enable)
{
    RuntimeEnabledFeatures::setDirectoryUploadEnabled(enable);
}

bool WebRuntimeFeatures::isDirectoryUploadEnabled()
{
    return RuntimeEnabledFeatures::directoryUploadEnabled();
}

void WebRuntimeFeatures::enableExperimentalWebSocket(bool enable)
{
    RuntimeEnabledFeatures::setExperimentalWebSocketEnabled(enable);
}

bool WebRuntimeFeatures::isExperimentalWebSocketEnabled()
{
    return RuntimeEnabledFeatures::experimentalWebSocketEnabled();
}

void WebRuntimeFeatures::enableWebMIDI(bool enable)
{
    return RuntimeEnabledFeatures::setWebMIDIEnabled(enable);
}

bool WebRuntimeFeatures::isWebMIDIEnabled()
{
    return RuntimeEnabledFeatures::webMIDIEnabled();
}

void WebRuntimeFeatures::enableIMEAPI(bool enable)
{
    RuntimeEnabledFeatures::setIMEAPIEnabled(enable);
}

bool WebRuntimeFeatures::isIMEAPIEnabled()
{
    return RuntimeEnabledFeatures::imeAPIEnabled();
}

void WebRuntimeFeatures::enableExperimentalCanvasFeatures(bool enable)
{
    RuntimeEnabledFeatures::setExperimentalCanvasFeaturesEnabled(enable);
}

bool WebRuntimeFeatures::areExperimentalCanvasFeaturesEnabled()
{
    return RuntimeEnabledFeatures::experimentalCanvasFeaturesEnabled();
}

void WebRuntimeFeatures::enableSpeechSynthesis(bool enable)
{
    RuntimeEnabledFeatures::setSpeechSynthesisEnabled(enable);
}

bool WebRuntimeFeatures::isSpeechSynthesisEnabled()
{
    return RuntimeEnabledFeatures::speechSynthesisEnabled();
}

} // namespace WebKit
