# Copyright (c) 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

#
# GNU Make based build file.  For details on GNU Make see:
#   http://www.gnu.org/software/make/manual/make.html
#
#


#
# Default configuration
#
# By default we will build a Debug configuration using the GCC newlib toolchain
# to override this, specify TOOLCHAIN=newlib|glibc or CONFIG=Debug|Release on
# the make command-line or in this file prior to including common.mk.  The
# toolchain we use by default will be the first valid one listed
VALID_TOOLCHAINS:={{' '.join(tools)}}


{{pre}}

#
# Get pepper directory for toolchain and includes.
#
# If NACL_SDK_ROOT is not set, then assume it can be found relative to
# to this Makefile.
#
NACL_SDK_ROOT?=$(abspath $(CURDIR)/{{rel_sdk}})
include $(NACL_SDK_ROOT)/tools/common.mk


#
# Target Name
#
# The base name of the final NEXE, also the name of the NMF file containing
# the mapping between architecture and actual NEXE.
#
TARGET={{targets[0]['NAME']}}

#
# List of sources to compile
#
[[for target in targets:]]
{{target['NAME']}}_SOURCES= \
[[  for source in sorted(target['SOURCES']):]]
[[    if not source.endswith('.h'):]]
  {{source}} \
[[  ]]

[[]]


#
# List of libraries to link against.  Unlike some tools, the GCC and LLVM
# based tools require libraries to be specified in the correct order.  The
# order should be symbol reference followed by symbol definition, with direct
# sources to the link (object files) are left most.  In this case:
#    hello_world -> ppapi_main -> ppapi_cpp -> ppapi -> pthread -> libc
# Notice that libc is implied and come last through standard compiler/link
# switches.
#
# We break this list down into two parts, the set we need to rebuild (DEPS)
# and the set we do not.  This example does not have a any additional library
# dependencies.
#
DEPS={{' '.join(targets[0].get('DEPS', []))}}
LIBS=$(DEPS) {{' '.join(targets[0].get('LIBS'))}}


#
# Use the library dependency macro for each dependency
#
$(foreach dep,$(DEPS),$(eval $(call DEPEND_RULE,$(dep))))

#
# Use the compile macro for each source.
#
[[for target in targets:]]
[[  name = target['NAME'] ]]
[[  flags = ' '.join(target.get('CCFLAGS', []))]]
[[  flags += ' '.join(target.get('CXXFLAGS', []))]]
$(foreach src,$({{name}}_SOURCES),$(eval $(call COMPILE_RULE,$(src),{{flags}})))
[[]]

#
# Use the link macro for this target on the list of sources.
#
[[for target in targets:]]
[[  name = target['NAME'] ]]
[[  if target['TYPE'] == 'so':]]
$(eval $(call SO_RULE,{{name}},$({{name}}_SOURCES)))
[[  elif target['TYPE'] == 'so-standalone':]]
$(eval $(call SO_RULE,{{name}},$({{name}}_SOURCES),,,1))
[[  else:]]
ifeq ($(CONFIG),Release)
$(eval $(call LINK_RULE,{{name}}_unstripped,$({{name}}_SOURCES),$(LIBS),$(DEPS)))
$(eval $(call STRIP_RULE,{{name}},{{name}}_unstripped))
else
$(eval $(call LINK_RULE,{{name}},$({{name}}_SOURCES),$(LIBS),$(DEPS)))
endif
[[]]

#
# Specify the NMF to be created with no additional arguments.
#
$(eval $(call NMF_RULE,$(TARGET),))

{{post}}

