# Copyright 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'targets': [
    {
      'target_name': 'browser',
      'type': 'static_library',
      'variables': { 'enable_wexit_time_destructors': 1, },
      'dependencies': [
        # NOTE: New dependencies should generally be added in the OS!="ios"
        # dependencies block below, rather than here.
        'browser/search_engines/prepopulated_engines.gyp:prepopulated_engines',
        'browser_ui',
        'cert_logger_proto',
        'chrome_resources.gyp:chrome_extra_resources',
        'chrome_resources.gyp:chrome_resources',
        'chrome_resources.gyp:chrome_strings',
        'chrome_resources.gyp:platform_locale_settings',
        'chrome_resources.gyp:theme_resources',
        'common',
        'common_net',
        'feedback_proto',
        'in_memory_url_index_cache_proto',
        'safe_browsing_proto',
        'safe_browsing_report_proto',
        'variations_seed_proto',
        '../build/temp_gyp/googleurl.gyp:googleurl',
        '../components/components.gyp:encryptor',
        '../components/components.gyp:sessions',
        '../components/components.gyp:user_prefs',
        '../components/components.gyp:visitedlink_browser',
        '../components/components.gyp:visitedlink_common',
        '../components/components.gyp:webdata_common',
        '../content/content.gyp:content_browser',
        '../content/content.gyp:content_common',
        '../crypto/crypto.gyp:crypto',
        '../google_apis/google_apis.gyp:google_apis',
        '../jingle/jingle.gyp:notifier',
        '../media/media.gyp:media',
        '../skia/skia.gyp:skia',
        '../sql/sql.gyp:sql',
        '../sync/sync.gyp:sync',
        '../third_party/bzip2/bzip2.gyp:bzip2',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation_proto_cpp',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../third_party/libjingle/libjingle.gyp:libjingle',
        '../third_party/libxml/libxml.gyp:libxml',
        '../third_party/widevine/cdm/widevine_cdm.gyp:widevine_cdm_version_h',
        '../third_party/zlib/zlib.gyp:zip',
        '../third_party/zlib/zlib.gyp:minizip',
        '../third_party/zlib/zlib.gyp:zlib',
        '../ui/base/strings/ui_strings.gyp:ui_strings',
        '../ui/ui.gyp:shell_dialogs',
        '../ui/ui.gyp:ui',
        '../ui/ui.gyp:ui_resources',
        '../webkit/support/webkit_support.gyp:user_agent',
      ],
      'include_dirs': [
        '..',
        '<(INTERMEDIATE_DIR)',
        # Needed by chrome_content_renderer_client.cc. &
        # plugin_info_message_filter.cc.
        '<(SHARED_INTERMEDIATE_DIR)',
      ],
      'export_dependent_settings': [
        '../sql/sql.gyp:sql',
        '../sync/sync.gyp:sync',
      ],
      'sources': [
        # All .cc, .h, .m, and .mm files under browser except for:
        # * tests and mocks.
        # * code below browser/chromeos
        # * code below browser/extensions
        'browser/about_flags.cc',
        'browser/about_flags.h',
        'browser/accessibility/accessibility_extension_api_constants.cc',
        'browser/accessibility/accessibility_extension_api_constants.h',
        'browser/accessibility/accessibility_events.cc',
        'browser/accessibility/accessibility_events.h',
        'browser/accessibility/invert_bubble_prefs.cc',
        'browser/accessibility/invert_bubble_prefs.h',
        'browser/android/chrome_jni_registrar.cc',
        'browser/android/chrome_jni_registrar.h',
        'browser/android/chrome_startup_flags.cc',
        'browser/android/chrome_startup_flags.h',
        'browser/android/chrome_web_contents_delegate_android.cc',
        'browser/android/chrome_web_contents_delegate_android.h',
        'browser/android/content_view_util.cc',
        'browser/android/content_view_util.h',
        'browser/android/crash_dump_manager.cc',
        'browser/android/crash_dump_manager.h',
        'browser/android/dev_tools_server.cc',
        'browser/android/dev_tools_server.h',
        'browser/android/google_location_settings_helper.h',
        'browser/android/infobar_stubs.cc',
        'browser/android/intent_helper.cc',
        'browser/android/intent_helper.h',
        'browser/android/intercept_download_resource_throttle.cc',
        'browser/android/intercept_download_resource_throttle.h',
        'browser/android/provider/blocking_ui_thread_async_request.cc',
        'browser/android/provider/blocking_ui_thread_async_request.h',
        'browser/android/provider/bookmark_model_observer_task.cc',
        'browser/android/provider/bookmark_model_observer_task.h',
        'browser/android/provider/chrome_browser_provider.cc',
        'browser/android/provider/chrome_browser_provider.h',
        'browser/android/provider/run_on_ui_thread_blocking.h',
        'browser/android/tab_android.cc',
        'browser/android/tab_android.h',
        'browser/app_controller_mac.h',
        'browser/app_controller_mac.mm',
        'browser/app_icon_win.cc',
        'browser/app_icon_win.h',
        'browser/app_mode/app_mode_utils.cc',
        'browser/app_mode/app_mode_utils.h',
        'browser/autocomplete/autocomplete_classifier.cc',
        'browser/autocomplete/autocomplete_classifier.h',
        'browser/autocomplete/autocomplete_classifier_factory.cc',
        'browser/autocomplete/autocomplete_classifier_factory.h',
        'browser/autocomplete/autocomplete_controller.cc',
        'browser/autocomplete/autocomplete_controller.h',
        'browser/autocomplete/autocomplete_controller_delegate.h',
        'browser/autocomplete/autocomplete_input.cc',
        'browser/autocomplete/autocomplete_input.h',
        'browser/autocomplete/autocomplete_log.cc',
        'browser/autocomplete/autocomplete_log.h',
        'browser/autocomplete/autocomplete_match.cc',
        'browser/autocomplete/autocomplete_match.h',
        'browser/autocomplete/autocomplete_provider.cc',
        'browser/autocomplete/autocomplete_provider.h',
        'browser/autocomplete/autocomplete_provider_listener.h',
        'browser/autocomplete/autocomplete_result.cc',
        'browser/autocomplete/autocomplete_result.h',
        'browser/autocomplete/bookmark_provider.cc',
        'browser/autocomplete/bookmark_provider.h',
        'browser/autocomplete/builtin_provider.cc',
        'browser/autocomplete/builtin_provider.h',
        'browser/autocomplete/contact_provider_chromeos.cc',
        'browser/autocomplete/contact_provider_chromeos.h',
        'browser/autocomplete/extension_app_provider.cc',
        'browser/autocomplete/extension_app_provider.h',
        'browser/autocomplete/history_contents_provider.cc',
        'browser/autocomplete/history_contents_provider.h',
        'browser/autocomplete/history_provider.cc',
        'browser/autocomplete/history_provider.h',
        'browser/autocomplete/history_provider_util.cc',
        'browser/autocomplete/history_provider_util.h',
        'browser/autocomplete/history_quick_provider.cc',
        'browser/autocomplete/history_quick_provider.h',
        'browser/autocomplete/history_url_provider.cc',
        'browser/autocomplete/history_url_provider.h',
        'browser/autocomplete/keyword_provider.cc',
        'browser/autocomplete/keyword_provider.h',
        'browser/autocomplete/search_provider.cc',
        'browser/autocomplete/search_provider.h',
        'browser/autocomplete/shortcuts_provider.cc',
        'browser/autocomplete/shortcuts_provider.h',
        'browser/autocomplete/url_prefix.cc',
        'browser/autocomplete/url_prefix.h',
        'browser/autocomplete/zero_suggest_provider.cc',
        'browser/autocomplete/zero_suggest_provider.h',
        'browser/autofill/android/personal_data_manager_android.cc',
        'browser/autofill/android/personal_data_manager_android.h',
        'browser/autofill/autocheckout_whitelist_manager_factory.cc',
        'browser/autofill/autocheckout_whitelist_manager_factory.h',
        'browser/autofill/autofill_cc_infobar_delegate.cc',
        'browser/autofill/autofill_cc_infobar_delegate.h',
        'browser/autofill/personal_data_manager_factory.cc',
        'browser/autofill/personal_data_manager_factory.h',
        'browser/auto_launch_trial.cc',
        'browser/auto_launch_trial.h',
        'browser/automation/automation_browser_tracker.cc',
        'browser/automation/automation_browser_tracker.h',
        'browser/automation/automation_event_observers.cc',
        'browser/automation/automation_event_observers.h',
        'browser/automation/automation_event_observers_chromeos.cc',
        'browser/automation/automation_event_queue.cc',
        'browser/automation/automation_event_queue.h',
        'browser/automation/automation_provider.cc',
        'browser/automation/automation_provider.h',
        'browser/automation/automation_provider_aura.cc',
        'browser/automation/automation_provider_gtk.cc',
        'browser/automation/automation_provider_json.cc',
        'browser/automation/automation_provider_json.h',
        'browser/automation/automation_provider_list.cc',
        'browser/automation/automation_provider_list.h',
        'browser/automation/automation_provider_list_generic.cc',
        'browser/automation/automation_provider_list_mac.mm',
        'browser/automation/automation_provider_mac.mm',
        'browser/automation/automation_provider_observers.cc',
        'browser/automation/automation_provider_observers.h',
        'browser/automation/automation_provider_observers_chromeos.cc',
        'browser/automation/automation_provider_win.cc',
        'browser/automation/automation_resource_message_filter.cc',
        'browser/automation/automation_resource_message_filter.h',
        'browser/automation/automation_resource_tracker.cc',
        'browser/automation/automation_resource_tracker.h',
        'browser/automation/automation_tab_helper.cc',
        'browser/automation/automation_tab_helper.h',
        'browser/automation/automation_tab_tracker.cc',
        'browser/automation/automation_tab_tracker.h',
        'browser/automation/automation_util.cc',
        'browser/automation/automation_util.h',
        'browser/automation/automation_window_tracker.cc',
        'browser/automation/automation_window_tracker.h',
        'browser/automation/chrome_frame_automation_provider_win.cc',
        'browser/automation/chrome_frame_automation_provider_win.h',
        'browser/automation/testing_automation_provider.cc',
        'browser/automation/testing_automation_provider.h',
        'browser/automation/testing_automation_provider_aura.cc',
        'browser/automation/testing_automation_provider_chromeos.cc',
        'browser/automation/testing_automation_provider_gtk.cc',
        'browser/automation/testing_automation_provider_mac.mm',
        'browser/automation/testing_automation_provider_views.cc',
        'browser/automation/testing_automation_provider_win.cc',
        'browser/automation/url_request_automation_job.cc',
        'browser/automation/url_request_automation_job.h',
        'browser/background/background_application_list_model.cc',
        'browser/background/background_application_list_model.h',
        'browser/background/background_contents_service.cc',
        'browser/background/background_contents_service.h',
        'browser/background/background_contents_service_factory.cc',
        'browser/background/background_contents_service_factory.h',
        'browser/background/background_mode_manager.cc',
        'browser/background/background_mode_manager.h',
        'browser/background/background_mode_manager_chromeos.cc',
        'browser/background/background_mode_manager_aura.cc',
        'browser/background/background_mode_manager_gtk.cc',
        'browser/background/background_mode_manager_mac.mm',
        'browser/background/background_mode_manager_win.cc',
        'browser/bookmarks/base_bookmark_model_observer.cc',
        'browser/bookmarks/base_bookmark_model_observer.h',
        'browser/bookmarks/bookmark_codec.cc',
        'browser/bookmarks/bookmark_codec.h',
        'browser/bookmarks/bookmark_editor.cc',
        'browser/bookmarks/bookmark_editor.h',
        'browser/bookmarks/bookmark_expanded_state_tracker.cc',
        'browser/bookmarks/bookmark_expanded_state_tracker.h',
        'browser/bookmarks/bookmark_html_writer.cc',
        'browser/bookmarks/bookmark_html_writer.h',
        'browser/bookmarks/bookmark_index.cc',
        'browser/bookmarks/bookmark_index.h',
        'browser/bookmarks/bookmark_model.cc',
        'browser/bookmarks/bookmark_model.h',
        'browser/bookmarks/bookmark_model_factory.cc',
        'browser/bookmarks/bookmark_model_factory.h',
        'browser/bookmarks/bookmark_model_observer.h',
        'browser/bookmarks/bookmark_node_data.cc',
        'browser/bookmarks/bookmark_node_data.h',
        'browser/bookmarks/bookmark_pasteboard_helper_mac.h',
        'browser/bookmarks/bookmark_pasteboard_helper_mac.mm',
        'browser/bookmarks/bookmark_prompt_prefs.cc',
        'browser/bookmarks/bookmark_prompt_prefs.h',
        'browser/bookmarks/bookmark_service.cc',
        'browser/bookmarks/bookmark_service.h',
        'browser/bookmarks/bookmark_storage.cc',
        'browser/bookmarks/bookmark_storage.h',
        'browser/bookmarks/bookmark_utils.cc',
        'browser/bookmarks/bookmark_utils.h',
        'browser/bookmarks/recently_used_folders_combo_model.cc',
        'browser/bookmarks/recently_used_folders_combo_model.h',
        'browser/browser_about_handler.cc',
        'browser/browser_about_handler.h',
        'browser/browser_process.cc',
        'browser/browser_process.h',
        'browser/browser_process_impl.cc',
        'browser/browser_process_impl.h',
        'browser/browser_process_impl_win.cc',
        'browser/browser_process_platform_part.cc',
        'browser/browser_process_platform_part.h',
        'browser/browser_process_platform_part_chromeos.cc',
        'browser/browser_process_platform_part_chromeos.h',
        'browser/browser_shutdown.cc',
        'browser/browser_shutdown.h',
        'browser/browser_util_win.cc',
        'browser/browser_util_win.h',
        'browser/browsing_data/browsing_data_appcache_helper.cc',
        'browser/browsing_data/browsing_data_appcache_helper.h',
        'browser/browsing_data/browsing_data_database_helper.cc',
        'browser/browsing_data/browsing_data_database_helper.h',
        'browser/browsing_data/browsing_data_file_system_helper.cc',
        'browser/browsing_data/browsing_data_file_system_helper.h',
        'browser/browsing_data/browsing_data_flash_lso_helper.cc',
        'browser/browsing_data/browsing_data_flash_lso_helper.h',
        'browser/browsing_data/browsing_data_helper.cc',
        'browser/browsing_data/browsing_data_helper.h',
        'browser/browsing_data/browsing_data_indexed_db_helper.cc',
        'browser/browsing_data/browsing_data_indexed_db_helper.h',
        'browser/browsing_data/browsing_data_local_storage_helper.cc',
        'browser/browsing_data/browsing_data_local_storage_helper.h',
        'browser/browsing_data/local_data_container.cc',
        'browser/browsing_data/local_data_container.h',
        'browser/browsing_data/browsing_data_quota_helper.cc',
        'browser/browsing_data/browsing_data_quota_helper.h',
        'browser/browsing_data/browsing_data_quota_helper_impl.cc',
        'browser/browsing_data/browsing_data_quota_helper_impl.h',
        'browser/browsing_data/browsing_data_remover.cc',
        'browser/browsing_data/browsing_data_remover.h',
        'browser/browsing_data/browsing_data_server_bound_cert_helper.cc',
        'browser/browsing_data/browsing_data_server_bound_cert_helper.h',
        'browser/browsing_data/browsing_data_cookie_helper.cc',
        'browser/browsing_data/browsing_data_cookie_helper.h',
        'browser/browsing_data/cookies_tree_model.cc',
        'browser/browsing_data/cookies_tree_model.h',
        'browser/feedback/feedback_data.cc',
        'browser/feedback/feedback_data.h',
        'browser/feedback/feedback_util.cc',
        'browser/feedback/feedback_util.h',
        'browser/captive_portal/captive_portal_detector.cc',
        'browser/captive_portal/captive_portal_detector.h',
        'browser/captive_portal/captive_portal_login_detector.cc',
        'browser/captive_portal/captive_portal_login_detector.h',
        'browser/captive_portal/captive_portal_service.cc',
        'browser/captive_portal/captive_portal_service.h',
        'browser/captive_portal/captive_portal_service_factory.cc',
        'browser/captive_portal/captive_portal_service_factory.h',
        'browser/captive_portal/captive_portal_tab_helper.cc',
        'browser/captive_portal/captive_portal_tab_helper.h',
        'browser/captive_portal/captive_portal_tab_reloader.cc',
        'browser/captive_portal/captive_portal_tab_reloader.h',
        'browser/certificate_manager_model.cc',
        'browser/certificate_manager_model.h',
        'browser/certificate_viewer.cc',
        'browser/certificate_viewer.h',
        'browser/character_encoding.cc',
        'browser/character_encoding.h',
        'browser/chrome_net_benchmarking_message_filter.cc',
        'browser/chrome_net_benchmarking_message_filter.h',
        'browser/chrome_browser_application_mac.h',
        'browser/chrome_browser_application_mac.mm',
        'browser/chrome_browser_field_trials.cc',
        'browser/chrome_browser_field_trials.h',
        'browser/chrome_browser_field_trials_desktop.cc',
        'browser/chrome_browser_field_trials_desktop.h',
        'browser/chrome_browser_field_trials_mobile.cc',
        'browser/chrome_browser_field_trials_mobile.h',
        'browser/chrome_browser_main.cc',
        'browser/chrome_browser_main.h',
        'browser/chrome_browser_main_android.cc',
        'browser/chrome_browser_main_android.h',
        'browser/chrome_browser_main_extra_parts.h',
        'browser/chrome_browser_main_linux.cc',
        'browser/chrome_browser_main_linux.h',
        'browser/chrome_browser_main_mac.h',
        'browser/chrome_browser_main_mac.mm',
        'browser/chrome_browser_main_posix.cc',
        'browser/chrome_browser_main_posix.h',
        'browser/chrome_browser_main_win.cc',
        'browser/chrome_browser_main_win.h',
        'browser/chrome_browser_main_x11.cc',
        'browser/chrome_browser_main_x11.h',
        'browser/chrome_content_browser_client.cc',
        'browser/chrome_content_browser_client.h',
        'browser/chrome_page_zoom.cc',
        'browser/chrome_page_zoom.h',
        'browser/chrome_page_zoom_constants.cc',
        'browser/chrome_page_zoom_constants.h',
        'browser/chrome_process_singleton.cc',
        'browser/chrome_process_singleton.h',
        'browser/chrome_quota_permission_context.cc',
        'browser/chrome_quota_permission_context.h',
        'browser/chrome_to_mobile_service.cc',
        'browser/chrome_to_mobile_service.h',
        'browser/chrome_to_mobile_service_factory.cc',
        'browser/chrome_to_mobile_service_factory.h',
        'browser/command_observer.h',
        'browser/command_updater.cc',
        'browser/command_updater.h',
        'browser/command_updater_delegate.h',
        'browser/common/cancelable_request.cc',
        'browser/common/cancelable_request.h',
        'browser/component_updater/component_updater_configurator.cc',
        'browser/component_updater/component_updater_configurator.h',
        'browser/component_updater/component_unpacker.cc',
        'browser/component_updater/component_unpacker.h',
        'browser/component_updater/component_updater_service.cc',
        'browser/component_updater/component_updater_service.h',
        'browser/component_updater/flash_component_installer.h',
        'browser/component_updater/pepper_flash_component_installer.cc',
        'browser/component_updater/pnacl/pnacl_component_installer.cc',
        'browser/component_updater/pnacl/pnacl_component_installer.h',
        'browser/component_updater/pnacl/pnacl_profile_observer.cc',
        'browser/component_updater/pnacl/pnacl_profile_observer.h',
        'browser/component_updater/recovery_component_installer.cc',
        'browser/component_updater/recovery_component_installer.h',
        'browser/component_updater/swiftshader_component_installer.cc',
        'browser/component_updater/swiftshader_component_installer.h',
        'browser/component_updater/widevine_cdm_component_installer.cc',
        'browser/component_updater/widevine_cdm_component_installer.h',
        'browser/content_settings/content_settings_default_provider.cc',
        'browser/content_settings/content_settings_default_provider.h',
        'browser/content_settings/content_settings_details.cc',
        'browser/content_settings/content_settings_details.h',
        'browser/content_settings/content_settings_custom_extension_provider.cc',
        'browser/content_settings/content_settings_custom_extension_provider.h',
        'browser/content_settings/content_settings_observable_provider.cc',
        'browser/content_settings/content_settings_observable_provider.h',
        'browser/content_settings/content_settings_observer.h',
        'browser/content_settings/content_settings_origin_identifier_value_map.cc',
        'browser/content_settings/content_settings_origin_identifier_value_map.h',
        'browser/content_settings/content_settings_internal_extension_provider.cc',
        'browser/content_settings/content_settings_internal_extension_provider.h',
        'browser/content_settings/content_settings_policy_provider.cc',
        'browser/content_settings/content_settings_policy_provider.h',
        'browser/content_settings/content_settings_pref_provider.cc',
        'browser/content_settings/content_settings_pref_provider.h',
        'browser/content_settings/content_settings_provider.h',
        'browser/content_settings/content_settings_rule.cc',
        'browser/content_settings/content_settings_rule.h',
        'browser/content_settings/content_settings_utils.cc',
        'browser/content_settings/content_settings_utils.h',
        'browser/content_settings/cookie_settings.cc',
        'browser/content_settings/cookie_settings.h',
        'browser/content_settings/host_content_settings_map.cc',
        'browser/content_settings/host_content_settings_map.h',
        'browser/content_settings/local_shared_objects_container.cc',
        'browser/content_settings/local_shared_objects_container.h',
        'browser/content_settings/tab_specific_content_settings.cc',
        'browser/content_settings/tab_specific_content_settings.h',
        'browser/crash_upload_list.cc',
        'browser/crash_upload_list.h',
        'browser/crash_upload_list_win.cc',
        'browser/crash_upload_list_win.h',
        'browser/custom_handlers/protocol_handler_registry.cc',
        'browser/custom_handlers/protocol_handler_registry.h',
        'browser/custom_handlers/protocol_handler_registry_factory.cc',
        'browser/custom_handlers/protocol_handler_registry_factory.h',
        'browser/custom_handlers/register_protocol_handler_infobar_delegate.cc',
        'browser/custom_handlers/register_protocol_handler_infobar_delegate.h',
        'browser/custom_home_pages_table_model.cc',
        'browser/custom_home_pages_table_model.h',
        'browser/defaults.cc',
        'browser/defaults.h',
        'browser/diagnostics/diagnostics_main.cc',
        'browser/diagnostics/diagnostics_main.h',
        'browser/diagnostics/diagnostics_model.cc',
        'browser/diagnostics/diagnostics_model.h',
        'browser/diagnostics/diagnostics_test.cc',
        'browser/diagnostics/diagnostics_test.h',
        'browser/diagnostics/recon_diagnostics.cc',
        'browser/diagnostics/recon_diagnostics.h',
        'browser/diagnostics/sqlite_diagnostics.cc',
        'browser/diagnostics/sqlite_diagnostics.h',
        'browser/download/chrome_download_manager_delegate.cc',
        'browser/download/chrome_download_manager_delegate.h',
        'browser/download/download_completion_blocker.cc',
        'browser/download/download_completion_blocker.h',
        'browser/download/download_crx_util.cc',
        'browser/download/download_crx_util.h',
        'browser/download/download_crx_util_android.cc',
        'browser/download/download_extensions.cc',
        'browser/download/download_extensions.h',
        'browser/download/download_file_picker.cc',
        'browser/download/download_file_picker.h',
        'browser/download/download_history.cc',
        'browser/download/download_history.h',
        'browser/download/download_item_model.cc',
        'browser/download/download_item_model.h',
        'browser/download/download_prefs.cc',
        'browser/download/download_prefs.h',
        'browser/download/download_query.cc',
        'browser/download/download_query.h',
        'browser/download/download_request_infobar_delegate.cc',
        'browser/download/download_request_infobar_delegate.h',
        'browser/download/download_request_limiter.cc',
        'browser/download/download_request_limiter.h',
        'browser/download/download_path_reservation_tracker.cc',
        'browser/download/download_path_reservation_tracker.h',
        'browser/download/download_service.cc',
        'browser/download/download_service.h',
        'browser/download/download_service_factory.cc',
        'browser/download/download_service_factory.h',
        'browser/download/download_danger_prompt.cc',
        'browser/download/download_danger_prompt.h',
        'browser/download/download_shelf.h',
        'browser/download/download_shelf.cc',
        'browser/download/download_shelf_context_menu.cc',
        'browser/download/download_shelf_context_menu.h',
        'browser/download/download_started_animation.h',
        'browser/download/download_resource_throttle.cc',
        'browser/download/download_resource_throttle.h',
        'browser/download/download_status_updater.cc',
        'browser/download/download_status_updater.h',
        'browser/download/download_status_updater_gtk.cc',
        'browser/download/download_status_updater_mac.mm',
        'browser/download/download_status_updater_win.cc',
        'browser/download/download_target_determiner.cc',
        'browser/download/download_target_determiner.h',
        'browser/download/download_target_determiner_delegate.h',
        'browser/download/download_ui_controller.cc',
        'browser/download/download_ui_controller.h',
        'browser/download/download_util.cc',
        'browser/download/download_util.h',
        'browser/download/all_download_item_notifier.cc',
        'browser/download/all_download_item_notifier.h',
        'browser/download/save_package_file_picker.cc',
        'browser/download/save_package_file_picker.h',
        'browser/download/save_package_file_picker_chromeos.cc',
        'browser/download/save_package_file_picker_chromeos.h',
        'browser/enumerate_modules_model_win.cc',
        'browser/enumerate_modules_model_win.h',
        'browser/extensions/token_cache/token_cache_service.cc',
        'browser/extensions/token_cache/token_cache_service.h',
        'browser/extensions/token_cache/token_cache_service_factory.cc',
        'browser/extensions/token_cache/token_cache_service_factory.h',
        'browser/external_protocol/external_protocol_handler.cc',
        'browser/external_protocol/external_protocol_handler.h',
        'browser/external_protocol/external_protocol_observer.cc',
        'browser/external_protocol/external_protocol_observer.h',
        'browser/external_tab/external_tab_container.h',
        'browser/favicon/favicon_handler.cc',
        'browser/favicon/favicon_handler.h',
        'browser/favicon/favicon_handler_delegate.h',
        'browser/favicon/favicon_service.cc',
        'browser/favicon/favicon_service.h',
        'browser/favicon/favicon_service_factory.cc',
        'browser/favicon/favicon_service_factory.h',
        'browser/favicon/favicon_tab_helper.cc',
        'browser/favicon/favicon_tab_helper.h',
        'browser/favicon/favicon_util.cc',
        'browser/favicon/favicon_util.h',
        'browser/file_select_helper.cc',
        'browser/file_select_helper.h',
        'browser/first_run/first_run.cc',
        'browser/first_run/first_run.h',
        'browser/first_run/first_run_dialog.h',
        'browser/first_run/first_run_internal.h',
        'browser/first_run/first_run_linux.cc',
        'browser/first_run/first_run_mac.mm',
        'browser/first_run/first_run_posix.cc',
        'browser/first_run/first_run_win.cc',
        'browser/first_run/try_chrome_dialog_view.cc',
        'browser/first_run/try_chrome_dialog_view.h',
        'browser/first_run/upgrade_util.cc',
        'browser/first_run/upgrade_util.h',
        'browser/first_run/upgrade_util_linux.cc',
        'browser/first_run/upgrade_util_linux.h',
        'browser/first_run/upgrade_util_mac.cc',
        'browser/first_run/upgrade_util_win.cc',
        'browser/first_run/upgrade_util_win.h',
        'browser/fullscreen.h',
        'browser/fullscreen_aura.cc',
        'browser/fullscreen_chromeos.cc',
        'browser/fullscreen_gtk.cc',
        'browser/fullscreen_mac.mm',
        'browser/fullscreen_win.cc',
        'browser/geolocation/chrome_access_token_store.cc',
        'browser/geolocation/chrome_access_token_store.h',
        'browser/geolocation/chrome_geolocation_permission_context.cc',
        'browser/geolocation/chrome_geolocation_permission_context.h',
        'browser/geolocation/chrome_geolocation_permission_context_android.cc',
        'browser/geolocation/chrome_geolocation_permission_context_android.h',
        'browser/geolocation/chrome_geolocation_permission_context_factory.cc',
        'browser/geolocation/chrome_geolocation_permission_context_factory.h',
        'browser/geolocation/geolocation_infobar_delegate.cc',
        'browser/geolocation/geolocation_infobar_delegate.h',
        'browser/geolocation/geolocation_infobar_delegate_android.cc',
        'browser/geolocation/geolocation_infobar_delegate_android.h',
        'browser/geolocation/geolocation_infobar_queue_controller.cc',
        'browser/geolocation/geolocation_infobar_queue_controller.h',
        'browser/geolocation/geolocation_permission_request_id.cc',
        'browser/geolocation/geolocation_permission_request_id.h',
        'browser/geolocation/geolocation_prefs.cc',
        'browser/geolocation/geolocation_prefs.h',
        'browser/geolocation/geolocation_settings_state.cc',
        'browser/geolocation/geolocation_settings_state.h',
        'browser/global_keyboard_shortcuts_mac.h',
        'browser/global_keyboard_shortcuts_mac.mm',
        'browser/google/google_search_counter.cc',
        'browser/google/google_search_counter.h',
        'browser/google/google_search_metrics.cc',
        'browser/google/google_search_metrics.h',
        'browser/google/google_update_settings_posix.cc',
        'browser/google/google_update_win.cc',
        'browser/google/google_update_win.h',
        'browser/google/google_url_tracker.cc',
        'browser/google/google_url_tracker.h',
        'browser/google/google_url_tracker_factory.cc',
        'browser/google/google_url_tracker_factory.h',
        'browser/google/google_url_tracker_infobar_delegate.cc',
        'browser/google/google_url_tracker_infobar_delegate.h',
        'browser/google/google_url_tracker_map_entry.cc',
        'browser/google/google_url_tracker_map_entry.h',
        'browser/google/google_url_tracker_navigation_helper.h',
        'browser/google/google_url_tracker_navigation_helper_impl.cc',
        'browser/google/google_url_tracker_navigation_helper_impl.h',
        'browser/google/google_util.cc',
        'browser/google/google_util.h',
        'browser/google/google_util_chromeos.cc',
        'browser/google/google_util_chromeos.h',
        'browser/google_apis/auth_service.cc',
        'browser/google_apis/auth_service.h',
        'browser/google_apis/auth_service_interface.h',
        'browser/google_apis/auth_service_observer.h',
        'browser/google_apis/base_operations.cc',
        'browser/google_apis/base_operations.h',
        'browser/google_apis/drive_api_operations.cc',
        'browser/google_apis/drive_api_operations.h',
        'browser/google_apis/drive_api_parser.cc',
        'browser/google_apis/drive_api_parser.h',
        'browser/google_apis/drive_api_service.cc',
        'browser/google_apis/drive_api_service.h',
        'browser/google_apis/drive_api_url_generator.cc',
        'browser/google_apis/drive_api_url_generator.h',
        'browser/google_apis/drive_api_util.cc',
        'browser/google_apis/drive_api_util.h',
        'browser/google_apis/drive_entry_kinds.h',
        'browser/google_apis/drive_notification_manager_factory.cc',
        'browser/google_apis/drive_notification_manager_factory.h',
        'browser/google_apis/drive_notification_manager.cc',
        'browser/google_apis/drive_notification_manager.h',
        'browser/google_apis/drive_notification_observer.h',
        'browser/google_apis/drive_service_interface.h',
        'browser/google_apis/drive_switches.cc',
        'browser/google_apis/drive_switches.h',
        'browser/google_apis/drive_upload_mode.h',
        'browser/google_apis/drive_uploader.cc',
        'browser/google_apis/drive_uploader.h',
        'browser/google_apis/event_logger.cc',
        'browser/google_apis/event_logger.h',
        'browser/google_apis/gdata_contacts_operations.cc',
        'browser/google_apis/gdata_contacts_operations.h',
        'browser/google_apis/gdata_errorcode.h',
        'browser/google_apis/gdata_wapi_operations.cc',
        'browser/google_apis/gdata_wapi_operations.h',
        'browser/google_apis/gdata_wapi_parser.cc',
        'browser/google_apis/gdata_wapi_parser.h',
        'browser/google_apis/gdata_wapi_service.cc',
        'browser/google_apis/gdata_wapi_service.h',
        'browser/google_apis/gdata_wapi_url_generator.cc',
        'browser/google_apis/gdata_wapi_url_generator.h',
        'browser/google_apis/operation_registry.cc',
        'browser/google_apis/operation_registry.h',
        'browser/google_apis/operation_runner.cc',
        'browser/google_apis/operation_runner.h',
        'browser/google_apis/operation_util.cc',
        'browser/google_apis/operation_util.h',
        'browser/google_apis/task_util.cc',
        'browser/google_apis/task_util.h',
        'browser/google_apis/time_util.cc',
        'browser/google_apis/time_util.h',
        'browser/gpu/chrome_gpu_util.cc',
        'browser/gpu/chrome_gpu_util.h',
        'browser/gpu/gl_string_manager.cc',
        'browser/gpu/gl_string_manager.h',
        'browser/gpu/gpu_feature_checker.cc',
        'browser/gpu/gpu_feature_checker.h',
        'browser/gpu/gpu_mode_manager.cc',
        'browser/gpu/gpu_mode_manager.h',
        'browser/hang_monitor/hang_crash_dump_win.cc',
        'browser/hang_monitor/hang_crash_dump_win.h',
        'browser/hang_monitor/hung_plugin_action.cc',
        'browser/hang_monitor/hung_plugin_action.h',
        'browser/hang_monitor/hung_window_detector.cc',
        'browser/hang_monitor/hung_window_detector.h',
        'browser/history/android/android_cache_database.cc',
        'browser/history/android/android_cache_database.h',
        'browser/history/android/android_history_provider_service.cc',
        'browser/history/android/android_history_provider_service.h',
        'browser/history/android/android_history_types.cc',
        'browser/history/android/android_history_types.h',
        'browser/history/android/android_provider_backend.cc',
        'browser/history/android/android_provider_backend.h',
        'browser/history/android/android_time.h',
        'browser/history/android/android_urls_database.cc',
        'browser/history/android/android_urls_database.h',
        'browser/history/android/android_urls_sql_handler.cc',
        'browser/history/android/android_urls_sql_handler.h',
        'browser/history/android/bookmark_model_sql_handler.cc',
        'browser/history/android/bookmark_model_sql_handler.h',
        'browser/history/android/favicon_sql_handler.cc',
        'browser/history/android/favicon_sql_handler.h',
        'browser/history/android/sql_handler.cc',
        'browser/history/android/sql_handler.h',
        'browser/history/android/sqlite_cursor.cc',
        'browser/history/android/sqlite_cursor.h',
        'browser/history/android/urls_sql_handler.cc',
        'browser/history/android/urls_sql_handler.h',
        'browser/history/android/visit_sql_handler.cc',
        'browser/history/android/visit_sql_handler.h',
        'browser/history/archived_database.cc',
        'browser/history/archived_database.h',
        'browser/history/delete_directive_handler.cc',
        'browser/history/delete_directive_handler.h',
        'browser/history/download_database.cc',
        'browser/history/download_database.h',
        'browser/history/download_row.cc',
        'browser/history/download_row.h',
        'browser/history/expire_history_backend.cc',
        'browser/history/expire_history_backend.h',
        'browser/history/history_backend.cc',
        'browser/history/history_backend.h',
        'browser/history/history_backend_android.cc',
        'browser/history/history_database.cc',
        'browser/history/history_database.h',
        'browser/history/history_db_task.h',
        'browser/history/history_marshaling.h',
        'browser/history/history_marshaling_android.h',
        'browser/history/history_notifications.cc',
        'browser/history/history_notifications.h',
        'browser/history/history_publisher.cc',
        'browser/history/history_publisher.h',
        'browser/history/history_publisher_none.cc',
        'browser/history/history_publisher_win.cc',
        'browser/history/history_service.cc',
        'browser/history/history_service.h',
        'browser/history/history_service_factory.cc',
        'browser/history/history_service_factory.h',
        'browser/history/history_tab_helper.cc',
        'browser/history/history_tab_helper.h',
        'browser/history/history_types.cc',
        'browser/history/history_types.h',
        'browser/history/in_memory_database.cc',
        'browser/history/in_memory_database.h',
        'browser/history/in_memory_history_backend.cc',
        'browser/history/in_memory_history_backend.h',
        'browser/history/in_memory_url_index.cc',
        'browser/history/in_memory_url_index.h',
        'browser/history/in_memory_url_index_types.cc',
        'browser/history/in_memory_url_index_types.h',
        'browser/history/page_usage_data.cc',
        'browser/history/page_usage_data.h',
        'browser/history/query_parser.cc',
        'browser/history/query_parser.h',
        'browser/history/scored_history_match.cc',
        'browser/history/scored_history_match.h',
        'browser/history/select_favicon_frames.cc',
        'browser/history/select_favicon_frames.h',
        'browser/history/snippet.cc',
        'browser/history/snippet.h',
        'browser/history/shortcuts_backend.cc',
        'browser/history/shortcuts_backend.h',
        'browser/history/shortcuts_backend_factory.cc',
        'browser/history/shortcuts_backend_factory.h',
        'browser/history/shortcuts_database.cc',
        'browser/history/shortcuts_database.h',
        'browser/history/text_database.cc',
        'browser/history/text_database.h',
        'browser/history/text_database_manager.cc',
        'browser/history/text_database_manager.h',
        'browser/history/thumbnail_database.cc',
        'browser/history/thumbnail_database.h',
        'browser/history/top_sites.cc',
        'browser/history/top_sites.h',
        'browser/history/top_sites_backend.cc',
        'browser/history/top_sites_backend.h',
        'browser/history/top_sites_cache.cc',
        'browser/history/top_sites_cache.h',
        'browser/history/top_sites_database.cc',
        'browser/history/top_sites_database.h',
        'browser/history/top_sites_impl.cc',
        'browser/history/top_sites_impl.h',
        'browser/history/top_sites_likely_impl.cc',
        'browser/history/top_sites_likely_impl.h',
        'browser/history/url_database.cc',
        'browser/history/url_database.h',
        'browser/history/url_index_private_data.cc',
        'browser/history/url_index_private_data.h',
        'browser/history/visit_database.cc',
        'browser/history/visit_database.h',
        'browser/history/visit_filter.cc',
        'browser/history/visit_filter.h',
        'browser/history/visit_tracker.cc',
        'browser/history/visit_tracker.h',
        'browser/history/visitsegment_database.cc',
        'browser/history/visitsegment_database.h',
        'browser/history/web_history_service.cc',
        'browser/history/web_history_service.h',
        'browser/history/web_history_service_factory.cc',
        'browser/history/web_history_service_factory.h',
        'browser/icon_loader.cc',
        'browser/icon_loader.h',
        'browser/icon_loader_android.cc',
        'browser/icon_loader_chromeos.cc',
        'browser/icon_loader_linux.cc',
        'browser/icon_loader_mac.mm',
        'browser/icon_loader_win.cc',
        'browser/icon_manager.cc',
        'browser/icon_manager.h',
        'browser/idle.cc',
        'browser/idle.h',
        'browser/idle_android.cc',
        'browser/idle_chromeos.cc',
        'browser/idle_linux.cc',
        'browser/idle_mac.mm',
        'browser/idle_query_x11.cc',
        'browser/idle_query_x11.h',
        'browser/idle_win.cc',
        'browser/image_decoder.cc',
        'browser/image_decoder.h',
        'browser/importer/external_process_importer_bridge.cc',
        'browser/importer/external_process_importer_bridge.h',
        'browser/importer/external_process_importer_client.cc',
        'browser/importer/external_process_importer_client.h',
        'browser/importer/external_process_importer_host.cc',
        'browser/importer/external_process_importer_host.h',
        'browser/importer/firefox2_importer.cc',
        'browser/importer/firefox2_importer.h',
        'browser/importer/firefox3_importer.cc',
        'browser/importer/firefox3_importer.h',
        'browser/importer/firefox_importer_utils.cc',
        'browser/importer/firefox_importer_utils.h',
        'browser/importer/firefox_importer_utils_linux.cc',
        'browser/importer/firefox_importer_utils_mac.mm',
        'browser/importer/firefox_importer_utils_win.cc',
        'browser/importer/firefox_profile_lock.cc',
        'browser/importer/firefox_profile_lock.h',
        'browser/importer/firefox_profile_lock_posix.cc',
        'browser/importer/firefox_profile_lock_win.cc',
        'browser/importer/firefox_proxy_settings.cc',
        'browser/importer/firefox_proxy_settings.h',
        'browser/importer/ie_importer.cc',
        'browser/importer/ie_importer.h',
        'browser/importer/ie_importer_test_registry_overrider_win.cc',
        'browser/importer/ie_importer_test_registry_overrider_win.h',
        'browser/importer/importer.cc',
        'browser/importer/importer.h',
        'browser/importer/importer_bridge.cc',
        'browser/importer/importer_bridge.h',
        'browser/importer/importer_data_types.cc',
        'browser/importer/importer_data_types.h',
        'browser/importer/importer_host.cc',
        'browser/importer/importer_host.h',
        'browser/importer/importer_list.cc',
        'browser/importer/importer_list.h',
        'browser/importer/importer_list_observer.h',
        'browser/importer/importer_lock_dialog.h',
        'browser/importer/importer_progress_observer.h',
        'browser/importer/importer_type.cc',
        'browser/importer/importer_type.h',
        'browser/importer/importer_util.cc',
        'browser/importer/importer_util.h',
        'browser/importer/in_process_importer_bridge.cc',
        'browser/importer/in_process_importer_bridge.h',
        'browser/importer/mork_reader.cc',
        'browser/importer/mork_reader.h',
        'browser/importer/nss_decryptor.cc',
        'browser/importer/nss_decryptor.h',
        'browser/importer/nss_decryptor_mac.h',
        'browser/importer/nss_decryptor_mac.mm',
        'browser/importer/nss_decryptor_system_nss.cc',
        'browser/importer/nss_decryptor_system_nss.h',
        'browser/importer/nss_decryptor_win.cc',
        'browser/importer/nss_decryptor_win.h',
        'browser/importer/profile_import_process_messages.cc',
        'browser/importer/profile_import_process_messages.h',
        'browser/importer/profile_writer.cc',
        'browser/importer/profile_writer.h',
        'browser/importer/safari_importer.h',
        'browser/importer/safari_importer.mm',
        'browser/importer/toolbar_importer.cc',
        'browser/importer/toolbar_importer.h',
        'browser/importer/toolbar_importer_utils.cc',
        'browser/importer/toolbar_importer_utils.h',
        'browser/infobars/confirm_infobar_delegate.cc',
        'browser/infobars/confirm_infobar_delegate.h',
        'browser/infobars/infobar.cc',
        'browser/infobars/infobar.h',
        'browser/infobars/infobar_container.cc',
        'browser/infobars/infobar_container.h',
        'browser/infobars/infobar_delegate.cc',
        'browser/infobars/infobar_delegate.h',
        'browser/infobars/infobar_service.cc',
        'browser/infobars/infobar_service.h',
        'browser/infobars/insecure_content_infobar_delegate.cc',
        'browser/infobars/insecure_content_infobar_delegate.h',
        'browser/infobars/simple_alert_infobar_delegate.cc',
        'browser/infobars/simple_alert_infobar_delegate.h',
        'browser/internal_auth.cc',
        'browser/internal_auth.h',
        'browser/intranet_redirect_detector.cc',
        'browser/intranet_redirect_detector.h',
        'browser/io_thread.cc',
        'browser/io_thread.h',
        'browser/jankometer.cc',
        'browser/jankometer.h',
        'browser/jankometer_android.cc',
        'browser/jankometer_mac.cc',
        'browser/jumplist_win.cc',
        'browser/jumplist_win.h',
        'browser/language_usage_metrics.cc',
        'browser/language_usage_metrics.h',
        'browser/lifetime/application_lifetime.cc',
        'browser/lifetime/application_lifetime.h',
        'browser/lifetime/application_lifetime_android.cc',
        'browser/lifetime/application_lifetime_android.h',
        'browser/lifetime/application_lifetime_aura.cc',
        'browser/lifetime/application_lifetime_gtk.cc',
        'browser/lifetime/application_lifetime_mac.mm',
        'browser/lifetime/application_lifetime_stub.cc',
        'browser/lifetime/application_lifetime_win.cc',
        'browser/mac/dock.h',
        'browser/mac/dock.mm',
        'browser/mac/install_from_dmg.h',
        'browser/mac/install_from_dmg.mm',
        'browser/mac/keychain_reauthorize.h',
        'browser/mac/keychain_reauthorize.mm',
        'browser/mac/keystone_glue.h',
        'browser/mac/keystone_glue.mm',
        'browser/mac/keystone_registration.h',
        'browser/mac/keystone_registration.mm',
        'browser/mac/master_prefs.h',
        'browser/mac/master_prefs.mm',
        'browser/mac/relauncher.cc',
        'browser/mac/relauncher.h',
        'browser/mac/security_wrappers.cc',
        'browser/mac/security_wrappers.h',
        'browser/managed_mode/managed_mode.cc',
        'browser/managed_mode/managed_mode.h',
        'browser/managed_mode/managed_mode_interstitial.cc',
        'browser/managed_mode/managed_mode_interstitial.h',
        'browser/managed_mode/managed_mode_navigation_observer.cc',
        'browser/managed_mode/managed_mode_navigation_observer.h',
        'browser/managed_mode/managed_mode_resource_throttle.cc',
        'browser/managed_mode/managed_mode_resource_throttle.h',
        'browser/managed_mode/managed_mode_site_list.cc',
        'browser/managed_mode/managed_mode_site_list.h',
        'browser/managed_mode/managed_mode_url_filter.cc',
        'browser/managed_mode/managed_mode_url_filter.h',
        'browser/managed_mode/managed_user_passphrase.cc',
        'browser/managed_mode/managed_user_passphrase.h',
        'browser/managed_mode/managed_user_service.cc',
        'browser/managed_mode/managed_user_service.h',
        'browser/managed_mode/managed_user_service_factory.cc',
        'browser/managed_mode/managed_user_service_factory.h',
        'browser/managed_mode/scoped_extension_elevation.cc',
        'browser/managed_mode/scoped_extension_elevation.h',
        'browser/media/audio_stream_indicator.cc',
        'browser/media/audio_stream_indicator.h',
        'browser/media/media_capture_devices_dispatcher.cc',
        'browser/media/media_capture_devices_dispatcher.h',
        'browser/media/media_stream_capture_indicator.cc',
        'browser/media/media_stream_capture_indicator.h',
        'browser/media/media_stream_devices_controller.cc',
        'browser/media/media_stream_devices_controller.h',
        'browser/media/media_stream_infobar_delegate.cc',
        'browser/media/media_stream_infobar_delegate.h',
        'browser/media_galleries/fileapi/filtering_file_enumerator.cc',
        'browser/media_galleries/fileapi/filtering_file_enumerator.h',
        'browser/media_galleries/fileapi/itunes_finder.cc',
        'browser/media_galleries/fileapi/itunes_finder.h',
        'browser/media_galleries/fileapi/itunes_finder_win.cc',
        'browser/media_galleries/fileapi/itunes_finder_win.h',
        'browser/media_galleries/fileapi/media_file_system_mount_point_provider.cc',
        'browser/media_galleries/fileapi/media_file_system_mount_point_provider.h',
        'browser/media_galleries/fileapi/media_path_filter.cc',
        'browser/media_galleries/fileapi/media_path_filter.h',
        'browser/media_galleries/fileapi/mtp_device_file_system_config.h',
        'browser/media_galleries/fileapi/native_media_file_util.cc',
        'browser/media_galleries/fileapi/native_media_file_util.h',
        'browser/media_galleries/fileapi/picasa/picasa_album_table_reader.cc',
        'browser/media_galleries/fileapi/picasa/picasa_album_table_reader.h',
        'browser/media_galleries/fileapi/picasa/pmp_column_reader.cc',
        'browser/media_galleries/fileapi/picasa/pmp_column_reader.h',
        'browser/media_galleries/fileapi/picasa/pmp_constants.h',
        'browser/media_galleries/fileapi/picasa/pmp_table_reader.cc',
        'browser/media_galleries/fileapi/picasa/pmp_table_reader.h',
        'browser/media_galleries/linux/mtp_device_delegate_impl_linux.cc',
        'browser/media_galleries/linux/mtp_device_delegate_impl_linux.h',
        'browser/media_galleries/linux/mtp_device_object_enumerator.cc',
        'browser/media_galleries/linux/mtp_device_object_enumerator.h',
        'browser/media_galleries/linux/mtp_device_task_helper.cc',
        'browser/media_galleries/linux/mtp_device_task_helper.h',
        'browser/media_galleries/linux/mtp_device_task_helper_map_service.cc',
        'browser/media_galleries/linux/mtp_device_task_helper_map_service.h',
        'browser/media_galleries/linux/mtp_read_file_worker.cc',
        'browser/media_galleries/linux/mtp_read_file_worker.h',
        'browser/media_galleries/linux/snapshot_file_details.cc',
        'browser/media_galleries/linux/snapshot_file_details.h',
        'browser/media_galleries/mac/mtp_device_delegate_impl_mac.h',
        'browser/media_galleries/mac/mtp_device_delegate_impl_mac.mm',
        'browser/media_galleries/media_file_system_registry.cc',
        'browser/media_galleries/media_file_system_registry.h',
        'browser/media_galleries/media_galleries_dialog_controller.cc',
        'browser/media_galleries/media_galleries_dialog_controller.h',
        'browser/media_galleries/media_galleries_preferences.cc',
        'browser/media_galleries/media_galleries_preferences.h',
        'browser/media_galleries/media_galleries_preferences_factory.cc',
        'browser/media_galleries/media_galleries_preferences_factory.h',
        'browser/media_galleries/mtp_device_delegate_impl.h',
        'browser/media_galleries/scoped_mtp_device_map_entry.cc',
        'browser/media_galleries/scoped_mtp_device_map_entry.h',
        'browser/media_galleries/win/mtp_device_delegate_impl_win.cc',
        'browser/media_galleries/win/mtp_device_delegate_impl_win.h',
        'browser/media_galleries/win/mtp_device_object_entry.cc',
        'browser/media_galleries/win/mtp_device_object_entry.h',
        'browser/media_galleries/win/mtp_device_object_enumerator.cc',
        'browser/media_galleries/win/mtp_device_object_enumerator.h',
        'browser/media_galleries/win/mtp_device_operations_util.cc',
        'browser/media_galleries/win/mtp_device_operations_util.h',
        'browser/media_galleries/win/portable_device_map_service.cc',
        'browser/media_galleries/win/portable_device_map_service.h',
        'browser/media_galleries/win/snapshot_file_details.cc',
        'browser/media_galleries/win/snapshot_file_details.h',
        'browser/memory_details.cc',
        'browser/memory_details.h',
        'browser/memory_details_android.cc',
        'browser/memory_details_linux.cc',
        'browser/memory_details_mac.cc',
        'browser/memory_details_win.cc',
        'browser/memory_purger.cc',
        'browser/memory_purger.h',
        'browser/metrics/chrome_browser_main_extra_parts_metrics.cc',
        'browser/metrics/chrome_browser_main_extra_parts_metrics.h',
        'browser/metrics/field_trial_synchronizer.cc',
        'browser/metrics/field_trial_synchronizer.h',
        'browser/metrics/metric_event_duration_details.h',
        'browser/metrics/metrics_log.cc',
        'browser/metrics/metrics_log.h',
        'browser/metrics/metrics_log_serializer.cc',
        'browser/metrics/metrics_log_serializer.h',
        'browser/metrics/metrics_network_observer.cc',
        'browser/metrics/metrics_network_observer.h',
        'browser/metrics/metrics_reporting_scheduler.cc',
        'browser/metrics/metrics_reporting_scheduler.h',
        'browser/metrics/metrics_service.cc',
        'browser/metrics/metrics_service.h',
        'browser/metrics/perf_provider_chromeos.cc',
        'browser/metrics/perf_provider_chromeos.h',
        'browser/metrics/thread_watcher.cc',
        'browser/metrics/thread_watcher.h',
        'browser/metrics/time_ticks_experiment_win.cc',
        'browser/metrics/time_ticks_experiment_win.h',
        'browser/metrics/tracking_synchronizer.cc',
        'browser/metrics/tracking_synchronizer.h',
        'browser/metrics/tracking_synchronizer_observer.h',
        'browser/metrics/variations/eula_accepted_notifier.cc',
        'browser/metrics/variations/eula_accepted_notifier.h',
        'browser/metrics/variations/eula_accepted_notifier_chromeos.cc',
        'browser/metrics/variations/eula_accepted_notifier_chromeos.h',
        'browser/metrics/variations/eula_accepted_notifier_mobile.cc',
        'browser/metrics/variations/eula_accepted_notifier_mobile.h',
        'browser/metrics/variations/resource_request_allowed_notifier.cc',
        'browser/metrics/variations/resource_request_allowed_notifier.h',
        'browser/metrics/variations/variations_http_header_provider.cc',
        'browser/metrics/variations/variations_http_header_provider.h',
        'browser/metrics/variations/variations_registry_syncer_win.cc',
        'browser/metrics/variations/variations_registry_syncer_win.h',
        'browser/metrics/variations/variations_request_scheduler.cc',
        'browser/metrics/variations/variations_request_scheduler.h',
        'browser/metrics/variations/variations_request_scheduler_mobile.cc',
        'browser/metrics/variations/variations_request_scheduler_mobile.h',
        'browser/metrics/variations/variations_service.cc',
        'browser/metrics/variations/variations_service.h',
        'browser/native_window_notification_source.h',
        'browser/net/about_protocol_handler.cc',
        'browser/net/about_protocol_handler.h',
        'browser/net/async_dns_field_trial.cc',
        'browser/net/async_dns_field_trial.h',
        'browser/net/basic_http_user_agent_settings.cc',
        'browser/net/basic_http_user_agent_settings.h',
        'browser/net/chrome_cookie_notification_details.h',
        'browser/net/chrome_fraudulent_certificate_reporter.cc',
        'browser/net/chrome_fraudulent_certificate_reporter.h',
        'browser/net/chrome_http_user_agent_settings.cc',
        'browser/net/chrome_http_user_agent_settings.h',
        'browser/net/chrome_net_log.cc',
        'browser/net/chrome_net_log.h',
        'browser/net/chrome_network_delegate.cc',
        'browser/net/chrome_network_delegate.h',
        'browser/net/chrome_url_request_context.cc',
        'browser/net/chrome_url_request_context.h',
        'browser/net/connect_interceptor.cc',
        'browser/net/connect_interceptor.h',
        'browser/net/connection_tester.cc',
        'browser/net/connection_tester.h',
        'browser/net/crl_set_fetcher.cc',
        'browser/net/crl_set_fetcher.h',
        'browser/net/dns_probe_job.cc',
        'browser/net/dns_probe_job.h',
        'browser/net/dns_probe_service.cc',
        'browser/net/dns_probe_service.h',
        'browser/net/evicted_domain_cookie_counter.cc',
        'browser/net/evicted_domain_cookie_counter.h',
        'browser/net/gaia/gaia_oauth_consumer.h',
        'browser/net/gaia/gaia_oauth_fetcher.cc',
        'browser/net/gaia/gaia_oauth_fetcher.h',
        'browser/net/http_pipelining_compatibility_client.cc',
        'browser/net/http_pipelining_compatibility_client.h',
        'browser/net/http_server_properties_manager.h',
        'browser/net/http_server_properties_manager.cc',
        'browser/net/load_time_stats.cc',
        'browser/net/load_time_stats.h',
        'browser/net/net_error_tab_helper.cc',
        'browser/net/net_error_tab_helper.h',
        'browser/net/net_log_logger.cc',
        'browser/net/net_log_logger.h',
        'browser/net/net_log_temp_file.cc',
        'browser/net/net_log_temp_file.h',
        'browser/net/net_pref_observer.cc',
        'browser/net/net_pref_observer.h',
        'browser/net/network_stats.cc',
        'browser/net/network_stats.h',
        'browser/net/network_time_tracker.cc',
        'browser/net/network_time_tracker.h',
        'browser/net/preconnect.cc',
        'browser/net/preconnect.h',
        'browser/net/predictor.cc',
        'browser/net/predictor.h',
        'browser/net/pref_proxy_config_tracker.h',
        'browser/net/pref_proxy_config_tracker_impl.cc',
        'browser/net/pref_proxy_config_tracker_impl.h',
        'browser/net/proxy_service_factory.cc',
        'browser/net/proxy_service_factory.h',
        'browser/net/referrer.cc',
        'browser/net/referrer.h',
        'browser/net/resource_prefetch_predictor_observer.cc',
        'browser/net/resource_prefetch_predictor_observer.h',
        'browser/net/sdch_dictionary_fetcher.cc',
        'browser/net/sdch_dictionary_fetcher.h',
        'browser/net/service_providers_win.cc',
        'browser/net/service_providers_win.h',
        'browser/net/spdyproxy/http_auth_handler_spdyproxy.cc',
        'browser/net/spdyproxy/http_auth_handler_spdyproxy.h',
        'browser/net/sqlite_server_bound_cert_store.cc',
        'browser/net/sqlite_server_bound_cert_store.h',
        'browser/net/ssl_config_service_manager.h',
        'browser/net/ssl_config_service_manager_pref.cc',
        'browser/net/transport_security_persister.cc',
        'browser/net/transport_security_persister.h',
        'browser/net/url_fixer_upper.cc',
        'browser/net/url_fixer_upper.h',
        'browser/net/url_info.cc',
        'browser/net/url_info.h',
        'browser/notifications/balloon.cc',
        'browser/notifications/balloon.h',
        'browser/notifications/balloon_collection.cc',
        'browser/notifications/balloon_collection.h',
        'browser/notifications/balloon_collection_base.cc',
        'browser/notifications/balloon_collection_base.h',
        'browser/notifications/balloon_collection_impl.cc',
        'browser/notifications/balloon_collection_impl.h',
        'browser/notifications/balloon_host.cc',
        'browser/notifications/balloon_host.h',
        'browser/notifications/balloon_notification_ui_manager.cc',
        'browser/notifications/balloon_notification_ui_manager.h',
        'browser/notifications/desktop_notification_service.cc',
        'browser/notifications/desktop_notification_service.h',
        'browser/notifications/desktop_notification_service_factory.cc',
        'browser/notifications/desktop_notification_service_factory.h',
        'browser/notifications/desktop_notification_service_win.cc',
        'browser/notifications/fake_balloon_view.cc',
        'browser/notifications/fake_balloon_view.h',
        'browser/notifications/message_center_notification_manager.cc',
        'browser/notifications/message_center_notification_manager.h',
        'browser/notifications/message_center_settings_controller.cc',
        'browser/notifications/message_center_settings_controller.h',
        'browser/notifications/notification.cc',
        'browser/notifications/notification.h',
        'browser/notifications/notification_delegate.cc',
        'browser/notifications/notification_delegate.h',
        'browser/notifications/notification_object_proxy.cc',
        'browser/notifications/notification_object_proxy.h',
        'browser/notifications/notification_options_menu_model.cc',
        'browser/notifications/notification_options_menu_model.h',
        'browser/notifications/notification_prefs_manager.cc',
        'browser/notifications/notification_prefs_manager.h',
        'browser/notifications/notification_ui_manager.cc',
        'browser/notifications/notification_ui_manager.h',
        'browser/notifications/notification_ui_manager_impl.cc',
        'browser/notifications/notification_ui_manager_impl.h',
        'browser/notifications/notification_ui_manager_mac.mm',
        'browser/notifications/notification_ui_manager_mac.h',
        'browser/notifications/sync_notifier/chrome_notifier_delegate.cc',
        'browser/notifications/sync_notifier/chrome_notifier_delegate.h',
        'browser/notifications/sync_notifier/chrome_notifier_service.cc',
        'browser/notifications/sync_notifier/chrome_notifier_service.h',
        'browser/notifications/sync_notifier/chrome_notifier_service_factory.cc',
        'browser/notifications/sync_notifier/chrome_notifier_service_factory.h',
        'browser/notifications/sync_notifier/synced_notification.cc',
        'browser/notifications/sync_notifier/synced_notification.h',
        'browser/omnibox_search_hint.cc',
        'browser/omnibox_search_hint.h',
        'browser/omnibox/omnibox_field_trial.cc',
        'browser/omnibox/omnibox_field_trial.h',
        'browser/page_cycler/page_cycler.cc',
        'browser/page_cycler/page_cycler.h',
        'browser/parsers/metadata_parser.cc',
        'browser/parsers/metadata_parser.h',
        'browser/parsers/metadata_parser_factory.h',
        'browser/parsers/metadata_parser_filebase.cc',
        'browser/parsers/metadata_parser_filebase.h',
        'browser/parsers/metadata_parser_jpeg.cc',
        'browser/parsers/metadata_parser_jpeg.h',
        'browser/parsers/metadata_parser_jpeg_factory.cc',
        'browser/parsers/metadata_parser_jpeg_factory.h',
        'browser/parsers/metadata_parser_manager.cc',
        'browser/parsers/metadata_parser_manager.h',
        'browser/password_manager/login_database.cc',
        'browser/password_manager/login_database.h',
        'browser/password_manager/login_database_mac.cc',
        'browser/password_manager/login_database_posix.cc',
        'browser/password_manager/login_database_win.cc',
        'browser/password_manager/native_backend_gnome_x.cc',
        'browser/password_manager/native_backend_gnome_x.h',
        'browser/password_manager/native_backend_kwallet_x.cc',
        'browser/password_manager/native_backend_kwallet_x.h',
        'browser/password_manager/password_form_manager.cc',
        'browser/password_manager/password_form_manager.h',
        'browser/password_manager/password_generation_manager.cc',
        'browser/password_manager/password_generation_manager.h',
        'browser/password_manager/password_manager.cc',
        'browser/password_manager/password_manager.h',
        'browser/password_manager/password_manager_delegate.h',
        'browser/password_manager/password_manager_delegate_impl.cc',
        'browser/password_manager/password_manager_delegate_impl.h',
        'browser/password_manager/password_store.cc',
        'browser/password_manager/password_store.h',
        'browser/password_manager/password_store_consumer.cc',
        'browser/password_manager/password_store_consumer.h',
        'browser/password_manager/password_store_default.cc',
        'browser/password_manager/password_store_default.h',
        'browser/password_manager/password_store_factory.cc',
        'browser/password_manager/password_store_factory.h',
        'browser/password_manager/password_store_mac.cc',
        'browser/password_manager/password_store_mac.h',
        'browser/password_manager/password_store_mac_internal.h',
        'browser/password_manager/password_store_win.cc',
        'browser/password_manager/password_store_win.h',
        'browser/password_manager/password_store_x.cc',
        'browser/password_manager/password_store_x.h',
        'browser/pepper_broker_infobar_delegate.cc',
        'browser/pepper_broker_infobar_delegate.h',
        'browser/pepper_flash_settings_manager.cc',
        'browser/pepper_flash_settings_manager.h',
        'browser/performance_monitor/constants.cc',
        'browser/performance_monitor/constants.h',
        'browser/performance_monitor/database.cc',
        'browser/performance_monitor/database.h',
        'browser/performance_monitor/event.cc',
        'browser/performance_monitor/event.h',
        'browser/performance_monitor/key_builder.cc',
        'browser/performance_monitor/key_builder.h',
        'browser/performance_monitor/metric.cc',
        'browser/performance_monitor/metric.h',
        'browser/performance_monitor/performance_monitor.cc',
        'browser/performance_monitor/performance_monitor.h',
        'browser/performance_monitor/performance_monitor_util.cc',
        'browser/performance_monitor/performance_monitor_util.h',
        'browser/performance_monitor/startup_timer.cc',
        'browser/performance_monitor/startup_timer.h',
        'browser/platform_util.h',
        'browser/platform_util_android.cc',
        'browser/platform_util_aura.cc',
        'browser/platform_util_chromeos.cc',
        'browser/platform_util_common_linux.cc',
        'browser/platform_util_linux.cc',
        'browser/platform_util_mac.mm',
        'browser/platform_util_win.cc',
        'browser/plugins/chrome_plugin_service_filter.cc',
        'browser/plugins/chrome_plugin_service_filter.h',
        'browser/plugins/plugins_resource_service.cc',
        'browser/plugins/plugins_resource_service.h',
        'browser/plugins/plugin_data_remover_helper.cc',
        'browser/plugins/plugin_data_remover_helper.h',
        'browser/plugins/plugin_finder.cc',
        'browser/plugins/plugin_finder.h',
        'browser/plugins/plugin_infobar_delegates.cc',
        'browser/plugins/plugin_infobar_delegates.h',
        'browser/plugins/plugin_info_message_filter.cc',
        'browser/plugins/plugin_info_message_filter.h',
        'browser/plugins/plugin_installer.cc',
        'browser/plugins/plugin_installer.h',
        'browser/plugins/plugin_installer_observer.cc',
        'browser/plugins/plugin_installer_observer.h',
        'browser/plugins/plugin_metadata.cc',
        'browser/plugins/plugin_metadata.h',
        'browser/plugins/plugin_observer.cc',
        'browser/plugins/plugin_observer.h',
        'browser/plugins/plugin_prefs.cc',
        'browser/plugins/plugin_prefs.h',
        'browser/plugins/plugin_prefs_factory.cc',
        'browser/plugins/plugin_prefs_factory.h',
        'browser/plugins/plugin_status_pref_setter.cc',
        'browser/plugins/plugin_status_pref_setter.h',
        'browser/policy/async_policy_loader.cc',
        'browser/policy/async_policy_loader.h',
        'browser/policy/async_policy_provider.cc',
        'browser/policy/async_policy_provider.h',
        'browser/policy/browser_policy_connector.cc',
        'browser/policy/browser_policy_connector.h',
        'browser/policy/cloud/cloud_policy_client.cc',
        'browser/policy/cloud/cloud_policy_client.h',
        'browser/policy/cloud/cloud_policy_constants.cc',
        'browser/policy/cloud/cloud_policy_constants.h',
        'browser/policy/cloud/cloud_policy_core.cc',
        'browser/policy/cloud/cloud_policy_core.h',
        'browser/policy/cloud/cloud_policy_manager.cc',
        'browser/policy/cloud/cloud_policy_manager.h',
        'browser/policy/cloud/cloud_policy_refresh_scheduler.cc',
        'browser/policy/cloud/cloud_policy_refresh_scheduler.h',
        'browser/policy/cloud/cloud_policy_service.cc',
        'browser/policy/cloud/cloud_policy_service.h',
        'browser/policy/cloud/cloud_policy_store.cc',
        'browser/policy/cloud/cloud_policy_store.h',
        'browser/policy/cloud/cloud_policy_validator.cc',
        'browser/policy/cloud/cloud_policy_validator.h',
        'browser/policy/cloud/component_cloud_policy_service.cc',
        'browser/policy/cloud/component_cloud_policy_service.h',
        'browser/policy/cloud/component_cloud_policy_store.cc',
        'browser/policy/cloud/component_cloud_policy_store.h',
        'browser/policy/cloud/component_cloud_policy_updater.cc',
        'browser/policy/cloud/component_cloud_policy_updater.h',
        'browser/policy/cloud/device_management_service.cc',
        'browser/policy/cloud/device_management_service.h',
        'browser/policy/cloud/enterprise_metrics.cc',
        'browser/policy/cloud/enterprise_metrics.h',
        'browser/policy/cloud/external_policy_data_updater.cc',
        'browser/policy/cloud/external_policy_data_updater.h',
        'browser/policy/cloud/message_util.cc',
        'browser/policy/cloud/message_util.h',
        'browser/policy/cloud/rate_limiter.cc',
        'browser/policy/cloud/rate_limiter.h',
        'browser/policy/cloud/resource_cache.cc',
        'browser/policy/cloud/resource_cache.h',
        'browser/policy/cloud/user_cloud_policy_manager.cc',
        'browser/policy/cloud/user_cloud_policy_manager.h',
        'browser/policy/cloud/user_cloud_policy_manager_factory.cc',
        'browser/policy/cloud/user_cloud_policy_manager_factory.h',
        'browser/policy/cloud/user_cloud_policy_store.cc',
        'browser/policy/cloud/user_cloud_policy_store.h',
        'browser/policy/cloud/user_cloud_policy_store_base.cc',
        'browser/policy/cloud/user_cloud_policy_store_base.h',
        'browser/policy/cloud/user_info_fetcher.cc',
        'browser/policy/cloud/user_info_fetcher.h',
        'browser/policy/cloud/user_policy_signin_service.cc',
        'browser/policy/cloud/user_policy_signin_service.h',
        'browser/policy/cloud/user_policy_signin_service_factory.cc',
        'browser/policy/cloud/user_policy_signin_service_factory.h',
        'browser/policy/config_dir_policy_loader.cc',
        'browser/policy/config_dir_policy_loader.h',
        'browser/policy/configuration_policy_handler.cc',
        'browser/policy/configuration_policy_handler.h',
        'browser/policy/configuration_policy_handler_list.cc',
        'browser/policy/configuration_policy_handler_list.h',
        'browser/policy/configuration_policy_pref_store.cc',
        'browser/policy/configuration_policy_pref_store.h',
        'browser/policy/configuration_policy_provider.cc',
        'browser/policy/configuration_policy_provider.h',
        'browser/policy/managed_mode_policy_provider.cc',
        'browser/policy/managed_mode_policy_provider.h',
        'browser/policy/policy_bundle.cc',
        'browser/policy/policy_bundle.h',
        'browser/policy/policy_error_map.cc',
        'browser/policy/policy_error_map.h',
        'browser/policy/policy_load_status.cc',
        'browser/policy/policy_load_status.h',
        'browser/policy/policy_loader_mac.cc',
        'browser/policy/policy_loader_mac.h',
        'browser/policy/policy_loader_win.cc',
        'browser/policy/policy_loader_win.h',
        'browser/policy/policy_map.cc',
        'browser/policy/policy_map.h',
        'browser/policy/policy_path_parser.h',
        'browser/policy/policy_path_parser_linux.cc',
        'browser/policy/policy_path_parser_mac.mm',
        'browser/policy/policy_path_parser_win.cc',
        'browser/policy/policy_service.cc',
        'browser/policy/policy_service.h',
        'browser/policy/policy_service_impl.cc',
        'browser/policy/policy_service_impl.h',
        'browser/policy/policy_service_stub.cc',
        'browser/policy/policy_service_stub.h',
        'browser/policy/policy_statistics_collector.cc',
        'browser/policy/policy_statistics_collector.h',
        'browser/policy/policy_types.h',
        'browser/policy/preferences_mac.cc',
        'browser/policy/preferences_mac.h',
        'browser/policy/preg_parser_win.cc',
        'browser/policy/preg_parser_win.h',
        'browser/policy/profile_policy_connector.cc',
        'browser/policy/profile_policy_connector_stub.cc',
        'browser/policy/profile_policy_connector.h',
        'browser/policy/profile_policy_connector_factory.cc',
        'browser/policy/profile_policy_connector_factory.h',
        'browser/policy/url_blacklist_manager.cc',
        'browser/policy/url_blacklist_manager.h',
        'browser/predictors/autocomplete_action_predictor.cc',
        'browser/predictors/autocomplete_action_predictor.h',
        'browser/predictors/autocomplete_action_predictor_factory.cc',
        'browser/predictors/autocomplete_action_predictor_factory.h',
        'browser/predictors/autocomplete_action_predictor_table.cc',
        'browser/predictors/autocomplete_action_predictor_table.h',
        'browser/predictors/logged_in_predictor_table.cc',
        'browser/predictors/logged_in_predictor_table.h',
        'browser/predictors/predictor_database.cc',
        'browser/predictors/predictor_database.h',
        'browser/predictors/predictor_database_factory.cc',
        'browser/predictors/predictor_database_factory.h',
        'browser/predictors/predictor_table_base.cc',
        'browser/predictors/predictor_table_base.h',
        'browser/predictors/resource_prefetch_common.cc',
        'browser/predictors/resource_prefetch_common.h',
        'browser/predictors/resource_prefetch_predictor.cc',
        'browser/predictors/resource_prefetch_predictor.h',
        'browser/predictors/resource_prefetch_predictor_factory.cc',
        'browser/predictors/resource_prefetch_predictor_factory.h',
        'browser/predictors/resource_prefetch_predictor_tables.cc',
        'browser/predictors/resource_prefetch_predictor_tables.h',
        'browser/predictors/resource_prefetcher.cc',
        'browser/predictors/resource_prefetcher.h',
        'browser/predictors/resource_prefetcher_manager.cc',
        'browser/predictors/resource_prefetcher_manager.h',
        'browser/prefs/browser_prefs.cc',
        'browser/prefs/browser_prefs.h',
        'browser/prefs/chrome_pref_service_factory.cc',
        'browser/prefs/chrome_pref_service_factory.h',
        'browser/prefs/command_line_pref_store.cc',
        'browser/prefs/command_line_pref_store.h',
        'browser/prefs/incognito_mode_prefs.cc',
        'browser/prefs/incognito_mode_prefs.h',
        'browser/prefs/pref_model_associator.cc',
        'browser/prefs/pref_model_associator.h',
        'browser/prefs/pref_service_syncable.cc',
        'browser/prefs/pref_service_syncable.h',
        'browser/prefs/pref_service_syncable_builder.cc',
        'browser/prefs/pref_service_syncable_builder.h',
        'browser/prefs/pref_service_syncable_observer.h',
        'browser/prefs/proxy_config_dictionary.cc',
        'browser/prefs/proxy_config_dictionary.h',
        'browser/prefs/proxy_prefs.cc',
        'browser/prefs/proxy_prefs.h',
        'browser/prefs/scoped_user_pref_update.cc',
        'browser/prefs/scoped_user_pref_update.h',
        'browser/prefs/session_startup_pref.cc',
        'browser/prefs/session_startup_pref.h',
        'browser/prerender/prerender_condition.h',
        'browser/prerender/prerender_config.cc',
        'browser/prerender/prerender_config.h',
        'browser/prerender/prerender_contents.cc',
        'browser/prerender/prerender_contents.h',
        'browser/prerender/prerender_field_trial.cc',
        'browser/prerender/prerender_field_trial.h',
        'browser/prerender/prerender_final_status.cc',
        'browser/prerender/prerender_final_status.h',
        'browser/prerender/prerender_handle.cc',
        'browser/prerender/prerender_handle.h',
        'browser/prerender/prerender_histograms.cc',
        'browser/prerender/prerender_histograms.h',
        'browser/prerender/prerender_history.cc',
        'browser/prerender/prerender_history.h',
        'browser/prerender/prerender_link_manager.cc',
        'browser/prerender/prerender_link_manager.h',
        'browser/prerender/prerender_link_manager_factory.cc',
        'browser/prerender/prerender_link_manager_factory.h',
        'browser/prerender/prerender_local_predictor.cc',
        'browser/prerender/prerender_local_predictor.h',
        'browser/prerender/prerender_manager.cc',
        'browser/prerender/prerender_manager.h',
        'browser/prerender/prerender_manager_factory.cc',
        'browser/prerender/prerender_manager_factory.h',
        'browser/prerender/prerender_message_filter.cc',
        'browser/prerender/prerender_message_filter.h',
        'browser/prerender/prerender_origin.cc',
        'browser/prerender/prerender_origin.h',
        'browser/prerender/prerender_render_view_host_observer.cc',
        'browser/prerender/prerender_render_view_host_observer.h',
        'browser/prerender/prerender_tab_helper.cc',
        'browser/prerender/prerender_tab_helper.h',
        'browser/prerender/prerender_tracker.cc',
        'browser/prerender/prerender_tracker.h',
        'browser/prerender/prerender_util.cc',
        'browser/prerender/prerender_util.h',
        'browser/printing/background_printing_manager.cc',
        'browser/printing/background_printing_manager.h',
        'browser/printing/cloud_print/cloud_print_proxy_service.cc',
        'browser/printing/cloud_print/cloud_print_proxy_service.h',
        'browser/printing/cloud_print/cloud_print_proxy_service_factory.cc',
        'browser/printing/cloud_print/cloud_print_proxy_service_factory.h',
        'browser/printing/cloud_print/cloud_print_setup_flow.cc',
        'browser/printing/cloud_print/cloud_print_setup_flow.h',
        'browser/printing/cloud_print/cloud_print_setup_handler.cc',
        'browser/printing/cloud_print/cloud_print_setup_handler.h',
        'browser/printing/cloud_print/cloud_print_setup_message_handler.cc',
        'browser/printing/cloud_print/cloud_print_setup_message_handler.h',
        'browser/printing/cloud_print/cloud_print_setup_source.cc',
        'browser/printing/cloud_print/cloud_print_setup_source.h',
        'browser/printing/cloud_print/cloud_print_url.cc',
        'browser/printing/cloud_print/cloud_print_url.h',
        'browser/printing/print_dialog_cloud.cc',
        'browser/printing/print_dialog_cloud.h',
        'browser/printing/print_dialog_gtk.cc',
        'browser/printing/print_dialog_gtk.h',
        'browser/printing/print_error_dialog.cc',
        'browser/printing/print_error_dialog.h',
        'browser/printing/print_job.cc',
        'browser/printing/print_job.h',
        'browser/printing/print_job_manager.cc',
        'browser/printing/print_job_manager.h',
        'browser/printing/print_job_worker.cc',
        'browser/printing/print_job_worker.h',
        'browser/printing/print_job_worker_owner.h',
        'browser/printing/print_preview_context_menu_observer.cc',
        'browser/printing/print_preview_context_menu_observer.h',
        'browser/printing/print_preview_data_service.cc',
        'browser/printing/print_preview_data_service.h',
        'browser/printing/print_preview_dialog_controller.cc',
        'browser/printing/print_preview_dialog_controller.h',
        'browser/printing/print_preview_message_handler.cc',
        'browser/printing/print_preview_message_handler.h',
        'browser/printing/print_system_task_proxy.cc',
        'browser/printing/print_system_task_proxy.h',
        'browser/printing/print_view_manager.cc',
        'browser/printing/print_view_manager.h',
        'browser/printing/print_view_manager_observer.h',
        'browser/printing/printer_manager_dialog.h',
        'browser/printing/printer_manager_dialog_linux.cc',
        'browser/printing/printer_manager_dialog_mac.mm',
        'browser/printing/printer_manager_dialog_win.cc',
        'browser/printing/printer_query.cc',
        'browser/printing/printer_query.h',
        'browser/printing/printing_message_filter.cc',
        'browser/printing/printing_message_filter.h',
        'browser/process_info_snapshot.h',
        'browser/process_info_snapshot_mac.cc',
        'browser/process_singleton.h',
        'browser/process_singleton_linux.cc',
        'browser/process_singleton_mac.cc',
        'browser/process_singleton_modal_dialog_lock.cc',
        'browser/process_singleton_modal_dialog_lock.h',
        'browser/process_singleton_startup_lock.cc',
        'browser/process_singleton_startup_lock.h',
        'browser/process_singleton_win.cc',
        'browser/profile_resetter/profile_resetter.h',
        'browser/profile_resetter/profile_resetter.cc',
        'browser/profiles/avatar_menu_model.cc',
        'browser/profiles/avatar_menu_model.h',
        'browser/profiles/avatar_menu_model_observer.h',
        'browser/profiles/bookmark_model_loaded_observer.cc',
        'browser/profiles/bookmark_model_loaded_observer.h',
        'browser/profiles/chrome_version_service.cc',
        'browser/profiles/chrome_version_service.h',
        'browser/profiles/dependency_graph.cc',
        'browser/profiles/dependency_graph.h',
        'browser/profiles/dependency_node.h',
        'browser/profiles/gaia_info_update_service.cc',
        'browser/profiles/gaia_info_update_service.h',
        'browser/profiles/gaia_info_update_service_factory.cc',
        'browser/profiles/gaia_info_update_service_factory.h',
        'browser/profiles/incognito_helpers.cc',
        'browser/profiles/incognito_helpers.h',
        'browser/profiles/off_the_record_profile_impl.cc',
        'browser/profiles/off_the_record_profile_impl.h',
        'browser/profiles/off_the_record_profile_io_data.cc',
        'browser/profiles/off_the_record_profile_io_data.h',
        'browser/profiles/profile.cc',
        'browser/profiles/profile.h',
        'browser/profiles/profile_android.cc',
        'browser/profiles/profile_android.h',
        'browser/profiles/profile_dependency_manager.cc',
        'browser/profiles/profile_dependency_manager.h',
        'browser/profiles/profile_destroyer.cc',
        'browser/profiles/profile_destroyer.h',
        'browser/profiles/profile_downloader.cc',
        'browser/profiles/profile_downloader.h',
        'browser/profiles/profile_downloader_delegate.h',
        'browser/profiles/profile_impl.cc',
        'browser/profiles/profile_impl.h',
        'browser/profiles/profile_impl_io_data.cc',
        'browser/profiles/profile_impl_io_data.h',
        'browser/profiles/profile_info_cache.cc',
        'browser/profiles/profile_info_cache.h',
        'browser/profiles/profile_info_cache_observer.h',
        'browser/profiles/profile_info_interface.h',
        'browser/profiles/profile_info_util.cc',
        'browser/profiles/profile_info_util.h',
        'browser/profiles/profile_io_data.cc',
        'browser/profiles/profile_io_data.h',
        'browser/profiles/profile_keyed_base_factory.h',
        'browser/profiles/profile_keyed_base_factory.cc',
        'browser/profiles/profile_keyed_service.h',
        'browser/profiles/profile_keyed_service_factory.cc',
        'browser/profiles/profile_keyed_service_factory.h',
        'browser/profiles/profile_manager.cc',
        'browser/profiles/profile_manager.h',
        'browser/profiles/profile_metrics.cc',
        'browser/profiles/profile_metrics.h',
        'browser/profiles/profile_shortcut_manager.cc',
        'browser/profiles/profile_shortcut_manager.h',
        'browser/profiles/profile_shortcut_manager_stub.cc',
        'browser/profiles/profile_shortcut_manager_win.cc',
        'browser/profiles/profile_shortcut_manager_win.h',
        'browser/profiles/refcounted_profile_keyed_service.cc',
        'browser/profiles/refcounted_profile_keyed_service.h',
        'browser/profiles/refcounted_profile_keyed_service_factory.cc',
        'browser/profiles/refcounted_profile_keyed_service_factory.h',
        'browser/profiles/startup_task_runner_service.cc',
        'browser/profiles/startup_task_runner_service.h',
        'browser/profiles/startup_task_runner_service_factory.cc',
        'browser/profiles/startup_task_runner_service_factory.h',
        'browser/profiles/storage_partition_descriptor.h',
        'browser/remove_rows_table_model.h',
        'browser/renderer_host/chrome_render_message_filter.cc',
        'browser/renderer_host/chrome_render_message_filter.h',
        'browser/renderer_host/chrome_render_view_host_observer.cc',
        'browser/renderer_host/chrome_render_view_host_observer.h',
        'browser/renderer_host/chrome_render_widget_host_view_mac_delegate.h',
        'browser/renderer_host/chrome_render_widget_host_view_mac_delegate.mm',
        'browser/renderer_host/chrome_resource_dispatcher_host_delegate.cc',
        'browser/renderer_host/chrome_resource_dispatcher_host_delegate.h',
        'browser/renderer_host/chrome_url_request_user_data.cc',
        'browser/renderer_host/chrome_url_request_user_data.h',
        'browser/renderer_host/offline_resource_throttle.cc',
        'browser/renderer_host/offline_resource_throttle.h',
        'browser/renderer_host/pepper/chrome_browser_pepper_host_factory.cc',
        'browser/renderer_host/pepper/chrome_browser_pepper_host_factory.h',
        'browser/renderer_host/pepper/device_id_fetcher.h',
        'browser/renderer_host/pepper/device_id_fetcher.cc',
        'browser/renderer_host/pepper/pepper_broker_message_filter.cc',
        'browser/renderer_host/pepper/pepper_broker_message_filter.h',
        'browser/renderer_host/pepper/pepper_flash_browser_host.cc',
        'browser/renderer_host/pepper/pepper_flash_browser_host.h',
        'browser/renderer_host/pepper/pepper_flash_clipboard_message_filter.cc',
        'browser/renderer_host/pepper/pepper_flash_clipboard_message_filter.h',
        'browser/renderer_host/pepper/pepper_flash_device_id_host.cc',
        'browser/renderer_host/pepper/pepper_flash_device_id_host.h',
        'browser/renderer_host/pepper/pepper_talk_host.cc',
        'browser/renderer_host/pepper/pepper_talk_host.h',
        'browser/renderer_host/safe_browsing_resource_throttle.cc',
        'browser/renderer_host/safe_browsing_resource_throttle.h',
        'browser/renderer_host/safe_browsing_resource_throttle_factory.cc',
        'browser/renderer_host/safe_browsing_resource_throttle_factory.h',
        'browser/renderer_host/web_cache_manager.cc',
        'browser/renderer_host/web_cache_manager.h',
        'browser/renderer_preferences_util.cc',
        'browser/renderer_preferences_util.h',
        'browser/repost_form_warning_controller.cc',
        'browser/repost_form_warning_controller.h',
        'browser/resources_util.cc',
        'browser/resources_util.h',
        'browser/rlz/rlz.cc',
        'browser/rlz/rlz.h',
        'browser/safe_browsing/browser_feature_extractor.cc',
        'browser/safe_browsing/browser_feature_extractor.h',
        'browser/safe_browsing/browser_features.cc',
        'browser/safe_browsing/browser_features.h',
        'browser/safe_browsing/chunk_range.cc',
        'browser/safe_browsing/chunk_range.h',
        'browser/safe_browsing/client_side_detection_host.cc',
        'browser/safe_browsing/client_side_detection_host.h',
        'browser/safe_browsing/client_side_detection_service.cc',
        'browser/safe_browsing/client_side_detection_service.h',
        'browser/safe_browsing/database_manager.cc',
        'browser/safe_browsing/database_manager.h',
        'browser/safe_browsing/download_protection_service.cc',
        'browser/safe_browsing/download_protection_service.h',
        'browser/safe_browsing/malware_details.cc',
        'browser/safe_browsing/malware_details.h',
        'browser/safe_browsing/malware_details_cache.cc',
        'browser/safe_browsing/malware_details_cache.h',
        'browser/safe_browsing/malware_details_history.cc',
        'browser/safe_browsing/malware_details_history.h',
        'browser/safe_browsing/ping_manager.cc',
        'browser/safe_browsing/ping_manager.h',
        'browser/safe_browsing/prefix_set.cc',
        'browser/safe_browsing/prefix_set.h',
        'browser/safe_browsing/protocol_manager.cc',
        'browser/safe_browsing/protocol_manager.h',
        'browser/safe_browsing/protocol_manager_helper.cc',
        'browser/safe_browsing/protocol_manager_helper.h',
        'browser/safe_browsing/protocol_parser.cc',
        'browser/safe_browsing/protocol_parser.h',
        'browser/safe_browsing/safe_browsing_blocking_page.cc',
        'browser/safe_browsing/safe_browsing_blocking_page.h',
        'browser/safe_browsing/safe_browsing_database.cc',
        'browser/safe_browsing/safe_browsing_database.h',
        'browser/safe_browsing/safe_browsing_service.cc',
        'browser/safe_browsing/safe_browsing_service.h',
        'browser/safe_browsing/safe_browsing_store.cc',
        'browser/safe_browsing/safe_browsing_store.h',
        'browser/safe_browsing/safe_browsing_store_file.cc',
        'browser/safe_browsing/safe_browsing_store_file.h',
        'browser/safe_browsing/safe_browsing_tab_observer.cc',
        'browser/safe_browsing/safe_browsing_tab_observer.h',
        'browser/safe_browsing/safe_browsing_util.cc',
        'browser/safe_browsing/safe_browsing_util.h',
        'browser/safe_browsing/sandboxed_zip_analyzer.cc',
        'browser/safe_browsing/sandboxed_zip_analyzer.h',
        'browser/safe_browsing/signature_util_posix.cc',
        'browser/safe_browsing/signature_util_win.cc',
        'browser/safe_browsing/signature_util.h',
        'browser/safe_browsing/two_phase_uploader.cc',
        'browser/safe_browsing/two_phase_uploader.h',
        'browser/safe_browsing/ui_manager.cc',
        'browser/safe_browsing/ui_manager.h',
        'browser/screensaver_window_finder_gtk.cc',
        'browser/screensaver_window_finder_gtk.h',
        'browser/search/iframe_source.cc',
        'browser/search/iframe_source.h',
        'browser/search/instant_io_context.cc',
        'browser/search/instant_io_context.h',
        'browser/search/instant_service.cc',
        'browser/search/instant_service.h',
        'browser/search/instant_service_factory.cc',
        'browser/search/instant_service_factory.h',
        'browser/search/local_ntp_source.cc',
        'browser/search/local_ntp_source.h',
        'browser/search/most_visited_iframe_source.cc',
        'browser/search/most_visited_iframe_source.h',
        'browser/search/search.cc',
        'browser/search/search.h',
        'browser/search/suggestion_iframe_source.cc',
        'browser/search/suggestion_iframe_source.h',
        'browser/search_engines/search_engine_type.h',
        'browser/search_engines/search_host_to_urls_map.cc',
        'browser/search_engines/search_host_to_urls_map.h',
        'browser/search_engines/search_provider_install_data.cc',
        'browser/search_engines/search_provider_install_data.h',
        'browser/search_engines/search_provider_install_state_message_filter.cc',
        'browser/search_engines/search_provider_install_state_message_filter.h',
        'browser/search_engines/search_terms_data.cc',
        'browser/search_engines/search_terms_data.h',
        'browser/search_engines/search_terms_data_android.cc',
        'browser/search_engines/search_terms_data_android.h',
        'browser/search_engines/template_url.cc',
        'browser/search_engines/template_url.h',
        'browser/search_engines/template_url_fetcher.cc',
        'browser/search_engines/template_url_fetcher.h',
        'browser/search_engines/template_url_fetcher_callbacks.h',
        'browser/search_engines/template_url_fetcher_factory.cc',
        'browser/search_engines/template_url_fetcher_factory.h',
        'browser/search_engines/template_url_id.h',
        'browser/search_engines/template_url_parser.cc',
        'browser/search_engines/template_url_parser.h',
        'browser/search_engines/template_url_prepopulate_data.cc',
        'browser/search_engines/template_url_prepopulate_data.h',
        'browser/search_engines/template_url_service.cc',
        'browser/search_engines/template_url_service.h',
        'browser/search_engines/template_url_service_android.cc',
        'browser/search_engines/template_url_service_android.h',
        'browser/search_engines/template_url_service_factory.cc',
        'browser/search_engines/template_url_service_factory.h',
        'browser/search_engines/template_url_service_observer.h',
        'browser/search_engines/util.cc',
        'browser/search_engines/util.h',
        'browser/service/service_process_control.cc',
        'browser/service/service_process_control_mac.mm',
        'browser/service/service_process_control.h',
        'browser/sessions/base_session_service.cc',
        'browser/sessions/base_session_service.h',
        'browser/sessions/persistent_tab_restore_service.cc',
        'browser/sessions/persistent_tab_restore_service.h',
        'browser/sessions/session_backend.cc',
        'browser/sessions/session_backend.h',
        'browser/sessions/session_command.cc',
        'browser/sessions/session_command.h',
        'browser/sessions/session_id.cc',
        'browser/sessions/session_id.h',
        'browser/sessions/session_restore.cc',
        'browser/sessions/session_restore.h',
        'browser/sessions/session_restore_android.cc',
        'browser/sessions/session_service.cc',
        'browser/sessions/session_service.h',
        'browser/sessions/session_service_factory.cc',
        'browser/sessions/session_service_factory.h',
        'browser/sessions/session_tab_helper.cc',
        'browser/sessions/session_tab_helper.h',
        'browser/sessions/session_types.cc',
        'browser/sessions/session_types.h',
        'browser/sessions/tab_restore_service.cc',
        'browser/sessions/tab_restore_service.h',
        'browser/sessions/tab_restore_service_factory.cc',
        'browser/sessions/tab_restore_service_factory.h',
        'browser/sessions/tab_restore_service_helper.cc',
        'browser/sessions/tab_restore_service_helper.h',
        'browser/shell_integration.cc',
        'browser/shell_integration.h',
        'browser/shell_integration_android.cc',
        'browser/shell_integration_linux.cc',
        'browser/shell_integration_linux.h',
        'browser/shell_integration_mac.mm',
        'browser/shell_integration_win.cc',
        'browser/signin/about_signin_internals.cc',
        'browser/signin/about_signin_internals.h',
        'browser/signin/about_signin_internals_factory.cc',
        'browser/signin/about_signin_internals_factory.h',
        'browser/signin/chrome_signin_manager_delegate.cc',
        'browser/signin/chrome_signin_manager_delegate.h',
        'browser/signin/oauth2_token_service.cc',
        'browser/signin/oauth2_token_service.h',
        'browser/signin/profile_oauth2_token_service.cc',
        'browser/signin/profile_oauth2_token_service.h',
        'browser/signin/profile_oauth2_token_service_factory.cc',
        'browser/signin/profile_oauth2_token_service_factory.h',
        'browser/signin/profile_oauth2_token_service_request.cc',
        'browser/signin/profile_oauth2_token_service_request.h',
        'browser/signin/signin_global_error.cc',
        'browser/signin/signin_global_error.h',
        'browser/signin/signin_internals_util.cc',
        'browser/signin/signin_internals_util.h',
        'browser/signin/signin_manager_base.cc',
        'browser/signin/signin_manager_base.h',
        'browser/signin/signin_manager.cc',
        'browser/signin/signin_manager.h',
        'browser/signin/signin_manager_cookie_helper.cc',
        'browser/signin/signin_manager_cookie_helper.h',
        'browser/signin/signin_manager_delegate.h',
        'browser/signin/signin_manager_factory.cc',
        'browser/signin/signin_manager_factory.h',
        'browser/signin/signin_names_io_thread.cc',
        'browser/signin/signin_names_io_thread.h',
        'browser/signin/signin_tracker.cc',
        'browser/signin/signin_tracker.h',
        'browser/signin/signin_ui_util.cc',
        'browser/signin/signin_ui_util.h',
        'browser/signin/token_service.cc',
        'browser/signin/token_service.h',
        'browser/signin/token_service_factory.cc',
        'browser/signin/token_service_factory.h',
        'browser/signin/ubertoken_fetcher.cc',
        'browser/signin/ubertoken_fetcher.h',
        'browser/speech/chrome_speech_recognition_manager_delegate.cc',
        'browser/speech/chrome_speech_recognition_manager_delegate.h',
        'browser/speech/chrome_speech_recognition_preferences.cc',
        'browser/speech/chrome_speech_recognition_preferences.h',
        'browser/speech/extension_api/tts_extension_api_constants.cc',
        'browser/speech/extension_api/tts_extension_api_constants.h',
        'browser/speech/speech_recognition_bubble.cc',
        'browser/speech/speech_recognition_bubble.h',
        'browser/speech/speech_recognition_bubble_controller.cc',
        'browser/speech/speech_recognition_bubble_controller.h',
        'browser/speech/tts_chromeos.cc',
        'browser/speech/tts_controller.cc',
        'browser/speech/tts_controller.h',
        'browser/speech/tts_extension_loader_chromeos.cc',
        'browser/speech/tts_extension_loader_chromeos.h',
        'browser/speech/tts_linux.cc',
        'browser/speech/tts_mac.mm',
        'browser/speech/tts_platform.cc',
        'browser/speech/tts_platform.h',
        'browser/speech/tts_message_filter.cc',
        'browser/speech/tts_message_filter.h',
        'browser/speech/tts_win.cc',
        'browser/spellchecker/spellcheck_custom_dictionary.cc',
        'browser/spellchecker/spellcheck_custom_dictionary.h',
        'browser/spellchecker/spellcheck_dictionary.h',
        'browser/spellchecker/spellcheck_factory.cc',
        'browser/spellchecker/spellcheck_factory.h',
        'browser/spellchecker/spellcheck_host_metrics.cc',
        'browser/spellchecker/spellcheck_host_metrics.h',
        'browser/spellchecker/spellcheck_hunspell_dictionary.cc',
        'browser/spellchecker/spellcheck_hunspell_dictionary.h',
        'browser/spellchecker/spellcheck_message_filter.cc',
        'browser/spellchecker/spellcheck_message_filter.h',
        'browser/spellchecker/spellcheck_message_filter_mac.cc',
        'browser/spellchecker/spellcheck_message_filter_mac.h',
        'browser/spellchecker/spellcheck_platform_mac.h',
        'browser/spellchecker/spellcheck_platform_mac.mm',
        'browser/spellchecker/spellcheck_service.cc',
        'browser/spellchecker/spellcheck_service.h',
        'browser/spellchecker/spelling_service_client.cc',
        'browser/spellchecker/spelling_service_client.h',
        'browser/spellchecker/spelling_service_feedback.cc',
        'browser/spellchecker/spelling_service_feedback.h',
        'browser/spellchecker/word_trimmer.cc',
        'browser/spellchecker/word_trimmer.h',
        'browser/ssl/ssl_add_certificate.cc',
        'browser/ssl/ssl_add_certificate.h',
        'browser/ssl/ssl_add_cert_handler.cc',
        'browser/ssl/ssl_add_cert_handler.h',
        'browser/ssl/ssl_add_cert_handler_mac.mm',
        'browser/ssl/ssl_blocking_page.cc',
        'browser/ssl/ssl_blocking_page.h',
        'browser/ssl/ssl_client_auth_observer.cc',
        'browser/ssl/ssl_client_auth_observer.h',
        'browser/ssl/ssl_client_certificate_selector.h',
        'browser/ssl/ssl_error_info.cc',
        'browser/ssl/ssl_error_info.h',
        'browser/ssl/ssl_tab_helper.cc',
        'browser/ssl/ssl_tab_helper.h',
        'browser/status_icons/desktop_notification_balloon.cc',
        'browser/status_icons/desktop_notification_balloon.h',
        'browser/status_icons/status_icon.cc',
        'browser/status_icons/status_icon.h',
        'browser/status_icons/status_icon_observer.h',
        'browser/status_icons/status_tray.cc',
        'browser/status_icons/status_tray.h',
        'browser/storage_monitor/image_capture_device.h',
        'browser/storage_monitor/image_capture_device.mm',
        'browser/storage_monitor/image_capture_device_manager.h',
        'browser/storage_monitor/image_capture_device_manager.mm',
        'browser/storage_monitor/media_storage_util.cc',
        'browser/storage_monitor/media_storage_util.h',
        'browser/storage_monitor/media_transfer_protocol_device_observer_linux.cc',
        'browser/storage_monitor/media_transfer_protocol_device_observer_linux.h',
        'browser/storage_monitor/mtab_watcher_linux.cc',
        'browser/storage_monitor/mtab_watcher_linux.h',
        'browser/storage_monitor/portable_device_watcher_win.cc',
        'browser/storage_monitor/portable_device_watcher_win.h',
        'browser/storage_monitor/removable_device_constants.cc',
        'browser/storage_monitor/removable_device_constants.h',
        'browser/storage_monitor/removable_storage_observer.h',
        'browser/storage_monitor/storage_info.cc',
        'browser/storage_monitor/storage_info.h',
        'browser/storage_monitor/storage_monitor_chromeos.cc',
        'browser/storage_monitor/storage_monitor_chromeos.h',
        'browser/storage_monitor/storage_monitor_linux.cc',
        'browser/storage_monitor/storage_monitor_linux.h',
        'browser/storage_monitor/storage_monitor_mac.h',
        'browser/storage_monitor/storage_monitor_mac.mm',
        'browser/storage_monitor/storage_monitor_win.cc',
        'browser/storage_monitor/storage_monitor_win.h',
        'browser/storage_monitor/storage_monitor.cc',
        'browser/storage_monitor/storage_monitor.h',
        # TODO(thestig) Refactor StorageMonitor so these are test-only.
        'browser/storage_monitor/test_media_transfer_protocol_manager_linux.cc',
        'browser/storage_monitor/test_media_transfer_protocol_manager_linux.h',
        'browser/storage_monitor/transient_device_ids.cc',
        'browser/storage_monitor/transient_device_ids.h',
        'browser/storage_monitor/udev_util_linux.cc',
        'browser/storage_monitor/udev_util_linux.h',
        'browser/storage_monitor/volume_mount_watcher_win.cc',
        'browser/storage_monitor/volume_mount_watcher_win.h',
        'browser/sync/about_sync_util.cc',
        'browser/sync/about_sync_util.h',
        'browser/sync/backend_migrator.cc',
        'browser/sync/backend_migrator.h',
        'browser/sync/backend_unrecoverable_error_handler.cc',
        'browser/sync/backend_unrecoverable_error_handler.h',
        'browser/sync/failed_datatypes_handler.cc',
        'browser/sync/failed_datatypes_handler.h',
        'browser/sync/glue/android_invalidator_bridge.cc',
        'browser/sync/glue/android_invalidator_bridge.h',
        'browser/sync/glue/android_invalidator_bridge_proxy.cc',
        'browser/sync/glue/android_invalidator_bridge_proxy.h',
        'browser/sync/glue/autofill_data_type_controller.cc',
        'browser/sync/glue/autofill_data_type_controller.h',
        'browser/sync/glue/autofill_profile_data_type_controller.cc',
        'browser/sync/glue/autofill_profile_data_type_controller.h',
        'browser/sync/glue/backend_data_type_configurer.cc',
        'browser/sync/glue/backend_data_type_configurer.h',
        'browser/sync/glue/bookmark_change_processor.cc',
        'browser/sync/glue/bookmark_change_processor.h',
        'browser/sync/glue/bookmark_data_type_controller.cc',
        'browser/sync/glue/bookmark_data_type_controller.h',
        'browser/sync/glue/bookmark_model_associator.cc',
        'browser/sync/glue/bookmark_model_associator.h',
        'browser/sync/glue/browser_thread_model_worker.cc',
        'browser/sync/glue/browser_thread_model_worker.h',
        'browser/sync/glue/change_processor.cc',
        'browser/sync/glue/change_processor.h',
        'browser/sync/glue/chrome_encryptor.cc',
        'browser/sync/glue/chrome_encryptor.h',
        'browser/sync/glue/chrome_extensions_activity_monitor.cc',
        'browser/sync/glue/chrome_extensions_activity_monitor.h',
        'browser/sync/glue/chrome_report_unrecoverable_error.cc',
        'browser/sync/glue/chrome_report_unrecoverable_error.h',
        'browser/sync/glue/data_type_controller.cc',
        'browser/sync/glue/data_type_controller.h',
        'browser/sync/glue/data_type_error_handler.h',
        'browser/sync/glue/data_type_manager.cc',
        'browser/sync/glue/data_type_manager.h',
        'browser/sync/glue/data_type_manager_impl.cc',
        'browser/sync/glue/data_type_manager_impl.h',
        'browser/sync/glue/data_type_manager_observer.h',
        'browser/sync/glue/device_info.cc',
        'browser/sync/glue/device_info.h',
        'browser/sync/glue/extension_data_type_controller.cc',
        'browser/sync/glue/extension_data_type_controller.h',
        'browser/sync/glue/extension_setting_data_type_controller.cc',
        'browser/sync/glue/extension_setting_data_type_controller.h',
        'browser/sync/glue/favicon_cache.cc',
        'browser/sync/glue/favicon_cache.h',
        'browser/sync/glue/frontend_data_type_controller.cc',
        'browser/sync/glue/frontend_data_type_controller.h',
        'browser/sync/glue/generic_change_processor.cc',
        'browser/sync/glue/generic_change_processor.h',
        'browser/sync/glue/history_model_worker.cc',
        'browser/sync/glue/history_model_worker.h',
        'browser/sync/glue/model_association_manager.cc',
        'browser/sync/glue/model_association_manager.h',
        'browser/sync/glue/model_associator.h',
        'browser/sync/glue/non_frontend_data_type_controller.cc',
        'browser/sync/glue/non_frontend_data_type_controller.h',
        'browser/sync/glue/non_ui_data_type_controller.cc',
        'browser/sync/glue/non_ui_data_type_controller.h',
        'browser/sync/glue/password_change_processor.cc',
        'browser/sync/glue/password_change_processor.h',
        'browser/sync/glue/password_data_type_controller.cc',
        'browser/sync/glue/password_data_type_controller.h',
        'browser/sync/glue/password_model_associator.cc',
        'browser/sync/glue/password_model_associator.h',
        'browser/sync/glue/password_model_worker.cc',
        'browser/sync/glue/password_model_worker.h',
        'browser/sync/glue/proxy_data_type_controller.cc',
        'browser/sync/glue/proxy_data_type_controller.h',
        'browser/sync/glue/search_engine_data_type_controller.cc',
        'browser/sync/glue/search_engine_data_type_controller.h',
        'browser/sync/glue/session_change_processor.cc',
        'browser/sync/glue/session_change_processor.h',
        'browser/sync/glue/session_data_type_controller.cc',
        'browser/sync/glue/session_data_type_controller.h',
        'browser/sync/glue/session_model_associator.cc',
        'browser/sync/glue/session_model_associator.h',
        'browser/sync/glue/shared_change_processor.cc',
        'browser/sync/glue/shared_change_processor.h',
        'browser/sync/glue/shared_change_processor_ref.cc',
        'browser/sync/glue/shared_change_processor_ref.h',
        'browser/sync/glue/sync_backend_host.cc',
        'browser/sync/glue/sync_backend_host.h',
        'browser/sync/glue/sync_backend_registrar.cc',
        'browser/sync/glue/sync_backend_registrar.h',
        'browser/sync/glue/sync_start_util.cc',
        'browser/sync/glue/sync_start_util.h',
        'browser/sync/glue/synced_device_tracker.cc',
        'browser/sync/glue/synced_device_tracker.h',
        'browser/sync/glue/synced_session.cc',
        'browser/sync/glue/synced_session.h',
        'browser/sync/glue/synced_session_tracker.cc',
        'browser/sync/glue/synced_session_tracker.h',
        'browser/sync/glue/synced_window_delegate.h',
        'browser/sync/glue/synced_window_delegate_android.cc',
        'browser/sync/glue/synced_window_delegate_android.h',
        'browser/sync/glue/tab_node_pool.cc',
        'browser/sync/glue/tab_node_pool.h',
        'browser/sync/glue/theme_data_type_controller.cc',
        'browser/sync/glue/theme_data_type_controller.h',
        'browser/sync/glue/typed_url_change_processor.cc',
        'browser/sync/glue/typed_url_change_processor.h',
        'browser/sync/glue/typed_url_data_type_controller.cc',
        'browser/sync/glue/typed_url_data_type_controller.h',
        'browser/sync/glue/typed_url_model_associator.cc',
        'browser/sync/glue/typed_url_model_associator.h',
        'browser/sync/glue/ui_data_type_controller.cc',
        'browser/sync/glue/ui_data_type_controller.h',
        'browser/sync/glue/ui_model_worker.cc',
        'browser/sync/glue/ui_model_worker.h',
        'browser/sync/invalidations/invalidator_storage.cc',
        'browser/sync/invalidations/invalidator_storage.h',
        'browser/sync/invalidation_frontend.h',
        'browser/sync/profile_sync_components_factory.h',
        'browser/sync/profile_sync_components_factory_impl.cc',
        'browser/sync/profile_sync_components_factory_impl.h',
        'browser/sync/profile_sync_service.cc',
        'browser/sync/profile_sync_service.h',
        'browser/sync/profile_sync_service_android.cc',
        'browser/sync/profile_sync_service_android.h',
        'browser/sync/profile_sync_service_base.h',
        'browser/sync/profile_sync_service_base.cc',
        'browser/sync/profile_sync_service_factory.cc',
        'browser/sync/profile_sync_service_factory.h',
        'browser/sync/profile_sync_service_harness.cc',
        'browser/sync/profile_sync_service_harness.h',
        'browser/sync/profile_sync_service_model_type_selection_android.h',
        'browser/sync/profile_sync_service_observer.h',
        'browser/sync/retry_verifier.cc',
        'browser/sync/retry_verifier.h',
        'browser/sync/sync_global_error.cc',
        'browser/sync/sync_global_error.h',
        'browser/sync/sync_prefs.cc',
        'browser/sync/sync_prefs.h',
        'browser/sync/sync_ui_util.cc',
        'browser/sync/sync_ui_util.h',
        'browser/sync/user_selectable_sync_type.h',
        'browser/sync_file_system/conflict_resolution_policy.h',
        'browser/sync_file_system/drive_file_sync_client.cc',
        'browser/sync_file_system/drive_file_sync_client.h',
        'browser/sync_file_system/drive_file_sync_client_interface.h',
        'browser/sync_file_system/drive_file_sync_service.cc',
        'browser/sync_file_system/drive_file_sync_service.h',
        'browser/sync_file_system/drive_file_sync_util.cc',
        'browser/sync_file_system/drive_file_sync_util.h',
        'browser/sync_file_system/drive_metadata_store.cc',
        'browser/sync_file_system/drive_metadata_store.h',
        'browser/sync_file_system/file_status_observer.h',
        'browser/sync_file_system/local_change_processor.h',
        'browser/sync_file_system/local_file_sync_service.cc',
        'browser/sync_file_system/local_file_sync_service.h',
        'browser/sync_file_system/local_sync_operation_resolver.cc',
        'browser/sync_file_system/local_sync_operation_resolver.h',
        'browser/sync_file_system/remote_change_processor.h',
        'browser/sync_file_system/remote_file_sync_service.h',
        'browser/sync_file_system/remote_sync_operation_resolver.cc',
        'browser/sync_file_system/remote_sync_operation_resolver.h',
        'browser/sync_file_system/sync_event_observer.h',
        'browser/sync_file_system/sync_file_system_service.cc',
        'browser/sync_file_system/sync_file_system_service.h',
        'browser/sync_file_system/sync_file_system_service_factory.cc',
        'browser/sync_file_system/sync_file_system_service_factory.h',
        'browser/sync_file_system/sync_service_state.h',
        'browser/tab_contents/background_contents.cc',
        'browser/tab_contents/background_contents.h',
        'browser/tab_contents/language_state.cc',
        'browser/tab_contents/language_state.h',
        'browser/tab_contents/navigation_metrics_recorder.cc',
        'browser/tab_contents/navigation_metrics_recorder.h',
        'browser/tab_contents/render_view_context_menu.cc',
        'browser/tab_contents/render_view_context_menu.h',
        'browser/tab_contents/render_view_context_menu_observer.cc',
        'browser/tab_contents/render_view_context_menu_observer.h',
        'browser/tab_contents/retargeting_details.h',
        'browser/tab_contents/tab_util.cc',
        'browser/tab_contents/tab_util.h',
        'browser/tab_contents/spellchecker_submenu_observer.h',
        'browser/tab_contents/spellchecker_submenu_observer_hunspell.cc',
        'browser/tab_contents/spellchecker_submenu_observer_mac.cc',
        'browser/tab_contents/spelling_bubble_model.cc',
        'browser/tab_contents/spelling_bubble_model.h',
        'browser/tab_contents/spelling_menu_observer.cc',
        'browser/tab_contents/spelling_menu_observer.h',
        'browser/task_manager/task_manager.cc',
        'browser/task_manager/task_manager.h',
        'browser/task_manager/task_manager_notification_resource_provider.cc',
        'browser/task_manager/task_manager_os_resources_win.cc',
        'browser/task_manager/task_manager_os_resources_win.h',
        'browser/task_manager/task_manager_resource_providers.cc',
        'browser/task_manager/task_manager_resource_providers.h',
        'browser/task_manager/task_manager_worker_resource_provider.cc',
        'browser/task_manager/task_manager_worker_resource_provider.h',
        'browser/task_profiler/auto_tracking.cc',
        'browser/task_profiler/auto_tracking.h',
        'browser/task_profiler/task_profiler_data_serializer.cc',
        'browser/task_profiler/task_profiler_data_serializer.h',
        'browser/themes/browser_theme_pack.cc',
        'browser/themes/browser_theme_pack.h',
        'browser/themes/theme_properties.cc',
        'browser/themes/theme_properties.h',
        'browser/themes/theme_service.cc',
        'browser/themes/theme_service_factory.cc',
        'browser/themes/theme_service_factory.h',
        'browser/themes/theme_service.h',
        'browser/themes/theme_service_gtk.cc',
        'browser/themes/theme_service_mac.mm',
        'browser/themes/theme_syncable_service.cc',
        'browser/themes/theme_syncable_service.h',
        'browser/three_d_api_observer.cc',
        'browser/three_d_api_observer.h',
        'browser/thumbnails/content_analysis.cc',
        'browser/thumbnails/content_analysis.h',
        'browser/thumbnails/simple_thumbnail_crop.cc',
        'browser/thumbnails/simple_thumbnail_crop.h',
        'browser/thumbnails/render_widget_snapshot_taker.cc',
        'browser/thumbnails/render_widget_snapshot_taker.h',
        'browser/thumbnails/thumbnail_service.h',
        'browser/thumbnails/thumbnail_service_factory.cc',
        'browser/thumbnails/thumbnail_service_factory.h',
        'browser/thumbnails/thumbnail_service_impl.cc',
        'browser/thumbnails/thumbnail_service_impl.h',
        'browser/thumbnails/thumbnail_tab_helper.cc',
        'browser/thumbnails/thumbnail_tab_helper.h',
        'browser/thumbnails/thumbnailing_algorithm.h',
        'browser/thumbnails/thumbnailing_context.cc',
        'browser/thumbnails/thumbnailing_context.h',
        'browser/toolkit_extra_parts.h',
        'browser/translate/options_menu_model.cc',
        'browser/translate/options_menu_model.h',
        'browser/translate/translate_infobar_delegate.cc',
        'browser/translate/translate_infobar_delegate.h',
        'browser/translate/translate_manager.cc',
        'browser/translate/translate_manager.h',
        'browser/translate/translate_prefs.cc',
        'browser/translate/translate_prefs.h',
        'browser/translate/translate_tab_helper.cc',
        'browser/translate/translate_tab_helper.h',
        'browser/upgrade_detector.cc',
        'browser/upgrade_detector.h',
        'browser/upgrade_detector_impl.cc',
        'browser/upgrade_detector_impl.h',
        'browser/usb/usb_device.cc',
        'browser/usb/usb_device.h',
        'browser/usb/usb_service.cc',
        'browser/usb/usb_service.h',
        'browser/usb/usb_service_factory.cc',
        'browser/usb/usb_service_factory.h',
        'browser/user_data_dir_extractor.cc',
        'browser/user_data_dir_extractor.h',
        'browser/user_data_dir_extractor_win.cc',
        'browser/user_data_dir_extractor_win.h',
        'browser/user_style_sheet_watcher.cc',
        'browser/user_style_sheet_watcher.h',
        'browser/user_style_sheet_watcher_factory.cc',
        'browser/user_style_sheet_watcher_factory.h',
        'browser/validation_message_message_filter.cc',
        'browser/validation_message_message_filter.h',
        'browser/value_store/leveldb_value_store.cc',
        'browser/value_store/leveldb_value_store.h',
        'browser/value_store/testing_value_store.cc',
        'browser/value_store/testing_value_store.h',
        'browser/value_store/value_store_change.cc',
        'browser/value_store/value_store_change.h',
        'browser/value_store/value_store_frontend.cc',
        'browser/value_store/value_store_frontend.h',
        'browser/value_store/value_store.cc',
        'browser/value_store/value_store.h',
        'browser/web_applications/web_app.cc',
        'browser/web_applications/web_app.h',
        'browser/web_applications/web_app_android.cc',
        'browser/web_applications/web_app_linux.cc',
        'browser/web_applications/web_app_mac.h',
        'browser/web_applications/web_app_mac.mm',
        'browser/web_applications/web_app_win.cc',
        'browser/web_resource/json_asynchronous_unpacker.cc',
        'browser/web_resource/json_asynchronous_unpacker.h',
        'browser/web_resource/notification_promo.cc',
        'browser/web_resource/notification_promo.h',
        'browser/web_resource/promo_resource_service.cc',
        'browser/web_resource/promo_resource_service.h',
        'browser/web_resource/web_resource_service.cc',
        'browser/web_resource/web_resource_service.h',
        'browser/webdata/autocomplete_syncable_service.cc',
        'browser/webdata/autocomplete_syncable_service.h',
        'browser/webdata/autofill_profile_syncable_service.cc',
        'browser/webdata/autofill_profile_syncable_service.h',
        'browser/webdata/keyword_table.cc',
        'browser/webdata/keyword_table.h',
        'browser/webdata/logins_table.cc',
        'browser/webdata/logins_table.h',
        'browser/webdata/logins_table_win.cc',
        'browser/webdata/token_service_table.cc',
        'browser/webdata/token_service_table.h',
        'browser/webdata/web_apps_table.cc',
        'browser/webdata/web_apps_table.h',
        'browser/webdata/web_data_service.cc',
        'browser/webdata/web_data_service.h',
        'browser/webdata/web_data_service_factory.cc',
        'browser/webdata/web_data_service_factory.h',
        'browser/webdata/web_data_service_win.cc',
        'browser/webdata/web_intents_table.cc',
        'browser/webdata/web_intents_table.h',
        # These files are needed by page_cycler.cc
        'test/base/test_switches.cc',
        'test/base/test_switches.h',
        'test/base/chrome_process_util.cc',
        'test/base/chrome_process_util.h',
        'test/base/chrome_process_util_mac.cc',
        'test/perf/perf_test.cc',
        'test/perf/perf_test.h',

        # These files are generated by GRIT.
        '<(grit_out_dir)/grit/component_extension_resources_map.cc',
        '<(grit_out_dir)/grit/devtools_discovery_page_resources_map.cc',
        '<(grit_out_dir)/grit/theme_resources_map.cc',
        '<(SHARED_INTERMEDIATE_DIR)/ui/ui_resources/grit/ui_resources_map.cc',
      ],
      'conditions': [
        ['OS != "ios"', {
          'dependencies': [
            'apps',
            'browser/performance_monitor/performance_monitor.gyp:performance_monitor',
            'browser_extensions',
            'common/extensions/api/api.gyp:api',
            'debugger',
            'installer_util',
            'sync_file_system_proto',
            '../cc/cc.gyp:cc',
            '../components/components.gyp:autofill_browser',
            '../components/components.gyp:navigation_interception',
            '../net/net.gyp:net_with_v8',
            '../printing/printing.gyp:printing',
            '../third_party/adobe/flash/flash_player.gyp:flapper_version_h',
            '../third_party/expat/expat.gyp:expat',
            '../third_party/hunspell/hunspell.gyp:hunspell',
            '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
            '../third_party/libphonenumber/libphonenumber.gyp:libphonenumber',
            '../third_party/libusb/libusb.gyp:libusb',
            '../third_party/npapi/npapi.gyp:npapi',
            '../third_party/re2/re2.gyp:re2',
            '../ui/gl/gl.gyp:gl',
            '../ui/surface/surface.gyp:surface',
            '../ui/web_dialogs/web_dialogs.gyp:web_dialogs',
            '../v8/tools/gyp/v8.gyp:v8',
            '../webkit/support/webkit_support.gyp:glue',
            '../webkit/support/webkit_support.gyp:webkit_resources',
            '../webkit/support/webkit_support.gyp:webkit_storage',
          ],
          'defines': [
            '<@(nacl_defines)',
          ],
          'direct_dependent_settings': {
            'defines': [
              '<@(nacl_defines)',
            ],
          },
        }, {  # OS == "ios"
          'dependencies': [
            '../net/net.gyp:net',
          ],
          'sources/': [
            # Exclude everything but iOS-specific files.
            ['exclude', '\\.(cc|mm)$'],
            ['include', '_ios\\.(cc|mm)$'],
            ['include', '(^|/)ios/'],
            # TODO(ios): Add files here as they are updated to compile on iOS.
            ['include', '^browser/browser_process\\.cc$'],
            ['include', '^browser/browser_process_platform_part\\.cc$'],
          ],
          'link_settings': {
            'libraries': [
              '$(SDKROOT)/System/Library/Frameworks/CoreTelephony.framework',
              '$(SDKROOT)/System/Library/Frameworks/CoreText.framework',
              '$(SDKROOT)/System/Library/Frameworks/MobileCoreServices.framework',
              '$(SDKROOT)/System/Library/Frameworks/QuartzCore.framework',
            ],
            # CoreImage is iOS 5+, but iOS 4.3 is still supported.
            'xcode_settings': {'OTHER_LDFLAGS': ['-weak_framework CoreImage']},
          },
        }],
        ['OS=="mac" or OS=="win" or OS=="linux" or chromeos==1', {
          'sources': [
            'browser/media_galleries/fileapi/device_media_async_file_util.cc',
            'browser/media_galleries/fileapi/device_media_async_file_util.h',
            'browser/media_galleries/fileapi/mtp_device_async_delegate.h',
            'browser/media_galleries/fileapi/mtp_device_map_service.cc',
            'browser/media_galleries/fileapi/mtp_device_map_service.h',
          ],
        }],
        ['enable_extensions==1', {
          'sources': [
            # Only extension API implementations should go here.
            'browser/accessibility/accessibility_extension_api.cc',
            'browser/accessibility/accessibility_extension_api.h',
            'browser/infobars/infobar_extension_api.cc',
            'browser/infobars/infobar_extension_api.h',
            'browser/rlz/rlz_extension_api.cc',
            'browser/rlz/rlz_extension_api.h',
            'browser/speech/extension_api/tts_extension_api.cc',
            'browser/speech/extension_api/tts_extension_api.h',
            'browser/speech/extension_api/tts_engine_extension_api.cc',
            'browser/speech/extension_api/tts_engine_extension_api.h',
          ],
        }, {
          'sources!': [
            'browser/content_settings/content_settings_custom_extension_provider.cc',
            'browser/content_settings/content_settings_custom_extension_provider.h',
            'browser/content_settings/content_settings_internal_extension_provider.cc',
            'browser/content_settings/content_settings_internal_extension_provider.h',
          ],
        }],
        ['enable_background==0', {
          'sources/': [
            ['exclude', '^browser/background/'],
          ],
        }],
        ['enable_task_manager==0', {
          'sources/': [
            ['exclude', '^browser/task_manager/'],
          ],
        }],
        ['disable_nacl==0', {
          'sources': [
            'browser/nacl_host/nacl_broker_host_win.cc',
            'browser/nacl_host/nacl_broker_host_win.h',
            'browser/nacl_host/nacl_broker_service_win.cc',
            'browser/nacl_host/nacl_broker_service_win.h',
            'browser/nacl_host/nacl_browser.cc',
            'browser/nacl_host/nacl_browser.h',
            'browser/nacl_host/nacl_file_host.cc',
            'browser/nacl_host/nacl_file_host.h',
            'browser/nacl_host/nacl_infobar.cc',
            'browser/nacl_host/nacl_infobar.h',
            'browser/nacl_host/nacl_process_host.cc',
            'browser/nacl_host/nacl_process_host.h',
            'browser/nacl_host/nacl_validation_cache.cc',
            'browser/nacl_host/nacl_validation_cache.h',
            'common/nacl_debug_exception_handler_win.cc',
            'common/nacl_debug_exception_handler_win.h',
          ],
          'dependencies': [
            '../native_client/src/trusted/service_runtime/service_runtime.gyp:sel',
          ],
        }],
        ['debug_devtools==1', {
          'defines': [
            'DEBUG_DEVTOOLS=1',
          ],
        }],
        ['configuration_policy==1', {
          'sources!': [
            'browser/policy/policy_service_stub.cc',
            'browser/policy/policy_service_stub.h',
            'browser/policy/profile_policy_connector_stub.cc',
          ],
          'dependencies': [
            'app/policy/cloud_policy_codegen.gyp:policy',
            'cloud_policy_proto',
          ],
        }, {  # configuration_policy==0
          'sources/': [
            ['exclude', '^browser/policy/'],
            ['include', 'browser/policy/policy_map.cc'],
            ['include', 'browser/policy/policy_map.h'],
            ['include', 'browser/policy/policy_service.cc'],
            ['include', 'browser/policy/policy_service.h'],
            ['include', 'browser/policy/policy_service_stub.cc'],
            ['include', 'browser/policy/policy_service_stub.h'],
            ['include', 'browser/policy/profile_policy_connector_stub.cc'],
            ['include', 'browser/policy/profile_policy_connector.h'],
            ['include', 'browser/policy/profile_policy_connector_factory.cc'],
            ['include', 'browser/policy/profile_policy_connector_factory.h'],
            ['include', 'browser/policy/url_blacklist_manager.cc'],
            ['include', 'browser/policy/url_blacklist_manager.h'],
          ],
        }],
        ['enable_plugins==1', {
          'dependencies': [
            '../ppapi/ppapi_internal.gyp:ppapi_ipc',
          ],
        }, {  # enable_plugins==0
          'sources/': [
            ['exclude', '^browser/pepper_'],
            ['exclude', '^browser/plugins/'],
            ['exclude', '^browser/renderer_host/pepper/'],
          ],
        }],
        ['safe_browsing==1', {
          'defines': [
            'FULL_SAFE_BROWSING',
          ],
        }],
        ['safe_browsing==2', {
          'defines': [
            'MOBILE_SAFE_BROWSING',
          ],
          'dependencies!': [
            'safe_browsing_proto',
          ],
         'sources!': [
            'browser/renderer_host/safe_browsing_resource_throttle.cc',
            'browser/renderer_host/safe_browsing_resource_throttle.h',
          ],
          'sources/': [
            ['exclude', '^browser/safe_browsing/'],
            ['include', '^browser/safe_browsing/malware_details.cc'],
            ['include', '^browser/safe_browsing/malware_details.h'],
            ['include', '^browser/safe_browsing/malware_details_cache.cc'],
            ['include', '^browser/safe_browsing/malware_details_cache.h'],
            ['include', '^browser/safe_browsing/malware_details_history.cc'],
            ['include', '^browser/safe_browsing/malware_details_history.h'],
            ['include', '^browser/safe_browsing/ping_manager.cc'],
            ['include', '^browser/safe_browsing/ping_manager.h'],
            ['include', '^browser/safe_browsing/protocol_manager_helper.cc'],
            ['include', '^browser/safe_browsing/protocol_manager_helper.h'],
            ['include', '^browser/safe_browsing/safe_browsing_blocking_page.cc'],
            ['include', '^browser/safe_browsing/safe_browsing_blocking_page.h'],
            ['include', '^browser/safe_browsing/safe_browsing_service.cc'],
            ['include', '^browser/safe_browsing/safe_browsing_service.h'],
            ['include', '^browser/safe_browsing/safe_browsing_tab_observer.cc'],
            ['include', '^browser/safe_browsing/safe_browsing_tab_observer.h'],
            ['include', '^browser/safe_browsing/safe_browsing_util.cc'],
            ['include', '^browser/safe_browsing/safe_browsing_util.h'],
            ['include', '^browser/safe_browsing/ui_manager.cc'],
            ['include', '^browser/safe_browsing/ui_manager.h'],
          ],
        }],
        ['safe_browsing==0', {
          'dependencies!': [
            'safe_browsing_proto',
            'safe_browsing_report_proto',
          ],
          'sources!': [
            'browser/renderer_host/safe_browsing_resource_throttle.cc',
            'browser/renderer_host/safe_browsing_resource_throttle.h',
            'browser/renderer_host/safe_browsing_resource_throttle_factory.cc',
            'browser/renderer_host/safe_browsing_resource_throttle_factory.h',
          ],
          'sources/': [
            ['exclude', '^browser/safe_browsing/'],
            ['include', '^browser/safe_browsing/safe_browsing_tab_observer.cc'],
            ['include', '^browser/safe_browsing/safe_browsing_tab_observer.h'],
          ],
        }],
        ['OS=="linux"', {
          'dependencies': [
            '../build/linux/system.gyp:udev',
            '../device/device.gyp:mtp_file_entry_proto',
            '../device/device.gyp:mtp_storage_info_proto',
            '../device/device.gyp:device_media_transfer_protocol',
          ],
        }],
        ['OS=="linux" and chromeos==0', {
          'dependencies': [
            '../build/linux/system.gyp:libspeechd',
          ],
        }],
        ['chromeos==0', {
          'sources!': [
            'browser/extensions/api/input_ime/input_ime_api.cc',
            'browser/extensions/api/input_ime/input_ime_api.h',
            'browser/extensions/api/terminal/terminal_extension_helper.cc',
            'browser/extensions/api/terminal/terminal_extension_helper.h',
            'browser/extensions/api/terminal/terminal_private_api.cc',
            'browser/extensions/api/terminal/terminal_private_api.h',
            'browser/net/gaia/gaia_oauth_consumer.h',
            'browser/net/gaia/gaia_oauth_fetcher.cc',
            'browser/net/gaia/gaia_oauth_fetcher.h',
            'browser/policy/proto/chrome_device_policy.pb.cc',
            'browser/policy/proto/chrome_device_policy.pb.h',
            'browser/renderer_host/offline_resource_throttle.cc',
            'browser/renderer_host/offline_resource_throttle.h',
          ],
        }, {  # chromeos==1
          'dependencies': [
            'browser_chromeos',
          ],
          'sources!': [
            'browser/browser_process_platform_part.cc',
            'browser/browser_process_platform_part.h',
            'browser/first_run/upgrade_util.cc',
            'browser/first_run/upgrade_util.h',
            'browser/first_run/upgrade_util_linux.cc',
            'browser/icon_loader_linux.cc',
            'browser/icon_manager_linux.cc',
            'browser/idle_linux.cc',
            'browser/password_manager/native_backend_gnome_x.cc',
            'browser/password_manager/native_backend_gnome_x.h',
            'browser/password_manager/native_backend_kwallet_x.cc',
            'browser/password_manager/native_backend_kwallet_x.h',
            'browser/platform_util_linux.cc',
            'browser/policy/cloud/user_cloud_policy_manager.cc',
            'browser/policy/cloud/user_cloud_policy_manager.h',
            'browser/policy/cloud/user_cloud_policy_manager_factory.cc',
            'browser/policy/cloud/user_cloud_policy_manager_factory.h',
            'browser/policy/cloud/user_cloud_policy_store.cc',
            'browser/policy/cloud/user_cloud_policy_store.h',
            'browser/policy/cloud/user_policy_signin_service.cc',
            'browser/policy/cloud/user_policy_signin_service.h',
            'browser/policy/cloud/user_policy_signin_service_factory.cc',
            'browser/policy/cloud/user_policy_signin_service_factory.h',
            'browser/signin/signin_manager.cc',
            'browser/speech/tts_linux.cc',
            'browser/storage_monitor/mtab_watcher_linux.cc',
            'browser/storage_monitor/mtab_watcher_linux.h',
            'browser/storage_monitor/storage_monitor_linux.cc',
            'browser/storage_monitor/storage_monitor_linux.h',
            'browser/ui/webui/help/version_updater_basic.cc',
            'browser/ui/webui/help/version_updater_basic.h',
            'browser/upgrade_detector_impl.cc',
            'browser/upgrade_detector_impl.h',
          ],
        }],
        ['use_cups==1', {
          'dependencies': [
            '../printing/printing.gyp:cups',
          ],
        }],
        ['use_gnome_keyring==0', {
          'sources!': [
            'browser/password_manager/native_backend_gnome_x.cc',
            'browser/password_manager/native_backend_gnome_x.h',
          ],
        }],
        ['use_aura==1', {
          'sources/': [
            ['exclude', '^browser/automation/testing_automation_provider_win.cc'],
            ['exclude', '^browser/hang_monitor/hung_plugin_action.cc'],
            ['exclude', '^browser/hang_monitor/hung_plugin_action.h'],
            ['exclude', '^browser/hang_monitor/hung_window_detector.cc'],
            ['exclude', '^browser/hang_monitor/hung_window_detector.h'],
            ['exclude', '^browser/jumplist_win.cc'],
            ['exclude', '^browser/jumplist_win.h'],
            ['exclude', '^browser/lifetime/application_lifetime_stub.cc'],
            ['exclude', '^browser/renderer_host/render_widget_host_view_views*'],
          ],
          'sources': [
            'browser/metro_viewer/metro_viewer_process_host_win.cc',
            'browser/metro_viewer/metro_viewer_process_host_win.h',
          ],
          'dependencies': [
            '../ui/aura/aura.gyp:aura',
            '../ui/compositor/compositor.gyp:compositor',
            '../ui/keyboard/keyboard.gyp:keyboard',
          ],
          'conditions': [
            ['OS=="win"', {
              'sources/': [
                ['exclude', '^browser/automation/automation_provider_aura.cc'],
                ['exclude', '^browser/background/background_mode_manager_aura.cc'],
                ['exclude', '^browser/lifetime/application_lifetime_win.cc'],
              ],
              'dependencies': [
                'launcher_support',
                '../ui/metro_viewer/metro_viewer.gyp:metro_viewer',
              ],
            }],
          ],
        }],
        ['ui_compositor_image_transport==1', {
          'dependencies': [
            '../ui/gl/gl.gyp:gl',
          ],
        }],
        ['os_posix == 1 and OS != "mac" and OS != "ios" and OS != "android"', {
          'link_settings': {
            'libraries': [
              '-lXss',
            ],
          },
        }],
        ['os_posix == 1 and OS != "mac" and OS != "ios"', {
          'sources': [ 'browser/crash_handler_host_linux.h', ],
          'conditions': [
            ['linux_breakpad==1', {
              'sources': [
                'app/breakpad_linux.cc',
                'app/breakpad_linux.h',
                'browser/crash_handler_host_linux.cc',
              ],
              'dependencies': [
                '../breakpad/breakpad.gyp:breakpad_client',
                # make sure file_version_info_linux.h is generated first.
                'common',
              ],
              'include_dirs': [
                # breakpad_linux.cc uses generated file_version_info_linux.h.
                '<(SHARED_INTERMEDIATE_DIR)',
                '../breakpad/src',
              ],
            }, {  # linux_breakpad==0
              'sources': [
                'browser/crash_handler_host_linux_stub.cc',
              ],
            }],
          ],
        }],
        ['use_nss==1', {
          'sources': [
            'third_party/mozilla_security_manager/nsNSSCertHelper.cpp',
            'third_party/mozilla_security_manager/nsNSSCertHelper.h',
            'third_party/mozilla_security_manager/nsNSSCertificate.cpp',
            'third_party/mozilla_security_manager/nsNSSCertificate.h',
            'third_party/mozilla_security_manager/nsUsageArrayHelper.cpp',
            'third_party/mozilla_security_manager/nsUsageArrayHelper.h',
          ],
        }, {  # use_nss==0
          'sources!': [
            'browser/certificate_manager_model.cc',
            'browser/certificate_manager_model.h',
          ],
        }],
        ['toolkit_uses_gtk == 1', {
          'dependencies': [
            '../build/linux/system.gyp:dbus',
            '../build/linux/system.gyp:gconf',
            '../build/linux/system.gyp:gtk',
            '../build/linux/system.gyp:gtkprint',
            '../build/linux/system.gyp:ssl',
            '../build/linux/system.gyp:x11',
            '../dbus/dbus.gyp:dbus',
            '../third_party/undoview/undoview.gyp:undoview',
          ],
          'conditions': [
            ['OS=="linux"', {
              'link_settings': {
                'libraries': [
                  # For dlsym() in 'browser/zygote_main_linux.cc'
                  '-ldl',
                ],
              },
            }],
            ['use_gnome_keyring==1', {
              'dependencies': [
                '../build/linux/system.gyp:gnome_keyring',
              ],
            }],
          ],
        }],
        ['input_speech==0', {
          'sources/': [
            ['exclude', '^browser/speech/chrome_speech'],
            ['exclude', '^browser/speech/speech_'],
          ],
        }],
        ['notifications==0', {
          'sources/': [
            ['exclude', '^browser/notifications/'],
          ],
        }],
        ['enable_themes==0', {
          'sources!': [
            'browser/sync/glue/theme_data_type_controller.cc',
          ],
          'sources/': [
            ['exclude', '^browser/themes/'],
          ],
        }],
        ['enable_automation!=1', {
          'sources/': [
            ['exclude', '^browser/automation/'],
          ],
        }],
        ['enable_language_detection==0', {
          'sources!': [
            'browser/language_usage_metrics.cc',
            'browser/language_usage_metrics.h',
          ],
        }, {   # enable_language_detection==1
          'dependencies': [
            '../third_party/cld/cld.gyp:cld',
          ],
        }],
        ['enable_printing!=1', {
          'sources/': [
            ['exclude', '^browser/printing/'],
          ],
        }],
        ['enable_captive_portal_detection!=1', {
          'sources/': [
            ['exclude', '^browser/captive_portal/'],
          ],
        }],
        ['enable_session_service!=1', {
          'sources!': [
            'browser/sessions/session_restore.cc',
            'browser/sessions/session_service.cc',
            'browser/sessions/session_service.h',
            'browser/sessions/session_service_factory.cc',
            'browser/sessions/session_service_factory.h',
          ],
        }],
        ['OS=="android" or OS=="ios"', {
          'sources!': [
            'browser/chrome_browser_field_trials_desktop.cc',
            'browser/chrome_browser_field_trials_desktop.h',
          ],
        }, {  # OS!="android" and OS!="ios"
          'sources!': [
            'browser/chrome_browser_field_trials_mobile.cc',
            'browser/chrome_browser_field_trials_mobile.h',
            'browser/metrics/variations/eula_accepted_notifier_mobile.cc',
            'browser/metrics/variations/eula_accepted_notifier_mobile.h',
            'browser/metrics/variations/variations_request_scheduler_mobile.cc',
            'browser/metrics/variations/variations_request_scheduler_mobile.h',
          ],
        }],
        ['OS=="android"', {
          'dependencies': [
            '../components/components.gyp:web_contents_delegate_android',
            'chrome_browser_jni_headers',
          ],
          'dependencies!': [
            '../third_party/libusb/libusb.gyp:libusb',
          ],
          'sources': [
            'browser/sessions/in_memory_tab_restore_service.cc',
            'browser/sessions/in_memory_tab_restore_service.h',
            'browser/signin/android_profile_oauth2_token_service.cc',
            'browser/signin/android_profile_oauth2_token_service.h',
            'browser/ssl/ssl_add_certificate_android.cc',
            'browser/web_resource/notification_promo_mobile_ntp.cc',
            'browser/web_resource/notification_promo_mobile_ntp.h',
          ],
          'sources!': [
            # Bookmark export/import are handled via the BookmarkColumns
            # ContentProvider.
            'browser/bookmarks/bookmark_html_writer.cc',
            'browser/ssl/ssl_add_certificate.cc',

            'browser/jankometer.cc',
            'browser/sync/sync_global_error.cc',
            'browser/sync/sync_global_error.h',

            'browser/download/download_crx_util.cc',
            'browser/net/gaia/gaia_oauth_fetcher.cc',
            'browser/omnibox_search_hint.cc',
            'browser/page_cycler/page_cycler.cc',
            'browser/page_cycler/page_cycler.h',
            'browser/sessions/persistent_tab_restore_service.cc',
            'browser/sessions/persistent_tab_restore_service.h',
            'browser/sessions/session_backend.cc',
            'browser/sessions/session_backend.h',
            'browser/tab_contents/background_contents.cc',
            'browser/tab_contents/background_contents.h',
            'browser/tab_contents/render_view_context_menu.cc',
            'browser/tab_contents/render_view_context_menu.h',
            'browser/tab_contents/render_view_context_menu_observer.cc',
            'browser/tab_contents/render_view_context_menu_observer.h',
            'browser/tab_contents/spellchecker_submenu_observer.h',
            'browser/tab_contents/spellchecker_submenu_observer_hunspell.cc',
            'browser/tab_contents/spelling_bubble_model.cc',
            'browser/tab_contents/spelling_bubble_model.h',
            'browser/tab_contents/spelling_menu_observer.cc',
            'browser/tab_contents/spelling_menu_observer.h',
            'browser/upgrade_detector_impl.cc',
            'browser/upgrade_detector_impl.h',

            # User Stylesheet unsupported on Android (crbug.com/236696)
            'browser/user_style_sheet_watcher.cc',
            'browser/user_style_sheet_watcher.h',
            'browser/user_style_sheet_watcher_factory.cc',
            'browser/user_style_sheet_watcher_factory.h',

            # Not used by Android
            'browser/chrome_browser_main_posix.cc',
            'browser/chrome_browser_main_posix.h',
            'browser/chrome_process_singleton.cc',
            'browser/process_singleton.cc',
          ],
          'sources/': [
            ['exclude', '^browser/captive_portal/'],
            ['exclude', '^browser/chrome_to_mobile'],
            ['exclude', '^browser/first_run/'],
            ['include', '^browser/first_run/first_run.cc'], # For ctor/dtor of a struct.
            ['exclude', '^browser/importer/'],
            ['exclude', '^browser/media_galleries/'],
            ['exclude', '^browser/service/'],
            ['exclude', '^browser/speech/'],
            ['exclude', '^browser/sync/glue/app_'],
            ['exclude', '^browser/sync/glue/extension_'],
            ['exclude', '^browser/sync/glue/theme_'],
            ['exclude', '^browser/usb/'],
          ],
        }],
        ['OS=="mac"', {
          'sources!': [
            'browser/automation/automation_provider_list_generic.cc',
            'browser/first_run/upgrade_util.cc',
            'browser/importer/nss_decryptor_system_nss.cc',
            'browser/importer/nss_decryptor_system_nss.h',
            'browser/jankometer.cc',
            'browser/lifetime/application_lifetime_stub.cc',
            'browser/password_manager/login_database_posix.cc',
            'browser/tab_contents/spellchecker_submenu_observer_hunspell.cc',
          ],
          'link_settings': {
            'libraries': [
              '$(SDKROOT)/System/Library/Frameworks/Accelerate.framework',
              '$(SDKROOT)/System/Library/Frameworks/AddressBook.framework',
              '$(SDKROOT)/System/Library/Frameworks/AudioUnit.framework',
              '$(SDKROOT)/System/Library/Frameworks/DiskArbitration.framework',
              '$(SDKROOT)/System/Library/Frameworks/IOKit.framework',
              '$(SDKROOT)/System/Library/Frameworks/ImageCaptureCore.framework',
              '$(SDKROOT)/System/Library/Frameworks/OpenGL.framework',
              '$(SDKROOT)/System/Library/Frameworks/QuartzCore.framework',
              '$(SDKROOT)/System/Library/Frameworks/SecurityInterface.framework',
            ],
          },
          'dependencies': [
            '../third_party/icon_family/icon_family.gyp:icon_family',
          ],
          'sources': [
            # Build the necessary GTM sources
            '../third_party/GTM/Foundation/GTMServiceManagement.h',
            '../third_party/GTM/Foundation/GTMServiceManagement.c',
          ],
          'include_dirs': [
            '../third_party/GTM',
            '../third_party/GTM/Foundation',
          ],
        }],
        ['enable_rlz==1', {
          'dependencies': [
            '../rlz/rlz.gyp:rlz_lib',
          ],
        }, {  # enable_rlz!=1
          'sources/': [
            # Exclude all of rlz.
            ['exclude', '^browser/rlz/'],
          ],
        }],
        ['OS=="win"', {
          'include_dirs': [
            '<(DEPTH)/third_party/wtl/include',
          ],
          'dependencies': [
            'installer_util_strings',
            '../google_update/google_update.gyp:google_update',
            '../third_party/iaccessible2/iaccessible2.gyp:iaccessible2',
            '../third_party/isimpledom/isimpledom.gyp:isimpledom',
            '../ui/views/controls/webview/webview.gyp:webview',
            '../ui/views/views.gyp:views',
            '../win8/win8.gyp:win8_util',
          ],
          'export_dependent_settings': [
            '../ui/views/controls/webview/webview.gyp:webview',
            '../ui/views/views.gyp:views',
          ],
          'sources': [
            # Using built-in rule in vstudio for midl.
            'browser/history/history_indexer.idl',
          ],
          'sources!': [
            'browser/first_run/first_run_dialog.h',
            'browser/history/history_publisher_none.cc',
            'browser/importer/nss_decryptor_system_nss.cc',
            'browser/importer/nss_decryptor_system_nss.h',
            'browser/lifetime/application_lifetime_stub.cc',
            'browser/profiles/profile_shortcut_manager_stub.cc',
            'browser/user_data_dir_extractor.cc',
          ],
          'conditions': [
            ['win_use_allocator_shim==1', {
              'dependencies': [
                '<(allocator_target)',
              ],
            }],
          ],
        }, {  # 'OS!="win"
          'sources/': [
            # Exclude files that should be excluded for all non-Windows platforms.
            ['exclude', '^browser/first_run/try_chrome_dialog_view.cc'],
            ['exclude', '^browser/first_run/try_chrome_dialog_view.h'],
            ['exclude', '^browser/importer/ie_importer.cc'],

            # Exclude all of hang_monitor.
            ['exclude', '^browser/hang_monitor/'],
          ],
          'conditions': [
            ['use_aura==1',{
              'dependencies': [
                '../build/linux/system.gyp:dbus',
                '../build/linux/system.gyp:fontconfig',
                '../build/linux/system.gyp:x11',
                '../dbus/dbus.gyp:dbus',
                '../ui/views/controls/webview/webview.gyp:webview',
                '../ui/views/views.gyp:views',
              ],
              'include_dirs': [
                '<(INTERMEDIATE_DIR)',
                '<(INTERMEDIATE_DIR)/chrome',
              ],
              'sources/': [
                ['exclude', '^browser/platform_util_common_linux.cc'],
                ['include', '^browser/printing/print_dialog_cloud.cc'],
                ['include', '^browser/printing/print_dialog_cloud.h'],
              ],
            }],
            # GTK build only
            ['toolkit_uses_gtk==1', {
              'sources/': [
                ['exclude', '^browser/lifetime/application_lifetime_stub.cc'],
                ['include', '^browser/printing/print_dialog_gtk.cc'],
                ['include', '^browser/printing/print_dialog_gtk.h'],
              ],
            }],
            ['gcc_version == 45', {
              # Avoid gcc 4.5 miscompilation of template_url.cc
              # as per http://crbug.com/41887
              'cflags': [
                '-fno-ipa-cp',
              ],
            }],
          ],
        }],
        ['enable_plugin_installation==0', {
          'sources!': [
            'browser/plugins/plugin_installer.cc',
            'browser/plugins/plugin_installer.h',
            'browser/plugins/plugin_installer_observer.cc',
            'browser/plugins/plugin_installer_observer.h',
            'browser/plugins/plugins_resource_service.cc',
            'browser/plugins/plugins_resource_service.h',
          ],
        }],
        [ 'use_openssl==1', {
          'sources!': [
            'browser/importer/nss_decryptor.cc',
            'browser/importer/nss_decryptor_system_nss.cc',
            'browser/importer/nss_decryptor_system_nss.h',
          ]
        }],
        ['enable_app_list==1', {
          'dependencies': [
            '../ui/app_list/app_list.gyp:app_list',
          ]
        }],
        ['enable_message_center==1', {
          'dependencies': [
            '../ui/message_center/message_center.gyp:message_center',
          ],
        }, {  # enable_message_center==0
          'sources!': [
            'browser/notifications/message_center_notification_manager.cc',
            'browser/notifications/message_center_notification_manager.h',
            'browser/notifications/message_center_settings_controller.cc',
            'browser/notifications/message_center_settings_controller.h',
          ],
        }],
        ['enable_managed_users!=1', {
          'sources/': [
            ['exclude', '^browser/managed_mode/'],
          ]
        }],
        ['enable_webrtc==1', {
          'dependencies': [
            '../third_party/libjingle/libjingle.gyp:libjingle_webrtc',
            '../third_party/libjingle/libjingle.gyp:libpeerconnection',
          ],
        }],
      ],
      'target_conditions': [
        # Need 'target_conditions' to override default filename_rules to include
        # the files on Android.
        ['OS=="android"', {
          'sources/': [
            ['include', '^app/breakpad_linux\\.cc$'],
            ['include', '^browser/crash_handler_host_linux\\.cc$'],
            ['include', '^browser/crash_handler_host_linux_stub\\.cc$'],
          ],
        }],
      ],
    },
    {
      # Protobuf compiler / generator for the fraudulent certificate reporting
      # protocol buffer.
      'target_name': 'cert_logger_proto',
      'type': 'static_library',
      'sources': [ 'browser/net/cert_logger.proto', ],
      'variables': {
        'proto_in_dir': 'browser/net',
        'proto_out_dir': 'chrome/browser/net',
      },
      'includes': [ '../build/protoc.gypi', ],
    },
    {
      # Protobuf compiler / generate rule for feedback
      'target_name': 'feedback_proto',
      'type': 'static_library',
      'sources': [
        'browser/feedback/proto/annotations.proto',
        'browser/feedback/proto/chrome.proto',
        'browser/feedback/proto/common.proto',
        'browser/feedback/proto/dom.proto',
        'browser/feedback/proto/extension.proto',
        'browser/feedback/proto/math.proto',
        'browser/feedback/proto/web.proto',
      ],
      'variables': {
        'proto_in_dir': 'browser/feedback/proto',
        'proto_out_dir': 'chrome/browser/feedback/proto',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
    {
      # Protobuf compiler / generator for the safebrowsing reporting
      # protocol buffer.
      'target_name': 'safe_browsing_report_proto',
      'type': 'static_library',
      'sources': [ 'browser/safe_browsing/report.proto' ],
      'variables': {
        'proto_in_dir': 'browser/safe_browsing',
        'proto_out_dir': 'chrome/browser/safe_browsing',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
    {
      # Protobuf compiler / generator for the InMemoryURLIndex caching
      # protocol buffer.
      'target_name': 'in_memory_url_index_cache_proto',
      'type': 'static_library',
      'sources': [ 'browser/history/in_memory_url_index_cache.proto' ],
      'variables': {
        'proto_in_dir': 'browser/history',
        'proto_out_dir': 'chrome/browser/history',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
    {
      # Protobuf compiler / generator for Chrome Variations seed.
      'target_name': 'variations_seed_proto',
      'type': 'static_library',
      'sources': [
        'browser/metrics/proto/trials_seed.proto',
        'browser/metrics/proto/study.proto',
      ],
      'variables': {
        'proto_in_dir': 'browser/metrics/proto',
        'proto_out_dir': 'chrome/browser/metrics/proto',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
    {
      # Protobuf compiler / generator for Sync FileSystem protocol buffer.
      'target_name': 'sync_file_system_proto',
      'type': 'static_library',
      'sources': [
        'browser/sync_file_system/sync_file_system.proto',
      ],
      'variables': {
        'proto_in_dir': 'browser/sync_file_system',
        'proto_out_dir': 'chrome/browser/sync_file_system',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
    {
      # Protobuf compiler / generator for cloud policy protocol buffers.
      'target_name': 'cloud_policy_proto',
      'type': 'static_library',
      'sources': [
        'browser/policy/proto/cloud/chrome_extension_policy.proto',
        'browser/policy/proto/cloud/device_management_backend.proto',
        'browser/policy/proto/cloud/device_management_local.proto',
      ],
      'variables': {
        'proto_in_dir': 'browser/policy/proto/cloud',
        'proto_out_dir': 'chrome/browser/policy/proto/cloud',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
  ],
  'conditions': [
    ['OS=="android"', {
      'targets': [
        {
          'target_name': 'chrome_browser_jni_headers',
          'type': 'none',
          'sources': [
            'android/java/src/org/chromium/chrome/browser/ApplicationLifetime.java',
            'android/java/src/org/chromium/chrome/browser/autofill/AutofillDialogGlue.java',
            'android/java/src/org/chromium/chrome/browser/autofill/AutofillPopupGlue.java',
            'android/java/src/org/chromium/chrome/browser/autofill/PersonalDataManager.java',
            'android/java/src/org/chromium/chrome/browser/CertificateViewer.java',
            'android/java/src/org/chromium/chrome/browser/ChromeBrowserProvider.java',
            'android/java/src/org/chromium/chrome/browser/ChromeHttpAuthHandler.java',
            'android/java/src/org/chromium/chrome/browser/ChromeWebContentsDelegateAndroid.java',
            'android/java/src/org/chromium/chrome/browser/ContentViewUtil.java',
            'android/java/src/org/chromium/chrome/browser/DevToolsServer.java',
            'android/java/src/org/chromium/chrome/browser/database/SQLiteCursor.java',
            'android/java/src/org/chromium/chrome/browser/IntentHelper.java',
            'android/java/src/org/chromium/chrome/browser/JavascriptAppModalDialog.java',
            'android/java/src/org/chromium/chrome/browser/NavigationPopup.java',
            'android/java/src/org/chromium/chrome/browser/profiles/Profile.java',
            'android/java/src/org/chromium/chrome/browser/SSLClientCertificateRequest.java',
            'android/java/src/org/chromium/chrome/browser/StatusTray.java',
            'android/java/src/org/chromium/chrome/browser/search_engines/TemplateUrlService.java',
            'android/java/src/org/chromium/chrome/browser/sync/ProfileSyncService.java',
            'android/java/src/org/chromium/chrome/browser/TabBase.java',
            'android/java/src/org/chromium/chrome/browser/WebsiteSettingsPopup.java',
          ],
          'variables': {
            'jni_gen_package': 'chrome',
          },
          'includes': [ '../build/jni_generator.gypi' ],
        },
        {
          'target_name': 'profile_sync_service_model_type_selection_java',
          'type': 'none',
          'sources': [
            'android/java/ModelTypeSelection.template',
          ],
          'variables': {
            'package_name': 'org/chromium/chrome/browser/sync',
            'template_deps': ['browser/sync/profile_sync_service_model_type_selection_android.h'],
          },
          'includes': [ '../build/android/java_cpp_template.gypi' ],
        },
        {
          'target_name': 'toolbar_model_security_levels_java',
          'type': 'none',
          'sources': [
            'android/java/ToolbarModelSecurityLevel.template',
          ],
          'variables': {
            'package_name': 'org/chromium/chrome/browser/ui/toolbar',
            'template_deps': ['browser/ui/toolbar/toolbar_model_security_level_list.h'],
          },
          'includes': [ '../build/android/java_cpp_template.gypi' ],
        },
      ],
     },
    ],
  ],
}
