// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

cr.define('print_preview.ticket_items', function() {
  'use strict';

  /**
   * Margins type ticket item whose value is a
   * {@link print_preview.ticket_items.MarginsType.Value} that indicates what
   * predefined margins type to use.
   * @param {!print_preview.DocumentInfo} documentInfo Information about the
   *     document to print.
   * @constructor
   * @extends {print_preview.ticket_items.TicketItem}
   */
  function MarginsType(documentInfo) {
    print_preview.ticket_items.TicketItem.call(this);

    /**
     * Information about the document to print.
     * @type {!print_preview.DocumentInfo}
     * @private
     */
    this.documentInfo_ = documentInfo;
  };

  /**
   * Enumeration of margin types. Matches enum MarginType in
   * printing/print_job_constants.h.
   * @enum {number}
   */
  MarginsType.Value = {
    DEFAULT: 0,
    NO_MARGINS: 1,
    MINIMUM: 2,
    CUSTOM: 3
  };

  MarginsType.prototype = {
    __proto__: print_preview.ticket_items.TicketItem.prototype,

    /** @override */
    wouldValueBeValid: function(value) {
      return true;
    },

    /** @override */
    isCapabilityAvailable: function() {
      return this.documentInfo_.isModifiable;
    },

    /** @override */
    getDefaultValueInternal: function() {
      return MarginsType.Value.DEFAULT;
    },

    /** @override */
    getCapabilityNotAvailableValueInternal: function() {
      return MarginsType.Value.DEFAULT;
    }
  };

  // Export
  return {
    MarginsType: MarginsType
  };
});
