# Copyright (c) 2013 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

# NOTE: this file is autogenerated by ffmpeg/chromium/scripts/generate_gyp.py

{
  'variables': {
    'conditions': [
      ['(target_arch == "ia32" or target_arch == "x64") and (ffmpeg_branding == "ChromeOS") and (1)', {
        'asm_sources': [
          'libavcodec/x86/h263_loopfilter.asm',
        ],
      }],  # (target_arch == "ia32" or target_arch == "x64") and (ffmpeg_branding == "ChromeOS") and (1)
      ['((target_arch == "arm" and arm_neon == 1)) and (ffmpeg_branding == "Chrome" or ffmpeg_branding == "ChromeOS") and (1)', {
        'asm_sources': [
          'libavcodec/arm/aacpsdsp_neon.S',
          'libavcodec/arm/h264cmc_neon.S',
          'libavcodec/arm/h264dsp_neon.S',
          'libavcodec/arm/h264idct_neon.S',
          'libavcodec/arm/h264qpel_neon.S',
          'libavcodec/arm/mpegvideo_neon.S',
          'libavcodec/arm/sbrdsp_neon.S',
        ],
      }],  # ((target_arch == "arm" and arm_neon == 1)) and (ffmpeg_branding == "Chrome" or ffmpeg_branding == "ChromeOS") and (1)
      ['(target_arch == "ia32" or target_arch == "x64") and (ffmpeg_branding == "Chrome" or ffmpeg_branding == "Chromium") and (OS == "win")', {
        'c_sources': [
          'compat/msvcrt/snprintf.c',
          'compat/strtod.c',
        ],
        'converter_outputs': [
          '<(shared_generated_dir)/compat/msvcrt/snprintf.c',
          '<(shared_generated_dir)/compat/strtod.c',
        ],
      }],  # (target_arch == "ia32" or target_arch == "x64") and (ffmpeg_branding == "Chrome" or ffmpeg_branding == "Chromium") and (OS == "win")
      ['(1) and (ffmpeg_branding == "ChromeOS") and (1)', {
        'c_sources': [
          'libavcodec/acelp_filters.c',
          'libavcodec/acelp_pitch_delay.c',
          'libavcodec/acelp_vectors.c',
          'libavcodec/amrnbdec.c',
          'libavcodec/amrwbdec.c',
          'libavcodec/celp_filters.c',
          'libavcodec/celp_math.c',
          'libavcodec/flvdec.c',
          'libavcodec/gsm_parser.c',
          'libavcodec/gsmdec.c',
          'libavcodec/gsmdec_data.c',
          'libavcodec/h263.c',
          'libavcodec/h263_parser.c',
          'libavcodec/h263dec.c',
          'libavcodec/intelh263dec.c',
          'libavcodec/ituh263dec.c',
          'libavcodec/lsp.c',
          'libavcodec/mpeg4video.c',
          'libavcodec/mpeg4video_parser.c',
          'libavcodec/mpeg4videodec.c',
          'libavcodec/msgsmdec.c',
          'libavformat/amr.c',
          'libavformat/avidec.c',
          'libavformat/gsmdec.c',
        ],
        'converter_outputs': [
          '<(shared_generated_dir)/libavcodec/acelp_filters.c',
          '<(shared_generated_dir)/libavcodec/acelp_pitch_delay.c',
          '<(shared_generated_dir)/libavcodec/acelp_vectors.c',
          '<(shared_generated_dir)/libavcodec/amrnbdec.c',
          '<(shared_generated_dir)/libavcodec/amrwbdec.c',
          '<(shared_generated_dir)/libavcodec/celp_filters.c',
          '<(shared_generated_dir)/libavcodec/celp_math.c',
          '<(shared_generated_dir)/libavcodec/flvdec.c',
          '<(shared_generated_dir)/libavcodec/gsm_parser.c',
          '<(shared_generated_dir)/libavcodec/gsmdec.c',
          '<(shared_generated_dir)/libavcodec/gsmdec_data.c',
          '<(shared_generated_dir)/libavcodec/h263.c',
          '<(shared_generated_dir)/libavcodec/h263_parser.c',
          '<(shared_generated_dir)/libavcodec/h263dec.c',
          '<(shared_generated_dir)/libavcodec/intelh263dec.c',
          '<(shared_generated_dir)/libavcodec/ituh263dec.c',
          '<(shared_generated_dir)/libavcodec/lsp.c',
          '<(shared_generated_dir)/libavcodec/mpeg4video.c',
          '<(shared_generated_dir)/libavcodec/mpeg4video_parser.c',
          '<(shared_generated_dir)/libavcodec/mpeg4videodec.c',
          '<(shared_generated_dir)/libavcodec/msgsmdec.c',
          '<(shared_generated_dir)/libavformat/amr.c',
          '<(shared_generated_dir)/libavformat/avidec.c',
          '<(shared_generated_dir)/libavformat/gsmdec.c',
        ],
      }],  # (1) and (ffmpeg_branding == "ChromeOS") and (1)
      ['(target_arch == "ia32" or target_arch == "x64") and (ffmpeg_branding == "Chrome" or ffmpeg_branding == "ChromeOS") and (1)', {
        'c_sources': [
          'libavcodec/x86/h264_qpel.c',
          'libavcodec/x86/h264chroma_init.c',
          'libavcodec/x86/h264dsp_init.c',
          'libavcodec/x86/mpegaudiodec.c',
          'libavcodec/x86/mpegvideo.c',
          'libavcodec/x86/sbrdsp_init.c',
        ],
        'asm_sources': [
          'libavcodec/x86/dct32.asm',
          'libavcodec/x86/h264_chromamc.asm',
          'libavcodec/x86/h264_chromamc_10bit.asm',
          'libavcodec/x86/h264_deblock.asm',
          'libavcodec/x86/h264_deblock_10bit.asm',
          'libavcodec/x86/h264_idct.asm',
          'libavcodec/x86/h264_idct_10bit.asm',
          'libavcodec/x86/h264_qpel_10bit.asm',
          'libavcodec/x86/h264_qpel_8bit.asm',
          'libavcodec/x86/h264_weight.asm',
          'libavcodec/x86/h264_weight_10bit.asm',
          'libavcodec/x86/imdct36.asm',
          'libavcodec/x86/sbrdsp.asm',
        ],
        'converter_outputs': [
          '<(shared_generated_dir)/libavcodec/x86/h264_qpel.c',
          '<(shared_generated_dir)/libavcodec/x86/h264chroma_init.c',
          '<(shared_generated_dir)/libavcodec/x86/h264dsp_init.c',
          '<(shared_generated_dir)/libavcodec/x86/mpegaudiodec.c',
          '<(shared_generated_dir)/libavcodec/x86/mpegvideo.c',
          '<(shared_generated_dir)/libavcodec/x86/sbrdsp_init.c',
        ],
      }],  # (target_arch == "ia32" or target_arch == "x64") and (ffmpeg_branding == "Chrome" or ffmpeg_branding == "ChromeOS") and (1)
      ['(target_arch == "arm" or (target_arch == "arm" and arm_neon == 1)) and (ffmpeg_branding == "Chrome" or ffmpeg_branding == "ChromeOS") and (1)', {
        'c_sources': [
          'libavcodec/arm/aacpsdsp_init_arm.c',
          'libavcodec/arm/h264chroma_init_arm.c',
          'libavcodec/arm/h264dsp_init_arm.c',
          'libavcodec/arm/h264qpel_init_arm.c',
          'libavcodec/arm/mpegaudiodsp_init_arm.c',
          'libavcodec/arm/mpegvideo_arm.c',
          'libavcodec/arm/mpegvideo_armv5te.c',
          'libavcodec/arm/sbrdsp_init_arm.c',
        ],
        'asm_sources': [
          'libavcodec/arm/mpegaudiodsp_fixed_armv6.S',
          'libavcodec/arm/mpegvideo_armv5te_s.S',
        ],
        'converter_outputs': [
          '<(shared_generated_dir)/libavcodec/arm/aacpsdsp_init_arm.c',
          '<(shared_generated_dir)/libavcodec/arm/h264chroma_init_arm.c',
          '<(shared_generated_dir)/libavcodec/arm/h264dsp_init_arm.c',
          '<(shared_generated_dir)/libavcodec/arm/h264qpel_init_arm.c',
          '<(shared_generated_dir)/libavcodec/arm/mpegaudiodsp_init_arm.c',
          '<(shared_generated_dir)/libavcodec/arm/mpegvideo_arm.c',
          '<(shared_generated_dir)/libavcodec/arm/mpegvideo_armv5te.c',
          '<(shared_generated_dir)/libavcodec/arm/sbrdsp_init_arm.c',
        ],
      }],  # (target_arch == "arm" or (target_arch == "arm" and arm_neon == 1)) and (ffmpeg_branding == "Chrome" or ffmpeg_branding == "ChromeOS") and (1)
      ['(target_arch == "arm" or (target_arch == "arm" and arm_neon == 1)) and (ffmpeg_branding == "ChromiumOS" or ffmpeg_branding == "ChromeOS") and (1)', {
        'c_sources': [
          'libavcodec/arm/flacdsp_init_arm.c',
        ],
        'asm_sources': [
          'libavcodec/arm/flacdsp_arm.S',
        ],
        'converter_outputs': [
          '<(shared_generated_dir)/libavcodec/arm/flacdsp_init_arm.c',
        ],
      }],  # (target_arch == "arm" or (target_arch == "arm" and arm_neon == 1)) and (ffmpeg_branding == "ChromiumOS" or ffmpeg_branding == "ChromeOS") and (1)
      ['((target_arch == "arm" and arm_neon == 1)) and (1) and (1)', {
        'c_sources': [
          'libavcodec/arm/dsputil_init_neon.c',
          'libavcodec/arm/vp8dsp_init_neon.c',
          'libavutil/arm/float_dsp_init_neon.c',
        ],
        'asm_sources': [
          'libavcodec/arm/dsputil_neon.S',
          'libavcodec/arm/fft_fixed_neon.S',
          'libavcodec/arm/fft_neon.S',
          'libavcodec/arm/fmtconvert_neon.S',
          'libavcodec/arm/h264pred_neon.S',
          'libavcodec/arm/int_neon.S',
          'libavcodec/arm/mdct_fixed_neon.S',
          'libavcodec/arm/mdct_neon.S',
          'libavcodec/arm/rdft_neon.S',
          'libavcodec/arm/simple_idct_neon.S',
          'libavcodec/arm/vorbisdsp_neon.S',
          'libavcodec/arm/vp3dsp_neon.S',
          'libavcodec/arm/vp8dsp_neon.S',
          'libavutil/arm/float_dsp_neon.S',
        ],
        'converter_outputs': [
          '<(shared_generated_dir)/libavcodec/arm/dsputil_init_neon.c',
          '<(shared_generated_dir)/libavcodec/arm/vp8dsp_init_neon.c',
          '<(shared_generated_dir)/libavutil/arm/float_dsp_init_neon.c',
        ],
      }],  # ((target_arch == "arm" and arm_neon == 1)) and (1) and (1)
      ['(1) and (ffmpeg_branding == "ChromiumOS" or ffmpeg_branding == "ChromeOS") and (1)', {
        'c_sources': [
          'libavcodec/flac_parser.c',
          'libavcodec/flacdec.c',
          'libavcodec/flacdsp.c',
          'libavformat/flacdec.c',
          'libavformat/rawdec.c',
        ],
        'converter_outputs': [
          '<(shared_generated_dir)/libavcodec/flac_parser.c',
          '<(shared_generated_dir)/libavcodec/flacdec.c',
          '<(shared_generated_dir)/libavcodec/flacdsp.c',
          '<(shared_generated_dir)/libavformat/flacdec.c',
          '<(shared_generated_dir)/libavformat/rawdec.c',
        ],
      }],  # (1) and (ffmpeg_branding == "ChromiumOS" or ffmpeg_branding == "ChromeOS") and (1)
      ['(target_arch == "ia32" or target_arch == "x64") and (1) and (1)', {
        'c_sources': [
          'libavcodec/x86/dsputil_mmx.c',
          'libavcodec/x86/fdct.c',
          'libavcodec/x86/fft_init.c',
          'libavcodec/x86/fmtconvert_init.c',
          'libavcodec/x86/h264_intrapred_init.c',
          'libavcodec/x86/idct_mmx_xvid.c',
          'libavcodec/x86/idct_sse2_xvid.c',
          'libavcodec/x86/simple_idct.c',
          'libavcodec/x86/videodsp_init.c',
          'libavcodec/x86/vorbisdsp_init.c',
          'libavcodec/x86/vp3dsp_init.c',
          'libavcodec/x86/vp8dsp_init.c',
          'libavutil/x86/cpu.c',
          'libavutil/x86/float_dsp_init.c',
        ],
        'asm_sources': [
          'libavcodec/x86/deinterlace.asm',
          'libavcodec/x86/dsputil.asm',
          'libavcodec/x86/fft.asm',
          'libavcodec/x86/fmtconvert.asm',
          'libavcodec/x86/h264_intrapred.asm',
          'libavcodec/x86/h264_intrapred_10bit.asm',
          'libavcodec/x86/hpeldsp.asm',
          'libavcodec/x86/mpeg4qpel.asm',
          'libavcodec/x86/videodsp.asm',
          'libavcodec/x86/vorbisdsp.asm',
          'libavcodec/x86/vp3dsp.asm',
          'libavcodec/x86/vp8dsp.asm',
          'libavutil/x86/cpuid.asm',
          'libavutil/x86/emms.asm',
          'libavutil/x86/float_dsp.asm',
        ],
        'converter_outputs': [
          '<(shared_generated_dir)/libavcodec/x86/dsputil_mmx.c',
          '<(shared_generated_dir)/libavcodec/x86/fdct.c',
          '<(shared_generated_dir)/libavcodec/x86/fft_init.c',
          '<(shared_generated_dir)/libavcodec/x86/fmtconvert_init.c',
          '<(shared_generated_dir)/libavcodec/x86/h264_intrapred_init.c',
          '<(shared_generated_dir)/libavcodec/x86/idct_mmx_xvid.c',
          '<(shared_generated_dir)/libavcodec/x86/idct_sse2_xvid.c',
          '<(shared_generated_dir)/libavcodec/x86/simple_idct.c',
          '<(shared_generated_dir)/libavcodec/x86/videodsp_init.c',
          '<(shared_generated_dir)/libavcodec/x86/vorbisdsp_init.c',
          '<(shared_generated_dir)/libavcodec/x86/vp3dsp_init.c',
          '<(shared_generated_dir)/libavcodec/x86/vp8dsp_init.c',
          '<(shared_generated_dir)/libavutil/x86/cpu.c',
          '<(shared_generated_dir)/libavutil/x86/float_dsp_init.c',
        ],
      }],  # (target_arch == "ia32" or target_arch == "x64") and (1) and (1)
      ['(1) and (ffmpeg_branding == "Chrome" or ffmpeg_branding == "ChromeOS") and (1)', {
        'c_sources': [
          'libavcodec/aac_ac3_parser.c',
          'libavcodec/aac_parser.c',
          'libavcodec/aacadtsdec.c',
          'libavcodec/aacdec.c',
          'libavcodec/aacps.c',
          'libavcodec/aacpsdsp.c',
          'libavcodec/aacsbr.c',
          'libavcodec/aactab.c',
          'libavcodec/ac3tab.c',
          'libavcodec/cabac.c',
          'libavcodec/dct.c',
          'libavcodec/dct32_fixed.c',
          'libavcodec/dct32_float.c',
          'libavcodec/error_resilience.c',
          'libavcodec/h264.c',
          'libavcodec/h264_cabac.c',
          'libavcodec/h264_cavlc.c',
          'libavcodec/h264_direct.c',
          'libavcodec/h264_loopfilter.c',
          'libavcodec/h264_parser.c',
          'libavcodec/h264_ps.c',
          'libavcodec/h264_refs.c',
          'libavcodec/h264_sei.c',
          'libavcodec/h264chroma.c',
          'libavcodec/h264dsp.c',
          'libavcodec/h264idct.c',
          'libavcodec/h264qpel.c',
          'libavcodec/kbdwin.c',
          'libavcodec/mpegaudio.c',
          'libavcodec/mpegaudio_parser.c',
          'libavcodec/mpegaudiodec.c',
          'libavcodec/mpegaudiodecheader.c',
          'libavcodec/mpegaudiodsp.c',
          'libavcodec/mpegaudiodsp_data.c',
          'libavcodec/mpegaudiodsp_fixed.c',
          'libavcodec/mpegaudiodsp_float.c',
          'libavcodec/mpegvideo.c',
          'libavcodec/mpegvideo_motion.c',
          'libavcodec/sbrdsp.c',
          'libavcodec/sinewin.c',
          'libavcodec/timecode.c',
          'libavformat/mov.c',
          'libavformat/mov_chan.c',
          'libavformat/mp3dec.c',
        ],
        'converter_outputs': [
          '<(shared_generated_dir)/libavcodec/aac_ac3_parser.c',
          '<(shared_generated_dir)/libavcodec/aac_parser.c',
          '<(shared_generated_dir)/libavcodec/aacadtsdec.c',
          '<(shared_generated_dir)/libavcodec/aacdec.c',
          '<(shared_generated_dir)/libavcodec/aacps.c',
          '<(shared_generated_dir)/libavcodec/aacpsdsp.c',
          '<(shared_generated_dir)/libavcodec/aacsbr.c',
          '<(shared_generated_dir)/libavcodec/aactab.c',
          '<(shared_generated_dir)/libavcodec/ac3tab.c',
          '<(shared_generated_dir)/libavcodec/cabac.c',
          '<(shared_generated_dir)/libavcodec/dct.c',
          '<(shared_generated_dir)/libavcodec/dct32_fixed.c',
          '<(shared_generated_dir)/libavcodec/dct32_float.c',
          '<(shared_generated_dir)/libavcodec/error_resilience.c',
          '<(shared_generated_dir)/libavcodec/h264.c',
          '<(shared_generated_dir)/libavcodec/h264_cabac.c',
          '<(shared_generated_dir)/libavcodec/h264_cavlc.c',
          '<(shared_generated_dir)/libavcodec/h264_direct.c',
          '<(shared_generated_dir)/libavcodec/h264_loopfilter.c',
          '<(shared_generated_dir)/libavcodec/h264_parser.c',
          '<(shared_generated_dir)/libavcodec/h264_ps.c',
          '<(shared_generated_dir)/libavcodec/h264_refs.c',
          '<(shared_generated_dir)/libavcodec/h264_sei.c',
          '<(shared_generated_dir)/libavcodec/h264chroma.c',
          '<(shared_generated_dir)/libavcodec/h264dsp.c',
          '<(shared_generated_dir)/libavcodec/h264idct.c',
          '<(shared_generated_dir)/libavcodec/h264qpel.c',
          '<(shared_generated_dir)/libavcodec/kbdwin.c',
          '<(shared_generated_dir)/libavcodec/mpegaudio.c',
          '<(shared_generated_dir)/libavcodec/mpegaudio_parser.c',
          '<(shared_generated_dir)/libavcodec/mpegaudiodec.c',
          '<(shared_generated_dir)/libavcodec/mpegaudiodecheader.c',
          '<(shared_generated_dir)/libavcodec/mpegaudiodsp.c',
          '<(shared_generated_dir)/libavcodec/mpegaudiodsp_data.c',
          '<(shared_generated_dir)/libavcodec/mpegaudiodsp_fixed.c',
          '<(shared_generated_dir)/libavcodec/mpegaudiodsp_float.c',
          '<(shared_generated_dir)/libavcodec/mpegvideo.c',
          '<(shared_generated_dir)/libavcodec/mpegvideo_motion.c',
          '<(shared_generated_dir)/libavcodec/sbrdsp.c',
          '<(shared_generated_dir)/libavcodec/sinewin.c',
          '<(shared_generated_dir)/libavcodec/timecode.c',
          '<(shared_generated_dir)/libavformat/mov.c',
          '<(shared_generated_dir)/libavformat/mov_chan.c',
          '<(shared_generated_dir)/libavformat/mp3dec.c',
        ],
      }],  # (1) and (ffmpeg_branding == "Chrome" or ffmpeg_branding == "ChromeOS") and (1)
      ['(target_arch == "arm" or (target_arch == "arm" and arm_neon == 1)) and (1) and (1)', {
        'c_sources': [
          'libavcodec/arm/dsputil_init_arm.c',
          'libavcodec/arm/dsputil_init_armv5te.c',
          'libavcodec/arm/dsputil_init_armv6.c',
          'libavcodec/arm/fft_fixed_init_arm.c',
          'libavcodec/arm/fft_init_arm.c',
          'libavcodec/arm/fmtconvert_init_arm.c',
          'libavcodec/arm/h264pred_init_arm.c',
          'libavcodec/arm/videodsp_init_arm.c',
          'libavcodec/arm/videodsp_init_armv5te.c',
          'libavcodec/arm/vorbisdsp_init_arm.c',
          'libavcodec/arm/vp3dsp_init_arm.c',
          'libavcodec/arm/vp8dsp_init_arm.c',
          'libavcodec/arm/vp8dsp_init_armv6.c',
          'libavutil/arm/cpu.c',
          'libavutil/arm/float_dsp_init_arm.c',
          'libavutil/arm/float_dsp_init_vfp.c',
        ],
        'asm_sources': [
          'libavcodec/arm/dsputil_arm.S',
          'libavcodec/arm/dsputil_armv6.S',
          'libavcodec/arm/fmtconvert_vfp.S',
          'libavcodec/arm/jrevdct_arm.S',
          'libavcodec/arm/simple_idct_arm.S',
          'libavcodec/arm/simple_idct_armv5te.S',
          'libavcodec/arm/simple_idct_armv6.S',
          'libavcodec/arm/videodsp_armv5te.S',
          'libavcodec/arm/vp8_armv6.S',
          'libavcodec/arm/vp8dsp_armv6.S',
          'libavutil/arm/float_dsp_vfp.S',
        ],
        'converter_outputs': [
          '<(shared_generated_dir)/libavcodec/arm/dsputil_init_arm.c',
          '<(shared_generated_dir)/libavcodec/arm/dsputil_init_armv5te.c',
          '<(shared_generated_dir)/libavcodec/arm/dsputil_init_armv6.c',
          '<(shared_generated_dir)/libavcodec/arm/fft_fixed_init_arm.c',
          '<(shared_generated_dir)/libavcodec/arm/fft_init_arm.c',
          '<(shared_generated_dir)/libavcodec/arm/fmtconvert_init_arm.c',
          '<(shared_generated_dir)/libavcodec/arm/h264pred_init_arm.c',
          '<(shared_generated_dir)/libavcodec/arm/videodsp_init_arm.c',
          '<(shared_generated_dir)/libavcodec/arm/videodsp_init_armv5te.c',
          '<(shared_generated_dir)/libavcodec/arm/vorbisdsp_init_arm.c',
          '<(shared_generated_dir)/libavcodec/arm/vp3dsp_init_arm.c',
          '<(shared_generated_dir)/libavcodec/arm/vp8dsp_init_arm.c',
          '<(shared_generated_dir)/libavcodec/arm/vp8dsp_init_armv6.c',
          '<(shared_generated_dir)/libavutil/arm/cpu.c',
          '<(shared_generated_dir)/libavutil/arm/float_dsp_init_arm.c',
          '<(shared_generated_dir)/libavutil/arm/float_dsp_init_vfp.c',
        ],
      }],  # (target_arch == "arm" or (target_arch == "arm" and arm_neon == 1)) and (1) and (1)
      ['(1) and (1) and (1)', {
        'c_sources': [
          'libavcodec/allcodecs.c',
          'libavcodec/audioconvert.c',
          'libavcodec/avfft.c',
          'libavcodec/avpacket.c',
          'libavcodec/avpicture.c',
          'libavcodec/bitstream.c',
          'libavcodec/bitstream_filter.c',
          'libavcodec/codec_desc.c',
          'libavcodec/dirac.c',
          'libavcodec/dsputil.c',
          'libavcodec/faanidct.c',
          'libavcodec/fft_fixed.c',
          'libavcodec/fft_float.c',
          'libavcodec/flac.c',
          'libavcodec/flacdata.c',
          'libavcodec/fmtconvert.c',
          'libavcodec/frame_thread_encoder.c',
          'libavcodec/golomb.c',
          'libavcodec/h264pred.c',
          'libavcodec/imgconvert.c',
          'libavcodec/jrevdct.c',
          'libavcodec/mathtables.c',
          'libavcodec/mdct_fixed.c',
          'libavcodec/mdct_float.c',
          'libavcodec/mpeg12data.c',
          'libavcodec/mpeg4audio.c',
          'libavcodec/mpegaudiodata.c',
          'libavcodec/options.c',
          'libavcodec/parser.c',
          'libavcodec/pcm.c',
          'libavcodec/pthread.c',
          'libavcodec/raw.c',
          'libavcodec/rawdec.c',
          'libavcodec/rdft.c',
          'libavcodec/simple_idct.c',
          'libavcodec/utils.c',
          'libavcodec/videodsp.c',
          'libavcodec/vorbis.c',
          'libavcodec/vorbis_data.c',
          'libavcodec/vorbis_parser.c',
          'libavcodec/vorbisdec.c',
          'libavcodec/vorbisdsp.c',
          'libavcodec/vp3.c',
          'libavcodec/vp3_parser.c',
          'libavcodec/vp3dsp.c',
          'libavcodec/vp56rac.c',
          'libavcodec/vp8.c',
          'libavcodec/vp8_parser.c',
          'libavcodec/vp8dsp.c',
          'libavcodec/xiph.c',
          'libavformat/allformats.c',
          'libavformat/avio.c',
          'libavformat/aviobuf.c',
          'libavformat/cutils.c',
          'libavformat/id3v1.c',
          'libavformat/id3v2.c',
          'libavformat/isom.c',
          'libavformat/matroska.c',
          'libavformat/matroskadec.c',
          'libavformat/metadata.c',
          'libavformat/mux.c',
          'libavformat/oggdec.c',
          'libavformat/oggparsecelt.c',
          'libavformat/oggparsedirac.c',
          'libavformat/oggparseflac.c',
          'libavformat/oggparseogm.c',
          'libavformat/oggparseopus.c',
          'libavformat/oggparseskeleton.c',
          'libavformat/oggparsespeex.c',
          'libavformat/oggparsetheora.c',
          'libavformat/oggparsevorbis.c',
          'libavformat/options.c',
          'libavformat/os_support.c',
          'libavformat/pcm.c',
          'libavformat/riff.c',
          'libavformat/rmsipr.c',
          'libavformat/seek.c',
          'libavformat/subtitles.c',
          'libavformat/utils.c',
          'libavformat/vorbiscomment.c',
          'libavformat/wavdec.c',
          'libavutil/audio_fifo.c',
          'libavutil/avstring.c',
          'libavutil/base64.c',
          'libavutil/blowfish.c',
          'libavutil/bprint.c',
          'libavutil/channel_layout.c',
          'libavutil/cpu.c',
          'libavutil/crc.c',
          'libavutil/dict.c',
          'libavutil/error.c',
          'libavutil/eval.c',
          'libavutil/fifo.c',
          'libavutil/float_dsp.c',
          'libavutil/hmac.c',
          'libavutil/imgutils.c',
          'libavutil/intfloat_readwrite.c',
          'libavutil/intmath.c',
          'libavutil/lfg.c',
          'libavutil/log.c',
          'libavutil/log2_tab.c',
          'libavutil/mathematics.c',
          'libavutil/md5.c',
          'libavutil/mem.c',
          'libavutil/opt.c',
          'libavutil/parseutils.c',
          'libavutil/pixdesc.c',
          'libavutil/random_seed.c',
          'libavutil/rational.c',
          'libavutil/samplefmt.c',
          'libavutil/sha.c',
          'libavutil/time.c',
          'libavutil/timecode.c',
          'libavutil/utils.c',
          'libavutil/xga_font_data.c',
          'libavutil/xtea.c',
        ],
        'converter_outputs': [
          '<(shared_generated_dir)/libavcodec/allcodecs.c',
          '<(shared_generated_dir)/libavcodec/audioconvert.c',
          '<(shared_generated_dir)/libavcodec/avfft.c',
          '<(shared_generated_dir)/libavcodec/avpacket.c',
          '<(shared_generated_dir)/libavcodec/avpicture.c',
          '<(shared_generated_dir)/libavcodec/bitstream.c',
          '<(shared_generated_dir)/libavcodec/bitstream_filter.c',
          '<(shared_generated_dir)/libavcodec/codec_desc.c',
          '<(shared_generated_dir)/libavcodec/dirac.c',
          '<(shared_generated_dir)/libavcodec/dsputil.c',
          '<(shared_generated_dir)/libavcodec/faanidct.c',
          '<(shared_generated_dir)/libavcodec/fft_fixed.c',
          '<(shared_generated_dir)/libavcodec/fft_float.c',
          '<(shared_generated_dir)/libavcodec/flac.c',
          '<(shared_generated_dir)/libavcodec/flacdata.c',
          '<(shared_generated_dir)/libavcodec/fmtconvert.c',
          '<(shared_generated_dir)/libavcodec/frame_thread_encoder.c',
          '<(shared_generated_dir)/libavcodec/golomb.c',
          '<(shared_generated_dir)/libavcodec/h264pred.c',
          '<(shared_generated_dir)/libavcodec/imgconvert.c',
          '<(shared_generated_dir)/libavcodec/jrevdct.c',
          '<(shared_generated_dir)/libavcodec/mathtables.c',
          '<(shared_generated_dir)/libavcodec/mdct_fixed.c',
          '<(shared_generated_dir)/libavcodec/mdct_float.c',
          '<(shared_generated_dir)/libavcodec/mpeg12data.c',
          '<(shared_generated_dir)/libavcodec/mpeg4audio.c',
          '<(shared_generated_dir)/libavcodec/mpegaudiodata.c',
          '<(shared_generated_dir)/libavcodec/options.c',
          '<(shared_generated_dir)/libavcodec/parser.c',
          '<(shared_generated_dir)/libavcodec/pcm.c',
          '<(shared_generated_dir)/libavcodec/pthread.c',
          '<(shared_generated_dir)/libavcodec/raw.c',
          '<(shared_generated_dir)/libavcodec/rawdec.c',
          '<(shared_generated_dir)/libavcodec/rdft.c',
          '<(shared_generated_dir)/libavcodec/simple_idct.c',
          '<(shared_generated_dir)/libavcodec/utils.c',
          '<(shared_generated_dir)/libavcodec/videodsp.c',
          '<(shared_generated_dir)/libavcodec/vorbis.c',
          '<(shared_generated_dir)/libavcodec/vorbis_data.c',
          '<(shared_generated_dir)/libavcodec/vorbis_parser.c',
          '<(shared_generated_dir)/libavcodec/vorbisdec.c',
          '<(shared_generated_dir)/libavcodec/vorbisdsp.c',
          '<(shared_generated_dir)/libavcodec/vp3.c',
          '<(shared_generated_dir)/libavcodec/vp3_parser.c',
          '<(shared_generated_dir)/libavcodec/vp3dsp.c',
          '<(shared_generated_dir)/libavcodec/vp56rac.c',
          '<(shared_generated_dir)/libavcodec/vp8.c',
          '<(shared_generated_dir)/libavcodec/vp8_parser.c',
          '<(shared_generated_dir)/libavcodec/vp8dsp.c',
          '<(shared_generated_dir)/libavcodec/xiph.c',
          '<(shared_generated_dir)/libavformat/allformats.c',
          '<(shared_generated_dir)/libavformat/avio.c',
          '<(shared_generated_dir)/libavformat/aviobuf.c',
          '<(shared_generated_dir)/libavformat/cutils.c',
          '<(shared_generated_dir)/libavformat/id3v1.c',
          '<(shared_generated_dir)/libavformat/id3v2.c',
          '<(shared_generated_dir)/libavformat/isom.c',
          '<(shared_generated_dir)/libavformat/matroska.c',
          '<(shared_generated_dir)/libavformat/matroskadec.c',
          '<(shared_generated_dir)/libavformat/metadata.c',
          '<(shared_generated_dir)/libavformat/mux.c',
          '<(shared_generated_dir)/libavformat/oggdec.c',
          '<(shared_generated_dir)/libavformat/oggparsecelt.c',
          '<(shared_generated_dir)/libavformat/oggparsedirac.c',
          '<(shared_generated_dir)/libavformat/oggparseflac.c',
          '<(shared_generated_dir)/libavformat/oggparseogm.c',
          '<(shared_generated_dir)/libavformat/oggparseopus.c',
          '<(shared_generated_dir)/libavformat/oggparseskeleton.c',
          '<(shared_generated_dir)/libavformat/oggparsespeex.c',
          '<(shared_generated_dir)/libavformat/oggparsetheora.c',
          '<(shared_generated_dir)/libavformat/oggparsevorbis.c',
          '<(shared_generated_dir)/libavformat/options.c',
          '<(shared_generated_dir)/libavformat/os_support.c',
          '<(shared_generated_dir)/libavformat/pcm.c',
          '<(shared_generated_dir)/libavformat/riff.c',
          '<(shared_generated_dir)/libavformat/rmsipr.c',
          '<(shared_generated_dir)/libavformat/seek.c',
          '<(shared_generated_dir)/libavformat/subtitles.c',
          '<(shared_generated_dir)/libavformat/utils.c',
          '<(shared_generated_dir)/libavformat/vorbiscomment.c',
          '<(shared_generated_dir)/libavformat/wavdec.c',
          '<(shared_generated_dir)/libavutil/audio_fifo.c',
          '<(shared_generated_dir)/libavutil/avstring.c',
          '<(shared_generated_dir)/libavutil/base64.c',
          '<(shared_generated_dir)/libavutil/blowfish.c',
          '<(shared_generated_dir)/libavutil/bprint.c',
          '<(shared_generated_dir)/libavutil/channel_layout.c',
          '<(shared_generated_dir)/libavutil/cpu.c',
          '<(shared_generated_dir)/libavutil/crc.c',
          '<(shared_generated_dir)/libavutil/dict.c',
          '<(shared_generated_dir)/libavutil/error.c',
          '<(shared_generated_dir)/libavutil/eval.c',
          '<(shared_generated_dir)/libavutil/fifo.c',
          '<(shared_generated_dir)/libavutil/float_dsp.c',
          '<(shared_generated_dir)/libavutil/hmac.c',
          '<(shared_generated_dir)/libavutil/imgutils.c',
          '<(shared_generated_dir)/libavutil/intfloat_readwrite.c',
          '<(shared_generated_dir)/libavutil/intmath.c',
          '<(shared_generated_dir)/libavutil/lfg.c',
          '<(shared_generated_dir)/libavutil/log.c',
          '<(shared_generated_dir)/libavutil/log2_tab.c',
          '<(shared_generated_dir)/libavutil/mathematics.c',
          '<(shared_generated_dir)/libavutil/md5.c',
          '<(shared_generated_dir)/libavutil/mem.c',
          '<(shared_generated_dir)/libavutil/opt.c',
          '<(shared_generated_dir)/libavutil/parseutils.c',
          '<(shared_generated_dir)/libavutil/pixdesc.c',
          '<(shared_generated_dir)/libavutil/random_seed.c',
          '<(shared_generated_dir)/libavutil/rational.c',
          '<(shared_generated_dir)/libavutil/samplefmt.c',
          '<(shared_generated_dir)/libavutil/sha.c',
          '<(shared_generated_dir)/libavutil/time.c',
          '<(shared_generated_dir)/libavutil/timecode.c',
          '<(shared_generated_dir)/libavutil/utils.c',
          '<(shared_generated_dir)/libavutil/xga_font_data.c',
          '<(shared_generated_dir)/libavutil/xtea.c',
        ],
      }],  # (1) and (1) and (1)
    ],  # conditions
    'c_headers': [
      'libavcodec/a64colors.h',
      'libavcodec/a64enc.h',
      'libavcodec/a64tables.h',
      'libavcodec/aac.h',
      'libavcodec/aac_ac3_parser.h',
      'libavcodec/aac_tablegen.h',
      'libavcodec/aac_tablegen_decl.h',
      'libavcodec/aacadtsdec.h',
      'libavcodec/aacdectab.h',
      'libavcodec/aacenc.h',
      'libavcodec/aacps.h',
      'libavcodec/aacps_tablegen.h',
      'libavcodec/aacpsdsp.h',
      'libavcodec/aacpsy.h',
      'libavcodec/aacsbr.h',
      'libavcodec/aacsbrdata.h',
      'libavcodec/aactab.h',
      'libavcodec/aandcttab.h',
      'libavcodec/ac3.h',
      'libavcodec/ac3_parser.h',
      'libavcodec/ac3dec.h',
      'libavcodec/ac3dec_data.h',
      'libavcodec/ac3dsp.h',
      'libavcodec/ac3enc.h',
      'libavcodec/ac3tab.h',
      'libavcodec/acelp_filters.h',
      'libavcodec/acelp_pitch_delay.h',
      'libavcodec/acelp_vectors.h',
      'libavcodec/adpcm.h',
      'libavcodec/adpcm_data.h',
      'libavcodec/adx.h',
      'libavcodec/alac_data.h',
      'libavcodec/alpha/asm.h',
      'libavcodec/alpha/dsputil_alpha.h',
      'libavcodec/alpha/regdef.h',
      'libavcodec/amr.h',
      'libavcodec/amrnbdata.h',
      'libavcodec/amrwbdata.h',
      'libavcodec/arm/aac.h',
      'libavcodec/arm/asm-offsets.h',
      'libavcodec/arm/dca.h',
      'libavcodec/arm/dsputil_arm.h',
      'libavcodec/arm/mathops.h',
      'libavcodec/arm/mpegvideo_arm.h',
      'libavcodec/arm/videodsp_arm.h',
      'libavcodec/arm/vp56_arith.h',
      'libavcodec/arm/vp8.h',
      'libavcodec/arm/vp8dsp.h',
      'libavcodec/ass.h',
      'libavcodec/ass_split.h',
      'libavcodec/asv.h',
      'libavcodec/atrac.h',
      'libavcodec/atrac1data.h',
      'libavcodec/atrac3data.h',
      'libavcodec/audio_frame_queue.h',
      'libavcodec/audioconvert.h',
      'libavcodec/avcodec.h',
      'libavcodec/avfft.h',
      'libavcodec/avr32/mathops.h',
      'libavcodec/bethsoftvideo.h',
      'libavcodec/bfin/config_bfin.h',
      'libavcodec/bfin/dsputil_bfin.h',
      'libavcodec/bfin/mathops.h',
      'libavcodec/bfin/vp3_bfin.h',
      'libavcodec/bgmc.h',
      'libavcodec/binkdata.h',
      'libavcodec/binkdsp.h',
      'libavcodec/bintext.h',
      'libavcodec/bmp.h',
      'libavcodec/bytestream.h',
      'libavcodec/cabac.h',
      'libavcodec/cabac_functions.h',
      'libavcodec/cavs.h',
      'libavcodec/cavsdata.h',
      'libavcodec/cavsdsp.h',
      'libavcodec/cbrt_tablegen.h',
      'libavcodec/celp_filters.h',
      'libavcodec/celp_math.h',
      'libavcodec/cga_data.h',
      'libavcodec/cookdata.h',
      'libavcodec/copy_block.h',
      'libavcodec/dca.h',
      'libavcodec/dca_parser.h',
      'libavcodec/dcadata.h',
      'libavcodec/dcadsp.h',
      'libavcodec/dcaenc.h',
      'libavcodec/dcahuff.h',
      'libavcodec/dct.h',
      'libavcodec/dct32.h',
      'libavcodec/dctref.h',
      'libavcodec/dirac.h',
      'libavcodec/dirac_arith.h',
      'libavcodec/dirac_dwt.h',
      'libavcodec/diracdsp.h',
      'libavcodec/dnxhddata.h',
      'libavcodec/dnxhdenc.h',
      'libavcodec/dsputil.h',
      'libavcodec/dv_profile.h',
      'libavcodec/dv_tablegen.h',
      'libavcodec/dv_vlc_data.h',
      'libavcodec/dvdata.h',
      'libavcodec/dxva2.h',
      'libavcodec/dxva2_internal.h',
      'libavcodec/eac3_data.h',
      'libavcodec/eac3enc.h',
      'libavcodec/eaidct.h',
      'libavcodec/elbg.h',
      'libavcodec/error_resilience.h',
      'libavcodec/evrcdata.h',
      'libavcodec/faandct.h',
      'libavcodec/faanidct.h',
      'libavcodec/faxcompr.h',
      'libavcodec/fft-internal.h',
      'libavcodec/fft.h',
      'libavcodec/ffv1.h',
      'libavcodec/flac.h',
      'libavcodec/flacdata.h',
      'libavcodec/flacdsp.h',
      'libavcodec/flv.h',
      'libavcodec/fmtconvert.h',
      'libavcodec/frame_thread_encoder.h',
      'libavcodec/g722.h',
      'libavcodec/g723_1_data.h',
      'libavcodec/g729.h',
      'libavcodec/g729data.h',
      'libavcodec/g729postfilter.h',
      'libavcodec/get_bits.h',
      'libavcodec/gif.h',
      'libavcodec/golomb.h',
      'libavcodec/gsm.h',
      'libavcodec/gsmdec_data.h',
      'libavcodec/h261.h',
      'libavcodec/h261data.h',
      'libavcodec/h263.h',
      'libavcodec/h263_parser.h',
      'libavcodec/h263data.h',
      'libavcodec/h264.h',
      'libavcodec/h264_mvpred.h',
      'libavcodec/h264chroma.h',
      'libavcodec/h264data.h',
      'libavcodec/h264dsp.h',
      'libavcodec/h264idct.h',
      'libavcodec/h264pred.h',
      'libavcodec/h264qpel.h',
      'libavcodec/huffman.h',
      'libavcodec/huffyuv.h',
      'libavcodec/iirfilter.h',
      'libavcodec/imcdata.h',
      'libavcodec/imgconvert.h',
      'libavcodec/indeo2data.h',
      'libavcodec/indeo3data.h',
      'libavcodec/indeo4data.h',
      'libavcodec/indeo5data.h',
      'libavcodec/internal.h',
      'libavcodec/intrax8.h',
      'libavcodec/intrax8dsp.h',
      'libavcodec/intrax8huf.h',
      'libavcodec/ivi_common.h',
      'libavcodec/ivi_dsp.h',
      'libavcodec/j2k.h',
      'libavcodec/j2k_dwt.h',
      'libavcodec/jacosub.h',
      'libavcodec/jpegls.h',
      'libavcodec/jpeglsdec.h',
      'libavcodec/kbdwin.h',
      'libavcodec/lagarithrac.h',
      'libavcodec/lcl.h',
      'libavcodec/libopus.h',
      'libavcodec/libschroedinger.h',
      'libavcodec/libutvideo.h',
      'libavcodec/libxvid.h',
      'libavcodec/lpc.h',
      'libavcodec/lsp.h',
      'libavcodec/lzw.h',
      'libavcodec/mathops.h',
      'libavcodec/mips/aacdec_mips.h',
      'libavcodec/mips/aacsbr_mips.h',
      'libavcodec/mips/amrwbdec_mips.h',
      'libavcodec/mips/compute_antialias_fixed.h',
      'libavcodec/mips/compute_antialias_float.h',
      'libavcodec/mips/fft_table.h',
      'libavcodec/mips/lsp_mips.h',
      'libavcodec/mips/mathops.h',
      'libavcodec/mjpeg.h',
      'libavcodec/mjpegdec.h',
      'libavcodec/mjpegenc.h',
      'libavcodec/mlp.h',
      'libavcodec/mlp_parser.h',
      'libavcodec/mlpdsp.h',
      'libavcodec/motionpixels_tablegen.h',
      'libavcodec/mpc.h',
      'libavcodec/mpc7data.h',
      'libavcodec/mpc8data.h',
      'libavcodec/mpc8huff.h',
      'libavcodec/mpcdata.h',
      'libavcodec/mpeg12.h',
      'libavcodec/mpeg12data.h',
      'libavcodec/mpeg12decdata.h',
      'libavcodec/mpeg4audio.h',
      'libavcodec/mpeg4data.h',
      'libavcodec/mpeg4video.h',
      'libavcodec/mpeg4video_parser.h',
      'libavcodec/mpegaudio.h',
      'libavcodec/mpegaudio_tablegen.h',
      'libavcodec/mpegaudiodata.h',
      'libavcodec/mpegaudiodecheader.h',
      'libavcodec/mpegaudiodectab.h',
      'libavcodec/mpegaudiodsp.h',
      'libavcodec/mpegaudiotab.h',
      'libavcodec/mpegvideo.h',
      'libavcodec/mqc.h',
      'libavcodec/msgsmdec.h',
      'libavcodec/msmpeg4.h',
      'libavcodec/msmpeg4data.h',
      'libavcodec/msrledec.h',
      'libavcodec/mss12.h',
      'libavcodec/mss2dsp.h',
      'libavcodec/mss34dsp.h',
      'libavcodec/nellymoser.h',
      'libavcodec/old_codec_ids.h',
      'libavcodec/options_table.h',
      'libavcodec/os2threads.h',
      'libavcodec/paf.h',
      'libavcodec/parser.h',
      'libavcodec/pcm_tablegen.h',
      'libavcodec/png.h',
      'libavcodec/pngdsp.h',
      'libavcodec/pnm.h',
      'libavcodec/ppc/dsputil_altivec.h',
      'libavcodec/ppc/mathops.h',
      'libavcodec/proresdata.h',
      'libavcodec/proresdec.h',
      'libavcodec/proresdsp.h',
      'libavcodec/psymodel.h',
      'libavcodec/put_bits.h',
      'libavcodec/qcelpdata.h',
      'libavcodec/qdm2_tablegen.h',
      'libavcodec/qdm2data.h',
      'libavcodec/ra144.h',
      'libavcodec/ra288.h',
      'libavcodec/ralfdata.h',
      'libavcodec/rangecoder.h',
      'libavcodec/ratecontrol.h',
      'libavcodec/raw.h',
      'libavcodec/rdft.h',
      'libavcodec/rectangle.h',
      'libavcodec/rl.h',
      'libavcodec/rle.h',
      'libavcodec/rnd_avg.h',
      'libavcodec/roqvideo.h',
      'libavcodec/rtjpeg.h',
      'libavcodec/rv30data.h',
      'libavcodec/rv34.h',
      'libavcodec/rv34data.h',
      'libavcodec/rv34dsp.h',
      'libavcodec/rv34vlc.h',
      'libavcodec/rv40data.h',
      'libavcodec/rv40vlc2.h',
      'libavcodec/s3tc.h',
      'libavcodec/sanm_data.h',
      'libavcodec/sbr.h',
      'libavcodec/sbrdsp.h',
      'libavcodec/sgi.h',
      'libavcodec/sh4/dsputil_sh4.h',
      'libavcodec/sh4/sh4.h',
      'libavcodec/simple_idct.h',
      'libavcodec/sinewin.h',
      'libavcodec/sinewin_tablegen.h',
      'libavcodec/sipr.h',
      'libavcodec/sipr16kdata.h',
      'libavcodec/siprdata.h',
      'libavcodec/snow.h',
      'libavcodec/snow_dwt.h',
      'libavcodec/snowdata.h',
      'libavcodec/sp5x.h',
      'libavcodec/sparc/dsputil_vis.h',
      'libavcodec/sparc/vis.h',
      'libavcodec/sunrast.h',
      'libavcodec/svq1.h',
      'libavcodec/svq1_cb.h',
      'libavcodec/svq1_vlc.h',
      'libavcodec/svq1enc_cb.h',
      'libavcodec/svq3.h',
      'libavcodec/synth_filter.h',
      'libavcodec/tableprint.h',
      'libavcodec/tak.h',
      'libavcodec/targa.h',
      'libavcodec/thread.h',
      'libavcodec/tiff.h',
      'libavcodec/tiff_data.h',
      'libavcodec/timecode.h',
      'libavcodec/truemotion1data.h',
      'libavcodec/truespeech_data.h',
      'libavcodec/tscc2data.h',
      'libavcodec/twinvq_data.h',
      'libavcodec/ulti_cb.h',
      'libavcodec/unary.h',
      'libavcodec/utvideo.h',
      'libavcodec/v210dec.h',
      'libavcodec/vaapi.h',
      'libavcodec/vaapi_internal.h',
      'libavcodec/vc1.h',
      'libavcodec/vc1acdata.h',
      'libavcodec/vc1data.h',
      'libavcodec/vc1dsp.h',
      'libavcodec/vda.h',
      'libavcodec/vdpau.h',
      'libavcodec/vdpau_internal.h',
      'libavcodec/version.h',
      'libavcodec/videodsp.h',
      'libavcodec/vorbis.h',
      'libavcodec/vorbis_enc_data.h',
      'libavcodec/vorbis_parser.h',
      'libavcodec/vorbisdsp.h',
      'libavcodec/vp3data.h',
      'libavcodec/vp3dsp.h',
      'libavcodec/vp56.h',
      'libavcodec/vp56data.h',
      'libavcodec/vp56dsp.h',
      'libavcodec/vp5data.h',
      'libavcodec/vp6data.h',
      'libavcodec/vp8.h',
      'libavcodec/vp8data.h',
      'libavcodec/vp8dsp.h',
      'libavcodec/w32pthreads.h',
      'libavcodec/wma.h',
      'libavcodec/wma_common.h',
      'libavcodec/wmadata.h',
      'libavcodec/wmaprodata.h',
      'libavcodec/wmavoice_data.h',
      'libavcodec/wmv2.h',
      'libavcodec/wmv2dsp.h',
      'libavcodec/x86/cabac.h',
      'libavcodec/x86/dirac_dwt.h',
      'libavcodec/x86/diracdsp_mmx.h',
      'libavcodec/x86/dsputil_mmx.h',
      'libavcodec/x86/fft.h',
      'libavcodec/x86/h264_i386.h',
      'libavcodec/x86/idct_xvid.h',
      'libavcodec/x86/mathops.h',
      'libavcodec/x86/vc1dsp.h',
      'libavcodec/x86/vp56_arith.h',
      'libavcodec/xface.h',
      'libavcodec/xiph.h',
      'libavcodec/xvmc.h',
      'libavcodec/xvmc_internal.h',
      'libavcodec/xwd.h',
      'libavformat/aiff.h',
      'libavformat/apetag.h',
      'libavformat/asf.h',
      'libavformat/asfcrypt.h',
      'libavformat/ast.h',
      'libavformat/audiointerleave.h',
      'libavformat/avc.h',
      'libavformat/avformat.h',
      'libavformat/avi.h',
      'libavformat/avio.h',
      'libavformat/avio_internal.h',
      'libavformat/avlanguage.h',
      'libavformat/caf.h',
      'libavformat/dv.h',
      'libavformat/ffm.h',
      'libavformat/ffmeta.h',
      'libavformat/flacenc.h',
      'libavformat/flv.h',
      'libavformat/gxf.h',
      'libavformat/http.h',
      'libavformat/httpauth.h',
      'libavformat/id3v1.h',
      'libavformat/id3v2.h',
      'libavformat/internal.h',
      'libavformat/ircam.h',
      'libavformat/isom.h',
      'libavformat/matroska.h',
      'libavformat/metadata.h',
      'libavformat/mms.h',
      'libavformat/mov_chan.h',
      'libavformat/movenc.h',
      'libavformat/mpeg.h',
      'libavformat/mpegts.h',
      'libavformat/mxf.h',
      'libavformat/network.h',
      'libavformat/nut.h',
      'libavformat/oggdec.h',
      'libavformat/oma.h',
      'libavformat/options_table.h',
      'libavformat/os_support.h',
      'libavformat/pcm.h',
      'libavformat/qtpalette.h',
      'libavformat/rawdec.h',
      'libavformat/rawenc.h',
      'libavformat/rdt.h',
      'libavformat/riff.h',
      'libavformat/rm.h',
      'libavformat/rmsipr.h',
      'libavformat/rso.h',
      'libavformat/rtmp.h',
      'libavformat/rtmpcrypt.h',
      'libavformat/rtmpdh.h',
      'libavformat/rtmppkt.h',
      'libavformat/rtp.h',
      'libavformat/rtpdec.h',
      'libavformat/rtpdec_formats.h',
      'libavformat/rtpenc.h',
      'libavformat/rtpenc_chain.h',
      'libavformat/rtsp.h',
      'libavformat/rtspcodes.h',
      'libavformat/sauce.h',
      'libavformat/seek.h',
      'libavformat/smjpeg.h',
      'libavformat/sox.h',
      'libavformat/spdif.h',
      'libavformat/srtp.h',
      'libavformat/subtitles.h',
      'libavformat/swf.h',
      'libavformat/url.h',
      'libavformat/urldecode.h',
      'libavformat/version.h',
      'libavformat/voc.h',
      'libavformat/vorbiscomment.h',
      'libavformat/w64.h',
      'libavformat/wtv.h',
      'libavutil/adler32.h',
      'libavutil/aes.h',
      'libavutil/arm/bswap.h',
      'libavutil/arm/cpu.h',
      'libavutil/arm/float_dsp_arm.h',
      'libavutil/arm/intmath.h',
      'libavutil/arm/intreadwrite.h',
      'libavutil/arm/timer.h',
      'libavutil/attributes.h',
      'libavutil/audio_fifo.h',
      'libavutil/audioconvert.h',
      'libavutil/avassert.h',
      'libavutil/avr32/bswap.h',
      'libavutil/avr32/intreadwrite.h',
      'libavutil/avstring.h',
      'libavutil/avutil.h',
      'libavutil/base64.h',
      'libavutil/bfin/bswap.h',
      'libavutil/bfin/timer.h',
      'libavutil/blowfish.h',
      'libavutil/bprint.h',
      'libavutil/bswap.h',
      'libavutil/channel_layout.h',
      'libavutil/colorspace.h',
      'libavutil/common.h',
      'libavutil/cpu.h',
      'libavutil/crc.h',
      'libavutil/des.h',
      'libavutil/dict.h',
      'libavutil/error.h',
      'libavutil/eval.h',
      'libavutil/fifo.h',
      'libavutil/file.h',
      'libavutil/float_dsp.h',
      'libavutil/hmac.h',
      'libavutil/imgutils.h',
      'libavutil/integer.h',
      'libavutil/internal.h',
      'libavutil/intfloat.h',
      'libavutil/intfloat_readwrite.h',
      'libavutil/intmath.h',
      'libavutil/intreadwrite.h',
      'libavutil/lfg.h',
      'libavutil/libm.h',
      'libavutil/lls.h',
      'libavutil/log.h',
      'libavutil/lzo.h',
      'libavutil/mathematics.h',
      'libavutil/md5.h',
      'libavutil/mem.h',
      'libavutil/mips/intreadwrite.h',
      'libavutil/mips/libm_mips.h',
      'libavutil/old_pix_fmts.h',
      'libavutil/opt.h',
      'libavutil/parseutils.h',
      'libavutil/pca.h',
      'libavutil/pixdesc.h',
      'libavutil/pixfmt.h',
      'libavutil/ppc/float_dsp_altivec.h',
      'libavutil/ppc/intreadwrite.h',
      'libavutil/ppc/timer.h',
      'libavutil/ppc/types_altivec.h',
      'libavutil/ppc/util_altivec.h',
      'libavutil/qsort.h',
      'libavutil/random_seed.h',
      'libavutil/rational.h',
      'libavutil/rc4.h',
      'libavutil/samplefmt.h',
      'libavutil/sh4/bswap.h',
      'libavutil/sha.h',
      'libavutil/softfloat.h',
      'libavutil/time.h',
      'libavutil/timecode.h',
      'libavutil/timer.h',
      'libavutil/timestamp.h',
      'libavutil/tomi/intreadwrite.h',
      'libavutil/tree.h',
      'libavutil/version.h',
      'libavutil/x86/asm.h',
      'libavutil/x86/bswap.h',
      'libavutil/x86/cpu.h',
      'libavutil/x86/emms.h',
      'libavutil/x86/intreadwrite.h',
      'libavutil/x86/timer.h',
      'libavutil/x86/w64xmmtest.h',
      'libavutil/x86_cpu.h',
      'libavutil/xga_font_data.h',
      'libavutil/xtea.h',
    ],  # c_headers
  },
}
