# Copyright (c) 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'targets': [
    {
      'target_name': 'test_support_content',
      'type': 'static_library',
      'defines!': ['CONTENT_IMPLEMENTATION'],
      'dependencies': [
        '../build/temp_gyp/googleurl.gyp:googleurl',
        'content_app',
        'content_browser',
        'content_common',
        '../media/media.gyp:media',
        '../net/net.gyp:net_test_support',
        '../skia/skia.gyp:skia',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        '../ui/ui.gyp:ui_test_support',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        'public/test/browser_test.h',
        'public/test/browser_test_base.cc',
        'public/test/browser_test_base.h',
        'public/test/browser_test_utils.cc',
        'public/test/browser_test_utils.h',
        'public/test/content_test_suite_base.cc',
        'public/test/content_test_suite_base.h',
        'public/test/download_test_observer.cc',
        'public/test/download_test_observer.h',
        'public/test/fake_speech_recognition_manager.cc',
        'public/test/fake_speech_recognition_manager.h',
        'public/test/js_injection_ready_observer.h',
        'public/test/layouttest_support.h',
        'public/test/mock_download_item.cc',
        'public/test/mock_download_item.h',
        'public/test/mock_download_manager.cc',
        'public/test/mock_download_manager.h',
        'public/test/mock_notification_observer.cc',
        'public/test/mock_notification_observer.h',
        'public/test/mock_render_process_host.cc',
        'public/test/mock_render_process_host.h',
        'public/test/mock_render_thread.cc',
        'public/test/mock_render_thread.h',
        'public/test/mock_resource_context.cc',
        'public/test/mock_resource_context.h',
        'public/test/render_view_fake_resources_test.cc',
        'public/test/render_view_fake_resources_test.h',
        'public/test/render_view_test.cc',
        'public/test/render_view_test.h',
        'public/test/render_widget_test.cc',
        'public/test/render_widget_test.h',
        'public/test/test_browser_context.cc',
        'public/test/test_browser_context.h',
        'public/test/test_browser_thread.cc',
        'public/test/test_browser_thread.h',
        'public/test/test_content_client_initializer.cc',
        'public/test/test_content_client_initializer.h',
        'public/test/test_file_error_injector.cc',
        'public/test/test_file_error_injector.h',
        'public/test/test_launcher.cc',
        'public/test/test_launcher.h',
        'public/test/test_navigation_observer.cc',
        'public/test/test_navigation_observer.h',
        'public/test/test_notification_tracker.cc',
        'public/test/test_notification_tracker.h',
        'public/test/test_renderer_host.cc',
        'public/test/test_renderer_host.h',
        'public/test/test_utils.cc',
        'public/test/test_utils.h',
        'public/test/unittest_test_suite.cc',
        'public/test/unittest_test_suite.h',
        'public/test/web_contents_tester.cc',
        'public/test/web_contents_tester.h',
        'app/startup_helper_win.cc',
        # TODO(phajdan.jr): All of those files should live in content/test (if
        # they're only used by content) or content/public/test (if they're used
        # by other embedders).
        'browser/download/mock_download_file.cc',
        'browser/download/mock_download_file.h',
        'browser/geolocation/fake_access_token_store.cc',
        'browser/geolocation/fake_access_token_store.h',
        'browser/geolocation/mock_location_arbitrator.cc',
        'browser/geolocation/mock_location_arbitrator.h',
        'browser/geolocation/mock_location_provider.cc',
        'browser/geolocation/mock_location_provider.h',
        'browser/renderer_host/compositing_iosurface_shader_programs_mac.cc',
        'browser/renderer_host/compositing_iosurface_shader_programs_mac.h',
        'browser/renderer_host/compositing_iosurface_transformer_mac.cc',
        'browser/renderer_host/compositing_iosurface_transformer_mac.h',
        'browser/renderer_host/media/mock_media_observer.cc',
        'browser/renderer_host/media/mock_media_observer.h',
        'browser/renderer_host/test_backing_store.cc',
        'browser/renderer_host/test_backing_store.h',
        'browser/renderer_host/test_render_view_host.cc',
        'browser/renderer_host/test_render_view_host.h',
        'gpu/gpu_idirect3d9_mock_win.cc',
        'gpu/gpu_idirect3d9_mock_win.h',
        'test/content_test_suite.cc',
        'test/content_test_suite.h',
        'test/gpu/gpu_test_config.cc',
        'test/gpu/gpu_test_config.h',
        'test/gpu/gpu_test_expectations_parser.cc',
        'test/gpu/gpu_test_expectations_parser.h',
        'test/layouttest_support.cc',
        'test/mock_keyboard.cc',
        'test/mock_keyboard_driver_win.cc',
        'test/mock_keyboard_driver_win.h',
        'test/mock_keyboard.h',
        'test/mock_render_process.cc',
        'test/mock_render_process.h',
        'test/net/url_request_failed_job.cc',
        'test/net/url_request_failed_job.h',
        'test/net/url_request_mock_http_job.cc',
        'test/net/url_request_mock_http_job.h',
        'test/net/url_request_prepackaged_interceptor.cc',
        'test/net/url_request_prepackaged_interceptor.h',
        'test/net/url_request_slow_download_job.cc',
        'test/net/url_request_slow_download_job.h',
        'test/net/url_request_abort_on_end_job.cc',
        'test/net/url_request_abort_on_end_job.h',
        'test/test_content_browser_client.cc',
        'test/test_content_browser_client.h',
        'test/test_content_client.cc',
        'test/test_content_client.h',
        'test/test_render_view_host_factory.cc',
        'test/test_render_view_host_factory.h',
        'test/test_web_contents.cc',
        'test/test_web_contents.h',
        'test/test_web_contents_view.cc',
        'test/test_web_contents_view.h',

        # TODO(phajdan.jr): Those files should be moved to webkit
        # test support target.
        '../webkit/appcache/appcache_test_helper.cc',
        '../webkit/appcache/appcache_test_helper.h',
      ],
      'conditions': [
        ['OS == "ios"', {
          'sources/': [
            # iOS only needs a small portion of content; exclude all the
            # implementation, and re-include what is used.
            ['exclude', '\\.(cc|mm)$'],
            ['include', '_ios\\.(cc|mm)$'],
            ['include', '^public/test/content_test_suite_base\\.cc$'],
            ['include', '^public/test/mock_notification_observer\\.cc$'],
            ['include', '^public/test/mock_resource_context\\.cc$'],
            ['include', '^public/test/test_browser_thread\\.cc$'],
            ['include', '^public/test/test_content_client_initializer\\.cc$'],
            ['include', '^public/test/test_notification_tracker\\.cc$'],
            ['include', '^public/test/test_utils\\.cc$'],
            ['include', '^public/test/unittest_test_suite\\.cc$'],
            ['include', '^test/content_test_suite\\.cc$'],
            ['include', '^test/test_content_browser_client\\.cc$'],
            ['include', '^test/test_content_client\\.cc$'],
          ],
        }, {  # OS != "ios"
          'dependencies': [
            'content_ppapi_plugin',
            'content_utility',
            'content_worker',
            '../ppapi/ppapi_internal.gyp:ppapi_host',
            '../ppapi/ppapi_internal.gyp:ppapi_proxy',
            '../ppapi/ppapi_internal.gyp:ppapi_shared',
            '../ppapi/ppapi_internal.gyp:ppapi_unittest_shared',
            '<(webkit_src_dir)/Source/WebKit/chromium/WebKit.gyp:webkit',
            '<(webkit_src_dir)/Tools/DumpRenderTree/DumpRenderTree.gyp/DumpRenderTree.gyp:TestRunner',
            '../ui/surface/surface.gyp:surface',
            '../webkit/compositor_bindings/compositor_bindings.gyp:webkit_compositor_support',
            '../webkit/gpu/webkit_gpu.gyp:webkit_gpu',
            '../webkit/support/webkit_support.gyp:webkit_storage',
            '../webkit/support/webkit_support.gyp:webkit_support_common',
          ],
        }],
        ['OS == "win" or (toolkit_uses_gtk == 1 and selinux == 0)', {
          'dependencies': [
            '../sandbox/sandbox.gyp:sandbox',
          ],
        }],
        ['enable_webrtc==1', {
          'sources': [
            'renderer/media/mock_media_stream_dependency_factory.cc',
            'renderer/media/mock_media_stream_dependency_factory.h',
            'renderer/media/mock_media_stream_dispatcher.cc',
            'renderer/media/mock_media_stream_dispatcher.h',
            'renderer/media/mock_media_stream_registry.cc',
            'renderer/media/mock_media_stream_registry.h',
            'renderer/media/mock_peer_connection_impl.cc',
            'renderer/media/mock_peer_connection_impl.h',
            'renderer/media/mock_web_rtc_peer_connection_handler_client.cc',
            'renderer/media/mock_web_rtc_peer_connection_handler_client.h',
            'test/webrtc_audio_device_test.cc',
            'test/webrtc_audio_device_test.h',
          ],
          'dependencies': [
            '../third_party/libjingle/libjingle.gyp:libjingle_webrtc',
            '../third_party/libjingle/libjingle.gyp:libpeerconnection',
            '../third_party/webrtc/modules/modules.gyp:audio_device',
            '../third_party/webrtc/modules/modules.gyp:video_capture_module',
          ],
        }],
        ['toolkit_uses_gtk == 1', {
          'dependencies': [
            '../build/linux/system.gyp:gtk',
          ],
        }],
        ['use_glib == 1', {
          'dependencies': [
            '../build/linux/system.gyp:glib',
          ],
        }],
        ['use_aura==1', {
          'dependencies': [
            '../ui/aura/aura.gyp:aura_test_support',
            '../ui/compositor/compositor.gyp:compositor',
          ],
        }],
        ['OS=="win"', {
          'dependencies': [
            '../third_party/iaccessible2/iaccessible2.gyp:iaccessible2',
          ],
        }],
        ['OS!="android" and OS!="ios"', {
          'dependencies': [
            '../third_party/libvpx/libvpx.gyp:libvpx',
          ],
        }],
      ],
    },
    {
      'target_name': 'content_unittests',
      'type': '<(gtest_target_type)',
      'defines!': ['CONTENT_IMPLEMENTATION'],
      'dependencies': [
        'content_common',
        'test_support_content',
        'browser/speech/proto/speech_proto.gyp:speech_proto',
        '../base/base.gyp:test_support_base',
        '../crypto/crypto.gyp:crypto',
        '../media/media.gyp:media_test_support',
        '../net/net.gyp:net_test_support',
        '../skia/skia.gyp:skia',
        '../sql/sql.gyp:sql',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        '../ui/ui.gyp:ui',
        '../webkit/support/webkit_support.gyp:user_agent',
      ],
      'include_dirs': [
        '..',
        '<(SHARED_INTERMEDIATE_DIR)',  # Needed by key_systems_unittest.cc.
      ],
      'sources': [
        'browser/accessibility/browser_accessibility_mac_unittest.mm',
        'browser/accessibility/browser_accessibility_manager_unittest.cc',
        'browser/accessibility/browser_accessibility_win_unittest.cc',
        'browser/appcache/chrome_appcache_service_unittest.cc',
        'browser/browser_thread_unittest.cc',
        'browser/browser_url_handler_impl_unittest.cc',
        'browser/byte_stream_unittest.cc',
        'browser/child_process_security_policy_unittest.cc',
        'browser/devtools/devtools_http_handler_unittest.cc',
        'browser/devtools/devtools_manager_unittest.cc',
        'browser/device_orientation/provider_unittest.cc',
        'browser/download/base_file_unittest.cc',
        'browser/download/download_file_unittest.cc',
        'browser/download/download_id_unittest.cc',
        'browser/download/download_item_impl_unittest.cc',
        'browser/download/download_manager_impl_unittest.cc',
        'browser/download/file_metadata_unittest_linux.cc',
        'browser/download/save_package_unittest.cc',
        'browser/gamepad/gamepad_provider_unittest.cc',
        'browser/gamepad/gamepad_test_helpers.cc',
        'browser/gamepad/gamepad_test_helpers.h',
        'browser/geolocation/device_data_provider_unittest.cc',
        'browser/geolocation/geolocation_provider_unittest.cc',
        'browser/geolocation/gps_location_provider_unittest_linux.cc',
        'browser/geolocation/location_arbitrator_impl_unittest.cc',
        'browser/geolocation/network_location_provider_unittest.cc',
        'browser/geolocation/wifi_data_provider_chromeos_unittest.cc',
        'browser/geolocation/wifi_data_provider_common_unittest.cc',
        'browser/geolocation/wifi_data_provider_linux_unittest.cc',
        'browser/geolocation/wifi_data_provider_unittest_win.cc',
        'browser/geolocation/win7_location_api_unittest_win.cc',
        'browser/geolocation/win7_location_provider_unittest_win.cc',
        'browser/gpu/gpu_blacklist_unittest.cc',
        'browser/gpu/gpu_control_list_entry_unittest.cc',
        'browser/gpu/gpu_control_list_machine_model_info_unittest.cc',
        'browser/gpu/gpu_control_list_number_info_unittest.cc',
        'browser/gpu/gpu_control_list_os_info_unittest.cc',
        'browser/gpu/gpu_control_list_string_info_unittest.cc',
        'browser/gpu/gpu_control_list_unittest.cc',
        'browser/gpu/gpu_control_list_version_info_unittest.cc',
        'browser/gpu/gpu_data_manager_impl_private_unittest.cc',
        'browser/gpu/gpu_driver_bug_list_unittest.cc',
        'browser/gpu/gpu_switching_list_unittest.cc',
        'browser/gpu/gpu_util_unittest.cc',
        'browser/gpu/shader_disk_cache_unittest.cc',
        'browser/host_zoom_map_impl_unittest.cc',
        'browser/hyphenator/hyphenator_message_filter_unittest.cc',
        'browser/in_process_webkit/webkit_thread_unittest.cc',
        'browser/indexed_db/indexed_db_unittest.cc',
        'browser/indexed_db/indexed_db_quota_client_unittest.cc',
        'browser/loader/offline_policy_unittest.cc',
        'browser/loader/resource_buffer_unittest.cc',
        'browser/loader/resource_dispatcher_host_unittest.cc',
        'browser/loader/resource_loader_unittest.cc',
        'browser/loader/resource_scheduler_unittest.cc',
        'browser/mach_broker_mac_unittest.cc',
        'browser/media/media_internals_unittest.cc',
        'browser/net/sqlite_persistent_cookie_store_unittest.cc',
        'browser/notification_service_impl_unittest.cc',
        'browser/plugin_loader_posix_unittest.cc',
        'browser/renderer_host/compositing_iosurface_transformer_mac_unittest.cc',
        'browser/renderer_host/gtk_key_bindings_handler_unittest.cc',
        'browser/renderer_host/media/audio_input_device_manager_unittest.cc',
        'browser/renderer_host/media/audio_mirroring_manager_unittest.cc',
        'browser/renderer_host/media/audio_renderer_host_unittest.cc',
        'browser/renderer_host/media/media_stream_dispatcher_host_unittest.cc',
        'browser/renderer_host/media/media_stream_manager_unittest.cc',
        'browser/renderer_host/media/media_stream_ui_controller_unittest.cc',
        'browser/renderer_host/media/video_capture_buffer_pool_unittest.cc',
        'browser/renderer_host/media/video_capture_controller_unittest.cc',
        'browser/renderer_host/media/video_capture_host_unittest.cc',
        'browser/renderer_host/media/video_capture_manager_unittest.cc',
        'browser/renderer_host/media/web_contents_audio_input_stream_unittest.cc',
        'browser/renderer_host/media/web_contents_video_capture_device_unittest.cc',
        'browser/renderer_host/pepper/browser_ppapi_host_test.cc',
        'browser/renderer_host/pepper/browser_ppapi_host_test.h',
        'browser/renderer_host/pepper/pepper_gamepad_host_unittest.cc',
        'browser/renderer_host/pepper/pepper_printing_host_unittest.cc',
        'browser/renderer_host/render_view_host_unittest.cc',
        'browser/renderer_host/render_widget_host_unittest.cc',
        'browser/renderer_host/render_widget_host_view_aura_unittest.cc',
        'browser/renderer_host/render_widget_host_view_guest_unittest.cc',
        'browser/renderer_host/render_widget_host_view_mac_editcommand_helper_unittest.mm',
        'browser/renderer_host/render_widget_host_view_mac_unittest.mm',
        'browser/renderer_host/smooth_scroll_gesture_controller_unittest.cc',
        'browser/renderer_host/text_input_client_mac_unittest.mm',
        'browser/renderer_host/web_input_event_aura_unittest.cc',
        'browser/resolve_proxy_msg_helper_unittest.cc',
        'browser/site_instance_impl_unittest.cc',
        'browser/speech/chunked_byte_buffer_unittest.cc',
        'browser/speech/endpointer/endpointer_unittest.cc',
        'browser/speech/google_one_shot_remote_engine_unittest.cc',
        'browser/speech/google_streaming_remote_engine_unittest.cc',
        'browser/speech/speech_recognizer_unittest.cc',
        'browser/ssl/ssl_host_state_unittest.cc',
        'browser/storage_partition_impl_unittest.cc',
        'browser/storage_partition_impl_map_unittest.cc',
        'browser/streams/stream_unittest.cc',
        'browser/streams/stream_url_request_job_unittest.cc',
        'browser/system_message_window_win_unittest.cc',
        'browser/tracing/trace_subscriber_stdio_unittest.cc',
        'browser/web_contents/navigation_controller_impl_unittest.cc',
        'browser/web_contents/navigation_entry_impl_unittest.cc',
        'browser/web_contents/render_view_host_manager_unittest.cc',
        'browser/web_contents/web_contents_delegate_unittest.cc',
        'browser/web_contents/web_contents_impl_unittest.cc',
        'browser/web_contents/web_contents_user_data_unittest.cc',
        'browser/web_contents/web_contents_view_mac_unittest.mm',
        'browser/web_contents/web_drag_dest_mac_unittest.mm',
        'browser/web_contents/web_drag_source_mac_unittest.mm',
        'browser/webui/web_ui_data_source_unittest.cc',
        'browser/webui/web_ui_message_handler_unittest.cc',
        'common/android/address_parser_unittest.cc',
        'common/cc_messages_unittest.cc',
        'common/common_param_traits_unittest.cc',
        'common/mac/attributed_string_coder_unittest.mm',
        'common/mac/font_descriptor_unittest.mm',
        'common/gpu/gpu_info_unittest.cc',
        'common/gpu/gpu_memory_manager_unittest.cc',
        'common/indexed_db/indexed_db_dispatcher_unittest.cc',
        'common/indexed_db/proxy_webidbcursor_impl_unittest.cc',
        'common/inter_process_time_ticks_converter_unittest.cc',
        'common/page_zoom_unittest.cc',
        'common/partial_circular_buffer_unittest.cc',
        'common/resource_dispatcher_unittest.cc',
        'common/sandbox_mac_diraccess_unittest.mm',
        'common/sandbox_mac_fontloading_unittest.mm',
        'common/sandbox_mac_unittest_helper.h',
        'common/sandbox_mac_unittest_helper.mm',
        'common/sandbox_mac_system_access_unittest.mm',
        'gpu/gpu_info_collector_unittest.cc',
        'renderer/active_notification_tracker_unittest.cc',
        'renderer/android/email_detector_unittest.cc',
        'renderer/android/phone_number_detector_unittest.cc',
        'renderer/bmp_image_decoder_unittest.cc',
        'renderer/date_time_formatter_unittest.cc',
        'renderer/disambiguation_popup_helper_unittest.cc',
        'renderer/gpu/input_event_filter_unittest.cc',
        'renderer/hyphenator/hyphenator_unittest.cc',
        'renderer/ico_image_decoder_unittest.cc',
        'renderer/media/audio_message_filter_unittest.cc',
        'renderer/media/audio_renderer_mixer_manager_unittest.cc',
        'renderer/media/video_capture_impl_unittest.cc',
        'renderer/media/video_capture_message_filter_unittest.cc',
        'renderer/paint_aggregator_unittest.cc',
        'renderer/pepper/pepper_broker_impl_unittest.cc',
        'renderer/render_thread_impl_unittest.cc',
        'renderer/render_view_impl_unittest.cc',
        'renderer/v8_value_converter_impl_unittest.cc',
        'test/gpu/gpu_test_config_unittest.cc',
        'test/gpu/gpu_test_expectations_parser_unittest.cc',
        'test/image_decoder_test.cc',
        'test/image_decoder_test.h',
        'test/run_all_unittests.cc',
        '../webkit/appcache/manifest_parser_unittest.cc',
        '../webkit/appcache/appcache_unittest.cc',
        '../webkit/appcache/appcache_database_unittest.cc',
        '../webkit/appcache/appcache_group_unittest.cc',
        '../webkit/appcache/appcache_host_unittest.cc',
        '../webkit/appcache/appcache_quota_client_unittest.cc',
        '../webkit/appcache/appcache_request_handler_unittest.cc',
        '../webkit/appcache/appcache_response_unittest.cc',
        '../webkit/appcache/appcache_service_unittest.cc',
        '../webkit/appcache/appcache_storage_unittest.cc',
        '../webkit/appcache/appcache_storage_impl_unittest.cc',
        '../webkit/appcache/appcache_update_job_unittest.cc',
        '../webkit/appcache/appcache_url_request_job_unittest.cc',
        '../webkit/appcache/mock_appcache_policy.h',
        '../webkit/appcache/mock_appcache_policy.cc',
        '../webkit/appcache/mock_appcache_service.cc',
        '../webkit/appcache/mock_appcache_service.h',
        '../webkit/appcache/mock_appcache_storage.cc',
        '../webkit/appcache/mock_appcache_storage.h',
        '../webkit/appcache/mock_appcache_storage_unittest.cc',
        '../webkit/blob/blob_storage_context_unittest.cc',
        '../webkit/blob/blob_storage_controller_unittest.cc',
        '../webkit/blob/blob_url_request_job_unittest.cc',
        '../webkit/blob/local_file_stream_reader_unittest.cc',
        '../webkit/blob/mock_blob_url_request_context.cc',
        '../webkit/blob/mock_blob_url_request_context.h',
        '../webkit/blob/shareable_file_reference_unittest.cc',
        '../webkit/chromeos/fileapi/cros_mount_point_provider_unittest.cc',
        '../webkit/chromeos/fileapi/file_access_permissions_unittest.cc',
        '../webkit/database/database_connections_unittest.cc',
        '../webkit/database/database_quota_client_unittest.cc',
        '../webkit/database/databases_table_unittest.cc',
        '../webkit/database/database_tracker_unittest.cc',
        '../webkit/database/database_util_unittest.cc',
        '../webkit/dom_storage/dom_storage_area_unittest.cc',
        '../webkit/dom_storage/dom_storage_cached_area_unittest.cc',
        '../webkit/dom_storage/dom_storage_context_unittest.cc',
        '../webkit/dom_storage/dom_storage_database_unittest.cc',
        '../webkit/dom_storage/dom_storage_map_unittest.cc',
        '../webkit/dom_storage/session_storage_database_unittest.cc',
        '../webkit/fileapi/async_file_test_helper.cc',
        '../webkit/fileapi/async_file_test_helper.h',
        '../webkit/fileapi/copy_or_move_file_validator_unittest.cc',
        '../webkit/fileapi/external_mount_points_unittest.cc',
        '../webkit/fileapi/file_system_context_unittest.cc',
        '../webkit/fileapi/file_system_database_test_helper.cc',
        '../webkit/fileapi/file_system_database_test_helper.h',
        '../webkit/fileapi/file_system_directory_database_unittest.cc',
        '../webkit/fileapi/file_system_dir_url_request_job_unittest.cc',
        '../webkit/fileapi/file_system_file_stream_reader_unittest.cc',
        '../webkit/fileapi/file_system_mount_point_provider_unittest.cc',
        '../webkit/fileapi/file_system_origin_database_unittest.cc',
        '../webkit/fileapi/file_system_quota_client_unittest.cc',
        '../webkit/fileapi/file_system_url_unittest.cc',
        '../webkit/fileapi/file_system_url_request_job_unittest.cc',
        '../webkit/fileapi/file_system_usage_cache_unittest.cc',
        '../webkit/fileapi/file_system_util_unittest.cc',
        '../webkit/fileapi/file_writer_delegate_unittest.cc',
        '../webkit/fileapi/isolated_context_unittest.cc',
        '../webkit/fileapi/isolated_file_util_unittest.cc',
        '../webkit/fileapi/local_file_system_cross_operation_unittest.cc',
        '../webkit/fileapi/local_file_system_operation_unittest.cc',
        '../webkit/fileapi/local_file_system_operation_write_unittest.cc',
        '../webkit/fileapi/local_file_system_quota_unittest.cc',
        '../webkit/fileapi/local_file_system_test_helper.cc',
        '../webkit/fileapi/local_file_system_test_helper.h',
        '../webkit/fileapi/local_file_stream_writer_unittest.cc',
        '../webkit/fileapi/local_file_util_unittest.cc',
        '../webkit/fileapi/mock_file_change_observer.cc',
        '../webkit/fileapi/mock_file_change_observer.h',
        '../webkit/fileapi/native_file_util_unittest.cc',
        '../webkit/fileapi/obfuscated_file_util_unittest.cc',
        '../webkit/fileapi/sandbox_mount_point_provider_unittest.cc',
        '../webkit/fileapi/syncable/canned_syncable_file_system.cc',
        '../webkit/fileapi/syncable/canned_syncable_file_system.h',
        '../webkit/fileapi/syncable/file_change_unittest.cc',
        '../webkit/fileapi/syncable/local_file_change_tracker_unittest.cc',
        '../webkit/fileapi/syncable/local_file_sync_context_unittest.cc',
        '../webkit/fileapi/syncable/local_file_sync_status_unittest.cc',
        '../webkit/fileapi/syncable/syncable_file_system_unittest.cc',
        '../webkit/fileapi/syncable/syncable_file_system_util_unittest.cc',
        '../webkit/fileapi/syncable/syncable_file_operation_runner_unittest.cc',
        '../webkit/fileapi/test_file_set.cc',
        '../webkit/fileapi/test_file_set.h',
        '../webkit/fileapi/upload_file_system_file_element_reader_unittest.cc',
        '../webkit/fileapi/webfilewriter_base_unittest.cc',
        '../webkit/glue/cpp_variant_unittest.cc',
        '../webkit/glue/glue_serialize_unittest.cc',
        '../webkit/glue/resource_request_body_unittest.cc',
        '../webkit/glue/multipart_response_delegate_unittest.cc',
        '../webkit/glue/touch_fling_gesture_curve_unittest.cc',
        '../webkit/glue/webcursor_unittest.cc',
        '../webkit/glue/webkit_glue_unittest.cc',
        '../webkit/glue/worker_task_runner_unittest.cc',
        '../webkit/media/buffered_data_source_unittest.cc',
        '../webkit/media/buffered_resource_loader_unittest.cc',
        '../webkit/media/cache_util_unittest.cc',
        '../webkit/media/crypto/key_systems_unittest.cc',
        '../webkit/media/test_response_generator.cc',
        '../webkit/media/test_response_generator.h',
        '../webkit/media/webaudiosourceprovider_impl_unittest.cc',
        '../webkit/mocks/mock_weburlloader.cc',
        '../webkit/mocks/mock_weburlloader.h',
        '../webkit/plugins/npapi/plugin_lib_unittest.cc',
        '../webkit/plugins/npapi/plugin_list_unittest.cc',
        '../webkit/plugins/npapi/plugin_utils_unittest.cc',
        '../webkit/plugins/npapi/webplugin_impl_unittest.cc',
        '../webkit/plugins/ppapi/host_var_tracker_unittest.cc',
        '../webkit/plugins/ppapi/mock_platform_image_2d.cc',
        '../webkit/plugins/ppapi/mock_platform_image_2d.h',
        '../webkit/plugins/ppapi/mock_plugin_delegate.cc',
        '../webkit/plugins/ppapi/mock_plugin_delegate.h',
        '../webkit/plugins/ppapi/mock_resource.h',
        '../webkit/plugins/ppapi/ppapi_plugin_instance_unittest.cc',
        '../webkit/plugins/ppapi/ppapi_unittest.cc',
        '../webkit/plugins/ppapi/ppapi_unittest.h',
        '../webkit/plugins/ppapi/quota_file_io_unittest.cc',
        '../webkit/quota/mock_quota_manager.cc',
        '../webkit/quota/mock_quota_manager.h',
        '../webkit/quota/mock_quota_manager_unittest.cc',
        '../webkit/quota/mock_storage_client.cc',
        '../webkit/quota/mock_storage_client.h',
        '../webkit/quota/quota_database_unittest.cc',
        '../webkit/quota/quota_manager_unittest.cc',
        '../webkit/quota/quota_temporary_storage_evictor_unittest.cc',
        '../webkit/quota/usage_tracker_unittest.cc',
        '../webkit/user_agent/user_agent_unittest.cc',
      ],
      'conditions': [
        ['OS == "ios"', {
          'sources/': [
            # iOS only needs a small portion of content; exclude all the
            # implementation, and re-include what is used.
            ['exclude', '\\.(cc|mm)$'],
            ['include', '_ios\\.(cc|mm)$'],
            ['include', '^browser/notification_service_impl_unittest\\.cc$'],
            ['include', '^browser/speech/.*_unittest\\.cc$'],
            ['include', '^browser/web_contents/navigation_entry_impl_unittest\\.cc$'],
            ['include', '^test/run_all_unittests\\.cc$'],
          ],
        }, {  # OS != "ios"
          'dependencies': [
            'content_browser',
            'content_gpu',
            'content_plugin',
            'content_renderer',
            'content_resources.gyp:content_resources',
            '../base/third_party/dynamic_annotations/dynamic_annotations.gyp:dynamic_annotations',
            '../gpu/gpu.gyp:gpu',
            '../gpu/gpu.gyp:gpu_unittest_utils',
            '../ipc/ipc.gyp:test_support_ipc',
            '../jingle/jingle.gyp:jingle_glue_test_util',
            '../media/media.gyp:shared_memory_support',
            '../third_party/icu/icu.gyp:icui18n',
            '../third_party/icu/icu.gyp:icuuc',
            '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
            '../third_party/libjingle/libjingle.gyp:libjingle',
            '<(webkit_src_dir)/Source/WebKit/chromium/WebKit.gyp:webkit',
            '../ui/gl/gl.gyp:gl',
            '../v8/tools/gyp/v8.gyp:v8',
            '../webkit/support/webkit_support.gyp:glue',
            '../webkit/support/webkit_support.gyp:webkit_base',
            '../webkit/support/webkit_support.gyp:webkit_media',
            '../webkit/support/webkit_support.gyp:webkit_storage',
            '../webkit/webkit.gyp:test_shell_test_support',
          ],
        }],
        ['enable_plugins==0', {
          'sources/': [
            ['exclude', '^renderer/pepper/'],
            ['exclude', '^browser/renderer_host/pepper/'],
          ],
          'sources!': [
            'browser/plugin_loader_posix_unittest.cc',
          ],
        }],
        ['enable_webrtc==1', {
          'sources': [
            'browser/media/webrtc_internals_unittest.cc',
            'browser/renderer_host/p2p/socket_host_test_utils.h',
            'browser/renderer_host/p2p/socket_host_tcp_unittest.cc',
            'browser/renderer_host/p2p/socket_host_tcp_server_unittest.cc',
            'browser/renderer_host/p2p/socket_host_udp_unittest.cc',
            'renderer/media/media_stream_dependency_factory_unittest.cc',
            'renderer/media/media_stream_dispatcher_unittest.cc',
            'renderer/media/media_stream_impl_unittest.cc',
            'renderer/media/rtc_peer_connection_handler_unittest.cc',
            'renderer/media/video_destination_handler_unittest.cc',
            'renderer/media/video_source_handler_unittest.cc',
            'renderer/media/webrtc_audio_device_unittest.cc',
            'renderer/media/webrtc_local_audio_track_unittest.cc',
          ],
          'dependencies': [
            '../third_party/libjingle/libjingle.gyp:libjingle_webrtc',
            '../third_party/libjingle/libjingle.gyp:libpeerconnection',
            '../third_party/webrtc/modules/modules.gyp:video_capture_module',
            '../third_party/webrtc/voice_engine/voice_engine.gyp:voice_engine_core',
          ]
        }],
        # TODO(jrg): remove the OS=="android" section?
        # http://crbug.com/113172
        # Understand better how media_stream_ is tied into Chromium.
        ['enable_webrtc==0 and OS=="android"', {
          'sources/': [
            ['exclude', '^renderer/media/media_stream_'],
          ],
        }],
        ['input_speech==0', {
          'sources/': [
            ['exclude', '^browser/speech/'],
          ]
        }],
        ['notifications==0', {
           'sources!': [
             'renderer/active_notification_tracker_unittest.cc',
           ],
        }],
        ['use_x11 == 1', {
          'dependencies': [
            '../build/linux/system.gyp:dbus',
            '../dbus/dbus.gyp:dbus_test_support',
          ],
        }],
        ['OS=="win" and win_use_allocator_shim==1', {
          'dependencies': [
            '../base/allocator/allocator.gyp:allocator',
          ],
        }],
        ['OS=="win"', {
          'dependencies': [
            '../third_party/iaccessible2/iaccessible2.gyp:iaccessible2',
          ],
        }],
        ['OS=="mac"', {
          # These flags are needed to run the test on Mac.
          # Search for comments about "xcode_settings" in chrome_tests.gypi.
          'xcode_settings': {'OTHER_LDFLAGS': ['-Wl,-ObjC']},
        }],
        ['chromeos==1', {
          'sources/': [
            ['exclude', '^browser/renderer_host/gtk_key_bindings_handler_unittest.cc'],
            ['exclude', '^browser/geolocation/wifi_data_provider_linux_unittest.cc'],
          ],
        }],
        ['use_aura==1', {
          'dependencies': [
            '../ui/aura/aura.gyp:aura',
          ],
          'sources!': [
            'browser/accessibility/browser_accessibility_win_unittest.cc',
          ],
        }],
        ['use_aura==1 and OS=="linux"', {
          'sources!': [
            # http://crbug.com/234172: these tests depend on single process
            # mode, which doesn't work in content_browsertests on Linux Aura.
            'renderer/dom_operations_browsertest.cc',
            'renderer/dom_serializer_browsertest.cc',
            'renderer/resource_fetcher_browsertest.cc',
          ],
        }],
        ['OS == "android"', {
          'dependencies': [
            '../ui/ui.gyp:shell_dialogs',
          ],
          'sources!': [
            'browser/geolocation/device_data_provider_unittest.cc',
            'browser/geolocation/gps_location_provider_unittest_linux.cc',
            'browser/geolocation/network_location_provider_unittest.cc',
            'browser/geolocation/wifi_data_provider_chromeos_unittest.cc',
            'browser/geolocation/wifi_data_provider_common_unittest.cc',
            'browser/geolocation/wifi_data_provider_linux_unittest.cc',
          ],
        }],
        ['OS != "android" and OS != "ios"', {
          'dependencies': [
            '../third_party/libvpx/libvpx.gyp:libvpx',
          ],
        }],
        ['OS == "android" and gtest_target_type == "shared_library"', {
          'dependencies': [
            '../testing/android/native_test.gyp:native_test_native_code',
          ],
        }],
      ],
    },
  ],
  'conditions': [
    ['OS!="ios"', {
      'targets': [
        {
          'target_name': 'content_browsertests',
          'type': '<(gtest_target_type)',
          'defines!': ['CONTENT_IMPLEMENTATION'],
          'dependencies': [
            'content_common',
            'content_gpu',
            'content_plugin',
            'content_renderer',
            'content_shell_lib',
            'content_shell_pak',
            'test_support_content',
            '../base/base.gyp:test_support_base',
            '../gpu/gpu.gyp:gpu',
            '../ipc/ipc.gyp:test_support_ipc',
            '../net/net.gyp:net_test_support',
            '../ppapi/ppapi_internal.gyp:ppapi_host',
            '../ppapi/ppapi_internal.gyp:ppapi_proxy',
            '../ppapi/ppapi_internal.gyp:ppapi_ipc',
            '../ppapi/ppapi_internal.gyp:ppapi_shared',
            '../ppapi/ppapi_internal.gyp:ppapi_unittest_shared',
            '../skia/skia.gyp:skia',
            '../testing/gmock.gyp:gmock',
            '../testing/gtest.gyp:gtest',
            '../third_party/mesa/mesa.gyp:osmesa',
            '../third_party/widevine/cdm/widevine_cdm.gyp:widevine_cdm_version_h',
            '../ui/gl/gl.gyp:gl',
            '../ui/snapshot/snapshot.gyp:snapshot',
            '../ui/ui.gyp:shell_dialogs',
            '../ui/ui.gyp:ui',
            '../webkit/support/webkit_support.gyp:clearkeycdmadapter',
            '../webkit/support/webkit_support.gyp:glue',
            '<(webkit_src_dir)/Tools/DumpRenderTree/DumpRenderTree.gyp/DumpRenderTree.gyp:TestRunner_resources',
          ],
          'include_dirs': [
            '..',
            '<(SHARED_INTERMEDIATE_DIR)',  # Needed by encrypted_media_browsertest.cc
          ],
          'includes': [
            'browser/gpu/test_support_gpu.gypi',
          ],
          'defines': [
            'HAS_OUT_OF_PROC_TEST_RUNNER',
          ],
          'sources': [
            'browser/accessibility/accessibility_win_browsertest.cc',
            'browser/accessibility/cross_platform_accessibility_browsertest.cc',
            'browser/accessibility/dump_accessibility_tree_browsertest.cc',
            'browser/appcache/appcache_browsertest.cc',
            'browser/bookmarklet_browsertest.cc',
            'browser/browser_plugin/browser_plugin_host_browsertest.cc',
            'browser/browser_plugin/test_browser_plugin_embedder.cc',
            'browser/browser_plugin/test_browser_plugin_embedder.h',
            'browser/browser_plugin/test_browser_plugin_guest.cc',
            'browser/browser_plugin/test_browser_plugin_guest.h',
            'browser/browser_plugin/test_browser_plugin_guest_manager.cc',
            'browser/browser_plugin/test_browser_plugin_guest_manager.h',
            'browser/child_process_security_policy_browsertest.cc',
            'browser/database_browsertest.cc',
            'browser/device_orientation/device_orientation_browsertest.cc',
            'browser/dom_storage/dom_storage_browsertest.cc',
            'browser/download/download_browsertest.cc',
            'browser/download/drag_download_file_browsertest.cc',
            'browser/download/mhtml_generation_browsertest.cc',
            'browser/download/save_package_browsertest.cc',
            'browser/fileapi/blob_layout_browsertest.cc',
            'browser/fileapi/file_system_browsertest.cc',
            'browser/gpu/gpu_crash_browsertest.cc',
            'browser/gpu/gpu_functional_browsertest.cc',
            'browser/gpu/gpu_memory_test.cc',
            'browser/gpu/gpu_pixel_browsertest.cc',
            'browser/gpu/webgl_conformance_test.cc',
            'browser/gpu/webgl_conformance_test_list_autogen.h',
            'browser/in_process_webkit/indexed_db_browsertest.cc',
            'browser/indexed_db/indexed_db_layout_browsertest.cc',
            'browser/loader/resource_dispatcher_host_browsertest.cc',
            'browser/media/audio_browsertest.cc',
            'browser/media/encrypted_media_browsertest.cc',
            'browser/media/media_browsertest.cc',
            'browser/media/webrtc_internals_browsertest.cc',
            'browser/plugin_data_remover_impl_browsertest.cc',
            'browser/plugin_browsertest.cc',
            'browser/plugin_service_impl_browsertest.cc',
            'browser/renderer_host/clipboard_browsertest.cc',
            'browser/renderer_host/render_view_host_browsertest.cc',
            'browser/renderer_host/render_view_host_manager_browsertest.cc',
            'browser/renderer_host/render_widget_host_browsertest.cc',
            'browser/renderer_host/render_widget_host_view_browsertest.cc',
            'browser/renderer_host/render_widget_host_view_win_browsertest.cc',
            'browser/security_exploit_browsertest.cc',
            'browser/session_history_browsertest.cc',
            'browser/site_per_process_browsertest.cc',
            'browser/speech/speech_recognition_browsertest.cc',
            'browser/web_contents/touch_editable_impl_aura_browsertest.cc',
            'browser/web_contents/web_contents_impl_browsertest.cc',
            'browser/web_contents/web_contents_view_aura_browsertest.cc',
            'browser/webkit_browsertest.cc',
            'browser/worker_host/test/worker_browsertest.cc',
            'renderer/accessibility/renderer_accessibility_browsertest.cc',
            'renderer/browser_plugin/mock_browser_plugin.h',
            'renderer/browser_plugin/mock_browser_plugin.cc',
            'renderer/browser_plugin/mock_browser_plugin_manager.h',
            'renderer/browser_plugin/mock_browser_plugin_manager.cc',
            'renderer/browser_plugin/browser_plugin_browsertest.h',
            'renderer/browser_plugin/browser_plugin_browsertest.cc',
            'renderer/cpp_bound_class_unittest.cc',
            'renderer/dom_operations_browsertest.cc',
            'renderer/dom_serializer_browsertest.cc',
            'renderer/mouse_lock_dispatcher_browsertest.cc',
            'renderer/password_form_conversion_utils_browsertest.cc',
            'renderer/pepper/mock_renderer_ppapi_host.cc',
            'renderer/pepper/pepper_device_enumeration_host_helper_unittest.cc',
            'renderer/pepper/pepper_file_chooser_host_unittest.cc',
            'renderer/pepper/pepper_graphics_2d_host_unittest.cc',
            'renderer/pepper/pepper_url_request_unittest.cc',
            'renderer/render_thread_impl_browsertest.cc',
            'renderer/render_view_browsertest.cc',
            'renderer/render_view_browsertest_mac.mm',
            'renderer/render_widget_browsertest.cc',
            'renderer/resource_fetcher_browsertest.cc',
            'test/browser_test_message_pump_android.cc',
            'test/browser_test_message_pump_android.h',
            'test/content_browser_test.h',
            'test/content_browser_test.cc',
            'test/content_browser_test_utils.cc',
            'test/content_browser_test_utils.h',
            'test/content_browser_test_utils_mac.mm',
            'test/content_browser_test_test.cc',
            'test/content_test_launcher.cc',
            'test/layout_browsertest.cc',
            'test/layout_browsertest.h',
            'test/layout_test_http_server.cc',
            'test/layout_test_http_server.h',
            '../webkit/glue/cpp_binding_example.cc',
            '../webkit/glue/cpp_binding_example.h',
            '../webkit/plugins/ppapi/mock_platform_image_2d.cc',
            '../webkit/plugins/ppapi/mock_platform_image_2d.h',
            '../webkit/plugins/ppapi/mock_plugin_delegate.cc',
            '../webkit/plugins/ppapi/mock_plugin_delegate.h',
          ],
          'conditions': [
            ['chromeos==0', {
              'sources!': [
                'browser/web_contents/touch_editable_impl_aura_browsertest.cc',
              ],
            }],
            ['OS=="win"', {
              'resource_include_dirs': [
                '<(SHARED_INTERMEDIATE_DIR)/webkit',
              ],
              'sources': [
                'shell/resource.h',
                'shell/shell.rc',
                # TODO:  It would be nice to have these pulled in
                # automatically from direct_dependent_settings in
                # their various targets (net.gyp:net_resources, etc.),
                # but that causes errors in other targets when
                # resulting .res files get referenced multiple times.
                '<(SHARED_INTERMEDIATE_DIR)/net/net_resources.rc',
                '<(SHARED_INTERMEDIATE_DIR)/webkit/webkit_chromium_resources.rc',
                '<(SHARED_INTERMEDIATE_DIR)/webkit/webkit_strings_en-US.rc',
              ],
              'dependencies': [
                '<(DEPTH)/net/net.gyp:net_resources',
                '<(DEPTH)/third_party/iaccessible2/iaccessible2.gyp:iaccessible2',
                '<(DEPTH)/third_party/isimpledom/isimpledom.gyp:isimpledom',
                '<(DEPTH)/webkit/support/webkit_support.gyp:webkit_resources',
                '<(DEPTH)/webkit/support/webkit_support.gyp:webkit_strings',
              ],
              'configurations': {
                'Debug_Base': {
                  'msvs_settings': {
                    'VCLinkerTool': {
                      'LinkIncremental': '<(msvs_large_module_debug_link_mode)',
                    },
                  },
                },
              },
              # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
              'msvs_disabled_warnings': [ 4267, ],
            }, {  # OS!="win"
              'sources!': [
                'browser/accessibility/accessibility_win_browsertest.cc',
                'browser/renderer_host/render_widget_host_view_win_browsertest.cc',
              ],
            }],
            ['OS=="win" and win_use_allocator_shim==1', {
              'dependencies': [
                '../base/allocator/allocator.gyp:allocator',
              ],
            }],
            ['OS=="linux"', {
              'sources!': [
                'browser/accessibility/dump_accessibility_tree_browsertest.cc',
              ],
            }],
            ['OS=="android"', {
              'sources!': [
                'browser/accessibility/dump_accessibility_tree_browsertest.cc',
              ],
              'sources': [
                'shell/android/browsertests_apk/content_browser_tests_android.cc',
              ],
              'dependencies': [
                'content_shell_jni_headers',
                'content_shell_lib',
                '../testing/android/native_test.gyp:native_test_util',
              ],
            }],
            ['OS=="mac"', {
              'dependencies': [
                'content_shell',  # Needed for Content Shell.app's Helper.
              ],
              'sources': [
                'renderer/external_popup_menu_browsertest.cc',
              ],
            }],
            ['use_aura==1', {
              'sources!': [
                'browser/accessibility/accessibility_win_browsertest.cc',
                'browser/accessibility/dump_accessibility_tree_browsertest.cc',
                'browser/plugin_browsertest.cc',
              ],
            }],
            ['OS!="android" and OS!="ios"', {
              # npapi test plugin doesn't build on android or ios
              'dependencies': [
                # Runtime dependencies
                '../webkit/webkit.gyp:copy_npapi_test_plugin',
                '../webkit/webkit.gyp:pull_in_copy_TestNetscapePlugIn',
              ],
            }],
            ['enable_webrtc==1', {
              'sources': [
                'browser/media/webrtc_browsertest.cc',
              ],
            }],
            ['enable_plugins==0', {
              'sources!': [
                'browser/plugin_service_impl_browsertest.cc',
                'browser/plugin_data_remover_impl_browsertest.cc',
                'renderer/pepper/pepper_device_enumeration_host_helper_unittest.cc',
                'renderer/pepper/pepper_file_chooser_host_unittest.cc',
                'renderer/pepper/pepper_graphics_2d_host_unittest.cc',
              ],
            }],
            ['input_speech==0', {
              'sources/': [
                ['exclude', '^browser/speech/'],
              ]
            }],
          ],
        },
      ],
    }],
    ['chromeos==1 or OS=="win"', {
      # TODO(felipeg): Make video_decode_accelerator_unittest work on Android.
      # http://crbug.com/178647
      'targets': [
          {
            'target_name': 'video_decode_accelerator_unittest',
            'type': 'executable',
            'dependencies': [
              'content',
              '../base/base.gyp:base',
              '../testing/gtest.gyp:gtest',
              '../media/media.gyp:media',
              '../ui/gl/gl.gyp:gl',
              '../ui/ui.gyp:ui',
            ],
            'include_dirs': [
              '<(DEPTH)/third_party/angle/include',
            ],
            'sources': [
              'common/gpu/media/rendering_helper.h',
              'common/gpu/media/rendering_helper_gl.cc',
              'common/gpu/media/video_decode_accelerator_unittest.cc',
            ],
            'conditions': [
              ['target_arch=="arm"', {
                'include_dirs': [
                  '<(DEPTH)/third_party/openmax/il',
                ],
              }],
              ['OS=="win"', {
                'dependencies': [
                  '../third_party/angle/src/build_angle.gyp:libEGL',
                  '../third_party/angle/src/build_angle.gyp:libGLESv2',
                ],
              }],
              ['(OS=="win" and win_use_allocator_shim==1) or '
               '(os_posix == 1 and OS != "android" and '
               ' linux_use_tcmalloc==1)', {
                'dependencies': [
                  '../base/allocator/allocator.gyp:allocator',
                ],
              }],
              ['target_arch != "arm" and (OS=="linux" or chromeos == 1)', {
                'include_dirs': [
                  '<(DEPTH)/third_party/libva',
                ],
              }],
            ],
            # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
            'msvs_disabled_warnings': [ 4267, ],
          },
        ]
    }],
    ['chromeos == 1 or OS == "linux"', {
      'targets': [
        {
          'target_name': 'h264_parser_unittest',
          'type': 'executable',
          'dependencies': [
            'content_common',
            '../base/base.gyp:base',
            '../testing/gtest.gyp:gtest',
          ],
          'sources': [
            'common/gpu/media/h264_bit_reader_unittest.cc',
            'common/gpu/media/h264_parser_unittest.cc',
          ],
          'conditions': [
            ['linux_use_tcmalloc==1', {
              'dependencies': [
                '../base/allocator/allocator.gyp:allocator',
              ],
            }],
          ],
        }
      ],
    }],
    # Special target to wrap a gtest_target_type==shared_library
    # content_unittests into an android apk for execution.
    # See base.gyp for TODO(jrg)s about this strategy.
    ['OS == "android" and gtest_target_type == "shared_library"', {
      'targets': [
        {
          'target_name': 'content_unittests_apk',
          'type': 'none',
          'dependencies': [
            'content_java',
            'content_unittests',
          ],
          'variables': {
            'test_suite_name': 'content_unittests',
            'input_shlib_path': '<(SHARED_LIB_DIR)/<(SHARED_LIB_PREFIX)content_unittests<(SHARED_LIB_SUFFIX)',
          },
          'includes': [ '../build/apk_test.gypi' ],
        },
        {
          'target_name': 'content_browsertests_apk',
          'type': 'none',
          'dependencies': [
            'content_browsertests',
            'content_java',
            'content_shell_java',
          ],
          'variables': {
            'apk_name': 'content_browsertests',
            'java_in_dir': 'shell/android/browsertests_apk',
            'resource_dir': 'shell/android/browsertests_apk/res',
            'native_lib_target': 'libcontent_browsertests',
            'additional_input_paths': ['<(PRODUCT_DIR)/content_shell/assets/content_shell.pak'],
            'asset_location': '<(ant_build_out)/content_shell/assets',
          },
          'includes': [ '../build/java_apk.gypi' ],
        },
      ],
    }],
    ['OS == "android"', {
      'targets': [
        {
          'target_name': 'content_java_test_support',
          'type': 'none',
          'dependencies': [
            '../base/base.gyp:base',
            '../base/base.gyp:base_java_test_support',
            'content_common',
            'content_java',
          ],
          'variables': {
            'java_in_dir': '../content/public/test/android/javatests',
          },
          'includes': [ '../build/java.gypi' ],
        },
        {
          'target_name': 'content_shell_test_apk',
          'type': 'none',
          'dependencies': [
            'content_java',
            'content_java_test_support',
            'content_shell_apk_java',
            '../base/base.gyp:base_java',
            '../base/base.gyp:base_javatests',
            '../base/base.gyp:base_java_test_support',
            '../media/media.gyp:media_java',
            '../media/media.gyp:media_test_support',
            '../net/net.gyp:net_java',
            '../net/net.gyp:net_javatests',
            '../tools/android/forwarder2/forwarder.gyp:forwarder2',
          ],
          'variables': {
            'apk_name': 'ContentShellTest',
            'java_in_dir': 'shell/android/javatests',
            'resource_dir': 'shell/android/shell_apk/res',
            'additional_src_dirs': ['public/android/javatests/',],
            'is_test_apk': 1,
          },
          'includes': [ '../build/java_apk.gypi' ],
        },
      ],
    }],
  ],
}
