// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/safe_browsing/local_safebrowsing_test_server.h"

#include "base/command_line.h"
#include "base/path_service.h"
#include "base/strings/string_number_conversions.h"
#include "base/values.h"
#include "net/test/python_utils.h"
#include "net/test/spawned_test_server.h"

LocalSafeBrowsingTestServer::LocalSafeBrowsingTestServer(
    const base::FilePath& data_file)
    : net::LocalTestServer(net::SpawnedTestServer::TYPE_HTTP,
                           net::SpawnedTestServer::kLocalhost,
                           base::FilePath()),
      data_file_(data_file) {
}

LocalSafeBrowsingTestServer::~LocalSafeBrowsingTestServer() {}

bool LocalSafeBrowsingTestServer::GetTestServerPath(
    base::FilePath* testserver_path) const {
  base::FilePath testserver_dir;
  if (!PathService::Get(base::DIR_SOURCE_ROOT, &testserver_dir)) {
    LOG(ERROR) << "Failed to get DIR_SOURCE_ROOT";
    return false;
  }

  testserver_dir = testserver_dir
      .Append(FILE_PATH_LITERAL("chrome"))
      .Append(FILE_PATH_LITERAL("browser"))
      .Append(FILE_PATH_LITERAL("safe_browsing"));

  *testserver_path = testserver_dir.Append(FILE_PATH_LITERAL(
      "safe_browsing_testserver.py"));
  return true;
}

bool LocalSafeBrowsingTestServer::SetPythonPath() const {
  if (!net::LocalTestServer::SetPythonPath())
    return false;

  // Locate the Python code generated by the protocol buffers compiler.
  base::FilePath pyproto_dir;
  if (!GetPyProtoPath(&pyproto_dir)) {
    LOG(ERROR) << "Cannot find pyproto dir for generated code.";
    return false;
  }

  AppendToPythonPath(pyproto_dir.AppendASCII("google"));
  return true;
}

bool LocalSafeBrowsingTestServer::GenerateAdditionalArguments(
    base::DictionaryValue* arguments) const {
  arguments->SetString("data-file", data_file_.value());
  return true;
}
