// Chip's Workshop - a level editor for Chip's Challenge.
// Copyright 2008-2009 Christopher Elsby <glarbex@glarbex.com>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of version 2 of the GNU General Public License as
// published by the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "global.h"

#include "levelpropertiesdlg.h"
#include "level.h"
#include <string>
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/valtext.h>
#include <wx/button.h>

namespace ChipW {

BEGIN_EVENT_TABLE(LevelPropertiesDialog, wxDialog)
    EVT_BUTTON(-1, LevelPropertiesDialog::OnCommand)
END_EVENT_TABLE()

enum {
    ID_RANDPSW = wxID_HIGHEST + 1,
};

LevelPropertiesDialog::LevelPropertiesDialog(wxWindow* parent, bool readonly)
 : wxDialog(parent, -1, wxT("Level properties"), wxDefaultPosition, wxDefaultSize), pswbox(NULL)
{
    long style = readonly ? wxTE_READONLY : 0;
    wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);
    wxFlexGridSizer* settingsizer = new wxFlexGridSizer(2);
    settingsizer->Add(new wxStaticText(this, -1, wxT("Title:")), 0, wxALL | wxALIGN_RIGHT, 5);
    settingsizer->Add(new wxTextCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, style,
        wxTextValidator(wxFILTER_NONE, &title)), 0, wxALL | wxGROW, 5);
    if(readonly) {
        settingsizer->Add(new wxStaticText(this, -1, wxT("Password:")), 0, wxALL | wxALIGN_RIGHT, 5);
    } else {
        settingsizer->Add(new wxButton(this, ID_RANDPSW, wxT("Password:"), wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT),
            0, wxALL | wxALIGN_RIGHT, 5);
    }
    settingsizer->Add(pswbox = new wxTextCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, style,
        wxTextValidator(wxFILTER_NONE, &psw)), 0, wxALL | wxGROW, 5);
    settingsizer->Add(new wxStaticText(this, -1, wxT("Chips required:")), 0, wxALL | wxALIGN_RIGHT, 5);
    settingsizer->Add(new wxTextCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, style,
        wxTextValidator(wxFILTER_NUMERIC, &chips)), 0, wxALL | wxGROW, 5);
    settingsizer->Add(new wxStaticText(this, -1, wxT("Chips in level:")), 0, wxALL | wxALIGN_RIGHT, 5);
    settingsizer->Add(new wxTextCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxTE_READONLY,
        wxTextValidator(wxFILTER_NUMERIC, &countedchips)), 0, wxALL | wxGROW, 5);
    settingsizer->Add(new wxStaticText(this, -1, wxT("Time limit:")), 0, wxALL | wxALIGN_RIGHT, 5);
    settingsizer->Add(new wxTextCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, style,
        wxTextValidator(wxFILTER_NUMERIC, &time)), 0, wxALL | wxGROW, 5);
    settingsizer->Add(new wxStaticText(this, -1, wxT("Hint:")), 0, wxALL | wxALIGN_RIGHT, 5);
    settingsizer->Add(new wxTextCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, style,
        wxTextValidator(wxFILTER_NONE, &hint)), 0, wxALL | wxGROW, 5);
    settingsizer->AddGrowableCol(1);
    sizer->Add(settingsizer, 0, wxGROW);
    sizer->Add(new wxStaticText(this, -1, wxT("Advanced tinkering - do not change the following unless you know what you are doing!")),
        0, wxALL, 5);
    wxFlexGridSizer* tinkersizer = new wxFlexGridSizer(2);
    tinkersizer->Add(new wxStaticText(this, -1, wxT("Internal level number:")), 0, wxALL | wxALIGN_RIGHT, 5);
    tinkersizer->Add(new wxTextCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, style,
        wxTextValidator(wxFILTER_NUMERIC, &levnum)), 0, wxALL | wxGROW, 5);
    tinkersizer->Add(new wxStaticText(this, -1, wxT("Magic number:")), 0, wxALL | wxALIGN_RIGHT, 5);
    tinkersizer->Add(new wxTextCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, style,
        wxTextValidator(wxFILTER_NUMERIC, &magic)), 0, wxALL | wxGROW, 5);
    tinkersizer->AddGrowableCol(1);
    sizer->Add(tinkersizer, 0, wxGROW);
    wxBoxSizer* buttonsizer = new wxBoxSizer(wxHORIZONTAL);
    wxButton* okbutton = new wxButton(this, wxID_OK, wxT("&OK"));
    okbutton->SetDefault();
    buttonsizer->Add(okbutton, 0, wxALL, 5);
    buttonsizer->Add(new wxButton(this, wxID_CANCEL, wxT("&Cancel")), 0, wxALL, 5);
    sizer->Add(buttonsizer);
    SetSizerAndFit(sizer);
}

#if !wxCHECK_VERSION(2, 8, 0)
#define ChangeValue SetValue
#endif

void LevelPropertiesDialog::OnCommand(wxCommandEvent& event) {
    switch(event.GetId()) {
    case ID_RANDPSW:
        if(pswbox != NULL) {
            std::string randpsw = Level::RandPsw();
            pswbox->ChangeValue(wxString(randpsw.c_str(), wxConvUTF8));
        }
        break;
    default:
        event.Skip();
    }
}

}
