// Chip's Workshop - a level editor for Chip's Challenge.
// Copyright 2008-2009 Christopher Elsby <glarbex@glarbex.com>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of version 2 of the GNU General Public License as
// published by the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "global.h"

#include "app.h"
#include "levelsetdoc.h"
#include "leveleditview.h"
#include "leveleditframe.h"
#include "apppaths.h"
#include <wx/app.h>
#include <wx/docview.h>
#include <wx/string.h>
#include <wx/image.h>
#include <wx/msgdlg.h>
//#include <wx/choicdlg.h>
#include <wx/cmdline.h>
#include <wx/confbase.h>
#include <cstdlib>
#include <ctime>

IMPLEMENT_APP(ChipW::App)

namespace ChipW {

long RefCounted::nextid = 0;

BEGIN_EVENT_TABLE(App, wxApp)
    EVT_MENU(-1, App::OnCommand)
    EVT_BUTTON(-1, App::OnCommand)
END_EVENT_TABLE()

App::App()
 : docmgr(NULL), autostart(false)
{
}

bool App::OnInit() {
    SetAppName(wxT("ChipW"));
    SetVendorName(wxT("Glarbex"));
    std::srand(std::time(NULL));
    wxInitAllImageHandlers();
    docmgr = new wxDocManager;
    new wxDocTemplate(docmgr, wxT("Level set"), wxT("*.ccl;*.dat"), wxT(""), wxT("ccl"), wxT("Level set"), wxT("Level editor"),
        CLASSINFO(LevelSetDoc), CLASSINFO(LevelEditView));
    if(!wxApp::OnInit())
        return false;
    if(!autostart) {
#if 0
        wxString choices[2];
        choices[0] = wxT("Create a new levelset");
        choices[1] = wxT("Open an existing levelset");
        int choice = wxGetSingleChoiceIndex(wxT("Welcome to Chip's Workshop! What would you like to do?"), wxT("Chip's Workshop"), 2, choices);
        switch(choice) {
        case 0:
            docmgr->CreateDocument(wxEmptyString, wxDOC_NEW);
            break;
        case 1:
            docmgr->CreateDocument(wxEmptyString, 0);
            break;
        }
#endif
        LevelEditFrame* frame = new LevelEditFrame(docmgr);
        frame->Show();
    }
//    return !docmgr->GetDocuments().empty();
    return true;
}

void App::OnInitCmdLine(wxCmdLineParser& parser) {
    wxApp::OnInitCmdLine(parser);
    parser.SetLogo(wxT("Chip's Workshop " VERSION " Copyright 2008 Christopher Elsby\nCompiled with ") wxVERSION_STRING);
    parser.AddSwitch(wxT("v"), wxT("version"), wxT("show the version number and copyright notice"));
    parser.AddParam(wxT("file"), wxCMD_LINE_VAL_STRING, wxCMD_LINE_PARAM_OPTIONAL | wxCMD_LINE_PARAM_MULTIPLE);
}

bool App::OnCmdLineParsed(wxCmdLineParser& parser) {
    if(!wxApp::OnCmdLineParsed(parser))
        return false;
    if(parser.Found(wxT("v")))
    {
        wxFprintf(stderr, wxT("Chip's Workshop %s Copyright 2008-2009 Christopher Elsby\n"
            "Compiled with %s\n"), wxT(VERSION), wxVERSION_STRING);
        return false;
    }
    autostart = (parser.GetParamCount() > 0);
    if(docmgr != NULL) {
        for(size_t n = 0; n < parser.GetParamCount(); ++n)
            docmgr->CreateDocument(parser.GetParam(n), wxDOC_SILENT);
    }
    return true;
}

int App::OnExit() {
    delete docmgr;
    docmgr = NULL;
    delete wxConfigBase::Set(NULL);
    return 0;
}

void App::OnCommand(wxCommandEvent& event) {
    switch(event.GetId()) {
    case wxID_ABOUT:
        wxMessageBox(
            wxT("Chip's Workshop " VERSION "\nCopyright 2008-2009 Christopher Elsby\nCompiled on " __DATE__ " " __TIME__ ".\n"
            "Compiled against ") wxVERSION_STRING wxT(".\n"
            "Tile images by Anders Kaseorg and Michael Hansen.\n"
            "This program is free software; you can redistribute it and/or modify it "
            "under the terms of version 2 of the GNU General Public License "
            "as published by the Free Software Foundation.\n"
            "This program is distributed in the hope that it will be useful, "
            "but WITHOUT ANY WARRANTY; without even the implied warranty of "
            "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE."
        ), wxT("About Chip's Workshop"), wxOK);
        break;
    case wxID_HELP_CONTENTS:
        if(!wxLaunchDefaultBrowser(wxT("file://") + GetDocDir() + wxT("/chipw.html")
#if wxCHECK_VERSION(2, 8, 0)
        , wxBROWSER_NEW_WINDOW
#endif
        ))
            wxMessageBox(wxT("Please see chipw.html for help."), wxT("Chip's Workshop Help"), wxOK);
        break;
    default:
        event.Skip();
    }
}

}

