/*
 * This file is part of the chinese-calendar project
 * Copyright (C) 2013 National University of Defense Technology(NUDT) & Kylin Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * This project is developed by "UbuntuKylin Members" team,
 * see <https://launchpad.net/~ubuntukylin~members>
 * Authors: Abel Liu <guiltyritter@gmail.com>
 *                 Shine Huang <hostc@163.com>
 */

#include <QtGui>
#include <QCoreApplication>
#include <QTranslator>
#include <QTextCodec>
#include <QDesktopWidget>
#include "chinesecalendar.h"

//ChineseCalendar *window = 0;


int main(int argc, char *argv[])
{
    QTextCodec::setCodecForTr(QTextCodec::codecForName("UTF-8"));
    QTextCodec::setCodecForCStrings(QTextCodec::codecForName("UTF-8"));
    QApplication app(argc, argv);
    QTranslator translator;

    translator.load(":/translate/i18_zh_CN.qm");
    app.installTranslator(&translator);

    ChineseCalendar *window = new ChineseCalendar;
    app.setWindowIcon(window->icon);
    window->setWindowFlags(Qt::FramelessWindowHint);

    QDesktopWidget desktop;
    int width = desktop.screenGeometry().width();
    int height = desktop.screenGeometry().height();
    window->setGeometry(QRect(width/2-260,height/2-175,520,350));

    window->show();
    return app.exec();
}
