#!/usr/bin/env python
#
#     Copyright (C) 2002 Stas Z <stas@linux.isbeter.nl>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

# Script to install additional modules to the score thing in childsplay
import sys,pickle,os
#SCOREFILE = '/var/games/childsplay.score'
def bail_out(info):
    print >> sys.stderr, "Problems with script, bail out","\n",info
    print "Please send a bug report to:"
    print "childsplay@sourceforge.net"
    sys.exit(1)

#print sys.argv
if len(sys.argv) == 3:
    destdir = sys.argv[1]
    plugs = sys.argv[2]
    plugs = plugs.split(',')
else:
    bail_out("Not enough arguments")

file = os.path.join(destdir,'childsplay.score')
#file = SCOREFILE
if not os.path.exists(file):
    bail_out("Can't find %s" % file)

try:
    fp = open(file,'r')
    sheet = pickle.load(fp)
    fp.close()
except (IOError,EOFError),info:
    bail_out(info)

templ = []
for name in ['Tux','Linus','Guido','RMS','Dijkstra']:
    templ.append(((100,name)))
    templ.sort()

for name in plugs:
    print name
    sheet[name.capitalize()] = templ[:]
try:
    fp = open(file,'w')
    pickle.dump(sheet,fp)
    fp.close()
except IOError,info:
    bail_out(info)
