/* Generated from posixunix.scm by the CHICKEN compiler
   http://www.call-with-current-continuation.org
   2009-09-21 21:28
   Version 4.0.1 - SVN rev. 14292
   linux-unix-gnu-x86 [ manyargs dload ptables applyhook ]
   compiled 2009-05-12 on galinha (Linux)
   command line: posixunix.scm -no-trace -optimize-level 2 -include-path . -include-path ./ -explicit-use -unsafe -no-lambda-info -output-file uposixunix.c
   unit: posix
*/

#include "chicken.h"

#include <signal.h>
#include <errno.h>
#include <math.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

static C_TLS int C_wait_status;

#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>

#if defined(__sun__) && defined(__svr4__)
# include <sys/tty.h>
#endif

#ifdef HAVE_GRP_H
#include <grp.h>
#endif

#include <sys/mman.h>
#include <time.h>

#ifndef O_FSYNC
# define O_FSYNC O_SYNC
#endif

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef O_BINARY
# define O_BINARY        0
#endif
#ifndef O_TEXT
# define O_TEXT          0
#endif

#ifndef ARG_MAX
# define ARG_MAX 256
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANON
# define MAP_ANON    0
#endif

#if defined(HAVE_CRT_EXTERNS_H)
# include <crt_externs.h>
# define C_getenventry(i)       ((*_NSGetEnviron())[ i ])
#elif defined(C_MACOSX)
# define C_getenventry(i)       NULL
#else
extern char **environ;
# define C_getenventry(i)       (environ[ i ])
#endif

#ifndef ENV_MAX
# define ENV_MAX        1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct utsname C_utsname;
static C_TLS struct flock C_flock;
static C_TLS DIR *temphandle;
static C_TLS struct passwd *C_user;
#ifdef HAVE_GRP_H
static C_TLS struct group *C_group;
#else
static C_TLS struct {
  char *gr_name, gr_passwd;
  int gr_gid;
  char *gr_mem[ 1 ];
} C_group = { "", "", 0, { "" } };
#endif
static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS fd_set C_fd_sets[ 2 ];
static C_TLS struct timeval C_timeval;
static C_TLS char C_hostbuf[ 256 ];
static C_TLS struct stat C_statbuf;

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXU | S_IRWXG | S_IRWXO))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#define C_opendir(x,h)          C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)           (closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)          C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)        (strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)       (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_fork              fork
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getpid            getpid
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_setgid(id)        C_fix(setgid(C_unfix(id)))
#define C_seteuid(id)       C_fix(seteuid(C_unfix(id)))
#define C_setegid(id)       C_fix(setegid(C_unfix(id)))
#define C_setsid(dummy)     C_fix(setsid())
#define C_setpgid(x, y)     C_fix(setpgid(C_unfix(x), C_unfix(y)))
#define C_getpgid(x)        C_fix(getpgid(C_unfix(x)))
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#ifdef HAVE_GRP_H
#define C_getgrnam(n)       C_mk_bool((C_group = getgrnam((char *)C_data_pointer(n))) != NULL)
#define C_getgrgid(u)       C_mk_bool((C_group = getgrgid(C_unfix(u))) != NULL)
#else
#define C_getgrnam(n)       C_SCHEME_FALSE
#define C_getgrgid(n)       C_SCHEME_FALSE
#endif
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#define C_uname             C_fix(uname(&C_utsname))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_alarm             alarm
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_close(fd)         C_fix(close(C_unfix(fd)))
#define C_sleep             sleep

#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_lstat(fn)         C_fix(lstat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#define C_islink            ((C_statbuf.st_mode & S_IFMT) == S_IFLNK)
#define C_isreg             ((C_statbuf.st_mode & S_IFMT) == S_IFREG)
#define C_isdir             ((C_statbuf.st_mode & S_IFMT) == S_IFDIR)
#define C_ischr             ((C_statbuf.st_mode & S_IFMT) == S_IFCHR)
#define C_isblk             ((C_statbuf.st_mode & S_IFMT) == S_IFBLK)
#define C_isfifo            ((C_statbuf.st_mode & S_IFMT) == S_IFIFO)
#ifdef S_IFSOCK
#define C_issock            ((C_statbuf.st_mode & S_IFMT) == S_IFSOCK)
#else
#define C_issock            ((C_statbuf.st_mode & S_IFMT) == 0140000)
#endif

#ifdef C_GNU_ENV
# define C_unsetenv(s)      (unsetenv((char *)C_data_pointer(s)), C_SCHEME_TRUE)
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
# define C_unsetenv(s)      C_fix(putenv((char *)C_data_pointer(s)))
static C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_data_pointer(x),
       *sy = C_data_pointer(y);
  int n1 = C_strlen(sx), n2 = C_strlen(sy);
  char *buf = (char *)C_malloc(n1 + n2 + 2);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strcpy(buf, sx);
    buf[ n1 ] = '=';
    C_strcpy(buf + n1 + 1, sy);
    return(C_fix(putenv(buf)));
  }
}
#endif

static void C_fcall C_set_arg_string(char **where, int i, char *a, int len) {
  char *ptr;
  if(a != NULL) {
    ptr = (char *)C_malloc(len + 1);
    C_memcpy(ptr, a, len);
    ptr[ len ] = '\0';
  }
  else ptr = NULL;
  where[ i ] = ptr;
}

static void C_fcall C_free_arg_string(char **where) {
  while((*where) != NULL) C_free(*(where++));
}

static void C_set_timeval(C_word num, struct timeval *tm)
{
  if((num & C_FIXNUM_BIT) != 0) {
    tm->tv_sec = C_unfix(num);
    tm->tv_usec = 0;
  }
  else {
    double i;
    tm->tv_usec = (int)(modf(C_flonum_magnitude(num), &i) * 1000000);
    tm->tv_sec = (int)i;
  }
}

#define C_set_exec_arg(i, a, len)	C_set_arg_string(C_exec_args, i, a, len)
#define C_free_exec_args()		C_free_arg_string(C_exec_args)
#define C_set_exec_env(i, a, len)	C_set_arg_string(C_exec_env, i, a, len)
#define C_free_exec_env()		C_free_arg_string(C_exec_env)

#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))
#define C_execve(f)         C_fix(execve(C_data_pointer(f), C_exec_args, C_exec_env))

#if defined(__FreeBSD__) || defined(C_MACOSX) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__sgi__) || defined(sgi) || defined(__DragonFly__) || defined(__SUNPRO_C)
static C_TLS int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))
#define C_flock_lockw(p)    C_fix(fcntl(fileno(C_port_file(p)), F_SETLKW, &C_flock))

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static C_TLS sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigdelset(s)      (sigdelset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigismember(s)    C_mk_bool(sigismember(&C_sigset, C_unfix(s)))
#define C_sigprocmask_set(d)        C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))
#define C_sigprocmask_block(d)      C_fix(sigprocmask(SIG_BLOCK, &C_sigset, NULL))
#define C_sigprocmask_unblock(d)    C_fix(sigprocmask(SIG_UNBLOCK, &C_sigset, NULL))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)        C_fix(mkstemp(C_c_string(t)))

#define C_ftell(p)            C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)      C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_zero_fd_set(i)      FD_ZERO(&C_fd_sets[ i ])
#define C_set_fd_set(i, fd)   FD_SET(fd, &C_fd_sets[ i ])
#define C_test_fd_set(i, fd)  FD_ISSET(fd, &C_fd_sets[ i ])
#define C_C_select(m)         C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, NULL))
#define C_C_select_t(m, t)    (C_set_timeval(t, &C_timeval), \
			       C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, &C_timeval)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if defined(__SVR4)
/* Seen here: http://lists.samba.org/archive/samba-technical/2002-November/025571.html */

static time_t timegm(struct tm *t)
{
  time_t tl, tb;
  struct tm *tg;

  tl = mktime (t);
  if (tl == -1)
    {
      t->tm_hour--;
      tl = mktime (t);
      if (tl == -1)
        return -1; /* can't deal with output from strptime */
      tl += 3600;
    }
  tg = gmtime (&tl);
  tg->tm_isdst = 0;
  tb = mktime (tg);
  if (tb == -1)
    {
      tg->tm_hour--;
      tb = mktime (tg);
      if (tb == -1)
        return -1; /* can't deal with output from gmtime */
      tb += 3600;
    }
  return (tl - (tb - tl));
}
#endif

#define cpy_tmvec_to_tmstc08(ptm, v) \
    (memset((ptm), 0, sizeof(struct tm)), \
    (ptm)->tm_sec = C_unfix(C_block_item((v), 0)), \
    (ptm)->tm_min = C_unfix(C_block_item((v), 1)), \
    (ptm)->tm_hour = C_unfix(C_block_item((v), 2)), \
    (ptm)->tm_mday = C_unfix(C_block_item((v), 3)), \
    (ptm)->tm_mon = C_unfix(C_block_item((v), 4)), \
    (ptm)->tm_year = C_unfix(C_block_item((v), 5)), \
    (ptm)->tm_wday = C_unfix(C_block_item((v), 6)), \
    (ptm)->tm_yday = C_unfix(C_block_item((v), 7)), \
    (ptm)->tm_isdst = (C_block_item((v), 8) != C_SCHEME_FALSE))

#define cpy_tmvec_to_tmstc9(ptm, v) \
    (((struct tm *)ptm)->tm_gmtoff = C_unfix(C_block_item((v), 9)))

#define cpy_tmstc08_to_tmvec(v, ptm) \
    (C_set_block_item((v), 0, C_fix(((struct tm *)ptm)->tm_sec)), \
    C_set_block_item((v), 1, C_fix((ptm)->tm_min)), \
    C_set_block_item((v), 2, C_fix((ptm)->tm_hour)), \
    C_set_block_item((v), 3, C_fix((ptm)->tm_mday)), \
    C_set_block_item((v), 4, C_fix((ptm)->tm_mon)), \
    C_set_block_item((v), 5, C_fix((ptm)->tm_year)), \
    C_set_block_item((v), 6, C_fix((ptm)->tm_wday)), \
    C_set_block_item((v), 7, C_fix((ptm)->tm_yday)), \
    C_set_block_item((v), 8, ((ptm)->tm_isdst ? C_SCHEME_TRUE : C_SCHEME_FALSE)))

#define cpy_tmstc9_to_tmvec(v, ptm) \
    (C_set_block_item((v), 9, C_fix((ptm)->tm_gmtoff)))

#define C_tm_set_08(v)  cpy_tmvec_to_tmstc08( &C_tm, (v) )
#define C_tm_set_9(v)   cpy_tmvec_to_tmstc9( &C_tm, (v) )

#define C_tm_get_08(v)  cpy_tmstc08_to_tmvec( (v), &C_tm )
#define C_tm_get_9(v)   cpy_tmstc9_to_tmvec( (v), &C_tm )

#if !defined(C_GNU_ENV) || defined(__CYGWIN__) || defined(__uClinux__)

static struct tm *
C_tm_set( C_word v )
{
  C_tm_set_08( v );
  return &C_tm;
}

static C_word
C_tm_get( C_word v )
{
  C_tm_get_08( v );
  return v;
}

#else

static struct tm *
C_tm_set( C_word v )
{
  C_tm_set_08( v );
  C_tm_set_9( v );
  return &C_tm;
}

static C_word
C_tm_get( C_word v )
{
  C_tm_get_08( v );
  C_tm_get_9( v );
  return v;
}

#endif

#define C_asctime(v)    (asctime(C_tm_set(v)))
#define C_mktime(v)     ((C_temporary_flonum = mktime(C_tm_set(v))) != -1)
#define C_timegm(v)     ((C_temporary_flonum = timegm(C_tm_set(v))) != -1)

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

#define C_strftime(v, f) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set(v)) ? C_time_string : NULL)

#define C_strptime(s, f, v) \
        (strptime(C_c_string(s), C_c_string(f), &C_tm) ? C_tm_get(v) : C_SCHEME_FALSE)

static gid_t *C_groups = NULL;

#define C_get_gid(n)      C_fix(C_groups[ C_unfix(n) ])
#define C_set_gid(n, id)  (C_groups[ C_unfix(n) ] = C_unfix(id), C_SCHEME_UNDEFINED)
#define C_set_groups(n)   C_fix(setgroups(C_unfix(n), C_groups))

#ifdef TIOCGWINSZ
static int get_tty_size(int p, int *rows, int *cols)
{
 struct winsize tty_size;
 int r;

 memset(&tty_size, 0, sizeof tty_size);

 r = ioctl(p, TIOCGWINSZ, &tty_size);
 if (r == 0) {
    *rows = tty_size.ws_row;
    *cols = tty_size.ws_col;
 }
 return r;
}
#else
static int get_tty_size(int p, int *rows, int *cols)
{
 *rows = *cols = 0;
 return -1;
}
#endif


static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_regex_toplevel)
C_externimport void C_ccall C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_utils_toplevel)
C_externimport void C_ccall C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_files_toplevel)
C_externimport void C_ccall C_files_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_ports_toplevel)
C_externimport void C_ccall C_ports_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[466];
static double C_possibly_force_alignment;


/* from k8978 in set-root-directory! in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub3185(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub3185(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_r=C_fix((C_word)chroot(t0));
return C_r;}

/* from sleep in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub2733(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub2733(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_sleep(t0));
return C_r;}

/* from parent-process-id in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub2728(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub2728(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

/* from current-process-id in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub2724(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub2724(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from freeenv */
static C_word C_fcall stub2568(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub2568(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_env();
return C_r;}

/* from k7945 */
static C_word C_fcall stub2559(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub2559(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from freeargs */
static C_word C_fcall stub2553(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub2553(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k7937 */
static C_word C_fcall stub2544(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub2544(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from f_7922 in k7916 in process-fork in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub2530(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub2530(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from fork */
static C_word C_fcall stub2512(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub2512(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

/* from getit */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub2426(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub2426(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) return(NULL);else return(C_hostbuf);
C_ret:
#undef return

return C_r;}

/* from k7737 */
static C_word C_fcall stub2397(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub2397(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int *t1=(int *)C_c_pointer_nn(C_a1);
int *t2=(int *)C_c_pointer_nn(C_a2);
C_r=C_fix((C_word)get_tty_size(t0,t1,t2));
return C_r;}

/* from ttyname */
static C_word C_fcall stub2382(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub2382(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

/* from set-alarm! in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub2333(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub2333(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

/* from ex0 */
static C_word C_fcall stub2324(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub2324(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from local-timezone-abbreviation in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub2316(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub2316(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;

#if !defined(__CYGWIN__) && !defined(__SVR4) && !defined(__uClinux__) && !defined(__hpux__)
time_t clock = (time_t)0;struct tm *ltm = C_localtime(&clock);char *z = ltm ? (char *)ltm->tm_zone : 0;
#else
char *z = (daylight ? tzname[1] : tzname[0]);
#endif
return(z);
C_ret:
#undef return

return C_r;}

/* from strptime */
static C_word C_fcall stub2277(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub2277(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_word t2=(C_word )(C_a2);
C_r=((C_word)C_strptime(t0,t1,t2));
return C_r;}

/* from strftime */
static C_word C_fcall stub2235(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub2235(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1));
return C_r;}

/* from asctime */
static C_word C_fcall stub2227(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub2227(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from ctime */
static C_word C_fcall stub2211(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub2211(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k7324 */
static C_word C_fcall stub2164(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub2164(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k7266 */
static C_word C_fcall stub2125(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5) C_regparm;
C_regparm static C_word C_fcall stub2125(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
int t4=(int )C_unfix(C_a4);
int t5=(int )C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from get */
static C_word C_fcall stub2076(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub2076(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k5958 in k5954 in file-link in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub1489(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub1489(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
C_r=C_fix((C_word)link(t0,t1));
return C_r;}

/* from k5672 in initialize-groups in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub1293(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub1293(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)initgroups(t0,t1));
return C_r;}

/* from _ensure-groups in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
static C_word C_fcall stub1234(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1234(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
if(C_groups != NULL) C_free(C_groups);C_groups = (gid_t *)C_malloc(sizeof(gid_t) * n);if(C_groups == NULL) return(0);else return(1);
C_ret:
#undef return

return C_r;}

/* from _get-groups */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1228(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1228(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
return(getgroups(n, C_groups));
C_ret:
#undef return

return C_r;}

/* from group-member */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1186(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1186(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
return(C_group->gr_mem[ i ]);
C_ret:
#undef return

return C_r;}

/* from a9045 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub1134(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1134(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

/* from a9063 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub1125(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1125(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

/* from a9081 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub1116(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1116(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

/* from a9099 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub1107(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1107(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

/* from fd_test in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub252(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub252(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mk_bool(C_test_fd_set(t0,t1));
return C_r;}

/* from fd_set in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub245(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub245(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_set_fd_set(t0,t1);
return C_r;}

/* from fd_zero in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall stub239(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub239(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_zero_fd_set(t0);
return C_r;}

/* from fcntl */
static C_word C_fcall stub124(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub124(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
long t2=(long )C_num_to_long(C_a2);
C_r=C_fix((C_word)fcntl(t0,t1,t2));
return C_r;}

/* from ##sys#file-select-one in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub46(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub46(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
fd_set in;struct timeval tm;FD_ZERO(&in);FD_SET(fd, &in);tm.tv_sec = tm.tv_usec = 0;if(select(fd + 1, &in, NULL, NULL, &tm) == -1) return(-1);else return(FD_ISSET(fd, &in) ? 1 : 0);
C_ret:
#undef return

return C_r;}

/* from ##sys#file-nonblocking! in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
static C_word C_fcall stub40(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub40(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
int val = fcntl(fd, F_GETFL, 0);if(val == -1) return(0);return(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1);
C_ret:
#undef return

return C_r;}

/* from strerror */
static C_word C_fcall stub23(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub23(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3455)
static void C_ccall f_3455(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3458)
static void C_ccall f_3458(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3461)
static void C_ccall f_3461(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3464)
static void C_ccall f_3464(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3467)
static void C_ccall f_3467(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3470)
static void C_ccall f_3470(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3473)
static void C_ccall f_3473(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9124)
static void C_ccall f_9124(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9140)
static void C_ccall f_9140(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9128)
static void C_ccall f_9128(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9131)
static void C_ccall f_9131(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4180)
static void C_ccall f_4180(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5186)
static void C_ccall f_5186(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9118)
static void C_ccall f_9118(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5321)
static void C_ccall f_5321(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9103)
static void C_ccall f_9103(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9113)
static void C_ccall f_9113(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9100)
static void C_ccall f_9100(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5363)
static void C_ccall f_5363(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9085)
static void C_ccall f_9085(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9095)
static void C_ccall f_9095(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9082)
static void C_ccall f_9082(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5367)
static void C_ccall f_5367(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9067)
static void C_ccall f_9067(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9077)
static void C_ccall f_9077(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9064)
static void C_ccall f_9064(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5371)
static void C_ccall f_5371(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9049)
static void C_ccall f_9049(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9059)
static void C_ccall f_9059(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9046)
static void C_ccall f_9046(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5375)
static void C_ccall f_5375(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9025)
static void C_ccall f_9025(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_9041)
static void C_ccall f_9041(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9007)
static void C_ccall f_9007(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9020)
static void C_ccall f_9020(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_9014)
static void C_ccall f_9014(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5858)
static void C_ccall f_5858(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5897)
static void C_ccall f_5897(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8984)
static void C_ccall f_8984(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8980)
static void C_ccall f_8980(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8732)
static void C_ccall f_8732(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_8732)
static void C_ccall f_8732r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_8909)
static void C_fcall f_8909(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8915)
static void C_ccall f_8915(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8904)
static void C_fcall f_8904(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8899)
static void C_fcall f_8899(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8734)
static void C_fcall f_8734(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_8886)
static void C_ccall f_8886(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_8894)
static void C_ccall f_8894(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_8741)
static void C_fcall f_8741(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8874)
static void C_ccall f_8874(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8868)
static void C_ccall f_8868(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8751)
static void C_ccall f_8751(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8753)
static void C_fcall f_8753(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8772)
static void C_ccall f_8772(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8854)
static void C_ccall f_8854(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8861)
static void C_ccall f_8861(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8848)
static void C_ccall f_8848(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8787)
static void C_ccall f_8787(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8841)
static void C_ccall f_8841(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8838)
static void C_ccall f_8838(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8828)
static void C_ccall f_8828(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8804)
static void C_ccall f_8804(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8826)
static void C_ccall f_8826(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8812)
static void C_ccall f_8812(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8819)
static void C_ccall f_8819(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8816)
static void C_ccall f_8816(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8799)
static void C_ccall f_8799(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8797)
static void C_ccall f_8797(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8875)
static void C_ccall f_8875(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8675)
static void C_ccall f_8675(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_8675)
static void C_ccall f_8675r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_8687)
static void C_fcall f_8687(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8682)
static void C_fcall f_8682(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8677)
static void C_fcall f_8677(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8618)
static void C_ccall f_8618(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_8618)
static void C_ccall f_8618r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_8630)
static void C_fcall f_8630(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8625)
static void C_fcall f_8625(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8620)
static void C_fcall f_8620(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8557)
static void C_fcall f_8557(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_8612)
static void C_ccall f_8612(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8616)
static void C_ccall f_8616(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8578)
static void C_ccall f_8578(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8581)
static void C_ccall f_8581(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8592)
static void C_ccall f_8592(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_8586)
static void C_ccall f_8586(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8559)
static void C_fcall f_8559(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8568)
static void C_ccall f_8568(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8499)
static void C_ccall f_8499(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8) C_noret;
C_noret_decl(f_8511)
static void C_ccall f_8511(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_8542)
static void C_ccall f_8542(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8522)
static void C_ccall f_8522(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8538)
static void C_ccall f_8538(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8526)
static void C_ccall f_8526(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8534)
static void C_ccall f_8534(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8530)
static void C_ccall f_8530(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8505)
static void C_ccall f_8505(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8488)
static void C_fcall f_8488(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_8492)
static void C_ccall f_8492(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8477)
static void C_fcall f_8477(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_8481)
static void C_ccall f_8481(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8432)
static void C_fcall f_8432(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_8436)
static void C_ccall f_8436(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8439)
static void C_ccall f_8439(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8442)
static void C_ccall f_8442(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8455)
static void C_ccall f_8455(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8459)
static void C_ccall f_8459(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8462)
static void C_ccall f_8462(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8465)
static void C_ccall f_8465(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8453)
static void C_ccall f_8453(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8416)
static C_word C_fcall f_8416(C_word *a,C_word t0);
C_noret_decl(f_8399)
static void C_fcall f_8399(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_8412)
static void C_ccall f_8412(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8324)
static void C_ccall f_8324(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8385)
static void C_fcall f_8385(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8398)
static void C_ccall f_8398(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8365)
static void C_fcall f_8365(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8380)
static void C_ccall f_8380(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8374)
static void C_ccall f_8374(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8328)
static void C_fcall f_8328(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_8330)
static void C_ccall f_8330(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8351)
static void C_ccall f_8351(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_8345)
static void C_ccall f_8345(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8272)
static void C_ccall f_8272(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_8272)
static void C_ccall f_8272r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_8279)
static void C_ccall f_8279(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8298)
static void C_ccall f_8298(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8302)
static void C_ccall f_8302(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8266)
static void C_ccall f_8266(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8257)
static void C_ccall f_8257(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8261)
static void C_ccall f_8261(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8230)
static void C_ccall f_8230(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_8230)
static void C_ccall f_8230r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_8227)
static void C_ccall f_8227(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8224)
static void C_ccall f_8224(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8221)
static void C_ccall f_8221(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8146)
static void C_ccall f_8146(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_8146)
static void C_ccall f_8146r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_8179)
static void C_ccall f_8179(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_8173)
static void C_ccall f_8173(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8129)
static void C_ccall f_8129(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7950)
static void C_ccall f_7950(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7950)
static void C_ccall f_7950r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_8084)
static void C_fcall f_8084(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8079)
static void C_fcall f_8079(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7952)
static void C_fcall f_7952(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7962)
static void C_ccall f_7962(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7970)
static void C_fcall f_7970(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8016)
static C_word C_fcall f_8016(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_7983)
static void C_fcall f_7983(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8008)
static void C_ccall f_8008(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7986)
static void C_ccall f_7986(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7942)
static C_word C_fcall f_7942(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_7934)
static C_word C_fcall f_7934(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_7896)
static void C_ccall f_7896(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_7896)
static void C_ccall f_7896r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_7918)
static void C_ccall f_7918(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7922)
static void C_ccall f_7922(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7787)
static void C_ccall f_7787(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_7787)
static void C_ccall f_7787r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_7793)
static void C_fcall f_7793(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7814)
static void C_ccall f_7814(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_7888)
static void C_ccall f_7888(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7818)
static void C_ccall f_7818(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7821)
static void C_ccall f_7821(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7828)
static void C_ccall f_7828(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7830)
static void C_fcall f_7830(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7847)
static void C_ccall f_7847(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7857)
static void C_ccall f_7857(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7861)
static void C_ccall f_7861(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7808)
static void C_ccall f_7808(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7775)
static void C_ccall f_7775(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7779)
static void C_ccall f_7779(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7782)
static void C_ccall f_7782(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7740)
static void C_ccall f_7740(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7744)
static void C_ccall f_7744(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7764)
static void C_ccall f_7764(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7768)
static void C_ccall f_7768(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7721)
static void C_ccall f_7721(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7725)
static void C_ccall f_7725(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7694)
static void C_fcall f_7694(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7698)
static void C_ccall f_7698(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7675)
static void C_ccall f_7675(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7679)
static void C_ccall f_7679(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7682)
static void C_ccall f_7682(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7616)
static void C_ccall f_7616(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_7616)
static void C_ccall f_7616r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_7620)
static void C_ccall f_7620(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7626)
static void C_ccall f_7626(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7613)
static void C_ccall f_7613(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7597)
static void C_ccall f_7597(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_7597)
static void C_ccall f_7597r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_7589)
static void C_ccall f_7589(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7574)
static void C_ccall f_7574(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7578)
static void C_ccall f_7578(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7559)
static void C_ccall f_7559(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7563)
static void C_ccall f_7563(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7520)
static void C_ccall f_7520(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7520)
static void C_ccall f_7520r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7537)
static void C_ccall f_7537(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7541)
static void C_ccall f_7541(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7458)
static void C_ccall f_7458(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7458)
static void C_ccall f_7458r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7465)
static void C_ccall f_7465(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7487)
static void C_ccall f_7487(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7484)
static void C_ccall f_7484(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7474)
static void C_ccall f_7474(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7422)
static void C_ccall f_7422(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7429)
static void C_ccall f_7429(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7408)
static void C_ccall f_7408(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7399)
static void C_ccall f_7399(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7380)
static void C_fcall f_7380(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7374)
static void C_ccall f_7374(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7365)
static void C_ccall f_7365(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7330)
static void C_ccall f_7330(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7330)
static void C_ccall f_7330r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7272)
static void C_ccall f_7272(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...) C_noret;
C_noret_decl(f_7272)
static void C_ccall f_7272r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t8) C_noret;
C_noret_decl(f_7276)
static void C_ccall f_7276(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7282)
static void C_ccall f_7282(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7301)
static void C_ccall f_7301(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7288)
static void C_ccall f_7288(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7188)
static void C_ccall f_7188(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7194)
static void C_fcall f_7194(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7198)
static void C_ccall f_7198(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7206)
static void C_fcall f_7206(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7232)
static void C_ccall f_7232(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7236)
static void C_ccall f_7236(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7224)
static void C_ccall f_7224(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7173)
static void C_ccall f_7173(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7181)
static void C_ccall f_7181(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7156)
static void C_ccall f_7156(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7167)
static void C_ccall f_7167(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7171)
static void C_ccall f_7171(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7130)
static void C_ccall f_7130(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7154)
static void C_ccall f_7154(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7137)
static void C_ccall f_7137(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7087)
static void C_ccall f_7087(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7087)
static void C_ccall f_7087r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7094)
static void C_fcall f_7094(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7115)
static void C_ccall f_7115(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7111)
static void C_ccall f_7111(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7059)
static void C_ccall f_7059(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7037)
static void C_ccall f_7037(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7037)
static void C_ccall f_7037r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7041)
static void C_ccall f_7041(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7022)
static void C_ccall f_7022(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7022)
static void C_ccall f_7022r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7026)
static void C_ccall f_7026(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7007)
static void C_ccall f_7007(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7007)
static void C_ccall f_7007r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7011)
static void C_ccall f_7011(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6989)
static void C_fcall f_6989(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6918)
static void C_fcall f_6918(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6937)
static void C_ccall f_6937(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6943)
static void C_fcall f_6943(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6879)
static void C_ccall f_6879(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6907)
static void C_ccall f_6907(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6903)
static void C_ccall f_6903(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6896)
static void C_ccall f_6896(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6623)
static void C_ccall f_6623(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_6623)
static void C_ccall f_6623r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_6819)
static void C_fcall f_6819(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6814)
static void C_fcall f_6814(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6809)
static void C_fcall f_6809(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6625)
static void C_fcall f_6625(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6629)
static void C_ccall f_6629(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6735)
static void C_ccall f_6735(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6736)
static void C_ccall f_6736(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6753)
static void C_fcall f_6753(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6763)
static void C_ccall f_6763(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6721)
static void C_ccall f_6721(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6677)
static void C_fcall f_6677(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6713)
static void C_ccall f_6713(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6692)
static void C_ccall f_6692(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6702)
static void C_ccall f_6702(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6686)
static void C_ccall f_6686(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6681)
static void C_ccall f_6681(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6684)
static void C_ccall f_6684(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6631)
static void C_fcall f_6631(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6666)
static void C_ccall f_6666(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6647)
static void C_ccall f_6647(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6144)
static void C_ccall f_6144(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_6144)
static void C_ccall f_6144r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_6548)
static void C_fcall f_6548(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6543)
static void C_fcall f_6543(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6538)
static void C_fcall f_6538(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6533)
static void C_fcall f_6533(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6146)
static void C_fcall f_6146(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_6150)
static void C_ccall f_6150(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6156)
static void C_ccall f_6156(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6406)
static void C_ccall f_6406(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6412)
static void C_fcall f_6412(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6508)
static void C_ccall f_6508(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6498)
static void C_ccall f_6498(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6492)
static void C_ccall f_6492(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6414)
static void C_ccall f_6414(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6464)
static void C_ccall f_6464(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6421)
static void C_ccall f_6421(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6431)
static void C_ccall f_6431(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6330)
static void C_ccall f_6330(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_6338)
static void C_fcall f_6338(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6340)
static void C_fcall f_6340(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6388)
static void C_ccall f_6388(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6321)
static void C_ccall f_6321(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6325)
static void C_ccall f_6325(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6300)
static void C_ccall f_6300(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6310)
static void C_ccall f_6310(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6288)
static void C_ccall f_6288(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6275)
static void C_ccall f_6275(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6279)
static void C_ccall f_6279(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6270)
static void C_ccall f_6270(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6273)
static void C_ccall f_6273(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6188)
static void C_fcall f_6188(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6200)
static void C_fcall f_6200(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6237)
static void C_ccall f_6237(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6246)
static void C_ccall f_6246(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6240)
static void C_ccall f_6240(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6216)
static void C_ccall f_6216(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6219)
static void C_ccall f_6219(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6180)
static C_word C_fcall f_6180(C_word t0);
C_noret_decl(f_6157)
static void C_fcall f_6157(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6161)
static void C_ccall f_6161(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6117)
static void C_ccall f_6117(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6117)
static void C_ccall f_6117r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6124)
static void C_fcall f_6124(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6127)
static void C_ccall f_6127(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6072)
static void C_ccall f_6072(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6076)
static void C_ccall f_6076(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6111)
static void C_ccall f_6111(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6094)
static void C_ccall f_6094(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6058)
static void C_ccall f_6058(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6058)
static void C_ccall f_6058r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6070)
static void C_ccall f_6070(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6044)
static void C_ccall f_6044(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6044)
static void C_ccall f_6044r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6056)
static void C_ccall f_6056(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6029)
static void C_fcall f_6029(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6042)
static void C_ccall f_6042(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5992)
static void C_fcall f_5992(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6000)
static void C_ccall f_6000(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5967)
static void C_ccall f_5967(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5956)
static void C_ccall f_5956(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5960)
static void C_ccall f_5960(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5898)
static void C_ccall f_5898(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5898)
static void C_ccall f_5898r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5937)
static void C_ccall f_5937(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5909)
static void C_ccall f_5909(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5912)
static void C_ccall f_5912(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5915)
static void C_ccall f_5915(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5921)
static void C_ccall f_5921(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5860)
static void C_ccall f_5860(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5893)
static void C_ccall f_5893(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5881)
static void C_ccall f_5881(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5889)
static void C_ccall f_5889(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5885)
static void C_ccall f_5885(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5841)
static void C_ccall f_5841(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5851)
static void C_ccall f_5851(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5845)
static void C_ccall f_5845(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5835)
static void C_ccall f_5835(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5829)
static void C_ccall f_5829(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5823)
static void C_ccall f_5823(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5799)
static void C_fcall f_5799(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5821)
static void C_ccall f_5821(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5817)
static void C_ccall f_5817(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5809)
static void C_ccall f_5809(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5769)
static void C_ccall f_5769(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5797)
static void C_ccall f_5797(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5793)
static void C_ccall f_5793(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5742)
static void C_ccall f_5742(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5767)
static void C_ccall f_5767(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5763)
static void C_ccall f_5763(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5678)
static void C_ccall f_5678(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5674)
static void C_ccall f_5674(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5694)
static void C_ccall f_5694(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5612)
static void C_ccall f_5612(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5616)
static void C_ccall f_5616(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5621)
static void C_fcall f_5621(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5637)
static void C_ccall f_5637(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5549)
static void C_ccall f_5549(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5607)
static void C_ccall f_5607(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5553)
static void C_ccall f_5553(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5556)
static void C_ccall f_5556(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5588)
static void C_ccall f_5588(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5559)
static void C_ccall f_5559(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5564)
static void C_fcall f_5564(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5578)
static void C_ccall f_5578(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5546)
static C_word C_fcall f_5546(C_word t0);
C_noret_decl(f_5471)
static void C_ccall f_5471(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5471)
static void C_ccall f_5471r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5529)
static void C_ccall f_5529(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5478)
static void C_fcall f_5478(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5488)
static void C_ccall f_5488(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5492)
static void C_ccall f_5492(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5501)
static void C_fcall f_5501(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5505)
static void C_ccall f_5505(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5515)
static void C_ccall f_5515(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5496)
static void C_ccall f_5496(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5451)
static void C_ccall f_5451(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5463)
static void C_ccall f_5463(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5459)
static void C_ccall f_5459(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5437)
static void C_ccall f_5437(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5449)
static void C_ccall f_5449(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5445)
static void C_ccall f_5445(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5377)
static void C_ccall f_5377(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5377)
static void C_ccall f_5377r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5423)
static void C_ccall f_5423(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5384)
static void C_fcall f_5384(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5394)
static void C_ccall f_5394(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5398)
static void C_ccall f_5398(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5402)
static void C_ccall f_5402(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5406)
static void C_ccall f_5406(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5410)
static void C_ccall f_5410(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5323)
static void C_ccall f_5323(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5356)
static void C_ccall f_5356(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5327)
static void C_ccall f_5327(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5334)
static void C_ccall f_5334(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5338)
static void C_ccall f_5338(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5342)
static void C_ccall f_5342(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5346)
static void C_ccall f_5346(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5350)
static void C_ccall f_5350(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5305)
static void C_ccall f_5305(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5290)
static void C_ccall f_5290(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5284)
static void C_ccall f_5284(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5252)
static void C_ccall f_5252(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5258)
static void C_fcall f_5258(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5228)
static void C_ccall f_5228(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5246)
static void C_ccall f_5246(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5235)
static void C_ccall f_5235(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5210)
static void C_ccall f_5210(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5220)
static void C_ccall f_5220(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5197)
static void C_ccall f_5197(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5188)
static void C_ccall f_5188(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5141)
static void C_ccall f_5141(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5145)
static void C_ccall f_5145(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5121)
static void C_ccall f_5121(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5121)
static void C_ccall f_5121r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5125)
static void C_ccall f_5125(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5131)
static void C_ccall f_5131(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5131)
static void C_ccall f_5131r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5135)
static void C_ccall f_5135(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5101)
static void C_ccall f_5101(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5101)
static void C_ccall f_5101r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5105)
static void C_ccall f_5105(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5111)
static void C_ccall f_5111(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5111)
static void C_ccall f_5111r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5115)
static void C_ccall f_5115(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5077)
static void C_ccall f_5077(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5077)
static void C_ccall f_5077r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5081)
static void C_ccall f_5081(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5092)
static void C_ccall f_5092(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5092)
static void C_ccall f_5092r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5096)
static void C_ccall f_5096(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5086)
static void C_ccall f_5086(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5053)
static void C_ccall f_5053(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5053)
static void C_ccall f_5053r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5057)
static void C_ccall f_5057(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5068)
static void C_ccall f_5068(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5068)
static void C_ccall f_5068r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5072)
static void C_ccall f_5072(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5062)
static void C_ccall f_5062(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5037)
static void C_ccall f_5037(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5041)
static void C_ccall f_5041(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5044)
static void C_ccall f_5044(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5001)
static void C_ccall f_5001(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5001)
static void C_ccall f_5001r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5032)
static void C_ccall f_5032(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5022)
static void C_ccall f_5022(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5015)
static void C_ccall f_5015(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4965)
static void C_ccall f_4965(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4965)
static void C_ccall f_4965r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4996)
static void C_ccall f_4996(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4986)
static void C_ccall f_4986(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4979)
static void C_ccall f_4979(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4950)
static void C_fcall f_4950(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4963)
static void C_ccall f_4963(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4944)
static void C_fcall f_4944(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4932)
static C_word C_fcall f_4932(C_word t0);
C_noret_decl(f_4615)
static void C_ccall f_4615(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4922)
static void C_ccall f_4922(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4742)
static void C_fcall f_4742(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4908)
static void C_ccall f_4908(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4897)
static void C_ccall f_4897(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4904)
static void C_ccall f_4904(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4761)
static void C_fcall f_4761(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4890)
static void C_ccall f_4890(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4869)
static void C_ccall f_4869(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4886)
static void C_ccall f_4886(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4875)
static void C_ccall f_4875(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4882)
static void C_ccall f_4882(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4805)
static void C_fcall f_4805(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4866)
static void C_ccall f_4866(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4845)
static void C_ccall f_4845(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4862)
static void C_ccall f_4862(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4851)
static void C_ccall f_4851(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4858)
static void C_ccall f_4858(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4818)
static void C_ccall f_4818(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4842)
static void C_ccall f_4842(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4838)
static void C_ccall f_4838(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4799)
static void C_ccall f_4799(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4768)
static void C_ccall f_4768(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4786)
static void C_ccall f_4786(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4771)
static void C_ccall f_4771(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4775)
static void C_ccall f_4775(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4755)
static void C_ccall f_4755(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4736)
static void C_ccall f_4736(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4622)
static void C_ccall f_4622(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4629)
static void C_ccall f_4629(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4631)
static void C_fcall f_4631(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4638)
static void C_ccall f_4638(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4702)
static void C_ccall f_4702(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4711)
static void C_ccall f_4711(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4699)
static void C_fcall f_4699(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4644)
static void C_ccall f_4644(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4680)
static void C_ccall f_4680(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4676)
static void C_ccall f_4676(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4672)
static void C_ccall f_4672(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4661)
static void C_ccall f_4661(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4657)
static void C_ccall f_4657(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4559)
static void C_fcall f_4559(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4568)
static void C_ccall f_4568(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4592)
static void C_ccall f_4592(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4604)
static void C_ccall f_4604(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4604)
static void C_ccall f_4604r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4610)
static void C_ccall f_4610(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4598)
static void C_ccall f_4598(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4574)
static void C_ccall f_4574(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4580)
static void C_ccall f_4580(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4566)
static void C_ccall f_4566(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4548)
static C_word C_fcall f_4548(C_word t0);
C_noret_decl(f_4543)
static void C_fcall f_4543(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4502)
static void C_ccall f_4502(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4502)
static void C_ccall f_4502r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4515)
static void C_ccall f_4515(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4479)
static void C_ccall f_4479(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4500)
static void C_ccall f_4500(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4486)
static void C_ccall f_4486(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4325)
static void C_ccall f_4325(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4325)
static void C_ccall f_4325r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4430)
static void C_fcall f_4430(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4438)
static void C_ccall f_4438(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4425)
static void C_fcall f_4425(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4327)
static void C_fcall f_4327(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4334)
static void C_ccall f_4334(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4337)
static void C_ccall f_4337(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4340)
static void C_ccall f_4340(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4424)
static void C_ccall f_4424(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4344)
static void C_ccall f_4344(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4358)
static void C_fcall f_4358(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4368)
static void C_ccall f_4368(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4371)
static void C_ccall f_4371(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4374)
static void C_ccall f_4374(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4380)
static void C_fcall f_4380(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4390)
static void C_ccall f_4390(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4301)
static void C_ccall f_4301(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4323)
static void C_ccall f_4323(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4319)
static void C_ccall f_4319(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4277)
static void C_ccall f_4277(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4299)
static void C_ccall f_4299(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4295)
static void C_ccall f_4295(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4182)
static void C_ccall f_4182(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4182)
static void C_ccall f_4182r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4263)
static void C_ccall f_4263(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4249)
static void C_ccall f_4249(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4197)
static void C_ccall f_4197(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4202)
static void C_ccall f_4202(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4225)
static void C_ccall f_4225(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4245)
static void C_ccall f_4245(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4208)
static void C_ccall f_4208(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4222)
static void C_ccall f_4222(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4120)
static void C_ccall f_4120(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4120)
static void C_ccall f_4120r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4133)
static void C_ccall f_4133(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4145)
static void C_ccall f_4145(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4139)
static void C_ccall f_4139(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4110)
static void C_ccall f_4110(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4117)
static void C_ccall f_4117(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4099)
static void C_ccall f_4099(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4106)
static void C_ccall f_4106(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4089)
static void C_ccall f_4089(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4096)
static void C_ccall f_4096(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4079)
static void C_ccall f_4079(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4086)
static void C_ccall f_4086(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4070)
static void C_ccall f_4070(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4077)
static void C_ccall f_4077(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4061)
static void C_ccall f_4061(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4068)
static void C_ccall f_4068(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4052)
static void C_ccall f_4052(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4059)
static void C_ccall f_4059(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4043)
static void C_ccall f_4043(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4050)
static void C_ccall f_4050(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4037)
static void C_ccall f_4037(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4041)
static void C_ccall f_4041(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4031)
static void C_ccall f_4031(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4035)
static void C_ccall f_4035(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4025)
static void C_ccall f_4025(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4029)
static void C_ccall f_4029(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4019)
static void C_ccall f_4019(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4023)
static void C_ccall f_4023(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4013)
static void C_ccall f_4013(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4017)
static void C_ccall f_4017(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4007)
static void C_ccall f_4007(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4011)
static void C_ccall f_4011(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3982)
static void C_ccall f_3982(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3982)
static void C_ccall f_3982r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3986)
static void C_ccall f_3986(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3945)
static void C_fcall f_3945(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3977)
static void C_ccall f_3977(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3970)
static void C_ccall f_3970(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3949)
static void C_ccall f_3949(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3753)
static void C_ccall f_3753(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3753)
static void C_ccall f_3753r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3926)
static void C_ccall f_3926(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3769)
static void C_ccall f_3769(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3900)
static void C_ccall f_3900(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3775)
static void C_ccall f_3775(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3778)
static void C_fcall f_3778(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3860)
static void C_ccall f_3860(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3858)
static void C_ccall f_3858(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3817)
static void C_fcall f_3817(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3835)
static void C_ccall f_3835(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3833)
static void C_ccall f_3833(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3821)
static void C_fcall f_3821(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3751)
static C_word C_fcall f_3751(C_word t0,C_word t1);
C_noret_decl(f_3749)
static C_word C_fcall f_3749(C_word t0,C_word t1);
C_noret_decl(f_3747)
static C_word C_fcall f_3747(C_word t0);
C_noret_decl(f_3715)
static void C_ccall f_3715(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3722)
static void C_ccall f_3722(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3728)
static void C_ccall f_3728(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3735)
static void C_ccall f_3735(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3676)
static void C_ccall f_3676(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3676)
static void C_ccall f_3676r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3683)
static void C_ccall f_3683(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3692)
static void C_ccall f_3692(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3634)
static void C_ccall f_3634(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3634)
static void C_ccall f_3634r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3644)
static void C_ccall f_3644(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3647)
static void C_ccall f_3647(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3650)
static void C_ccall f_3650(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3619)
static void C_ccall f_3619(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3581)
static void C_ccall f_3581(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3581)
static void C_ccall f_3581r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3611)
static void C_ccall f_3611(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3598)
static void C_ccall f_3598(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3601)
static void C_ccall f_3601(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3542)
static void C_ccall f_3542(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3542)
static void C_ccall f_3542r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3501)
static void C_ccall f_3501(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3498)
static void C_ccall f_3498(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3480)
static void C_ccall f_3480(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_3480)
static void C_ccall f_3480r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_3484)
static void C_ccall f_3484(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3495)
static void C_ccall f_3495(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3491)
static void C_ccall f_3491(C_word c,C_word t0,C_word t1) C_noret;

C_noret_decl(trf_8909)
static void C_fcall trf_8909(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8909(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_8909(t0,t1);}

C_noret_decl(trf_8904)
static void C_fcall trf_8904(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8904(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_8904(t0,t1,t2);}

C_noret_decl(trf_8899)
static void C_fcall trf_8899(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8899(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_8899(t0,t1,t2,t3);}

C_noret_decl(trf_8734)
static void C_fcall trf_8734(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8734(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_8734(t0,t1,t2,t3,t4);}

C_noret_decl(trf_8741)
static void C_fcall trf_8741(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8741(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_8741(t0,t1);}

C_noret_decl(trf_8753)
static void C_fcall trf_8753(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8753(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_8753(t0,t1,t2,t3);}

C_noret_decl(trf_8687)
static void C_fcall trf_8687(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8687(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_8687(t0,t1);}

C_noret_decl(trf_8682)
static void C_fcall trf_8682(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8682(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_8682(t0,t1,t2);}

C_noret_decl(trf_8677)
static void C_fcall trf_8677(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8677(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_8677(t0,t1,t2,t3);}

C_noret_decl(trf_8630)
static void C_fcall trf_8630(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8630(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_8630(t0,t1);}

C_noret_decl(trf_8625)
static void C_fcall trf_8625(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8625(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_8625(t0,t1,t2);}

C_noret_decl(trf_8620)
static void C_fcall trf_8620(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8620(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_8620(t0,t1,t2,t3);}

C_noret_decl(trf_8557)
static void C_fcall trf_8557(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8557(void *dummy){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
f_8557(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_8559)
static void C_fcall trf_8559(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8559(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_8559(t0,t1,t2);}

C_noret_decl(trf_8488)
static void C_fcall trf_8488(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8488(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_8488(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_8477)
static void C_fcall trf_8477(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8477(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_8477(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_8432)
static void C_fcall trf_8432(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8432(void *dummy){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
f_8432(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_8399)
static void C_fcall trf_8399(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8399(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_8399(t0,t1,t2,t3,t4);}

C_noret_decl(trf_8385)
static void C_fcall trf_8385(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8385(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_8385(t0,t1,t2,t3);}

C_noret_decl(trf_8365)
static void C_fcall trf_8365(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8365(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_8365(t0,t1,t2);}

C_noret_decl(trf_8328)
static void C_fcall trf_8328(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8328(void *dummy){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
f_8328(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_8084)
static void C_fcall trf_8084(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8084(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_8084(t0,t1);}

C_noret_decl(trf_8079)
static void C_fcall trf_8079(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8079(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_8079(t0,t1,t2);}

C_noret_decl(trf_7952)
static void C_fcall trf_7952(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7952(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7952(t0,t1,t2,t3);}

C_noret_decl(trf_7970)
static void C_fcall trf_7970(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7970(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7970(t0,t1,t2,t3);}

C_noret_decl(trf_7983)
static void C_fcall trf_7983(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7983(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7983(t0,t1);}

C_noret_decl(trf_7793)
static void C_fcall trf_7793(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7793(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7793(t0,t1,t2);}

C_noret_decl(trf_7830)
static void C_fcall trf_7830(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7830(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7830(t0,t1,t2);}

C_noret_decl(trf_7694)
static void C_fcall trf_7694(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7694(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7694(t0,t1,t2);}

C_noret_decl(trf_7380)
static void C_fcall trf_7380(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7380(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7380(t0,t1,t2);}

C_noret_decl(trf_7194)
static void C_fcall trf_7194(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7194(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7194(t0,t1,t2);}

C_noret_decl(trf_7206)
static void C_fcall trf_7206(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7206(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7206(t0,t1,t2);}

C_noret_decl(trf_7094)
static void C_fcall trf_7094(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7094(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7094(t0,t1);}

C_noret_decl(trf_6989)
static void C_fcall trf_6989(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6989(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6989(t0,t1,t2,t3);}

C_noret_decl(trf_6918)
static void C_fcall trf_6918(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6918(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6918(t0,t1,t2,t3);}

C_noret_decl(trf_6943)
static void C_fcall trf_6943(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6943(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6943(t0,t1);}

C_noret_decl(trf_6819)
static void C_fcall trf_6819(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6819(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6819(t0,t1);}

C_noret_decl(trf_6814)
static void C_fcall trf_6814(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6814(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6814(t0,t1,t2);}

C_noret_decl(trf_6809)
static void C_fcall trf_6809(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6809(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6809(t0,t1,t2,t3);}

C_noret_decl(trf_6625)
static void C_fcall trf_6625(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6625(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_6625(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6753)
static void C_fcall trf_6753(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6753(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_6753(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6677)
static void C_fcall trf_6677(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6677(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6677(t0,t1);}

C_noret_decl(trf_6631)
static void C_fcall trf_6631(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6631(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6631(t0,t1,t2,t3);}

C_noret_decl(trf_6548)
static void C_fcall trf_6548(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6548(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6548(t0,t1);}

C_noret_decl(trf_6543)
static void C_fcall trf_6543(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6543(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6543(t0,t1,t2);}

C_noret_decl(trf_6538)
static void C_fcall trf_6538(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6538(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6538(t0,t1,t2,t3);}

C_noret_decl(trf_6533)
static void C_fcall trf_6533(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6533(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_6533(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6146)
static void C_fcall trf_6146(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6146(void *dummy){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
f_6146(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_6412)
static void C_fcall trf_6412(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6412(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6412(t0,t1,t2);}

C_noret_decl(trf_6338)
static void C_fcall trf_6338(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6338(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6338(t0,t1);}

C_noret_decl(trf_6340)
static void C_fcall trf_6340(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6340(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_6340(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6188)
static void C_fcall trf_6188(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6188(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6188(t0,t1);}

C_noret_decl(trf_6200)
static void C_fcall trf_6200(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6200(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6200(t0,t1);}

C_noret_decl(trf_6157)
static void C_fcall trf_6157(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6157(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6157(t0,t1);}

C_noret_decl(trf_6124)
static void C_fcall trf_6124(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6124(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6124(t0,t1);}

C_noret_decl(trf_6029)
static void C_fcall trf_6029(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6029(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_6029(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5992)
static void C_fcall trf_5992(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5992(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5992(t0,t1,t2);}

C_noret_decl(trf_5799)
static void C_fcall trf_5799(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5799(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5799(t0,t1,t2,t3);}

C_noret_decl(trf_5621)
static void C_fcall trf_5621(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5621(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5621(t0,t1,t2,t3);}

C_noret_decl(trf_5564)
static void C_fcall trf_5564(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5564(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5564(t0,t1,t2);}

C_noret_decl(trf_5478)
static void C_fcall trf_5478(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5478(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5478(t0,t1);}

C_noret_decl(trf_5501)
static void C_fcall trf_5501(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5501(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5501(t0,t1,t2);}

C_noret_decl(trf_5384)
static void C_fcall trf_5384(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5384(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5384(t0,t1);}

C_noret_decl(trf_5258)
static void C_fcall trf_5258(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5258(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5258(t0,t1,t2,t3);}

C_noret_decl(trf_4950)
static void C_fcall trf_4950(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4950(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4950(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4944)
static void C_fcall trf_4944(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4944(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4944(t0,t1);}

C_noret_decl(trf_4742)
static void C_fcall trf_4742(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4742(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4742(t0,t1);}

C_noret_decl(trf_4761)
static void C_fcall trf_4761(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4761(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4761(t0,t1);}

C_noret_decl(trf_4805)
static void C_fcall trf_4805(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4805(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4805(t0,t1);}

C_noret_decl(trf_4631)
static void C_fcall trf_4631(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4631(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4631(t0,t1,t2,t3);}

C_noret_decl(trf_4699)
static void C_fcall trf_4699(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4699(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4699(t0,t1);}

C_noret_decl(trf_4559)
static void C_fcall trf_4559(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4559(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4559(t0,t1);}

C_noret_decl(trf_4543)
static void C_fcall trf_4543(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4543(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4543(t0,t1);}

C_noret_decl(trf_4430)
static void C_fcall trf_4430(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4430(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4430(t0,t1);}

C_noret_decl(trf_4425)
static void C_fcall trf_4425(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4425(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4425(t0,t1,t2);}

C_noret_decl(trf_4327)
static void C_fcall trf_4327(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4327(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4327(t0,t1,t2,t3);}

C_noret_decl(trf_4358)
static void C_fcall trf_4358(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4358(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4358(t0,t1);}

C_noret_decl(trf_4380)
static void C_fcall trf_4380(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4380(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4380(t0,t1);}

C_noret_decl(trf_3945)
static void C_fcall trf_3945(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3945(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3945(t0,t1,t2,t3);}

C_noret_decl(trf_3778)
static void C_fcall trf_3778(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3778(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3778(t0,t1);}

C_noret_decl(trf_3817)
static void C_fcall trf_3817(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3817(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3817(t0,t1);}

C_noret_decl(trf_3821)
static void C_fcall trf_3821(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3821(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3821(t0,t1);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr9)
static void C_fcall tr9(C_proc9 k) C_regparm C_noret;
C_regparm static void C_fcall tr9(C_proc9 k){
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
(k)(9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}

C_noret_decl(tr6)
static void C_fcall tr6(C_proc6 k) C_regparm C_noret;
C_regparm static void C_fcall tr6(C_proc6 k){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
(k)(6,t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr5r)
static void C_fcall tr5r(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5r(C_proc5 k){
int n;
C_word *a,t5;
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
n=C_rest_count(0);
a=C_alloc(n*3);
t5=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr7rv)
static void C_fcall tr7rv(C_proc7 k) C_regparm C_noret;
C_regparm static void C_fcall tr7rv(C_proc7 k){
int n;
C_word *a,t7;
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
n=C_rest_count(0);
a=C_alloc(n+1);
t7=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(tr4rv)
static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n+1);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr2rv)
static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n+1);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3rv)
static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n+1);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(3370)){
C_save(t1);
C_rereclaim2(3370*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,466);
lf[0]=C_h_intern(&lf[0],13,"string-append");
lf[2]=C_h_intern(&lf[2],15,"\003syssignal-hook");
lf[3]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[4]=C_h_intern(&lf[4],17,"\003syspeek-c-string");
lf[5]=C_h_intern(&lf[5],16,"\003sysupdate-errno");
lf[6]=C_h_intern(&lf[6],15,"\003sysposix-error");
lf[7]=C_h_intern(&lf[7],21,"\003sysfile-nonblocking!");
lf[8]=C_h_intern(&lf[8],19,"\003sysfile-select-one");
lf[9]=C_h_intern(&lf[9],8,"pipe/buf");
lf[10]=C_h_intern(&lf[10],11,"fcntl/dupfd");
lf[11]=C_h_intern(&lf[11],11,"fcntl/getfd");
lf[12]=C_h_intern(&lf[12],11,"fcntl/setfd");
lf[13]=C_h_intern(&lf[13],11,"fcntl/getfl");
lf[14]=C_h_intern(&lf[14],11,"fcntl/setfl");
lf[15]=C_h_intern(&lf[15],11,"open/rdonly");
lf[16]=C_h_intern(&lf[16],11,"open/wronly");
lf[17]=C_h_intern(&lf[17],9,"open/rdwr");
lf[18]=C_h_intern(&lf[18],9,"open/read");
lf[19]=C_h_intern(&lf[19],10,"open/write");
lf[20]=C_h_intern(&lf[20],10,"open/creat");
lf[21]=C_h_intern(&lf[21],11,"open/append");
lf[22]=C_h_intern(&lf[22],9,"open/excl");
lf[23]=C_h_intern(&lf[23],11,"open/noctty");
lf[24]=C_h_intern(&lf[24],13,"open/nonblock");
lf[25]=C_h_intern(&lf[25],10,"open/trunc");
lf[26]=C_h_intern(&lf[26],9,"open/sync");
lf[27]=C_h_intern(&lf[27],10,"open/fsync");
lf[28]=C_h_intern(&lf[28],11,"open/binary");
lf[29]=C_h_intern(&lf[29],9,"open/text");
lf[30]=C_h_intern(&lf[30],10,"perm/irusr");
lf[31]=C_h_intern(&lf[31],10,"perm/iwusr");
lf[32]=C_h_intern(&lf[32],10,"perm/ixusr");
lf[33]=C_h_intern(&lf[33],10,"perm/irgrp");
lf[34]=C_h_intern(&lf[34],10,"perm/iwgrp");
lf[35]=C_h_intern(&lf[35],10,"perm/ixgrp");
lf[36]=C_h_intern(&lf[36],10,"perm/iroth");
lf[37]=C_h_intern(&lf[37],10,"perm/iwoth");
lf[38]=C_h_intern(&lf[38],10,"perm/ixoth");
lf[39]=C_h_intern(&lf[39],10,"perm/irwxu");
lf[40]=C_h_intern(&lf[40],10,"perm/irwxg");
lf[41]=C_h_intern(&lf[41],10,"perm/irwxo");
lf[42]=C_h_intern(&lf[42],10,"perm/isvtx");
lf[43]=C_h_intern(&lf[43],10,"perm/isuid");
lf[44]=C_h_intern(&lf[44],10,"perm/isgid");
lf[45]=C_h_intern(&lf[45],12,"file-control");
lf[46]=C_h_intern(&lf[46],11,"\000file-error");
lf[47]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot control file");
lf[48]=C_h_intern(&lf[48],9,"file-open");
lf[49]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[50]=C_h_intern(&lf[50],17,"\003sysmake-c-string");
lf[51]=C_h_intern(&lf[51],20,"\003sysexpand-home-path");
lf[52]=C_h_intern(&lf[52],10,"file-close");
lf[53]=C_decode_literal(C_heaptop,"\376B\000\000\021cannot close file");
lf[54]=C_h_intern(&lf[54],11,"make-string");
lf[55]=C_h_intern(&lf[55],9,"file-read");
lf[56]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot read from file");
lf[57]=C_h_intern(&lf[57],11,"\000type-error");
lf[58]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[59]=C_h_intern(&lf[59],10,"file-write");
lf[60]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot write to file");
lf[61]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[62]=C_h_intern(&lf[62],12,"file-mkstemp");
lf[63]=C_h_intern(&lf[63],13,"\003syssubstring");
lf[64]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot create temporary file");
lf[65]=C_h_intern(&lf[65],11,"file-select");
lf[66]=C_decode_literal(C_heaptop,"\376B\000\000\006failed");
lf[67]=C_h_intern(&lf[67],12,"\003sysfor-each");
lf[68]=C_h_intern(&lf[68],8,"seek/set");
lf[69]=C_h_intern(&lf[69],8,"seek/end");
lf[70]=C_h_intern(&lf[70],8,"seek/cur");
lf[72]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot access file");
lf[73]=C_decode_literal(C_heaptop,"\376B\000\000*bad argument type - not a fixnum or string");
lf[74]=C_h_intern(&lf[74],9,"file-stat");
lf[75]=C_h_intern(&lf[75],9,"file-size");
lf[76]=C_h_intern(&lf[76],22,"file-modification-time");
lf[77]=C_h_intern(&lf[77],16,"file-access-time");
lf[78]=C_h_intern(&lf[78],16,"file-change-time");
lf[79]=C_h_intern(&lf[79],10,"file-owner");
lf[80]=C_h_intern(&lf[80],16,"file-permissions");
lf[81]=C_h_intern(&lf[81],13,"regular-file\077");
lf[82]=C_h_intern(&lf[82],14,"symbolic-link\077");
lf[83]=C_h_intern(&lf[83],13,"stat-regular\077");
lf[84]=C_h_intern(&lf[84],15,"stat-directory\077");
lf[85]=C_h_intern(&lf[85],17,"character-device\077");
lf[86]=C_h_intern(&lf[86],17,"stat-char-device\077");
lf[87]=C_h_intern(&lf[87],13,"block-device\077");
lf[88]=C_h_intern(&lf[88],18,"stat-block-device\077");
lf[89]=C_h_intern(&lf[89],5,"fifo\077");
lf[90]=C_h_intern(&lf[90],10,"stat-fifo\077");
lf[91]=C_h_intern(&lf[91],13,"stat-symlink\077");
lf[92]=C_h_intern(&lf[92],7,"socket\077");
lf[93]=C_h_intern(&lf[93],12,"stat-socket\077");
lf[94]=C_h_intern(&lf[94],18,"set-file-position!");
lf[95]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot set file position");
lf[96]=C_h_intern(&lf[96],6,"stream");
lf[97]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[98]=C_h_intern(&lf[98],5,"port\077");
lf[99]=C_h_intern(&lf[99],13,"\000bounds-error");
lf[100]=C_decode_literal(C_heaptop,"\376B\000\000\036invalid negative port position");
lf[101]=C_h_intern(&lf[101],13,"file-position");
lf[102]=C_h_intern(&lf[102],16,"create-directory");
lf[103]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[104]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create directory");
lf[105]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot stat file");
lf[106]=C_decode_literal(C_heaptop,"\376B\000\000\026path segment is a file");
lf[107]=C_h_intern(&lf[107],12,"file-exists\077");
lf[108]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[109]=C_h_intern(&lf[109],12,"string-split");
lf[110]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[111]=C_h_intern(&lf[111],16,"change-directory");
lf[112]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[113]=C_h_intern(&lf[113],16,"delete-directory");
lf[114]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot delete directory");
lf[115]=C_h_intern(&lf[115],10,"string-ref");
lf[116]=C_h_intern(&lf[116],6,"string");
lf[117]=C_h_intern(&lf[117],9,"directory");
lf[118]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot open directory");
lf[119]=C_h_intern(&lf[119],16,"\003sysmake-pointer");
lf[120]=C_h_intern(&lf[120],17,"current-directory");
lf[121]=C_h_intern(&lf[121],10,"directory\077");
lf[122]=C_h_intern(&lf[122],13,"\003sysfile-info");
lf[123]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current directory");
lf[124]=C_h_intern(&lf[124],5,"null\077");
lf[125]=C_h_intern(&lf[125],6,"char=\077");
lf[126]=C_h_intern(&lf[126],8,"string=\077");
lf[127]=C_h_intern(&lf[127],16,"char-alphabetic\077");
lf[128]=C_h_intern(&lf[128],18,"string-intersperse");
lf[129]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[130]=C_h_intern(&lf[130],24,"get-environment-variable");
lf[131]=C_h_intern(&lf[131],17,"current-user-name");
lf[132]=C_h_intern(&lf[132],9,"condition");
lf[133]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[134]=C_h_intern(&lf[134],22,"with-exception-handler");
lf[135]=C_h_intern(&lf[135],30,"call-with-current-continuation");
lf[136]=C_h_intern(&lf[136],14,"canonical-path");
lf[137]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[138]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[139]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[140]=C_h_intern(&lf[140],7,"reverse");
lf[141]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[142]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[143]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[144]=C_decode_literal(C_heaptop,"\376B\000\000\002/\134");
lf[145]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[146]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[147]=C_decode_literal(C_heaptop,"\376B\000\000\006/home/");
lf[148]=C_decode_literal(C_heaptop,"\376B\000\000\004HOME");
lf[149]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[150]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[151]=C_h_intern(&lf[151],5,"\000text");
lf[152]=C_h_intern(&lf[152],9,"\003syserror");
lf[153]=C_decode_literal(C_heaptop,"\376B\000\000#illegal input/output mode specifier");
lf[154]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open pipe");
lf[155]=C_h_intern(&lf[155],13,"\003sysmake-port");
lf[156]=C_h_intern(&lf[156],21,"\003sysstream-port-class");
lf[157]=C_decode_literal(C_heaptop,"\376B\000\000\006(pipe)");
lf[158]=C_h_intern(&lf[158],15,"open-input-pipe");
lf[159]=C_h_intern(&lf[159],7,"\000binary");
lf[160]=C_h_intern(&lf[160],16,"open-output-pipe");
lf[161]=C_h_intern(&lf[161],16,"close-input-pipe");
lf[162]=C_h_intern(&lf[162],23,"close-input/output-pipe");
lf[163]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[164]=C_h_intern(&lf[164],14,"\003syscheck-port");
lf[165]=C_h_intern(&lf[165],17,"close-output-pipe");
lf[166]=C_h_intern(&lf[166],20,"call-with-input-pipe");
lf[167]=C_h_intern(&lf[167],21,"call-with-output-pipe");
lf[168]=C_h_intern(&lf[168],20,"with-input-from-pipe");
lf[169]=C_h_intern(&lf[169],18,"\003sysstandard-input");
lf[170]=C_h_intern(&lf[170],19,"with-output-to-pipe");
lf[171]=C_h_intern(&lf[171],19,"\003sysstandard-output");
lf[172]=C_h_intern(&lf[172],11,"create-pipe");
lf[173]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create pipe");
lf[174]=C_h_intern(&lf[174],11,"signal/term");
lf[175]=C_h_intern(&lf[175],11,"signal/kill");
lf[176]=C_h_intern(&lf[176],10,"signal/int");
lf[177]=C_h_intern(&lf[177],10,"signal/hup");
lf[178]=C_h_intern(&lf[178],10,"signal/fpe");
lf[179]=C_h_intern(&lf[179],10,"signal/ill");
lf[180]=C_h_intern(&lf[180],11,"signal/segv");
lf[181]=C_h_intern(&lf[181],11,"signal/abrt");
lf[182]=C_h_intern(&lf[182],11,"signal/trap");
lf[183]=C_h_intern(&lf[183],11,"signal/quit");
lf[184]=C_h_intern(&lf[184],11,"signal/alrm");
lf[185]=C_h_intern(&lf[185],13,"signal/vtalrm");
lf[186]=C_h_intern(&lf[186],11,"signal/prof");
lf[187]=C_h_intern(&lf[187],9,"signal/io");
lf[188]=C_h_intern(&lf[188],10,"signal/urg");
lf[189]=C_h_intern(&lf[189],11,"signal/chld");
lf[190]=C_h_intern(&lf[190],11,"signal/cont");
lf[191]=C_h_intern(&lf[191],11,"signal/stop");
lf[192]=C_h_intern(&lf[192],11,"signal/tstp");
lf[193]=C_h_intern(&lf[193],11,"signal/pipe");
lf[194]=C_h_intern(&lf[194],11,"signal/xcpu");
lf[195]=C_h_intern(&lf[195],11,"signal/xfsz");
lf[196]=C_h_intern(&lf[196],11,"signal/usr1");
lf[197]=C_h_intern(&lf[197],11,"signal/usr2");
lf[198]=C_h_intern(&lf[198],12,"signal/winch");
lf[199]=C_h_intern(&lf[199],12,"signals-list");
lf[200]=C_h_intern(&lf[200],18,"\003sysinterrupt-hook");
lf[201]=C_h_intern(&lf[201],14,"signal-handler");
lf[202]=C_h_intern(&lf[202],19,"set-signal-handler!");
lf[203]=C_h_intern(&lf[203],16,"set-signal-mask!");
lf[204]=C_h_intern(&lf[204],14,"\000process-error");
lf[205]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot set signal mask");
lf[206]=C_h_intern(&lf[206],11,"signal-mask");
lf[207]=C_h_intern(&lf[207],14,"signal-masked\077");
lf[208]=C_h_intern(&lf[208],12,"signal-mask!");
lf[209]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot block signal");
lf[210]=C_h_intern(&lf[210],14,"signal-unmask!");
lf[211]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot unblock signal");
lf[212]=C_h_intern(&lf[212],18,"system-information");
lf[213]=C_h_intern(&lf[213],25,"\003syspeek-nonnull-c-string");
lf[214]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot retrieve system information");
lf[215]=C_h_intern(&lf[215],15,"current-user-id");
lf[216]=C_h_intern(&lf[216],25,"current-effective-user-id");
lf[217]=C_h_intern(&lf[217],16,"current-group-id");
lf[218]=C_h_intern(&lf[218],26,"current-effective-group-id");
lf[219]=C_h_intern(&lf[219],16,"user-information");
lf[220]=C_h_intern(&lf[220],6,"vector");
lf[221]=C_h_intern(&lf[221],4,"list");
lf[222]=C_h_intern(&lf[222],27,"current-effective-user-name");
lf[223]=C_h_intern(&lf[223],17,"group-information");
lf[225]=C_h_intern(&lf[225],10,"get-groups");
lf[226]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[227]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[228]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[229]=C_h_intern(&lf[229],11,"set-groups!");
lf[230]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot set supplementary group ids");
lf[231]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[232]=C_h_intern(&lf[232],17,"initialize-groups");
lf[233]=C_decode_literal(C_heaptop,"\376B\000\000)cannot initialize supplementary group ids");
lf[234]=C_h_intern(&lf[234],10,"errno/perm");
lf[235]=C_h_intern(&lf[235],11,"errno/noent");
lf[236]=C_h_intern(&lf[236],10,"errno/srch");
lf[237]=C_h_intern(&lf[237],10,"errno/intr");
lf[238]=C_h_intern(&lf[238],8,"errno/io");
lf[239]=C_h_intern(&lf[239],12,"errno/noexec");
lf[240]=C_h_intern(&lf[240],10,"errno/badf");
lf[241]=C_h_intern(&lf[241],11,"errno/child");
lf[242]=C_h_intern(&lf[242],11,"errno/nomem");
lf[243]=C_h_intern(&lf[243],11,"errno/acces");
lf[244]=C_h_intern(&lf[244],11,"errno/fault");
lf[245]=C_h_intern(&lf[245],10,"errno/busy");
lf[246]=C_h_intern(&lf[246],12,"errno/notdir");
lf[247]=C_h_intern(&lf[247],11,"errno/isdir");
lf[248]=C_h_intern(&lf[248],11,"errno/inval");
lf[249]=C_h_intern(&lf[249],11,"errno/mfile");
lf[250]=C_h_intern(&lf[250],11,"errno/nospc");
lf[251]=C_h_intern(&lf[251],11,"errno/spipe");
lf[252]=C_h_intern(&lf[252],10,"errno/pipe");
lf[253]=C_h_intern(&lf[253],11,"errno/again");
lf[254]=C_h_intern(&lf[254],10,"errno/rofs");
lf[255]=C_h_intern(&lf[255],11,"errno/exist");
lf[256]=C_h_intern(&lf[256],16,"errno/wouldblock");
lf[257]=C_h_intern(&lf[257],10,"errno/2big");
lf[258]=C_h_intern(&lf[258],12,"errno/deadlk");
lf[259]=C_h_intern(&lf[259],9,"errno/dom");
lf[260]=C_h_intern(&lf[260],10,"errno/fbig");
lf[261]=C_h_intern(&lf[261],11,"errno/ilseq");
lf[262]=C_h_intern(&lf[262],11,"errno/mlink");
lf[263]=C_h_intern(&lf[263],17,"errno/nametoolong");
lf[264]=C_h_intern(&lf[264],11,"errno/nfile");
lf[265]=C_h_intern(&lf[265],11,"errno/nodev");
lf[266]=C_h_intern(&lf[266],11,"errno/nolck");
lf[267]=C_h_intern(&lf[267],11,"errno/nosys");
lf[268]=C_h_intern(&lf[268],14,"errno/notempty");
lf[269]=C_h_intern(&lf[269],11,"errno/notty");
lf[270]=C_h_intern(&lf[270],10,"errno/nxio");
lf[271]=C_h_intern(&lf[271],11,"errno/range");
lf[272]=C_h_intern(&lf[272],10,"errno/xdev");
lf[273]=C_h_intern(&lf[273],16,"change-file-mode");
lf[274]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot change file mode");
lf[275]=C_h_intern(&lf[275],17,"change-file-owner");
lf[276]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot change file owner");
lf[277]=C_h_intern(&lf[277],17,"file-read-access\077");
lf[278]=C_h_intern(&lf[278],18,"file-write-access\077");
lf[279]=C_h_intern(&lf[279],20,"file-execute-access\077");
lf[280]=C_h_intern(&lf[280],14,"create-session");
lf[281]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot create session");
lf[282]=C_h_intern(&lf[282],16,"process-group-id");
lf[283]=C_h_intern(&lf[283],20,"create-symbolic-link");
lf[284]=C_h_intern(&lf[284],18,"create-symbol-link");
lf[285]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create symbolic link");
lf[286]=C_h_intern(&lf[286],9,"substring");
lf[287]=C_h_intern(&lf[287],18,"read-symbolic-link");
lf[288]=C_h_intern(&lf[288],12,"canonicalize");
lf[289]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot read symbolic link");
lf[290]=C_h_intern(&lf[290],9,"file-link");
lf[291]=C_h_intern(&lf[291],9,"hard-link");
lf[292]=C_decode_literal(C_heaptop,"\376B\000\000\032could not create hard link");
lf[293]=C_h_intern(&lf[293],12,"fileno/stdin");
lf[294]=C_h_intern(&lf[294],13,"fileno/stdout");
lf[295]=C_h_intern(&lf[295],13,"fileno/stderr");
lf[296]=C_h_intern(&lf[296],7,"\000append");
lf[297]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[298]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[299]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[300]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[301]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[302]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[303]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[304]=C_h_intern(&lf[304],16,"open-input-file*");
lf[305]=C_h_intern(&lf[305],17,"open-output-file*");
lf[306]=C_h_intern(&lf[306],12,"port->fileno");
lf[307]=C_h_intern(&lf[307],6,"socket");
lf[308]=C_h_intern(&lf[308],20,"\003systcp-port->fileno");
lf[309]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[310]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[311]=C_h_intern(&lf[311],25,"\003syspeek-unsigned-integer");
lf[312]=C_h_intern(&lf[312],16,"duplicate-fileno");
lf[313]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file-descriptor");
lf[314]=C_h_intern(&lf[314],15,"make-input-port");
lf[315]=C_h_intern(&lf[315],14,"set-port-name!");
lf[316]=C_h_intern(&lf[316],21,"\003syscustom-input-port");
lf[317]=C_decode_literal(C_heaptop,"\376B\000\000\015cannot select");
lf[318]=C_h_intern(&lf[318],17,"\003systhread-yield!");
lf[319]=C_h_intern(&lf[319],25,"\003systhread-block-for-i/o!");
lf[320]=C_h_intern(&lf[320],18,"\003syscurrent-thread");
lf[321]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[322]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[323]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[324]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[325]=C_h_intern(&lf[325],17,"\003sysstring-append");
lf[326]=C_h_intern(&lf[326],15,"\003sysmake-string");
lf[327]=C_h_intern(&lf[327],20,"\003sysscan-buffer-line");
lf[328]=C_h_intern(&lf[328],4,"noop");
lf[329]=C_h_intern(&lf[329],16,"make-output-port");
lf[330]=C_h_intern(&lf[330],22,"\003syscustom-output-port");
lf[331]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot write");
lf[332]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[333]=C_h_intern(&lf[333],13,"file-truncate");
lf[334]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot truncate file");
lf[335]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[336]=C_h_intern(&lf[336],4,"lock");
lf[337]=C_h_intern(&lf[337],9,"file-lock");
lf[338]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[339]=C_h_intern(&lf[339],18,"file-lock/blocking");
lf[340]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[341]=C_h_intern(&lf[341],14,"file-test-lock");
lf[342]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[343]=C_h_intern(&lf[343],11,"file-unlock");
lf[344]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[345]=C_h_intern(&lf[345],11,"create-fifo");
lf[346]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create FIFO");
lf[347]=C_decode_literal(C_heaptop,"\376B\000\000\023file does not exist");
lf[348]=C_h_intern(&lf[348],6,"setenv");
lf[349]=C_h_intern(&lf[349],8,"unsetenv");
lf[350]=C_h_intern(&lf[350],25,"get-environment-variables");
lf[351]=C_h_intern(&lf[351],19,"current-environment");
lf[352]=C_h_intern(&lf[352],9,"prot/read");
lf[353]=C_h_intern(&lf[353],10,"prot/write");
lf[354]=C_h_intern(&lf[354],9,"prot/exec");
lf[355]=C_h_intern(&lf[355],9,"prot/none");
lf[356]=C_h_intern(&lf[356],9,"map/fixed");
lf[357]=C_h_intern(&lf[357],10,"map/shared");
lf[358]=C_h_intern(&lf[358],11,"map/private");
lf[359]=C_h_intern(&lf[359],13,"map/anonymous");
lf[360]=C_h_intern(&lf[360],8,"map/file");
lf[361]=C_h_intern(&lf[361],18,"map-file-to-memory");
lf[362]=C_h_intern(&lf[362],4,"mmap");
lf[363]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot map file to memory");
lf[364]=C_h_intern(&lf[364],20,"\003syspointer->address");
lf[365]=C_decode_literal(C_heaptop,"\376B\000\000)bad argument type - not a foreign pointer");
lf[366]=C_h_intern(&lf[366],16,"\003sysnull-pointer");
lf[367]=C_h_intern(&lf[367],22,"unmap-file-from-memory");
lf[368]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot unmap file from memory");
lf[369]=C_h_intern(&lf[369],26,"memory-mapped-file-pointer");
lf[370]=C_h_intern(&lf[370],19,"memory-mapped-file\077");
lf[372]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[373]=C_h_intern(&lf[373],19,"seconds->local-time");
lf[374]=C_h_intern(&lf[374],18,"\003sysdecode-seconds");
lf[375]=C_h_intern(&lf[375],17,"seconds->utc-time");
lf[376]=C_h_intern(&lf[376],15,"seconds->string");
lf[377]=C_decode_literal(C_heaptop,"\376B\000\000 cannot convert seconds to string");
lf[378]=C_h_intern(&lf[378],12,"time->string");
lf[379]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[380]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[381]=C_h_intern(&lf[381],12,"string->time");
lf[382]=C_decode_literal(C_heaptop,"\376B\000\000\027%a %b %e %H:%M:%S %Z %Y");
lf[383]=C_h_intern(&lf[383],19,"local-time->seconds");
lf[384]=C_h_intern(&lf[384],15,"\003syscons-flonum");
lf[385]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[386]=C_h_intern(&lf[386],17,"utc-time->seconds");
lf[387]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[388]=C_h_intern(&lf[388],27,"local-timezone-abbreviation");
lf[389]=C_h_intern(&lf[389],5,"_exit");
lf[390]=C_h_intern(&lf[390],10,"set-alarm!");
lf[391]=C_h_intern(&lf[391],19,"set-buffering-mode!");
lf[392]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot set buffering mode");
lf[393]=C_h_intern(&lf[393],5,"\000full");
lf[394]=C_h_intern(&lf[394],5,"\000line");
lf[395]=C_h_intern(&lf[395],5,"\000none");
lf[396]=C_decode_literal(C_heaptop,"\376B\000\000\026invalid buffering-mode");
lf[397]=C_h_intern(&lf[397],14,"terminal-port\077");
lf[399]=C_decode_literal(C_heaptop,"\376B\000\000#port is not connected to a terminal");
lf[400]=C_h_intern(&lf[400],13,"terminal-name");
lf[401]=C_h_intern(&lf[401],13,"terminal-size");
lf[402]=C_h_intern(&lf[402],6,"\000error");
lf[403]=C_decode_literal(C_heaptop,"\376B\000\000\036Unable to get size of terminal");
lf[404]=C_h_intern(&lf[404],17,"\003sysmake-locative");
lf[405]=C_h_intern(&lf[405],8,"location");
lf[406]=C_h_intern(&lf[406],13,"get-host-name");
lf[407]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot retrieve host-name");
lf[408]=C_h_intern(&lf[408],6,"regexp");
lf[409]=C_h_intern(&lf[409],12,"string-match");
lf[410]=C_h_intern(&lf[410],12,"glob->regexp");
lf[411]=C_h_intern(&lf[411],13,"make-pathname");
lf[412]=C_h_intern(&lf[412],18,"decompose-pathname");
lf[413]=C_h_intern(&lf[413],4,"glob");
lf[414]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[415]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[416]=C_h_intern(&lf[416],12,"process-fork");
lf[417]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create child process");
lf[418]=C_h_intern(&lf[418],24,"pathname-strip-directory");
lf[419]=C_h_intern(&lf[419],15,"process-execute");
lf[420]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[421]=C_h_intern(&lf[421],16,"\003sysprocess-wait");
lf[422]=C_h_intern(&lf[422],12,"process-wait");
lf[423]=C_decode_literal(C_heaptop,"\376B\000\000 waiting for child process failed");
lf[424]=C_h_intern(&lf[424],18,"current-process-id");
lf[425]=C_h_intern(&lf[425],17,"parent-process-id");
lf[426]=C_h_intern(&lf[426],5,"sleep");
lf[427]=C_h_intern(&lf[427],14,"process-signal");
lf[428]=C_decode_literal(C_heaptop,"\376B\000\000 could not send signal to process");
lf[429]=C_h_intern(&lf[429],17,"\003sysshell-command");
lf[430]=C_decode_literal(C_heaptop,"\376B\000\000\007/bin/sh");
lf[431]=C_decode_literal(C_heaptop,"\376B\000\000\005SHELL");
lf[432]=C_h_intern(&lf[432],27,"\003sysshell-command-arguments");
lf[433]=C_decode_literal(C_heaptop,"\376B\000\000\002-c");
lf[434]=C_h_intern(&lf[434],11,"process-run");
lf[435]=C_decode_literal(C_heaptop,"\376B\000\000\025abnormal process exit");
lf[436]=C_h_intern(&lf[436],11,"\003sysprocess");
lf[437]=C_h_intern(&lf[437],7,"process");
lf[438]=C_h_intern(&lf[438],8,"process*");
lf[439]=C_h_intern(&lf[439],10,"find-files");
lf[440]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[441]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[442]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[443]=C_h_intern(&lf[443],16,"\003sysdynamic-wind");
lf[444]=C_h_intern(&lf[444],13,"pathname-file");
lf[445]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[446]=C_h_intern(&lf[446],7,"regexp\077");
lf[447]=C_h_intern(&lf[447],19,"set-root-directory!");
lf[448]=C_decode_literal(C_heaptop,"\376B\000\000\037unable to change root directory");
lf[449]=C_decode_literal(C_heaptop,"\376B\000\000 cannot retrieve process group ID");
lf[450]=C_h_intern(&lf[450],21,"set-process-group-id!");
lf[451]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot set process group ID");
lf[452]=C_h_intern(&lf[452],18,"getter-with-setter");
lf[453]=C_h_intern(&lf[453],26,"effective-group-id!-setter");
lf[454]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot set effective group ID");
lf[455]=C_h_intern(&lf[455],12,"set-user-id!");
lf[456]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot set group ID");
lf[457]=C_h_intern(&lf[457],25,"effective-user-id!-setter");
lf[458]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot set effective user ID");
lf[459]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot set user ID");
lf[460]=C_h_intern(&lf[460],23,"\003sysuser-interrupt-hook");
lf[461]=C_h_intern(&lf[461],11,"make-vector");
lf[462]=C_decode_literal(C_heaptop,"\376B\000\000%cannot retrieve file position of port");
lf[463]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[464]=C_h_intern(&lf[464],17,"register-feature!");
lf[465]=C_h_intern(&lf[465],5,"posix");
C_register_lf2(lf,466,create_ptable());
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3455,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k3453 */
static void C_ccall f_3455(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3455,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3458,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k3456 in k3453 */
static void C_ccall f_3458(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3458,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3461,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k3459 in k3456 in k3453 */
static void C_ccall f_3461(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3461,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3464,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3464(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3464,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3467,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_files_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3467(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3467,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3470,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_ports_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3470(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3470,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3473,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 501  register-feature! */
t3=*((C_word*)lf[464]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[465]);}

/* k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3473(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word ab[79],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3473,2,t0,t1);}
t2=*((C_word*)lf[0]+1);
t3=C_mutate(&lf[1] /* (set! posix-error ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3480,a[2]=t2,tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[6]+1 /* (set! posix-error ...) */,lf[1]);
t5=C_mutate((C_word*)lf[7]+1 /* (set! file-nonblocking! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3498,tmp=(C_word)a,a+=2,tmp));
t6=C_mutate((C_word*)lf[8]+1 /* (set! file-select-one ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3501,tmp=(C_word)a,a+=2,tmp));
t7=C_mutate((C_word*)lf[9]+1 /* (set! pipe/buf ...) */,C_fix((C_word)PIPE_BUF));
t8=C_mutate((C_word*)lf[10]+1 /* (set! fcntl/dupfd ...) */,C_fix((C_word)F_DUPFD));
t9=C_mutate((C_word*)lf[11]+1 /* (set! fcntl/getfd ...) */,C_fix((C_word)F_GETFD));
t10=C_mutate((C_word*)lf[12]+1 /* (set! fcntl/setfd ...) */,C_fix((C_word)F_SETFD));
t11=C_mutate((C_word*)lf[13]+1 /* (set! fcntl/getfl ...) */,C_fix((C_word)F_GETFL));
t12=C_mutate((C_word*)lf[14]+1 /* (set! fcntl/setfl ...) */,C_fix((C_word)F_SETFL));
t13=C_mutate((C_word*)lf[15]+1 /* (set! open/rdonly ...) */,C_fix((C_word)O_RDONLY));
t14=C_mutate((C_word*)lf[16]+1 /* (set! open/wronly ...) */,C_fix((C_word)O_WRONLY));
t15=C_mutate((C_word*)lf[17]+1 /* (set! open/rdwr ...) */,C_fix((C_word)O_RDWR));
t16=C_mutate((C_word*)lf[18]+1 /* (set! open/read ...) */,C_fix((C_word)O_RDONLY));
t17=C_mutate((C_word*)lf[19]+1 /* (set! open/write ...) */,C_fix((C_word)O_WRONLY));
t18=C_mutate((C_word*)lf[20]+1 /* (set! open/creat ...) */,C_fix((C_word)O_CREAT));
t19=C_mutate((C_word*)lf[21]+1 /* (set! open/append ...) */,C_fix((C_word)O_APPEND));
t20=C_mutate((C_word*)lf[22]+1 /* (set! open/excl ...) */,C_fix((C_word)O_EXCL));
t21=C_mutate((C_word*)lf[23]+1 /* (set! open/noctty ...) */,C_fix((C_word)O_NOCTTY));
t22=C_mutate((C_word*)lf[24]+1 /* (set! open/nonblock ...) */,C_fix((C_word)O_NONBLOCK));
t23=C_mutate((C_word*)lf[25]+1 /* (set! open/trunc ...) */,C_fix((C_word)O_TRUNC));
t24=C_mutate((C_word*)lf[26]+1 /* (set! open/sync ...) */,C_fix((C_word)O_FSYNC));
t25=C_mutate((C_word*)lf[27]+1 /* (set! open/fsync ...) */,C_fix((C_word)O_FSYNC));
t26=C_mutate((C_word*)lf[28]+1 /* (set! open/binary ...) */,C_fix((C_word)O_BINARY));
t27=C_mutate((C_word*)lf[29]+1 /* (set! open/text ...) */,C_fix((C_word)O_TEXT));
t28=C_mutate((C_word*)lf[30]+1 /* (set! perm/irusr ...) */,C_fix((C_word)S_IRUSR));
t29=C_mutate((C_word*)lf[31]+1 /* (set! perm/iwusr ...) */,C_fix((C_word)S_IWUSR));
t30=C_mutate((C_word*)lf[32]+1 /* (set! perm/ixusr ...) */,C_fix((C_word)S_IXUSR));
t31=C_mutate((C_word*)lf[33]+1 /* (set! perm/irgrp ...) */,C_fix((C_word)S_IRGRP));
t32=C_mutate((C_word*)lf[34]+1 /* (set! perm/iwgrp ...) */,C_fix((C_word)S_IWGRP));
t33=C_mutate((C_word*)lf[35]+1 /* (set! perm/ixgrp ...) */,C_fix((C_word)S_IXGRP));
t34=C_mutate((C_word*)lf[36]+1 /* (set! perm/iroth ...) */,C_fix((C_word)S_IROTH));
t35=C_mutate((C_word*)lf[37]+1 /* (set! perm/iwoth ...) */,C_fix((C_word)S_IWOTH));
t36=C_mutate((C_word*)lf[38]+1 /* (set! perm/ixoth ...) */,C_fix((C_word)S_IXOTH));
t37=C_mutate((C_word*)lf[39]+1 /* (set! perm/irwxu ...) */,C_fix((C_word)S_IRWXU));
t38=C_mutate((C_word*)lf[40]+1 /* (set! perm/irwxg ...) */,C_fix((C_word)S_IRWXG));
t39=C_mutate((C_word*)lf[41]+1 /* (set! perm/irwxo ...) */,C_fix((C_word)S_IRWXO));
t40=C_mutate((C_word*)lf[42]+1 /* (set! perm/isvtx ...) */,C_fix((C_word)S_ISVTX));
t41=C_mutate((C_word*)lf[43]+1 /* (set! perm/isuid ...) */,C_fix((C_word)S_ISUID));
t42=C_mutate((C_word*)lf[44]+1 /* (set! perm/isgid ...) */,C_fix((C_word)S_ISGID));
t43=C_mutate((C_word*)lf[45]+1 /* (set! file-control ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3542,tmp=(C_word)a,a+=2,tmp));
t44=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t45=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRWXU),t44);
t46=C_mutate((C_word*)lf[48]+1 /* (set! file-open ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3581,a[2]=t45,tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[52]+1 /* (set! file-close ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3619,tmp=(C_word)a,a+=2,tmp));
t48=*((C_word*)lf[54]+1);
t49=C_mutate((C_word*)lf[55]+1 /* (set! file-read ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3634,a[2]=t48,tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[59]+1 /* (set! file-write ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3676,tmp=(C_word)a,a+=2,tmp));
t51=C_mutate((C_word*)lf[62]+1 /* (set! file-mkstemp ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3715,tmp=(C_word)a,a+=2,tmp));
t52=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3747,tmp=(C_word)a,a+=2,tmp);
t53=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3749,tmp=(C_word)a,a+=2,tmp);
t54=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3751,tmp=(C_word)a,a+=2,tmp);
t55=C_mutate((C_word*)lf[65]+1 /* (set! file-select ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3753,a[2]=t53,a[3]=t54,a[4]=t52,tmp=(C_word)a,a+=5,tmp));
t56=C_mutate((C_word*)lf[68]+1 /* (set! seek/set ...) */,C_fix((C_word)SEEK_SET));
t57=C_mutate((C_word*)lf[69]+1 /* (set! seek/end ...) */,C_fix((C_word)SEEK_END));
t58=C_mutate((C_word*)lf[70]+1 /* (set! seek/cur ...) */,C_fix((C_word)SEEK_CUR));
t59=C_mutate(&lf[71] /* (set! stat ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3945,tmp=(C_word)a,a+=2,tmp));
t60=C_mutate((C_word*)lf[74]+1 /* (set! file-stat ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3982,tmp=(C_word)a,a+=2,tmp));
t61=C_mutate((C_word*)lf[75]+1 /* (set! file-size ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4007,tmp=(C_word)a,a+=2,tmp));
t62=C_mutate((C_word*)lf[76]+1 /* (set! file-modification-time ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4013,tmp=(C_word)a,a+=2,tmp));
t63=C_mutate((C_word*)lf[77]+1 /* (set! file-access-time ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4019,tmp=(C_word)a,a+=2,tmp));
t64=C_mutate((C_word*)lf[78]+1 /* (set! file-change-time ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4025,tmp=(C_word)a,a+=2,tmp));
t65=C_mutate((C_word*)lf[79]+1 /* (set! file-owner ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4031,tmp=(C_word)a,a+=2,tmp));
t66=C_mutate((C_word*)lf[80]+1 /* (set! file-permissions ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4037,tmp=(C_word)a,a+=2,tmp));
t67=C_mutate((C_word*)lf[81]+1 /* (set! regular-file? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4043,tmp=(C_word)a,a+=2,tmp));
t68=C_mutate((C_word*)lf[82]+1 /* (set! symbolic-link? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4052,tmp=(C_word)a,a+=2,tmp));
t69=C_mutate((C_word*)lf[83]+1 /* (set! stat-regular? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4061,tmp=(C_word)a,a+=2,tmp));
t70=C_mutate((C_word*)lf[84]+1 /* (set! stat-directory? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4070,tmp=(C_word)a,a+=2,tmp));
t71=C_mutate((C_word*)lf[85]+1 /* (set! character-device? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4079,tmp=(C_word)a,a+=2,tmp));
t72=C_mutate((C_word*)lf[86]+1 /* (set! stat-char-device? ...) */,*((C_word*)lf[85]+1));
t73=C_mutate((C_word*)lf[87]+1 /* (set! block-device? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4089,tmp=(C_word)a,a+=2,tmp));
t74=C_mutate((C_word*)lf[88]+1 /* (set! stat-block-device? ...) */,*((C_word*)lf[87]+1));
t75=C_mutate((C_word*)lf[89]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4099,tmp=(C_word)a,a+=2,tmp));
t76=C_mutate((C_word*)lf[90]+1 /* (set! stat-fifo? ...) */,*((C_word*)lf[89]+1));
t77=C_mutate((C_word*)lf[91]+1 /* (set! stat-symlink? ...) */,*((C_word*)lf[82]+1));
t78=C_mutate((C_word*)lf[92]+1 /* (set! socket? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4110,tmp=(C_word)a,a+=2,tmp));
t79=C_mutate((C_word*)lf[93]+1 /* (set! stat-socket? ...) */,*((C_word*)lf[92]+1));
t80=C_mutate((C_word*)lf[94]+1 /* (set! set-file-position! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4120,tmp=(C_word)a,a+=2,tmp));
t81=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4180,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t82=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_9124,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 845  getter-with-setter */
t83=*((C_word*)lf[452]+1);
((C_proc4)(void*)(*((C_word*)t83+1)))(4,t83,t81,t82,*((C_word*)lf[94]+1));}

/* a9123 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9124(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_9124,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9128,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9140,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 847  port? */
t5=*((C_word*)lf[98]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k9138 in a9123 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9140(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(t2,lf[96]);
t4=((C_word*)t0)[2];
f_9128(2,t4,(C_truep(t3)?(C_word)C_ftell(((C_word*)t0)[3]):C_fix(-1)));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
f_9128(2,t2,(C_word)C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
/* posixunix.scm: 852  ##sys#signal-hook */
t2=*((C_word*)lf[2]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[57],lf[101],lf[463],((C_word*)t0)[3]);}}}

/* k9126 in a9123 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9128(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9128,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9131,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 854  posix-error */
t3=lf[1];
f_3480(6,t3,t2,lf[46],lf[101],lf[462],((C_word*)t0)[2]);}
else{
t3=t2;
f_9131(2,t3,C_SCHEME_UNDEFINED);}}

/* k9129 in k9126 in a9123 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9131(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4180(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word ab[150],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4180,2,t0,t1);}
t2=C_mutate((C_word*)lf[101]+1 /* (set! file-position ...) */,t1);
t3=C_mutate((C_word*)lf[102]+1 /* (set! create-directory ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4182,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate((C_word*)lf[111]+1 /* (set! change-directory ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4277,tmp=(C_word)a,a+=2,tmp));
t5=C_mutate((C_word*)lf[113]+1 /* (set! delete-directory ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4301,tmp=(C_word)a,a+=2,tmp));
t6=*((C_word*)lf[115]+1);
t7=*((C_word*)lf[54]+1);
t8=*((C_word*)lf[116]+1);
t9=C_mutate((C_word*)lf[117]+1 /* (set! directory ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4325,a[2]=t7,a[3]=t6,tmp=(C_word)a,a+=4,tmp));
t10=C_mutate((C_word*)lf[121]+1 /* (set! directory? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4479,tmp=(C_word)a,a+=2,tmp));
t11=*((C_word*)lf[54]+1);
t12=C_mutate((C_word*)lf[120]+1 /* (set! current-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4502,a[2]=t11,tmp=(C_word)a,a+=3,tmp));
t13=*((C_word*)lf[124]+1);
t14=*((C_word*)lf[125]+1);
t15=*((C_word*)lf[126]+1);
t16=*((C_word*)lf[127]+1);
t17=*((C_word*)lf[115]+1);
t18=*((C_word*)lf[0]+1);
t19=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4543,tmp=(C_word)a,a+=2,tmp);
t20=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4548,tmp=(C_word)a,a+=2,tmp);
t21=*((C_word*)lf[130]+1);
t22=*((C_word*)lf[131]+1);
t23=*((C_word*)lf[120]+1);
t24=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4559,a[2]=t23,tmp=(C_word)a,a+=3,tmp);
t25=C_mutate((C_word*)lf[136]+1 /* (set! canonical-path ...) */,(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4615,a[2]=t16,a[3]=t14,a[4]=t21,a[5]=t22,a[6]=t24,a[7]=t15,a[8]=t13,a[9]=t17,a[10]=t19,a[11]=t18,a[12]=t20,tmp=(C_word)a,a+=13,tmp));
t26=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4932,tmp=(C_word)a,a+=2,tmp);
t27=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4944,tmp=(C_word)a,a+=2,tmp);
t28=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4950,tmp=(C_word)a,a+=2,tmp);
t29=C_mutate((C_word*)lf[158]+1 /* (set! open-input-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4965,a[2]=t27,a[3]=t28,a[4]=t26,tmp=(C_word)a,a+=5,tmp));
t30=C_mutate((C_word*)lf[160]+1 /* (set! open-output-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5001,a[2]=t27,a[3]=t28,a[4]=t26,tmp=(C_word)a,a+=5,tmp));
t31=C_mutate((C_word*)lf[161]+1 /* (set! close-input-pipe ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5037,tmp=(C_word)a,a+=2,tmp));
t32=C_mutate((C_word*)lf[165]+1 /* (set! close-output-pipe ...) */,*((C_word*)lf[161]+1));
t33=*((C_word*)lf[158]+1);
t34=*((C_word*)lf[160]+1);
t35=*((C_word*)lf[161]+1);
t36=*((C_word*)lf[165]+1);
t37=C_mutate((C_word*)lf[166]+1 /* (set! call-with-input-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5053,a[2]=t33,a[3]=t35,tmp=(C_word)a,a+=4,tmp));
t38=C_mutate((C_word*)lf[167]+1 /* (set! call-with-output-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5077,a[2]=t34,a[3]=t36,tmp=(C_word)a,a+=4,tmp));
t39=C_mutate((C_word*)lf[168]+1 /* (set! with-input-from-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5101,a[2]=t33,a[3]=t35,tmp=(C_word)a,a+=4,tmp));
t40=C_mutate((C_word*)lf[170]+1 /* (set! with-output-to-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5121,a[2]=t34,a[3]=t36,tmp=(C_word)a,a+=4,tmp));
t41=C_mutate((C_word*)lf[172]+1 /* (set! create-pipe ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5141,tmp=(C_word)a,a+=2,tmp));
t42=C_mutate((C_word*)lf[174]+1 /* (set! signal/term ...) */,C_fix((C_word)SIGTERM));
t43=C_mutate((C_word*)lf[175]+1 /* (set! signal/kill ...) */,C_fix((C_word)SIGKILL));
t44=C_mutate((C_word*)lf[176]+1 /* (set! signal/int ...) */,C_fix((C_word)SIGINT));
t45=C_mutate((C_word*)lf[177]+1 /* (set! signal/hup ...) */,C_fix((C_word)SIGHUP));
t46=C_mutate((C_word*)lf[178]+1 /* (set! signal/fpe ...) */,C_fix((C_word)SIGFPE));
t47=C_mutate((C_word*)lf[179]+1 /* (set! signal/ill ...) */,C_fix((C_word)SIGILL));
t48=C_mutate((C_word*)lf[180]+1 /* (set! signal/segv ...) */,C_fix((C_word)SIGSEGV));
t49=C_mutate((C_word*)lf[181]+1 /* (set! signal/abrt ...) */,C_fix((C_word)SIGABRT));
t50=C_mutate((C_word*)lf[182]+1 /* (set! signal/trap ...) */,C_fix((C_word)SIGTRAP));
t51=C_mutate((C_word*)lf[183]+1 /* (set! signal/quit ...) */,C_fix((C_word)SIGQUIT));
t52=C_mutate((C_word*)lf[184]+1 /* (set! signal/alrm ...) */,C_fix((C_word)SIGALRM));
t53=C_mutate((C_word*)lf[185]+1 /* (set! signal/vtalrm ...) */,C_fix((C_word)SIGVTALRM));
t54=C_mutate((C_word*)lf[186]+1 /* (set! signal/prof ...) */,C_fix((C_word)SIGPROF));
t55=C_mutate((C_word*)lf[187]+1 /* (set! signal/io ...) */,C_fix((C_word)SIGIO));
t56=C_mutate((C_word*)lf[188]+1 /* (set! signal/urg ...) */,C_fix((C_word)SIGURG));
t57=C_mutate((C_word*)lf[189]+1 /* (set! signal/chld ...) */,C_fix((C_word)SIGCHLD));
t58=C_mutate((C_word*)lf[190]+1 /* (set! signal/cont ...) */,C_fix((C_word)SIGCONT));
t59=C_mutate((C_word*)lf[191]+1 /* (set! signal/stop ...) */,C_fix((C_word)SIGSTOP));
t60=C_mutate((C_word*)lf[192]+1 /* (set! signal/tstp ...) */,C_fix((C_word)SIGTSTP));
t61=C_mutate((C_word*)lf[193]+1 /* (set! signal/pipe ...) */,C_fix((C_word)SIGPIPE));
t62=C_mutate((C_word*)lf[194]+1 /* (set! signal/xcpu ...) */,C_fix((C_word)SIGXCPU));
t63=C_mutate((C_word*)lf[195]+1 /* (set! signal/xfsz ...) */,C_fix((C_word)SIGXFSZ));
t64=C_mutate((C_word*)lf[196]+1 /* (set! signal/usr1 ...) */,C_fix((C_word)SIGUSR1));
t65=C_mutate((C_word*)lf[197]+1 /* (set! signal/usr2 ...) */,C_fix((C_word)SIGUSR2));
t66=C_mutate((C_word*)lf[198]+1 /* (set! signal/winch ...) */,C_fix((C_word)SIGWINCH));
t67=(C_word)C_a_i_list(&a,25,*((C_word*)lf[174]+1),*((C_word*)lf[175]+1),*((C_word*)lf[176]+1),*((C_word*)lf[177]+1),*((C_word*)lf[178]+1),*((C_word*)lf[179]+1),*((C_word*)lf[180]+1),*((C_word*)lf[181]+1),*((C_word*)lf[182]+1),*((C_word*)lf[183]+1),*((C_word*)lf[184]+1),*((C_word*)lf[185]+1),*((C_word*)lf[186]+1),*((C_word*)lf[187]+1),*((C_word*)lf[188]+1),*((C_word*)lf[189]+1),*((C_word*)lf[190]+1),*((C_word*)lf[191]+1),*((C_word*)lf[192]+1),*((C_word*)lf[193]+1),*((C_word*)lf[194]+1),*((C_word*)lf[195]+1),*((C_word*)lf[196]+1),*((C_word*)lf[197]+1),*((C_word*)lf[198]+1));
t68=C_mutate((C_word*)lf[199]+1 /* (set! signals-list ...) */,t67);
t69=*((C_word*)lf[200]+1);
t70=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5186,a[2]=((C_word*)t0)[2],a[3]=t69,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1175 make-vector */
t71=*((C_word*)lf[461]+1);
((C_proc4)(void*)(*((C_word*)t71+1)))(4,t71,t70,C_fix(256),C_SCHEME_FALSE);}

/* k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5186(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[25],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5186,2,t0,t1);}
t2=C_mutate((C_word*)lf[201]+1 /* (set! signal-handler ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5188,a[2]=t1,tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[202]+1 /* (set! set-signal-handler! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5197,a[2]=t1,tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[200]+1 /* (set! interrupt-hook ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5210,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t5=C_mutate((C_word*)lf[203]+1 /* (set! set-signal-mask! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5228,tmp=(C_word)a,a+=2,tmp));
t6=C_mutate((C_word*)lf[206]+1 /* (set! signal-mask ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5252,tmp=(C_word)a,a+=2,tmp));
t7=C_mutate((C_word*)lf[207]+1 /* (set! signal-masked? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5284,tmp=(C_word)a,a+=2,tmp));
t8=C_mutate((C_word*)lf[208]+1 /* (set! signal-mask! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5290,tmp=(C_word)a,a+=2,tmp));
t9=C_mutate((C_word*)lf[210]+1 /* (set! signal-unmask! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5305,tmp=(C_word)a,a+=2,tmp));
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5321,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t11=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_9118,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 1231 set-signal-handler! */
t12=*((C_word*)lf[202]+1);
((C_proc4)(void*)(*((C_word*)t12+1)))(4,t12,t10,*((C_word*)lf[176]+1),t11);}

/* a9117 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9118(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_9118,3,t0,t1,t2);}
/* posixunix.scm: 1233 ##sys#user-interrupt-hook */
t3=*((C_word*)lf[460]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5321(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5321,2,t0,t1);}
t2=C_mutate((C_word*)lf[212]+1 /* (set! system-information ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5323,tmp=(C_word)a,a+=2,tmp));
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5363,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_9100,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_9103,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 1257 getter-with-setter */
t6=*((C_word*)lf[452]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,t4,t5);}

/* a9102 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9103(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_9103,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9113,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1261 ##sys#update-errno */
t4=*((C_word*)lf[5]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k9111 in a9102 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9113(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1262 ##sys#error */
t2=*((C_word*)lf[152]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[455],lf[459],((C_word*)t0)[2]);}

/* a9099 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9100(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9100,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub1107(C_SCHEME_UNDEFINED));}

/* k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5363(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5363,2,t0,t1);}
t2=C_mutate((C_word*)lf[215]+1 /* (set! current-user-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5367,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_9082,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_9085,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 1265 getter-with-setter */
t6=*((C_word*)lf[452]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,t4,t5);}

/* a9084 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9085(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_9085,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_seteuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9095,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1269 ##sys#update-errno */
t4=*((C_word*)lf[5]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k9093 in a9084 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9095(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1270 ##sys#error */
t2=*((C_word*)lf[152]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[457],lf[458],((C_word*)t0)[2]);}

/* a9081 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9082(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9082,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub1116(C_SCHEME_UNDEFINED));}

/* k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5367(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5367,2,t0,t1);}
t2=C_mutate((C_word*)lf[216]+1 /* (set! current-effective-user-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5371,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_9064,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_9067,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 1274 getter-with-setter */
t6=*((C_word*)lf[452]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,t4,t5);}

/* a9066 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9067(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_9067,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setgid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9077,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1278 ##sys#update-errno */
t4=*((C_word*)lf[5]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k9075 in a9066 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9077(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1279 ##sys#error */
t2=*((C_word*)lf[152]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[455],lf[456],((C_word*)t0)[2]);}

/* a9063 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9064(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9064,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub1125(C_SCHEME_UNDEFINED));}

/* k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5371(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5371,2,t0,t1);}
t2=C_mutate((C_word*)lf[217]+1 /* (set! current-group-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5375,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_9046,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_9049,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 1282 getter-with-setter */
t6=*((C_word*)lf[452]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,t4,t5);}

/* a9048 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9049(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_9049,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setegid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9059,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1286 ##sys#update-errno */
t4=*((C_word*)lf[5]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k9057 in a9048 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9059(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1287 ##sys#error */
t2=*((C_word*)lf[152]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[453],lf[454],((C_word*)t0)[2]);}

/* a9045 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9046(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_9046,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub1134(C_SCHEME_UNDEFINED));}

/* k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5375(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word ab[40],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5375,2,t0,t1);}
t2=C_mutate((C_word*)lf[218]+1 /* (set! current-effective-group-id ...) */,t1);
t3=C_mutate((C_word*)lf[219]+1 /* (set! user-information ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5377,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate((C_word*)lf[131]+1 /* (set! current-user-name ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5437,tmp=(C_word)a,a+=2,tmp));
t5=C_mutate((C_word*)lf[222]+1 /* (set! current-effective-user-name ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5451,tmp=(C_word)a,a+=2,tmp));
t6=C_mutate((C_word*)lf[223]+1 /* (set! group-information ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5471,tmp=(C_word)a,a+=2,tmp));
t7=C_mutate(&lf[224] /* (set! _ensure-groups ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5546,tmp=(C_word)a,a+=2,tmp));
t8=C_mutate((C_word*)lf[225]+1 /* (set! get-groups ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5549,tmp=(C_word)a,a+=2,tmp));
t9=C_mutate((C_word*)lf[229]+1 /* (set! set-groups! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5612,tmp=(C_word)a,a+=2,tmp));
t10=C_mutate((C_word*)lf[232]+1 /* (set! initialize-groups ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5678,tmp=(C_word)a,a+=2,tmp));
t11=C_mutate((C_word*)lf[234]+1 /* (set! errno/perm ...) */,C_fix((C_word)EPERM));
t12=C_mutate((C_word*)lf[235]+1 /* (set! errno/noent ...) */,C_fix((C_word)ENOENT));
t13=C_mutate((C_word*)lf[236]+1 /* (set! errno/srch ...) */,C_fix((C_word)ESRCH));
t14=C_mutate((C_word*)lf[237]+1 /* (set! errno/intr ...) */,C_fix((C_word)EINTR));
t15=C_mutate((C_word*)lf[238]+1 /* (set! errno/io ...) */,C_fix((C_word)EIO));
t16=C_mutate((C_word*)lf[239]+1 /* (set! errno/noexec ...) */,C_fix((C_word)ENOEXEC));
t17=C_mutate((C_word*)lf[240]+1 /* (set! errno/badf ...) */,C_fix((C_word)EBADF));
t18=C_mutate((C_word*)lf[241]+1 /* (set! errno/child ...) */,C_fix((C_word)ECHILD));
t19=C_mutate((C_word*)lf[242]+1 /* (set! errno/nomem ...) */,C_fix((C_word)ENOMEM));
t20=C_mutate((C_word*)lf[243]+1 /* (set! errno/acces ...) */,C_fix((C_word)EACCES));
t21=C_mutate((C_word*)lf[244]+1 /* (set! errno/fault ...) */,C_fix((C_word)EFAULT));
t22=C_mutate((C_word*)lf[245]+1 /* (set! errno/busy ...) */,C_fix((C_word)EBUSY));
t23=C_mutate((C_word*)lf[246]+1 /* (set! errno/notdir ...) */,C_fix((C_word)ENOTDIR));
t24=C_mutate((C_word*)lf[247]+1 /* (set! errno/isdir ...) */,C_fix((C_word)EISDIR));
t25=C_mutate((C_word*)lf[248]+1 /* (set! errno/inval ...) */,C_fix((C_word)EINVAL));
t26=C_mutate((C_word*)lf[249]+1 /* (set! errno/mfile ...) */,C_fix((C_word)EMFILE));
t27=C_mutate((C_word*)lf[250]+1 /* (set! errno/nospc ...) */,C_fix((C_word)ENOSPC));
t28=C_mutate((C_word*)lf[251]+1 /* (set! errno/spipe ...) */,C_fix((C_word)ESPIPE));
t29=C_mutate((C_word*)lf[252]+1 /* (set! errno/pipe ...) */,C_fix((C_word)EPIPE));
t30=C_mutate((C_word*)lf[253]+1 /* (set! errno/again ...) */,C_fix((C_word)EAGAIN));
t31=C_mutate((C_word*)lf[254]+1 /* (set! errno/rofs ...) */,C_fix((C_word)EROFS));
t32=C_mutate((C_word*)lf[255]+1 /* (set! errno/exist ...) */,C_fix((C_word)EEXIST));
t33=C_mutate((C_word*)lf[256]+1 /* (set! errno/wouldblock ...) */,C_fix((C_word)EWOULDBLOCK));
t34=C_set_block_item(lf[257] /* errno/2big */,0,C_fix(0));
t35=C_set_block_item(lf[258] /* errno/deadlk */,0,C_fix(0));
t36=C_set_block_item(lf[259] /* errno/dom */,0,C_fix(0));
t37=C_set_block_item(lf[260] /* errno/fbig */,0,C_fix(0));
t38=C_set_block_item(lf[261] /* errno/ilseq */,0,C_fix(0));
t39=C_set_block_item(lf[262] /* errno/mlink */,0,C_fix(0));
t40=C_set_block_item(lf[263] /* errno/nametoolong */,0,C_fix(0));
t41=C_set_block_item(lf[264] /* errno/nfile */,0,C_fix(0));
t42=C_set_block_item(lf[265] /* errno/nodev */,0,C_fix(0));
t43=C_set_block_item(lf[266] /* errno/nolck */,0,C_fix(0));
t44=C_set_block_item(lf[267] /* errno/nosys */,0,C_fix(0));
t45=C_set_block_item(lf[268] /* errno/notempty */,0,C_fix(0));
t46=C_set_block_item(lf[269] /* errno/notty */,0,C_fix(0));
t47=C_set_block_item(lf[270] /* errno/nxio */,0,C_fix(0));
t48=C_set_block_item(lf[271] /* errno/range */,0,C_fix(0));
t49=C_set_block_item(lf[272] /* errno/xdev */,0,C_fix(0));
t50=C_mutate((C_word*)lf[273]+1 /* (set! change-file-mode ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5742,tmp=(C_word)a,a+=2,tmp));
t51=C_mutate((C_word*)lf[275]+1 /* (set! change-file-owner ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5769,tmp=(C_word)a,a+=2,tmp));
t52=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5799,tmp=(C_word)a,a+=2,tmp);
t53=C_mutate((C_word*)lf[277]+1 /* (set! file-read-access? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5823,a[2]=t52,tmp=(C_word)a,a+=3,tmp));
t54=C_mutate((C_word*)lf[278]+1 /* (set! file-write-access? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5829,a[2]=t52,tmp=(C_word)a,a+=3,tmp));
t55=C_mutate((C_word*)lf[279]+1 /* (set! file-execute-access? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5835,a[2]=t52,tmp=(C_word)a,a+=3,tmp));
t56=C_mutate((C_word*)lf[280]+1 /* (set! create-session ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5841,tmp=(C_word)a,a+=2,tmp));
t57=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5858,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t58=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_9007,tmp=(C_word)a,a+=2,tmp);
t59=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_9025,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 1502 getter-with-setter */
t60=*((C_word*)lf[452]+1);
((C_proc4)(void*)(*((C_word*)t60+1)))(4,t60,t57,t58,t59);}

/* a9024 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9025(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_9025,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[450]);
t5=(C_word)C_i_check_exact_2(t3,lf[450]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setpgid(t2,t3),C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_9041,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1514 ##sys#update-errno */
t7=*((C_word*)lf[5]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* k9039 in a9024 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9041(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1515 ##sys#error */
t2=*((C_word*)lf[152]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[450],lf[451],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a9006 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9007(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_9007,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[282]);
t4=(C_word)C_getpgid(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9014,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t4,C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_9020,a[2]=t2,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1507 ##sys#update-errno */
t7=*((C_word*)lf[5]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=t5;
f_9014(2,t6,C_SCHEME_UNDEFINED);}}

/* k9018 in a9006 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9020(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1508 ##sys#error */
t2=*((C_word*)lf[152]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[282],lf[449],((C_word*)t0)[2]);}

/* k9012 in a9006 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_9014(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5858(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5858,2,t0,t1);}
t2=C_mutate((C_word*)lf[282]+1 /* (set! process-group-id ...) */,t1);
t3=C_mutate((C_word*)lf[283]+1 /* (set! create-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5860,tmp=(C_word)a,a+=2,tmp));
t4=*((C_word*)lf[286]+1);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5897,a[2]=((C_word*)t0)[2],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=(C_word)C_u_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
/* posixunix.scm: 1535 make-string */
t7=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t5,t6);}

/* k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5897(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word ab[190],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5897,2,t0,t1);}
t2=C_mutate((C_word*)lf[287]+1 /* (set! read-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5898,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[290]+1 /* (set! file-link ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5967,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate((C_word*)lf[293]+1 /* (set! fileno/stdin ...) */,C_fix((C_word)STDIN_FILENO));
t5=C_mutate((C_word*)lf[294]+1 /* (set! fileno/stdout ...) */,C_fix((C_word)STDOUT_FILENO));
t6=C_mutate((C_word*)lf[295]+1 /* (set! fileno/stderr ...) */,C_fix((C_word)STDERR_FILENO));
t7=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5992,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6029,tmp=(C_word)a,a+=2,tmp);
t9=C_mutate((C_word*)lf[304]+1 /* (set! open-input-file* ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6044,a[2]=t7,a[3]=t8,tmp=(C_word)a,a+=4,tmp));
t10=C_mutate((C_word*)lf[305]+1 /* (set! open-output-file* ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6058,a[2]=t7,a[3]=t8,tmp=(C_word)a,a+=4,tmp));
t11=C_mutate((C_word*)lf[306]+1 /* (set! port->fileno ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6072,tmp=(C_word)a,a+=2,tmp));
t12=C_mutate((C_word*)lf[312]+1 /* (set! duplicate-fileno ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6117,tmp=(C_word)a,a+=2,tmp));
t13=*((C_word*)lf[314]+1);
t14=*((C_word*)lf[315]+1);
t15=C_mutate((C_word*)lf[316]+1 /* (set! custom-input-port ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6144,a[2]=t13,a[3]=t14,tmp=(C_word)a,a+=4,tmp));
t16=*((C_word*)lf[329]+1);
t17=*((C_word*)lf[315]+1);
t18=C_mutate((C_word*)lf[330]+1 /* (set! custom-output-port ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6623,a[2]=t16,a[3]=t17,tmp=(C_word)a,a+=4,tmp));
t19=C_mutate((C_word*)lf[333]+1 /* (set! file-truncate ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6879,tmp=(C_word)a,a+=2,tmp));
t20=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6918,tmp=(C_word)a,a+=2,tmp);
t21=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6989,tmp=(C_word)a,a+=2,tmp);
t22=C_mutate((C_word*)lf[337]+1 /* (set! file-lock ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7007,a[2]=t20,a[3]=t21,tmp=(C_word)a,a+=4,tmp));
t23=C_mutate((C_word*)lf[339]+1 /* (set! file-lock/blocking ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7022,a[2]=t20,a[3]=t21,tmp=(C_word)a,a+=4,tmp));
t24=C_mutate((C_word*)lf[341]+1 /* (set! file-test-lock ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7037,a[2]=t20,a[3]=t21,tmp=(C_word)a,a+=4,tmp));
t25=C_mutate((C_word*)lf[343]+1 /* (set! file-unlock ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7059,tmp=(C_word)a,a+=2,tmp));
t26=C_mutate((C_word*)lf[345]+1 /* (set! create-fifo ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7087,tmp=(C_word)a,a+=2,tmp));
t27=C_mutate((C_word*)lf[89]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7130,tmp=(C_word)a,a+=2,tmp));
t28=C_mutate((C_word*)lf[348]+1 /* (set! setenv ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7156,tmp=(C_word)a,a+=2,tmp));
t29=C_mutate((C_word*)lf[349]+1 /* (set! unsetenv ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7173,tmp=(C_word)a,a+=2,tmp));
t30=C_mutate((C_word*)lf[350]+1 /* (set! get-environment-variables ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7188,tmp=(C_word)a,a+=2,tmp));
t31=C_mutate((C_word*)lf[351]+1 /* (set! current-environment ...) */,*((C_word*)lf[350]+1));
t32=C_mutate((C_word*)lf[352]+1 /* (set! prot/read ...) */,C_fix((C_word)PROT_READ));
t33=C_mutate((C_word*)lf[353]+1 /* (set! prot/write ...) */,C_fix((C_word)PROT_WRITE));
t34=C_mutate((C_word*)lf[354]+1 /* (set! prot/exec ...) */,C_fix((C_word)PROT_EXEC));
t35=C_mutate((C_word*)lf[355]+1 /* (set! prot/none ...) */,C_fix((C_word)PROT_NONE));
t36=C_mutate((C_word*)lf[356]+1 /* (set! map/fixed ...) */,C_fix((C_word)MAP_FIXED));
t37=C_mutate((C_word*)lf[357]+1 /* (set! map/shared ...) */,C_fix((C_word)MAP_SHARED));
t38=C_mutate((C_word*)lf[358]+1 /* (set! map/private ...) */,C_fix((C_word)MAP_PRIVATE));
t39=C_mutate((C_word*)lf[359]+1 /* (set! map/anonymous ...) */,C_fix((C_word)MAP_ANON));
t40=C_mutate((C_word*)lf[360]+1 /* (set! map/file ...) */,C_fix((C_word)MAP_FILE));
t41=C_mutate((C_word*)lf[361]+1 /* (set! map-file-to-memory ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7272,tmp=(C_word)a,a+=2,tmp));
t42=C_mutate((C_word*)lf[367]+1 /* (set! unmap-file-from-memory ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7330,tmp=(C_word)a,a+=2,tmp));
t43=C_mutate((C_word*)lf[369]+1 /* (set! memory-mapped-file-pointer ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7365,tmp=(C_word)a,a+=2,tmp));
t44=C_mutate((C_word*)lf[370]+1 /* (set! memory-mapped-file? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7374,tmp=(C_word)a,a+=2,tmp));
t45=C_mutate(&lf[371] /* (set! check-time-vector ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7380,tmp=(C_word)a,a+=2,tmp));
t46=C_mutate((C_word*)lf[373]+1 /* (set! seconds->local-time ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7399,tmp=(C_word)a,a+=2,tmp));
t47=C_mutate((C_word*)lf[375]+1 /* (set! seconds->utc-time ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7408,tmp=(C_word)a,a+=2,tmp));
t48=C_mutate((C_word*)lf[376]+1 /* (set! seconds->string ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7422,tmp=(C_word)a,a+=2,tmp));
t49=C_mutate((C_word*)lf[378]+1 /* (set! time->string ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7458,tmp=(C_word)a,a+=2,tmp));
t50=C_mutate((C_word*)lf[381]+1 /* (set! string->time ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7520,tmp=(C_word)a,a+=2,tmp));
t51=C_mutate((C_word*)lf[383]+1 /* (set! local-time->seconds ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7559,tmp=(C_word)a,a+=2,tmp));
t52=C_mutate((C_word*)lf[386]+1 /* (set! utc-time->seconds ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7574,tmp=(C_word)a,a+=2,tmp));
t53=C_mutate((C_word*)lf[388]+1 /* (set! local-timezone-abbreviation ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7589,tmp=(C_word)a,a+=2,tmp));
t54=C_mutate((C_word*)lf[389]+1 /* (set! _exit ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7597,tmp=(C_word)a,a+=2,tmp));
t55=C_mutate((C_word*)lf[390]+1 /* (set! set-alarm! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7613,tmp=(C_word)a,a+=2,tmp));
t56=C_mutate((C_word*)lf[391]+1 /* (set! set-buffering-mode! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7616,tmp=(C_word)a,a+=2,tmp));
t57=C_mutate((C_word*)lf[397]+1 /* (set! terminal-port? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7675,tmp=(C_word)a,a+=2,tmp));
t58=C_mutate(&lf[398] /* (set! terminal-check ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7694,tmp=(C_word)a,a+=2,tmp));
t59=C_mutate((C_word*)lf[400]+1 /* (set! terminal-name ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7721,tmp=(C_word)a,a+=2,tmp));
t60=C_mutate((C_word*)lf[401]+1 /* (set! terminal-size ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7740,tmp=(C_word)a,a+=2,tmp));
t61=C_mutate((C_word*)lf[406]+1 /* (set! get-host-name ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7775,tmp=(C_word)a,a+=2,tmp));
t62=*((C_word*)lf[408]+1);
t63=*((C_word*)lf[409]+1);
t64=*((C_word*)lf[410]+1);
t65=*((C_word*)lf[117]+1);
t66=*((C_word*)lf[411]+1);
t67=*((C_word*)lf[412]+1);
t68=C_mutate((C_word*)lf[413]+1 /* (set! glob ...) */,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7787,a[2]=t64,a[3]=t62,a[4]=t65,a[5]=t63,a[6]=t66,a[7]=t67,tmp=(C_word)a,a+=8,tmp));
t69=C_mutate((C_word*)lf[416]+1 /* (set! process-fork ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7896,tmp=(C_word)a,a+=2,tmp));
t70=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7934,tmp=(C_word)a,a+=2,tmp);
t71=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7942,tmp=(C_word)a,a+=2,tmp);
t72=*((C_word*)lf[418]+1);
t73=C_mutate((C_word*)lf[419]+1 /* (set! process-execute ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7950,a[2]=t72,a[3]=t71,a[4]=t70,tmp=(C_word)a,a+=5,tmp));
t74=C_mutate((C_word*)lf[421]+1 /* (set! process-wait ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_8129,tmp=(C_word)a,a+=2,tmp));
t75=C_mutate((C_word*)lf[422]+1 /* (set! process-wait ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_8146,tmp=(C_word)a,a+=2,tmp));
t76=C_mutate((C_word*)lf[424]+1 /* (set! current-process-id ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_8221,tmp=(C_word)a,a+=2,tmp));
t77=C_mutate((C_word*)lf[425]+1 /* (set! parent-process-id ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_8224,tmp=(C_word)a,a+=2,tmp));
t78=C_mutate((C_word*)lf[426]+1 /* (set! sleep ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_8227,tmp=(C_word)a,a+=2,tmp));
t79=C_mutate((C_word*)lf[427]+1 /* (set! process-signal ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_8230,tmp=(C_word)a,a+=2,tmp));
t80=C_mutate((C_word*)lf[429]+1 /* (set! shell-command ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_8257,tmp=(C_word)a,a+=2,tmp));
t81=C_mutate((C_word*)lf[432]+1 /* (set! shell-command-arguments ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_8266,tmp=(C_word)a,a+=2,tmp));
t82=*((C_word*)lf[416]+1);
t83=*((C_word*)lf[419]+1);
t84=C_mutate((C_word*)lf[434]+1 /* (set! process-run ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8272,a[2]=t82,a[3]=t83,tmp=(C_word)a,a+=4,tmp));
t85=*((C_word*)lf[172]+1);
t86=*((C_word*)lf[422]+1);
t87=*((C_word*)lf[416]+1);
t88=*((C_word*)lf[419]+1);
t89=*((C_word*)lf[312]+1);
t90=*((C_word*)lf[52]+1);
t91=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8328,a[2]=t86,tmp=(C_word)a,a+=3,tmp);
t92=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8365,a[2]=t85,tmp=(C_word)a,a+=3,tmp);
t93=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8385,a[2]=t90,tmp=(C_word)a,a+=3,tmp);
t94=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8399,a[2]=t90,tmp=(C_word)a,a+=3,tmp);
t95=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_8416,tmp=(C_word)a,a+=2,tmp);
t96=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_8432,a[2]=t92,a[3]=t87,a[4]=t94,a[5]=t88,a[6]=t95,tmp=(C_word)a,a+=7,tmp);
t97=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8477,a[2]=t93,tmp=(C_word)a,a+=3,tmp);
t98=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8488,a[2]=t93,tmp=(C_word)a,a+=3,tmp);
t99=C_mutate((C_word*)lf[436]+1 /* (set! process ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8499,a[2]=t98,a[3]=t91,a[4]=t97,a[5]=t96,tmp=(C_word)a,a+=6,tmp));
t100=C_set_block_item(lf[437] /* process */,0,C_SCHEME_UNDEFINED);
t101=C_set_block_item(lf[438] /* process* */,0,C_SCHEME_UNDEFINED);
t102=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_8557,tmp=(C_word)a,a+=2,tmp);
t103=C_mutate((C_word*)lf[437]+1 /* (set! process ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8618,a[2]=t102,tmp=(C_word)a,a+=3,tmp));
t104=C_mutate((C_word*)lf[438]+1 /* (set! process* ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8675,a[2]=t102,tmp=(C_word)a,a+=3,tmp));
t105=*((C_word*)lf[413]+1);
t106=*((C_word*)lf[409]+1);
t107=*((C_word*)lf[411]+1);
t108=*((C_word*)lf[121]+1);
t109=C_mutate((C_word*)lf[439]+1 /* (set! find-files ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8732,a[2]=t108,a[3]=t107,a[4]=t105,a[5]=t106,tmp=(C_word)a,a+=6,tmp));
t110=C_mutate((C_word*)lf[447]+1 /* (set! set-root-directory! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_8984,tmp=(C_word)a,a+=2,tmp));
t111=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t111+1)))(2,t111,C_SCHEME_UNDEFINED);}

/* set-root-directory! in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8984(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8984,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[447]);
t4=t2;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8980,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t4)){
/* ##sys#make-c-string */
t6=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t4);}
else{
t6=t5;
f_8980(2,t6,C_SCHEME_FALSE);}}

/* k8978 in set-root-directory! in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8980(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)stub3185(C_SCHEME_UNDEFINED,t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 2399 posix-error */
t3=lf[1];
f_3480(6,t3,((C_word*)t0)[3],lf[46],lf[447],lf[448],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8732(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr4r,(void*)f_8732r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_8732r(t0,t1,t2,t3,t4);}}

static void C_ccall f_8732r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(17);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8734,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=t2,tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8899,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8904,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8909,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-action30753166 */
t9=t8;
f_8909(t9,t1);}
else{
t9=(C_word)C_u_i_car(t4);
t10=(C_word)C_slot(t4,C_fix(1));
if(C_truep((C_word)C_i_nullp(t10))){
/* def-id30763162 */
t11=t7;
f_8904(t11,t1,t9);}
else{
t11=(C_word)C_u_i_car(t10);
t12=(C_word)C_slot(t10,C_fix(1));
if(C_truep((C_word)C_i_nullp(t12))){
/* def-limit30773157 */
t13=t6;
f_8899(t13,t1,t9,t11);}
else{
t13=(C_word)C_u_i_car(t12);
t14=(C_word)C_slot(t12,C_fix(1));
/* body30733083 */
t15=t5;
f_8734(t15,t1,t9,t11,t13);}}}}

/* def-action3075 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8909(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8909,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_8915,tmp=(C_word)a,a+=2,tmp);
/* def-id30763162 */
t3=((C_word*)t0)[2];
f_8904(t3,t1,t2);}

/* a8914 in def-action3075 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8915(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_8915,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* def-id3076 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8904(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8904,NULL,3,t0,t1,t2);}
/* def-limit30773157 */
t3=((C_word*)t0)[2];
f_8899(t3,t1,t2,C_SCHEME_END_OF_LIST);}

/* def-limit3077 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8899(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8899,NULL,4,t0,t1,t2,t3);}
/* body30733083 */
t4=((C_word*)t0)[2];
f_8734(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8734(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8734,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(((C_word*)t0)[7],lf[439]);
t6=C_fix(0);
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_8741,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=t2,a[9]=t7,a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],tmp=(C_word)a,a+=12,tmp);
t9=t4;
if(C_truep(t9)){
t10=(C_word)C_fixnump(t4);
t11=t8;
f_8741(t11,(C_truep(t10)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8894,a[2]=t4,a[3]=t7,tmp=(C_word)a,a+=4,tmp):t4));}
else{
t10=t8;
f_8741(t10,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_8886,tmp=(C_word)a,a+=2,tmp));}}

/* f_8886 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8886(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8886,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_8894 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8894(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8894,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8741(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8741,NULL,2,t0,t1);}
t2=(C_word)C_i_stringp(((C_word*)t0)[11]);
t3=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_8874,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[10],tmp=(C_word)a,a+=13,tmp);
if(C_truep(t2)){
t4=t3;
f_8874(2,t4,t2);}
else{
/* posixunix.scm: 2371 regexp? */
t4=*((C_word*)lf[446]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[11]);}}

/* k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8874(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8874,2,t0,t1);}
t2=(C_truep(t1)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8875,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[12],tmp=(C_word)a,a+=4,tmp):((C_word*)t0)[11]);
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_8751,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t2,a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8868,a[2]=t3,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2374 make-pathname */
t5=((C_word*)t0)[7];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[2],lf[445]);}

/* k8866 in k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8868(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2374 glob */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k8749 in k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8751(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8751,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_8753,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t3,tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_8753(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k8749 in k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8753(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8753,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_8772,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t4,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t3,a[10]=t5,a[11]=t1,a[12]=((C_word*)t0)[9],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 2380 directory? */
t7=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t4);}}

/* k8770 in loop in k8749 in k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8772(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8772,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_8848,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[12],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 2381 pathname-file */
t3=*((C_word*)lf[444]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[6]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8854,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[12],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2388 pproc */
t3=((C_word*)t0)[5];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[6]);}}

/* k8852 in k8770 in loop in k8749 in k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8854(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8854,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8861,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2388 action */
t3=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2389 loop */
t2=((C_word*)((C_word*)t0)[7])[1];
f_8753(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k8859 in k8852 in k8770 in loop in k8749 in k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8861(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2388 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_8753(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k8846 in k8770 in loop in k8749 in k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8848(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8848,2,t0,t1);}
if(C_truep((C_truep((C_word)C_i_equalp(t1,lf[440]))?C_SCHEME_TRUE:(C_truep((C_word)C_i_equalp(t1,lf[441]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posixunix.scm: 2381 loop */
t2=((C_word*)((C_word*)t0)[12])[1];
f_8753(t2,((C_word*)t0)[11],((C_word*)t0)[10],((C_word*)t0)[9]);}
else{
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_8787,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],a[11]=((C_word*)t0)[8],tmp=(C_word)a,a+=12,tmp);
/* posixunix.scm: 2382 lproc */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[6]);}}

/* k8785 in k8846 in k8770 in loop in k8749 in k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8787(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[28],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8787,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[11])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8797,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8799,a[2]=t4,a[3]=((C_word*)t0)[11],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_8804,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[10],tmp=(C_word)a,a+=9,tmp);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8828,a[2]=t6,a[3]=((C_word*)t0)[11],a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* ##sys#dynamic-wind */
t11=*((C_word*)lf[443]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8838,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8841,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=t2,a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2387 pproc */
t4=((C_word*)t0)[4];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[6]);}}

/* k8839 in k8785 in k8846 in k8770 in loop in k8749 in k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8841(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2387 action */
t2=((C_word*)t0)[5];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
f_8838(2,t2,((C_word*)t0)[2]);}}

/* k8836 in k8785 in k8846 in k8770 in loop in k8749 in k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8838(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2387 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_8753(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a8827 in k8785 in k8846 in k8770 in loop in k8749 in k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8828(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8828,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* a8803 in k8785 in k8846 in k8770 in loop in k8749 in k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8804(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8804,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8812,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=t1,a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8826,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2385 make-pathname */
t4=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[6],lf[442]);}

/* k8824 in a8803 in k8785 in k8846 in k8770 in loop in k8749 in k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8826(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2385 glob */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k8810 in a8803 in k8785 in k8846 in k8770 in loop in k8749 in k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8812(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8812,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8816,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8819,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2386 pproc */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k8817 in k8810 in a8803 in k8785 in k8846 in k8770 in loop in k8749 in k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8819(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2386 action */
t2=((C_word*)t0)[5];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
f_8816(2,t2,((C_word*)t0)[2]);}}

/* k8814 in k8810 in a8803 in k8785 in k8846 in k8770 in loop in k8749 in k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8816(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2385 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_8753(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a8798 in k8785 in k8846 in k8770 in loop in k8749 in k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8799(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8799,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k8795 in k8785 in k8846 in k8770 in loop in k8749 in k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8797(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2383 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_8753(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f_8875 in k8872 in k8739 in body3073 in find-files in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8875(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8875,3,t0,t1,t2);}
/* posixunix.scm: 2372 string-match */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,((C_word*)t0)[2],t2);}

/* process* in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8675(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_8675r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_8675r(t0,t1,t2,t3);}}

static void C_ccall f_8675r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(10);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8677,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8682,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8687,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args30283044 */
t7=t6;
f_8687(t7,t1);}
else{
t7=(C_word)C_u_i_car(t3);
t8=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t8))){
/* def-env30293040 */
t9=t5;
f_8682(t9,t1,t7);}
else{
t9=(C_word)C_u_i_car(t8);
t10=(C_word)C_slot(t8,C_fix(1));
/* body30263035 */
t11=t4;
f_8677(t11,t1,t7,t9);}}}

/* def-args3028 in process* in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8687(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8687,NULL,2,t0,t1);}
/* def-env30293040 */
t2=((C_word*)t0)[2];
f_8682(t2,t1,C_SCHEME_FALSE);}

/* def-env3029 in process* in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8682(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8682,NULL,3,t0,t1,t2);}
/* body30263035 */
t3=((C_word*)t0)[2];
f_8677(t3,t1,t2,C_SCHEME_FALSE);}

/* body3026 in process* in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8677(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8677,NULL,4,t0,t1,t2,t3);}
/* posixunix.scm: 2349 %process */
f_8557(t1,lf[438],C_SCHEME_TRUE,((C_word*)t0)[2],t2,t3);}

/* process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8618(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_8618r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_8618r(t0,t1,t2,t3);}}

static void C_ccall f_8618r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(10);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8620,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8625,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8630,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args29843000 */
t7=t6;
f_8630(t7,t1);}
else{
t7=(C_word)C_u_i_car(t3);
t8=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t8))){
/* def-env29852996 */
t9=t5;
f_8625(t9,t1,t7);}
else{
t9=(C_word)C_u_i_car(t8);
t10=(C_word)C_slot(t8,C_fix(1));
/* body29822991 */
t11=t4;
f_8620(t11,t1,t7,t9);}}}

/* def-args2984 in process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8630(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8630,NULL,2,t0,t1);}
/* def-env29852996 */
t2=((C_word*)t0)[2];
f_8625(t2,t1,C_SCHEME_FALSE);}

/* def-env2985 in process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8625(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8625,NULL,3,t0,t1,t2);}
/* body29822991 */
t3=((C_word*)t0)[2];
f_8620(t3,t1,t2,C_SCHEME_FALSE);}

/* body2982 in process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8620(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8620,NULL,4,t0,t1,t2,t3);}
/* posixunix.scm: 2346 %process */
f_8557(t1,lf[437],C_SCHEME_FALSE,((C_word*)t0)[2],t2,t3);}

/* %process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8557(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8557,NULL,6,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8559,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t10=(C_word)C_i_check_string_2(((C_word*)t7)[1],t2);
t11=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_8578,a[2]=t9,a[3]=t1,a[4]=t3,a[5]=t6,a[6]=t8,a[7]=t7,a[8]=t2,tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t8)[1])){
/* posixunix.scm: 2335 chkstrlst */
t12=t9;
f_8559(t12,t11,((C_word*)t8)[1]);}
else{
t12=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8612,a[2]=t11,a[3]=t7,a[4]=t8,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2337 ##sys#shell-command-arguments */
t13=*((C_word*)lf[432]+1);
((C_proc3)(void*)(*((C_word*)t13+1)))(3,t13,t12,((C_word*)t7)[1]);}}

/* k8610 in %process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8612(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8612,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8616,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2338 ##sys#shell-command */
t4=*((C_word*)lf[429]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k8614 in k8610 in %process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8616(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)t0)[2];
f_8578(2,t3,t2);}

/* k8576 in %process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8578(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8578,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8581,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixunix.scm: 2339 chkstrlst */
t3=((C_word*)t0)[2];
f_8559(t3,t2,((C_word*)t0)[5]);}
else{
t3=t2;
f_8581(2,t3,C_SCHEME_UNDEFINED);}}

/* k8579 in k8576 in %process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8581(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8581,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_8586,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8592,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a8591 in k8579 in k8576 in %process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8592(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_8592,6,t0,t1,t2,t3,t4,t5);}
if(C_truep(((C_word*)t0)[2])){
/* posixunix.scm: 2342 values */
C_values(6,0,t1,t2,t3,t4,t5);}
else{
/* posixunix.scm: 2343 values */
C_values(5,0,t1,t2,t3,t4);}}

/* a8585 in k8579 in k8576 in %process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8586(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8586,2,t0,t1);}
/* posixunix.scm: 2340 ##sys#process */
t2=*((C_word*)lf[436]+1);
((C_proc9)(void*)(*((C_word*)t2+1)))(9,t2,t1,((C_word*)t0)[6],((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1],((C_word*)t0)[3],C_SCHEME_TRUE,C_SCHEME_TRUE,((C_word*)t0)[2]);}

/* chkstrlst in %process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8559(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8559,NULL,3,t0,t1,t2);}
t3=(C_word)C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8568,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* for-each */
t5=*((C_word*)lf[67]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t4,t2);}

/* a8567 in chkstrlst in %process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8568(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8568,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_check_string_2(t2,((C_word*)t0)[2]));}

/* ##sys#process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8499(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8){
C_word tmp;
C_word t9;
C_word t10;
C_word t11;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr9,(void*)f_8499,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
t9=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_8505,a[2]=t8,a[3]=t7,a[4]=t6,a[5]=t5,a[6]=t4,a[7]=t3,a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
t10=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_8511,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t2,a[6]=((C_word*)t0)[4],a[7]=t8,a[8]=t6,a[9]=t7,tmp=(C_word)a,a+=10,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t9,t10);}

/* a8510 in ##sys#process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8511(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[26],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_8511,6,t0,t1,t2,t3,t4,t5);}
t6=(C_word)C_i_not(((C_word*)t0)[9]);
t7=(C_word)C_i_not(((C_word*)t0)[8]);
t8=(C_word)C_i_not(((C_word*)t0)[7]);
t9=(C_word)C_a_i_vector(&a,3,t6,t7,t8);
t10=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_8522,a[2]=((C_word*)t0)[8],a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t9,a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[7],a[8]=t4,a[9]=((C_word*)t0)[4],a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],a[12]=t5,a[13]=t1,tmp=(C_word)a,a+=14,tmp);
t11=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8542,a[2]=((C_word*)t0)[9],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t10,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2316 make-on-close */
t12=((C_word*)t0)[3];
f_8328(t12,t11,((C_word*)t0)[5],t5,t9,C_fix(0),C_fix(1),C_fix(2));}

/* k8540 in a8510 in ##sys#process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8542(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2315 input-port */
t2=((C_word*)t0)[7];
f_8477(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k8520 in a8510 in ##sys#process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8522(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8522,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_8526,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[11],a[9]=((C_word*)t0)[12],a[10]=t1,a[11]=((C_word*)t0)[13],tmp=(C_word)a,a+=12,tmp);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8538,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[10],a[6]=t2,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2318 make-on-close */
t4=((C_word*)t0)[6];
f_8328(t4,t3,((C_word*)t0)[10],((C_word*)t0)[12],((C_word*)t0)[5],C_fix(1),C_fix(0),C_fix(2));}

/* k8536 in k8520 in a8510 in ##sys#process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8538(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2317 output-port */
t2=((C_word*)t0)[7];
f_8488(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k8524 in k8520 in a8510 in ##sys#process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8526(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8526,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8530,a[2]=((C_word*)t0)[9],a[3]=t1,a[4]=((C_word*)t0)[10],a[5]=((C_word*)t0)[11],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8534,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=t2,a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2321 make-on-close */
t4=((C_word*)t0)[3];
f_8328(t4,t3,((C_word*)t0)[7],((C_word*)t0)[9],((C_word*)t0)[2],C_fix(2),C_fix(0),C_fix(1));}

/* k8532 in k8524 in k8520 in a8510 in ##sys#process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8534(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2320 input-port */
t2=((C_word*)t0)[7];
f_8477(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k8528 in k8524 in k8520 in a8510 in ##sys#process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8530(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2314 values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a8504 in ##sys#process in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8505(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8505,2,t0,t1);}
/* posixunix.scm: 2309 spawn */
t2=((C_word*)t0)[8];
f_8432(t2,t1,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8488(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8488,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8492,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2305 connect-parent */
t8=((C_word*)t0)[2];
f_8385(t8,t7,t4,t5);}

/* k8490 in output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8492(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2306 ##sys#custom-output-port */
t2=*((C_word*)lf[330]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t1,C_SCHEME_TRUE,C_fix(0),((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8477(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8477,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8481,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2301 connect-parent */
t8=((C_word*)t0)[2];
f_8385(t8,t7,t4,t5);}

/* k8479 in input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8481(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2302 ##sys#custom-input-port */
t2=*((C_word*)lf[316]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t1,C_SCHEME_TRUE,C_fix(256),((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* spawn in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8432(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8432,NULL,8,t0,t1,t2,t3,t4,t5,t6,t7);}
t8=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_8436,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t6,a[5]=t5,a[6]=t7,a[7]=((C_word*)t0)[4],a[8]=t4,a[9]=t3,a[10]=t2,a[11]=((C_word*)t0)[5],a[12]=t1,a[13]=((C_word*)t0)[6],tmp=(C_word)a,a+=14,tmp);
/* posixunix.scm: 2288 needed-pipe */
t9=((C_word*)t0)[2];
f_8365(t9,t8,t6);}

/* k8434 in spawn in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8436(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8436,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_8439,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=t1,a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],tmp=(C_word)a,a+=15,tmp);
/* posixunix.scm: 2289 needed-pipe */
t3=((C_word*)t0)[2];
f_8365(t3,t2,((C_word*)t0)[5]);}

/* k8437 in k8434 in spawn in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8439(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8439,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_8442,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=t1,a[14]=((C_word*)t0)[14],tmp=(C_word)a,a+=15,tmp);
/* posixunix.scm: 2290 needed-pipe */
t3=((C_word*)t0)[2];
f_8365(t3,t2,((C_word*)t0)[6]);}

/* k8440 in k8437 in k8434 in spawn in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8442(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[23],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8442,2,t0,t1);}
t2=f_8416(C_a_i(&a,3),((C_word*)t0)[13]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8453,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[11],a[5]=((C_word*)t0)[12],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_8455,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[13],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[11],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,a[9]=((C_word*)t0)[14],a[10]=((C_word*)t0)[7],a[11]=((C_word*)t0)[8],a[12]=((C_word*)t0)[9],a[13]=((C_word*)t0)[10],tmp=(C_word)a,a+=14,tmp);
/* posixunix.scm: 2293 process-fork */
t5=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}

/* a8454 in k8440 in k8437 in k8434 in spawn in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8455(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8455,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_8459,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],a[11]=t1,a[12]=((C_word*)t0)[13],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 2295 connect-child */
t3=((C_word*)t0)[7];
f_8399(t3,t2,((C_word*)t0)[3],((C_word*)t0)[2],*((C_word*)lf[293]+1));}

/* k8457 in a8454 in k8440 in k8437 in k8434 in spawn in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8459(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8459,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_8462,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
t3=f_8416(C_a_i(&a,3),((C_word*)t0)[3]);
/* posixunix.scm: 2296 connect-child */
t4=((C_word*)t0)[5];
f_8399(t4,t2,t3,((C_word*)t0)[2],*((C_word*)lf[294]+1));}

/* k8460 in k8457 in a8454 in k8440 in k8437 in k8434 in spawn in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8462(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8462,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_8465,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],tmp=(C_word)a,a+=7,tmp);
t3=f_8416(C_a_i(&a,3),((C_word*)t0)[4]);
/* posixunix.scm: 2297 connect-child */
t4=((C_word*)t0)[3];
f_8399(t4,t2,t3,((C_word*)t0)[2],*((C_word*)lf[295]+1));}

/* k8463 in k8460 in k8457 in a8454 in k8440 in k8437 in k8434 in spawn in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8465(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2298 process-execute */
t2=((C_word*)t0)[6];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k8451 in k8440 in k8437 in k8434 in spawn in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8453(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2291 values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* swapped-ends in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_8416(C_word *a,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(1));
t3=(C_word)C_u_i_car(t1);
return((C_word)C_a_i_cons(&a,2,t2,t3));}
else{
return(C_SCHEME_FALSE);}}

/* connect-child in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8399(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8399,NULL,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=(C_word)C_u_i_car(t2);
t6=(C_word)C_slot(t2,C_fix(1));
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8412,a[2]=t5,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2279 file-close */
t8=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t6);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* k8410 in connect-child in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8412(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8412,2,t0,t1);}
t2=((C_word*)t0)[4];
t3=((C_word*)t0)[3];
t4=(C_word)C_eqp(t3,((C_word*)t0)[2]);
if(C_truep(t4)){
t5=t2;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8324,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2253 duplicate-fileno */
t6=*((C_word*)lf[312]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,((C_word*)t0)[2],t3);}}

/* k8322 in k8410 in connect-child in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8324(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2254 file-close */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* connect-parent in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8385(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8385,NULL,4,t0,t1,t2,t3);}
if(C_truep(t3)){
t4=(C_word)C_u_i_car(t2);
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8398,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2273 file-close */
t7=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}}

/* k8396 in connect-parent in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8398(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* needed-pipe in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8365(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8365,NULL,3,t0,t1,t2);}
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8374,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_8380,tmp=(C_word)a,a+=2,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t3,t4);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}}

/* a8379 in needed-pipe in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8380(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_8380,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* a8373 in needed-pipe in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8374(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8374,2,t0,t1);}
/* posixunix.scm: 2268 create-pipe */
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}

/* make-on-close in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8328(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8328,NULL,8,t0,t1,t2,t3,t4,t5,t6,t7);}
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_8330,a[2]=t2,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t7,a[6]=t6,a[7]=t5,a[8]=t4,tmp=(C_word)a,a+=9,tmp));}

/* f_8330 in make-on-close in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8330(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8330,2,t0,t1);}
t2=(C_word)C_i_set_i_slot(((C_word*)t0)[8],((C_word*)t0)[7],C_SCHEME_TRUE);
t3=(C_word)C_slot(((C_word*)t0)[8],((C_word*)t0)[6]);
t4=(C_truep(t3)?(C_word)C_slot(((C_word*)t0)[8],((C_word*)t0)[5]):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8345,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8351,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t5,t6);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* a8350 */
static void C_ccall f_8351(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_8351,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 2263 ##sys#signal-hook */
t5=*((C_word*)lf[2]+1);
((C_proc7)(void*)(*((C_word*)t5+1)))(7,t5,t1,lf[204],((C_word*)t0)[3],lf[435],((C_word*)t0)[2],t4);}}

/* a8344 */
static void C_ccall f_8345(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8345,2,t0,t1);}
/* posixunix.scm: 2261 process-wait */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* process-run in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8272(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f_8272r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_8272r(t0,t1,t2,t3);}}

static void C_ccall f_8272r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8279,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2217 process-fork */
t7=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k8277 in process-run in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8279(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8279,2,t0,t1);}
t2=(C_word)C_eqp(C_fix(0),t1);
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[5])){
/* posixunix.scm: 2219 process-execute */
t3=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[3],((C_word*)t0)[2],((C_word*)t0)[5]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8298,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2221 ##sys#shell-command */
t4=*((C_word*)lf[429]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k8296 in k8277 in process-run in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8298(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8298,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8302,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2221 ##sys#shell-command-arguments */
t3=*((C_word*)lf[432]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k8300 in k8296 in k8277 in process-run in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8302(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2221 process-execute */
t2=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* ##sys#shell-command-arguments in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8266(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8266,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_a_i_list(&a,2,lf[433],t2));}

/* ##sys#shell-command in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8257(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8257,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8261,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 2207 get-environment-variable */
t3=*((C_word*)lf[130]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[431]);}

/* k8259 in ##sys#shell-command in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8261(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_truep(t1)?t1:lf[430]));}

/* process-signal in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8230(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3rv,(void*)f_8230r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_8230r(t0,t1,t2,t3);}}

static void C_ccall f_8230r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):C_fix((C_word)SIGTERM));
t6=(C_word)C_i_check_exact_2(t2,lf[427]);
t7=(C_word)C_i_check_exact_2(t5,lf[427]);
t8=(C_word)C_kill(t2,t5);
t9=(C_word)C_eqp(t8,C_fix(-1));
if(C_truep(t9)){
/* posixunix.scm: 2204 posix-error */
t10=lf[1];
f_3480(7,t10,t1,lf[204],lf[427],lf[428],t2,t5);}
else{
t10=t1;
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,C_SCHEME_UNDEFINED);}}

/* sleep in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8227(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8227,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub2733(C_SCHEME_UNDEFINED,t2));}

/* parent-process-id in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8224(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8224,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub2728(C_SCHEME_UNDEFINED));}

/* current-process-id in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8221(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8221,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub2724(C_SCHEME_UNDEFINED));}

/* process-wait in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8146(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr2r,(void*)f_8146r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_8146r(t0,t1,t2);}}

static void C_ccall f_8146r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(7);
t3=(C_word)C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_u_i_car(t2));
t5=(C_word)C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t2,C_fix(1)));
t7=(C_word)C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:(C_word)C_u_i_car(t6));
t9=(C_word)C_i_nullp(t6);
t10=(C_truep(t9)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t6,C_fix(1)));
t11=(C_truep(t4)?t4:C_fix(-1));
t12=(C_word)C_i_check_exact_2(t11,lf[422]);
t13=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8173,a[2]=t8,a[3]=t11,tmp=(C_word)a,a+=4,tmp);
t14=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8179,a[2]=t11,tmp=(C_word)a,a+=3,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t13,t14);}

/* a8178 in process-wait in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8179(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_8179,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
/* posixunix.scm: 2190 posix-error */
t6=lf[1];
f_3480(6,t6,t1,lf[204],lf[422],lf[423],((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2191 values */
C_values(5,0,t1,t2,t3,t4);}}

/* a8172 in process-wait in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8173(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8173,2,t0,t1);}
/* posixunix.scm: 2188 ##sys#process-wait */
t2=*((C_word*)lf[421]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#process-wait in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8129(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_8129,4,t0,t1,t2,t3);}
t4=(C_truep(t3)?C_fix((C_word)WNOHANG):C_fix(0));
t5=(C_word)C_waitpid(t2,t4);
t6=(C_word)C_WIFEXITED(C_fix((C_word)C_wait_status));
t7=(C_truep(t6)?(C_word)C_WEXITSTATUS(C_fix((C_word)C_wait_status)):(C_truep((C_word)C_WIFSIGNALED(C_fix((C_word)C_wait_status)))?(C_word)C_WTERMSIG(C_fix((C_word)C_wait_status)):(C_word)C_WSTOPSIG(C_fix((C_word)C_wait_status))));
/* posixunix.scm: 2175 values */
C_values(5,0,t1,t5,t6,t7);}

/* process-execute in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7950(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr3r,(void*)f_7950r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7950r(t0,t1,t2,t3);}}

static void C_ccall f_7950r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(12);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7952,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8079,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8084,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-arglist25902658 */
t7=t6;
f_8084(t7,t1);}
else{
t7=(C_word)C_u_i_car(t3);
t8=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t8))){
/* def-envlist25912654 */
t9=t5;
f_8079(t9,t1,t7);}
else{
t9=(C_word)C_u_i_car(t8);
t10=(C_word)C_slot(t8,C_fix(1));
/* body25882597 */
t11=t4;
f_7952(t11,t1,t7,t9);}}}

/* def-arglist2590 in process-execute in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8084(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8084,NULL,2,t0,t1);}
/* def-envlist25912654 */
t2=((C_word*)t0)[2];
f_8079(t2,t1,C_SCHEME_END_OF_LIST);}

/* def-envlist2591 in process-execute in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_8079(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8079,NULL,3,t0,t1,t2);}
/* body25882597 */
t3=((C_word*)t0)[2];
f_7952(t3,t1,t2,C_SCHEME_FALSE);}

/* body2588 in process-execute in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_7952(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7952,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(((C_word*)t0)[5],lf[419]);
t5=(C_word)C_i_check_list_2(t2,lf[419]);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7962,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2143 pathname-strip-directory */
t7=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,((C_word*)t0)[5]);}

/* k7960 in body2588 in process-execute in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7962(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7962,2,t0,t1);}
t2=(C_word)C_block_size(t1);
t3=f_7934(C_fix(0),t1,t2);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7970,a[2]=t5,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp));
t7=((C_word*)t5)[1];
f_7970(t7,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

/* doloop2603 in k7960 in body2588 in process-execute in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_7970(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_7970,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=f_7934(t3,C_SCHEME_FALSE,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7983,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[5])){
t6=(C_word)C_i_check_list_2(((C_word*)t0)[5],lf[419]);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8016,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t8=t5;
f_7983(t8,f_8016(t7,((C_word*)t0)[5],C_fix(0)));}
else{
t6=t5;
f_7983(t6,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_u_i_car(t2);
t5=(C_word)C_i_check_string_2(t4,lf[419]);
t6=(C_word)C_block_size(t4);
t7=f_7934(t3,t4,t6);
t8=(C_word)C_slot(t2,C_fix(1));
t9=(C_word)C_u_fixnum_plus(t3,C_fix(1));
t15=t1;
t16=t8;
t17=t9;
t1=t15;
t2=t16;
t3=t17;
goto loop;}}

/* doloop2614 in doloop2603 in k7960 in body2588 in process-execute in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_8016(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
loop:
if(C_truep((C_word)C_i_nullp(t1))){
return(f_7942(t2,C_SCHEME_FALSE,C_fix(0)));}
else{
t3=(C_word)C_u_i_car(t1);
t4=(C_word)C_i_check_string_2(t3,lf[419]);
t5=(C_word)C_block_size(t3);
t6=f_7942(t2,t3,t5);
t7=(C_word)C_slot(t1,C_fix(1));
t8=(C_word)C_u_fixnum_plus(t2,C_fix(1));
t10=t7;
t11=t8;
t1=t10;
t2=t11;
goto loop;}}

/* k7981 in doloop2603 in k7960 in body2588 in process-execute in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_7983(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7983,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7986,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8008,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 2157 ##sys#expand-home-path */
t4=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k8006 in k7981 in doloop2603 in k7960 in body2588 in process-execute in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_8008(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2157 ##sys#make-c-string */
t2=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k7984 in k7981 in doloop2603 in k7960 in body2588 in process-execute in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7986(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_truep(((C_word*)t0)[4])?(C_word)C_execve(t1):(C_word)C_execvp(t1));
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)stub2553(C_SCHEME_UNDEFINED);
t5=(C_word)stub2568(C_SCHEME_UNDEFINED);
/* posixunix.scm: 2164 posix-error */
t6=lf[1];
f_3480(6,t6,((C_word*)t0)[3],lf[204],lf[419],lf[420],((C_word*)t0)[2]);}
else{
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* setenv in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_7942(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
t4=(C_truep(t2)?t2:C_SCHEME_FALSE);
return((C_word)stub2559(C_SCHEME_UNDEFINED,t1,t4,t3));}

/* setarg in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_7934(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
t4=(C_truep(t2)?t2:C_SCHEME_FALSE);
return((C_word)stub2544(C_SCHEME_UNDEFINED,t1,t4,t3));}

/* process-fork in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7896(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2rv,(void*)f_7896r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_7896r(t0,t1,t2);}}

static void C_ccall f_7896r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(3);
t3=(C_word)stub2512(C_SCHEME_UNDEFINED);
t4=(C_word)C_eqp(C_fix(-1),t3);
if(C_truep(t4)){
/* posixunix.scm: 2128 posix-error */
t5=lf[1];
f_3480(5,t5,t1,lf[204],lf[416],lf[417]);}
else{
t5=(C_word)C_notvemptyp(t2);
t6=(C_truep(t5)?(C_word)C_eqp(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7918,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t8=(C_word)C_slot(t2,C_fix(0));
t9=t8;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t7);}
else{
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t3);}}}

/* k7916 in process-fork in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7918(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7918,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7922,tmp=(C_word)a,a+=2,tmp);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],C_fix(0));}

/* f_7922 in k7916 in process-fork in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7922(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7922,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub2530(C_SCHEME_UNDEFINED,t2));}

/* glob in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7787(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr2r,(void*)f_7787r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_7787r(t0,t1,t2);}}

static void C_ccall f_7787r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(11);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7793,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t4,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp));
t6=((C_word*)t4)[1];
f_7793(t6,t1,t2);}

/* conc-loop in glob in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_7793(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7793,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_u_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7808,a[2]=t3,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7814,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t4,t5);}}

/* a7813 in conc-loop in glob in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7814(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_7814,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_7818,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7888,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[415]);
/* posixunix.scm: 2113 make-pathname */
t8=((C_word*)t0)[6];
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

/* k7886 in a7813 in conc-loop in glob in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7888(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2113 glob->regexp */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k7816 in a7813 in conc-loop in glob in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7818(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7818,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7821,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 2114 regexp */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,t1);}

/* k7819 in k7816 in a7813 in conc-loop in glob in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7821(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7821,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7828,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t3=(C_truep(((C_word*)t0)[5])?((C_word*)t0)[5]:lf[414]);
/* posixunix.scm: 2115 directory */
t4=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,t3,C_SCHEME_TRUE);}

/* k7826 in k7819 in k7816 in a7813 in conc-loop in glob in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7828(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7828,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7830,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t3,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];
f_7830(t5,((C_word*)t0)[2],t1);}

/* loop in k7826 in k7819 in k7816 in a7813 in conc-loop in glob in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_7830(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7830,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_slot(((C_word*)t0)[8],C_fix(1));
/* posixunix.scm: 2116 conc-loop */
t4=((C_word*)((C_word*)t0)[7])[1];
f_7793(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7847,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_u_i_car(t2);
/* posixunix.scm: 2117 string-match */
t5=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k7845 in loop in k7826 in k7819 in k7816 in a7813 in conc-loop in glob in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7847(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7847,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7857,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_u_i_car(t1);
/* posixunix.scm: 2118 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,((C_word*)t0)[2],t3);}
else{
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
/* posixunix.scm: 2119 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_7830(t3,((C_word*)t0)[6],t2);}}

/* k7855 in k7845 in loop in k7826 in k7819 in k7816 in a7813 in conc-loop in glob in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7857(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7857,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7861,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 2118 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_7830(t4,t2,t3);}

/* k7859 in k7855 in k7845 in loop in k7826 in k7819 in k7816 in a7813 in conc-loop in glob in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7861(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7861,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a7807 in conc-loop in glob in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7808(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7808,2,t0,t1);}
/* posixunix.scm: 2112 decompose-pathname */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* get-host-name in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7775(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7775,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7779,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,(C_word)stub2426(t3),C_fix(0));}

/* k7777 in get-host-name in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7779(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7779,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7782,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_7782(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 2094 posix-error */
t3=lf[1];
f_3480(5,t3,t2,lf[402],lf[406],lf[407]);}}

/* k7780 in k7777 in get-host-name in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7782(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* terminal-size in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7740(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7740,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7744,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2075 ##sys#terminal-check */
f_7694(t3,lf[401],t2);}

/* k7742 in terminal-size in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7744(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7744,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7764,a[2]=t3,a[3]=t2,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
/* ##sys#make-locative */
t5=*((C_word*)lf[404]+1);
((C_proc6)(void*)(*((C_word*)t5+1)))(6,t5,t4,t2,C_fix(0),C_SCHEME_FALSE,lf[405]);}

/* k7762 in k7742 in terminal-size in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7764(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7764,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7768,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#make-locative */
t3=*((C_word*)lf[404]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],C_fix(0),C_SCHEME_FALSE,lf[405]);}

/* k7766 in k7762 in k7742 in terminal-size in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7768(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
t2=(C_word)C_C_fileno(((C_word*)t0)[6]);
t3=((C_word*)t0)[5];
t4=(C_word)C_i_foreign_pointer_argumentp(t3);
t5=(C_word)C_i_foreign_pointer_argumentp(t1);
t6=(C_word)stub2397(C_SCHEME_UNDEFINED,t2,t4,t5);
t7=(C_word)C_eqp(C_fix(0),t6);
if(C_truep(t7)){
/* posixunix.scm: 2082 values */
C_values(4,0,((C_word*)t0)[4],C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[3]))),C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))));}
else{
/* posixunix.scm: 2083 posix-error */
t8=lf[1];
f_3480(6,t8,((C_word*)t0)[4],lf[402],lf[401],lf[403],((C_word*)t0)[6]);}}

/* terminal-name in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7721(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7721,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7725,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2067 ##sys#terminal-check */
f_7694(t3,lf[400],t2);}

/* k7723 in terminal-name in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7725(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7725,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_C_fileno(((C_word*)t0)[2]);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-nonnull-c-string */
t5=*((C_word*)lf[213]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub2382(t4,t3),C_fix(0));}

/* ##sys#terminal-check in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_7694(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7694,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7698,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2059 ##sys#check-port */
t5=*((C_word*)lf[164]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,t3,t2);}

/* k7696 in ##sys#terminal-check in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7698(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(7));
t3=(C_word)C_eqp(lf[96],t2);
t4=(C_truep(t3)?(C_word)C_tty_portp(((C_word*)t0)[4]):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 2062 ##sys#error */
t5=*((C_word*)lf[152]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,((C_word*)t0)[3],((C_word*)t0)[2],lf[399],((C_word*)t0)[4]);}}

/* terminal-port? in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7675(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7675,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7679,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2054 ##sys#check-port */
t4=*((C_word*)lf[164]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[397]);}

/* k7677 in terminal-port? in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7679(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7679,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7682,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2055 ##sys#peek-unsigned-integer */
t3=*((C_word*)lf[311]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

/* k7680 in k7677 in terminal-port? in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7682(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(0),t1);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_truep(t2)?C_SCHEME_FALSE:(C_word)C_tty_portp(((C_word*)t0)[2])));}

/* set-buffering-mode! in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7616(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_7616r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_7616r(t0,t1,t2,t3,t4);}}

static void C_ccall f_7616r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7620,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2039 ##sys#check-port */
t6=*((C_word*)lf[164]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,lf[391]);}

/* k7618 in set-buffering-mode! in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7620(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7620,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[5],C_fix(0)):C_fix((C_word)BUFSIZ));
t4=((C_word*)t0)[4];
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7626,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[393]);
if(C_truep(t6)){
t7=t5;
f_7626(2,t7,C_fix((C_word)_IOFBF));}
else{
t7=(C_word)C_eqp(t4,lf[394]);
if(C_truep(t7)){
t8=t5;
f_7626(2,t8,C_fix((C_word)_IOLBF));}
else{
t8=(C_word)C_eqp(t4,lf[395]);
if(C_truep(t8)){
t9=t5;
f_7626(2,t9,C_fix((C_word)_IONBF));}
else{
/* posixunix.scm: 2045 ##sys#error */
t9=*((C_word*)lf[152]+1);
((C_proc6)(void*)(*((C_word*)t9+1)))(6,t9,t5,lf[391],lf[396],((C_word*)t0)[4],((C_word*)t0)[3]);}}}}

/* k7624 in k7618 in set-buffering-mode! in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7626(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_i_check_exact_2(((C_word*)t0)[4],lf[391]);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t4=(C_word)C_eqp(lf[96],t3);
t5=(C_truep(t4)?(C_word)C_setvbuf(((C_word*)t0)[3],t1,((C_word*)t0)[4]):C_fix(-1));
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(0)))){
/* posixunix.scm: 2051 ##sys#error */
t6=*((C_word*)lf[152]+1);
((C_proc7)(void*)(*((C_word*)t6+1)))(7,t6,((C_word*)t0)[2],lf[391],lf[392],((C_word*)t0)[3],t1,((C_word*)t0)[4]);}
else{
t6=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* set-alarm! in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7613(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7613,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub2333(C_SCHEME_UNDEFINED,t2));}

/* _exit in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7597(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2rv,(void*)f_7597r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_7597r(t0,t1,t2);}}

static void C_ccall f_7597r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
t3=(C_word)C_notvemptyp(t2);
t4=(C_truep(t3)?(C_word)C_slot(t2,C_fix(0)):C_fix(0));
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)stub2324(C_SCHEME_UNDEFINED,t4));}

/* local-timezone-abbreviation in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7589(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7589,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t3=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,(C_word)stub2316(t2),C_fix(0));}

/* utc-time->seconds in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7574(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7574,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7578,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2007 check-time-vector */
f_7380(t3,lf[386],t2);}

/* k7576 in utc-time->seconds in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7578(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_timegm(((C_word*)t0)[3]))){
/* posixunix.scm: 2009 ##sys#cons-flonum */
t2=*((C_word*)lf[384]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2010 ##sys#error */
t2=*((C_word*)lf[152]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[386],lf[387],((C_word*)t0)[3]);}}

/* local-time->seconds in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7559(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7559,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7563,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2001 check-time-vector */
f_7380(t3,lf[383],t2);}

/* k7561 in local-time->seconds in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7563(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_mktime(((C_word*)t0)[3]))){
/* posixunix.scm: 2003 ##sys#cons-flonum */
t2=*((C_word*)lf[384]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2004 ##sys#error */
t2=*((C_word*)lf[152]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[383],lf[385],((C_word*)t0)[3]);}}

/* string->time in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7520(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_7520r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_7520r(t0,t1,t2,t3);}}

static void C_ccall f_7520r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(4);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?lf[382]:(C_word)C_slot(t3,C_fix(0)));
t6=(C_word)C_i_check_string_2(t2,lf[381]);
t7=(C_word)C_i_check_string_2(t5,lf[381]);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7537,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1998 ##sys#make-c-string */
t9=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}

/* k7535 in string->time in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7537(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7537,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7541,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1998 ##sys#make-c-string */
t3=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k7539 in k7535 in string->time in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7541(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7541,2,t0,t1);}
t2=(C_word)C_a_i_vector(&a,10,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE);
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[2];
t5=t3;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)stub2277(C_SCHEME_UNDEFINED,t4,t1,t2));}

/* time->string in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7458(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3rv,(void*)f_7458r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_7458r(t0,t1,t2,t3);}}

static void C_ccall f_7458r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7465,a[2]=t2,a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1982 check-time-vector */
f_7380(t6,lf[378],t2);}

/* k7463 in time->string in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7465(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7465,2,t0,t1);}
if(C_truep(((C_word*)t0)[4])){
t2=(C_word)C_i_check_string_2(((C_word*)t0)[4],lf[378]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7474,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7484,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1986 ##sys#make-c-string */
t5=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[4]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7487,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub2227(t4,t3),C_fix(0));}}

/* k7485 in k7463 in time->string in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7487(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_block_size(t1);
t3=(C_word)C_u_fixnum_difference(t2,C_fix(1));
/* posixunix.scm: 1990 ##sys#substring */
t4=*((C_word*)lf[63]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixunix.scm: 1991 ##sys#error */
t2=*((C_word*)lf[152]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[378],lf[380],((C_word*)t0)[2]);}}

/* k7482 in k7463 in time->string in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7484(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7484,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,((C_word*)t0)[2],(C_word)stub2235(t3,t2,t1),C_fix(0));}

/* k7472 in k7463 in time->string in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7474(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
/* posixunix.scm: 1987 ##sys#error */
t2=*((C_word*)lf[152]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[378],lf[379],((C_word*)t0)[2]);}}

/* seconds->string in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7422(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7422,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[376]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7429,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=t2;
t6=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t7=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,(C_word)stub2211(t6,t5),C_fix(0));}

/* k7427 in seconds->string in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7429(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_block_size(t1);
t3=(C_word)C_u_fixnum_difference(t2,C_fix(1));
/* posixunix.scm: 1975 ##sys#substring */
t4=*((C_word*)lf[63]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixunix.scm: 1976 ##sys#error */
t2=*((C_word*)lf[152]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[376],lf[377],((C_word*)t0)[2]);}}

/* seconds->utc-time in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7408(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7408,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[375]);
/* posixunix.scm: 1967 ##sys#decode-seconds */
t4=*((C_word*)lf[374]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t2,C_SCHEME_TRUE);}

/* seconds->local-time in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7399(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7399,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[373]);
/* posixunix.scm: 1963 ##sys#decode-seconds */
t4=*((C_word*)lf[374]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t2,C_SCHEME_FALSE);}

/* check-time-vector in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_7380(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7380,NULL,3,t1,t2,t3);}
t4=(C_word)C_i_check_vector_2(t3,t2);
t5=(C_word)C_block_size(t3);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixunix.scm: 1959 ##sys#error */
t6=*((C_word*)lf[152]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t1,t2,lf[372],t3);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* memory-mapped-file? in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7374(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7374,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_structurep(t2,lf[362]));}

/* memory-mapped-file-pointer in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7365(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7365,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[362],lf[369]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(t2,C_fix(1)));}

/* unmap-file-from-memory in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7330(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3rv,(void*)f_7330r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_7330r(t0,t1,t2,t3);}}

static void C_ccall f_7330r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t4=(C_word)C_i_check_structure_2(t2,lf[362],lf[367]);
t5=(C_word)C_notvemptyp(t3);
t6=(C_truep(t5)?(C_word)C_slot(t3,C_fix(0)):(C_word)C_slot(t2,C_fix(2)));
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_truep(t7)?(C_word)C_i_foreign_pointer_argumentp(t7):C_SCHEME_FALSE);
t9=(C_word)stub2164(C_SCHEME_UNDEFINED,t8,t6);
t10=(C_word)C_eqp(C_fix(0),t9);
if(C_truep(t10)){
t11=t1;
((C_proc2)(void*)(*((C_word*)t11+1)))(2,t11,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1945 posix-error */
t11=lf[1];
f_3480(7,t11,t1,lf[46],lf[367],lf[368],t2,t6);}}

/* map-file-to-memory in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7272(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...){
C_word tmp;
C_word t7;
va_list v;
C_word *a,c2=c;
C_save_rest(t6,c2,7);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr7rv,(void*)f_7272r,7,t0,t1,t2,t3,t4,t5,t6);}
else{
a=C_alloc((c-7)*3);
t7=C_restore_rest_vector(a,C_rest_count(0));
f_7272r(t0,t1,t2,t3,t4,t5,t6,t7);}}

static void C_ccall f_7272r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7276,a[2]=t1,a[3]=t6,a[4]=t5,a[5]=t4,a[6]=t3,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;
f_7276(2,t10,t2);}
else{
/* posixunix.scm: 1930 ##sys#null-pointer */
t10=*((C_word*)lf[366]+1);
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t8);}}

/* k7274 in map-file-to-memory in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7276(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7276,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[7]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[7],C_fix(0)):C_fix(0));
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7282,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t5=(C_truep((C_word)C_blockp(t1))?(C_word)C_specialp(t1):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t4;
f_7282(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1933 ##sys#signal-hook */
t6=*((C_word*)lf[2]+1);
((C_proc6)(void*)(*((C_word*)t6+1)))(6,t6,t4,lf[57],lf[361],lf[365],t1);}}

/* k7280 in k7274 in map-file-to-memory in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7282(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7282,2,t0,t1);}
t2=((C_word*)t0)[8];
t3=((C_word*)t0)[7];
t4=((C_word*)t0)[6];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[4];
t7=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t8=(C_truep(t2)?(C_word)C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t9=(C_word)stub2125(t7,t8,t3,t4,t5,t6,((C_word*)t0)[3]);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7288,a[2]=((C_word*)t0)[7],a[3]=t9,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t11=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7301,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t10,tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1935 ##sys#pointer->address */
t12=*((C_word*)lf[364]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,t9);}

/* k7299 in k7280 in k7274 in map-file-to-memory in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7301(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posixunix.scm: 1936 posix-error */
t3=lf[1];
f_3480(11,t3,((C_word*)t0)[8],lf[46],lf[361],lf[363],((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[8];
f_7288(2,t3,C_SCHEME_UNDEFINED);}}

/* k7286 in k7280 in k7274 in map-file-to-memory in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7288(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7288,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_record(&a,3,lf[362],((C_word*)t0)[3],((C_word*)t0)[2]));}

/* get-environment-variables in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7188(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7188,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7194,a[2]=t3,tmp=(C_word)a,a+=3,tmp));
t5=((C_word*)t3)[1];
f_7194(t5,t1,C_fix(0));}

/* loop in get-environment-variables in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_7194(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7194,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7198,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub2076(t5,t4),C_fix(0));}

/* k7196 in loop in get-environment-variables in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7198(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7198,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7206,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp));
t5=((C_word*)t3)[1];
f_7206(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k7196 in loop in get-environment-variables in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_7206(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_7206,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[5],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7232,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1894 ##sys#substring */
t5=*((C_word*)lf[63]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[5],C_fix(0),t2);}
else{
t4=(C_word)C_u_fixnum_plus(t2,C_fix(1));
/* posixunix.scm: 1897 scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k7230 in scan in k7196 in loop in get-environment-variables in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7232(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7232,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7236,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixunix.scm: 1895 ##sys#substring */
t5=*((C_word*)lf[63]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t2,((C_word*)t0)[2],t3,t4);}

/* k7234 in k7230 in scan in k7196 in loop in get-environment-variables in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7236(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7236,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7224,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 1896 loop */
t5=((C_word*)((C_word*)t0)[2])[1];
f_7194(t5,t3,t4);}

/* k7222 in k7234 in k7230 in scan in k7196 in loop in get-environment-variables in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7224(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7224,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7173(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7173,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[349]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7181,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1883 ##sys#make-c-string */
t5=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k7179 in unsetenv in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7181(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_unsetenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7156(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_7156,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[348]);
t5=(C_word)C_i_check_string_2(t3,lf[348]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7167,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1878 ##sys#make-c-string */
t7=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k7165 in setenv in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7167(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7167,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7171,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1878 ##sys#make-c-string */
t3=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k7169 in k7165 in setenv in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7171(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* fifo? in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7130(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7130,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[89]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7137,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7154,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1866 ##sys#expand-home-path */
t6=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k7152 in fifo? in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7154(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1866 ##sys#file-info */
t2=*((C_word*)lf[122]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k7135 in fifo? in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7137(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(3),t2));}
else{
/* posixunix.scm: 1869 posix-error */
t2=lf[1];
f_3480(6,t2,((C_word*)t0)[3],lf[46],lf[89],lf[347],((C_word*)t0)[2]);}}

/* create-fifo in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7087(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_7087r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_7087r(t0,t1,t2,t3);}}

static void C_ccall f_7087r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_string_2(t2,lf[345]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7094,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_notvemptyp(t3))){
t6=t5;
f_7094(t6,(C_word)C_slot(t3,C_fix(0)));}
else{
t6=(C_word)C_u_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t7=t5;
f_7094(t7,(C_word)C_u_fixnum_or(C_fix((C_word)S_IRWXU),t6));}}

/* k7092 in create-fifo in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_7094(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7094,NULL,2,t0,t1);}
t2=(C_word)C_i_check_exact_2(t1,lf[345]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7111,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7115,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1860 ##sys#expand-home-path */
t5=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[2]);}

/* k7113 in k7092 in create-fifo in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7115(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1860 ##sys#make-c-string */
t2=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k7109 in k7092 in create-fifo in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7111(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_mkfifo(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1861 posix-error */
t3=lf[1];
f_3480(7,t3,((C_word*)t0)[3],lf[46],lf[345],lf[346],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* file-unlock in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7059(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7059,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[336],lf[343]);
t4=(C_word)C_slot(t2,C_fix(2));
t5=(C_word)C_slot(t2,C_fix(3));
t6=(C_word)C_flock_setup(C_fix((C_word)F_UNLCK),t4,t5);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_flock_lock(t7);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(0)))){
/* posixunix.scm: 1850 posix-error */
t9=lf[1];
f_3480(6,t9,t1,lf[46],lf[343],lf[344],t2);}
else{
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,C_SCHEME_UNDEFINED);}}

/* file-test-lock in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7037(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_7037r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7037r(t0,t1,t2,t3);}}

static void C_ccall f_7037r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7041,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1841 setup */
f_6918(t4,t2,t3,lf[341]);}

/* k7039 in file-test-lock in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7041(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_flock_test(((C_word*)t0)[4]);
if(C_truep(t2)){
t3=(C_word)C_eqp(t2,C_fix(0));
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?C_SCHEME_FALSE:t2));}
else{
/* posixunix.scm: 1843 err */
f_6989(((C_word*)t0)[3],lf[342],t1,lf[341]);}}

/* file-lock/blocking in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7022(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_7022r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7022r(t0,t1,t2,t3);}}

static void C_ccall f_7022r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7026,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1835 setup */
f_6918(t4,t2,t3,lf[339]);}

/* k7024 in file-lock/blocking in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7026(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lockw(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1837 err */
f_6989(((C_word*)t0)[2],lf[340],t1,lf[339]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* file-lock in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7007(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_7007r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7007r(t0,t1,t2,t3);}}

static void C_ccall f_7007r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7011,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1829 setup */
f_6918(t4,t2,t3,lf[337]);}

/* k7009 in file-lock in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_7011(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lock(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1831 err */
f_6989(((C_word*)t0)[2],lf[338],t1,lf[337]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* err in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6989(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6989,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_slot(t3,C_fix(1));
t6=(C_word)C_slot(t3,C_fix(2));
t7=(C_word)C_slot(t3,C_fix(3));
/* posixunix.scm: 1826 posix-error */
t8=lf[1];
f_3480(8,t8,t1,lf[46],t4,t2,t5,t6,t7);}

/* setup in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6918(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6918,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_nullp(t3);
t6=(C_truep(t5)?C_fix(0):(C_word)C_u_i_car(t3));
t7=(C_word)C_i_nullp(t3);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t3,C_fix(1)));
t9=(C_word)C_i_nullp(t8);
t10=(C_truep(t9)?C_SCHEME_TRUE:(C_word)C_u_i_car(t8));
t11=t10;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=(C_word)C_i_nullp(t8);
t14=(C_truep(t13)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t8,C_fix(1)));
t15=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6937,a[2]=t1,a[3]=t12,a[4]=t2,a[5]=t4,a[6]=t6,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1818 ##sys#check-port */
t16=*((C_word*)lf[164]+1);
((C_proc4)(void*)(*((C_word*)t16+1)))(4,t16,t15,t2,t4);}

/* k6935 in setup in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6937(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6937,2,t0,t1);}
t2=(C_word)C_i_check_number_2(((C_word*)t0)[6],((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6943,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(C_word)C_eqp(C_SCHEME_TRUE,((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t4)){
t5=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t6=t3;
f_6943(t6,t5);}
else{
t5=t3;
f_6943(t5,(C_word)C_i_check_number_2(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[5]));}}

/* k6941 in k6935 in setup in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6943(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6943,NULL,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_RDLCK):C_fix((C_word)F_WRLCK));
t4=(C_word)C_flock_setup(t3,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_a_i_record(&a,4,lf[336],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]));}

/* file-truncate in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6879(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6879,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_number_2(t3,lf[333]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6896,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6903,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6907,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1801 ##sys#expand-home-path */
t8=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f_6896(2,t6,(C_word)C_ftruncate(t2,t3));}
else{
/* posixunix.scm: 1803 ##sys#error */
t6=*((C_word*)lf[152]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[333],lf[335],t2);}}}

/* k6905 in file-truncate in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6907(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1801 ##sys#make-c-string */
t2=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k6901 in file-truncate in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6903(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_6896(2,t2,(C_word)C_truncate(t1,((C_word*)t0)[2]));}

/* k6894 in file-truncate in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6896(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 1805 posix-error */
t2=lf[1];
f_3480(7,t2,((C_word*)t0)[4],lf[46],lf[333],lf[334],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* ##sys#custom-output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6623(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(!C_demand(c*C_SIZEOF_PAIR+16)){
C_save_and_reclaim((void*)tr5r,(void*)f_6623r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_6623r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_6623r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a=C_alloc(16);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6625,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t2,a[6]=t4,tmp=(C_word)a,a+=7,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6809,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6814,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6819,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t5))){
/* def-nonblocking?18501941 */
t10=t9;
f_6819(t10,t1);}
else{
t10=(C_word)C_u_i_car(t5);
t11=(C_word)C_slot(t5,C_fix(1));
if(C_truep((C_word)C_i_nullp(t11))){
/* def-bufi18511937 */
t12=t8;
f_6814(t12,t1,t10);}
else{
t12=(C_word)C_u_i_car(t11);
t13=(C_word)C_slot(t11,C_fix(1));
if(C_truep((C_word)C_i_nullp(t13))){
/* def-on-close18521932 */
t14=t7;
f_6809(t14,t1,t10,t12);}
else{
t14=(C_word)C_u_i_car(t13);
t15=(C_word)C_slot(t13,C_fix(1));
/* body18481858 */
t16=t6;
f_6625(t16,t1,t10,t12,t14);}}}}

/* def-nonblocking?1850 in ##sys#custom-output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6819(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6819,NULL,2,t0,t1);}
/* def-bufi18511937 */
t2=((C_word*)t0)[2];
f_6814(t2,t1,C_SCHEME_FALSE);}

/* def-bufi1851 in ##sys#custom-output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6814(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6814,NULL,3,t0,t1,t2);}
/* def-on-close18521932 */
t3=((C_word*)t0)[2];
f_6809(t3,t1,t2,C_fix(0));}

/* def-on-close1852 in ##sys#custom-output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6809(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6809,NULL,4,t0,t1,t2,t3);}
/* body18481858 */
t4=((C_word*)t0)[2];
f_6625(t4,t1,t2,t3,*((C_word*)lf[328]+1));}

/* body1848 in ##sys#custom-output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6625(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6625,NULL,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6629,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=t3,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
if(C_truep(t2)){
/* posixunix.scm: 1743 ##sys#file-nonblocking! */
t6=*((C_word*)lf[7]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,((C_word*)t0)[6]);}
else{
t6=t5;
f_6629(2,t6,C_SCHEME_UNDEFINED);}}

/* k6627 in body1848 in ##sys#custom-output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6629(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[25],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6629,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6631,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],a[4]=t3,a[5]=((C_word*)t0)[9],tmp=(C_word)a,a+=6,tmp));
t7=(C_word)C_fixnump(((C_word*)t0)[6]);
t8=(C_truep(t7)?((C_word*)t0)[6]:(C_word)C_block_size(((C_word*)t0)[6]));
t9=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6677,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=t5,tmp=(C_word)a,a+=10,tmp);
t10=(C_word)C_eqp(C_fix(0),t8);
if(C_truep(t10)){
t11=t9;
f_6677(t11,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6721,a[2]=t3,tmp=(C_word)a,a+=3,tmp));}
else{
t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6735,a[2]=t3,a[3]=t8,a[4]=t9,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_fixnump(((C_word*)t0)[6]))){
/* posixunix.scm: 1762 ##sys#make-string */
t12=*((C_word*)lf[326]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,((C_word*)t0)[6]);}
else{
t12=t11;
f_6735(2,t12,((C_word*)t0)[6]);}}}

/* k6733 in k6627 in body1848 in ##sys#custom-output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6735(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6735,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=((C_word*)t0)[4];
f_6677(t4,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6736,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp));}

/* f_6736 in k6733 in k6627 in body1848 in ##sys#custom-output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6736(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6736,3,t0,t1,t2);}
if(C_truep(t2)){
t3=(C_word)C_u_fixnum_difference(((C_word*)t0)[5],((C_word*)((C_word*)t0)[4])[1]);
t4=(C_word)C_block_size(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6753,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[5],a[6]=t6,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp));
t8=((C_word*)t6)[1];
f_6753(t8,t1,t3,C_fix(0),t4);}
else{
if(C_truep((C_word)C_fixnum_lessp(C_fix(0),((C_word*)((C_word*)t0)[4])[1]))){
/* posixunix.scm: 1778 poke */
t3=((C_word*)((C_word*)t0)[3])[1];
f_6631(t3,t1,((C_word*)t0)[2],((C_word*)((C_word*)t0)[4])[1]);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}}

/* loop */
static void C_fcall f_6753(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_6753,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6763,a[2]=t4,a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1768 poke */
t7=((C_word*)((C_word*)t0)[4])[1];
f_6631(t7,t6,((C_word*)t0)[3],((C_word*)t0)[5]);}
else{
if(C_truep((C_word)C_fixnum_lessp(t2,t4))){
t6=(C_word)C_substring_copy(((C_word*)t0)[2],((C_word*)t0)[3],t3,t2,((C_word*)((C_word*)t0)[7])[1]);
t7=(C_word)C_u_fixnum_difference(t4,t2);
/* posixunix.scm: 1773 loop */
t13=t1;
t14=C_fix(0);
t15=t2;
t16=t7;
t1=t13;
t2=t14;
t3=t15;
t4=t16;
goto loop;}
else{
t6=(C_word)C_substring_copy(((C_word*)t0)[2],((C_word*)t0)[3],t3,t4,((C_word*)((C_word*)t0)[7])[1]);
t7=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],t4);
t8=C_mutate(((C_word *)((C_word*)t0)[7])+1,t7);
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}}}

/* k6761 in loop */
static void C_ccall f_6763(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_fix(0));
/* posixunix.scm: 1770 loop */
t3=((C_word*)((C_word*)t0)[5])[1];
f_6753(t3,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* f_6721 in k6627 in body1848 in ##sys#custom-output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6721(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6721,3,t0,t1,t2);}
if(C_truep(t2)){
t3=(C_word)C_block_size(t2);
/* posixunix.scm: 1761 poke */
t4=((C_word*)((C_word*)t0)[2])[1];
f_6631(t4,t1,t2,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k6675 in k6627 in body1848 in ##sys#custom-output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6677(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6677,NULL,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[9])+1,t1);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6681,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6686,a[2]=((C_word*)t0)[9],tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6692,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t4,tmp=(C_word)a,a+=7,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6713,a[2]=((C_word*)t0)[9],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1781 make-output-port */
t9=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t9+1)))(5,t9,t5,t6,t7,t8);}

/* a6712 in k6675 in k6627 in body1848 in ##sys#custom-output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6713(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6713,2,t0,t1);}
/* posixunix.scm: 1791 store */
t2=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,C_SCHEME_FALSE);}

/* a6691 in k6675 in k6627 in body1848 in ##sys#custom-output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6692(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6692,2,t0,t1);}
if(C_truep((C_word)C_slot(((C_word*)((C_word*)t0)[6])[1],C_fix(8)))){
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6702,a[2]=t1,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1788 posix-error */
t3=lf[1];
f_3480(7,t3,t2,lf[46],((C_word*)t0)[3],lf[332],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
t3=t2;
f_6702(2,t3,C_SCHEME_UNDEFINED);}}}

/* k6700 in a6691 in k6675 in k6627 in body1848 in ##sys#custom-output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6702(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1789 on-close */
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* a6685 in k6675 in k6627 in body1848 in ##sys#custom-output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6686(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6686,3,t0,t1,t2);}
/* posixunix.scm: 1783 store */
t3=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t1,t2);}

/* k6679 in k6675 in k6627 in body1848 in ##sys#custom-output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6681(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6681,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6684,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1792 set-port-name! */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[2]);}

/* k6682 in k6679 in k6675 in k6627 in body1848 in ##sys#custom-output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6684(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)((C_word*)t0)[2])[1]);}

/* poke in k6627 in body1848 in ##sys#custom-output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6631(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6631,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_write(((C_word*)t0)[5],t2,t3);
t5=(C_word)C_eqp(C_fix(-1),t4);
if(C_truep(t5)){
t6=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6647,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1751 ##sys#thread-yield! */
t8=*((C_word*)lf[318]+1);
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}
else{
/* posixunix.scm: 1753 posix-error */
t7=lf[1];
f_3480(7,t7,t1,((C_word*)t0)[3],lf[46],lf[331],((C_word*)t0)[5],((C_word*)t0)[2]);}}
else{
if(C_truep((C_word)C_fixnum_lessp(t4,t3))){
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6666,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1755 ##sys#substring */
t7=*((C_word*)lf[63]+1);
((C_proc5)(void*)(*((C_word*)t7+1)))(5,t7,t6,t2,t4,t3);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}}

/* k6664 in poke in k6627 in body1848 in ##sys#custom-output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6666(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_u_fixnum_difference(((C_word*)t0)[5],((C_word*)t0)[4]);
/* posixunix.scm: 1755 poke */
t3=((C_word*)((C_word*)t0)[3])[1];
f_6631(t3,((C_word*)t0)[2],t1,t2);}

/* k6645 in poke in k6627 in body1848 in ##sys#custom-output-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6647(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1752 poke */
t2=((C_word*)((C_word*)t0)[5])[1];
f_6631(t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6144(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(!C_demand(c*C_SIZEOF_PAIR+19)){
C_save_and_reclaim((void*)tr5r,(void*)f_6144r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_6144r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_6144r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word *a=C_alloc(19);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6146,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t4,a[6]=t2,tmp=(C_word)a,a+=7,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6533,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6538,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6543,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6548,a[2]=t9,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t5))){
/* def-nonblocking?16111809 */
t11=t10;
f_6548(t11,t1);}
else{
t11=(C_word)C_u_i_car(t5);
t12=(C_word)C_slot(t5,C_fix(1));
if(C_truep((C_word)C_i_nullp(t12))){
/* def-bufi16121805 */
t13=t9;
f_6543(t13,t1,t11);}
else{
t13=(C_word)C_u_i_car(t12);
t14=(C_word)C_slot(t12,C_fix(1));
if(C_truep((C_word)C_i_nullp(t14))){
/* def-on-close16131800 */
t15=t8;
f_6538(t15,t1,t11,t13);}
else{
t15=(C_word)C_u_i_car(t14);
t16=(C_word)C_slot(t14,C_fix(1));
if(C_truep((C_word)C_i_nullp(t16))){
/* def-more?16141794 */
t17=t7;
f_6533(t17,t1,t11,t13,t15);}
else{
t17=(C_word)C_u_i_car(t16);
t18=(C_word)C_slot(t16,C_fix(1));
/* body16091620 */
t19=t6;
f_6146(t19,t1,t11,t13,t15,t17);}}}}}

/* def-nonblocking?1611 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6548(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6548,NULL,2,t0,t1);}
/* def-bufi16121805 */
t2=((C_word*)t0)[2];
f_6543(t2,t1,C_SCHEME_FALSE);}

/* def-bufi1612 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6543(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6543,NULL,3,t0,t1,t2);}
/* def-on-close16131800 */
t3=((C_word*)t0)[2];
f_6538(t3,t1,t2,C_fix(1));}

/* def-on-close1613 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6538(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6538,NULL,4,t0,t1,t2,t3);}
/* def-more?16141794 */
t4=((C_word*)t0)[2];
f_6533(t4,t1,t2,t3,*((C_word*)lf[328]+1));}

/* def-more?1614 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6533(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6533,NULL,5,t0,t1,t2,t3,t4);}
/* body16091620 */
t5=((C_word*)t0)[2];
f_6146(t5,t1,t2,t3,t4,C_SCHEME_FALSE);}

/* body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6146(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6146,NULL,6,t0,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6150,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=t5,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],a[10]=t3,tmp=(C_word)a,a+=11,tmp);
if(C_truep(t2)){
/* posixunix.scm: 1617 ##sys#file-nonblocking! */
t7=*((C_word*)lf[7]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,((C_word*)t0)[5]);}
else{
t7=t6;
f_6150(2,t7,C_SCHEME_UNDEFINED);}}

/* k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6150(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6150,2,t0,t1);}
t2=(C_word)C_fixnump(((C_word*)t0)[10]);
t3=(C_truep(t2)?((C_word*)t0)[10]:(C_word)C_block_size(((C_word*)t0)[10]));
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6156,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t3,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
if(C_truep((C_word)C_fixnump(((C_word*)t0)[10]))){
/* posixunix.scm: 1619 ##sys#make-string */
t5=*((C_word*)lf[326]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[10]);}
else{
t5=t4;
f_6156(2,t5,((C_word*)t0)[10]);}}

/* k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6156(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word ab[65],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6156,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_fix(0);
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6157,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6180,a[2]=t1,a[3]=t3,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6188,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[10],a[5]=((C_word*)t0)[7],a[6]=t1,a[7]=((C_word*)t0)[9],a[8]=t3,a[9]=t5,tmp=(C_word)a,a+=10,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6270,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t10,tmp=(C_word)a,a+=6,tmp);
t12=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6275,a[2]=t8,a[3]=t5,a[4]=t7,tmp=(C_word)a,a+=5,tmp);
t13=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6288,a[2]=t6,a[3]=t3,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t14=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6300,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[10],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[3],a[6]=t10,tmp=(C_word)a,a+=7,tmp);
t15=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6321,a[2]=t8,a[3]=t7,tmp=(C_word)a,a+=4,tmp);
t16=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6330,a[2]=t8,a[3]=t1,a[4]=t3,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
t17=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6406,a[2]=t1,a[3]=t8,a[4]=t3,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1667 make-input-port */
t18=((C_word*)t0)[2];
((C_proc8)(void*)(*((C_word*)t18+1)))(8,t18,t11,t12,t13,t14,t15,t16,t17);}

/* a6405 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6406(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6406,4,t0,t1,t2,t3);}
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6412,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp));
t7=((C_word*)t5)[1];
f_6412(t7,t1,C_SCHEME_FALSE);}

/* loop in a6405 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6412(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6412,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6414,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep((C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[7])[1],((C_word*)((C_word*)t0)[6])[1]))){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6492,a[2]=t3,a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6498,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t4,t5);}
else{
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6508,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1732 fetch */
t5=((C_word*)t0)[5];
f_6188(t5,t4);}}

/* k6506 in loop in a6405 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6508(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[5])[1]))){
/* posixunix.scm: 1734 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_6412(t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_FILE);}}

/* a6497 in loop in a6405 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6498(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6498,4,t0,t1,t2,t3);}
if(C_truep(t3)){
/* posixunix.scm: 1729 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_6412(t4,t1,t2);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* a6491 in loop in a6405 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6492(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6492,2,t0,t1);}
/* posixunix.scm: 1727 ##sys#scan-buffer-line */
t2=*((C_word*)lf[327]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,t1,((C_word*)t0)[5],((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]);}

/* bumper in loop in a6405 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6414(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6414,4,t0,t1,t2,t3);}
t4=(C_word)C_u_fixnum_difference(t2,((C_word*)((C_word*)t0)[7])[1]);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6421,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=t2,a[7]=t3,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t6=(C_word)C_eqp(C_fix(0),t4);
if(C_truep(t6)){
t7=((C_word*)t0)[3];
t8=t5;
f_6421(2,t8,(C_truep(t7)?t7:lf[324]));}
else{
t7=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6464,a[2]=t5,a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=((C_word*)t0)[4],a[6]=t2,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[2],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1709 ##sys#make-string */
t8=*((C_word*)lf[326]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t4);}}

/* k6462 in bumper in loop in a6405 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6464(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_substring_copy(((C_word*)t0)[8],t1,((C_word*)((C_word*)t0)[7])[1],((C_word*)t0)[6],C_fix(0));
t3=(C_word)C_slot(((C_word*)t0)[5],C_fix(5));
t4=(C_word)C_u_fixnum_plus(t3,((C_word*)t0)[4]);
t5=(C_word)C_i_set_i_slot(((C_word*)t0)[5],C_fix(5),t4);
if(C_truep(((C_word*)t0)[3])){
/* posixunix.scm: 1715 ##sys#string-append */
t6=*((C_word*)lf[325]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,((C_word*)t0)[2],((C_word*)t0)[3],t1);}
else{
t6=((C_word*)t0)[2];
f_6421(2,t6,t1);}}

/* k6419 in bumper in loop in a6405 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6421(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6421,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[8])+1,((C_word*)t0)[7]);
t3=(C_word)C_eqp(((C_word*)t0)[6],((C_word*)t0)[7]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6431,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1719 fetch */
t5=((C_word*)t0)[3];
f_6188(t5,t4);}
else{
t4=(C_word)C_slot(((C_word*)t0)[2],C_fix(4));
t5=(C_word)C_u_fixnum_plus(t4,C_fix(1));
t6=(C_word)C_i_set_i_slot(((C_word*)t0)[2],C_fix(4),t5);
t7=(C_word)C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),C_fix(0));
/* posixunix.scm: 1724 values */
C_values(4,0,((C_word*)t0)[4],t1,C_SCHEME_FALSE);}}

/* k6429 in k6419 in bumper in loop in a6405 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6431(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]);
/* posixunix.scm: 1720 values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t2);}

/* a6329 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6330(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_6330,6,t0,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6338,a[2]=t5,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=t4,a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
if(C_truep(t3)){
t7=t6;
f_6338(t7,t3);}
else{
t7=(C_word)C_block_size(t4);
t8=t6;
f_6338(t8,(C_word)C_u_fixnum_difference(t7,t5));}}

/* k6336 in a6329 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6338(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6338,NULL,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6340,a[2]=((C_word*)t0)[4],a[3]=t3,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_6340(t5,((C_word*)t0)[3],t1,C_fix(0),((C_word*)t0)[2]);}

/* loop in k6336 in a6329 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6340(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_6340,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t3);}
else{
if(C_truep((C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[7])[1],((C_word*)((C_word*)t0)[6])[1]))){
t6=(C_word)C_u_fixnum_difference(((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[7])[1]);
t7=(C_word)C_fixnum_lessp(t2,t6);
t8=(C_truep(t7)?t2:t6);
t9=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],t8);
t10=(C_word)C_substring_copy(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[7])[1],t9,t4);
t11=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],t8);
t12=C_mutate(((C_word *)((C_word*)t0)[7])+1,t11);
t13=(C_word)C_u_fixnum_difference(t2,t8);
t14=(C_word)C_u_fixnum_plus(t3,t8);
t15=(C_word)C_u_fixnum_plus(t4,t8);
/* posixunix.scm: 1695 loop */
t18=t1;
t19=t13;
t20=t14;
t21=t15;
t1=t18;
t2=t19;
t3=t20;
t4=t21;
goto loop;}
else{
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6388,a[2]=t4,a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=t3,a[6]=t1,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 1697 fetch */
t7=((C_word*)t0)[2];
f_6188(t7,t6);}}}

/* k6386 in loop in k6336 in a6329 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6388(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(0),((C_word*)((C_word*)t0)[7])[1]);
if(C_truep(t2)){
t3=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,((C_word*)t0)[5]);}
else{
/* posixunix.scm: 1700 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_6340(t3,((C_word*)t0)[6],((C_word*)t0)[3],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* a6320 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6321(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6321,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6325,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1685 fetch */
t3=((C_word*)t0)[2];
f_6188(t3,t2);}

/* k6323 in a6320 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6325(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1686 peek */
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,f_6180(((C_word*)t0)[2]));}

/* a6299 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6300(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6300,2,t0,t1);}
if(C_truep((C_word)C_slot(((C_word*)((C_word*)t0)[6])[1],C_fix(8)))){
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6310,a[2]=t1,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1682 posix-error */
t3=lf[1];
f_3480(7,t3,t2,lf[46],((C_word*)t0)[3],lf[323],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
t3=t2;
f_6310(2,t3,C_SCHEME_UNDEFINED);}}}

/* k6308 in a6299 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6310(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1683 on-close */
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* a6287 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6288(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6288,2,t0,t1);}
t2=(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
/* posixunix.scm: 1677 ready? */
t3=((C_word*)t0)[2];
f_6157(t3,t1);}}

/* a6274 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6275(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6275,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6279,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1669 fetch */
t3=((C_word*)t0)[2];
f_6188(t3,t2);}

/* k6277 in a6274 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6279(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=f_6180(((C_word*)t0)[4]);
t3=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[3])[1],C_fix(1));
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,t3);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}

/* k6268 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6270(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6270,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6273,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1736 set-port-name! */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[2]);}

/* k6271 in k6268 in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6273(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)((C_word*)t0)[2])[1]);}

/* fetch in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6188(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6188,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[9])[1],((C_word*)((C_word*)t0)[8])[1]))){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6200,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=t3,a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],a[10]=((C_word*)t0)[7],tmp=(C_word)a,a+=11,tmp));
t5=((C_word*)t3)[1];
f_6200(t5,t1);}
else{
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* loop in fetch in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6200(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6200,NULL,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[10],((C_word*)t0)[9],((C_word*)t0)[8]);
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6216,a[2]=t1,a[3]=((C_word*)t0)[7],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1644 ##sys#thread-block-for-i/o! */
t6=*((C_word*)lf[319]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,*((C_word*)lf[320]+1),((C_word*)t0)[10],C_SCHEME_TRUE);}
else{
/* posixunix.scm: 1647 posix-error */
t5=lf[1];
f_3480(7,t5,t1,lf[46],((C_word*)t0)[6],lf[321],((C_word*)t0)[10],((C_word*)t0)[5]);}}
else{
t4=(C_truep(((C_word*)t0)[4])?(C_word)C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6237,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t1,a[10]=((C_word*)t0)[7],tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm: 1651 more? */
t6=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=C_mutate(((C_word *)((C_word*)t0)[3])+1,t2);
t6=C_set_block_item(((C_word*)t0)[2],0,C_fix(0));
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}}

/* k6235 in loop in fetch in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6237(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6237,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6240,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[10],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1653 ##sys#thread-yield! */
t3=*((C_word*)lf[318]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(C_word)C_read(((C_word*)t0)[8],((C_word*)t0)[7],((C_word*)t0)[6]);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6246,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[4],a[4]=t3,a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_eqp(((C_word*)t3)[1],C_fix(-1));
if(C_truep(t5)){
t6=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t6)){
t7=C_set_block_item(t3,0,C_fix(0));
t8=t4;
f_6246(2,t8,t7);}
else{
/* posixunix.scm: 1659 posix-error */
t7=lf[1];
f_3480(7,t7,t4,lf[46],((C_word*)t0)[3],lf[322],((C_word*)t0)[8],((C_word*)t0)[2]);}}
else{
t6=t4;
f_6246(2,t6,C_SCHEME_UNDEFINED);}}}

/* k6244 in k6235 in loop in fetch in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6246(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,((C_word*)((C_word*)t0)[4])[1]);
t3=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k6238 in k6235 in loop in fetch in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6240(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1654 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_6200(t2,((C_word*)t0)[2]);}

/* k6214 in loop in fetch in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6216(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6216,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6219,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1645 ##sys#thread-yield! */
t3=*((C_word*)lf[318]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k6217 in k6214 in loop in fetch in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6219(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1646 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_6200(t2,((C_word*)t0)[2]);}

/* peek in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_6180(C_word t0){
C_word tmp;
C_word t1;
C_word t2;
t1=(C_word)C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
return((C_truep(t1)?C_SCHEME_END_OF_FILE:(C_word)C_subchar(((C_word*)t0)[2],((C_word*)((C_word*)t0)[4])[1])));}

/* ready? in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6157(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6157,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6161,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1625 ##sys#file-select-one */
t3=*((C_word*)lf[8]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}

/* k6159 in ready? in k6154 in k6148 in body1609 in ##sys#custom-input-port in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6161(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
t3=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t3)){
t4=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}
else{
/* posixunix.scm: 1629 posix-error */
t4=lf[1];
f_3480(7,t4,((C_word*)t0)[5],lf[46],((C_word*)t0)[4],lf[317],((C_word*)t0)[3],((C_word*)t0)[2]);}}
else{
t3=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t1));}}

/* duplicate-fileno in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6117(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_6117r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_6117r(t0,t1,t2,t3);}}

static void C_ccall f_6117r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_exact_2(t2,*((C_word*)lf[312]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6124,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_vemptyp(t3))){
t6=t5;
f_6124(t6,(C_word)C_dup(t2));}
else{
t6=(C_word)C_slot(t3,C_fix(0));
t7=(C_word)C_i_check_exact_2(t6,lf[312]);
t8=t5;
f_6124(t8,(C_word)C_dup2(t2,t6));}}

/* k6122 in duplicate-fileno in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6124(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6124,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6127,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 1610 posix-error */
t3=lf[1];
f_3480(6,t3,t2,lf[46],lf[312],lf[313],((C_word*)t0)[2]);}
else{
t3=t2;
f_6127(2,t3,C_SCHEME_UNDEFINED);}}

/* k6125 in k6122 in duplicate-fileno in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6127(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6072(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6072,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6076,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1592 ##sys#check-port */
t4=*((C_word*)lf[164]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[306]);}

/* k6074 in port->fileno in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6076(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6076,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(lf[307],t2);
if(C_truep(t3)){
/* posixunix.scm: 1593 ##sys#tcp-port->fileno */
t4=*((C_word*)lf[308]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,((C_word*)t0)[2],((C_word*)t0)[3]);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6111,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1594 ##sys#peek-unsigned-integer */
t5=*((C_word*)lf[311]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[3],C_fix(0));}}

/* k6109 in k6074 in port->fileno in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6111(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6111,2,t0,t1);}
if(C_truep((C_word)C_i_zerop(t1))){
/* posixunix.scm: 1599 posix-error */
t2=lf[1];
f_3480(6,t2,((C_word*)t0)[3],lf[57],lf[306],lf[309],((C_word*)t0)[2]);}
else{
t2=(C_word)C_C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6094,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1597 posix-error */
t4=lf[1];
f_3480(6,t4,t3,lf[46],lf[306],lf[310],((C_word*)t0)[2]);}
else{
t4=t3;
f_6094(2,t4,C_SCHEME_UNDEFINED);}}}

/* k6092 in k6109 in k6074 in port->fileno in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6094(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6058(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_6058r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6058r(t0,t1,t2,t3);}}

static void C_ccall f_6058r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[305]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6070,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1588 mode */
f_5992(t5,C_SCHEME_FALSE,t3);}

/* k6068 in open-output-file* in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6070(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6070,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixunix.scm: 1588 check */
f_6029(((C_word*)t0)[2],lf[305],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6044(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_6044r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6044r(t0,t1,t2,t3);}}

static void C_ccall f_6044r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[304]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6056,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1584 mode */
f_5992(t5,C_SCHEME_TRUE,t3);}

/* k6054 in open-input-file* in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6056(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6056,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixunix.scm: 1584 check */
f_6029(((C_word*)t0)[2],lf[304],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_6029(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6029,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posixunix.scm: 1577 posix-error */
t6=lf[1];
f_3480(6,t6,t1,lf[46],t2,lf[302],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6042,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1578 ##sys#make-port */
t7=*((C_word*)lf[155]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[156]+1),lf[303],lf[96]);}}

/* k6040 in check in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6042(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* mode in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_5992(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5992,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6000,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_pairp(t3))){
t5=(C_word)C_u_i_car(t3);
t6=(C_word)C_eqp(t5,lf[296]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
/* posixunix.scm: 1571 ##sys#error */
t8=*((C_word*)lf[152]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[297],t5);}
else{
t8=t4;
f_6000(2,t8,lf[298]);}}
else{
/* posixunix.scm: 1572 ##sys#error */
t7=*((C_word*)lf[152]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[299],t5);}}
else{
t5=t4;
f_6000(2,t5,(C_truep(t2)?lf[300]:lf[301]));}}

/* k5998 in mode in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_6000(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1567 ##sys#make-c-string */
t2=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* file-link in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5967(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5967,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[290]);
t5=(C_word)C_i_check_string_2(t3,lf[290]);
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5956,a[2]=t7,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
/* ##sys#make-c-string */
t9=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t6);}
else{
t9=t8;
f_5956(2,t9,C_SCHEME_FALSE);}}

/* k5954 in file-link in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5956(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5956,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5960,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[2])){
/* ##sys#make-c-string */
t3=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t3=t2;
f_5960(2,t3,C_SCHEME_FALSE);}}

/* k5958 in k5954 in file-link in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5960(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)stub1489(C_SCHEME_UNDEFINED,((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1552 posix-error */
t3=lf[1];
f_3480(7,t3,((C_word*)t0)[4],lf[46],lf[291],lf[292],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* read-symbolic-link in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5898(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3rv,(void*)f_5898r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_5898r(t0,t1,t2,t3);}}

static void C_ccall f_5898r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(10);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
t6=(C_word)C_i_check_string_2(t2,lf[287]);
t7=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5909,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=t1,a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5937,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1538 ##sys#expand-home-path */
t9=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}

/* k5935 in read-symbolic-link in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5937(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1538 ##sys#make-c-string */
t2=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5907 in read-symbolic-link in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5909(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5909,2,t0,t1);}
t2=(C_word)C_readlink(t1,((C_word*)t0)[6]);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5912,a[2]=t2,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1540 posix-error */
t4=lf[1];
f_3480(6,t4,t3,lf[46],lf[287],lf[289],((C_word*)t0)[2]);}
else{
t4=t3;
f_5912(2,t4,C_SCHEME_UNDEFINED);}}

/* k5910 in k5907 in read-symbolic-link in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5912(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5912,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5915,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1541 substring */
t3=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* k5913 in k5910 in k5907 in read-symbolic-link in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5915(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5915,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5921,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[2])){
/* posixunix.scm: 1542 symbolic-link? */
t3=*((C_word*)lf[82]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,t1);}
else{
t3=t2;
f_5921(2,t3,C_SCHEME_FALSE);}}

/* k5919 in k5913 in k5910 in k5907 in read-symbolic-link in k5895 in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5921(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 1543 read-symbolic-link */
t2=*((C_word*)lf[287]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[288]);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}}

/* create-symbolic-link in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5860(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5860,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[283]);
t5=(C_word)C_i_check_string_2(t3,lf[283]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5881,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5893,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1526 ##sys#expand-home-path */
t8=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k5891 in create-symbolic-link in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5893(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1526 ##sys#make-c-string */
t2=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5879 in create-symbolic-link in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5881(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5881,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5885,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5889,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1527 ##sys#expand-home-path */
t4=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k5887 in k5879 in create-symbolic-link in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5889(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1527 ##sys#make-c-string */
t2=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5883 in k5879 in create-symbolic-link in k5856 in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5885(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_symlink(((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1529 posix-error */
t3=lf[1];
f_3480(7,t3,((C_word*)t0)[4],lf[46],lf[284],lf[285],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* create-session in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5841(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5841,2,t0,t1);}
t2=(C_word)C_setsid(C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5845,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5851,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1497 ##sys#update-errno */
t5=*((C_word*)lf[5]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_5845(2,t4,C_SCHEME_UNDEFINED);}}

/* k5849 in create-session in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5851(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1498 ##sys#error */
t2=*((C_word*)lf[152]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[280],lf[281]);}

/* k5843 in create-session in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5845(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-execute-access? in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5835(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5835,3,t0,t1,t2);}
/* posixunix.scm: 1492 check */
f_5799(t1,t2,C_fix((C_word)X_OK),lf[279]);}

/* file-write-access? in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5829(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5829,3,t0,t1,t2);}
/* posixunix.scm: 1491 check */
f_5799(t1,t2,C_fix((C_word)W_OK),lf[278]);}

/* file-read-access? in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5823(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5823,3,t0,t1,t2);}
/* posixunix.scm: 1490 check */
f_5799(t1,t2,C_fix((C_word)R_OK),lf[277]);}

/* check in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_5799(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5799,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5817,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5821,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1487 ##sys#expand-home-path */
t8=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k5819 in check in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5821(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1487 ##sys#make-c-string */
t2=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5815 in check in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5817(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5817,2,t0,t1);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5809,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_5809(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1488 ##sys#update-errno */
t5=*((C_word*)lf[5]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k5807 in k5815 in check in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5809(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* change-file-owner in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5769(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_5769,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,lf[275]);
t6=(C_word)C_i_check_exact_2(t3,lf[275]);
t7=(C_word)C_i_check_exact_2(t4,lf[275]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5793,a[2]=t2,a[3]=t1,a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5797,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1477 ##sys#expand-home-path */
t10=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}

/* k5795 in change-file-owner in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5797(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1477 ##sys#make-c-string */
t2=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5791 in change-file-owner in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5793(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_chown(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1478 posix-error */
t3=lf[1];
f_3480(8,t3,((C_word*)t0)[3],lf[46],lf[275],lf[276],((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* change-file-mode in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5742(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5742,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[273]);
t5=(C_word)C_i_check_exact_2(t3,lf[273]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5763,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5767,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1469 ##sys#expand-home-path */
t8=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k5765 in change-file-mode in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5767(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1469 ##sys#make-c-string */
t2=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5761 in change-file-mode in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5763(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1470 posix-error */
t3=lf[1];
f_3480(7,t3,((C_word*)t0)[3],lf[46],lf[273],lf[274],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* initialize-groups in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5678(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5678,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[232]);
t5=(C_word)C_i_check_exact_2(t3,lf[232]);
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5674,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t7,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
/* ##sys#make-c-string */
t9=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t6);}
else{
t9=t8;
f_5674(2,t9,C_SCHEME_FALSE);}}

/* k5672 in initialize-groups in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5674(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5674,2,t0,t1);}
t2=(C_word)stub1293(C_SCHEME_UNDEFINED,t1,((C_word*)t0)[5]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5694,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1390 ##sys#update-errno */
t4=*((C_word*)lf[5]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k5692 in k5672 in initialize-groups in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5694(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1391 ##sys#error */
t2=*((C_word*)lf[152]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[232],lf[233],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-groups! in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5612(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5612,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5616,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_i_length(t2);
t5=f_5546(t4);
if(C_truep(t5)){
t6=t3;
f_5616(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1373 ##sys#error */
t6=*((C_word*)lf[152]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,lf[229],lf[231]);}}

/* k5614 in set-groups! in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5616(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5616,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5621,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_5621(t5,((C_word*)t0)[2],((C_word*)t0)[3],C_fix(0));}

/* doloop1269 in k5614 in set-groups! in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_5621(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_5621,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
if(C_truep((C_word)C_fixnum_lessp((C_word)C_set_groups(t3),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5637,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1378 ##sys#update-errno */
t5=*((C_word*)lf[5]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_i_check_exact_2(t4,lf[229]);
t6=(C_word)C_set_gid(t3,t4);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_u_fixnum_plus(t3,C_fix(1));
t11=t1;
t12=t7;
t13=t8;
t1=t11;
t2=t12;
t3=t13;
goto loop;}}

/* k5635 in doloop1269 in k5614 in set-groups! in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5637(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1379 ##sys#error */
t2=*((C_word*)lf[152]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[229],lf[230],((C_word*)t0)[2]);}

/* get-groups in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5549(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5549,2,t0,t1);}
t2=C_fix((C_word)getgroups(0, C_groups));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5553,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5607,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1359 ##sys#update-errno */
t5=*((C_word*)lf[5]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_5553(2,t4,C_SCHEME_UNDEFINED);}}

/* k5605 in get-groups in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5607(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1360 ##sys#error */
t2=*((C_word*)lf[152]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[225],lf[228]);}

/* k5551 in get-groups in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5553(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5553,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5556,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=f_5546(((C_word*)t0)[3]);
if(C_truep(t3)){
t4=t2;
f_5556(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1362 ##sys#error */
t4=*((C_word*)lf[152]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,lf[225],lf[227]);}}

/* k5554 in k5551 in get-groups in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5556(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5556,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5559,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)stub1228(C_SCHEME_UNDEFINED,((C_word*)t0)[3]);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5588,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1364 ##sys#update-errno */
t5=*((C_word*)lf[5]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t2;
f_5559(2,t4,C_SCHEME_UNDEFINED);}}

/* k5586 in k5554 in k5551 in get-groups in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5588(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1365 ##sys#error */
t2=*((C_word*)lf[152]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[225],lf[226]);}

/* k5557 in k5554 in k5551 in get-groups in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5559(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5559,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5564,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_5564(t5,((C_word*)t0)[2],C_fix(0));}

/* loop in k5557 in k5554 in k5551 in get-groups in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_5564(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_5564,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[3]))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5578,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_u_fixnum_plus(t2,C_fix(1));
/* posixunix.scm: 1369 loop */
t6=t3;
t7=t4;
t1=t6;
t2=t7;
goto loop;}}

/* k5576 in loop in k5557 in k5554 in k5551 in get-groups in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5578(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5578,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,(C_word)C_get_gid(((C_word*)t0)[2]),t1));}

/* _ensure-groups in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_5546(C_word t1){
C_word tmp;
C_word t2;
return((C_word)stub1234(C_SCHEME_UNDEFINED,t1));}

/* group-information in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5471(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3rv,(void*)f_5471r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_5471r(t0,t1,t2,t3);}}

static void C_ccall f_5471r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(7);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5478,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t7=t6;
f_5478(t7,(C_word)C_getgrgid(t2));}
else{
t7=(C_word)C_i_check_string_2(t2,lf[223]);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5529,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1333 ##sys#make-c-string */
t9=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}}

/* k5527 in group-information in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5529(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_5478(t2,(C_word)C_getgrnam(t1));}

/* k5476 in group-information in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_5478(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5478,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5488,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[213]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k5486 in k5476 in group-information in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5488(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5488,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5492,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[213]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_passwd),C_fix(0));}

/* k5490 in k5486 in k5476 in group-information in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5492(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5492,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5496,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5501,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t6=((C_word*)t4)[1];
f_5501(t6,t2,C_fix(0));}

/* loop in k5490 in k5486 in k5476 in group-information in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_5501(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5501,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5505,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub1186(t5,t4),C_fix(0));}

/* k5503 in loop in k5490 in k5486 in k5476 in group-information in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5505(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5505,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5515,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 1342 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_5501(t4,t2,t3);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* k5513 in k5503 in loop in k5490 in k5486 in k5476 in group-information in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5515(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5515,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k5494 in k5490 in k5486 in k5476 in group-information in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5496(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(((C_word*)t0)[5])?*((C_word*)lf[220]+1):*((C_word*)lf[221]+1));
t3=t2;
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],C_fix((C_word)C_group->gr_gid),t1);}

/* current-effective-user-name in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5451(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5451,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5459,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5463,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1318 current-effective-user-id */
t4=*((C_word*)lf[216]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k5461 in current-effective-user-name in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5463(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1318 user-information */
t2=*((C_word*)lf[219]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5457 in current-effective-user-name in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5459(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_u_i_list_ref(t1,C_fix(0)));}

/* current-user-name in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5437(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5437,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5445,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5449,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1315 current-user-id */
t4=*((C_word*)lf[215]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k5447 in current-user-name in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5449(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1315 user-information */
t2=*((C_word*)lf[219]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5443 in current-user-name in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5445(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_u_i_list_ref(t1,C_fix(0)));}

/* user-information in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5377(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3rv,(void*)f_5377r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_5377r(t0,t1,t2,t3);}}

static void C_ccall f_5377r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(7);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5384,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t7=t6;
f_5384(t7,(C_word)C_getpwuid(t2));}
else{
t7=(C_word)C_i_check_string_2(t2,lf[219]);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5423,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1303 ##sys#make-c-string */
t9=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}}

/* k5421 in user-information in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5423(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_5384(t2,(C_word)C_getpwnam(t1));}

/* k5382 in user-information in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_5384(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5384,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5394,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[213]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k5392 in k5382 in user-information in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5394(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5394,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5398,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[213]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_passwd),C_fix(0));}

/* k5396 in k5392 in k5382 in user-information in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5398(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5398,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5402,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[213]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_gecos),C_fix(0));}

/* k5400 in k5396 in k5392 in k5382 in user-information in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5402(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5402,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5406,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_dir),C_fix(0));}

/* k5404 in k5400 in k5396 in k5392 in k5382 in user-information in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5406(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5406,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5410,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_shell),C_fix(0));}

/* k5408 in k5404 in k5400 in k5396 in k5392 in k5382 in user-information in k5373 in k5369 in k5365 in k5361 in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5410(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(((C_word*)t0)[7])?*((C_word*)lf[220]+1):*((C_word*)lf[221]+1));
t3=t2;
((C_proc9)(void*)(*((C_word*)t3+1)))(9,t3,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],C_fix((C_word)C_user->pw_uid),C_fix((C_word)C_user->pw_gid),((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* system-information in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5323(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5323,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5327,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5356,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1248 ##sys#update-errno */
t4=*((C_word*)lf[5]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_5327(2,t3,C_SCHEME_UNDEFINED);}}

/* k5354 in system-information in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5356(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1249 ##sys#error */
t2=*((C_word*)lf[152]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[212],lf[214]);}

/* k5325 in system-information in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5327(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5327,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5334,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[213]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.sysname),C_fix(0));}

/* k5332 in k5325 in system-information in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5334(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5334,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5338,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[213]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.nodename),C_fix(0));}

/* k5336 in k5332 in k5325 in system-information in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5338(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5338,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5342,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[213]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.release),C_fix(0));}

/* k5340 in k5336 in k5332 in k5325 in system-information in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5342(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5342,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5346,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[213]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.version),C_fix(0));}

/* k5344 in k5340 in k5336 in k5332 in k5325 in system-information in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5346(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5346,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5350,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[213]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.machine),C_fix(0));}

/* k5348 in k5344 in k5340 in k5336 in k5332 in k5325 in system-information in k5319 in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5350(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5350,2,t0,t1);}
t2=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,5,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* signal-unmask! in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5305(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5305,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[210]);
t4=(C_word)C_sigdelset(t2);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask_unblock(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 1227 posix-error */
t5=lf[1];
f_3480(5,t5,t1,lf[204],lf[210],lf[211]);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* signal-mask! in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5290(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5290,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[208]);
t4=(C_word)C_sigaddset(t2);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask_block(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 1221 posix-error */
t5=lf[1];
f_3480(5,t5,t1,lf[204],lf[208],lf[209]);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* signal-masked? in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5284(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5284,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[207]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_sigismember(t2));}

/* signal-mask in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5252(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5252,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5258,a[2]=t3,tmp=(C_word)a,a+=3,tmp));
t5=((C_word*)t3)[1];
f_5258(t5,t1,*((C_word*)lf[199]+1),C_SCHEME_END_OF_LIST);}

/* loop in signal-mask in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_5258(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
a=C_alloc(3);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_5258,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_u_i_car(t2);
t5=(C_word)C_slot(t2,C_fix(1));
t6=(C_truep((C_word)C_sigismember(t4))?(C_word)C_a_i_cons(&a,2,t4,t3):t3);
/* posixunix.scm: 1211 loop */
t8=t1;
t9=t5;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}

/* set-signal-mask! in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5228(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5228,3,t0,t1,t2);}
t3=(C_word)C_i_check_list_2(t2,lf[203]);
t4=(C_word)C_sigemptyset(C_fix(0));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5235,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5246,tmp=(C_word)a,a+=2,tmp);
/* for-each */
t7=*((C_word*)lf[67]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,t2);}

/* a5245 in set-signal-mask! in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5246(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5246,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[203]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_sigaddset(t2));}

/* k5233 in set-signal-mask! in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5235(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask_set(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 1204 posix-error */
t2=lf[1];
f_3480(5,t2,((C_word*)t0)[2],lf[204],lf[203],lf[205]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* ##sys#interrupt-hook in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5210(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5210,4,t0,t1,t2,t3);}
t4=(C_word)C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5220,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1190 h */
t6=t4;
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}
else{
/* posixunix.scm: 1192 oldhook */
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t2,t3);}}

/* k5218 in ##sys#interrupt-hook in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5220(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1191 ##sys#context-switch */
C_context_switch(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5197(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5197,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[202]);
t5=(C_truep(t3)?t2:C_SCHEME_FALSE);
t6=(C_word)C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,(C_word)C_i_setslot(((C_word*)t0)[2],t2,t3));}

/* signal-handler in k5184 in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5188(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5188,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[201]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(((C_word*)t0)[2],t2));}

/* create-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5141(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5141,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5145,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE),C_fix(0)))){
/* posixunix.scm: 1107 posix-error */
t3=lf[1];
f_3480(5,t3,t2,lf[46],lf[172],lf[173]);}
else{
t3=t2;
f_5145(2,t3,C_SCHEME_UNDEFINED);}}

/* k5143 in create-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5145(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1108 values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5121(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_5121r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_5121r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5121r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[171]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5125,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k5123 in with-output-to-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5125(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5125,2,t0,t1);}
t2=C_mutate((C_word*)lf[171]+1 /* (set! standard-output ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5131,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1095 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a5130 in k5123 in with-output-to-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5131(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_5131r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_5131r(t0,t1,t2);}}

static void C_ccall f_5131r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5135,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1097 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k5133 in a5130 in k5123 in with-output-to-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5135(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[171]+1 /* (set! standard-output ...) */,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* with-input-from-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5101(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_5101r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_5101r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5101r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[169]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5105,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k5103 in with-input-from-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5105(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5105,2,t0,t1);}
t2=C_mutate((C_word*)lf[169]+1 /* (set! standard-input ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5111,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1085 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a5110 in k5103 in with-input-from-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5111(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_5111r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_5111r(t0,t1,t2);}}

static void C_ccall f_5111r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5115,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1087 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k5113 in a5110 in k5103 in with-input-from-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5115(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[169]+1 /* (set! standard-input ...) */,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* call-with-output-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5077(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_5077r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_5077r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5077r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5081,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k5079 in call-with-output-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5081(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5081,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5086,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5092,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1075 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a5091 in k5079 in call-with-output-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5092(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_5092r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_5092r(t0,t1,t2);}}

static void C_ccall f_5092r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5096,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1078 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k5094 in a5091 in k5079 in call-with-output-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5096(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a5085 in k5079 in call-with-output-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5086(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5086,2,t0,t1);}
/* posixunix.scm: 1076 proc */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5053(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_5053r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_5053r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5053r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5057,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k5055 in call-with-input-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5057(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5057,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5062,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5068,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1067 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a5067 in k5055 in call-with-input-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5068(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_5068r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_5068r(t0,t1,t2);}}

static void C_ccall f_5068r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5072,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1070 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k5070 in a5067 in k5055 in call-with-input-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5072(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a5061 in k5055 in call-with-input-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5062(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5062,2,t0,t1);}
/* posixunix.scm: 1068 proc */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5037(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5037,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5041,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1054 ##sys#check-port */
t4=*((C_word*)lf[164]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[161]);}

/* k5039 in close-input-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5041(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5041,2,t0,t1);}
t2=(C_word)close_pipe(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5044,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 1056 posix-error */
t5=lf[1];
f_3480(6,t5,t3,lf[46],lf[162],lf[163],((C_word*)t0)[3]);}
else{
t5=t3;
f_5044(2,t5,C_SCHEME_UNDEFINED);}}

/* k5042 in k5039 in close-input-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5044(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5001(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr3r,(void*)f_5001r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5001r(t0,t1,t2,t3);}}

static void C_ccall f_5001r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(8);
t4=(C_word)C_i_check_string_2(t2,lf[160]);
t5=f_4932(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5015,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[151]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5022,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1049 ##sys#make-c-string */
t9=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[159]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5032,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1050 ##sys#make-c-string */
t10=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixunix.scm: 1051 badmode */
f_4944(t6,t5);}}}

/* k5030 in open-output-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5032(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5032,2,t0,t1);}
t2=((C_word*)t0)[2];
f_5015(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

/* k5020 in open-output-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5022(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5022,2,t0,t1);}
t2=((C_word*)t0)[2];
f_5015(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

/* k5013 in open-output-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_5015(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1045 check */
f_4950(((C_word*)t0)[3],lf[160],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4965(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr3r,(void*)f_4965r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4965r(t0,t1,t2,t3);}}

static void C_ccall f_4965r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(8);
t4=(C_word)C_i_check_string_2(t2,lf[158]);
t5=f_4932(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4979,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[151]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4986,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1038 ##sys#make-c-string */
t9=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[159]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4996,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1039 ##sys#make-c-string */
t10=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixunix.scm: 1040 badmode */
f_4944(t6,t5);}}}

/* k4994 in open-input-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4996(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4996,2,t0,t1);}
t2=((C_word*)t0)[2];
f_4979(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

/* k4984 in open-input-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4986(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4986,2,t0,t1);}
t2=((C_word*)t0)[2];
f_4979(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

/* k4977 in open-input-pipe in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4979(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1034 check */
f_4950(((C_word*)t0)[3],lf[158],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4950(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4950,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posixunix.scm: 1026 posix-error */
t6=lf[1];
f_3480(6,t6,t1,lf[46],t2,lf[154],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4963,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1027 ##sys#make-port */
t7=*((C_word*)lf[155]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[156]+1),lf[157],lf[96]);}}

/* k4961 in check in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4963(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* badmode in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4944(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4944,NULL,2,t1,t2);}
/* posixunix.scm: 1023 ##sys#error */
t3=*((C_word*)lf[152]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[153],t2);}

/* mode in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_4932(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[151]));}

/* canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4615(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[25],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4615,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[136]);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4622,a[2]=t1,a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[12],tmp=(C_word)a,a+=9,tmp);
t5=(C_word)C_block_size(t2);
t6=(C_word)C_eqp(C_fix(0),t5);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4736,a[2]=t4,a[3]=((C_word*)t0)[11],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 971  cwd */
t8=((C_word*)t0)[6];
f_4559(t8,t7);}
else{
t7=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_4742,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[12],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[11],a[10]=t2,a[11]=t4,tmp=(C_word)a,a+=12,tmp);
t8=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(3)))){
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4922,a[2]=((C_word*)t0)[12],a[3]=t7,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 973  sref */
t10=((C_word*)t0)[9];
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t9,t2,C_fix(0));}
else{
t9=t7;
f_4742(t9,C_SCHEME_FALSE);}}}

/* k4920 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4922(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 973  sep? */
t2=((C_word*)t0)[3];
f_4742(t2,f_4548(t1));}

/* k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4742(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4742,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[11];
f_4622(2,t2,((C_word*)t0)[10]);}
else{
t2=(C_word)C_block_size(((C_word*)t0)[10]);
t3=(C_word)C_eqp(C_fix(1),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4755,a[2]=((C_word*)t0)[10],a[3]=((C_word*)t0)[11],a[4]=((C_word*)t0)[9],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 976  cwd */
t5=((C_word*)t0)[8];
f_4559(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_4761,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[9],tmp=(C_word)a,a+=12,tmp);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4897,a[2]=((C_word*)t0)[10],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4908,a[2]=t5,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 977  sref */
t7=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t6,((C_word*)t0)[10],C_fix(0));}}}

/* k4906 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4908(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 977  char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(126),t1);}

/* k4895 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4897(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4897,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4904,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 978  sref */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_4761(t2,C_SCHEME_FALSE);}}

/* k4902 in k4895 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4904(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 978  sep? */
t2=((C_word*)t0)[3];
f_4761(t2,f_4548(t1));}

/* k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4761(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4761,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4768,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],a[5]=((C_word*)t0)[11],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 980  get-environment-variable */
t3=((C_word*)t0)[7];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[148]);}
else{
t2=(C_word)C_block_size(((C_word*)t0)[9]);
t3=(C_word)C_eqp(C_fix(2),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4799,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[10],a[4]=((C_word*)t0)[11],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 985  cwd */
t5=((C_word*)t0)[6];
f_4559(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4805,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4869,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t4,tmp=(C_word)a,a+=7,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4890,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 986  sref */
t7=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t6,((C_word*)t0)[9],C_fix(0));}}}

/* k4888 in k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4890(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 986  alpha? */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4867 in k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4869(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4869,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4875,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4886,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 987  sref */
t4=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[6];
f_4805(t2,C_SCHEME_FALSE);}}

/* k4884 in k4867 in k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4886(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 987  char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k4873 in k4867 in k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4875(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4875,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4882,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 988  sref */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[5];
f_4805(t2,C_SCHEME_FALSE);}}

/* k4880 in k4873 in k4867 in k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4882(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 988  sep? */
t2=((C_word*)t0)[3];
f_4805(t2,f_4548(t1));}

/* k4803 in k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4805(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4805,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_block_size(((C_word*)t0)[9]);
/* posixunix.scm: 989  ##sys#substring */
t3=*((C_word*)lf[63]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[8],((C_word*)t0)[9],C_fix(3),t2);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4818,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4845,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4866,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 990  sref */
t5=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[9],C_fix(0));}}

/* k4864 in k4803 in k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4866(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 990  char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(47),t1);}

/* k4843 in k4803 in k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4845(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4845,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4851,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4862,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 991  sref */
t4=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_4818(2,t2,C_SCHEME_FALSE);}}

/* k4860 in k4843 in k4803 in k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4862(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 991  alpha? */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4849 in k4843 in k4803 in k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4851(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4851,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4858,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 992  sref */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[4];
f_4818(2,t2,C_SCHEME_FALSE);}}

/* k4856 in k4849 in k4843 in k4803 in k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4858(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 992  char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k4816 in k4803 in k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4818(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4818,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_block_size(((C_word*)t0)[7]);
/* posixunix.scm: 993  ##sys#substring */
t3=*((C_word*)lf[63]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[6],((C_word*)t0)[7],C_fix(3),t2);}
else{
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4842,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 994  sref */
t3=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[7],C_fix(0));}}

/* k4840 in k4816 in k4803 in k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4842(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4842,2,t0,t1);}
t2=f_4548(t1);
if(C_truep(t2)){
t3=((C_word*)t0)[5];
f_4622(2,t3,((C_word*)t0)[4]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4838,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 997  cwd */
t4=((C_word*)t0)[2];
f_4559(t4,t3);}}

/* k4836 in k4840 in k4816 in k4803 in k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4838(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 997  sappend */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],t1,lf[150],((C_word*)t0)[2]);}

/* k4797 in k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4799(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 985  sappend */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],t1,lf[149],((C_word*)t0)[2]);}

/* k4766 in k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4768(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4768,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4771,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(t1)){
t3=t2;
f_4771(2,t3,t1);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4786,a[2]=t2,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 981  user */
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k4784 in k4766 in k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4786(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 981  sappend */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[147],t1);}

/* k4769 in k4766 in k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4771(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4771,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4775,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixunix.scm: 982  ##sys#substring */
t4=*((C_word*)lf[63]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(1),t3);}

/* k4773 in k4769 in k4766 in k4759 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4775(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 979  sappend */
t2=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k4753 in k4740 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4755(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 976  sappend */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],t1,lf[146],((C_word*)t0)[2]);}

/* k4734 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4736(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 971  sappend */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],t1,lf[145]);}

/* k4620 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4622(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4622,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4629,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
t3=t1;
/* string-split */
t4=*((C_word*)lf[109]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,t3,lf[144]);}

/* k4627 in k4620 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4629(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4629,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4631,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_4631(t5,((C_word*)t0)[2],t1,C_SCHEME_END_OF_LIST);}

/* loop in k4627 in k4620 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4631(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4631,NULL,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4638,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t3,a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[9],a[12]=t1,tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 1000 null? */
t5=((C_word*)t0)[4];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k4636 in loop in k4627 in k4620 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4638(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4638,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4644,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[12],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1001 null? */
t3=((C_word*)t0)[5];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[8]);}
else{
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(1));
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4699,a[2]=t2,a[3]=((C_word*)t0)[12],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4702,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[8],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_u_i_car(((C_word*)t0)[4]);
/* posixunix.scm: 1012 string=? */
t6=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[143],t5);}}

/* k4700 in k4636 in loop in k4627 in k4620 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4702(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4702,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[5];
f_4699(t2,(C_word)C_slot(((C_word*)t0)[4],C_fix(1)));}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4711,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_u_i_car(((C_word*)t0)[3]);
/* posixunix.scm: 1014 string=? */
t4=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,lf[142],t3);}}

/* k4709 in k4700 in k4636 in loop in k4627 in k4620 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4711(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4711,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
f_4699(t2,((C_word*)t0)[3]);}
else{
t2=(C_word)C_u_i_car(((C_word*)t0)[2]);
t3=((C_word*)t0)[4];
f_4699(t3,(C_word)C_a_i_cons(&a,2,t2,((C_word*)t0)[3]));}}

/* k4697 in k4636 in loop in k4627 in k4620 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4699(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1010 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4631(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k4642 in k4636 in loop in k4627 in k4620 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4644(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4644,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[8];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,lf[137]);}
else{
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4680,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[3]);
t4=(C_word)C_a_i_minus(&a,2,t3,C_fix(1));
/* posixunix.scm: 1003 sref */
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,((C_word*)t0)[3],t4);}}

/* k4678 in k4642 in k4636 in loop in k4627 in k4620 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4680(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4680,2,t0,t1);}
t2=f_4548(t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4657,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4661,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_a_i_cons(&a,2,lf[139],((C_word*)t0)[2]);
/* posixunix.scm: 1006 reverse */
t6=*((C_word*)lf[140]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t4,t5);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4672,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4676,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1009 reverse */
t5=*((C_word*)lf[140]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[2]);}}

/* k4674 in k4678 in k4642 in k4636 in loop in k4627 in k4620 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4676(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1009 isperse */
f_4543(((C_word*)t0)[2],t1);}

/* k4670 in k4678 in k4642 in k4636 in loop in k4627 in k4620 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4672(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1007 sappend */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[141],t1);}

/* k4659 in k4678 in k4642 in k4636 in loop in k4627 in k4620 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4661(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1006 isperse */
f_4543(((C_word*)t0)[2],t1);}

/* k4655 in k4678 in k4642 in k4636 in loop in k4627 in k4620 in canonical-path in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4657(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1004 sappend */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[138],t1);}

/* cwd in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4559(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4559,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4566,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4568,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* call-with-current-continuation */
t4=*((C_word*)lf[135]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}

/* a4567 in cwd in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4568(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4568,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4574,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4592,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* with-exception-handler */
t5=*((C_word*)lf[134]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t3,t4);}

/* a4591 in a4567 in cwd in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4592(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4592,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4598,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4604,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t2,t3);}

/* a4603 in a4591 in a4567 in cwd in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4604(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_4604r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4604r(t0,t1,t2);}}

static void C_ccall f_4604r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4610,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* k789795 */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t1,t3);}

/* a4609 in a4603 in a4591 in a4567 in cwd in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4610(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4610,2,t0,t1);}
C_apply_values(3,0,t1,((C_word*)t0)[2]);}

/* a4597 in a4591 in a4567 in cwd in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4598(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4598,2,t0,t1);}
/* posixunix.scm: 966  cw */
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}

/* a4573 in a4567 in cwd in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4574(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4574,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4580,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* k789795 */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t1,t3);}

/* a4579 in a4573 in a4567 in cwd in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4580(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4580,2,t0,t1);}
t2=(C_word)C_i_structurep(((C_word*)t0)[2],lf[132]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[2],C_fix(1)):C_SCHEME_FALSE);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,lf[133]);}

/* k4564 in cwd in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4566(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* sep? in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_4548(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
t2=(C_word)C_eqp(C_make_character(47),t1);
return((C_truep(t2)?t2:(C_word)C_eqp(C_make_character(92),t1)));}

/* isperse in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4543(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4543,NULL,2,t1,t2);}
/* string-intersperse */
t3=*((C_word*)lf[128]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,t2,lf[129]);}

/* current-directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4502(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2rv,(void*)f_4502r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_4502r(t0,t1,t2);}}

static void C_ccall f_4502r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(3);
t3=(C_word)C_vemptyp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_slot(t2,C_fix(0)));
if(C_truep(t4)){
/* posixunix.scm: 945  change-directory */
t5=*((C_word*)lf[111]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t1,t4);}
else{
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4515,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 946  make-string */
t6=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,C_fix(256));}}

/* k4513 in current-directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4515(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_curdir(t1);
if(C_truep(t2)){
/* posixunix.scm: 949  ##sys#substring */
t3=*((C_word*)lf[63]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[2],t1,C_fix(0),t2);}
else{
/* posixunix.scm: 950  posix-error */
t3=lf[1];
f_3480(5,t3,((C_word*)t0)[2],lf[46],lf[120],lf[123]);}}

/* directory? in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4479(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4479,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[121]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4486,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4500,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 938  ##sys#expand-home-path */
t6=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k4498 in directory? in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4500(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 938  ##sys#file-info */
t2=*((C_word*)lf[122]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4484 in directory? in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4486(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4325(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr2r,(void*)f_4325r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4325r(t0,t1,t2);}}

static void C_ccall f_4325r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(10);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4327,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4425,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4430,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
/* def-spec637694 */
t6=t5;
f_4430(t6,t1);}
else{
t6=(C_word)C_u_i_car(t2);
t7=(C_word)C_slot(t2,C_fix(1));
if(C_truep((C_word)C_i_nullp(t7))){
/* def-show-dotfiles?638690 */
t8=t4;
f_4425(t8,t1,t6);}
else{
t8=(C_word)C_u_i_car(t7);
t9=(C_word)C_slot(t7,C_fix(1));
/* body635644 */
t10=t3;
f_4327(t10,t1,t6,t8);}}}

/* def-spec637 in directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4430(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4430,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4438,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 911  current-directory */
t3=*((C_word*)lf[120]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k4436 in def-spec637 in directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4438(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* def-show-dotfiles?638690 */
t2=((C_word*)t0)[3];
f_4425(t2,((C_word*)t0)[2],t1);}

/* def-show-dotfiles?638 in directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4425(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4425,NULL,3,t0,t1,t2);}
/* body635644 */
t3=((C_word*)t0)[2];
f_4327(t3,t1,t2,C_SCHEME_FALSE);}

/* body635 in directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4327(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4327,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[117]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4334,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 913  make-string */
t6=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,C_fix(256));}

/* k4332 in body635 in directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4334(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4334,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4337,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 914  ##sys#make-pointer */
t3=*((C_word*)lf[119]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k4335 in k4332 in body635 in directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4337(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4337,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4340,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 915  ##sys#make-pointer */
t3=*((C_word*)lf[119]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k4338 in k4335 in k4332 in body635 in directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4340(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4340,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4344,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4424,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 916  ##sys#expand-home-path */
t4=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[5]);}

/* k4422 in k4338 in k4335 in k4332 in body635 in directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4424(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 916  ##sys#make-c-string */
t2=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4342 in k4338 in k4335 in k4332 in body635 in directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4344(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4344,2,t0,t1);}
t2=(C_word)C_opendir(t1,((C_word*)t0)[8]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[8]))){
/* posixunix.scm: 918  posix-error */
t3=lf[1];
f_3480(6,t3,((C_word*)t0)[7],lf[46],lf[117],lf[118],((C_word*)t0)[6]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4358,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_4358(t6,((C_word*)t0)[7]);}}

/* loop in k4342 in k4338 in k4335 in k4332 in body635 in directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4358(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4358,NULL,2,t0,t1);}
t2=(C_word)C_readdir(((C_word*)t0)[7],((C_word*)t0)[6]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[6]))){
t3=(C_word)C_closedir(((C_word*)t0)[7]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_foundfile(((C_word*)t0)[6],((C_word*)t0)[5]);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4368,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t1,a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 926  ##sys#substring */
t5=*((C_word*)lf[63]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[5],C_fix(0),t3);}}

/* k4366 in loop in k4342 in k4338 in k4335 in k4332 in body635 in directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4368(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4368,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4371,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 927  string-ref */
t3=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,t1,C_fix(0));}

/* k4369 in k4366 in loop in k4342 in k4338 in k4335 in k4332 in body635 in directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4371(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4371,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4374,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep((C_word)C_fixnum_greaterp(((C_word*)t0)[4],C_fix(1)))){
/* posixunix.scm: 928  string-ref */
t3=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[5],C_fix(1));}
else{
t3=t2;
f_4374(2,t3,C_SCHEME_FALSE);}}

/* k4372 in k4369 in k4366 in loop in k4342 in k4338 in k4335 in k4332 in body635 in directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4374(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4374,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4380,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_eqp(C_make_character(46),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=(C_word)C_i_not(t1);
if(C_truep(t4)){
t5=t2;
f_4380(t5,t4);}
else{
t5=(C_word)C_eqp(C_make_character(46),t1);
t6=(C_truep(t5)?(C_word)C_eqp(C_fix(2),((C_word*)t0)[3]):C_SCHEME_FALSE);
t7=t2;
f_4380(t7,(C_truep(t6)?t6:(C_word)C_i_not(((C_word*)t0)[2])));}}
else{
t4=t2;
f_4380(t4,C_SCHEME_FALSE);}}

/* k4378 in k4372 in k4369 in k4366 in loop in k4342 in k4338 in k4335 in k4332 in body635 in directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_4380(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4380,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixunix.scm: 933  loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4358(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4390,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 934  loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_4358(t3,t2);}}

/* k4388 in k4378 in k4372 in k4369 in k4366 in loop in k4342 in k4338 in k4335 in k4332 in body635 in directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4390(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4390,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* delete-directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4301(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4301,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[113]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4319,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4323,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 904  ##sys#expand-home-path */
t6=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k4321 in delete-directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4323(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 904  ##sys#make-c-string */
t2=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4317 in delete-directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4319(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 905  posix-error */
t3=lf[1];
f_3480(6,t3,((C_word*)t0)[3],lf[46],lf[113],lf[114],((C_word*)t0)[2]);}}

/* change-directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4277(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4277,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[111]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4295,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4299,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 898  ##sys#expand-home-path */
t6=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k4297 in change-directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4299(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 898  ##sys#make-c-string */
t2=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4293 in change-directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4295(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 899  posix-error */
t3=lf[1];
f_3480(6,t3,((C_word*)t0)[3],lf[46],lf[111],lf[112],((C_word*)t0)[2]);}}

/* create-directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4182(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr3rv,(void*)f_4182r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_4182r(t0,t1,t2,t3);}}

static void C_ccall f_4182r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a=C_alloc(9);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
t6=(C_word)C_i_check_string_2(t2,lf[102]);
if(C_truep(t5)){
t7=t2;
t8=lf[103];
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4197,a[2]=t9,tmp=(C_word)a,a+=3,tmp);
t11=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4249,a[2]=t10,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 886  string-split */
t12=*((C_word*)lf[109]+1);
((C_proc4)(void*)(*((C_word*)t12+1)))(4,t12,t11,t7,lf[110]);}
else{
t7=t2;
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4263,a[2]=t7,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 862  ##sys#make-c-string */
t9=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t7);}}

/* k4261 in create-directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4263(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 863  posix-error */
t3=lf[1];
f_3480(6,t3,((C_word*)t0)[3],lf[46],lf[102],lf[104],((C_word*)t0)[2]);}}

/* k4247 in create-directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4249(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* for-each */
t2=*((C_word*)lf[67]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a4196 in create-directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4197(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4197,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4202,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 884  string-append */
t4=*((C_word*)lf[0]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,((C_word*)((C_word*)t0)[2])[1],lf[108],t2);}

/* k4200 in a4196 in create-directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4202(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4202,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)((C_word*)t0)[3])[1];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4208,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4225,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 867  file-exists? */
t6=*((C_word*)lf[107]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t3);}

/* k4223 in k4200 in a4196 in create-directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4225(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4225,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4245,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 868  ##sys#make-c-string */
t3=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[3];
f_4208(2,t2,C_SCHEME_FALSE);}}

/* k4243 in k4223 in k4200 in a4196 in create-directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4245(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_stat(t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 869  posix-error */
t3=lf[1];
f_3480(6,t3,((C_word*)t0)[3],lf[46],lf[102],lf[105],((C_word*)t0)[2]);}
else{
t3=C_mk_bool(C_isdir);
if(C_truep(t3)){
t4=((C_word*)t0)[3];
f_4208(2,t4,t3);}
else{
/* posixunix.scm: 872  posix-error */
t4=lf[1];
f_3480(6,t4,((C_word*)t0)[3],lf[46],lf[102],lf[106],((C_word*)t0)[2]);}}}

/* k4206 in k4200 in a4196 in create-directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4208(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4208,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4222,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 862  ##sys#make-c-string */
t3=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}}

/* k4220 in k4206 in k4200 in a4196 in create-directory in k4178 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4222(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 863  posix-error */
t3=lf[1];
f_3480(6,t3,((C_word*)t0)[3],lf[46],lf[102],lf[104],((C_word*)t0)[2]);}}

/* set-file-position! in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4120(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_4120r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_4120r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4120r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(C_word)C_i_check_exact_2(t3,lf[94]);
t8=(C_word)C_i_check_exact_2(t6,lf[94]);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4133,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm: 836  ##sys#signal-hook */
t10=*((C_word*)lf[2]+1);
((C_proc7)(void*)(*((C_word*)t10+1)))(7,t10,t9,lf[99],lf[94],lf[100],t3,t2);}
else{
t10=t9;
f_4133(2,t10,C_SCHEME_UNDEFINED);}}

/* k4131 in set-file-position! in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4133(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4133,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4139,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4145,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 837  port? */
t4=*((C_word*)lf[98]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k4143 in k4131 in set-file-position! in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4145(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(7));
t3=(C_word)C_eqp(t2,lf[96]);
t4=((C_word*)t0)[4];
f_4139(2,t4,(C_truep(t3)?(C_word)C_fseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[4];
f_4139(2,t2,(C_word)C_lseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
/* posixunix.scm: 841  ##sys#signal-hook */
t2=*((C_word*)lf[2]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[57],lf[94],lf[97],((C_word*)t0)[5]);}}}

/* k4137 in k4131 in set-file-position! in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4139(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 842  posix-error */
t2=lf[1];
f_3480(7,t2,((C_word*)t0)[4],lf[46],lf[94],lf[95],((C_word*)t0)[3],((C_word*)t0)[2]);}}

/* socket? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4110(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4110,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[92]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4117,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 826  ##sys#stat */
f_3945(t4,t2,C_SCHEME_FALSE,lf[92]);}

/* k4115 in socket? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4117(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_issock));}

/* f_4099 in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4099(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4099,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[90]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4106,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 818  ##sys#stat */
f_3945(t4,t2,C_SCHEME_FALSE,lf[90]);}

/* k4104 */
static void C_ccall f_4106(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isfifo));}

/* block-device? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4089(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4089,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[87]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4096,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 811  ##sys#stat */
f_3945(t4,t2,C_SCHEME_FALSE,lf[87]);}

/* k4094 in block-device? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4096(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isblk));}

/* character-device? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4079(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4079,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[85]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4086,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 804  ##sys#stat */
f_3945(t4,t2,C_SCHEME_FALSE,lf[85]);}

/* k4084 in character-device? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4086(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_ischr));}

/* stat-directory? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4070(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4070,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[84]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4077,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 799  ##sys#stat */
f_3945(t4,t2,C_SCHEME_FALSE,lf[84]);}

/* k4075 in stat-directory? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4077(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isdir));}

/* stat-regular? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4061(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4061,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[83]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4068,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 794  ##sys#stat */
f_3945(t4,t2,C_SCHEME_FALSE,lf[83]);}

/* k4066 in stat-regular? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4068(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isreg));}

/* symbolic-link? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4052(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4052,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[82]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4059,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 789  ##sys#stat */
f_3945(t4,t2,C_SCHEME_TRUE,lf[82]);}

/* k4057 in symbolic-link? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4059(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_islink));}

/* regular-file? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4043(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4043,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[81]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4050,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 784  ##sys#stat */
f_3945(t4,t2,C_SCHEME_TRUE,lf[81]);}

/* k4048 in regular-file? in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4050(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isreg));}

/* file-permissions in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4037(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4037,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4041,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 780  ##sys#stat */
f_3945(t3,t2,C_SCHEME_FALSE,lf[80]);}

/* k4039 in file-permissions in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4041(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-owner in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4031(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4031,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4035,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 779  ##sys#stat */
f_3945(t3,t2,C_SCHEME_FALSE,lf[79]);}

/* k4033 in file-owner in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4035(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-change-time in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4025(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4025,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4029,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 778  ##sys#stat */
f_3945(t3,t2,C_SCHEME_FALSE,lf[78]);}

/* k4027 in file-change-time in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4029(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4029,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-access-time in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4019(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4019,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4023,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 777  ##sys#stat */
f_3945(t3,t2,C_SCHEME_FALSE,lf[77]);}

/* k4021 in file-access-time in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4023(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4023,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-modification-time in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4013(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4013,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4017,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 776  ##sys#stat */
f_3945(t3,t2,C_SCHEME_FALSE,lf[76]);}

/* k4015 in file-modification-time in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4017(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4017,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* file-size in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4007(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4007,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4011,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 775  ##sys#stat */
f_3945(t3,t2,C_SCHEME_FALSE,lf[75]);}

/* k4009 in file-size in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_4011(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4011,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_double_to_num(&a,C_statbuf.st_size));}

/* file-stat in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3982(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3982r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3982r(t0,t1,t2,t3);}}

static void C_ccall f_3982r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3986,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(C_word)C_vemptyp(t3);
t6=(C_truep(t5)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
/* posixunix.scm: 768  ##sys#stat */
f_3945(t4,t2,t6,lf[74]);}

/* k3984 in file-stat in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3986(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[30],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3986,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_a_double_to_num(&a,C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_dev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_rdev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blksize),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blocks)));}

/* ##sys#stat in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_3945(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3945,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3949,a[2]=t2,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f_3949(2,t6,(C_word)C_fstat(t2));}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3970,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3977,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 759  ##sys#expand-home-path */
t8=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
/* posixunix.scm: 763  ##sys#signal-hook */
t6=*((C_word*)lf[2]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[57],lf[73],t2);}}}

/* k3975 in ##sys#stat in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3977(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 759  ##sys#make-c-string */
t2=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3968 in ##sys#stat in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3970(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_3949(2,t2,(C_truep(((C_word*)t0)[2])?(C_word)C_lstat(t1):(C_word)C_stat(t1)));}

/* k3947 in ##sys#stat in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3949(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 765  posix-error */
t2=lf[1];
f_3480(6,t2,((C_word*)t0)[4],lf[46],((C_word*)t0)[3],lf[72],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3753(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+15)){
C_save_and_reclaim((void*)tr4rv,(void*)f_3753r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_3753r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3753r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a=C_alloc(15);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(C_word)C_notvemptyp(t4);
t8=(C_truep(t7)?(C_word)C_slot(t4,C_fix(0)):C_SCHEME_FALSE);
t9=f_3747(C_fix(0));
t10=f_3747(C_fix(1));
t11=(C_word)C_i_not(t2);
t12=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3769,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=t8,a[5]=((C_word*)t0)[3],a[6]=t2,a[7]=t1,a[8]=t3,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t11)){
t13=t12;
f_3769(2,t13,t11);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t13=C_set_block_item(t6,0,t2);
/* posixunix.scm: 688  fd_set */
t14=t12;
f_3769(2,t14,f_3749(C_fix(0),t2));}
else{
t13=(C_word)C_i_check_list_2(t2,lf[65]);
t14=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3926,a[2]=((C_word*)t0)[2],a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* for-each */
t15=*((C_word*)lf[67]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t12,t14,t2);}}}

/* a3925 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3926(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3926,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[65]);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posixunix.scm: 695  fd_set */
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,f_3749(C_fix(0),t2));}

/* k3767 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3769(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3769,2,t0,t1);}
t2=(C_word)C_i_not(((C_word*)t0)[8]);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3775,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t2)){
t4=t3;
f_3775(2,t4,t2);}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[8]))){
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)t0)[8]);
/* posixunix.scm: 700  fd_set */
t5=t3;
f_3775(2,t5,f_3749(C_fix(1),((C_word*)t0)[8]));}
else{
t4=(C_word)C_i_check_list_2(((C_word*)t0)[8],lf[65]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3900,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* for-each */
t6=*((C_word*)lf[67]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,t5,((C_word*)t0)[8]);}}}

/* a3899 in k3767 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3900(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3900,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[65]);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posixunix.scm: 707  fd_set */
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,f_3749(C_fix(1),t2));}

/* k3773 in k3767 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3775(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3775,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3778,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
t3=(C_word)C_i_check_number_2(((C_word*)t0)[3],lf[65]);
t4=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t5=t2;
f_3778(t5,(C_word)C_C_select_t(t4,((C_word*)t0)[3]));}
else{
t3=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f_3778(t4,(C_word)C_C_select(t3));}}

/* k3776 in k3773 in k3767 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_3778(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3778,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 714  posix-error */
t2=lf[1];
f_3480(7,t2,((C_word*)t0)[5],lf[46],lf[65],lf[66],((C_word*)t0)[4],((C_word*)t0)[3]);}
else{
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
t3=(C_word)C_i_pairp(((C_word*)t0)[4]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
t5=(C_word)C_i_pairp(((C_word*)t0)[3]);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
/* posixunix.scm: 715  values */
C_values(4,0,((C_word*)t0)[5],t4,t6);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3817,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[4])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[4]))){
/* posixunix.scm: 720  fd_test */
t4=t3;
f_3817(t4,f_3751(C_fix(0),((C_word*)t0)[4]));}
else{
t4=C_SCHEME_END_OF_LIST;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3858,a[2]=t5,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3860,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* for-each */
t8=*((C_word*)lf[67]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t6,t7,((C_word*)t0)[4]);}}
else{
t4=t3;
f_3817(t4,C_SCHEME_FALSE);}}}}

/* a3859 in k3776 in k3773 in k3767 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3860(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3860,3,t0,t1,t2);}
t3=f_3751(C_fix(0),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k3856 in k3776 in k3773 in k3767 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3858(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_3817(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k3815 in k3776 in k3773 in k3767 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_3817(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3817,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3821,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
/* posixunix.scm: 726  fd_test */
t3=t2;
f_3821(t3,f_3751(C_fix(1),((C_word*)t0)[3]));}
else{
t3=C_SCHEME_END_OF_LIST;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3833,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3835,a[2]=t4,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* for-each */
t7=*((C_word*)lf[67]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,((C_word*)t0)[3]);}}
else{
t3=t2;
f_3821(t3,C_SCHEME_FALSE);}}

/* a3834 in k3815 in k3776 in k3773 in k3767 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3835(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3835,3,t0,t1,t2);}
t3=f_3751(C_fix(1),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k3831 in k3815 in k3776 in k3773 in k3767 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3833(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_3821(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k3819 in k3815 in k3776 in k3773 in k3767 in file-select in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_fcall f_3821(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 717  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* fd_test in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_3751(C_word t1,C_word t2){
C_word tmp;
C_word t3;
return((C_word)stub252(C_SCHEME_UNDEFINED,t1,t2));}

/* fd_set in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_3749(C_word t1,C_word t2){
C_word tmp;
C_word t3;
return((C_word)stub245(C_SCHEME_UNDEFINED,t1,t2));}

/* fd_zero in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static C_word C_fcall f_3747(C_word t1){
C_word tmp;
C_word t2;
return((C_word)stub239(C_SCHEME_UNDEFINED,t1));}

/* file-mkstemp in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3715(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3715,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[62]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3722,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 666  ##sys#make-c-string */
t5=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k3720 in file-mkstemp in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3722(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3722,2,t0,t1);}
t2=(C_word)C_mkstemp(t1);
t3=(C_word)C_block_size(t1);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3728,a[2]=t1,a[3]=t3,a[4]=t2,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t5)){
/* posixunix.scm: 670  posix-error */
t6=lf[1];
f_3480(6,t6,t4,lf[46],lf[62],lf[64],((C_word*)t0)[2]);}
else{
t6=t4;
f_3728(2,t6,C_SCHEME_UNDEFINED);}}

/* k3726 in k3720 in file-mkstemp in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3728(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3728,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3735,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_u_fixnum_difference(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 671  ##sys#substring */
t4=*((C_word*)lf[63]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k3733 in k3726 in k3720 in file-mkstemp in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3735(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 671  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3676(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_3676r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_3676r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3676r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_i_check_exact_2(t2,lf[59]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3683,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t7=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t7)){
t8=t6;
f_3683(2,t8,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 655  ##sys#signal-hook */
t8=*((C_word*)lf[2]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t6,lf[57],lf[59],lf[61],t3);}}

/* k3681 in file-write in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3683(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3683,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_i_check_exact_2(t3,lf[59]);
t5=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3692,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_word)C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
/* posixunix.scm: 660  posix-error */
t8=lf[1];
f_3480(7,t8,t6,lf[46],lf[59],lf[60],((C_word*)t0)[3],t3);}
else{
t8=t6;
f_3692(2,t8,C_SCHEME_UNDEFINED);}}

/* k3690 in k3681 in file-write in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3692(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3634(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_3634r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_3634r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3634r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t5=(C_word)C_i_check_exact_2(t2,lf[55]);
t6=(C_word)C_i_check_exact_2(t3,lf[55]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3644,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t8=t7;
f_3644(2,t8,(C_word)C_slot(t4,C_fix(0)));}
else{
/* posixunix.scm: 643  make-string */
t8=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t3);}}

/* k3642 in file-read in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3644(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3644,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3647,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=t2;
f_3647(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 645  ##sys#signal-hook */
t4=*((C_word*)lf[2]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[57],lf[55],lf[58],t1);}}

/* k3645 in k3642 in file-read in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3647(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3647,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3650,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 648  posix-error */
t5=lf[1];
f_3480(7,t5,t3,lf[46],lf[55],lf[56],((C_word*)t0)[5],((C_word*)t0)[3]);}
else{
t5=t3;
f_3650(2,t5,C_SCHEME_UNDEFINED);}}

/* k3648 in k3645 in k3642 in file-read in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3650(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3650,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3619(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3619,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[52]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
/* posixunix.scm: 636  posix-error */
t4=lf[1];
f_3480(6,t4,t1,lf[46],lf[52],lf[53],t2);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* file-open in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3581(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4rv,(void*)f_3581r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_3581r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3581r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(C_word)C_i_check_string_2(t2,lf[48]);
t8=(C_word)C_i_check_exact_2(t3,lf[48]);
t9=(C_word)C_i_check_exact_2(t6,lf[48]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3598,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3611,a[2]=t10,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 627  ##sys#expand-home-path */
t12=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,t2);}

/* k3609 in file-open in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3611(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 627  ##sys#make-c-string */
t2=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3596 in file-open in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3598(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3598,2,t0,t1);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3601,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 629  posix-error */
t5=lf[1];
f_3480(8,t5,t3,lf[46],lf[48],lf[49],((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]);}
else{
t5=t3;
f_3601(2,t5,C_SCHEME_UNDEFINED);}}

/* k3599 in k3596 in file-open in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3601(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-control in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3542(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr4rv,(void*)f_3542r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_3542r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3542r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
t5=(C_word)C_vemptyp(t4);
t6=(C_truep(t5)?C_fix(0):(C_word)C_slot(t4,C_fix(0)));
t7=(C_word)C_i_check_exact_2(t2,lf[45]);
t8=(C_word)C_i_check_exact_2(t3,lf[45]);
t9=t2;
t10=t3;
t11=(C_word)stub124(C_SCHEME_UNDEFINED,t9,t10,t6);
t12=(C_word)C_eqp(t11,C_fix(-1));
if(C_truep(t12)){
/* posixunix.scm: 617  posix-error */
t13=lf[1];
f_3480(7,t13,t1,lf[46],lf[45],lf[47],t2,t3);}
else{
t13=t1;
((C_proc2)(void*)(*((C_word*)t13+1)))(2,t13,t11);}}

/* ##sys#file-select-one in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3501(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3501,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub46(C_SCHEME_UNDEFINED,t2));}

/* ##sys#file-nonblocking! in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3498(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3498,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub40(C_SCHEME_UNDEFINED,t2));}

/* posix-error in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3480(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr5r,(void*)f_3480r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_3480r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_3480r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a=C_alloc(8);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3484,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=t3,a[6]=t2,a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 507  ##sys#update-errno */
t7=*((C_word*)lf[5]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k3482 in posix-error in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3484(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3484,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3491,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3495,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,(C_word)stub23(t4,t1),C_fix(0));}

/* k3493 in k3482 in posix-error in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3495(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 508  string-append */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[3],t1);}

/* k3489 in k3482 in posix-error in k3471 in k3468 in k3465 in k3462 in k3459 in k3456 in k3453 */
static void C_ccall f_3491(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[5],*((C_word*)lf[2]+1),((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[608] = {
{"toplevel:posixunix_scm",(void*)C_posix_toplevel},
{"f_3455:posixunix_scm",(void*)f_3455},
{"f_3458:posixunix_scm",(void*)f_3458},
{"f_3461:posixunix_scm",(void*)f_3461},
{"f_3464:posixunix_scm",(void*)f_3464},
{"f_3467:posixunix_scm",(void*)f_3467},
{"f_3470:posixunix_scm",(void*)f_3470},
{"f_3473:posixunix_scm",(void*)f_3473},
{"f_9124:posixunix_scm",(void*)f_9124},
{"f_9140:posixunix_scm",(void*)f_9140},
{"f_9128:posixunix_scm",(void*)f_9128},
{"f_9131:posixunix_scm",(void*)f_9131},
{"f_4180:posixunix_scm",(void*)f_4180},
{"f_5186:posixunix_scm",(void*)f_5186},
{"f_9118:posixunix_scm",(void*)f_9118},
{"f_5321:posixunix_scm",(void*)f_5321},
{"f_9103:posixunix_scm",(void*)f_9103},
{"f_9113:posixunix_scm",(void*)f_9113},
{"f_9100:posixunix_scm",(void*)f_9100},
{"f_5363:posixunix_scm",(void*)f_5363},
{"f_9085:posixunix_scm",(void*)f_9085},
{"f_9095:posixunix_scm",(void*)f_9095},
{"f_9082:posixunix_scm",(void*)f_9082},
{"f_5367:posixunix_scm",(void*)f_5367},
{"f_9067:posixunix_scm",(void*)f_9067},
{"f_9077:posixunix_scm",(void*)f_9077},
{"f_9064:posixunix_scm",(void*)f_9064},
{"f_5371:posixunix_scm",(void*)f_5371},
{"f_9049:posixunix_scm",(void*)f_9049},
{"f_9059:posixunix_scm",(void*)f_9059},
{"f_9046:posixunix_scm",(void*)f_9046},
{"f_5375:posixunix_scm",(void*)f_5375},
{"f_9025:posixunix_scm",(void*)f_9025},
{"f_9041:posixunix_scm",(void*)f_9041},
{"f_9007:posixunix_scm",(void*)f_9007},
{"f_9020:posixunix_scm",(void*)f_9020},
{"f_9014:posixunix_scm",(void*)f_9014},
{"f_5858:posixunix_scm",(void*)f_5858},
{"f_5897:posixunix_scm",(void*)f_5897},
{"f_8984:posixunix_scm",(void*)f_8984},
{"f_8980:posixunix_scm",(void*)f_8980},
{"f_8732:posixunix_scm",(void*)f_8732},
{"f_8909:posixunix_scm",(void*)f_8909},
{"f_8915:posixunix_scm",(void*)f_8915},
{"f_8904:posixunix_scm",(void*)f_8904},
{"f_8899:posixunix_scm",(void*)f_8899},
{"f_8734:posixunix_scm",(void*)f_8734},
{"f_8886:posixunix_scm",(void*)f_8886},
{"f_8894:posixunix_scm",(void*)f_8894},
{"f_8741:posixunix_scm",(void*)f_8741},
{"f_8874:posixunix_scm",(void*)f_8874},
{"f_8868:posixunix_scm",(void*)f_8868},
{"f_8751:posixunix_scm",(void*)f_8751},
{"f_8753:posixunix_scm",(void*)f_8753},
{"f_8772:posixunix_scm",(void*)f_8772},
{"f_8854:posixunix_scm",(void*)f_8854},
{"f_8861:posixunix_scm",(void*)f_8861},
{"f_8848:posixunix_scm",(void*)f_8848},
{"f_8787:posixunix_scm",(void*)f_8787},
{"f_8841:posixunix_scm",(void*)f_8841},
{"f_8838:posixunix_scm",(void*)f_8838},
{"f_8828:posixunix_scm",(void*)f_8828},
{"f_8804:posixunix_scm",(void*)f_8804},
{"f_8826:posixunix_scm",(void*)f_8826},
{"f_8812:posixunix_scm",(void*)f_8812},
{"f_8819:posixunix_scm",(void*)f_8819},
{"f_8816:posixunix_scm",(void*)f_8816},
{"f_8799:posixunix_scm",(void*)f_8799},
{"f_8797:posixunix_scm",(void*)f_8797},
{"f_8875:posixunix_scm",(void*)f_8875},
{"f_8675:posixunix_scm",(void*)f_8675},
{"f_8687:posixunix_scm",(void*)f_8687},
{"f_8682:posixunix_scm",(void*)f_8682},
{"f_8677:posixunix_scm",(void*)f_8677},
{"f_8618:posixunix_scm",(void*)f_8618},
{"f_8630:posixunix_scm",(void*)f_8630},
{"f_8625:posixunix_scm",(void*)f_8625},
{"f_8620:posixunix_scm",(void*)f_8620},
{"f_8557:posixunix_scm",(void*)f_8557},
{"f_8612:posixunix_scm",(void*)f_8612},
{"f_8616:posixunix_scm",(void*)f_8616},
{"f_8578:posixunix_scm",(void*)f_8578},
{"f_8581:posixunix_scm",(void*)f_8581},
{"f_8592:posixunix_scm",(void*)f_8592},
{"f_8586:posixunix_scm",(void*)f_8586},
{"f_8559:posixunix_scm",(void*)f_8559},
{"f_8568:posixunix_scm",(void*)f_8568},
{"f_8499:posixunix_scm",(void*)f_8499},
{"f_8511:posixunix_scm",(void*)f_8511},
{"f_8542:posixunix_scm",(void*)f_8542},
{"f_8522:posixunix_scm",(void*)f_8522},
{"f_8538:posixunix_scm",(void*)f_8538},
{"f_8526:posixunix_scm",(void*)f_8526},
{"f_8534:posixunix_scm",(void*)f_8534},
{"f_8530:posixunix_scm",(void*)f_8530},
{"f_8505:posixunix_scm",(void*)f_8505},
{"f_8488:posixunix_scm",(void*)f_8488},
{"f_8492:posixunix_scm",(void*)f_8492},
{"f_8477:posixunix_scm",(void*)f_8477},
{"f_8481:posixunix_scm",(void*)f_8481},
{"f_8432:posixunix_scm",(void*)f_8432},
{"f_8436:posixunix_scm",(void*)f_8436},
{"f_8439:posixunix_scm",(void*)f_8439},
{"f_8442:posixunix_scm",(void*)f_8442},
{"f_8455:posixunix_scm",(void*)f_8455},
{"f_8459:posixunix_scm",(void*)f_8459},
{"f_8462:posixunix_scm",(void*)f_8462},
{"f_8465:posixunix_scm",(void*)f_8465},
{"f_8453:posixunix_scm",(void*)f_8453},
{"f_8416:posixunix_scm",(void*)f_8416},
{"f_8399:posixunix_scm",(void*)f_8399},
{"f_8412:posixunix_scm",(void*)f_8412},
{"f_8324:posixunix_scm",(void*)f_8324},
{"f_8385:posixunix_scm",(void*)f_8385},
{"f_8398:posixunix_scm",(void*)f_8398},
{"f_8365:posixunix_scm",(void*)f_8365},
{"f_8380:posixunix_scm",(void*)f_8380},
{"f_8374:posixunix_scm",(void*)f_8374},
{"f_8328:posixunix_scm",(void*)f_8328},
{"f_8330:posixunix_scm",(void*)f_8330},
{"f_8351:posixunix_scm",(void*)f_8351},
{"f_8345:posixunix_scm",(void*)f_8345},
{"f_8272:posixunix_scm",(void*)f_8272},
{"f_8279:posixunix_scm",(void*)f_8279},
{"f_8298:posixunix_scm",(void*)f_8298},
{"f_8302:posixunix_scm",(void*)f_8302},
{"f_8266:posixunix_scm",(void*)f_8266},
{"f_8257:posixunix_scm",(void*)f_8257},
{"f_8261:posixunix_scm",(void*)f_8261},
{"f_8230:posixunix_scm",(void*)f_8230},
{"f_8227:posixunix_scm",(void*)f_8227},
{"f_8224:posixunix_scm",(void*)f_8224},
{"f_8221:posixunix_scm",(void*)f_8221},
{"f_8146:posixunix_scm",(void*)f_8146},
{"f_8179:posixunix_scm",(void*)f_8179},
{"f_8173:posixunix_scm",(void*)f_8173},
{"f_8129:posixunix_scm",(void*)f_8129},
{"f_7950:posixunix_scm",(void*)f_7950},
{"f_8084:posixunix_scm",(void*)f_8084},
{"f_8079:posixunix_scm",(void*)f_8079},
{"f_7952:posixunix_scm",(void*)f_7952},
{"f_7962:posixunix_scm",(void*)f_7962},
{"f_7970:posixunix_scm",(void*)f_7970},
{"f_8016:posixunix_scm",(void*)f_8016},
{"f_7983:posixunix_scm",(void*)f_7983},
{"f_8008:posixunix_scm",(void*)f_8008},
{"f_7986:posixunix_scm",(void*)f_7986},
{"f_7942:posixunix_scm",(void*)f_7942},
{"f_7934:posixunix_scm",(void*)f_7934},
{"f_7896:posixunix_scm",(void*)f_7896},
{"f_7918:posixunix_scm",(void*)f_7918},
{"f_7922:posixunix_scm",(void*)f_7922},
{"f_7787:posixunix_scm",(void*)f_7787},
{"f_7793:posixunix_scm",(void*)f_7793},
{"f_7814:posixunix_scm",(void*)f_7814},
{"f_7888:posixunix_scm",(void*)f_7888},
{"f_7818:posixunix_scm",(void*)f_7818},
{"f_7821:posixunix_scm",(void*)f_7821},
{"f_7828:posixunix_scm",(void*)f_7828},
{"f_7830:posixunix_scm",(void*)f_7830},
{"f_7847:posixunix_scm",(void*)f_7847},
{"f_7857:posixunix_scm",(void*)f_7857},
{"f_7861:posixunix_scm",(void*)f_7861},
{"f_7808:posixunix_scm",(void*)f_7808},
{"f_7775:posixunix_scm",(void*)f_7775},
{"f_7779:posixunix_scm",(void*)f_7779},
{"f_7782:posixunix_scm",(void*)f_7782},
{"f_7740:posixunix_scm",(void*)f_7740},
{"f_7744:posixunix_scm",(void*)f_7744},
{"f_7764:posixunix_scm",(void*)f_7764},
{"f_7768:posixunix_scm",(void*)f_7768},
{"f_7721:posixunix_scm",(void*)f_7721},
{"f_7725:posixunix_scm",(void*)f_7725},
{"f_7694:posixunix_scm",(void*)f_7694},
{"f_7698:posixunix_scm",(void*)f_7698},
{"f_7675:posixunix_scm",(void*)f_7675},
{"f_7679:posixunix_scm",(void*)f_7679},
{"f_7682:posixunix_scm",(void*)f_7682},
{"f_7616:posixunix_scm",(void*)f_7616},
{"f_7620:posixunix_scm",(void*)f_7620},
{"f_7626:posixunix_scm",(void*)f_7626},
{"f_7613:posixunix_scm",(void*)f_7613},
{"f_7597:posixunix_scm",(void*)f_7597},
{"f_7589:posixunix_scm",(void*)f_7589},
{"f_7574:posixunix_scm",(void*)f_7574},
{"f_7578:posixunix_scm",(void*)f_7578},
{"f_7559:posixunix_scm",(void*)f_7559},
{"f_7563:posixunix_scm",(void*)f_7563},
{"f_7520:posixunix_scm",(void*)f_7520},
{"f_7537:posixunix_scm",(void*)f_7537},
{"f_7541:posixunix_scm",(void*)f_7541},
{"f_7458:posixunix_scm",(void*)f_7458},
{"f_7465:posixunix_scm",(void*)f_7465},
{"f_7487:posixunix_scm",(void*)f_7487},
{"f_7484:posixunix_scm",(void*)f_7484},
{"f_7474:posixunix_scm",(void*)f_7474},
{"f_7422:posixunix_scm",(void*)f_7422},
{"f_7429:posixunix_scm",(void*)f_7429},
{"f_7408:posixunix_scm",(void*)f_7408},
{"f_7399:posixunix_scm",(void*)f_7399},
{"f_7380:posixunix_scm",(void*)f_7380},
{"f_7374:posixunix_scm",(void*)f_7374},
{"f_7365:posixunix_scm",(void*)f_7365},
{"f_7330:posixunix_scm",(void*)f_7330},
{"f_7272:posixunix_scm",(void*)f_7272},
{"f_7276:posixunix_scm",(void*)f_7276},
{"f_7282:posixunix_scm",(void*)f_7282},
{"f_7301:posixunix_scm",(void*)f_7301},
{"f_7288:posixunix_scm",(void*)f_7288},
{"f_7188:posixunix_scm",(void*)f_7188},
{"f_7194:posixunix_scm",(void*)f_7194},
{"f_7198:posixunix_scm",(void*)f_7198},
{"f_7206:posixunix_scm",(void*)f_7206},
{"f_7232:posixunix_scm",(void*)f_7232},
{"f_7236:posixunix_scm",(void*)f_7236},
{"f_7224:posixunix_scm",(void*)f_7224},
{"f_7173:posixunix_scm",(void*)f_7173},
{"f_7181:posixunix_scm",(void*)f_7181},
{"f_7156:posixunix_scm",(void*)f_7156},
{"f_7167:posixunix_scm",(void*)f_7167},
{"f_7171:posixunix_scm",(void*)f_7171},
{"f_7130:posixunix_scm",(void*)f_7130},
{"f_7154:posixunix_scm",(void*)f_7154},
{"f_7137:posixunix_scm",(void*)f_7137},
{"f_7087:posixunix_scm",(void*)f_7087},
{"f_7094:posixunix_scm",(void*)f_7094},
{"f_7115:posixunix_scm",(void*)f_7115},
{"f_7111:posixunix_scm",(void*)f_7111},
{"f_7059:posixunix_scm",(void*)f_7059},
{"f_7037:posixunix_scm",(void*)f_7037},
{"f_7041:posixunix_scm",(void*)f_7041},
{"f_7022:posixunix_scm",(void*)f_7022},
{"f_7026:posixunix_scm",(void*)f_7026},
{"f_7007:posixunix_scm",(void*)f_7007},
{"f_7011:posixunix_scm",(void*)f_7011},
{"f_6989:posixunix_scm",(void*)f_6989},
{"f_6918:posixunix_scm",(void*)f_6918},
{"f_6937:posixunix_scm",(void*)f_6937},
{"f_6943:posixunix_scm",(void*)f_6943},
{"f_6879:posixunix_scm",(void*)f_6879},
{"f_6907:posixunix_scm",(void*)f_6907},
{"f_6903:posixunix_scm",(void*)f_6903},
{"f_6896:posixunix_scm",(void*)f_6896},
{"f_6623:posixunix_scm",(void*)f_6623},
{"f_6819:posixunix_scm",(void*)f_6819},
{"f_6814:posixunix_scm",(void*)f_6814},
{"f_6809:posixunix_scm",(void*)f_6809},
{"f_6625:posixunix_scm",(void*)f_6625},
{"f_6629:posixunix_scm",(void*)f_6629},
{"f_6735:posixunix_scm",(void*)f_6735},
{"f_6736:posixunix_scm",(void*)f_6736},
{"f_6753:posixunix_scm",(void*)f_6753},
{"f_6763:posixunix_scm",(void*)f_6763},
{"f_6721:posixunix_scm",(void*)f_6721},
{"f_6677:posixunix_scm",(void*)f_6677},
{"f_6713:posixunix_scm",(void*)f_6713},
{"f_6692:posixunix_scm",(void*)f_6692},
{"f_6702:posixunix_scm",(void*)f_6702},
{"f_6686:posixunix_scm",(void*)f_6686},
{"f_6681:posixunix_scm",(void*)f_6681},
{"f_6684:posixunix_scm",(void*)f_6684},
{"f_6631:posixunix_scm",(void*)f_6631},
{"f_6666:posixunix_scm",(void*)f_6666},
{"f_6647:posixunix_scm",(void*)f_6647},
{"f_6144:posixunix_scm",(void*)f_6144},
{"f_6548:posixunix_scm",(void*)f_6548},
{"f_6543:posixunix_scm",(void*)f_6543},
{"f_6538:posixunix_scm",(void*)f_6538},
{"f_6533:posixunix_scm",(void*)f_6533},
{"f_6146:posixunix_scm",(void*)f_6146},
{"f_6150:posixunix_scm",(void*)f_6150},
{"f_6156:posixunix_scm",(void*)f_6156},
{"f_6406:posixunix_scm",(void*)f_6406},
{"f_6412:posixunix_scm",(void*)f_6412},
{"f_6508:posixunix_scm",(void*)f_6508},
{"f_6498:posixunix_scm",(void*)f_6498},
{"f_6492:posixunix_scm",(void*)f_6492},
{"f_6414:posixunix_scm",(void*)f_6414},
{"f_6464:posixunix_scm",(void*)f_6464},
{"f_6421:posixunix_scm",(void*)f_6421},
{"f_6431:posixunix_scm",(void*)f_6431},
{"f_6330:posixunix_scm",(void*)f_6330},
{"f_6338:posixunix_scm",(void*)f_6338},
{"f_6340:posixunix_scm",(void*)f_6340},
{"f_6388:posixunix_scm",(void*)f_6388},
{"f_6321:posixunix_scm",(void*)f_6321},
{"f_6325:posixunix_scm",(void*)f_6325},
{"f_6300:posixunix_scm",(void*)f_6300},
{"f_6310:posixunix_scm",(void*)f_6310},
{"f_6288:posixunix_scm",(void*)f_6288},
{"f_6275:posixunix_scm",(void*)f_6275},
{"f_6279:posixunix_scm",(void*)f_6279},
{"f_6270:posixunix_scm",(void*)f_6270},
{"f_6273:posixunix_scm",(void*)f_6273},
{"f_6188:posixunix_scm",(void*)f_6188},
{"f_6200:posixunix_scm",(void*)f_6200},
{"f_6237:posixunix_scm",(void*)f_6237},
{"f_6246:posixunix_scm",(void*)f_6246},
{"f_6240:posixunix_scm",(void*)f_6240},
{"f_6216:posixunix_scm",(void*)f_6216},
{"f_6219:posixunix_scm",(void*)f_6219},
{"f_6180:posixunix_scm",(void*)f_6180},
{"f_6157:posixunix_scm",(void*)f_6157},
{"f_6161:posixunix_scm",(void*)f_6161},
{"f_6117:posixunix_scm",(void*)f_6117},
{"f_6124:posixunix_scm",(void*)f_6124},
{"f_6127:posixunix_scm",(void*)f_6127},
{"f_6072:posixunix_scm",(void*)f_6072},
{"f_6076:posixunix_scm",(void*)f_6076},
{"f_6111:posixunix_scm",(void*)f_6111},
{"f_6094:posixunix_scm",(void*)f_6094},
{"f_6058:posixunix_scm",(void*)f_6058},
{"f_6070:posixunix_scm",(void*)f_6070},
{"f_6044:posixunix_scm",(void*)f_6044},
{"f_6056:posixunix_scm",(void*)f_6056},
{"f_6029:posixunix_scm",(void*)f_6029},
{"f_6042:posixunix_scm",(void*)f_6042},
{"f_5992:posixunix_scm",(void*)f_5992},
{"f_6000:posixunix_scm",(void*)f_6000},
{"f_5967:posixunix_scm",(void*)f_5967},
{"f_5956:posixunix_scm",(void*)f_5956},
{"f_5960:posixunix_scm",(void*)f_5960},
{"f_5898:posixunix_scm",(void*)f_5898},
{"f_5937:posixunix_scm",(void*)f_5937},
{"f_5909:posixunix_scm",(void*)f_5909},
{"f_5912:posixunix_scm",(void*)f_5912},
{"f_5915:posixunix_scm",(void*)f_5915},
{"f_5921:posixunix_scm",(void*)f_5921},
{"f_5860:posixunix_scm",(void*)f_5860},
{"f_5893:posixunix_scm",(void*)f_5893},
{"f_5881:posixunix_scm",(void*)f_5881},
{"f_5889:posixunix_scm",(void*)f_5889},
{"f_5885:posixunix_scm",(void*)f_5885},
{"f_5841:posixunix_scm",(void*)f_5841},
{"f_5851:posixunix_scm",(void*)f_5851},
{"f_5845:posixunix_scm",(void*)f_5845},
{"f_5835:posixunix_scm",(void*)f_5835},
{"f_5829:posixunix_scm",(void*)f_5829},
{"f_5823:posixunix_scm",(void*)f_5823},
{"f_5799:posixunix_scm",(void*)f_5799},
{"f_5821:posixunix_scm",(void*)f_5821},
{"f_5817:posixunix_scm",(void*)f_5817},
{"f_5809:posixunix_scm",(void*)f_5809},
{"f_5769:posixunix_scm",(void*)f_5769},
{"f_5797:posixunix_scm",(void*)f_5797},
{"f_5793:posixunix_scm",(void*)f_5793},
{"f_5742:posixunix_scm",(void*)f_5742},
{"f_5767:posixunix_scm",(void*)f_5767},
{"f_5763:posixunix_scm",(void*)f_5763},
{"f_5678:posixunix_scm",(void*)f_5678},
{"f_5674:posixunix_scm",(void*)f_5674},
{"f_5694:posixunix_scm",(void*)f_5694},
{"f_5612:posixunix_scm",(void*)f_5612},
{"f_5616:posixunix_scm",(void*)f_5616},
{"f_5621:posixunix_scm",(void*)f_5621},
{"f_5637:posixunix_scm",(void*)f_5637},
{"f_5549:posixunix_scm",(void*)f_5549},
{"f_5607:posixunix_scm",(void*)f_5607},
{"f_5553:posixunix_scm",(void*)f_5553},
{"f_5556:posixunix_scm",(void*)f_5556},
{"f_5588:posixunix_scm",(void*)f_5588},
{"f_5559:posixunix_scm",(void*)f_5559},
{"f_5564:posixunix_scm",(void*)f_5564},
{"f_5578:posixunix_scm",(void*)f_5578},
{"f_5546:posixunix_scm",(void*)f_5546},
{"f_5471:posixunix_scm",(void*)f_5471},
{"f_5529:posixunix_scm",(void*)f_5529},
{"f_5478:posixunix_scm",(void*)f_5478},
{"f_5488:posixunix_scm",(void*)f_5488},
{"f_5492:posixunix_scm",(void*)f_5492},
{"f_5501:posixunix_scm",(void*)f_5501},
{"f_5505:posixunix_scm",(void*)f_5505},
{"f_5515:posixunix_scm",(void*)f_5515},
{"f_5496:posixunix_scm",(void*)f_5496},
{"f_5451:posixunix_scm",(void*)f_5451},
{"f_5463:posixunix_scm",(void*)f_5463},
{"f_5459:posixunix_scm",(void*)f_5459},
{"f_5437:posixunix_scm",(void*)f_5437},
{"f_5449:posixunix_scm",(void*)f_5449},
{"f_5445:posixunix_scm",(void*)f_5445},
{"f_5377:posixunix_scm",(void*)f_5377},
{"f_5423:posixunix_scm",(void*)f_5423},
{"f_5384:posixunix_scm",(void*)f_5384},
{"f_5394:posixunix_scm",(void*)f_5394},
{"f_5398:posixunix_scm",(void*)f_5398},
{"f_5402:posixunix_scm",(void*)f_5402},
{"f_5406:posixunix_scm",(void*)f_5406},
{"f_5410:posixunix_scm",(void*)f_5410},
{"f_5323:posixunix_scm",(void*)f_5323},
{"f_5356:posixunix_scm",(void*)f_5356},
{"f_5327:posixunix_scm",(void*)f_5327},
{"f_5334:posixunix_scm",(void*)f_5334},
{"f_5338:posixunix_scm",(void*)f_5338},
{"f_5342:posixunix_scm",(void*)f_5342},
{"f_5346:posixunix_scm",(void*)f_5346},
{"f_5350:posixunix_scm",(void*)f_5350},
{"f_5305:posixunix_scm",(void*)f_5305},
{"f_5290:posixunix_scm",(void*)f_5290},
{"f_5284:posixunix_scm",(void*)f_5284},
{"f_5252:posixunix_scm",(void*)f_5252},
{"f_5258:posixunix_scm",(void*)f_5258},
{"f_5228:posixunix_scm",(void*)f_5228},
{"f_5246:posixunix_scm",(void*)f_5246},
{"f_5235:posixunix_scm",(void*)f_5235},
{"f_5210:posixunix_scm",(void*)f_5210},
{"f_5220:posixunix_scm",(void*)f_5220},
{"f_5197:posixunix_scm",(void*)f_5197},
{"f_5188:posixunix_scm",(void*)f_5188},
{"f_5141:posixunix_scm",(void*)f_5141},
{"f_5145:posixunix_scm",(void*)f_5145},
{"f_5121:posixunix_scm",(void*)f_5121},
{"f_5125:posixunix_scm",(void*)f_5125},
{"f_5131:posixunix_scm",(void*)f_5131},
{"f_5135:posixunix_scm",(void*)f_5135},
{"f_5101:posixunix_scm",(void*)f_5101},
{"f_5105:posixunix_scm",(void*)f_5105},
{"f_5111:posixunix_scm",(void*)f_5111},
{"f_5115:posixunix_scm",(void*)f_5115},
{"f_5077:posixunix_scm",(void*)f_5077},
{"f_5081:posixunix_scm",(void*)f_5081},
{"f_5092:posixunix_scm",(void*)f_5092},
{"f_5096:posixunix_scm",(void*)f_5096},
{"f_5086:posixunix_scm",(void*)f_5086},
{"f_5053:posixunix_scm",(void*)f_5053},
{"f_5057:posixunix_scm",(void*)f_5057},
{"f_5068:posixunix_scm",(void*)f_5068},
{"f_5072:posixunix_scm",(void*)f_5072},
{"f_5062:posixunix_scm",(void*)f_5062},
{"f_5037:posixunix_scm",(void*)f_5037},
{"f_5041:posixunix_scm",(void*)f_5041},
{"f_5044:posixunix_scm",(void*)f_5044},
{"f_5001:posixunix_scm",(void*)f_5001},
{"f_5032:posixunix_scm",(void*)f_5032},
{"f_5022:posixunix_scm",(void*)f_5022},
{"f_5015:posixunix_scm",(void*)f_5015},
{"f_4965:posixunix_scm",(void*)f_4965},
{"f_4996:posixunix_scm",(void*)f_4996},
{"f_4986:posixunix_scm",(void*)f_4986},
{"f_4979:posixunix_scm",(void*)f_4979},
{"f_4950:posixunix_scm",(void*)f_4950},
{"f_4963:posixunix_scm",(void*)f_4963},
{"f_4944:posixunix_scm",(void*)f_4944},
{"f_4932:posixunix_scm",(void*)f_4932},
{"f_4615:posixunix_scm",(void*)f_4615},
{"f_4922:posixunix_scm",(void*)f_4922},
{"f_4742:posixunix_scm",(void*)f_4742},
{"f_4908:posixunix_scm",(void*)f_4908},
{"f_4897:posixunix_scm",(void*)f_4897},
{"f_4904:posixunix_scm",(void*)f_4904},
{"f_4761:posixunix_scm",(void*)f_4761},
{"f_4890:posixunix_scm",(void*)f_4890},
{"f_4869:posixunix_scm",(void*)f_4869},
{"f_4886:posixunix_scm",(void*)f_4886},
{"f_4875:posixunix_scm",(void*)f_4875},
{"f_4882:posixunix_scm",(void*)f_4882},
{"f_4805:posixunix_scm",(void*)f_4805},
{"f_4866:posixunix_scm",(void*)f_4866},
{"f_4845:posixunix_scm",(void*)f_4845},
{"f_4862:posixunix_scm",(void*)f_4862},
{"f_4851:posixunix_scm",(void*)f_4851},
{"f_4858:posixunix_scm",(void*)f_4858},
{"f_4818:posixunix_scm",(void*)f_4818},
{"f_4842:posixunix_scm",(void*)f_4842},
{"f_4838:posixunix_scm",(void*)f_4838},
{"f_4799:posixunix_scm",(void*)f_4799},
{"f_4768:posixunix_scm",(void*)f_4768},
{"f_4786:posixunix_scm",(void*)f_4786},
{"f_4771:posixunix_scm",(void*)f_4771},
{"f_4775:posixunix_scm",(void*)f_4775},
{"f_4755:posixunix_scm",(void*)f_4755},
{"f_4736:posixunix_scm",(void*)f_4736},
{"f_4622:posixunix_scm",(void*)f_4622},
{"f_4629:posixunix_scm",(void*)f_4629},
{"f_4631:posixunix_scm",(void*)f_4631},
{"f_4638:posixunix_scm",(void*)f_4638},
{"f_4702:posixunix_scm",(void*)f_4702},
{"f_4711:posixunix_scm",(void*)f_4711},
{"f_4699:posixunix_scm",(void*)f_4699},
{"f_4644:posixunix_scm",(void*)f_4644},
{"f_4680:posixunix_scm",(void*)f_4680},
{"f_4676:posixunix_scm",(void*)f_4676},
{"f_4672:posixunix_scm",(void*)f_4672},
{"f_4661:posixunix_scm",(void*)f_4661},
{"f_4657:posixunix_scm",(void*)f_4657},
{"f_4559:posixunix_scm",(void*)f_4559},
{"f_4568:posixunix_scm",(void*)f_4568},
{"f_4592:posixunix_scm",(void*)f_4592},
{"f_4604:posixunix_scm",(void*)f_4604},
{"f_4610:posixunix_scm",(void*)f_4610},
{"f_4598:posixunix_scm",(void*)f_4598},
{"f_4574:posixunix_scm",(void*)f_4574},
{"f_4580:posixunix_scm",(void*)f_4580},
{"f_4566:posixunix_scm",(void*)f_4566},
{"f_4548:posixunix_scm",(void*)f_4548},
{"f_4543:posixunix_scm",(void*)f_4543},
{"f_4502:posixunix_scm",(void*)f_4502},
{"f_4515:posixunix_scm",(void*)f_4515},
{"f_4479:posixunix_scm",(void*)f_4479},
{"f_4500:posixunix_scm",(void*)f_4500},
{"f_4486:posixunix_scm",(void*)f_4486},
{"f_4325:posixunix_scm",(void*)f_4325},
{"f_4430:posixunix_scm",(void*)f_4430},
{"f_4438:posixunix_scm",(void*)f_4438},
{"f_4425:posixunix_scm",(void*)f_4425},
{"f_4327:posixunix_scm",(void*)f_4327},
{"f_4334:posixunix_scm",(void*)f_4334},
{"f_4337:posixunix_scm",(void*)f_4337},
{"f_4340:posixunix_scm",(void*)f_4340},
{"f_4424:posixunix_scm",(void*)f_4424},
{"f_4344:posixunix_scm",(void*)f_4344},
{"f_4358:posixunix_scm",(void*)f_4358},
{"f_4368:posixunix_scm",(void*)f_4368},
{"f_4371:posixunix_scm",(void*)f_4371},
{"f_4374:posixunix_scm",(void*)f_4374},
{"f_4380:posixunix_scm",(void*)f_4380},
{"f_4390:posixunix_scm",(void*)f_4390},
{"f_4301:posixunix_scm",(void*)f_4301},
{"f_4323:posixunix_scm",(void*)f_4323},
{"f_4319:posixunix_scm",(void*)f_4319},
{"f_4277:posixunix_scm",(void*)f_4277},
{"f_4299:posixunix_scm",(void*)f_4299},
{"f_4295:posixunix_scm",(void*)f_4295},
{"f_4182:posixunix_scm",(void*)f_4182},
{"f_4263:posixunix_scm",(void*)f_4263},
{"f_4249:posixunix_scm",(void*)f_4249},
{"f_4197:posixunix_scm",(void*)f_4197},
{"f_4202:posixunix_scm",(void*)f_4202},
{"f_4225:posixunix_scm",(void*)f_4225},
{"f_4245:posixunix_scm",(void*)f_4245},
{"f_4208:posixunix_scm",(void*)f_4208},
{"f_4222:posixunix_scm",(void*)f_4222},
{"f_4120:posixunix_scm",(void*)f_4120},
{"f_4133:posixunix_scm",(void*)f_4133},
{"f_4145:posixunix_scm",(void*)f_4145},
{"f_4139:posixunix_scm",(void*)f_4139},
{"f_4110:posixunix_scm",(void*)f_4110},
{"f_4117:posixunix_scm",(void*)f_4117},
{"f_4099:posixunix_scm",(void*)f_4099},
{"f_4106:posixunix_scm",(void*)f_4106},
{"f_4089:posixunix_scm",(void*)f_4089},
{"f_4096:posixunix_scm",(void*)f_4096},
{"f_4079:posixunix_scm",(void*)f_4079},
{"f_4086:posixunix_scm",(void*)f_4086},
{"f_4070:posixunix_scm",(void*)f_4070},
{"f_4077:posixunix_scm",(void*)f_4077},
{"f_4061:posixunix_scm",(void*)f_4061},
{"f_4068:posixunix_scm",(void*)f_4068},
{"f_4052:posixunix_scm",(void*)f_4052},
{"f_4059:posixunix_scm",(void*)f_4059},
{"f_4043:posixunix_scm",(void*)f_4043},
{"f_4050:posixunix_scm",(void*)f_4050},
{"f_4037:posixunix_scm",(void*)f_4037},
{"f_4041:posixunix_scm",(void*)f_4041},
{"f_4031:posixunix_scm",(void*)f_4031},
{"f_4035:posixunix_scm",(void*)f_4035},
{"f_4025:posixunix_scm",(void*)f_4025},
{"f_4029:posixunix_scm",(void*)f_4029},
{"f_4019:posixunix_scm",(void*)f_4019},
{"f_4023:posixunix_scm",(void*)f_4023},
{"f_4013:posixunix_scm",(void*)f_4013},
{"f_4017:posixunix_scm",(void*)f_4017},
{"f_4007:posixunix_scm",(void*)f_4007},
{"f_4011:posixunix_scm",(void*)f_4011},
{"f_3982:posixunix_scm",(void*)f_3982},
{"f_3986:posixunix_scm",(void*)f_3986},
{"f_3945:posixunix_scm",(void*)f_3945},
{"f_3977:posixunix_scm",(void*)f_3977},
{"f_3970:posixunix_scm",(void*)f_3970},
{"f_3949:posixunix_scm",(void*)f_3949},
{"f_3753:posixunix_scm",(void*)f_3753},
{"f_3926:posixunix_scm",(void*)f_3926},
{"f_3769:posixunix_scm",(void*)f_3769},
{"f_3900:posixunix_scm",(void*)f_3900},
{"f_3775:posixunix_scm",(void*)f_3775},
{"f_3778:posixunix_scm",(void*)f_3778},
{"f_3860:posixunix_scm",(void*)f_3860},
{"f_3858:posixunix_scm",(void*)f_3858},
{"f_3817:posixunix_scm",(void*)f_3817},
{"f_3835:posixunix_scm",(void*)f_3835},
{"f_3833:posixunix_scm",(void*)f_3833},
{"f_3821:posixunix_scm",(void*)f_3821},
{"f_3751:posixunix_scm",(void*)f_3751},
{"f_3749:posixunix_scm",(void*)f_3749},
{"f_3747:posixunix_scm",(void*)f_3747},
{"f_3715:posixunix_scm",(void*)f_3715},
{"f_3722:posixunix_scm",(void*)f_3722},
{"f_3728:posixunix_scm",(void*)f_3728},
{"f_3735:posixunix_scm",(void*)f_3735},
{"f_3676:posixunix_scm",(void*)f_3676},
{"f_3683:posixunix_scm",(void*)f_3683},
{"f_3692:posixunix_scm",(void*)f_3692},
{"f_3634:posixunix_scm",(void*)f_3634},
{"f_3644:posixunix_scm",(void*)f_3644},
{"f_3647:posixunix_scm",(void*)f_3647},
{"f_3650:posixunix_scm",(void*)f_3650},
{"f_3619:posixunix_scm",(void*)f_3619},
{"f_3581:posixunix_scm",(void*)f_3581},
{"f_3611:posixunix_scm",(void*)f_3611},
{"f_3598:posixunix_scm",(void*)f_3598},
{"f_3601:posixunix_scm",(void*)f_3601},
{"f_3542:posixunix_scm",(void*)f_3542},
{"f_3501:posixunix_scm",(void*)f_3501},
{"f_3498:posixunix_scm",(void*)f_3498},
{"f_3480:posixunix_scm",(void*)f_3480},
{"f_3484:posixunix_scm",(void*)f_3484},
{"f_3495:posixunix_scm",(void*)f_3495},
{"f_3491:posixunix_scm",(void*)f_3491},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}
/* end of file */
