#!/bin/bash

# Prepare the Solaris stuff
#
cat << EOF >pkginfo
PKG=CSWcherokee
NAME=cherokee - Fast and flexible web server
VERSION=0.4.29
CATEGORY=application
VENDOR=http://www.0x50.org  packaged for CSW by Alvaro Lopez Ortega
EMAIL=alvaro@sun.com
PSTAMP=Alvaro Lopez Ortega
HOTLINE=http://www.blastwave.org/bugtrack/
EOF

# It MUST use rpath
#
export LD_OPTIONS='-R/opt/csw/lib/$ISALIST -R/opt/csw/lib -L/opt/csw/lib'

# Configure and build
#
./configure --prefix=/opt/csw
gmake

# Install it
#
stagepkg

# Build the package
#
echo "Cherokee author and copyright holder:"      >> copyright
echo "   Alvaro Lopez Ortega <alvaro@alobbs.com>" >> copyright
echo ""     >> copyright
cat COPYING >> copyright

cp cswstage/prototype .
createpkg -r cswstage

