/* cheese-window.c generated by valac 0.14.0, the Vala compiler
 * generated from cheese-window.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <cheese-fileutil.h>
#include <clutter/clutter.h>
#include <clutter-gtk/clutter-gtk.h>
#include <thumbview/eog-thumb-nav.h>
#include <thumbview/cheese-thumb-view.h>
#include <gee.h>
#include <cheese-camera.h>
#include <cheese-flash.h>
#include <cheese-effect.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdkx.h>
#include <cheese-config.h>
#include <cheese-camera-device.h>
#include <canberra-gtk.h>
#include <canberra.h>
#include <gst/gst.h>
#include <stdio.h>
#include <float.h>
#include <math.h>


#define TYPE_PK_PROXY (pk_proxy_get_type ())
#define PK_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PK_PROXY, PkProxy))
#define IS_PK_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PK_PROXY))
#define PK_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PK_PROXY, PkProxyIface))

typedef struct _PkProxy PkProxy;
typedef struct _PkProxyIface PkProxyIface;

#define TYPE_PK_PROXY_PROXY (pk_proxy_proxy_get_type ())
typedef GDBusProxy PkProxyProxy;
typedef GDBusProxyClass PkProxyProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define CHEESE_TYPE_MAIN_WINDOW (cheese_main_window_get_type ())
#define CHEESE_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow))
#define CHEESE_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))
#define CHEESE_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))

typedef struct _CheeseMainWindow CheeseMainWindow;
typedef struct _CheeseMainWindowClass CheeseMainWindowClass;
typedef struct _CheeseMainWindowPrivate CheeseMainWindowPrivate;

#define CHEESE_TYPE_EFFECTS_MANAGER (cheese_effects_manager_get_type ())
#define CHEESE_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManager))
#define CHEESE_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))
#define CHEESE_IS_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_IS_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_EFFECTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))

typedef struct _CheeseEffectsManager CheeseEffectsManager;
typedef struct _CheeseEffectsManagerClass CheeseEffectsManagerClass;

#define CHEESE_TYPE_PREFERENCES_DIALOG (cheese_preferences_dialog_get_type ())
#define CHEESE_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialog))
#define CHEESE_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))
#define CHEESE_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))

typedef struct _CheesePreferencesDialog CheesePreferencesDialog;
typedef struct _CheesePreferencesDialogClass CheesePreferencesDialogClass;

#define CHEESE_TYPE_SHAREABLE_MEDIA (cheese_shareable_media_get_type ())
#define CHEESE_SHAREABLE_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_SHAREABLE_MEDIA, CheeseShareableMedia))
#define CHEESE_SHAREABLE_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_SHAREABLE_MEDIA, CheeseShareableMediaClass))
#define CHEESE_IS_SHAREABLE_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_SHAREABLE_MEDIA))
#define CHEESE_IS_SHAREABLE_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_SHAREABLE_MEDIA))
#define CHEESE_SHAREABLE_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_SHAREABLE_MEDIA, CheeseShareableMediaClass))

typedef struct _CheeseShareableMedia CheeseShareableMedia;
typedef struct _CheeseShareableMediaClass CheeseShareableMediaClass;

#define CHEESE_TYPE_COUNTDOWN (cheese_countdown_get_type ())
#define CHEESE_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdown))
#define CHEESE_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))
#define CHEESE_IS_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_IS_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_COUNTDOWN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))

typedef struct _CheeseCountdown CheeseCountdown;
typedef struct _CheeseCountdownClass CheeseCountdownClass;

#define CHEESE_MAIN_WINDOW_TYPE_DELETE_RESPONSE (cheese_main_window_delete_response_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _CheeseMainWindowInstallPackagesData CheeseMainWindowInstallPackagesData;
typedef struct _CheeseCountdownPrivate CheeseCountdownPrivate;
typedef struct _CheeseEffectsManagerPrivate CheeseEffectsManagerPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))

struct _PkProxyIface {
	GTypeInterface parent_iface;
	void (*install_package_names) (PkProxy* self, guint xid, gchar** packages_names, int packages_names_length1, const gchar* interaction, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*install_package_names_finish) (PkProxy* self, GAsyncResult* _res_, GError** error);
};

struct _CheeseMainWindow {
	GtkWindow parent_instance;
	CheeseMainWindowPrivate * priv;
};

struct _CheeseMainWindowClass {
	GtkWindowClass parent_class;
};

struct _CheeseMainWindowPrivate {
	CheeseMediaMode current_mode;
	GtkBuilder* gtk_builder;
	ClutterScript* clutter_builder;
	GSettings* settings;
	GtkWidget* thumbnails;
	GtkClutterEmbed* viewport_widget;
	GtkGrid* main_vbox;
	EogThumbNav* thumb_nav;
	CheeseThumbView* thumb_view;
	GtkAlignment* thumbnails_right;
	GtkAlignment* thumbnails_bottom;
	GtkMenuBar* menubar;
	GtkBox* leave_fullscreen_button_container;
	GtkToggleButton* photo_toggle_button;
	GtkToggleButton* video_toggle_button;
	GtkToggleButton* burst_toggle_button;
	GtkButton* take_action_button;
	GtkLabel* take_action_button_label;
	GtkImage* take_action_button_image;
	GtkToggleButton* effects_toggle_button;
	GtkButton* leave_fullscreen_button;
	GtkBox* buttons_area;
	GtkMenu* thumbnail_popup;
	ClutterStage* viewport;
	ClutterBox* viewport_layout;
	ClutterTexture* video_preview;
	ClutterBinLayout* viewport_layout_manager;
	ClutterText* countdown_layer;
	ClutterRectangle* background_layer;
	ClutterText* error_layer;
	ClutterBox* current_effects_grid;
	gint current_effects_page;
	GeeArrayList* effects_grids;
	GtkAction* take_photo_action;
	GtkAction* take_video_action;
	GtkAction* take_burst_action;
	GtkAction* photo_mode_action;
	GtkAction* video_mode_action;
	GtkAction* burst_mode_action;
	GtkToggleAction* effects_toggle_action;
	GtkToggleAction* wide_mode_action;
	GtkToggleAction* fullscreen_action;
	GtkAction* countdown_action;
	GtkAction* effects_page_prev_action;
	GtkAction* effects_page_next_action;
	GtkAction* share_action;
	GtkActionGroup* main_actions;
	gboolean is_fullscreen;
	gboolean is_wide_mode;
	gboolean is_recording;
	gboolean is_bursting;
	gboolean is_effects_selector_active;
	gboolean is_camera_actions_sensitive;
	gboolean action_cancelled;
	gboolean is_command_line_startup;
	GtkButton** buttons;
	gint buttons_length1;
	gint _buttons_size_;
	CheeseCamera* camera;
	CheeseFileUtil* fileutil;
	CheeseFlash* flash;
	CheeseEffectsManager* effects_manager;
	CheesePreferencesDialog* preferences_dialog;
	CheeseEffect* selected_effect;
	CheeseShareableMedia* shareable_media;
	GSource* fullscreen_timeout;
	CheeseCountdown* current_countdown;
	gint burst_count;
	guint burst_callback_id;
	GeeHashMap* action_sensitivities;
};

typedef enum  {
	CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP = 1,
	CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL = 2
} CheeseMainWindowDeleteResponse;

struct _CheeseMainWindowInstallPackagesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	CheeseMainWindow* self;
	GdkWindow* _tmp0_;
	GdkCursor* _tmp1_;
	GdkCursor* _tmp2_;
	PkProxy* _tmp3_;
	PkProxy* pk_proxy;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** packages;
	gint packages_length1;
	gint _packages_size_;
	PkProxy* _tmp6_;
	GdkWindow* _tmp7_;
	Window _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GError* _error_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GError * _inner_error_;
};

typedef void (*CheeseCountdownCountdownCallback) (void* user_data);
struct _CheeseCountdown {
	GObject parent_instance;
	CheeseCountdownPrivate * priv;
	gboolean running;
};

struct _CheeseCountdownClass {
	GObjectClass parent_class;
};

struct _CheeseEffectsManager {
	GObject parent_instance;
	CheeseEffectsManagerPrivate * priv;
	GeeArrayList* effects;
};

struct _CheeseEffectsManagerClass {
	GObjectClass parent_class;
};


static gpointer cheese_main_window_parent_class = NULL;

GType pk_proxy_proxy_get_type (void) G_GNUC_CONST;
guint pk_proxy_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType pk_proxy_get_type (void) G_GNUC_CONST;
void pk_proxy_install_package_names (PkProxy* self, guint xid, gchar** packages_names, int packages_names_length1, const gchar* interaction, GAsyncReadyCallback _callback_, gpointer _user_data_);
void pk_proxy_install_package_names_finish (PkProxy* self, GAsyncResult* _res_, GError** error);
static void pk_proxy_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void pk_proxy_proxy_install_package_names_async (PkProxy* self, guint xid, gchar** packages_names, int packages_names_length1, const gchar* interaction, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void pk_proxy_proxy_install_package_names_finish (PkProxy* self, GAsyncResult* _res_, GError** error);
static void pk_proxy_proxy_pk_proxy_interface_init (PkProxyIface* iface);
static void _dbus_pk_proxy_install_package_names (PkProxy* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_pk_proxy_install_package_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void pk_proxy_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* pk_proxy_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean pk_proxy_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _pk_proxy_unregister_object (gpointer user_data);
#define FULLSCREEN_TIMEOUT_INTERVAL (5 * 1000)
#define EFFECTS_PER_PAGE 9
#define SENDTO_EXEC "nautilus-sendto"
GType cheese_main_window_get_type (void) G_GNUC_CONST;
GType cheese_effects_manager_get_type (void) G_GNUC_CONST;
GType cheese_preferences_dialog_get_type (void) G_GNUC_CONST;
GType cheese_shareable_media_get_type (void) G_GNUC_CONST;
GType cheese_countdown_get_type (void) G_GNUC_CONST;
#define CHEESE_MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowPrivate))
enum  {
	CHEESE_MAIN_WINDOW_DUMMY_PROPERTY
};
static GType cheese_main_window_delete_response_get_type (void) G_GNUC_UNUSED;
void cheese_main_window_on_quit (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_preferences_dialog (GtkAction* action, CheeseMainWindow* self);
CheesePreferencesDialog* cheese_preferences_dialog_new (CheeseCamera* camera, GSettings* settings);
CheesePreferencesDialog* cheese_preferences_dialog_construct (GType object_type, CheeseCamera* camera, GSettings* settings);
void cheese_preferences_dialog_set_current_mode (CheesePreferencesDialog* self, CheeseMediaMode mode);
void cheese_preferences_dialog_show (CheesePreferencesDialog* self);
gboolean cheese_main_window_on_thumbnail_mouse_button_press (CheeseMainWindow* self, GtkWidget* iconview, GdkEventButton* event);
void cheese_main_window_on_file_open (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_file_delete (GtkAction* action, CheeseMainWindow* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void cheese_main_window_on_file_move_to_trash (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_file_move_to_trash_all (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_share_files (GtkAction* action, CheeseMainWindow* self);
static void cheese_main_window_install_packages (CheeseMainWindow* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void cheese_main_window_install_packages_finish (CheeseMainWindow* self, GAsyncResult* _res_);
static void ___lambda3_ (CheeseMainWindow* self, GObject* obj, GAsyncResult* res);
static void ____lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void cheese_shareable_media_share_files (CheeseShareableMedia* self, GList* files);
static void cheese_main_window_install_packages_data_free (gpointer _data);
static gboolean cheese_main_window_install_packages_co (CheeseMainWindowInstallPackagesData* _data_);
static void cheese_main_window_install_packages_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void cheese_main_window_on_file_save_as (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_help_contents (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_help_about (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_layout_wide_mode (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_set_wide_mode (CheeseMainWindow* self, gboolean wide_mode);
void cheese_main_window_on_layout_fullscreen (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self, gboolean fullscreen_mode);
void cheese_main_window_on_mode_change (GtkRadioAction* action, CheeseMainWindow* self);
static void cheese_main_window_set_mode (CheeseMainWindow* self, CheeseMediaMode mode);
static void cheese_main_window_enable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_disable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_set_resolution (CheeseMainWindow* self, CheeseMediaMode mode);
static void cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self);
static void cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self);
static gboolean __lambda4_ (CheeseMainWindow* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static gboolean cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self, GtkWidget* viewport, GdkEventMotion* e);
static gboolean _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
void cheese_main_window_on_stage_resize (CheeseMainWindow* self, ClutterActor* actor, ClutterActorBox* box, ClutterAllocationFlags flags);
void cheese_main_window_on_countdown_toggle (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_finish_countdown_callback (CheeseMainWindow* self);
void cheese_main_window_take_photo (CheeseMainWindow* self);
CheeseCountdown* cheese_countdown_new (ClutterText* countdown_actor);
CheeseCountdown* cheese_countdown_construct (GType object_type, ClutterText* countdown_actor);
void cheese_countdown_start (CheeseCountdown* self, CheeseCountdownCountdownCallback completed_callback, void* completed_callback_target);
static void _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self);
static gboolean cheese_main_window_burst_take_photo (CheeseMainWindow* self);
void cheese_main_window_toggle_photo_bursting (CheeseMainWindow* self, gboolean is_start);
static gboolean cheese_main_window_on_key_release (CheeseMainWindow* self, GdkEventKey* event);
void cheese_countdown_stop (CheeseCountdown* self);
void cheese_main_window_toggle_video_recording (CheeseMainWindow* self, gboolean is_start);
static gboolean _cheese_main_window_burst_take_photo_gsource_func (gpointer self);
void cheese_main_window_on_take_action (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_effects_toggle (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_toggle_effects_selector (CheeseMainWindow* self, gboolean active);
gboolean cheese_main_window_on_selected_effect_change (CheeseMainWindow* self, ClutterActor* source, ClutterButtonEvent* event);
void cheese_main_window_on_prev_effects_page (GtkAction* action, CheeseMainWindow* self);
static void cheese_main_window_activate_effects_page (CheeseMainWindow* self, gint number);
void cheese_main_window_on_next_effects_page (GtkAction* action, CheeseMainWindow* self);
static void cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self);
static void cheese_main_window_setup_effects_selector (CheeseMainWindow* self);
CheeseEffectsManager* cheese_effects_manager_new (void);
CheeseEffectsManager* cheese_effects_manager_construct (GType object_type);
void cheese_effects_manager_load_effects (CheeseEffectsManager* self);
static gboolean _cheese_main_window_on_selected_effect_change_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
void cheese_main_window_toggle_camera_actions_sensitivities (CheeseMainWindow* self, gboolean active);
static void cheese_main_window_camera_state_changed (CheeseMainWindow* self, GstState new_state);
CheeseEffect* cheese_effects_manager_get_effect (CheeseEffectsManager* self, const gchar* name);
void cheese_main_window_set_startup_wide_mode (CheeseMainWindow* self);
void cheese_main_window_set_startup_fullscreen_mode (CheeseMainWindow* self);
void cheese_main_window_setup_ui (CheeseMainWindow* self);
CheeseShareableMedia* cheese_shareable_media_new (CheeseMainWindow* main_window);
CheeseShareableMedia* cheese_shareable_media_construct (GType object_type, CheeseMainWindow* main_window);
void cheese_main_window_on_action_pre_activated (CheeseMainWindow* self, GtkAction* action);
static void _cheese_main_window_on_action_pre_activated_gtk_action_group_pre_activate (GtkActionGroup* _sender, GtkAction* p0, gpointer self);
static void _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self);
static gboolean _cheese_main_window_on_thumbnail_mouse_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _cheese_main_window_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
void cheese_main_window_setup_camera (CheeseMainWindow* self, const gchar* uri);
static void _cheese_main_window_camera_state_changed_cheese_camera_state_flags_changed (CheeseCamera* _sender, GstState new_state, gpointer self);
void cheese_main_window_start_thumbview_monitors (CheeseMainWindow* self);
CheeseMainWindow* cheese_main_window_new (void);
CheeseMainWindow* cheese_main_window_construct (GType object_type);
static void cheese_main_window_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _pk_proxy_dbus_arg_info_install_package_names_xid = {-1, "xid", "u"};
static const GDBusArgInfo _pk_proxy_dbus_arg_info_install_package_names_packages_names = {-1, "packages_names", "as"};
static const GDBusArgInfo _pk_proxy_dbus_arg_info_install_package_names_interaction = {-1, "interaction", "s"};
static const GDBusArgInfo * const _pk_proxy_dbus_arg_info_install_package_names_in[] = {&_pk_proxy_dbus_arg_info_install_package_names_xid, &_pk_proxy_dbus_arg_info_install_package_names_packages_names, &_pk_proxy_dbus_arg_info_install_package_names_interaction, NULL};
static const GDBusArgInfo * const _pk_proxy_dbus_arg_info_install_package_names_out[] = {NULL};
static const GDBusMethodInfo _pk_proxy_dbus_method_info_install_package_names = {-1, "InstallPackageNames", (GDBusArgInfo **) (&_pk_proxy_dbus_arg_info_install_package_names_in), (GDBusArgInfo **) (&_pk_proxy_dbus_arg_info_install_package_names_out)};
static const GDBusMethodInfo * const _pk_proxy_dbus_method_info[] = {&_pk_proxy_dbus_method_info_install_package_names, NULL};
static const GDBusSignalInfo * const _pk_proxy_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _pk_proxy_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _pk_proxy_dbus_interface_info = {-1, "org.freedesktop.PackageKit.Modify", (GDBusMethodInfo **) (&_pk_proxy_dbus_method_info), (GDBusSignalInfo **) (&_pk_proxy_dbus_signal_info), (GDBusPropertyInfo **) (&_pk_proxy_dbus_property_info)};
static const GDBusInterfaceVTable _pk_proxy_dbus_interface_vtable = {pk_proxy_dbus_interface_method_call, pk_proxy_dbus_interface_get_property, pk_proxy_dbus_interface_set_property};

void pk_proxy_install_package_names (PkProxy* self, guint xid, gchar** packages_names, int packages_names_length1, const gchar* interaction, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PK_PROXY_GET_INTERFACE (self)->install_package_names (self, xid, packages_names, packages_names_length1, interaction, _callback_, _user_data_);
}


void pk_proxy_install_package_names_finish (PkProxy* self, GAsyncResult* _res_, GError** error) {
	PK_PROXY_GET_INTERFACE (self)->install_package_names_finish (self, _res_, error);
}


static void pk_proxy_base_init (PkProxyIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType pk_proxy_get_type (void) {
	static volatile gsize pk_proxy_type_id__volatile = 0;
	if (g_once_init_enter (&pk_proxy_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PkProxyIface), (GBaseInitFunc) pk_proxy_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType pk_proxy_type_id;
		pk_proxy_type_id = g_type_register_static (G_TYPE_INTERFACE, "PkProxy", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (pk_proxy_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (pk_proxy_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) pk_proxy_proxy_get_type);
		g_type_set_qdata (pk_proxy_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.PackageKit.Modify");
		g_type_set_qdata (pk_proxy_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) pk_proxy_register_object);
		g_once_init_leave (&pk_proxy_type_id__volatile, pk_proxy_type_id);
	}
	return pk_proxy_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (PkProxyProxy, pk_proxy_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_PK_PROXY, pk_proxy_proxy_pk_proxy_interface_init) )
static void pk_proxy_proxy_class_init (PkProxyProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = pk_proxy_proxy_g_signal;
}


static void pk_proxy_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void pk_proxy_proxy_init (PkProxyProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void pk_proxy_proxy_install_package_names_async (PkProxy* self, guint xid, gchar** packages_names, int packages_names_length1, const gchar* interaction, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp0_;
	GVariantBuilder _tmp1_;
	int _tmp2_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.PackageKit.Modify", "InstallPackageNames");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (xid));
	_tmp0_ = packages_names;
	g_variant_builder_init (&_tmp1_, G_VARIANT_TYPE ("as"));
	for (_tmp2_ = 0; _tmp2_ < packages_names_length1; _tmp2_++) {
		g_variant_builder_add_value (&_tmp1_, g_variant_new_string (*_tmp0_));
		_tmp0_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp1_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (interaction));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void pk_proxy_proxy_install_package_names_finish (PkProxy* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void pk_proxy_proxy_pk_proxy_interface_init (PkProxyIface* iface) {
	iface->install_package_names = pk_proxy_proxy_install_package_names_async;
	iface->install_package_names_finish = pk_proxy_proxy_install_package_names_finish;
}


static void _dbus_pk_proxy_install_package_names (PkProxy* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	guint xid = 0U;
	GVariant* _tmp3_;
	gchar** packages_names = NULL;
	int packages_names_length1 = 0;
	GVariant* _tmp4_;
	gchar** _tmp5_;
	int _tmp5__length;
	int _tmp5__size;
	int _tmp5__length1;
	GVariantIter _tmp6_;
	GVariant* _tmp7_;
	gchar* interaction = NULL;
	GVariant* _tmp8_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	xid = g_variant_get_uint32 (_tmp3_);
	g_variant_unref (_tmp3_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp5_ = g_new (gchar*, 5);
	_tmp5__length = 0;
	_tmp5__size = 4;
	_tmp5__length1 = 0;
	g_variant_iter_init (&_tmp6_, _tmp4_);
	for (; (_tmp7_ = g_variant_iter_next_value (&_tmp6_)) != NULL; _tmp5__length1++) {
		if (_tmp5__size == _tmp5__length) {
			_tmp5__size = 2 * _tmp5__size;
			_tmp5_ = g_renew (gchar*, _tmp5_, _tmp5__size + 1);
		}
		_tmp5_[_tmp5__length++] = g_variant_dup_string (_tmp7_, NULL);
		g_variant_unref (_tmp7_);
	}
	packages_names_length1 = _tmp5__length1;
	_tmp5_[_tmp5__length] = NULL;
	packages_names = _tmp5_;
	g_variant_unref (_tmp4_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	interaction = g_variant_dup_string (_tmp8_, NULL);
	g_variant_unref (_tmp8_);
	pk_proxy_install_package_names (self, xid, packages_names, packages_names_length1, interaction, (GAsyncReadyCallback) _dbus_pk_proxy_install_package_names_ready, invocation);
	packages_names = (_vala_array_free (packages_names, packages_names_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (interaction);
}


static void _dbus_pk_proxy_install_package_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	pk_proxy_install_package_names_finish ((PkProxy*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void pk_proxy_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "InstallPackageNames") == 0) {
		_dbus_pk_proxy_install_package_names (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* pk_proxy_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean pk_proxy_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint pk_proxy_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_pk_proxy_dbus_interface_info), &_pk_proxy_dbus_interface_vtable, data, _pk_proxy_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _pk_proxy_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


/**
   * Responses from the delete files confirmation dialog.
   *
   * @param SKIP skip a single file
   * @param SKIP_ALL skill all following files
   */
static GType cheese_main_window_delete_response_get_type (void) {
	static volatile gsize cheese_main_window_delete_response_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_main_window_delete_response_type_id__volatile)) {
		static const GEnumValue values[] = {{CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP, "CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP", "skip"}, {CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL, "CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL", "skip-all"}, {0, NULL, NULL}};
		GType cheese_main_window_delete_response_type_id;
		cheese_main_window_delete_response_type_id = g_enum_register_static ("CheeseMainWindowDeleteResponse", values);
		g_once_init_leave (&cheese_main_window_delete_response_type_id__volatile, cheese_main_window_delete_response_type_id);
	}
	return cheese_main_window_delete_response_type_id__volatile;
}


/**
   * Destroy the main window, and shutdown the application, when quitting.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_quit (GtkAction* action, CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	gtk_widget_destroy ((GtkWidget*) self);
}


/**
   * Show the preferences dialog when requested, creating it as necessary.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_preferences_dialog (GtkAction* action, CheeseMainWindow* self) {
	CheesePreferencesDialog* _tmp0_;
	CheesePreferencesDialog* _tmp4_;
	CheeseMediaMode _tmp5_;
	CheesePreferencesDialog* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	if (_tmp0_ == NULL) {
		CheeseCamera* _tmp1_;
		GSettings* _tmp2_;
		CheesePreferencesDialog* _tmp3_;
		_tmp1_ = self->priv->camera;
		_tmp2_ = self->priv->settings;
		_tmp3_ = cheese_preferences_dialog_new (_tmp1_, _tmp2_);
		_g_object_unref0 (self->priv->preferences_dialog);
		self->priv->preferences_dialog = _tmp3_;
	}
	_tmp4_ = self->priv->preferences_dialog;
	_tmp5_ = self->priv->current_mode;
	cheese_preferences_dialog_set_current_mode (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->preferences_dialog;
	cheese_preferences_dialog_show (_tmp6_);
}


/**
   * Popup a context menu when right-clicking on a thumbnail.
   *
   * @param iconview the thumbnail view that emitted the signal
   * @param event the event
   * @return false, to allow further processing of the event
   */
static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


gboolean cheese_main_window_on_thumbnail_mouse_button_press (CheeseMainWindow* self, GtkWidget* iconview, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkTreePath* path = NULL;
	CheeseThumbView* _tmp0_;
	GdkEventButton _tmp1_;
	gdouble _tmp2_;
	GdkEventButton _tmp3_;
	gdouble _tmp4_;
	GtkTreePath* _tmp5_ = NULL;
	GtkTreePath* _tmp6_;
	GtkTreePath* _tmp7_;
	CheeseThumbView* _tmp8_;
	GtkTreePath* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GdkEventButton _tmp16_;
	GdkEventType _tmp17_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iconview != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.x;
	_tmp3_ = *event;
	_tmp4_ = _tmp3_.y;
	_tmp5_ = gtk_icon_view_get_path_at_pos ((GtkIconView*) _tmp0_, (gint) _tmp2_, (gint) _tmp4_);
	_tmp6_ = _gtk_tree_path_copy0 (_tmp5_);
	_gtk_tree_path_free0 (path);
	path = _tmp6_;
	_tmp7_ = path;
	if (_tmp7_ == NULL) {
		result = FALSE;
		_gtk_tree_path_free0 (path);
		return result;
	}
	_tmp8_ = self->priv->thumb_view;
	_tmp9_ = path;
	_tmp10_ = gtk_icon_view_path_is_selected ((GtkIconView*) _tmp8_, _tmp9_);
	if (!_tmp10_) {
		CheeseThumbView* _tmp11_;
		CheeseThumbView* _tmp12_;
		GtkTreePath* _tmp13_;
		CheeseThumbView* _tmp14_;
		GtkTreePath* _tmp15_;
		_tmp11_ = self->priv->thumb_view;
		g_signal_emit_by_name ((GtkIconView*) _tmp11_, "unselect-all");
		_tmp12_ = self->priv->thumb_view;
		_tmp13_ = path;
		gtk_icon_view_select_path ((GtkIconView*) _tmp12_, _tmp13_);
		_tmp14_ = self->priv->thumb_view;
		_tmp15_ = path;
		gtk_icon_view_set_cursor ((GtkIconView*) _tmp14_, _tmp15_, NULL, FALSE);
	}
	_tmp16_ = *event;
	_tmp17_ = _tmp16_.type;
	if (_tmp17_ == GDK_BUTTON_PRESS) {
		GdkEventButton _tmp18_;
		guint _tmp19_;
		_tmp18_ = *event;
		_tmp19_ = _tmp18_.button;
		if (_tmp19_ == ((guint) 3)) {
			GtkMenu* _tmp20_;
			CheeseThumbView* _tmp21_;
			GdkEventButton _tmp22_;
			guint _tmp23_;
			GdkEventButton _tmp24_;
			guint32 _tmp25_;
			_tmp20_ = self->priv->thumbnail_popup;
			_tmp21_ = self->priv->thumb_view;
			_tmp22_ = *event;
			_tmp23_ = _tmp22_.button;
			_tmp24_ = *event;
			_tmp25_ = _tmp24_.time;
			gtk_menu_popup (_tmp20_, NULL, (GtkWidget*) _tmp21_, NULL, NULL, _tmp23_, _tmp25_);
		}
	} else {
		GdkEventButton _tmp26_;
		GdkEventType _tmp27_;
		_tmp26_ = *event;
		_tmp27_ = _tmp26_.type;
		if (_tmp27_ == GDK_2BUTTON_PRESS) {
			cheese_main_window_on_file_open (NULL, self);
		}
	}
	result = FALSE;
	_gtk_tree_path_free0 (path);
	return result;
}


/**
   * Open an image associated with a thumbnail in the default application.
   *
   * @param action the action that emitted the signal, or null
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void cheese_main_window_on_file_open (GtkAction* action, CheeseMainWindow* self) {
	gchar* filename = NULL;
	gchar* uri = NULL;
	GdkScreen* screen = NULL;
	CheeseThumbView* _tmp0_;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_image (_tmp0_);
	_g_free0 (filename);
	filename = _tmp1_;
	_tmp2_ = filename;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (screen);
		_g_free0 (uri);
		_g_free0 (filename);
		return;
	}
	{
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		GdkScreen* _tmp6_ = NULL;
		GdkScreen* _tmp7_;
		GdkScreen* _tmp8_;
		const gchar* _tmp9_;
		guint32 _tmp10_ = 0U;
		_tmp3_ = filename;
		_tmp4_ = g_filename_to_uri (_tmp3_, NULL, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_g_free0 (uri);
		uri = _tmp5_;
		_tmp6_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (screen);
		screen = _tmp7_;
		_tmp8_ = screen;
		_tmp9_ = uri;
		_tmp10_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp8_, _tmp9_, _tmp10_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_;
		GtkMessageDialog* _tmp13_;
		GtkMessageDialog* _tmp14_;
		GtkMessageDialog* error_dialog;
		GtkMessageDialog* _tmp15_;
		GtkMessageDialog* _tmp16_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = _ ("Could not open %s");
		_tmp12_ = filename;
		_tmp13_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp11_, _tmp12_);
		_tmp14_ = g_object_ref_sink (_tmp13_);
		error_dialog = _tmp14_;
		_tmp15_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp15_);
		_tmp16_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp16_);
		_g_object_unref0 (error_dialog);
		_g_error_free0 (err);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (screen);
		_g_free0 (uri);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (screen);
	_g_free0 (uri);
	_g_free0 (filename);
}


/**
   * Delete the requested image or images in the thumbview from storage.
   *
   * A confirmation dialog is shown to the user before deleting any files.
   *
   * @param action the action that emitted the signal
   */
static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void cheese_main_window_on_file_delete (GtkAction* action, CheeseMainWindow* self) {
	gint response = 0;
	gint error_response = 0;
	gboolean skip_all_errors;
	CheeseThumbView* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* files;
	GList* _tmp2_;
	guint _tmp3_ = 0U;
	guint files_length;
	guint _tmp4_;
	const gchar* _tmp5_ = NULL;
	guint _tmp6_;
	GtkMessageDialog* _tmp7_;
	GtkMessageDialog* _tmp8_;
	GtkMessageDialog* confirmation_dialog;
	GtkMessageDialog* _tmp9_;
	GtkMessageDialog* _tmp10_;
	GtkMessageDialog* _tmp11_;
	guint _tmp12_;
	const gchar* _tmp13_ = NULL;
	GtkMessageDialog* _tmp14_;
	gint _tmp15_ = 0;
	gint _tmp16_;
	GtkMessageDialog* _tmp38_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	skip_all_errors = FALSE;
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_images_list (_tmp0_);
	files = _tmp1_;
	_tmp2_ = files;
	_tmp3_ = g_list_length (_tmp2_);
	files_length = _tmp3_;
	_tmp4_ = files_length;
	_tmp5_ = ngettext ("Are you sure you want to permanently delete the file?", "Are you sure you want to permanently delete %d files?", (gulong) _tmp4_);
	_tmp6_ = files_length;
	_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, _tmp5_, _tmp6_);
	_tmp8_ = g_object_ref_sink (_tmp7_);
	confirmation_dialog = _tmp8_;
	_tmp9_ = confirmation_dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp9_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	_tmp10_ = confirmation_dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp10_, GTK_STOCK_DELETE, (gint) GTK_RESPONSE_ACCEPT);
	_tmp11_ = confirmation_dialog;
	_tmp12_ = files_length;
	_tmp13_ = ngettext ("If you delete an item, it will be permanently lost", "If you delete the items, they will be permanently lost", (gulong) _tmp12_);
	gtk_message_dialog_format_secondary_text (_tmp11_, "%s", _tmp13_);
	_tmp14_ = confirmation_dialog;
	_tmp15_ = gtk_dialog_run ((GtkDialog*) _tmp14_);
	response = _tmp15_;
	_tmp16_ = response;
	if (_tmp16_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		GList* _tmp17_;
		_tmp17_ = files;
		{
			GList* file_collection = NULL;
			GList* file_it = NULL;
			file_collection = _tmp17_;
			for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
				GFile* _tmp18_;
				GFile* file = NULL;
				_tmp18_ = _g_object_ref0 ((GFile*) file_it->data);
				file = _tmp18_;
				{
					GFile* _tmp19_;
					_tmp19_ = file;
					if (_tmp19_ == NULL) {
						_g_object_unref0 (file);
						_g_object_unref0 (confirmation_dialog);
						__g_list_free__g_object_unref0_0 (files);
						return;
					}
					{
						GFile* _tmp20_;
						_tmp20_ = file;
						g_file_delete (_tmp20_, NULL, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch3_g_error;
						}
					}
					goto __finally3;
					__catch3_g_error:
					{
						GError* err = NULL;
						GError* _tmp21_;
						const gchar* _tmp22_;
						gboolean _tmp23_;
						err = _inner_error_;
						_inner_error_ = NULL;
						_tmp21_ = err;
						_tmp22_ = _tmp21_->message;
						g_warning ("cheese-window.vala:274: Unable to delete file: %s", _tmp22_);
						_tmp23_ = skip_all_errors;
						if (!_tmp23_) {
							GFile* _tmp24_;
							gchar* _tmp25_ = NULL;
							gchar* _tmp26_;
							GtkMessageDialog* _tmp27_;
							GtkMessageDialog* _tmp28_;
							GtkMessageDialog* _tmp29_;
							GtkMessageDialog* error_dialog;
							GtkMessageDialog* _tmp30_;
							GtkMessageDialog* _tmp31_;
							GtkMessageDialog* _tmp32_;
							GtkMessageDialog* _tmp33_;
							gint _tmp34_ = 0;
							gint _tmp35_;
							GtkMessageDialog* _tmp37_;
							_tmp24_ = file;
							_tmp25_ = g_file_get_path (_tmp24_);
							_tmp26_ = _tmp25_;
							_tmp27_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "Could not delete %s", _tmp26_);
							_tmp28_ = g_object_ref_sink (_tmp27_);
							_tmp29_ = _tmp28_;
							_g_free0 (_tmp26_);
							error_dialog = _tmp29_;
							_tmp30_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp30_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
							_tmp31_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp31_, "Skip", (gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP);
							_tmp32_ = error_dialog;
							gtk_dialog_add_button ((GtkDialog*) _tmp32_, "Skip all", (gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL);
							_tmp33_ = error_dialog;
							_tmp34_ = gtk_dialog_run ((GtkDialog*) _tmp33_);
							error_response = _tmp34_;
							_tmp35_ = error_response;
							if (_tmp35_ == ((gint) CHEESE_MAIN_WINDOW_DELETE_RESPONSE_SKIP_ALL)) {
								skip_all_errors = TRUE;
							} else {
								gint _tmp36_;
								_tmp36_ = error_response;
								if (_tmp36_ == ((gint) GTK_RESPONSE_CANCEL)) {
									_g_object_unref0 (error_dialog);
									_g_error_free0 (err);
									_g_object_unref0 (file);
									break;
								}
							}
							_tmp37_ = error_dialog;
							gtk_widget_destroy ((GtkWidget*) _tmp37_);
							_g_object_unref0 (error_dialog);
						}
						_g_error_free0 (err);
					}
					__finally3:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (file);
						_g_object_unref0 (confirmation_dialog);
						__g_list_free__g_object_unref0_0 (files);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (file);
				}
			}
		}
	}
	_tmp38_ = confirmation_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp38_);
	_g_object_unref0 (confirmation_dialog);
	__g_list_free__g_object_unref0_0 (files);
}


/**
   * Move the requested image in the thumbview to the trash.
   *
   * A confirmation dialog is shown to the user before moving the file.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_file_move_to_trash (GtkAction* action, CheeseMainWindow* self) {
	GFile* file = NULL;
	CheeseThumbView* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* files;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_images_list (_tmp0_);
	files = _tmp1_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				GList* _tmp6_;
				guint _tmp7_ = 0U;
				GList* _tmp8_;
				gint _tmp9_;
				GList* _tmp10_ = NULL;
				gconstpointer _tmp11_;
				GFile* _tmp12_;
				GFile* _tmp13_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = files;
				_tmp7_ = g_list_length (_tmp6_);
				if (!(((guint) _tmp5_) < _tmp7_)) {
					break;
				}
				_tmp8_ = files;
				_tmp9_ = i;
				_tmp10_ = g_list_nth (_tmp8_, (guint) _tmp9_);
				_tmp11_ = _tmp10_->data;
				_tmp12_ = _g_object_ref0 ((GFile*) _tmp11_);
				_g_object_unref0 (file);
				file = _tmp12_;
				_tmp13_ = file;
				if (_tmp13_ == NULL) {
					__g_list_free__g_object_unref0_0 (files);
					_g_object_unref0 (file);
					return;
				}
				{
					GFile* _tmp14_;
					_tmp14_ = file;
					g_file_trash (_tmp14_, NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch4_g_error;
					}
				}
				goto __finally4;
				__catch4_g_error:
				{
					GError* err = NULL;
					const gchar* _tmp15_ = NULL;
					GFile* _tmp16_;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_;
					GtkMessageDialog* _tmp19_;
					GtkMessageDialog* _tmp20_;
					GtkMessageDialog* _tmp21_;
					GtkMessageDialog* error_dialog;
					GtkMessageDialog* _tmp22_;
					GtkMessageDialog* _tmp23_;
					err = _inner_error_;
					_inner_error_ = NULL;
					_tmp15_ = _ ("Could not move %s to trash");
					_tmp16_ = file;
					_tmp17_ = g_file_get_path (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp15_, _tmp18_);
					_tmp20_ = g_object_ref_sink (_tmp19_);
					_tmp21_ = _tmp20_;
					_g_free0 (_tmp18_);
					error_dialog = _tmp21_;
					_tmp22_ = error_dialog;
					gtk_dialog_run ((GtkDialog*) _tmp22_);
					_tmp23_ = error_dialog;
					gtk_widget_destroy ((GtkWidget*) _tmp23_);
					_g_object_unref0 (error_dialog);
					_g_error_free0 (err);
				}
				__finally4:
				if (_inner_error_ != NULL) {
					__g_list_free__g_object_unref0_0 (files);
					_g_object_unref0 (file);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
	__g_list_free__g_object_unref0_0 (files);
	_g_object_unref0 (file);
}


/**
   * Move all images in the thumbview to the trash.
   *
   * No confirmation dialog is shown to the user before moving the files!
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_file_move_to_trash_all (GtkAction* action, CheeseMainWindow* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		GFile* file_to_trash = NULL;
		GFileInfo* file_info = NULL;
		CheeseFileUtil* _tmp0_;
		const gchar* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		GFile* directory;
		GFile* _tmp3_;
		GFileEnumerator* _tmp4_ = NULL;
		GFileEnumerator* enumerator;
		CheeseFileUtil* _tmp19_;
		const gchar* _tmp20_ = NULL;
		GFile* _tmp21_ = NULL;
		GFile* _tmp22_;
		GFileEnumerator* _tmp23_ = NULL;
		GFileEnumerator* _tmp24_;
		_tmp0_ = self->priv->fileutil;
		_tmp1_ = cheese_fileutil_get_photo_path (_tmp0_);
		_tmp2_ = g_file_new_for_path (_tmp1_);
		directory = _tmp2_;
		_tmp3_ = directory;
		_tmp4_ = g_file_enumerate_children (_tmp3_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error_);
		enumerator = _tmp4_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (directory);
			_g_object_unref0 (file_info);
			_g_object_unref0 (file_to_trash);
			goto __catch5_g_error;
		}
		while (TRUE) {
			GFileEnumerator* _tmp5_;
			GFileInfo* _tmp6_ = NULL;
			GFileInfo* _tmp7_;
			GFileInfo* _tmp8_;
			CheeseFileUtil* _tmp9_;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_;
			GFileInfo* _tmp13_;
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			gchar* _tmp16_;
			GFile* _tmp17_ = NULL;
			GFile* _tmp18_;
			_tmp5_ = enumerator;
			_tmp6_ = g_file_enumerator_next_file (_tmp5_, NULL, &_inner_error_);
			_tmp7_ = _tmp6_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (enumerator);
				_g_object_unref0 (directory);
				_g_object_unref0 (file_info);
				_g_object_unref0 (file_to_trash);
				goto __catch5_g_error;
			}
			_g_object_unref0 (file_info);
			file_info = _tmp7_;
			_tmp8_ = file_info;
			if (!(_tmp8_ != NULL)) {
				break;
			}
			_tmp9_ = self->priv->fileutil;
			_tmp10_ = cheese_fileutil_get_photo_path (_tmp9_);
			_tmp11_ = g_strconcat (_tmp10_, G_DIR_SEPARATOR_S, NULL);
			_tmp12_ = _tmp11_;
			_tmp13_ = file_info;
			_tmp14_ = g_file_info_get_name (_tmp13_);
			_tmp15_ = g_strconcat (_tmp12_, _tmp14_, NULL);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_file_new_for_path (_tmp16_);
			_g_object_unref0 (file_to_trash);
			file_to_trash = _tmp17_;
			_g_free0 (_tmp16_);
			_g_free0 (_tmp12_);
			_tmp18_ = file_to_trash;
			g_file_trash (_tmp18_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (enumerator);
				_g_object_unref0 (directory);
				_g_object_unref0 (file_info);
				_g_object_unref0 (file_to_trash);
				goto __catch5_g_error;
			}
		}
		_tmp19_ = self->priv->fileutil;
		_tmp20_ = cheese_fileutil_get_video_path (_tmp19_);
		_tmp21_ = g_file_new_for_path (_tmp20_);
		_g_object_unref0 (directory);
		directory = _tmp21_;
		_tmp22_ = directory;
		_tmp23_ = g_file_enumerate_children (_tmp22_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error_);
		_tmp24_ = _tmp23_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (enumerator);
			_g_object_unref0 (directory);
			_g_object_unref0 (file_info);
			_g_object_unref0 (file_to_trash);
			goto __catch5_g_error;
		}
		_g_object_unref0 (enumerator);
		enumerator = _tmp24_;
		while (TRUE) {
			GFileEnumerator* _tmp25_;
			GFileInfo* _tmp26_ = NULL;
			GFileInfo* _tmp27_;
			GFileInfo* _tmp28_;
			CheeseFileUtil* _tmp29_;
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_;
			gchar* _tmp32_;
			GFileInfo* _tmp33_;
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_;
			gchar* _tmp36_;
			GFile* _tmp37_ = NULL;
			GFile* _tmp38_;
			_tmp25_ = enumerator;
			_tmp26_ = g_file_enumerator_next_file (_tmp25_, NULL, &_inner_error_);
			_tmp27_ = _tmp26_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (enumerator);
				_g_object_unref0 (directory);
				_g_object_unref0 (file_info);
				_g_object_unref0 (file_to_trash);
				goto __catch5_g_error;
			}
			_g_object_unref0 (file_info);
			file_info = _tmp27_;
			_tmp28_ = file_info;
			if (!(_tmp28_ != NULL)) {
				break;
			}
			_tmp29_ = self->priv->fileutil;
			_tmp30_ = cheese_fileutil_get_photo_path (_tmp29_);
			_tmp31_ = g_strconcat (_tmp30_, G_DIR_SEPARATOR_S, NULL);
			_tmp32_ = _tmp31_;
			_tmp33_ = file_info;
			_tmp34_ = g_file_info_get_name (_tmp33_);
			_tmp35_ = g_strconcat (_tmp32_, _tmp34_, NULL);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_file_new_for_path (_tmp36_);
			_g_object_unref0 (file_to_trash);
			file_to_trash = _tmp37_;
			_g_free0 (_tmp36_);
			_g_free0 (_tmp32_);
			_tmp38_ = file_to_trash;
			g_file_trash (_tmp38_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (enumerator);
				_g_object_unref0 (directory);
				_g_object_unref0 (file_info);
				_g_object_unref0 (file_to_trash);
				goto __catch5_g_error;
			}
		}
		_g_object_unref0 (enumerator);
		_g_object_unref0 (directory);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file_to_trash);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp39_;
		const gchar* _tmp40_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp39_ = e;
		_tmp40_ = _tmp39_->message;
		g_warning ("cheese-window.vala:373: Error: %s\n", _tmp40_);
		_g_error_free0 (e);
		return;
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
   * Share the selected file(s) in the thumbview.
   *
   * A dialog is shown to the user, where the technology for sharing the
   * image or video can be selected.
   *
   * @param action the action that emitted the signal
   */
static void ___lambda3_ (CheeseMainWindow* self, GObject* obj, GAsyncResult* res) {
	GAsyncResult* _tmp0_;
	GdkWindow* _tmp1_ = NULL;
	GdkCursor* _tmp2_;
	GdkCursor* _tmp3_;
	g_return_if_fail (res != NULL);
	_tmp0_ = res;
	cheese_main_window_install_packages_finish (self, _tmp0_);
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp2_ = gdk_cursor_new (GDK_LEFT_PTR);
	_tmp3_ = _tmp2_;
	gdk_window_set_cursor (_tmp1_, _tmp3_);
	_g_object_unref0 (_tmp3_);
}


static void ____lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda3_ (self, source_object, res);
	g_object_unref (self);
}


void cheese_main_window_on_share_files (GtkAction* action, CheeseMainWindow* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean nautilus_sendto_installed;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_find_program_in_path (SENDTO_EXEC);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_free0 (_tmp1_);
	nautilus_sendto_installed = _tmp2_;
	_tmp3_ = nautilus_sendto_installed;
	if (!_tmp3_) {
		cheese_main_window_install_packages (self, ____lambda3__gasync_ready_callback, g_object_ref (self));
	} else {
		CheeseShareableMedia* _tmp4_;
		CheeseThumbView* _tmp5_;
		GList* _tmp6_ = NULL;
		GList* _tmp7_;
		_tmp4_ = self->priv->shareable_media;
		_tmp5_ = self->priv->thumb_view;
		_tmp6_ = cheese_thumb_view_get_selected_images_list (_tmp5_);
		_tmp7_ = _tmp6_;
		cheese_shareable_media_share_files (_tmp4_, _tmp7_);
		__g_list_free__g_object_unref0_0 (_tmp7_);
	}
}


static void cheese_main_window_install_packages_data_free (gpointer _data) {
	CheeseMainWindowInstallPackagesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (CheeseMainWindowInstallPackagesData, _data_);
}


static void cheese_main_window_install_packages (CheeseMainWindow* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	CheeseMainWindowInstallPackagesData* _data_;
	CheeseMainWindow* _tmp0_;
	_data_ = g_slice_new0 (CheeseMainWindowInstallPackagesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, cheese_main_window_install_packages);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, cheese_main_window_install_packages_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	cheese_main_window_install_packages_co (_data_);
}


static void cheese_main_window_install_packages_finish (CheeseMainWindow* self, GAsyncResult* _res_) {
	CheeseMainWindowInstallPackagesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Install nautilus-sendto runtime dependency.
   *
   */
static void cheese_main_window_install_packages_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	CheeseMainWindowInstallPackagesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	cheese_main_window_install_packages_co (_data_);
}


static gboolean cheese_main_window_install_packages_co (CheeseMainWindowInstallPackagesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = gtk_widget_get_window ((GtkWidget*) _data_->self);
	_data_->_tmp1_ = gdk_cursor_new (GDK_WATCH);
	_data_->_tmp2_ = _data_->_tmp1_;
	gdk_window_set_cursor (_data_->_tmp0_, _data_->_tmp2_);
	_g_object_unref0 (_data_->_tmp2_);
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (TYPE_PK_PROXY_PROXY, 0, NULL, cheese_main_window_install_packages_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.PackageKit", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/PackageKit", "g-interface-name", "org.freedesktop.PackageKit.Modify", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->pk_proxy = (PkProxy*) _data_->_tmp3_;
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch6_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp4_ = g_strdup ("nautilus-sendto");
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = g_new0 (gchar*, 1 + 1);
		_data_->_tmp5_[0] = _data_->_tmp4_;
		_data_->packages = _data_->_tmp5_;
		_data_->packages_length1 = 1;
		_data_->_packages_size_ = _data_->packages_length1;
		_data_->_tmp6_ = _data_->pk_proxy;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = gtk_widget_get_window ((GtkWidget*) _data_->self);
		_data_->_tmp8_ = 0;
		_data_->_tmp8_ = gdk_x11_window_get_xid (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->packages;
		_data_->_tmp9__length1 = _data_->packages_length1;
		_data_->_state_ = 2;
		pk_proxy_install_package_names (_data_->_tmp6_, (guint) _data_->_tmp8_, _data_->_tmp9_, _data_->_tmp9__length1, "", cheese_main_window_install_packages_ready, _data_);
		return FALSE;
		_state_2:
		pk_proxy_install_package_names_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			_data_->packages = (_vala_array_free (_data_->packages, _data_->packages_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->pk_proxy);
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch6_g_io_error;
			}
			_data_->packages = (_vala_array_free (_data_->packages, _data_->packages_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->pk_proxy);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->packages = (_vala_array_free (_data_->packages, _data_->packages_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_data_->pk_proxy);
	}
	goto __finally6;
	__catch6_g_io_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp10_ = _data_->_error_;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		g_critical ("cheese-window.vala:419: D-Bus error: %s\n", _data_->_tmp11_);
		_g_error_free0 (_data_->_error_);
	}
	__finally6:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Save the selected file in the thumbview to an alternate storage location.
   *
   * A file chooser dialog is shown to the user, asking where the file should
   * be saved and the filename.
   *
   * @param action the action that emitted the signal.
   */
void cheese_main_window_on_file_save_as (GtkAction* action, CheeseMainWindow* self) {
	gchar* filename = NULL;
	gchar* basename = NULL;
	GtkFileChooserDialog* save_as_dialog = NULL;
	gint response = 0;
	CheeseThumbView* _tmp0_;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	GtkFileChooserDialog* _tmp4_;
	GtkFileChooserDialog* _tmp5_;
	GtkFileChooserDialog* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_;
	const gchar* _tmp10_;
	GtkFileChooserDialog* _tmp11_;
	const gchar* _tmp12_ = NULL;
	GtkFileChooserDialog* _tmp13_;
	gint _tmp14_ = 0;
	GtkFileChooserDialog* _tmp15_;
	gint _tmp16_;
	GtkFileChooserDialog* _tmp31_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = cheese_thumb_view_get_selected_image (_tmp0_);
	_g_free0 (filename);
	filename = _tmp1_;
	_tmp2_ = filename;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (save_as_dialog);
		_g_free0 (basename);
		_g_free0 (filename);
		return;
	}
	_tmp3_ = _ ("Save File");
	_tmp4_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp3_, (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_g_object_unref0 (save_as_dialog);
	save_as_dialog = _tmp5_;
	_tmp6_ = save_as_dialog;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp6_, TRUE);
	_tmp7_ = filename;
	_tmp8_ = g_filename_display_basename (_tmp7_);
	_g_free0 (basename);
	basename = _tmp8_;
	_tmp9_ = save_as_dialog;
	_tmp10_ = basename;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp9_, _tmp10_);
	_tmp11_ = save_as_dialog;
	_tmp12_ = g_get_home_dir ();
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp11_, _tmp12_);
	_tmp13_ = save_as_dialog;
	_tmp14_ = gtk_dialog_run ((GtkDialog*) _tmp13_);
	response = _tmp14_;
	_tmp15_ = save_as_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp15_);
	_tmp16_ = response;
	if (_tmp16_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		gchar* target_filename = NULL;
		GtkFileChooserDialog* _tmp17_;
		gchar* _tmp18_ = NULL;
		const gchar* _tmp19_;
		GFile* _tmp20_ = NULL;
		GFile* src;
		const gchar* _tmp21_;
		GFile* _tmp22_ = NULL;
		GFile* dest;
		_tmp17_ = save_as_dialog;
		_tmp18_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp17_);
		_g_free0 (target_filename);
		target_filename = _tmp18_;
		_tmp19_ = filename;
		_tmp20_ = g_file_new_for_path (_tmp19_);
		src = _tmp20_;
		_tmp21_ = target_filename;
		_tmp22_ = g_file_new_for_path (_tmp21_);
		dest = _tmp22_;
		{
			GFile* _tmp23_;
			GFile* _tmp24_;
			_tmp23_ = src;
			_tmp24_ = dest;
			g_file_copy (_tmp23_, _tmp24_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch7_g_error;
			}
		}
		goto __finally7;
		__catch7_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp25_ = NULL;
			const gchar* _tmp26_;
			GtkMessageDialog* _tmp27_;
			GtkMessageDialog* _tmp28_;
			GtkMessageDialog* error_dialog;
			GtkMessageDialog* _tmp29_;
			GtkMessageDialog* _tmp30_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp25_ = _ ("Could not save %s");
			_tmp26_ = target_filename;
			_tmp27_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp25_, _tmp26_);
			_tmp28_ = g_object_ref_sink (_tmp27_);
			error_dialog = _tmp28_;
			_tmp29_ = error_dialog;
			gtk_dialog_run ((GtkDialog*) _tmp29_);
			_tmp30_ = error_dialog;
			gtk_widget_destroy ((GtkWidget*) _tmp30_);
			_g_object_unref0 (error_dialog);
			_g_error_free0 (err);
		}
		__finally7:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dest);
			_g_object_unref0 (src);
			_g_free0 (target_filename);
			_g_object_unref0 (save_as_dialog);
			_g_free0 (basename);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (dest);
		_g_object_unref0 (src);
		_g_free0 (target_filename);
	}
	_tmp31_ = save_as_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp31_);
	_g_object_unref0 (save_as_dialog);
	_g_free0 (basename);
	_g_free0 (filename);
}


/**
   * Show the Cheese help contents.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_help_contents (GtkAction* action, CheeseMainWindow* self) {
	GdkScreen* screen = NULL;
	GdkScreen* _tmp0_ = NULL;
	GdkScreen* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (screen);
	screen = _tmp1_;
	{
		guint32 _tmp2_ = 0U;
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (screen, "help:cheese", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_warning ("cheese-window.vala:500: Error: %s\n", _tmp4_);
		_g_error_free0 (err);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (screen);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (screen);
}


/**
   * Show the about dialog.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_help_about (GtkAction* action, CheeseMainWindow* self) {
	GtkAboutDialog* about_dialog = NULL;
	GtkBuilder* _tmp0_;
	GObject* _tmp1_ = NULL;
	GtkAboutDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->gtk_builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "aboutdialog");
	_tmp2_ = _g_object_ref0 (GTK_IS_ABOUT_DIALOG (_tmp1_) ? ((GtkAboutDialog*) _tmp1_) : NULL);
	_g_object_unref0 (about_dialog);
	about_dialog = _tmp2_;
	gtk_window_set_transient_for ((GtkWindow*) about_dialog, (GtkWindow*) self);
	gtk_window_set_modal ((GtkWindow*) about_dialog, TRUE);
	gtk_about_dialog_set_version (about_dialog, PACKAGE_VERSION);
	gtk_dialog_run ((GtkDialog*) about_dialog);
	gtk_widget_hide ((GtkWidget*) about_dialog);
	_g_object_unref0 (about_dialog);
}


/**
   * Toggle wide mode and save the preference to GSettings.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_layout_wide_mode (GtkToggleAction* action, CheeseMainWindow* self) {
	gboolean _tmp0_;
	GtkToggleAction* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->is_command_line_startup;
	if (!_tmp0_) {
		GSettings* _tmp1_;
		GtkToggleAction* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = self->priv->settings;
		_tmp2_ = action;
		_tmp3_ = gtk_toggle_action_get_active (_tmp2_);
		_tmp4_ = _tmp3_;
		g_settings_set_boolean (_tmp1_, "wide-mode", _tmp4_);
	}
	_tmp5_ = action;
	_tmp6_ = gtk_toggle_action_get_active (_tmp5_);
	_tmp7_ = _tmp6_;
	cheese_main_window_set_wide_mode (self, _tmp7_);
}


/**
   * Toggle fullscreen mode and save the preference to GSettings.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_layout_fullscreen (GtkToggleAction* action, CheeseMainWindow* self) {
	gboolean _tmp0_;
	GtkToggleAction* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->is_command_line_startup;
	if (!_tmp0_) {
		GSettings* _tmp1_;
		GtkToggleAction* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = self->priv->settings;
		_tmp2_ = action;
		_tmp3_ = gtk_toggle_action_get_active (_tmp2_);
		_tmp4_ = _tmp3_;
		g_settings_set_boolean (_tmp1_, "fullscreen", _tmp4_);
	}
	_tmp5_ = action;
	_tmp6_ = gtk_toggle_action_get_active (_tmp5_);
	_tmp7_ = _tmp6_;
	cheese_main_window_set_fullscreen_mode (self, _tmp7_);
}


/**
   * Change the media capture mode (photo, video or burst).
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_mode_change (GtkRadioAction* action, CheeseMainWindow* self) {
	GtkRadioAction* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	g_object_get (_tmp0_, "value", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	cheese_main_window_set_mode (self, (CheeseMediaMode) _tmp2_);
}


/**
   * Make the media capture mode actions sensitive.
   */
static void cheese_main_window_enable_mode_change (CheeseMainWindow* self) {
	GtkAction* _tmp0_;
	GtkAction* _tmp1_;
	GtkAction* _tmp2_;
	GtkToggleAction* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->photo_mode_action;
	gtk_action_set_sensitive (_tmp0_, TRUE);
	_tmp1_ = self->priv->video_mode_action;
	gtk_action_set_sensitive (_tmp1_, TRUE);
	_tmp2_ = self->priv->burst_mode_action;
	gtk_action_set_sensitive (_tmp2_, TRUE);
	_tmp3_ = self->priv->effects_toggle_action;
	gtk_action_set_sensitive ((GtkAction*) _tmp3_, TRUE);
}


/**
   * Make the media capture mode actions insensitive.
   */
static void cheese_main_window_disable_mode_change (CheeseMainWindow* self) {
	GtkAction* _tmp0_;
	GtkAction* _tmp1_;
	GtkAction* _tmp2_;
	GtkToggleAction* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->photo_mode_action;
	gtk_action_set_sensitive (_tmp0_, FALSE);
	_tmp1_ = self->priv->video_mode_action;
	gtk_action_set_sensitive (_tmp1_, FALSE);
	_tmp2_ = self->priv->burst_mode_action;
	gtk_action_set_sensitive (_tmp2_, FALSE);
	_tmp3_ = self->priv->effects_toggle_action;
	gtk_action_set_sensitive ((GtkAction*) _tmp3_, FALSE);
}


/**
   * Set the capture resolution, based on the current capture mode.
   *
   * @param mode the current capture mode (photo, video or burst)
   */
static void cheese_main_window_set_resolution (CheeseMainWindow* self, CheeseMediaMode mode) {
	CheeseCamera* _tmp0_;
	CheeseCamera* _tmp1_;
	GList* _tmp2_ = NULL;
	GList* formats;
	GList* _tmp3_;
	CheeseVideoFormat* format = NULL;
	gint width;
	gint height;
	CheeseMediaMode _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->camera;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->camera;
	_tmp2_ = cheese_camera_get_video_formats (_tmp1_);
	formats = _tmp2_;
	_tmp3_ = formats;
	if (_tmp3_ == NULL) {
		return;
	}
	width = 0;
	height = 0;
	_tmp4_ = mode;
	switch (_tmp4_) {
		case CHEESE_MEDIA_MODE_PHOTO:
		case CHEESE_MEDIA_MODE_BURST:
		{
			GSettings* _tmp5_;
			gint _tmp6_ = 0;
			GSettings* _tmp7_;
			gint _tmp8_ = 0;
			_tmp5_ = self->priv->settings;
			_tmp6_ = g_settings_get_int (_tmp5_, "photo-x-resolution");
			width = _tmp6_;
			_tmp7_ = self->priv->settings;
			_tmp8_ = g_settings_get_int (_tmp7_, "photo-y-resolution");
			height = _tmp8_;
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			GSettings* _tmp9_;
			gint _tmp10_ = 0;
			GSettings* _tmp11_;
			gint _tmp12_ = 0;
			_tmp9_ = self->priv->settings;
			_tmp10_ = g_settings_get_int (_tmp9_, "video-x-resolution");
			width = _tmp10_;
			_tmp11_ = self->priv->settings;
			_tmp12_ = g_settings_get_int (_tmp11_, "video-y-resolution");
			height = _tmp12_;
			break;
		}
		default:
		break;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp13_;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_;
				gint _tmp16_;
				GList* _tmp17_;
				guint _tmp18_ = 0U;
				GList* _tmp19_;
				gint _tmp20_;
				GList* _tmp21_ = NULL;
				gconstpointer _tmp22_;
				gboolean _tmp23_ = FALSE;
				gint _tmp24_;
				CheeseVideoFormat* _tmp25_;
				gint _tmp26_;
				gboolean _tmp30_;
				_tmp14_ = _tmp13_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp16_ = i;
				_tmp17_ = formats;
				_tmp18_ = g_list_length (_tmp17_);
				if (!(((guint) _tmp16_) < _tmp18_)) {
					break;
				}
				_tmp19_ = formats;
				_tmp20_ = i;
				_tmp21_ = g_list_nth (_tmp19_, (guint) _tmp20_);
				_tmp22_ = _tmp21_->data;
				format = (CheeseVideoFormat*) _tmp22_;
				_tmp24_ = width;
				_tmp25_ = format;
				_tmp26_ = _tmp25_->width;
				if (_tmp24_ == _tmp26_) {
					gint _tmp27_;
					CheeseVideoFormat* _tmp28_;
					gint _tmp29_;
					_tmp27_ = height;
					_tmp28_ = format;
					_tmp29_ = _tmp28_->height;
					_tmp23_ = _tmp27_ == _tmp29_;
				} else {
					_tmp23_ = FALSE;
				}
				_tmp30_ = _tmp23_;
				if (_tmp30_) {
					CheeseCamera* _tmp31_;
					CheeseVideoFormat* _tmp32_;
					_tmp31_ = self->priv->camera;
					_tmp32_ = format;
					cheese_camera_set_video_format (_tmp31_, _tmp32_);
					break;
				}
			}
		}
	}
}


/**
   * Set the current media capture mode, and update the UI sensitivities.
   *
   * @param mode the new capture mode to set
   */
static void cheese_main_window_set_mode (CheeseMainWindow* self, CheeseMediaMode mode) {
	CheeseMediaMode _tmp0_;
	CheeseMediaMode _tmp1_;
	CheesePreferencesDialog* _tmp2_;
	CheeseMediaMode _tmp5_;
	GtkLabel* _tmp21_;
	GtkButton* _tmp22_;
	GtkAction* _tmp23_;
	GtkAction* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GtkButton* _tmp31_;
	GtkButton* _tmp32_;
	GtkAction* _tmp33_;
	GtkAction* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	g_return_if_fail (self != NULL);
	_tmp0_ = mode;
	self->priv->current_mode = _tmp0_;
	_tmp1_ = self->priv->current_mode;
	cheese_main_window_set_resolution (self, _tmp1_);
	_tmp2_ = self->priv->preferences_dialog;
	if (_tmp2_ != NULL) {
		CheesePreferencesDialog* _tmp3_;
		CheeseMediaMode _tmp4_;
		_tmp3_ = self->priv->preferences_dialog;
		_tmp4_ = self->priv->current_mode;
		cheese_preferences_dialog_set_current_mode (_tmp3_, _tmp4_);
	}
	_tmp5_ = self->priv->current_mode;
	switch (_tmp5_) {
		case CHEESE_MEDIA_MODE_PHOTO:
		{
			GtkAction* _tmp6_;
			GtkAction* _tmp7_;
			GtkAction* _tmp8_;
			GtkButton* _tmp9_;
			GtkAction* _tmp10_;
			_tmp6_ = self->priv->take_photo_action;
			gtk_action_set_sensitive (_tmp6_, TRUE);
			_tmp7_ = self->priv->take_video_action;
			gtk_action_set_sensitive (_tmp7_, FALSE);
			_tmp8_ = self->priv->take_burst_action;
			gtk_action_set_sensitive (_tmp8_, FALSE);
			_tmp9_ = self->priv->take_action_button;
			_tmp10_ = self->priv->take_photo_action;
			gtk_activatable_set_related_action ((GtkActivatable*) _tmp9_, _tmp10_);
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			GtkAction* _tmp11_;
			GtkAction* _tmp12_;
			GtkAction* _tmp13_;
			GtkButton* _tmp14_;
			GtkAction* _tmp15_;
			_tmp11_ = self->priv->take_photo_action;
			gtk_action_set_sensitive (_tmp11_, FALSE);
			_tmp12_ = self->priv->take_video_action;
			gtk_action_set_sensitive (_tmp12_, TRUE);
			_tmp13_ = self->priv->take_burst_action;
			gtk_action_set_sensitive (_tmp13_, FALSE);
			_tmp14_ = self->priv->take_action_button;
			_tmp15_ = self->priv->take_video_action;
			gtk_activatable_set_related_action ((GtkActivatable*) _tmp14_, _tmp15_);
			break;
		}
		case CHEESE_MEDIA_MODE_BURST:
		{
			GtkAction* _tmp16_;
			GtkAction* _tmp17_;
			GtkAction* _tmp18_;
			GtkButton* _tmp19_;
			GtkAction* _tmp20_;
			_tmp16_ = self->priv->take_photo_action;
			gtk_action_set_sensitive (_tmp16_, FALSE);
			_tmp17_ = self->priv->take_video_action;
			gtk_action_set_sensitive (_tmp17_, FALSE);
			_tmp18_ = self->priv->take_burst_action;
			gtk_action_set_sensitive (_tmp18_, TRUE);
			_tmp19_ = self->priv->take_action_button;
			_tmp20_ = self->priv->take_burst_action;
			gtk_activatable_set_related_action ((GtkActivatable*) _tmp19_, _tmp20_);
			break;
		}
		default:
		break;
	}
	_tmp21_ = self->priv->take_action_button_label;
	_tmp22_ = self->priv->take_action_button;
	_tmp23_ = gtk_activatable_get_related_action ((GtkActivatable*) _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = gtk_action_get_label (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat ("<b>", _tmp26_, NULL);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat (_tmp28_, "</b>", NULL);
	_tmp30_ = _tmp29_;
	gtk_label_set_label (_tmp21_, _tmp30_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
	_tmp31_ = self->priv->take_action_button;
	_tmp32_ = self->priv->take_action_button;
	_tmp33_ = gtk_activatable_get_related_action ((GtkActivatable*) _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = gtk_action_get_tooltip (_tmp34_);
	_tmp36_ = _tmp35_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp31_, _tmp36_);
}


/**
   * Clear the fullscreen activity timeout.
   */
static void cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self) {
	GSource* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->fullscreen_timeout;
	if (_tmp0_ != NULL) {
		GSource* _tmp1_;
		_tmp1_ = self->priv->fullscreen_timeout;
		g_source_destroy (_tmp1_);
		_g_source_unref0 (self->priv->fullscreen_timeout);
		self->priv->fullscreen_timeout = NULL;
	}
}


/**
   * Set the fullscreen timeout, for hiding the UI if there is no mouse
   * movement.
   */
static gboolean __lambda4_ (CheeseMainWindow* self) {
	gboolean result = FALSE;
	GtkBox* _tmp0_;
	_tmp0_ = self->priv->buttons_area;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	cheese_main_window_clear_fullscreen_timeout (self);
	result = TRUE;
	return result;
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ (self);
	return result;
}


static void cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self) {
	GSource* _tmp0_;
	GSource* _tmp1_;
	GSource* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_timeout_source_new ((guint) FULLSCREEN_TIMEOUT_INTERVAL);
	_g_source_unref0 (self->priv->fullscreen_timeout);
	self->priv->fullscreen_timeout = _tmp0_;
	_tmp1_ = self->priv->fullscreen_timeout;
	g_source_attach (_tmp1_, NULL);
	_tmp2_ = self->priv->fullscreen_timeout;
	g_source_set_callback (_tmp2_, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
}


/**
   * Show the UI in fullscreen if there is any mouse activity.
   *
   * Start a new timeout at the end of every mouse pointer movement. All
   * timeouts will be cancelled, except one created during the last movement
   * event. Show() is called even if the button is not hidden.
   *
   * @param viewport the widget to check for mouse activity on
   * @param e the (unused) event
   */
static gboolean cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self, GtkWidget* viewport, GdkEventMotion* e) {
	gboolean result = FALSE;
	GtkBox* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (viewport != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	cheese_main_window_clear_fullscreen_timeout (self);
	_tmp0_ = self->priv->buttons_area;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	cheese_main_window_set_fullscreen_timeout (self);
	result = TRUE;
	return result;
}


/**
   * Enable or disable fullscreen mode to the requested state.
   *
   * @param fullscreen_mode whether to enable or disable fullscreen mode
   */
static gboolean _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_fullscreen_motion_notify_callback (self, _sender, event);
	return result;
}


static void cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self, gboolean fullscreen_mode) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = fullscreen_mode;
	self->priv->is_fullscreen = _tmp0_;
	_tmp1_ = fullscreen_mode;
	if (_tmp1_) {
		gboolean _tmp2_;
		GtkMenuBar* _tmp5_;
		GtkBox* _tmp6_;
		GtkBox* _tmp7_;
		GtkButton** _tmp8_;
		gint _tmp8__length1;
		GtkClutterEmbed* _tmp13_;
		_tmp2_ = self->priv->is_wide_mode;
		if (_tmp2_) {
			GtkAlignment* _tmp3_;
			_tmp3_ = self->priv->thumbnails_right;
			gtk_widget_hide ((GtkWidget*) _tmp3_);
		} else {
			GtkAlignment* _tmp4_;
			_tmp4_ = self->priv->thumbnails_bottom;
			gtk_widget_hide ((GtkWidget*) _tmp4_);
		}
		_tmp5_ = self->priv->menubar;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
		_tmp6_ = self->priv->leave_fullscreen_button_container;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp6_, FALSE);
		_tmp7_ = self->priv->leave_fullscreen_button_container;
		gtk_widget_show_all ((GtkWidget*) _tmp7_);
		_tmp8_ = self->priv->buttons;
		_tmp8__length1 = self->priv->buttons_length1;
		{
			GtkButton** b_collection = NULL;
			gint b_collection_length1 = 0;
			gint _b_collection_size_ = 0;
			gint b_it = 0;
			b_collection = _tmp8_;
			b_collection_length1 = _tmp8__length1;
			for (b_it = 0; b_it < _tmp8__length1; b_it = b_it + 1) {
				GtkButton* _tmp9_;
				GtkButton* b = NULL;
				_tmp9_ = _g_object_ref0 (b_collection[b_it]);
				b = _tmp9_;
				{
					GtkButton* _tmp10_;
					const gchar* _tmp11_ = NULL;
					_tmp10_ = b;
					_tmp11_ = gtk_buildable_get_name ((GtkBuildable*) _tmp10_);
					if (g_strcmp0 (_tmp11_, "take_action_button") != 0) {
						GtkButton* _tmp12_;
						_tmp12_ = b;
						gtk_button_set_relief (_tmp12_, GTK_RELIEF_NONE);
					}
					_g_object_unref0 (b);
				}
			}
		}
		gtk_window_fullscreen ((GtkWindow*) self);
		_tmp13_ = self->priv->viewport_widget;
		g_signal_connect_object ((GtkWidget*) _tmp13_, "motion-notify-event", (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self, 0);
		cheese_main_window_set_fullscreen_timeout (self);
	} else {
		gboolean _tmp14_;
		GtkMenuBar* _tmp17_;
		GtkBox* _tmp18_;
		GtkButton** _tmp19_;
		gint _tmp19__length1;
		GtkBox* _tmp24_;
		GtkClutterEmbed* _tmp25_;
		guint _tmp26_ = 0U;
		_tmp14_ = self->priv->is_wide_mode;
		if (_tmp14_) {
			GtkAlignment* _tmp15_;
			_tmp15_ = self->priv->thumbnails_right;
			gtk_widget_show_all ((GtkWidget*) _tmp15_);
		} else {
			GtkAlignment* _tmp16_;
			_tmp16_ = self->priv->thumbnails_bottom;
			gtk_widget_show_all ((GtkWidget*) _tmp16_);
		}
		_tmp17_ = self->priv->menubar;
		gtk_widget_show_all ((GtkWidget*) _tmp17_);
		_tmp18_ = self->priv->leave_fullscreen_button_container;
		gtk_widget_hide ((GtkWidget*) _tmp18_);
		_tmp19_ = self->priv->buttons;
		_tmp19__length1 = self->priv->buttons_length1;
		{
			GtkButton** b_collection = NULL;
			gint b_collection_length1 = 0;
			gint _b_collection_size_ = 0;
			gint b_it = 0;
			b_collection = _tmp19_;
			b_collection_length1 = _tmp19__length1;
			for (b_it = 0; b_it < _tmp19__length1; b_it = b_it + 1) {
				GtkButton* _tmp20_;
				GtkButton* b = NULL;
				_tmp20_ = _g_object_ref0 (b_collection[b_it]);
				b = _tmp20_;
				{
					GtkButton* _tmp21_;
					const gchar* _tmp22_ = NULL;
					_tmp21_ = b;
					_tmp22_ = gtk_buildable_get_name ((GtkBuildable*) _tmp21_);
					if (g_strcmp0 (_tmp22_, "take_action_button") != 0) {
						GtkButton* _tmp23_;
						_tmp23_ = b;
						gtk_button_set_relief (_tmp23_, GTK_RELIEF_NORMAL);
					}
					_g_object_unref0 (b);
				}
			}
		}
		cheese_main_window_clear_fullscreen_timeout (self);
		_tmp24_ = self->priv->buttons_area;
		gtk_widget_show ((GtkWidget*) _tmp24_);
		_tmp25_ = self->priv->viewport_widget;
		g_signal_parse_name ("motion-notify-event", GTK_TYPE_WIDGET, &_tmp26_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp25_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp26_, 0, NULL, (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self);
		gtk_window_unfullscreen ((GtkWindow*) self);
	}
}


/**
   * Enable or disable wide mode to the requested state.
   *
   * @param wide_mode whether to enable or disable wide mode
   */
static void cheese_main_window_set_wide_mode (CheeseMainWindow* self, gboolean wide_mode) {
	gboolean _tmp0_;
	GtkAllocation alloc = {0};
	GtkClutterEmbed* _tmp1_;
	GtkAllocation _tmp2_ = {0};
	GtkClutterEmbed* _tmp3_;
	GtkAllocation _tmp4_;
	gint _tmp5_;
	GtkAllocation _tmp6_;
	gint _tmp7_;
	gboolean _tmp8_;
	GtkRequisition req = {0};
	GtkRequisition _tmp31_ = {0};
	GtkRequisition _tmp32_ = {0};
	GtkRequisition _tmp33_;
	gint _tmp34_;
	GtkRequisition _tmp35_;
	gint _tmp36_;
	GtkClutterEmbed* _tmp37_;
	g_return_if_fail (self != NULL);
	_tmp0_ = wide_mode;
	self->priv->is_wide_mode = _tmp0_;
	_tmp1_ = self->priv->viewport_widget;
	gtk_widget_get_allocation ((GtkWidget*) _tmp1_, &_tmp2_);
	alloc = _tmp2_;
	_tmp3_ = self->priv->viewport_widget;
	_tmp4_ = alloc;
	_tmp5_ = _tmp4_.width;
	_tmp6_ = alloc;
	_tmp7_ = _tmp6_.height;
	gtk_widget_set_size_request ((GtkWidget*) _tmp3_, _tmp5_, _tmp7_);
	_tmp8_ = self->priv->is_wide_mode;
	if (_tmp8_) {
		CheeseThumbView* _tmp9_;
		EogThumbNav* _tmp10_;
		GtkAlignment* _tmp11_;
		GtkWidget* _tmp12_ = NULL;
		GtkAlignment* _tmp15_;
		EogThumbNav* _tmp16_;
		GtkAlignment* _tmp17_;
		GtkAlignment* _tmp18_;
		GtkAlignment* _tmp19_;
		_tmp9_ = self->priv->thumb_view;
		gtk_icon_view_set_columns ((GtkIconView*) _tmp9_, 1);
		_tmp10_ = self->priv->thumb_nav;
		eog_thumb_nav_set_vertical (_tmp10_, TRUE);
		_tmp11_ = self->priv->thumbnails_bottom;
		_tmp12_ = gtk_bin_get_child ((GtkBin*) _tmp11_);
		if (_tmp12_ != NULL) {
			GtkAlignment* _tmp13_;
			EogThumbNav* _tmp14_;
			_tmp13_ = self->priv->thumbnails_bottom;
			_tmp14_ = self->priv->thumb_nav;
			gtk_container_remove ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
		}
		_tmp15_ = self->priv->thumbnails_right;
		_tmp16_ = self->priv->thumb_nav;
		gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
		_tmp17_ = self->priv->thumbnails_right;
		gtk_widget_show_all ((GtkWidget*) _tmp17_);
		_tmp18_ = self->priv->thumbnails_right;
		gtk_container_resize_children ((GtkContainer*) _tmp18_);
		_tmp19_ = self->priv->thumbnails_bottom;
		gtk_widget_hide ((GtkWidget*) _tmp19_);
	} else {
		CheeseThumbView* _tmp20_;
		EogThumbNav* _tmp21_;
		GtkAlignment* _tmp22_;
		GtkWidget* _tmp23_ = NULL;
		GtkAlignment* _tmp26_;
		EogThumbNav* _tmp27_;
		GtkAlignment* _tmp28_;
		GtkAlignment* _tmp29_;
		GtkAlignment* _tmp30_;
		_tmp20_ = self->priv->thumb_view;
		gtk_icon_view_set_columns ((GtkIconView*) _tmp20_, 5000);
		_tmp21_ = self->priv->thumb_nav;
		eog_thumb_nav_set_vertical (_tmp21_, FALSE);
		_tmp22_ = self->priv->thumbnails_right;
		_tmp23_ = gtk_bin_get_child ((GtkBin*) _tmp22_);
		if (_tmp23_ != NULL) {
			GtkAlignment* _tmp24_;
			EogThumbNav* _tmp25_;
			_tmp24_ = self->priv->thumbnails_right;
			_tmp25_ = self->priv->thumb_nav;
			gtk_container_remove ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
		}
		_tmp26_ = self->priv->thumbnails_bottom;
		_tmp27_ = self->priv->thumb_nav;
		gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
		_tmp28_ = self->priv->thumbnails_bottom;
		gtk_widget_show_all ((GtkWidget*) _tmp28_);
		_tmp29_ = self->priv->thumbnails_bottom;
		gtk_container_resize_children ((GtkContainer*) _tmp29_);
		_tmp30_ = self->priv->thumbnails_right;
		gtk_widget_hide ((GtkWidget*) _tmp30_);
	}
	gtk_widget_get_preferred_size ((GtkWidget*) self, &_tmp31_, &_tmp32_);
	req = _tmp31_;
	req = _tmp32_;
	_tmp33_ = req;
	_tmp34_ = _tmp33_.width;
	_tmp35_ = req;
	_tmp36_ = _tmp35_.height;
	gtk_window_resize ((GtkWindow*) self, _tmp34_, _tmp36_);
	_tmp37_ = self->priv->viewport_widget;
	gtk_widget_set_size_request ((GtkWidget*) _tmp37_, -1, -1);
}


/**
   * Make sure that the layout manager manages the entire stage.
   *
   * @param actor unused
   * @param box unused
   * @param flags unused
   */
void cheese_main_window_on_stage_resize (CheeseMainWindow* self, ClutterActor* actor, ClutterActorBox* box, ClutterAllocationFlags flags) {
	ClutterBox* _tmp0_;
	ClutterStage* _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	ClutterStage* _tmp4_;
	gfloat _tmp5_;
	gfloat _tmp6_;
	ClutterRectangle* _tmp7_;
	ClutterStage* _tmp8_;
	gfloat _tmp9_;
	gfloat _tmp10_;
	ClutterStage* _tmp11_;
	gfloat _tmp12_;
	gfloat _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	g_return_if_fail (box != NULL);
	_tmp0_ = self->priv->viewport_layout;
	_tmp1_ = self->priv->viewport;
	_tmp2_ = clutter_actor_get_width ((ClutterActor*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->viewport;
	_tmp5_ = clutter_actor_get_height ((ClutterActor*) _tmp4_);
	_tmp6_ = _tmp5_;
	clutter_actor_set_size ((ClutterActor*) _tmp0_, _tmp3_, _tmp6_);
	_tmp7_ = self->priv->background_layer;
	_tmp8_ = self->priv->viewport;
	_tmp9_ = clutter_actor_get_width ((ClutterActor*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->viewport;
	_tmp12_ = clutter_actor_get_height ((ClutterActor*) _tmp11_);
	_tmp13_ = _tmp12_;
	clutter_actor_set_size ((ClutterActor*) _tmp7_, _tmp10_, _tmp13_);
}


/**
   * Toggle whether the countdown is active.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_countdown_toggle (GtkToggleAction* action, CheeseMainWindow* self) {
	GSettings* _tmp0_;
	GtkToggleAction* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = action;
	_tmp2_ = gtk_toggle_action_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_boolean (_tmp0_, "countdown", _tmp3_);
}


/**
   * The method to call when the countdown is finished.
   */
static void cheese_main_window_finish_countdown_callback (CheeseMainWindow* self) {
	gboolean _tmp0_;
	CheeseMediaMode _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->action_cancelled;
	if (_tmp0_ == FALSE) {
		CheeseFileUtil* _tmp1_;
		CheeseMediaMode _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* file_name;
		GSettings* _tmp5_;
		gboolean _tmp6_ = FALSE;
		GtkGrid* _tmp8_;
		const gchar* _tmp9_ = NULL;
		CheeseCamera* _tmp10_;
		const gchar* _tmp11_;
		_tmp1_ = self->priv->fileutil;
		_tmp2_ = self->priv->current_mode;
		_tmp3_ = cheese_fileutil_get_new_media_filename (_tmp1_, _tmp2_);
		_tmp4_ = g_strdup (_tmp3_);
		file_name = _tmp4_;
		_tmp5_ = self->priv->settings;
		_tmp6_ = g_settings_get_boolean (_tmp5_, "flash");
		if (_tmp6_) {
			CheeseFlash* _tmp7_;
			_tmp7_ = self->priv->flash;
			cheese_flash_fire (_tmp7_);
		}
		_tmp8_ = self->priv->main_vbox;
		_tmp9_ = _ ("Shutter sound");
		ca_gtk_play_for_widget ((GtkWidget*) _tmp8_, (guint32) 0, CA_PROP_EVENT_ID, "camera-shutter", CA_PROP_MEDIA_ROLE, "event", CA_PROP_EVENT_DESCRIPTION, _tmp9_, NULL, NULL);
		_tmp10_ = self->priv->camera;
		_tmp11_ = file_name;
		cheese_camera_take_photo (_tmp10_, _tmp11_);
		_g_free0 (file_name);
	}
	_tmp12_ = self->priv->current_mode;
	if (_tmp12_ == CHEESE_MEDIA_MODE_PHOTO) {
		GtkAction* _tmp13_;
		_tmp13_ = self->priv->take_photo_action;
		gtk_action_set_sensitive (_tmp13_, TRUE);
		cheese_main_window_enable_mode_change (self);
	}
}


/**
   * Start to take a photo, starting a countdown if it is enabled.
   */
static void _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self) {
	cheese_main_window_finish_countdown_callback (self);
}


void cheese_main_window_take_photo (CheeseMainWindow* self) {
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "countdown");
	if (_tmp1_) {
		CheeseMediaMode _tmp2_;
		ClutterText* _tmp4_;
		CheeseCountdown* _tmp5_;
		CheeseCountdown* _tmp6_;
		_tmp2_ = self->priv->current_mode;
		if (_tmp2_ == CHEESE_MEDIA_MODE_PHOTO) {
			GtkAction* _tmp3_;
			_tmp3_ = self->priv->take_photo_action;
			gtk_action_set_sensitive (_tmp3_, FALSE);
			cheese_main_window_disable_mode_change (self);
		}
		_tmp4_ = self->priv->countdown_layer;
		_tmp5_ = cheese_countdown_new (_tmp4_);
		_g_object_unref0 (self->priv->current_countdown);
		self->priv->current_countdown = _tmp5_;
		_tmp6_ = self->priv->current_countdown;
		cheese_countdown_start (_tmp6_, _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback, self);
	} else {
		cheese_main_window_finish_countdown_callback (self);
	}
}


/**
   * Take a photo during burst mode, and increment the burst count.
   *
   * @return true if there are more photos to be taken in the current burst,
   * false otherwise
   */
static gboolean cheese_main_window_burst_take_photo (CheeseMainWindow* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->is_bursting;
	if (_tmp1_) {
		gint _tmp2_;
		GSettings* _tmp3_;
		gint _tmp4_ = 0;
		_tmp2_ = self->priv->burst_count;
		_tmp3_ = self->priv->settings;
		_tmp4_ = g_settings_get_int (_tmp3_, "burst-repeat");
		_tmp0_ = _tmp2_ < _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		gint _tmp6_;
		cheese_main_window_take_photo (self);
		_tmp6_ = self->priv->burst_count;
		self->priv->burst_count = _tmp6_ + 1;
		result = TRUE;
		return result;
	} else {
		cheese_main_window_toggle_photo_bursting (self, FALSE);
		result = FALSE;
		return result;
	}
}


/**
   * Cancel the current activity if the escape key is pressed.
   *
   * @param event the key event, to check which key was pressed
   * @return false, to allow further processing of the event
   */
static gboolean cheese_main_window_on_key_release (CheeseMainWindow* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gchar* key = NULL;
	GdkEventKey _tmp0_;
	guint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GCompareFunc _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.keyval;
	_tmp2_ = gdk_keyval_name (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (key);
	key = _tmp3_;
	_tmp4_ = g_strcmp0;
	_tmp5_ = key;
	_tmp6_ = _tmp4_ (_tmp5_, "Escape");
	if (_tmp6_ == 0) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		CheeseCountdown* _tmp10_;
		gboolean _tmp13_;
		gboolean _tmp15_;
		gboolean _tmp17_;
		_tmp10_ = self->priv->current_countdown;
		if (_tmp10_ != NULL) {
			CheeseCountdown* _tmp11_;
			gboolean _tmp12_;
			_tmp11_ = self->priv->current_countdown;
			_tmp12_ = _tmp11_->running;
			_tmp9_ = _tmp12_;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp13_ = _tmp9_;
		if (_tmp13_) {
			_tmp8_ = TRUE;
		} else {
			gboolean _tmp14_;
			_tmp14_ = self->priv->is_bursting;
			_tmp8_ = _tmp14_;
		}
		_tmp15_ = _tmp8_;
		if (_tmp15_) {
			_tmp7_ = TRUE;
		} else {
			gboolean _tmp16_;
			_tmp16_ = self->priv->is_recording;
			_tmp7_ = _tmp16_;
		}
		_tmp17_ = _tmp7_;
		if (_tmp17_) {
			CheeseMediaMode _tmp18_;
			self->priv->action_cancelled = TRUE;
			_tmp18_ = self->priv->current_mode;
			switch (_tmp18_) {
				case CHEESE_MEDIA_MODE_PHOTO:
				{
					CheeseCountdown* _tmp19_;
					_tmp19_ = self->priv->current_countdown;
					cheese_countdown_stop (_tmp19_);
					cheese_main_window_finish_countdown_callback (self);
					break;
				}
				case CHEESE_MEDIA_MODE_BURST:
				{
					cheese_main_window_toggle_photo_bursting (self, FALSE);
					break;
				}
				case CHEESE_MEDIA_MODE_VIDEO:
				{
					cheese_main_window_toggle_video_recording (self, FALSE);
					break;
				}
				default:
				break;
			}
			self->priv->action_cancelled = FALSE;
		} else {
			gboolean _tmp20_;
			_tmp20_ = self->priv->is_effects_selector_active;
			if (_tmp20_) {
				GtkToggleAction* _tmp21_;
				_tmp21_ = self->priv->effects_toggle_action;
				gtk_toggle_action_set_active (_tmp21_, FALSE);
			}
		}
	}
	result = FALSE;
	_g_free0 (key);
	return result;
}


/**
   * Toggle whether video recording is active.
   *
   * @param is_start whether to start video recording
   */
void cheese_main_window_toggle_video_recording (CheeseMainWindow* self, gboolean is_start) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_start;
	if (_tmp0_) {
		CheeseCamera* _tmp1_;
		CheeseFileUtil* _tmp2_;
		CheeseMediaMode _tmp3_;
		const gchar* _tmp4_ = NULL;
		GtkLabel* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GtkButton* _tmp11_;
		const gchar* _tmp12_ = NULL;
		GtkImage* _tmp13_;
		_tmp1_ = self->priv->camera;
		_tmp2_ = self->priv->fileutil;
		_tmp3_ = self->priv->current_mode;
		_tmp4_ = cheese_fileutil_get_new_media_filename (_tmp2_, _tmp3_);
		cheese_camera_start_video_recording (_tmp1_, _tmp4_);
		_tmp5_ = self->priv->take_action_button_label;
		_tmp6_ = _ ("Stop _Recording");
		_tmp7_ = g_strconcat ("<b>", _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp8_, "</b>", NULL);
		_tmp10_ = _tmp9_;
		gtk_label_set_label (_tmp5_, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_tmp11_ = self->priv->take_action_button;
		_tmp12_ = _ ("Stop recording");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp11_, _tmp12_);
		_tmp13_ = self->priv->take_action_button_image;
		gtk_image_set_from_stock (_tmp13_, GTK_STOCK_MEDIA_STOP, GTK_ICON_SIZE_BUTTON);
		self->priv->is_recording = TRUE;
		cheese_main_window_disable_mode_change (self);
	} else {
		CheeseCamera* _tmp14_;
		GtkLabel* _tmp15_;
		GtkButton* _tmp16_;
		GtkAction* _tmp17_;
		GtkAction* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		GtkButton* _tmp25_;
		GtkButton* _tmp26_;
		GtkAction* _tmp27_;
		GtkAction* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		GtkImage* _tmp31_;
		_tmp14_ = self->priv->camera;
		cheese_camera_stop_video_recording (_tmp14_);
		_tmp15_ = self->priv->take_action_button_label;
		_tmp16_ = self->priv->take_action_button;
		_tmp17_ = gtk_activatable_get_related_action ((GtkActivatable*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = gtk_action_get_label (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat ("<b>", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp22_, "</b>", NULL);
		_tmp24_ = _tmp23_;
		gtk_label_set_label (_tmp15_, _tmp24_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_tmp25_ = self->priv->take_action_button;
		_tmp26_ = self->priv->take_action_button;
		_tmp27_ = gtk_activatable_get_related_action ((GtkActivatable*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = gtk_action_get_tooltip (_tmp28_);
		_tmp30_ = _tmp29_;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp25_, _tmp30_);
		_tmp31_ = self->priv->take_action_button_image;
		gtk_image_set_from_stock (_tmp31_, GTK_STOCK_MEDIA_RECORD, GTK_ICON_SIZE_BUTTON);
		self->priv->is_recording = FALSE;
		cheese_main_window_enable_mode_change (self);
	}
}


/**
   * Toggle whether photo bursting is active.
   *
   * @param is_start whether to start capturing a photo burst
   */
static gboolean _cheese_main_window_burst_take_photo_gsource_func (gpointer self) {
	gboolean result;
	result = cheese_main_window_burst_take_photo (self);
	return result;
}


void cheese_main_window_toggle_photo_bursting (CheeseMainWindow* self, gboolean is_start) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = is_start;
	if (_tmp0_) {
		GtkToggleAction* _tmp1_;
		GtkLabel* _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GtkButton* _tmp8_;
		const gchar* _tmp9_ = NULL;
		GSettings* _tmp10_;
		gint _tmp11_ = 0;
		gint burst_delay;
		GSettings* _tmp12_;
		gint _tmp13_ = 0;
		gint countdown_duration;
		gboolean _tmp14_ = FALSE;
		gint _tmp15_;
		gint _tmp16_;
		gboolean _tmp19_;
		self->priv->is_bursting = TRUE;
		cheese_main_window_disable_mode_change (self);
		_tmp1_ = self->priv->effects_toggle_action;
		gtk_action_set_sensitive ((GtkAction*) _tmp1_, FALSE);
		_tmp2_ = self->priv->take_action_button_label;
		_tmp3_ = _ ("Stop _Taking Pictures");
		_tmp4_ = g_strconcat ("<b>", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp5_, "</b>", NULL);
		_tmp7_ = _tmp6_;
		gtk_label_set_label (_tmp2_, _tmp7_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_tmp8_ = self->priv->take_action_button;
		_tmp9_ = _ ("Stop taking pictures");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp8_, _tmp9_);
		cheese_main_window_burst_take_photo (self);
		_tmp10_ = self->priv->settings;
		_tmp11_ = g_settings_get_int (_tmp10_, "burst-delay");
		burst_delay = _tmp11_;
		_tmp12_ = self->priv->settings;
		_tmp13_ = g_settings_get_int (_tmp12_, "countdown-duration");
		countdown_duration = 500 + (_tmp13_ * 1000);
		_tmp15_ = burst_delay;
		_tmp16_ = countdown_duration;
		if ((_tmp15_ - _tmp16_) < 1000) {
			GSettings* _tmp17_;
			gboolean _tmp18_ = FALSE;
			_tmp17_ = self->priv->settings;
			_tmp18_ = g_settings_get_boolean (_tmp17_, "countdown");
			_tmp14_ = _tmp18_;
		} else {
			_tmp14_ = FALSE;
		}
		_tmp19_ = _tmp14_;
		if (_tmp19_) {
			gint _tmp20_;
			guint _tmp21_ = 0U;
			_tmp20_ = countdown_duration;
			_tmp21_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp20_, _cheese_main_window_burst_take_photo_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->burst_callback_id = _tmp21_;
		} else {
			gint _tmp22_;
			guint _tmp23_ = 0U;
			_tmp22_ = burst_delay;
			_tmp23_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp22_, _cheese_main_window_burst_take_photo_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->burst_callback_id = _tmp23_;
		}
	} else {
		gboolean _tmp24_ = FALSE;
		CheeseCountdown* _tmp25_;
		gboolean _tmp28_;
		GtkLabel* _tmp30_;
		GtkButton* _tmp31_;
		GtkAction* _tmp32_;
		GtkAction* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		GtkButton* _tmp40_;
		GtkButton* _tmp41_;
		GtkAction* _tmp42_;
		GtkAction* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		CheeseFileUtil* _tmp46_;
		guint _tmp47_;
		_tmp25_ = self->priv->current_countdown;
		if (_tmp25_ != NULL) {
			CheeseCountdown* _tmp26_;
			gboolean _tmp27_;
			_tmp26_ = self->priv->current_countdown;
			_tmp27_ = _tmp26_->running;
			_tmp24_ = _tmp27_;
		} else {
			_tmp24_ = FALSE;
		}
		_tmp28_ = _tmp24_;
		if (_tmp28_) {
			CheeseCountdown* _tmp29_;
			_tmp29_ = self->priv->current_countdown;
			cheese_countdown_stop (_tmp29_);
		}
		self->priv->is_bursting = FALSE;
		cheese_main_window_enable_mode_change (self);
		_tmp30_ = self->priv->take_action_button_label;
		_tmp31_ = self->priv->take_action_button;
		_tmp32_ = gtk_activatable_get_related_action ((GtkActivatable*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = gtk_action_get_label (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strconcat ("<b>", _tmp35_, NULL);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strconcat (_tmp37_, "</b>", NULL);
		_tmp39_ = _tmp38_;
		gtk_label_set_label (_tmp30_, _tmp39_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
		_tmp40_ = self->priv->take_action_button;
		_tmp41_ = self->priv->take_action_button;
		_tmp42_ = gtk_activatable_get_related_action ((GtkActivatable*) _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = gtk_action_get_tooltip (_tmp43_);
		_tmp45_ = _tmp44_;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp40_, _tmp45_);
		self->priv->burst_count = 0;
		_tmp46_ = self->priv->fileutil;
		cheese_fileutil_reset_burst (_tmp46_);
		_tmp47_ = self->priv->burst_callback_id;
		g_source_remove (_tmp47_);
	}
}


/**
   * Take a photo or burst of photos, or record a video, based on the current
   * capture mode.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_take_action (GtkAction* action, CheeseMainWindow* self) {
	CheeseMediaMode _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->current_mode;
	if (_tmp0_ == CHEESE_MEDIA_MODE_PHOTO) {
		cheese_main_window_take_photo (self);
	} else {
		CheeseMediaMode _tmp1_;
		_tmp1_ = self->priv->current_mode;
		if (_tmp1_ == CHEESE_MEDIA_MODE_VIDEO) {
			gboolean _tmp2_;
			_tmp2_ = self->priv->is_recording;
			cheese_main_window_toggle_video_recording (self, !_tmp2_);
		} else {
			CheeseMediaMode _tmp3_;
			_tmp3_ = self->priv->current_mode;
			if (_tmp3_ == CHEESE_MEDIA_MODE_BURST) {
				gboolean _tmp4_;
				_tmp4_ = self->priv->is_bursting;
				cheese_main_window_toggle_photo_bursting (self, !_tmp4_);
			}
		}
	}
}


/**
   * Toggle the display of the effect selector.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_effects_toggle (GtkToggleAction* action, CheeseMainWindow* self) {
	GtkToggleAction* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkAction* _tmp3_;
	GtkToggleAction* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GtkAction* _tmp7_;
	GtkToggleAction* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GtkAction* _tmp11_;
	GtkToggleAction* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	GtkAction* _tmp15_;
	GtkToggleAction* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	GtkAction* _tmp19_;
	GtkToggleAction* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	GtkAction* _tmp23_;
	GtkToggleAction* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gtk_toggle_action_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	cheese_main_window_toggle_effects_selector (self, _tmp2_);
	_tmp3_ = self->priv->take_photo_action;
	_tmp4_ = action;
	_tmp5_ = gtk_toggle_action_get_active (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_action_set_sensitive (_tmp3_, !_tmp6_);
	_tmp7_ = self->priv->take_video_action;
	_tmp8_ = action;
	_tmp9_ = gtk_toggle_action_get_active (_tmp8_);
	_tmp10_ = _tmp9_;
	gtk_action_set_sensitive (_tmp7_, !_tmp10_);
	_tmp11_ = self->priv->take_burst_action;
	_tmp12_ = action;
	_tmp13_ = gtk_toggle_action_get_active (_tmp12_);
	_tmp14_ = _tmp13_;
	gtk_action_set_sensitive (_tmp11_, !_tmp14_);
	_tmp15_ = self->priv->photo_mode_action;
	_tmp16_ = action;
	_tmp17_ = gtk_toggle_action_get_active (_tmp16_);
	_tmp18_ = _tmp17_;
	gtk_action_set_sensitive (_tmp15_, !_tmp18_);
	_tmp19_ = self->priv->video_mode_action;
	_tmp20_ = action;
	_tmp21_ = gtk_toggle_action_get_active (_tmp20_);
	_tmp22_ = _tmp21_;
	gtk_action_set_sensitive (_tmp19_, !_tmp22_);
	_tmp23_ = self->priv->burst_mode_action;
	_tmp24_ = action;
	_tmp25_ = gtk_toggle_action_get_active (_tmp24_);
	_tmp26_ = _tmp25_;
	gtk_action_set_sensitive (_tmp23_, !_tmp26_);
}


/**
   * Change the selected effect, as a new one was selected.
   *
   * @param source unused
   * @param event unused
   * @return false, to allow further event processing
   */
gboolean cheese_main_window_on_selected_effect_change (CheeseMainWindow* self, ClutterActor* source, ClutterButtonEvent* event) {
	gboolean result = FALSE;
	ClutterActor* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	CheeseEffect* _tmp2_;
	CheeseCamera* _tmp3_;
	CheeseEffect* _tmp4_;
	GSettings* _tmp5_;
	CheeseEffect* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GtkToggleAction* _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = source;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "effect");
	_tmp2_ = _g_object_ref0 ((CheeseEffect*) _tmp1_);
	_g_object_unref0 (self->priv->selected_effect);
	self->priv->selected_effect = _tmp2_;
	_tmp3_ = self->priv->camera;
	_tmp4_ = self->priv->selected_effect;
	cheese_camera_set_effect (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->settings;
	_tmp6_ = self->priv->selected_effect;
	_tmp7_ = cheese_effect_get_name (_tmp6_);
	_tmp8_ = _tmp7_;
	g_settings_set_string (_tmp5_, "selected-effect", _tmp8_);
	_tmp9_ = self->priv->effects_toggle_action;
	gtk_toggle_action_set_active (_tmp9_, FALSE);
	result = FALSE;
	return result;
}


/**
   * Navigate back one page of effects.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_prev_effects_page (GtkAction* action, CheeseMainWindow* self) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->current_effects_page;
	if (_tmp0_ != 0) {
		gint _tmp1_;
		_tmp1_ = self->priv->current_effects_page;
		cheese_main_window_activate_effects_page (self, _tmp1_ - 1);
	}
}


/**
   * Navigate forward one page of effects.
   *
   * @param action the action that emitted the signal
   */
void cheese_main_window_on_next_effects_page (GtkAction* action, CheeseMainWindow* self) {
	gint _tmp0_;
	CheeseEffectsManager* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->current_effects_page;
	_tmp1_ = self->priv->effects_manager;
	_tmp2_ = _tmp1_->effects;
	_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp0_ != (_tmp4_ / EFFECTS_PER_PAGE)) {
		gint _tmp5_;
		_tmp5_ = self->priv->current_effects_page;
		cheese_main_window_activate_effects_page (self, _tmp5_ + 1);
	}
}


/**
   * Switch to the supplied page of effects.
   *
   * @param number the effects page to switch to
   */
static void cheese_main_window_activate_effects_page (CheeseMainWindow* self, gint number) {
	gboolean _tmp0_;
	gint _tmp1_;
	ClutterBox* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* _tmp4_;
	ClutterBox* _tmp5_;
	gint _tmp6_ = 0;
	gboolean _tmp7_;
	GeeArrayList* _tmp10_;
	gint _tmp11_;
	gpointer _tmp12_ = NULL;
	ClutterBox* _tmp13_;
	ClutterBox* _tmp14_;
	ClutterBox* _tmp15_;
	ClutterBox* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_effects_selector_active;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = number;
	self->priv->current_effects_page = _tmp1_;
	_tmp2_ = self->priv->viewport_layout;
	_tmp3_ = clutter_container_get_children ((ClutterContainer*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->current_effects_grid;
	_tmp6_ = g_list_index (_tmp4_, (ClutterActor*) _tmp5_);
	_tmp7_ = _tmp6_ != (-1);
	_g_list_free0 (_tmp4_);
	if (_tmp7_) {
		ClutterBox* _tmp8_;
		ClutterBox* _tmp9_;
		_tmp8_ = self->priv->viewport_layout;
		_tmp9_ = self->priv->current_effects_grid;
		clutter_container_remove ((ClutterContainer*) _tmp8_, CLUTTER_ACTOR (_tmp9_), NULL);
	}
	_tmp10_ = self->priv->effects_grids;
	_tmp11_ = number;
	_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
	_g_object_unref0 (self->priv->current_effects_grid);
	self->priv->current_effects_grid = (ClutterBox*) _tmp12_;
	_tmp13_ = self->priv->current_effects_grid;
	g_object_set ((GObject*) _tmp13_, "opacity", 0, NULL);
	_tmp14_ = self->priv->viewport_layout;
	_tmp15_ = self->priv->current_effects_grid;
	clutter_container_add ((ClutterContainer*) _tmp14_, CLUTTER_ACTOR (_tmp15_), NULL);
	_tmp16_ = self->priv->current_effects_grid;
	clutter_actor_animate ((ClutterActor*) _tmp16_, (gulong) CLUTTER_LINEAR, (guint) 1000, "opacity", 255, NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp17_;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_;
				gint _tmp20_;
				CheeseEffectsManager* _tmp21_;
				GeeArrayList* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gint page_of_effect;
				CheeseEffectsManager* _tmp26_;
				GeeArrayList* _tmp27_;
				gint _tmp28_;
				gpointer _tmp29_ = NULL;
				CheeseEffect* effect;
				gint _tmp30_;
				gint _tmp31_;
				_tmp18_ = _tmp17_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp20_ = i;
				_tmp21_ = self->priv->effects_manager;
				_tmp22_ = _tmp21_->effects;
				_tmp23_ = gee_collection_get_size ((GeeCollection*) _tmp22_);
				_tmp24_ = _tmp23_;
				if (!(_tmp20_ < _tmp24_)) {
					break;
				}
				_tmp25_ = i;
				page_of_effect = _tmp25_ / EFFECTS_PER_PAGE;
				_tmp26_ = self->priv->effects_manager;
				_tmp27_ = _tmp26_->effects;
				_tmp28_ = i;
				_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, _tmp28_);
				effect = (CheeseEffect*) _tmp29_;
				_tmp30_ = page_of_effect;
				_tmp31_ = number;
				if (_tmp30_ == _tmp31_) {
					CheeseEffect* _tmp32_;
					gboolean _tmp33_ = FALSE;
					CheeseEffect* _tmp40_;
					_tmp32_ = effect;
					_tmp33_ = cheese_effect_is_preview_connected (_tmp32_);
					if (!_tmp33_) {
						CheeseEffect* _tmp34_;
						gconstpointer _tmp35_ = NULL;
						ClutterTexture* _tmp36_;
						ClutterTexture* texture;
						CheeseCamera* _tmp37_;
						CheeseEffect* _tmp38_;
						ClutterTexture* _tmp39_;
						_tmp34_ = effect;
						_tmp35_ = g_object_get_data ((GObject*) _tmp34_, "texture");
						_tmp36_ = _g_object_ref0 ((ClutterTexture*) _tmp35_);
						texture = _tmp36_;
						_tmp37_ = self->priv->camera;
						_tmp38_ = effect;
						_tmp39_ = texture;
						cheese_camera_connect_effect_texture (_tmp37_, _tmp38_, _tmp39_);
						_g_object_unref0 (texture);
					}
					_tmp40_ = effect;
					cheese_effect_enable_preview (_tmp40_);
				} else {
					CheeseEffect* _tmp41_;
					gboolean _tmp42_ = FALSE;
					_tmp41_ = effect;
					_tmp42_ = cheese_effect_is_preview_connected (_tmp41_);
					if (_tmp42_) {
						CheeseEffect* _tmp43_;
						_tmp43_ = effect;
						cheese_effect_disable_preview (_tmp43_);
					}
				}
				_g_object_unref0 (effect);
			}
		}
	}
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
}


/**
   * Control the sensitivity of the effects page navigation buttons.
   */
static void cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GtkAction* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	GtkAction* _tmp12_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->is_effects_selector_active;
	if (_tmp1_) {
		gint _tmp2_;
		_tmp2_ = self->priv->current_effects_page;
		_tmp0_ = _tmp2_ != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = self->priv->effects_page_prev_action;
	_tmp4_ = _tmp0_;
	gtk_action_set_sensitive (_tmp3_, _tmp4_);
	_tmp6_ = self->priv->is_effects_selector_active;
	if (_tmp6_) {
		gint _tmp7_;
		CheeseEffectsManager* _tmp8_;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp7_ = self->priv->current_effects_page;
		_tmp8_ = self->priv->effects_manager;
		_tmp9_ = _tmp8_->effects;
		_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = _tmp7_ != (_tmp11_ / EFFECTS_PER_PAGE);
	} else {
		_tmp5_ = FALSE;
	}
	_tmp12_ = self->priv->effects_page_next_action;
	_tmp13_ = _tmp5_;
	gtk_action_set_sensitive (_tmp12_, _tmp13_);
}


/**
   * Toggle the visibility of the effects selector.
   *
   * @param active whether the selector should be active
   */
static void cheese_main_window_toggle_effects_selector (CheeseMainWindow* self, gboolean active) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	CheeseCamera* _tmp17_;
	gboolean _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = active;
	self->priv->is_effects_selector_active = _tmp0_;
	_tmp1_ = active;
	if (_tmp1_) {
		ClutterTexture* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp2_ = self->priv->video_preview;
		clutter_actor_hide ((ClutterActor*) _tmp2_);
		_tmp3_ = self->priv->effects_grids;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ == 0) {
			ClutterText* _tmp6_;
			const gchar* _tmp7_ = NULL;
			ClutterText* _tmp8_;
			_tmp6_ = self->priv->error_layer;
			_tmp7_ = _ ("No effects found");
			clutter_text_set_text (_tmp6_, _tmp7_);
			_tmp8_ = self->priv->error_layer;
			clutter_actor_show ((ClutterActor*) _tmp8_);
		} else {
			ClutterBox* _tmp9_;
			gint _tmp10_;
			_tmp9_ = self->priv->current_effects_grid;
			clutter_actor_show ((ClutterActor*) _tmp9_);
			_tmp10_ = self->priv->current_effects_page;
			cheese_main_window_activate_effects_page (self, _tmp10_);
		}
	} else {
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		ClutterTexture* _tmp16_;
		_tmp11_ = self->priv->effects_grids;
		_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_ == 0) {
			ClutterText* _tmp14_;
			_tmp14_ = self->priv->error_layer;
			clutter_actor_hide ((ClutterActor*) _tmp14_);
		} else {
			ClutterBox* _tmp15_;
			_tmp15_ = self->priv->current_effects_grid;
			clutter_actor_hide ((ClutterActor*) _tmp15_);
		}
		_tmp16_ = self->priv->video_preview;
		clutter_actor_show ((ClutterActor*) _tmp16_);
	}
	_tmp17_ = self->priv->camera;
	_tmp18_ = active;
	cheese_camera_toggle_effects_pipeline (_tmp17_, _tmp18_);
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
}


/**
   * Create the effects selector.
   */
static gboolean _cheese_main_window_on_selected_effect_change_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_selected_effect_change (self, _sender, event);
	return result;
}


static void cheese_main_window_setup_effects_selector (CheeseMainWindow* self) {
	ClutterBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_effects_grid;
	if (_tmp0_ == NULL) {
		CheeseEffectsManager* _tmp1_;
		CheeseEffectsManager* _tmp2_;
		GeeArrayList* _tmp3_;
		CheeseEffectsManager* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		GeeArrayList* _tmp90_;
		gpointer _tmp91_ = NULL;
		_tmp1_ = cheese_effects_manager_new ();
		_g_object_unref0 (self->priv->effects_manager);
		self->priv->effects_manager = _tmp1_;
		_tmp2_ = self->priv->effects_manager;
		cheese_effects_manager_load_effects (_tmp2_);
		_tmp3_ = gee_array_list_new (clutter_box_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
		_g_object_unref0 (self->priv->effects_grids);
		self->priv->effects_grids = _tmp3_;
		_tmp4_ = self->priv->effects_manager;
		_tmp5_ = _tmp4_->effects;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == 0) {
			g_warning ("cheese-window.vala:1242: gnome-video-effects is not installed.");
			return;
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp8_;
				_tmp8_ = TRUE;
				while (TRUE) {
					gboolean _tmp9_;
					gint _tmp11_;
					CheeseEffectsManager* _tmp12_;
					GeeArrayList* _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					ClutterTableLayout* _tmp16_;
					ClutterTableLayout* _tmp17_;
					ClutterTableLayout* table_layout;
					ClutterTableLayout* _tmp18_;
					ClutterBox* _tmp19_;
					ClutterBox* _tmp20_;
					ClutterBox* grid;
					GeeArrayList* _tmp21_;
					ClutterBox* _tmp22_;
					ClutterTableLayout* _tmp23_;
					ClutterTableLayout* _tmp24_;
					_tmp9_ = _tmp8_;
					if (!_tmp9_) {
						gint _tmp10_;
						_tmp10_ = i;
						i = _tmp10_ + 1;
					}
					_tmp8_ = FALSE;
					_tmp11_ = i;
					_tmp12_ = self->priv->effects_manager;
					_tmp13_ = _tmp12_->effects;
					_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
					_tmp15_ = _tmp14_;
					if (!(_tmp11_ <= (_tmp15_ / EFFECTS_PER_PAGE))) {
						break;
					}
					_tmp16_ = (ClutterTableLayout*) clutter_table_layout_new ();
					_tmp17_ = g_object_ref_sink (_tmp16_);
					table_layout = _tmp17_;
					_tmp18_ = table_layout;
					_tmp19_ = (ClutterBox*) clutter_box_new ((ClutterLayoutManager*) _tmp18_);
					_tmp20_ = g_object_ref_sink (_tmp19_);
					grid = _tmp20_;
					_tmp21_ = self->priv->effects_grids;
					_tmp22_ = grid;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
					_tmp23_ = table_layout;
					clutter_table_layout_set_column_spacing (_tmp23_, (guint) 10);
					_tmp24_ = table_layout;
					clutter_table_layout_set_row_spacing (_tmp24_, (guint) 10);
					_g_object_unref0 (grid);
					_g_object_unref0 (table_layout);
				}
			}
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp25_;
				_tmp25_ = TRUE;
				while (TRUE) {
					gboolean _tmp26_;
					gint _tmp28_;
					CheeseEffectsManager* _tmp29_;
					GeeArrayList* _tmp30_;
					gint _tmp31_;
					gint _tmp32_;
					CheeseEffectsManager* _tmp33_;
					GeeArrayList* _tmp34_;
					gint _tmp35_;
					gpointer _tmp36_ = NULL;
					CheeseEffect* effect;
					ClutterTexture* _tmp37_;
					ClutterTexture* _tmp38_;
					ClutterTexture* texture;
					ClutterBinLayout* _tmp39_;
					ClutterBinLayout* _tmp40_;
					ClutterBinLayout* layout;
					ClutterBinLayout* _tmp41_;
					ClutterBox* _tmp42_;
					ClutterBox* _tmp43_;
					ClutterBox* box;
					ClutterText* _tmp44_;
					ClutterText* _tmp45_;
					ClutterText* text;
					ClutterRectangle* _tmp46_;
					ClutterRectangle* _tmp47_;
					ClutterRectangle* rect;
					ClutterRectangle* _tmp48_;
					ClutterRectangle* _tmp49_;
					ClutterColor _tmp50_ = {0};
					ClutterTexture* _tmp51_;
					ClutterBox* _tmp52_;
					ClutterTexture* _tmp53_;
					ClutterBox* _tmp54_;
					ClutterBox* _tmp55_;
					CheeseEffect* _tmp56_;
					CheeseEffect* _tmp57_;
					CheeseEffect* _tmp58_;
					ClutterTexture* _tmp59_;
					ClutterTexture* _tmp60_;
					ClutterBox* _tmp61_;
					ClutterText* _tmp62_;
					CheeseEffect* _tmp63_;
					const gchar* _tmp64_;
					const gchar* _tmp65_;
					ClutterText* _tmp66_;
					ClutterColor _tmp67_ = {0};
					ClutterRectangle* _tmp68_;
					ClutterText* _tmp69_;
					gfloat _tmp70_;
					gfloat _tmp71_;
					ClutterBox* _tmp72_;
					ClutterRectangle* _tmp73_;
					ClutterBox* _tmp74_;
					ClutterText* _tmp75_;
					GeeArrayList* _tmp76_;
					gint _tmp77_;
					gpointer _tmp78_ = NULL;
					ClutterBox* _tmp79_;
					ClutterLayoutManager* _tmp80_;
					ClutterLayoutManager* _tmp81_;
					ClutterTableLayout* _tmp82_;
					ClutterTableLayout* _tmp83_;
					ClutterTableLayout* table_layout;
					ClutterTableLayout* _tmp84_;
					ClutterBox* _tmp85_;
					gint _tmp86_;
					gint _tmp87_;
					ClutterTableLayout* _tmp88_;
					ClutterBox* _tmp89_;
					_tmp26_ = _tmp25_;
					if (!_tmp26_) {
						gint _tmp27_;
						_tmp27_ = i;
						i = _tmp27_ + 1;
					}
					_tmp25_ = FALSE;
					_tmp28_ = i;
					_tmp29_ = self->priv->effects_manager;
					_tmp30_ = _tmp29_->effects;
					_tmp31_ = gee_collection_get_size ((GeeCollection*) _tmp30_);
					_tmp32_ = _tmp31_;
					if (!(_tmp28_ < _tmp32_)) {
						break;
					}
					_tmp33_ = self->priv->effects_manager;
					_tmp34_ = _tmp33_->effects;
					_tmp35_ = i;
					_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _tmp35_);
					effect = (CheeseEffect*) _tmp36_;
					_tmp37_ = (ClutterTexture*) clutter_texture_new ();
					_tmp38_ = g_object_ref_sink (_tmp37_);
					texture = _tmp38_;
					_tmp39_ = (ClutterBinLayout*) clutter_bin_layout_new (CLUTTER_BIN_ALIGNMENT_CENTER, CLUTTER_BIN_ALIGNMENT_CENTER);
					_tmp40_ = g_object_ref_sink (_tmp39_);
					layout = _tmp40_;
					_tmp41_ = layout;
					_tmp42_ = (ClutterBox*) clutter_box_new ((ClutterLayoutManager*) _tmp41_);
					_tmp43_ = g_object_ref_sink (_tmp42_);
					box = _tmp43_;
					_tmp44_ = (ClutterText*) clutter_text_new ();
					_tmp45_ = g_object_ref_sink (_tmp44_);
					text = _tmp45_;
					_tmp46_ = (ClutterRectangle*) clutter_rectangle_new ();
					_tmp47_ = g_object_ref_sink (_tmp46_);
					rect = _tmp47_;
					_tmp48_ = rect;
					clutter_actor_set_opacity ((ClutterActor*) _tmp48_, (guint) 128);
					_tmp49_ = rect;
					clutter_color_from_string (&_tmp50_, "black");
					clutter_rectangle_set_color (_tmp49_, &_tmp50_);
					_tmp51_ = texture;
					clutter_texture_set_keep_aspect_ratio (_tmp51_, TRUE);
					_tmp52_ = box;
					_tmp53_ = texture;
					clutter_box_pack (_tmp52_, CLUTTER_ACTOR (_tmp53_), NULL, NULL, NULL);
					_tmp54_ = box;
					clutter_actor_set_reactive ((ClutterActor*) _tmp54_, TRUE);
					_tmp55_ = box;
					_tmp56_ = effect;
					_tmp57_ = _g_object_ref0 (_tmp56_);
					g_object_set_data_full ((GObject*) _tmp55_, "effect", _tmp57_, g_object_unref);
					_tmp58_ = effect;
					_tmp59_ = texture;
					_tmp60_ = _g_object_ref0 (_tmp59_);
					g_object_set_data_full ((GObject*) _tmp58_, "texture", _tmp60_, g_object_unref);
					_tmp61_ = box;
					g_signal_connect_object ((ClutterActor*) _tmp61_, "button-release-event", (GCallback) _cheese_main_window_on_selected_effect_change_clutter_actor_button_release_event, self, 0);
					_tmp62_ = text;
					_tmp63_ = effect;
					_tmp64_ = cheese_effect_get_name (_tmp63_);
					_tmp65_ = _tmp64_;
					clutter_text_set_text (_tmp62_, _tmp65_);
					_tmp66_ = text;
					clutter_color_from_string (&_tmp67_, "white");
					clutter_text_set_color (_tmp66_, &_tmp67_);
					_tmp68_ = rect;
					_tmp69_ = text;
					_tmp70_ = clutter_actor_get_height ((ClutterActor*) _tmp69_);
					_tmp71_ = _tmp70_;
					clutter_actor_set_height ((ClutterActor*) _tmp68_, _tmp71_ + 5);
					_tmp72_ = box;
					_tmp73_ = rect;
					clutter_box_pack (_tmp72_, CLUTTER_ACTOR (_tmp73_), "x-align", CLUTTER_BIN_ALIGNMENT_FILL, "y-align", CLUTTER_BIN_ALIGNMENT_END, NULL, NULL);
					_tmp74_ = box;
					_tmp75_ = text;
					clutter_box_pack (_tmp74_, CLUTTER_ACTOR (_tmp75_), "x-align", CLUTTER_BIN_ALIGNMENT_CENTER, "y-align", CLUTTER_BIN_ALIGNMENT_END, NULL, NULL);
					_tmp76_ = self->priv->effects_grids;
					_tmp77_ = i;
					_tmp78_ = gee_abstract_list_get ((GeeAbstractList*) _tmp76_, _tmp77_ / EFFECTS_PER_PAGE);
					_tmp79_ = (ClutterBox*) _tmp78_;
					_tmp80_ = clutter_box_get_layout_manager (_tmp79_);
					_tmp81_ = _tmp80_;
					_tmp82_ = _g_object_ref0 (CLUTTER_TABLE_LAYOUT (_tmp81_));
					_tmp83_ = _tmp82_;
					_g_object_unref0 (_tmp79_);
					table_layout = _tmp83_;
					_tmp84_ = table_layout;
					_tmp85_ = box;
					_tmp86_ = i;
					_tmp87_ = i;
					clutter_table_layout_pack (_tmp84_, CLUTTER_ACTOR (_tmp85_), (_tmp86_ % EFFECTS_PER_PAGE) % 3, (_tmp87_ % EFFECTS_PER_PAGE) / 3);
					_tmp88_ = table_layout;
					_tmp89_ = box;
					clutter_table_layout_set_expand (_tmp88_, (ClutterActor*) _tmp89_, FALSE, FALSE);
					_g_object_unref0 (table_layout);
					_g_object_unref0 (rect);
					_g_object_unref0 (text);
					_g_object_unref0 (box);
					_g_object_unref0 (layout);
					_g_object_unref0 (texture);
					_g_object_unref0 (effect);
				}
			}
		}
		cheese_main_window_setup_effects_page_switch_sensitivity (self);
		_tmp90_ = self->priv->effects_grids;
		_tmp91_ = gee_abstract_list_get ((GeeAbstractList*) _tmp90_, 0);
		_g_object_unref0 (self->priv->current_effects_grid);
		self->priv->current_effects_grid = (ClutterBox*) _tmp91_;
	}
}


/**
   * Toggle the sensitvity of the camera actions.
   *
   * @param active whether the camera actions should be sensitive
   */
void cheese_main_window_toggle_camera_actions_sensitivities (CheeseMainWindow* self, gboolean active) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = active;
	self->priv->is_camera_actions_sensitive = _tmp0_;
	_tmp1_ = active;
	if (_tmp1_) {
		{
			GeeHashMap* _tmp2_;
			GeeSet* _tmp3_;
			GeeSet* _tmp4_;
			GeeSet* _tmp5_;
			GeeIterator* _tmp6_ = NULL;
			GeeIterator* _tmp7_;
			GeeIterator* _key_it;
			_tmp2_ = self->priv->action_sensitivities;
			_tmp3_ = gee_map_get_keys ((GeeMap*) _tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = _tmp4_;
			_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
			_tmp7_ = _tmp6_;
			_g_object_unref0 (_tmp5_);
			_key_it = _tmp7_;
			while (TRUE) {
				GeeIterator* _tmp8_;
				gboolean _tmp9_ = FALSE;
				GeeIterator* _tmp10_;
				gpointer _tmp11_ = NULL;
				gchar* key;
				GtkBuilder* _tmp12_;
				const gchar* _tmp13_;
				GObject* _tmp14_ = NULL;
				GtkAction* _tmp15_;
				GtkAction* action;
				GtkAction* _tmp16_;
				GeeHashMap* _tmp17_;
				const gchar* _tmp18_;
				gpointer _tmp19_ = NULL;
				_tmp8_ = _key_it;
				_tmp9_ = gee_iterator_next (_tmp8_);
				if (!_tmp9_) {
					break;
				}
				_tmp10_ = _key_it;
				_tmp11_ = gee_iterator_get (_tmp10_);
				key = (gchar*) _tmp11_;
				_tmp12_ = self->priv->gtk_builder;
				_tmp13_ = key;
				_tmp14_ = gtk_builder_get_object (_tmp12_, _tmp13_);
				_tmp15_ = _g_object_ref0 (GTK_IS_ACTION (_tmp14_) ? ((GtkAction*) _tmp14_) : NULL);
				action = _tmp15_;
				_tmp16_ = action;
				_tmp17_ = self->priv->action_sensitivities;
				_tmp18_ = key;
				_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, _tmp18_);
				gtk_action_set_sensitive (_tmp16_, GPOINTER_TO_INT (_tmp19_));
				_g_object_unref0 (action);
				_g_free0 (key);
			}
			_g_object_unref0 (_key_it);
		}
	} else {
		GHashFunc _tmp20_;
		GeeHashMap* _tmp21_;
		GtkBuilder* _tmp22_;
		GSList* _tmp23_ = NULL;
		GSList* objects;
		GSList* _tmp24_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar** _tmp47_ = NULL;
		gchar** active_actions;
		gint active_actions_length1;
		gint _active_actions_size_;
		gboolean flag = FALSE;
		GSList* _tmp48_;
		_tmp20_ = g_str_hash;
		_tmp21_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_BOOLEAN, NULL, NULL, _tmp20_, NULL, NULL);
		_g_object_unref0 (self->priv->action_sensitivities);
		self->priv->action_sensitivities = _tmp21_;
		_tmp22_ = self->priv->gtk_builder;
		_tmp23_ = gtk_builder_get_objects (_tmp22_);
		objects = _tmp23_;
		_tmp24_ = objects;
		{
			GSList* obj_collection = NULL;
			GSList* obj_it = NULL;
			obj_collection = _tmp24_;
			for (obj_it = obj_collection; obj_it != NULL; obj_it = obj_it->next) {
				GObject* _tmp25_;
				GObject* obj = NULL;
				_tmp25_ = _g_object_ref0 ((GObject*) obj_it->data);
				obj = _tmp25_;
				{
					GObject* _tmp26_;
					_tmp26_ = obj;
					if (GTK_IS_ACTION (_tmp26_)) {
						GObject* _tmp27_;
						GtkAction* _tmp28_;
						GtkAction* action;
						GeeHashMap* _tmp29_;
						GtkAction* _tmp30_;
						const gchar* _tmp31_;
						const gchar* _tmp32_;
						GtkAction* _tmp33_;
						gboolean _tmp34_;
						gboolean _tmp35_;
						_tmp27_ = obj;
						_tmp28_ = _g_object_ref0 (GTK_ACTION (_tmp27_));
						action = _tmp28_;
						_tmp29_ = self->priv->action_sensitivities;
						_tmp30_ = action;
						_tmp31_ = gtk_action_get_name (_tmp30_);
						_tmp32_ = _tmp31_;
						_tmp33_ = action;
						_tmp34_ = gtk_action_get_sensitive (_tmp33_);
						_tmp35_ = _tmp34_;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp29_, _tmp32_, GINT_TO_POINTER (_tmp35_));
						_g_object_unref0 (action);
					}
					_g_object_unref0 (obj);
				}
			}
		}
		_tmp36_ = g_strdup ("cheese_action");
		_tmp37_ = g_strdup ("edit_action");
		_tmp38_ = g_strdup ("help_action");
		_tmp39_ = g_strdup ("quit");
		_tmp40_ = g_strdup ("help_contents");
		_tmp41_ = g_strdup ("about");
		_tmp42_ = g_strdup ("open");
		_tmp43_ = g_strdup ("save_as");
		_tmp44_ = g_strdup ("move_to_trash");
		_tmp45_ = g_strdup ("delete");
		_tmp46_ = g_strdup ("move_all_to_trash");
		_tmp47_ = g_new0 (gchar*, 11 + 1);
		_tmp47_[0] = _tmp36_;
		_tmp47_[1] = _tmp37_;
		_tmp47_[2] = _tmp38_;
		_tmp47_[3] = _tmp39_;
		_tmp47_[4] = _tmp40_;
		_tmp47_[5] = _tmp41_;
		_tmp47_[6] = _tmp42_;
		_tmp47_[7] = _tmp43_;
		_tmp47_[8] = _tmp44_;
		_tmp47_[9] = _tmp45_;
		_tmp47_[10] = _tmp46_;
		active_actions = _tmp47_;
		active_actions_length1 = 11;
		_active_actions_size_ = active_actions_length1;
		_tmp48_ = objects;
		{
			GSList* obj_collection = NULL;
			GSList* obj_it = NULL;
			obj_collection = _tmp48_;
			for (obj_it = obj_collection; obj_it != NULL; obj_it = obj_it->next) {
				GObject* _tmp49_;
				GObject* obj = NULL;
				_tmp49_ = _g_object_ref0 ((GObject*) obj_it->data);
				obj = _tmp49_;
				{
					GObject* _tmp50_;
					flag = FALSE;
					_tmp50_ = obj;
					if (GTK_IS_ACTION (_tmp50_)) {
						GObject* _tmp51_;
						GtkAction* _tmp52_;
						GtkAction* action;
						gchar** _tmp53_;
						gint _tmp53__length1;
						gboolean _tmp59_;
						_tmp51_ = obj;
						_tmp52_ = _g_object_ref0 (GTK_ACTION (_tmp51_));
						action = _tmp52_;
						_tmp53_ = active_actions;
						_tmp53__length1 = active_actions_length1;
						{
							gchar** s_collection = NULL;
							gint s_collection_length1 = 0;
							gint _s_collection_size_ = 0;
							gint s_it = 0;
							s_collection = _tmp53_;
							s_collection_length1 = _tmp53__length1;
							for (s_it = 0; s_it < _tmp53__length1; s_it = s_it + 1) {
								gchar* _tmp54_;
								gchar* s = NULL;
								_tmp54_ = g_strdup (s_collection[s_it]);
								s = _tmp54_;
								{
									GtkAction* _tmp55_;
									const gchar* _tmp56_;
									const gchar* _tmp57_;
									const gchar* _tmp58_;
									_tmp55_ = action;
									_tmp56_ = gtk_action_get_name (_tmp55_);
									_tmp57_ = _tmp56_;
									_tmp58_ = s;
									if (g_strcmp0 (_tmp57_, _tmp58_) == 0) {
										flag = TRUE;
									}
									_g_free0 (s);
								}
							}
						}
						_tmp59_ = flag;
						if (!_tmp59_) {
							GObject* _tmp60_;
							_tmp60_ = obj;
							gtk_action_set_sensitive (GTK_ACTION (_tmp60_), FALSE);
						}
						_g_object_unref0 (action);
					}
					_g_object_unref0 (obj);
				}
			}
		}
		active_actions = (_vala_array_free (active_actions, active_actions_length1, (GDestroyNotify) g_free), NULL);
		_g_slist_free0 (objects);
	}
}


/**
   * Update the UI based on state changes of the camera.
   *
   * @param new_state the new Cheese.Camera state
   */
static void cheese_main_window_camera_state_changed (CheeseMainWindow* self, GstState new_state) {
	GstState _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = new_state;
	if (_tmp0_ == GST_STATE_PLAYING) {
		gboolean _tmp1_;
		CheeseEffectsManager* _tmp2_;
		GSettings* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		CheeseEffect* _tmp6_ = NULL;
		CheeseEffect* _tmp7_;
		CheeseEffect* effect;
		CheeseEffect* _tmp8_;
		_tmp1_ = self->priv->is_camera_actions_sensitive;
		if (!_tmp1_) {
			cheese_main_window_toggle_camera_actions_sensitivities (self, TRUE);
		}
		_tmp2_ = self->priv->effects_manager;
		_tmp3_ = self->priv->settings;
		_tmp4_ = g_settings_get_string (_tmp3_, "selected-effect");
		_tmp5_ = _tmp4_;
		_tmp6_ = cheese_effects_manager_get_effect (_tmp2_, _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		effect = _tmp7_;
		_tmp8_ = effect;
		if (_tmp8_ != NULL) {
			CheeseCamera* _tmp9_;
			CheeseEffect* _tmp10_;
			_tmp9_ = self->priv->camera;
			_tmp10_ = effect;
			cheese_camera_set_effect (_tmp9_, _tmp10_);
		}
		_g_object_unref0 (effect);
	}
}


/**
   * Set wide mode active when started from the command line (and do not change
   * the GSetting).
   */
void cheese_main_window_set_startup_wide_mode (CheeseMainWindow* self) {
	gboolean _tmp0_;
	GtkToggleAction* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_wide_mode;
	if (_tmp0_) {
		return;
	}
	self->priv->is_command_line_startup = TRUE;
	_tmp1_ = self->priv->wide_mode_action;
	gtk_toggle_action_set_active (_tmp1_, TRUE);
	self->priv->is_command_line_startup = FALSE;
}


/**
   * Set fullscreen mode active when started from the command line (and do not
   * change the GSetting).
   */
void cheese_main_window_set_startup_fullscreen_mode (CheeseMainWindow* self) {
	GtkToggleAction* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->is_command_line_startup = TRUE;
	_tmp0_ = self->priv->fullscreen_action;
	gtk_toggle_action_set_active (_tmp0_, TRUE);
	self->priv->is_command_line_startup = FALSE;
}


/**
   * Load the UI from the GtkBuilder description.
   */
static void _cheese_main_window_on_action_pre_activated_gtk_action_group_pre_activate (GtkActionGroup* _sender, GtkAction* p0, gpointer self) {
	cheese_main_window_on_action_pre_activated (self, p0);
}


static void _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self) {
	cheese_main_window_on_stage_resize (self, _sender, box, flags);
}


static gboolean _cheese_main_window_on_thumbnail_mouse_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_thumbnail_mouse_button_press (self, _sender, event);
	return result;
}


static gboolean _cheese_main_window_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_key_release (self, event);
	return result;
}


void cheese_main_window_setup_ui (CheeseMainWindow* self) {
	GtkBuilder* _tmp0_;
	ClutterScript* _tmp1_;
	CheeseFileUtil* _tmp2_;
	CheeseFlash* _tmp3_;
	CheeseFlash* _tmp4_;
	GSettings* _tmp5_;
	GtkBuilder* _tmp20_;
	GObject* _tmp21_ = NULL;
	GtkGrid* _tmp22_;
	GtkBuilder* _tmp23_;
	GObject* _tmp24_ = NULL;
	GtkWidget* _tmp25_;
	GtkBuilder* _tmp26_;
	GObject* _tmp27_ = NULL;
	GtkClutterEmbed* _tmp28_;
	GtkClutterEmbed* _tmp29_;
	ClutterActor* _tmp30_ = NULL;
	ClutterStage* _tmp31_;
	GtkBuilder* _tmp32_;
	GObject* _tmp33_ = NULL;
	GtkAlignment* _tmp34_;
	GtkBuilder* _tmp35_;
	GObject* _tmp36_ = NULL;
	GtkAlignment* _tmp37_;
	GtkBuilder* _tmp38_;
	GObject* _tmp39_ = NULL;
	GtkMenuBar* _tmp40_;
	GtkBuilder* _tmp41_;
	GObject* _tmp42_ = NULL;
	GtkBox* _tmp43_;
	GtkBuilder* _tmp44_;
	GObject* _tmp45_ = NULL;
	GtkToggleButton* _tmp46_;
	GtkBuilder* _tmp47_;
	GObject* _tmp48_ = NULL;
	GtkToggleButton* _tmp49_;
	GtkBuilder* _tmp50_;
	GObject* _tmp51_ = NULL;
	GtkToggleButton* _tmp52_;
	GtkBuilder* _tmp53_;
	GObject* _tmp54_ = NULL;
	GtkButton* _tmp55_;
	GtkBuilder* _tmp56_;
	GObject* _tmp57_ = NULL;
	GtkLabel* _tmp58_;
	GtkBuilder* _tmp59_;
	GObject* _tmp60_ = NULL;
	GtkImage* _tmp61_;
	GtkBuilder* _tmp62_;
	GObject* _tmp63_ = NULL;
	GtkToggleButton* _tmp64_;
	GtkBuilder* _tmp65_;
	GObject* _tmp66_ = NULL;
	GtkButton* _tmp67_;
	GtkBuilder* _tmp68_;
	GObject* _tmp69_ = NULL;
	GtkBox* _tmp70_;
	GtkBuilder* _tmp71_;
	GObject* _tmp72_ = NULL;
	GtkMenu* _tmp73_;
	GtkBuilder* _tmp74_;
	GObject* _tmp75_ = NULL;
	GtkActionGroup* _tmp76_;
	GtkBuilder* _tmp77_;
	GObject* _tmp78_ = NULL;
	GtkAction* _tmp79_;
	GtkBuilder* _tmp80_;
	GObject* _tmp81_ = NULL;
	GtkAction* _tmp82_;
	GtkBuilder* _tmp83_;
	GObject* _tmp84_ = NULL;
	GtkAction* _tmp85_;
	GtkBuilder* _tmp86_;
	GObject* _tmp87_ = NULL;
	GtkAction* _tmp88_;
	GtkBuilder* _tmp89_;
	GObject* _tmp90_ = NULL;
	GtkAction* _tmp91_;
	GtkBuilder* _tmp92_;
	GObject* _tmp93_ = NULL;
	GtkAction* _tmp94_;
	GtkBuilder* _tmp95_;
	GObject* _tmp96_ = NULL;
	GtkToggleAction* _tmp97_;
	GtkBuilder* _tmp98_;
	GObject* _tmp99_ = NULL;
	GtkAction* _tmp100_;
	GtkBuilder* _tmp101_;
	GObject* _tmp102_ = NULL;
	GtkToggleAction* _tmp103_;
	GtkBuilder* _tmp104_;
	GObject* _tmp105_ = NULL;
	GtkToggleAction* _tmp106_;
	GtkBuilder* _tmp107_;
	GObject* _tmp108_ = NULL;
	GtkAction* _tmp109_;
	GtkBuilder* _tmp110_;
	GObject* _tmp111_ = NULL;
	GtkAction* _tmp112_;
	GtkBuilder* _tmp113_;
	GObject* _tmp114_ = NULL;
	GtkAction* _tmp115_;
	CheeseShareableMedia* _tmp116_;
	GtkActionGroup* _tmp117_;
	GtkToggleButton* _tmp118_;
	GtkButton* _tmp119_;
	GtkToggleButton* _tmp120_;
	GtkButton* _tmp121_;
	GtkToggleButton* _tmp122_;
	GtkButton* _tmp123_;
	GtkButton* _tmp124_;
	GtkButton* _tmp125_;
	GtkToggleButton* _tmp126_;
	GtkButton* _tmp127_;
	GtkButton* _tmp128_;
	GtkButton* _tmp129_;
	GtkButton** _tmp130_ = NULL;
	ClutterScript* _tmp131_;
	GObject* _tmp132_ = NULL;
	ClutterTexture* _tmp133_;
	ClutterScript* _tmp134_;
	GObject* _tmp135_ = NULL;
	ClutterBox* _tmp136_;
	ClutterScript* _tmp137_;
	GObject* _tmp138_ = NULL;
	ClutterBinLayout* _tmp139_;
	ClutterScript* _tmp140_;
	GObject* _tmp141_ = NULL;
	ClutterText* _tmp142_;
	ClutterScript* _tmp143_;
	GObject* _tmp144_ = NULL;
	ClutterRectangle* _tmp145_;
	ClutterScript* _tmp146_;
	GObject* _tmp147_ = NULL;
	ClutterText* _tmp148_;
	ClutterTexture* _tmp149_;
	ClutterTexture* _tmp150_;
	ClutterStage* _tmp151_;
	ClutterRectangle* _tmp152_;
	ClutterBox* _tmp153_;
	ClutterBinLayout* _tmp154_;
	ClutterStage* _tmp155_;
	ClutterBox* _tmp156_;
	ClutterStage* _tmp157_;
	CheeseThumbView* _tmp158_;
	CheeseThumbView* _tmp159_;
	CheeseThumbView* _tmp160_;
	EogThumbNav* _tmp161_;
	EogThumbNav* _tmp162_;
	GtkCssProvider* css = NULL;
	GtkStyleContext* context = NULL;
	CheeseThumbView* _tmp169_;
	GtkStyleContext* _tmp170_ = NULL;
	GtkStyleContext* _tmp171_;
	GdkScreen* _tmp172_ = NULL;
	GtkStyleContext* _tmp173_;
	GdkScreen* _tmp174_;
	GdkScreen* _tmp175_;
	CheeseThumbView* _tmp176_;
	GtkGrid* _tmp177_;
	GtkGrid* _tmp178_;
	GtkClutterEmbed* _tmp179_;
	GtkToggleAction* _tmp180_;
	GSettings* _tmp181_;
	gboolean _tmp182_ = FALSE;
	GSettings* _tmp183_;
	gboolean _tmp184_ = FALSE;
	GSettings* _tmp186_;
	gboolean _tmp187_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->gtk_builder);
	self->priv->gtk_builder = _tmp0_;
	_tmp1_ = clutter_script_new ();
	_g_object_unref0 (self->priv->clutter_builder);
	self->priv->clutter_builder = _tmp1_;
	_tmp2_ = cheese_fileutil_new ();
	_g_object_unref0 (self->priv->fileutil);
	self->priv->fileutil = _tmp2_;
	_tmp3_ = cheese_flash_new ((GtkWidget*) self);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->flash);
	self->priv->flash = _tmp4_;
	_tmp5_ = g_settings_new ("org.gnome.Cheese");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp5_;
	{
		GtkBuilder* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		GtkBuilder* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		GtkBuilder* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		GtkBuilder* _tmp15_;
		ClutterScript* _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		_tmp6_ = self->priv->gtk_builder;
		_tmp7_ = g_build_filename (PACKAGE_DATADIR, "cheese-actions.ui", NULL);
		_tmp8_ = _tmp7_;
		gtk_builder_add_from_file (_tmp6_, _tmp8_, &_inner_error_);
		_g_free0 (_tmp8_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		_tmp9_ = self->priv->gtk_builder;
		_tmp10_ = g_build_filename (PACKAGE_DATADIR, "cheese-about.ui", NULL);
		_tmp11_ = _tmp10_;
		gtk_builder_add_from_file (_tmp9_, _tmp11_, &_inner_error_);
		_g_free0 (_tmp11_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		_tmp12_ = self->priv->gtk_builder;
		_tmp13_ = g_build_filename (PACKAGE_DATADIR, "cheese-main-window.ui", NULL);
		_tmp14_ = _tmp13_;
		gtk_builder_add_from_file (_tmp12_, _tmp14_, &_inner_error_);
		_g_free0 (_tmp14_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		_tmp15_ = self->priv->gtk_builder;
		gtk_builder_connect_signals (_tmp15_, self);
		_tmp16_ = self->priv->clutter_builder;
		_tmp17_ = g_build_filename (PACKAGE_DATADIR, "cheese-viewport.json", NULL);
		_tmp18_ = _tmp17_;
		clutter_script_load_from_file (_tmp16_, _tmp18_, &_inner_error_);
		_g_free0 (_tmp18_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp19_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = err->message;
		g_error ("cheese-window.vala:1431: Error: %s", _tmp19_);
		_g_error_free0 (err);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp20_ = self->priv->gtk_builder;
	_tmp21_ = gtk_builder_get_object (_tmp20_, "mainbox_normal");
	_tmp22_ = _g_object_ref0 (GTK_IS_GRID (_tmp21_) ? ((GtkGrid*) _tmp21_) : NULL);
	_g_object_unref0 (self->priv->main_vbox);
	self->priv->main_vbox = _tmp22_;
	_tmp23_ = self->priv->gtk_builder;
	_tmp24_ = gtk_builder_get_object (_tmp23_, "thumbnails");
	_tmp25_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp24_) ? ((GtkWidget*) _tmp24_) : NULL);
	_g_object_unref0 (self->priv->thumbnails);
	self->priv->thumbnails = _tmp25_;
	_tmp26_ = self->priv->gtk_builder;
	_tmp27_ = gtk_builder_get_object (_tmp26_, "viewport");
	_tmp28_ = _g_object_ref0 (GTK_CLUTTER_IS_EMBED (_tmp27_) ? ((GtkClutterEmbed*) _tmp27_) : NULL);
	_g_object_unref0 (self->priv->viewport_widget);
	self->priv->viewport_widget = _tmp28_;
	_tmp29_ = self->priv->viewport_widget;
	_tmp30_ = gtk_clutter_embed_get_stage (_tmp29_);
	_tmp31_ = _g_object_ref0 (CLUTTER_IS_STAGE (_tmp30_) ? ((ClutterStage*) _tmp30_) : NULL);
	_g_object_unref0 (self->priv->viewport);
	self->priv->viewport = _tmp31_;
	_tmp32_ = self->priv->gtk_builder;
	_tmp33_ = gtk_builder_get_object (_tmp32_, "thumbnails_right");
	_tmp34_ = _g_object_ref0 (GTK_IS_ALIGNMENT (_tmp33_) ? ((GtkAlignment*) _tmp33_) : NULL);
	_g_object_unref0 (self->priv->thumbnails_right);
	self->priv->thumbnails_right = _tmp34_;
	_tmp35_ = self->priv->gtk_builder;
	_tmp36_ = gtk_builder_get_object (_tmp35_, "thumbnails_bottom");
	_tmp37_ = _g_object_ref0 (GTK_IS_ALIGNMENT (_tmp36_) ? ((GtkAlignment*) _tmp36_) : NULL);
	_g_object_unref0 (self->priv->thumbnails_bottom);
	self->priv->thumbnails_bottom = _tmp37_;
	_tmp38_ = self->priv->gtk_builder;
	_tmp39_ = gtk_builder_get_object (_tmp38_, "main_menubar");
	_tmp40_ = _g_object_ref0 (GTK_IS_MENU_BAR (_tmp39_) ? ((GtkMenuBar*) _tmp39_) : NULL);
	_g_object_unref0 (self->priv->menubar);
	self->priv->menubar = _tmp40_;
	_tmp41_ = self->priv->gtk_builder;
	_tmp42_ = gtk_builder_get_object (_tmp41_, "leave_fullscreen_button_bin");
	_tmp43_ = _g_object_ref0 (GTK_IS_BOX (_tmp42_) ? ((GtkBox*) _tmp42_) : NULL);
	_g_object_unref0 (self->priv->leave_fullscreen_button_container);
	self->priv->leave_fullscreen_button_container = _tmp43_;
	_tmp44_ = self->priv->gtk_builder;
	_tmp45_ = gtk_builder_get_object (_tmp44_, "photo_toggle_button");
	_tmp46_ = _g_object_ref0 (GTK_IS_TOGGLE_BUTTON (_tmp45_) ? ((GtkToggleButton*) _tmp45_) : NULL);
	_g_object_unref0 (self->priv->photo_toggle_button);
	self->priv->photo_toggle_button = _tmp46_;
	_tmp47_ = self->priv->gtk_builder;
	_tmp48_ = gtk_builder_get_object (_tmp47_, "video_toggle_button");
	_tmp49_ = _g_object_ref0 (GTK_IS_TOGGLE_BUTTON (_tmp48_) ? ((GtkToggleButton*) _tmp48_) : NULL);
	_g_object_unref0 (self->priv->video_toggle_button);
	self->priv->video_toggle_button = _tmp49_;
	_tmp50_ = self->priv->gtk_builder;
	_tmp51_ = gtk_builder_get_object (_tmp50_, "burst_toggle_button");
	_tmp52_ = _g_object_ref0 (GTK_IS_TOGGLE_BUTTON (_tmp51_) ? ((GtkToggleButton*) _tmp51_) : NULL);
	_g_object_unref0 (self->priv->burst_toggle_button);
	self->priv->burst_toggle_button = _tmp52_;
	_tmp53_ = self->priv->gtk_builder;
	_tmp54_ = gtk_builder_get_object (_tmp53_, "take_action_button");
	_tmp55_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp54_) ? ((GtkButton*) _tmp54_) : NULL);
	_g_object_unref0 (self->priv->take_action_button);
	self->priv->take_action_button = _tmp55_;
	_tmp56_ = self->priv->gtk_builder;
	_tmp57_ = gtk_builder_get_object (_tmp56_, "take_action_button_internal_label");
	_tmp58_ = _g_object_ref0 (GTK_IS_LABEL (_tmp57_) ? ((GtkLabel*) _tmp57_) : NULL);
	_g_object_unref0 (self->priv->take_action_button_label);
	self->priv->take_action_button_label = _tmp58_;
	_tmp59_ = self->priv->gtk_builder;
	_tmp60_ = gtk_builder_get_object (_tmp59_, "take_action_button_internal_image");
	_tmp61_ = _g_object_ref0 (GTK_IS_IMAGE (_tmp60_) ? ((GtkImage*) _tmp60_) : NULL);
	_g_object_unref0 (self->priv->take_action_button_image);
	self->priv->take_action_button_image = _tmp61_;
	_tmp62_ = self->priv->gtk_builder;
	_tmp63_ = gtk_builder_get_object (_tmp62_, "effects_toggle_button");
	_tmp64_ = _g_object_ref0 (GTK_IS_TOGGLE_BUTTON (_tmp63_) ? ((GtkToggleButton*) _tmp63_) : NULL);
	_g_object_unref0 (self->priv->effects_toggle_button);
	self->priv->effects_toggle_button = _tmp64_;
	_tmp65_ = self->priv->gtk_builder;
	_tmp66_ = gtk_builder_get_object (_tmp65_, "leave_fullscreen_button");
	_tmp67_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp66_) ? ((GtkButton*) _tmp66_) : NULL);
	_g_object_unref0 (self->priv->leave_fullscreen_button);
	self->priv->leave_fullscreen_button = _tmp67_;
	_tmp68_ = self->priv->gtk_builder;
	_tmp69_ = gtk_builder_get_object (_tmp68_, "buttons_area");
	_tmp70_ = _g_object_ref0 (GTK_IS_BOX (_tmp69_) ? ((GtkBox*) _tmp69_) : NULL);
	_g_object_unref0 (self->priv->buttons_area);
	self->priv->buttons_area = _tmp70_;
	_tmp71_ = self->priv->gtk_builder;
	_tmp72_ = gtk_builder_get_object (_tmp71_, "thumbnail_popup");
	_tmp73_ = _g_object_ref0 (GTK_IS_MENU (_tmp72_) ? ((GtkMenu*) _tmp72_) : NULL);
	_g_object_unref0 (self->priv->thumbnail_popup);
	self->priv->thumbnail_popup = _tmp73_;
	_tmp74_ = self->priv->gtk_builder;
	_tmp75_ = gtk_builder_get_object (_tmp74_, "main_actions");
	_tmp76_ = _g_object_ref0 (GTK_IS_ACTION_GROUP (_tmp75_) ? ((GtkActionGroup*) _tmp75_) : NULL);
	_g_object_unref0 (self->priv->main_actions);
	self->priv->main_actions = _tmp76_;
	_tmp77_ = self->priv->gtk_builder;
	_tmp78_ = gtk_builder_get_object (_tmp77_, "take_photo");
	_tmp79_ = _g_object_ref0 (GTK_IS_ACTION (_tmp78_) ? ((GtkAction*) _tmp78_) : NULL);
	_g_object_unref0 (self->priv->take_photo_action);
	self->priv->take_photo_action = _tmp79_;
	_tmp80_ = self->priv->gtk_builder;
	_tmp81_ = gtk_builder_get_object (_tmp80_, "take_video");
	_tmp82_ = _g_object_ref0 (GTK_IS_ACTION (_tmp81_) ? ((GtkAction*) _tmp81_) : NULL);
	_g_object_unref0 (self->priv->take_video_action);
	self->priv->take_video_action = _tmp82_;
	_tmp83_ = self->priv->gtk_builder;
	_tmp84_ = gtk_builder_get_object (_tmp83_, "take_burst");
	_tmp85_ = _g_object_ref0 (GTK_IS_ACTION (_tmp84_) ? ((GtkAction*) _tmp84_) : NULL);
	_g_object_unref0 (self->priv->take_burst_action);
	self->priv->take_burst_action = _tmp85_;
	_tmp86_ = self->priv->gtk_builder;
	_tmp87_ = gtk_builder_get_object (_tmp86_, "photo_mode");
	_tmp88_ = _g_object_ref0 (GTK_IS_ACTION (_tmp87_) ? ((GtkAction*) _tmp87_) : NULL);
	_g_object_unref0 (self->priv->photo_mode_action);
	self->priv->photo_mode_action = _tmp88_;
	_tmp89_ = self->priv->gtk_builder;
	_tmp90_ = gtk_builder_get_object (_tmp89_, "video_mode");
	_tmp91_ = _g_object_ref0 (GTK_IS_ACTION (_tmp90_) ? ((GtkAction*) _tmp90_) : NULL);
	_g_object_unref0 (self->priv->video_mode_action);
	self->priv->video_mode_action = _tmp91_;
	_tmp92_ = self->priv->gtk_builder;
	_tmp93_ = gtk_builder_get_object (_tmp92_, "burst_mode");
	_tmp94_ = _g_object_ref0 (GTK_IS_ACTION (_tmp93_) ? ((GtkAction*) _tmp93_) : NULL);
	_g_object_unref0 (self->priv->burst_mode_action);
	self->priv->burst_mode_action = _tmp94_;
	_tmp95_ = self->priv->gtk_builder;
	_tmp96_ = gtk_builder_get_object (_tmp95_, "effects_toggle");
	_tmp97_ = _g_object_ref0 (GTK_IS_TOGGLE_ACTION (_tmp96_) ? ((GtkToggleAction*) _tmp96_) : NULL);
	_g_object_unref0 (self->priv->effects_toggle_action);
	self->priv->effects_toggle_action = _tmp97_;
	_tmp98_ = self->priv->gtk_builder;
	_tmp99_ = gtk_builder_get_object (_tmp98_, "countdown");
	_tmp100_ = _g_object_ref0 (GTK_IS_ACTION (_tmp99_) ? ((GtkAction*) _tmp99_) : NULL);
	_g_object_unref0 (self->priv->countdown_action);
	self->priv->countdown_action = _tmp100_;
	_tmp101_ = self->priv->gtk_builder;
	_tmp102_ = gtk_builder_get_object (_tmp101_, "wide_mode");
	_tmp103_ = _g_object_ref0 (GTK_IS_TOGGLE_ACTION (_tmp102_) ? ((GtkToggleAction*) _tmp102_) : NULL);
	_g_object_unref0 (self->priv->wide_mode_action);
	self->priv->wide_mode_action = _tmp103_;
	_tmp104_ = self->priv->gtk_builder;
	_tmp105_ = gtk_builder_get_object (_tmp104_, "fullscreen");
	_tmp106_ = _g_object_ref0 (GTK_IS_TOGGLE_ACTION (_tmp105_) ? ((GtkToggleAction*) _tmp105_) : NULL);
	_g_object_unref0 (self->priv->fullscreen_action);
	self->priv->fullscreen_action = _tmp106_;
	_tmp107_ = self->priv->gtk_builder;
	_tmp108_ = gtk_builder_get_object (_tmp107_, "effects_page_next");
	_tmp109_ = _g_object_ref0 (GTK_IS_ACTION (_tmp108_) ? ((GtkAction*) _tmp108_) : NULL);
	_g_object_unref0 (self->priv->effects_page_next_action);
	self->priv->effects_page_next_action = _tmp109_;
	_tmp110_ = self->priv->gtk_builder;
	_tmp111_ = gtk_builder_get_object (_tmp110_, "effects_page_prev");
	_tmp112_ = _g_object_ref0 (GTK_IS_ACTION (_tmp111_) ? ((GtkAction*) _tmp111_) : NULL);
	_g_object_unref0 (self->priv->effects_page_prev_action);
	self->priv->effects_page_prev_action = _tmp112_;
	_tmp113_ = self->priv->gtk_builder;
	_tmp114_ = gtk_builder_get_object (_tmp113_, "share");
	_tmp115_ = _g_object_ref0 (GTK_IS_ACTION (_tmp114_) ? ((GtkAction*) _tmp114_) : NULL);
	_g_object_unref0 (self->priv->share_action);
	self->priv->share_action = _tmp115_;
	_tmp116_ = cheese_shareable_media_new (self);
	_g_object_unref0 (self->priv->shareable_media);
	self->priv->shareable_media = _tmp116_;
	_tmp117_ = self->priv->main_actions;
	g_signal_connect_object (_tmp117_, "pre-activate", (GCallback) _cheese_main_window_on_action_pre_activated_gtk_action_group_pre_activate, self, 0);
	_tmp118_ = self->priv->photo_toggle_button;
	_tmp119_ = _g_object_ref0 ((GtkButton*) _tmp118_);
	_tmp120_ = self->priv->video_toggle_button;
	_tmp121_ = _g_object_ref0 ((GtkButton*) _tmp120_);
	_tmp122_ = self->priv->burst_toggle_button;
	_tmp123_ = _g_object_ref0 ((GtkButton*) _tmp122_);
	_tmp124_ = self->priv->take_action_button;
	_tmp125_ = _g_object_ref0 (_tmp124_);
	_tmp126_ = self->priv->effects_toggle_button;
	_tmp127_ = _g_object_ref0 ((GtkButton*) _tmp126_);
	_tmp128_ = self->priv->leave_fullscreen_button;
	_tmp129_ = _g_object_ref0 (_tmp128_);
	_tmp130_ = g_new0 (GtkButton*, 6 + 1);
	_tmp130_[0] = _tmp119_;
	_tmp130_[1] = _tmp121_;
	_tmp130_[2] = _tmp123_;
	_tmp130_[3] = _tmp125_;
	_tmp130_[4] = _tmp127_;
	_tmp130_[5] = _tmp129_;
	self->priv->buttons = (_vala_array_free (self->priv->buttons, self->priv->buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->buttons = _tmp130_;
	self->priv->buttons_length1 = 6;
	self->priv->_buttons_size_ = self->priv->buttons_length1;
	_tmp131_ = self->priv->clutter_builder;
	_tmp132_ = clutter_script_get_object (_tmp131_, "video_preview");
	_tmp133_ = _g_object_ref0 (CLUTTER_IS_TEXTURE (_tmp132_) ? ((ClutterTexture*) _tmp132_) : NULL);
	_g_object_unref0 (self->priv->video_preview);
	self->priv->video_preview = _tmp133_;
	_tmp134_ = self->priv->clutter_builder;
	_tmp135_ = clutter_script_get_object (_tmp134_, "viewport_layout");
	_tmp136_ = _g_object_ref0 (CLUTTER_IS_BOX (_tmp135_) ? ((ClutterBox*) _tmp135_) : NULL);
	_g_object_unref0 (self->priv->viewport_layout);
	self->priv->viewport_layout = _tmp136_;
	_tmp137_ = self->priv->clutter_builder;
	_tmp138_ = clutter_script_get_object (_tmp137_, "viewport_layout_manager");
	_tmp139_ = _g_object_ref0 (CLUTTER_IS_BIN_LAYOUT (_tmp138_) ? ((ClutterBinLayout*) _tmp138_) : NULL);
	_g_object_unref0 (self->priv->viewport_layout_manager);
	self->priv->viewport_layout_manager = _tmp139_;
	_tmp140_ = self->priv->clutter_builder;
	_tmp141_ = clutter_script_get_object (_tmp140_, "countdown_layer");
	_tmp142_ = _g_object_ref0 (CLUTTER_IS_TEXT (_tmp141_) ? ((ClutterText*) _tmp141_) : NULL);
	_g_object_unref0 (self->priv->countdown_layer);
	self->priv->countdown_layer = _tmp142_;
	_tmp143_ = self->priv->clutter_builder;
	_tmp144_ = clutter_script_get_object (_tmp143_, "background");
	_tmp145_ = _g_object_ref0 (CLUTTER_IS_RECTANGLE (_tmp144_) ? ((ClutterRectangle*) _tmp144_) : NULL);
	_g_object_unref0 (self->priv->background_layer);
	self->priv->background_layer = _tmp145_;
	_tmp146_ = self->priv->clutter_builder;
	_tmp147_ = clutter_script_get_object (_tmp146_, "error_layer");
	_tmp148_ = _g_object_ref0 (CLUTTER_IS_TEXT (_tmp147_) ? ((ClutterText*) _tmp147_) : NULL);
	_g_object_unref0 (self->priv->error_layer);
	self->priv->error_layer = _tmp148_;
	_tmp149_ = self->priv->video_preview;
	clutter_texture_set_keep_aspect_ratio (_tmp149_, TRUE);
	_tmp150_ = self->priv->video_preview;
	clutter_actor_set_request_mode ((ClutterActor*) _tmp150_, CLUTTER_REQUEST_HEIGHT_FOR_WIDTH);
	_tmp151_ = self->priv->viewport;
	_tmp152_ = self->priv->background_layer;
	clutter_container_add_actor ((ClutterContainer*) _tmp151_, (ClutterActor*) _tmp152_);
	_tmp153_ = self->priv->viewport_layout;
	_tmp154_ = self->priv->viewport_layout_manager;
	clutter_box_set_layout_manager (_tmp153_, (ClutterLayoutManager*) _tmp154_);
	_tmp155_ = self->priv->viewport;
	_tmp156_ = self->priv->viewport_layout;
	clutter_container_add_actor ((ClutterContainer*) _tmp155_, (ClutterActor*) _tmp156_);
	_tmp157_ = self->priv->viewport;
	g_signal_connect_object ((ClutterActor*) _tmp157_, "allocation-changed", (GCallback) _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed, self, 0);
	_tmp158_ = cheese_thumb_view_new ();
	_tmp159_ = g_object_ref_sink (_tmp158_);
	_g_object_unref0 (self->priv->thumb_view);
	self->priv->thumb_view = _tmp159_;
	_tmp160_ = self->priv->thumb_view;
	_tmp161_ = eog_thumb_nav_new ((GtkWidget*) _tmp160_, FALSE);
	_tmp162_ = g_object_ref_sink (_tmp161_);
	_g_object_unref0 (self->priv->thumb_nav);
	self->priv->thumb_nav = _tmp162_;
	{
		GtkCssProvider* _tmp163_;
		gchar* _tmp164_ = NULL;
		gchar* _tmp165_;
		_tmp163_ = gtk_css_provider_new ();
		_g_object_unref0 (css);
		css = _tmp163_;
		_tmp164_ = g_build_filename (PACKAGE_DATADIR, "cheese.css", NULL);
		_tmp165_ = _tmp164_;
		gtk_css_provider_load_from_path (css, _tmp165_, &_inner_error_);
		_g_free0 (_tmp165_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		FILE* _tmp166_;
		GError* _tmp167_;
		const gchar* _tmp168_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp166_ = stdout;
		_tmp167_ = e;
		_tmp168_ = _tmp167_->message;
		fprintf (_tmp166_, "Error: %s\n", _tmp168_);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (css);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp169_ = self->priv->thumb_view;
	_tmp170_ = gtk_widget_get_style_context ((GtkWidget*) _tmp169_);
	_tmp171_ = _g_object_ref0 (_tmp170_);
	_g_object_unref0 (context);
	context = _tmp171_;
	_tmp172_ = gdk_screen_get_default ();
	gtk_window_set_screen ((GtkWindow*) self, _tmp172_);
	_tmp173_ = context;
	_tmp174_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp175_ = _tmp174_;
	gtk_style_context_add_provider_for_screen (_tmp175_, (GtkStyleProvider*) css, (guint) GTK_STYLE_PROVIDER_PRIORITY_USER);
	_tmp176_ = self->priv->thumb_view;
	g_signal_connect_object ((GtkWidget*) _tmp176_, "button-press-event", (GCallback) _cheese_main_window_on_thumbnail_mouse_button_press_gtk_widget_button_press_event, self, 0);
	_tmp177_ = self->priv->main_vbox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp177_);
	_tmp178_ = self->priv->main_vbox;
	gtk_widget_show_all ((GtkWidget*) _tmp178_);
	_tmp179_ = self->priv->viewport_widget;
	gtk_widget_realize ((GtkWidget*) _tmp179_);
	_tmp180_ = self->priv->wide_mode_action;
	_tmp181_ = self->priv->settings;
	_tmp182_ = g_settings_get_boolean (_tmp181_, "wide-mode");
	gtk_toggle_action_set_active (_tmp180_, _tmp182_);
	_tmp183_ = self->priv->settings;
	_tmp184_ = g_settings_get_boolean (_tmp183_, "wide-mode");
	if (!_tmp184_) {
		GtkToggleAction* _tmp185_;
		_tmp185_ = self->priv->wide_mode_action;
		gtk_toggle_action_toggled (_tmp185_);
	}
	cheese_main_window_set_mode (self, CHEESE_MEDIA_MODE_PHOTO);
	cheese_main_window_setup_effects_selector (self);
	cheese_main_window_toggle_camera_actions_sensitivities (self, FALSE);
	g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) _cheese_main_window_on_key_release_gtk_widget_key_release_event, self, 0);
	_tmp186_ = self->priv->settings;
	_tmp187_ = g_settings_get_boolean (_tmp186_, "fullscreen");
	if (_tmp187_) {
		GtkToggleAction* _tmp188_;
		_tmp188_ = self->priv->fullscreen_action;
		gtk_toggle_action_set_active (_tmp188_, TRUE);
	}
	_g_object_unref0 (context);
	_g_object_unref0 (css);
}


/**
   * Decide which actions will be sensitive or insensitive.
   *
   * @param action the action that emitted the signal.
   */
void cheese_main_window_on_action_pre_activated (CheeseMainWindow* self, GtkAction* action) {
	GCompareFunc _tmp0_;
	GtkAction* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_strcmp0;
	_tmp1_ = action;
	_tmp2_ = gtk_buildable_get_name ((GtkBuildable*) _tmp1_);
	_tmp3_ = _tmp0_ (_tmp2_, "edit_action");
	if (_tmp3_ == 0) {
		CheeseThumbView* _tmp4_;
		GList* _tmp5_ = NULL;
		GList* _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = self->priv->thumb_view;
		_tmp5_ = cheese_thumb_view_get_selected_images_list (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_ == NULL;
		__g_list_free__g_object_unref0_0 (_tmp6_);
		if (_tmp7_) {
			GtkAction* _tmp8_;
			_tmp8_ = self->priv->share_action;
			gtk_action_set_sensitive (_tmp8_, FALSE);
		} else {
			GtkAction* _tmp9_;
			_tmp9_ = self->priv->share_action;
			gtk_action_set_sensitive (_tmp9_, TRUE);
		}
	}
}


/**
   * Setup the camera listed in GSettings.
   *
   * @param uri the uri of the device node to setup, or null
   */
static void _cheese_main_window_camera_state_changed_cheese_camera_state_flags_changed (CheeseCamera* _sender, GstState new_state, gpointer self) {
	cheese_main_window_camera_state_changed (self, new_state);
}


void cheese_main_window_setup_camera (CheeseMainWindow* self, const gchar* uri) {
	gchar* device = NULL;
	gdouble value = 0.0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp5_;
	ClutterTexture* _tmp10_;
	const gchar* _tmp11_;
	GSettings* _tmp12_;
	gint _tmp13_ = 0;
	GSettings* _tmp14_;
	gint _tmp15_ = 0;
	CheeseCamera* _tmp16_;
	GSettings* _tmp26_;
	gdouble _tmp27_ = 0.0;
	gdouble _tmp28_;
	GSettings* _tmp31_;
	gdouble _tmp32_ = 0.0;
	gdouble _tmp33_;
	GSettings* _tmp36_;
	gdouble _tmp37_ = 0.0;
	gdouble _tmp38_;
	GSettings* _tmp41_;
	gdouble _tmp42_ = 0.0;
	gdouble _tmp43_;
	CheeseCamera* _tmp46_;
	CheeseCamera* _tmp47_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = uri;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = uri;
		_tmp3_ = strlen (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = uri;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (device);
		device = _tmp7_;
	} else {
		GSettings* _tmp8_;
		gchar* _tmp9_ = NULL;
		_tmp8_ = self->priv->settings;
		_tmp9_ = g_settings_get_string (_tmp8_, "camera");
		_g_free0 (device);
		device = _tmp9_;
	}
	_tmp10_ = self->priv->video_preview;
	_tmp11_ = device;
	_tmp12_ = self->priv->settings;
	_tmp13_ = g_settings_get_int (_tmp12_, "photo-x-resolution");
	_tmp14_ = self->priv->settings;
	_tmp15_ = g_settings_get_int (_tmp14_, "photo-y-resolution");
	_tmp16_ = cheese_camera_new (_tmp10_, _tmp11_, _tmp13_, _tmp15_);
	_g_object_unref0 (self->priv->camera);
	self->priv->camera = _tmp16_;
	{
		CheeseCamera* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = self->priv->camera;
		_tmp18_ = device;
		cheese_camera_setup (_tmp17_, _tmp18_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* err = NULL;
		ClutterTexture* _tmp19_;
		GError* _tmp20_;
		const gchar* _tmp21_;
		ClutterText* _tmp22_;
		GError* _tmp23_;
		const gchar* _tmp24_;
		ClutterText* _tmp25_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = self->priv->video_preview;
		clutter_actor_hide ((ClutterActor*) _tmp19_);
		_tmp20_ = err;
		_tmp21_ = _tmp20_->message;
		g_warning ("cheese-window.vala:1585: Error: %s\n", _tmp21_);
		_tmp22_ = self->priv->error_layer;
		_tmp23_ = err;
		_tmp24_ = _tmp23_->message;
		clutter_text_set_text (_tmp22_, _tmp24_);
		_tmp25_ = self->priv->error_layer;
		clutter_actor_show ((ClutterActor*) _tmp25_);
		cheese_main_window_toggle_camera_actions_sensitivities (self, FALSE);
		_g_error_free0 (err);
		_g_free0 (device);
		return;
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_free0 (device);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp26_ = self->priv->settings;
	_tmp27_ = g_settings_get_double (_tmp26_, "brightness");
	value = _tmp27_;
	_tmp28_ = value;
	if (_tmp28_ != 0.0) {
		CheeseCamera* _tmp29_;
		gdouble _tmp30_;
		_tmp29_ = self->priv->camera;
		_tmp30_ = value;
		cheese_camera_set_balance_property (_tmp29_, "brightness", _tmp30_);
	}
	_tmp31_ = self->priv->settings;
	_tmp32_ = g_settings_get_double (_tmp31_, "contrast");
	value = _tmp32_;
	_tmp33_ = value;
	if (_tmp33_ != 1.0) {
		CheeseCamera* _tmp34_;
		gdouble _tmp35_;
		_tmp34_ = self->priv->camera;
		_tmp35_ = value;
		cheese_camera_set_balance_property (_tmp34_, "contrast", _tmp35_);
	}
	_tmp36_ = self->priv->settings;
	_tmp37_ = g_settings_get_double (_tmp36_, "hue");
	value = _tmp37_;
	_tmp38_ = value;
	if (_tmp38_ != 0.0) {
		CheeseCamera* _tmp39_;
		gdouble _tmp40_;
		_tmp39_ = self->priv->camera;
		_tmp40_ = value;
		cheese_camera_set_balance_property (_tmp39_, "hue", _tmp40_);
	}
	_tmp41_ = self->priv->settings;
	_tmp42_ = g_settings_get_double (_tmp41_, "saturation");
	value = _tmp42_;
	_tmp43_ = value;
	if (_tmp43_ != 1.0) {
		CheeseCamera* _tmp44_;
		gdouble _tmp45_;
		_tmp44_ = self->priv->camera;
		_tmp45_ = value;
		cheese_camera_set_balance_property (_tmp44_, "saturation", _tmp45_);
	}
	_tmp46_ = self->priv->camera;
	g_signal_connect_object (_tmp46_, "state-flags-changed", (GCallback) _cheese_main_window_camera_state_changed_cheese_camera_state_flags_changed, self, 0);
	_tmp47_ = self->priv->camera;
	cheese_camera_play (_tmp47_);
	_g_free0 (device);
}


/**
   * Setup the thumbview thumbnail monitors.
   */
void cheese_main_window_start_thumbview_monitors (CheeseMainWindow* self) {
	CheeseThumbView* _tmp0_;
	CheeseFileUtil* _tmp1_;
	const gchar* _tmp2_ = NULL;
	CheeseThumbView* _tmp3_;
	CheeseFileUtil* _tmp4_;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thumb_view;
	_tmp1_ = self->priv->fileutil;
	_tmp2_ = cheese_fileutil_get_video_path (_tmp1_);
	cheese_thumb_view_start_monitoring_video_path (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->thumb_view;
	_tmp4_ = self->priv->fileutil;
	_tmp5_ = cheese_fileutil_get_photo_path (_tmp4_);
	cheese_thumb_view_start_monitoring_photo_path (_tmp3_, _tmp5_);
}


CheeseMainWindow* cheese_main_window_construct (GType object_type) {
	CheeseMainWindow * self = NULL;
	self = (CheeseMainWindow*) g_object_new (object_type, NULL);
	return self;
}


CheeseMainWindow* cheese_main_window_new (void) {
	return cheese_main_window_construct (CHEESE_TYPE_MAIN_WINDOW);
}


static void cheese_main_window_class_init (CheeseMainWindowClass * klass) {
	cheese_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheeseMainWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = cheese_main_window_finalize;
}


static void cheese_main_window_instance_init (CheeseMainWindow * self) {
	self->priv = CHEESE_MAIN_WINDOW_GET_PRIVATE (self);
	self->priv->current_effects_page = 0;
}


static void cheese_main_window_finalize (GObject* obj) {
	CheeseMainWindow * self;
	self = CHEESE_MAIN_WINDOW (obj);
	_g_object_unref0 (self->priv->gtk_builder);
	_g_object_unref0 (self->priv->clutter_builder);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->thumbnails);
	_g_object_unref0 (self->priv->viewport_widget);
	_g_object_unref0 (self->priv->main_vbox);
	_g_object_unref0 (self->priv->thumb_nav);
	_g_object_unref0 (self->priv->thumb_view);
	_g_object_unref0 (self->priv->thumbnails_right);
	_g_object_unref0 (self->priv->thumbnails_bottom);
	_g_object_unref0 (self->priv->menubar);
	_g_object_unref0 (self->priv->leave_fullscreen_button_container);
	_g_object_unref0 (self->priv->photo_toggle_button);
	_g_object_unref0 (self->priv->video_toggle_button);
	_g_object_unref0 (self->priv->burst_toggle_button);
	_g_object_unref0 (self->priv->take_action_button);
	_g_object_unref0 (self->priv->take_action_button_label);
	_g_object_unref0 (self->priv->take_action_button_image);
	_g_object_unref0 (self->priv->effects_toggle_button);
	_g_object_unref0 (self->priv->leave_fullscreen_button);
	_g_object_unref0 (self->priv->buttons_area);
	_g_object_unref0 (self->priv->thumbnail_popup);
	_g_object_unref0 (self->priv->viewport);
	_g_object_unref0 (self->priv->viewport_layout);
	_g_object_unref0 (self->priv->video_preview);
	_g_object_unref0 (self->priv->viewport_layout_manager);
	_g_object_unref0 (self->priv->countdown_layer);
	_g_object_unref0 (self->priv->background_layer);
	_g_object_unref0 (self->priv->error_layer);
	_g_object_unref0 (self->priv->current_effects_grid);
	_g_object_unref0 (self->priv->effects_grids);
	_g_object_unref0 (self->priv->take_photo_action);
	_g_object_unref0 (self->priv->take_video_action);
	_g_object_unref0 (self->priv->take_burst_action);
	_g_object_unref0 (self->priv->photo_mode_action);
	_g_object_unref0 (self->priv->video_mode_action);
	_g_object_unref0 (self->priv->burst_mode_action);
	_g_object_unref0 (self->priv->effects_toggle_action);
	_g_object_unref0 (self->priv->wide_mode_action);
	_g_object_unref0 (self->priv->fullscreen_action);
	_g_object_unref0 (self->priv->countdown_action);
	_g_object_unref0 (self->priv->effects_page_prev_action);
	_g_object_unref0 (self->priv->effects_page_next_action);
	_g_object_unref0 (self->priv->share_action);
	_g_object_unref0 (self->priv->main_actions);
	self->priv->buttons = (_vala_array_free (self->priv->buttons, self->priv->buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->camera);
	_g_object_unref0 (self->priv->fileutil);
	_g_object_unref0 (self->priv->flash);
	_g_object_unref0 (self->priv->effects_manager);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->selected_effect);
	_g_object_unref0 (self->priv->shareable_media);
	_g_source_unref0 (self->priv->fullscreen_timeout);
	_g_object_unref0 (self->priv->current_countdown);
	_g_object_unref0 (self->priv->action_sensitivities);
	G_OBJECT_CLASS (cheese_main_window_parent_class)->finalize (obj);
}


GType cheese_main_window_get_type (void) {
	static volatile gsize cheese_main_window_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheeseMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseMainWindow), 0, (GInstanceInitFunc) cheese_main_window_instance_init, NULL };
		GType cheese_main_window_type_id;
		cheese_main_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "CheeseMainWindow", &g_define_type_info, 0);
		g_once_init_leave (&cheese_main_window_type_id__volatile, cheese_main_window_type_id);
	}
	return cheese_main_window_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



