////////////////////////////////////////////////////////////////////////////////
// checkstyle: Checks Java source code for adherence to a set of rules.
// Copyright (C) 2001-2019 the original author or authors.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
////////////////////////////////////////////////////////////////////////////////

package org.checkstyle.suppressionxpathfilter;

import java.io.File;
import java.util.Arrays;
import java.util.List;

import org.junit.Test;

import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.checks.sizes.AnonInnerLengthCheck;

public class XpathRegressionAnonInnerLengthTest extends AbstractXpathTestSupport {

    private final String checkName = AnonInnerLengthCheck.class.getSimpleName();

    @Override
    protected String getCheckName() {
        return checkName;
    }

    @Test
    public void testMaxLength() throws Exception {
        final int maxLen = 5;
        final File fileToProcess =
                new File(getPath("SuppressionXpathRegressionAnonInnerLength.java"));

        final DefaultConfiguration moduleConfig =
                createModuleConfig(AnonInnerLengthCheck.class);
        moduleConfig.addAttribute("max", String.valueOf(maxLen));

        final String[] expectedViolation = {
            "7:41: " + getCheckMessage(AnonInnerLengthCheck.class,
                    AnonInnerLengthCheck.MSG_KEY, 6, maxLen),
        };

        final List<String> expectedXpathQueries = Arrays.asList(
                "/CLASS_DEF[./IDENT[@text='SuppressionXpathRegressionAnonInnerLength']]"
                        + "/OBJBLOCK/METHOD_DEF[./IDENT[@text='compare']]/SLIST"
                        + "/VARIABLE_DEF[./IDENT[@text='comparator']]/ASSIGN/EXPR",
                "/CLASS_DEF[./IDENT[@text='SuppressionXpathRegressionAnonInnerLength']]"
                        + "/OBJBLOCK/METHOD_DEF[./IDENT[@text='compare']]/SLIST"
                        + "/VARIABLE_DEF[./IDENT[@text='comparator']]/ASSIGN/EXPR"
                        + "/LITERAL_NEW[./IDENT[@text='Comparator']]"
        );

        runVerifications(moduleConfig, fileToProcess, expectedViolation,
                expectedXpathQueries);
    }

}
