////////////////////////////////////////////////////////////////////////////////
// checkstyle: Checks Java source code for adherence to a set of rules.
// Copyright (C) 2001-2015 the original author or authors.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
////////////////////////////////////////////////////////////////////////////////

package com.puppycrawl.tools.checkstyle.grammars.javadoc;

import javax.annotation.Generated;

import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.tree.ParseTree;

import com.puppycrawl.tools.checkstyle.api.JavadocTokenTypes;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.AttributeContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.BrTagContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.DdTagOpenContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.DescriptionContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.DtTagCloseContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.HtmlCommentContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.HtmlElementCloseContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.HtmlElementContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.HtmlElementOpenContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.HtmlTagContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.JavadocContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.JavadocInlineTagContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.JavadocTagContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.LiContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.LiTagCloseContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.LiTagOpenContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.PTagCloseContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.PTagOpenContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.ParagraphContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.ParametersContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.ReferenceContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.SingletonElementContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.TextContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.TrContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.TrTagCloseContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.TrTagOpenContext;

/**
 * The class is used for testing. It builds expected ParseTree of javadoc comments.
 * All methods of this class were generated by ExpectedParseTreeGenerator.
 * It is located in 'contribution' repository:
 * <a href="https://github.com/checkstyle/contribution/blob/master/javadoc-expected-tree-generator/ExpectedParseTreeGenerator.java">Link</a>
 */
@Generated("ExpectedParseTreeGenerator")
//@formatter:off
final class ParseTreeBuilder {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private ParseTreeBuilder() {
    }

    public static ParseTree treeLeadingAsterisks()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        CommonToken newline0 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline0);
        CommonToken leadingAsterisk0 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, "  *");
        javadocContext0.addChild(leadingAsterisk0);
        TextContext textContext0 = new TextContext(javadocContext0, 0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "L");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext0.addChild(char2);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext0.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext0.addChild(char4);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext0.addChild(char5);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "g");
        textContext0.addChild(char6);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws1);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext0.addChild(char7);
        CommonToken char8 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext0.addChild(char8);
        CommonToken char9 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext0.addChild(char9);
        CommonToken char10 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char10);
        CommonToken char11 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext0.addChild(char11);
        CommonToken char12 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext0.addChild(char12);
        CommonToken char13 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext0.addChild(char13);
        CommonToken char14 = new CommonToken(JavadocTokenTypes.CHAR, "k");
        textContext0.addChild(char14);
        javadocContext0.addChild(textContext0);
        CommonToken newline1 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline1);
        CommonToken leadingAsterisk1 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, "    *");
        javadocContext0.addChild(leadingAsterisk1);
        TextContext textContext1 = new TextContext(javadocContext0, 0);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext1.addChild(ws2);
        CommonToken char15 = new CommonToken(JavadocTokenTypes.CHAR, "A");
        textContext1.addChild(char15);
        CommonToken char16 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext1.addChild(char16);
        CommonToken char17 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext1.addChild(char17);
        CommonToken char18 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext1.addChild(char18);
        CommonToken char19 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext1.addChild(char19);
        CommonToken char20 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext1.addChild(char20);
        CommonToken char21 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext1.addChild(char21);
        CommonToken ws3 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext1.addChild(ws3);
        CommonToken char22 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext1.addChild(char22);
        CommonToken char23 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext1.addChild(char23);
        CommonToken char24 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext1.addChild(char24);
        javadocContext0.addChild(textContext1);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeAttributeValueWithoutQuotes()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        HtmlElementContext htmlElementContext0 = new HtmlElementContext(javadocContext0, 0);
        HtmlTagContext htmlTagContext0 = new HtmlTagContext(htmlElementContext0, 0);
        HtmlElementOpenContext htmlElementOpenContext0 = new HtmlElementOpenContext(htmlTagContext0, 0);
        CommonToken open0 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementOpenContext0.addChild(open0);
        CommonToken htmlTagName0 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "a");
        htmlElementOpenContext0.addChild(htmlTagName0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        htmlElementOpenContext0.addChild(ws0);
        AttributeContext attributeContext0 = new AttributeContext(htmlElementOpenContext0, 0);
        CommonToken htmlTagName1 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "href");
        attributeContext0.addChild(htmlTagName1);
        CommonToken equals0 = new CommonToken(JavadocTokenTypes.EQUALS, "=");
        attributeContext0.addChild(equals0);
        CommonToken attrValue0 = new CommonToken(JavadocTokenTypes.ATTR_VALUE, "http://www.ietf.org/rfc/rfc3758.txt");
        attributeContext0.addChild(attrValue0);
        htmlElementOpenContext0.addChild(attributeContext0);
        CommonToken close0 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementOpenContext0.addChild(close0);
        htmlTagContext0.addChild(htmlElementOpenContext0);
        TextContext textContext0 = new TextContext(htmlTagContext0, 0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "R");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "F");
        textContext0.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "C");
        textContext0.addChild(char2);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws1);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "3");
        textContext0.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "7");
        textContext0.addChild(char4);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "5");
        textContext0.addChild(char5);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "8");
        textContext0.addChild(char6);
        htmlTagContext0.addChild(textContext0);
        HtmlElementCloseContext htmlElementCloseContext0 = new HtmlElementCloseContext(htmlTagContext0, 0);
        CommonToken open1 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementCloseContext0.addChild(open1);
        CommonToken slash0 = new CommonToken(JavadocTokenTypes.SLASH, "/");
        htmlElementCloseContext0.addChild(slash0);
        CommonToken htmlTagName2 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "a");
        htmlElementCloseContext0.addChild(htmlTagName2);
        CommonToken close1 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementCloseContext0.addChild(close1);
        htmlTagContext0.addChild(htmlElementCloseContext0);
        htmlElementContext0.addChild(htmlTagContext0);
        javadocContext0.addChild(htmlElementContext0);
        TextContext textContext1 = new TextContext(javadocContext0, 0);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext1.addChild(char7);
        javadocContext0.addChild(textContext1);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeClosedOtherTag()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        TextContext textContext0 = new TextContext(javadocContext0, 0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws0);
        javadocContext0.addChild(textContext0);
        HtmlElementContext htmlElementContext0 = new HtmlElementContext(javadocContext0, 0);
        DdTagOpenContext ddTagOpenContext0 = new DdTagOpenContext(htmlElementContext0, 0);
        CommonToken open0 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        ddTagOpenContext0.addChild(open0);
        CommonToken ddHtmlTagName0 = new CommonToken(JavadocTokenTypes.DD_HTML_TAG_NAME, "dd");
        ddTagOpenContext0.addChild(ddHtmlTagName0);
        CommonToken close0 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        ddTagOpenContext0.addChild(close0);
        htmlElementContext0.addChild(ddTagOpenContext0);
        javadocContext0.addChild(htmlElementContext0);
        HtmlElementContext htmlElementContext1 = new HtmlElementContext(javadocContext0, 0);
        DtTagCloseContext dtTagCloseContext0 = new DtTagCloseContext(htmlElementContext1, 0);
        CommonToken open1 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        dtTagCloseContext0.addChild(open1);
        CommonToken slash0 = new CommonToken(JavadocTokenTypes.SLASH, "/");
        dtTagCloseContext0.addChild(slash0);
        CommonToken dtHtmlTagName0 = new CommonToken(JavadocTokenTypes.DT_HTML_TAG_NAME, "dt");
        dtTagCloseContext0.addChild(dtHtmlTagName0);
        CommonToken close1 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        dtTagCloseContext0.addChild(close1);
        htmlElementContext1.addChild(dtTagCloseContext0);
        javadocContext0.addChild(htmlElementContext1);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeComments()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        CommonToken leadingAsterisk0 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocContext0.addChild(leadingAsterisk0);
        TextContext textContext0 = new TextContext(javadocContext0, 0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "U");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext0.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char2);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws1);
        javadocContext0.addChild(textContext0);
        HtmlCommentContext htmlCommentContext0 = new HtmlCommentContext(javadocContext0, 0);
        CommonToken htmlCommentStart0 = new CommonToken(JavadocTokenTypes.HTML_COMMENT_START, "<!--");
        htmlCommentContext0.addChild(htmlCommentStart0);
        TextContext textContext1 = new TextContext(htmlCommentContext0, 0);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext1.addChild(ws2);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext1.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext1.addChild(char4);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext1.addChild(char5);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext1.addChild(char6);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext1.addChild(char7);
        CommonToken char8 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext1.addChild(char8);
        CommonToken char9 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext1.addChild(char9);
        CommonToken char10 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext1.addChild(char10);
        htmlCommentContext0.addChild(textContext1);
        CommonToken newline0 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        htmlCommentContext0.addChild(newline0);
        CommonToken leadingAsterisk1 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        htmlCommentContext0.addChild(leadingAsterisk1);
        TextContext textContext2 = new TextContext(htmlCommentContext0, 0);
        CommonToken ws3 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext2.addChild(ws3);
        CommonToken char11 = new CommonToken(JavadocTokenTypes.CHAR, "j");
        textContext2.addChild(char11);
        CommonToken char12 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext2.addChild(char12);
        CommonToken char13 = new CommonToken(JavadocTokenTypes.CHAR, "v");
        textContext2.addChild(char13);
        CommonToken char14 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext2.addChild(char14);
        CommonToken ws4 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext2.addChild(ws4);
        CommonToken char15 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext2.addChild(char15);
        CommonToken char16 = new CommonToken(JavadocTokenTypes.CHAR, "y");
        textContext2.addChild(char16);
        CommonToken char17 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext2.addChild(char17);
        CommonToken char18 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext2.addChild(char18);
        CommonToken ws5 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext2.addChild(ws5);
        htmlCommentContext0.addChild(textContext2);
        CommonToken htmlCommentEnd0 = new CommonToken(JavadocTokenTypes.HTML_COMMENT_END, "-->");
        htmlCommentContext0.addChild(htmlCommentEnd0);
        javadocContext0.addChild(htmlCommentContext0);
        TextContext textContext3 = new TextContext(javadocContext0, 0);
        CommonToken ws6 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext3.addChild(ws6);
        javadocContext0.addChild(textContext3);
        HtmlElementContext htmlElementContext0 = new HtmlElementContext(javadocContext0, 0);
        HtmlTagContext htmlTagContext0 = new HtmlTagContext(htmlElementContext0, 0);
        HtmlElementOpenContext htmlElementOpenContext0 = new HtmlElementOpenContext(htmlTagContext0, 0);
        CommonToken open0 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementOpenContext0.addChild(open0);
        CommonToken htmlTagName0 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "b");
        htmlElementOpenContext0.addChild(htmlTagName0);
        CommonToken close0 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementOpenContext0.addChild(close0);
        htmlTagContext0.addChild(htmlElementOpenContext0);
        TextContext textContext4 = new TextContext(htmlTagContext0, 0);
        CommonToken char19 = new CommonToken(JavadocTokenTypes.CHAR, "S");
        textContext4.addChild(char19);
        CommonToken char20 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext4.addChild(char20);
        CommonToken char21 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext4.addChild(char21);
        CommonToken char22 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext4.addChild(char22);
        CommonToken char23 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext4.addChild(char23);
        CommonToken char24 = new CommonToken(JavadocTokenTypes.CHAR, "g");
        textContext4.addChild(char24);
        htmlTagContext0.addChild(textContext4);
        HtmlElementCloseContext htmlElementCloseContext0 = new HtmlElementCloseContext(htmlTagContext0, 0);
        CommonToken open1 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementCloseContext0.addChild(open1);
        CommonToken slash0 = new CommonToken(JavadocTokenTypes.SLASH, "/");
        htmlElementCloseContext0.addChild(slash0);
        CommonToken htmlTagName1 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "b");
        htmlElementCloseContext0.addChild(htmlTagName1);
        CommonToken close1 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementCloseContext0.addChild(close1);
        htmlTagContext0.addChild(htmlElementCloseContext0);
        htmlElementContext0.addChild(htmlTagContext0);
        javadocContext0.addChild(htmlElementContext0);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeHtmlTagsInParagraph()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        CommonToken newline0 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline0);
        CommonToken leadingAsterisk0 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocContext0.addChild(leadingAsterisk0);
        TextContext textContext0 = new TextContext(javadocContext0, 0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws0);
        javadocContext0.addChild(textContext0);
        HtmlElementContext htmlElementContext0 = new HtmlElementContext(javadocContext0, 0);
        ParagraphContext paragraphContext0 = new ParagraphContext(htmlElementContext0, 0);
        PTagOpenContext pTagOpenContext0 = new PTagOpenContext(paragraphContext0, 0);
        CommonToken open0 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        pTagOpenContext0.addChild(open0);
        CommonToken pHtmlTagName0 = new CommonToken(JavadocTokenTypes.P_HTML_TAG_NAME, "p");
        pTagOpenContext0.addChild(pHtmlTagName0);
        CommonToken close0 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        pTagOpenContext0.addChild(close0);
        paragraphContext0.addChild(pTagOpenContext0);
        CommonToken newline1 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        paragraphContext0.addChild(newline1);
        CommonToken leadingAsterisk1 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        paragraphContext0.addChild(leadingAsterisk1);
        TextContext textContext1 = new TextContext(paragraphContext0, 0);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext1.addChild(ws1);
        paragraphContext0.addChild(textContext1);
        HtmlTagContext htmlTagContext0 = new HtmlTagContext(paragraphContext0, 0);
        HtmlElementOpenContext htmlElementOpenContext0 = new HtmlElementOpenContext(htmlTagContext0, 0);
        CommonToken open1 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementOpenContext0.addChild(open1);
        CommonToken htmlTagName0 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "b");
        htmlElementOpenContext0.addChild(htmlTagName0);
        CommonToken close1 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementOpenContext0.addChild(close1);
        htmlTagContext0.addChild(htmlElementOpenContext0);
        TextContext textContext2 = new TextContext(htmlTagContext0, 0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "D");
        textContext2.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext2.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext2.addChild(char2);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext2.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext2.addChild(char4);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext2.addChild(char5);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext2.addChild(char6);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext2.addChild(char7);
        CommonToken char8 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext2.addChild(char8);
        CommonToken char9 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext2.addChild(char9);
        CommonToken char10 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext2.addChild(char10);
        htmlTagContext0.addChild(textContext2);
        HtmlElementCloseContext htmlElementCloseContext0 = new HtmlElementCloseContext(htmlTagContext0, 0);
        CommonToken open2 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementCloseContext0.addChild(open2);
        CommonToken slash0 = new CommonToken(JavadocTokenTypes.SLASH, "/");
        htmlElementCloseContext0.addChild(slash0);
        CommonToken htmlTagName1 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "b");
        htmlElementCloseContext0.addChild(htmlTagName1);
        CommonToken close2 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementCloseContext0.addChild(close2);
        htmlTagContext0.addChild(htmlElementCloseContext0);
        paragraphContext0.addChild(htmlTagContext0);
        TextContext textContext3 = new TextContext(paragraphContext0, 0);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext3.addChild(ws2);
        paragraphContext0.addChild(textContext3);
        HtmlTagContext htmlTagContext1 = new HtmlTagContext(paragraphContext0, 0);
        HtmlElementOpenContext htmlElementOpenContext1 = new HtmlElementOpenContext(htmlTagContext1, 0);
        CommonToken open3 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementOpenContext1.addChild(open3);
        CommonToken htmlTagName2 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "i");
        htmlElementOpenContext1.addChild(htmlTagName2);
        CommonToken close3 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementOpenContext1.addChild(close3);
        htmlTagContext1.addChild(htmlElementOpenContext1);
        TextContext textContext4 = new TextContext(htmlTagContext1, 0);
        CommonToken char11 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext4.addChild(char11);
        CommonToken char12 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext4.addChild(char12);
        htmlTagContext1.addChild(textContext4);
        HtmlElementCloseContext htmlElementCloseContext1 = new HtmlElementCloseContext(htmlTagContext1, 0);
        CommonToken open4 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementCloseContext1.addChild(open4);
        CommonToken slash1 = new CommonToken(JavadocTokenTypes.SLASH, "/");
        htmlElementCloseContext1.addChild(slash1);
        CommonToken htmlTagName3 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "i");
        htmlElementCloseContext1.addChild(htmlTagName3);
        CommonToken close4 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementCloseContext1.addChild(close4);
        htmlTagContext1.addChild(htmlElementCloseContext1);
        paragraphContext0.addChild(htmlTagContext1);
        TextContext textContext5 = new TextContext(paragraphContext0, 0);
        CommonToken ws3 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext5.addChild(ws3);
        CommonToken char13 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext5.addChild(char13);
        CommonToken char14 = new CommonToken(JavadocTokenTypes.CHAR, "y");
        textContext5.addChild(char14);
        CommonToken ws4 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext5.addChild(ws4);
        CommonToken char15 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext5.addChild(char15);
        CommonToken char16 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext5.addChild(char16);
        CommonToken char17 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext5.addChild(char17);
        CommonToken char18 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext5.addChild(char18);
        CommonToken char19 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext5.addChild(char19);
        CommonToken char20 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext5.addChild(char20);
        paragraphContext0.addChild(textContext5);
        CommonToken newline2 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        paragraphContext0.addChild(newline2);
        CommonToken leadingAsterisk2 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        paragraphContext0.addChild(leadingAsterisk2);
        TextContext textContext6 = new TextContext(paragraphContext0, 0);
        CommonToken ws5 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext6.addChild(ws5);
        paragraphContext0.addChild(textContext6);
        PTagCloseContext pTagCloseContext0 = new PTagCloseContext(paragraphContext0, 0);
        CommonToken open5 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        pTagCloseContext0.addChild(open5);
        CommonToken slash2 = new CommonToken(JavadocTokenTypes.SLASH, "/");
        pTagCloseContext0.addChild(slash2);
        CommonToken pHtmlTagName1 = new CommonToken(JavadocTokenTypes.P_HTML_TAG_NAME, "p");
        pTagCloseContext0.addChild(pHtmlTagName1);
        CommonToken close5 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        pTagCloseContext0.addChild(close5);
        paragraphContext0.addChild(pTagCloseContext0);
        htmlElementContext0.addChild(paragraphContext0);
        javadocContext0.addChild(htmlElementContext0);
        CommonToken newline3 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline3);
        CommonToken leadingAsterisk3 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocContext0.addChild(leadingAsterisk3);
        TextContext textContext7 = new TextContext(javadocContext0, 0);
        CommonToken ws6 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext7.addChild(ws6);
        CommonToken char21 = new CommonToken(JavadocTokenTypes.CHAR, "A");
        textContext7.addChild(char21);
        CommonToken char22 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext7.addChild(char22);
        CommonToken char23 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext7.addChild(char23);
        CommonToken char24 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext7.addChild(char24);
        CommonToken char25 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext7.addChild(char25);
        CommonToken char26 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext7.addChild(char26);
        CommonToken char27 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext7.addChild(char27);
        CommonToken ws7 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext7.addChild(ws7);
        CommonToken char28 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext7.addChild(char28);
        CommonToken char29 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext7.addChild(char29);
        CommonToken char30 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext7.addChild(char30);
        CommonToken char31 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext7.addChild(char31);
        CommonToken ws8 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext7.addChild(ws8);
        CommonToken char32 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext7.addChild(char32);
        CommonToken char33 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext7.addChild(char33);
        CommonToken ws9 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext7.addChild(ws9);
        CommonToken char34 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext7.addChild(char34);
        CommonToken char35 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext7.addChild(char35);
        CommonToken char36 = new CommonToken(JavadocTokenTypes.CHAR, "x");
        textContext7.addChild(char36);
        CommonToken char37 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext7.addChild(char37);
        javadocContext0.addChild(textContext7);
        CommonToken newline4 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline4);
        TextContext textContext8 = new TextContext(javadocContext0, 0);
        CommonToken ws10 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext8.addChild(ws10);
        javadocContext0.addChild(textContext8);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeListWithUnclosedItemInUnclosedParagraph()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        HtmlElementContext htmlElementContext0 = new HtmlElementContext(javadocContext0, 0);
        PTagOpenContext pTagOpenContext0 = new PTagOpenContext(htmlElementContext0, 0);
        CommonToken open0 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        pTagOpenContext0.addChild(open0);
        CommonToken pHtmlTagName0 = new CommonToken(JavadocTokenTypes.P_HTML_TAG_NAME, "p");
        pTagOpenContext0.addChild(pHtmlTagName0);
        CommonToken close0 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        pTagOpenContext0.addChild(close0);
        htmlElementContext0.addChild(pTagOpenContext0);
        javadocContext0.addChild(htmlElementContext0);
        CommonToken newline0 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline0);
        HtmlElementContext htmlElementContext1 = new HtmlElementContext(javadocContext0, 0);
        HtmlTagContext htmlTagContext0 = new HtmlTagContext(htmlElementContext1, 0);
        HtmlElementOpenContext htmlElementOpenContext0 = new HtmlElementOpenContext(htmlTagContext0, 0);
        CommonToken open1 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementOpenContext0.addChild(open1);
        CommonToken htmlTagName0 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "ul");
        htmlElementOpenContext0.addChild(htmlTagName0);
        CommonToken close1 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementOpenContext0.addChild(close1);
        htmlTagContext0.addChild(htmlElementOpenContext0);
        CommonToken newline1 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        htmlTagContext0.addChild(newline1);
        TextContext textContext0 = new TextContext(htmlTagContext0, 0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, "\t");
        textContext0.addChild(ws0);
        htmlTagContext0.addChild(textContext0);
        HtmlElementContext htmlElementContext2 = new HtmlElementContext(htmlTagContext0, 0);
        LiTagOpenContext liTagOpenContext0 = new LiTagOpenContext(htmlElementContext2, 0);
        CommonToken open2 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        liTagOpenContext0.addChild(open2);
        CommonToken liHtmlTagName0 = new CommonToken(JavadocTokenTypes.LI_HTML_TAG_NAME, "li");
        liTagOpenContext0.addChild(liHtmlTagName0);
        CommonToken close2 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        liTagOpenContext0.addChild(close2);
        htmlElementContext2.addChild(liTagOpenContext0);
        htmlTagContext0.addChild(htmlElementContext2);
        TextContext textContext1 = new TextContext(htmlTagContext0, 0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext1.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext1.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext1.addChild(char2);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext1.addChild(char3);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext1.addChild(ws1);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "1");
        textContext1.addChild(char4);
        htmlTagContext0.addChild(textContext1);
        CommonToken newline2 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        htmlTagContext0.addChild(newline2);
        TextContext textContext2 = new TextContext(htmlTagContext0, 0);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, "\t");
        textContext2.addChild(ws2);
        htmlTagContext0.addChild(textContext2);
        HtmlElementContext htmlElementContext3 = new HtmlElementContext(htmlTagContext0, 0);
        LiContext liContext0 = new LiContext(htmlElementContext3, 0);
        LiTagOpenContext liTagOpenContext1 = new LiTagOpenContext(liContext0, 0);
        CommonToken open3 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        liTagOpenContext1.addChild(open3);
        CommonToken liHtmlTagName1 = new CommonToken(JavadocTokenTypes.LI_HTML_TAG_NAME, "li");
        liTagOpenContext1.addChild(liHtmlTagName1);
        CommonToken close3 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        liTagOpenContext1.addChild(close3);
        liContext0.addChild(liTagOpenContext1);
        TextContext textContext3 = new TextContext(liContext0, 0);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext3.addChild(char5);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext3.addChild(char6);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext3.addChild(char7);
        CommonToken char8 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext3.addChild(char8);
        CommonToken ws3 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext3.addChild(ws3);
        CommonToken char9 = new CommonToken(JavadocTokenTypes.CHAR, "2");
        textContext3.addChild(char9);
        liContext0.addChild(textContext3);
        LiTagCloseContext liTagCloseContext0 = new LiTagCloseContext(liContext0, 0);
        CommonToken open4 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        liTagCloseContext0.addChild(open4);
        CommonToken slash0 = new CommonToken(JavadocTokenTypes.SLASH, "/");
        liTagCloseContext0.addChild(slash0);
        CommonToken liHtmlTagName2 = new CommonToken(JavadocTokenTypes.LI_HTML_TAG_NAME, "li");
        liTagCloseContext0.addChild(liHtmlTagName2);
        CommonToken close4 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        liTagCloseContext0.addChild(close4);
        liContext0.addChild(liTagCloseContext0);
        htmlElementContext3.addChild(liContext0);
        htmlTagContext0.addChild(htmlElementContext3);
        CommonToken newline3 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        htmlTagContext0.addChild(newline3);
        HtmlElementCloseContext htmlElementCloseContext0 = new HtmlElementCloseContext(htmlTagContext0, 0);
        CommonToken open5 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementCloseContext0.addChild(open5);
        CommonToken slash1 = new CommonToken(JavadocTokenTypes.SLASH, "/");
        htmlElementCloseContext0.addChild(slash1);
        CommonToken htmlTagName1 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "ul");
        htmlElementCloseContext0.addChild(htmlTagName1);
        CommonToken close5 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementCloseContext0.addChild(close5);
        htmlTagContext0.addChild(htmlElementCloseContext0);
        htmlElementContext1.addChild(htmlTagContext0);
        javadocContext0.addChild(htmlElementContext1);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeMixedCaseOfHtmlTags()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        HtmlElementContext htmlElementContext0 = new HtmlElementContext(javadocContext0, 0);
        PTagOpenContext pTagOpenContext0 = new PTagOpenContext(htmlElementContext0, 0);
        CommonToken open0 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        pTagOpenContext0.addChild(open0);
        CommonToken pHtmlTagName0 = new CommonToken(JavadocTokenTypes.P_HTML_TAG_NAME, "P");
        pTagOpenContext0.addChild(pHtmlTagName0);
        CommonToken close0 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        pTagOpenContext0.addChild(close0);
        htmlElementContext0.addChild(pTagOpenContext0);
        javadocContext0.addChild(htmlElementContext0);
        CommonToken newline0 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline0);
        HtmlElementContext htmlElementContext1 = new HtmlElementContext(javadocContext0, 0);
        SingletonElementContext singletonElementContext0 = new SingletonElementContext(htmlElementContext1, 0);
        BrTagContext brTagContext0 = new BrTagContext(singletonElementContext0, 0);
        CommonToken open1 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        brTagContext0.addChild(open1);
        CommonToken brHtmlTagName0 = new CommonToken(JavadocTokenTypes.BR_HTML_TAG_NAME, "br");
        brTagContext0.addChild(brHtmlTagName0);
        CommonToken close1 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        brTagContext0.addChild(close1);
        singletonElementContext0.addChild(brTagContext0);
        htmlElementContext1.addChild(singletonElementContext0);
        javadocContext0.addChild(htmlElementContext1);
        CommonToken newline1 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline1);
        HtmlElementContext htmlElementContext2 = new HtmlElementContext(javadocContext0, 0);
        SingletonElementContext singletonElementContext1 = new SingletonElementContext(htmlElementContext2, 0);
        BrTagContext brTagContext1 = new BrTagContext(singletonElementContext1, 0);
        CommonToken open2 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        brTagContext1.addChild(open2);
        CommonToken brHtmlTagName1 = new CommonToken(JavadocTokenTypes.BR_HTML_TAG_NAME, "br");
        brTagContext1.addChild(brHtmlTagName1);
        CommonToken slashClose0 = new CommonToken(JavadocTokenTypes.SLASH_CLOSE, "/>");
        brTagContext1.addChild(slashClose0);
        singletonElementContext1.addChild(brTagContext1);
        htmlElementContext2.addChild(singletonElementContext1);
        javadocContext0.addChild(htmlElementContext2);
        CommonToken newline2 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline2);
        HtmlElementContext htmlElementContext3 = new HtmlElementContext(javadocContext0, 0);
        SingletonElementContext singletonElementContext2 = new SingletonElementContext(htmlElementContext3, 0);
        BrTagContext brTagContext2 = new BrTagContext(singletonElementContext2, 0);
        CommonToken open3 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        brTagContext2.addChild(open3);
        CommonToken brHtmlTagName2 = new CommonToken(JavadocTokenTypes.BR_HTML_TAG_NAME, "BR");
        brTagContext2.addChild(brHtmlTagName2);
        CommonToken close2 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        brTagContext2.addChild(close2);
        singletonElementContext2.addChild(brTagContext2);
        htmlElementContext3.addChild(singletonElementContext2);
        javadocContext0.addChild(htmlElementContext3);
        CommonToken newline3 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline3);
        HtmlElementContext htmlElementContext4 = new HtmlElementContext(javadocContext0, 0);
        SingletonElementContext singletonElementContext3 = new SingletonElementContext(htmlElementContext4, 0);
        BrTagContext brTagContext3 = new BrTagContext(singletonElementContext3, 0);
        CommonToken open4 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        brTagContext3.addChild(open4);
        CommonToken brHtmlTagName3 = new CommonToken(JavadocTokenTypes.BR_HTML_TAG_NAME, "BR");
        brTagContext3.addChild(brHtmlTagName3);
        CommonToken slashClose1 = new CommonToken(JavadocTokenTypes.SLASH_CLOSE, "/>");
        brTagContext3.addChild(slashClose1);
        singletonElementContext3.addChild(brTagContext3);
        htmlElementContext4.addChild(singletonElementContext3);
        javadocContext0.addChild(htmlElementContext4);
        CommonToken newline4 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline4);
        HtmlElementContext htmlElementContext5 = new HtmlElementContext(javadocContext0, 0);
        HtmlTagContext htmlTagContext0 = new HtmlTagContext(htmlElementContext5, 0);
        HtmlElementOpenContext htmlElementOpenContext0 = new HtmlElementOpenContext(htmlTagContext0, 0);
        CommonToken open5 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementOpenContext0.addChild(open5);
        CommonToken htmlTagName0 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "TABLE");
        htmlElementOpenContext0.addChild(htmlTagName0);
        CommonToken close3 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementOpenContext0.addChild(close3);
        htmlTagContext0.addChild(htmlElementOpenContext0);
        CommonToken newline5 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        htmlTagContext0.addChild(newline5);
        TextContext textContext0 = new TextContext(htmlTagContext0, 0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, "\t");
        textContext0.addChild(ws0);
        htmlTagContext0.addChild(textContext0);
        HtmlElementContext htmlElementContext6 = new HtmlElementContext(htmlTagContext0, 0);
        TrContext trContext0 = new TrContext(htmlElementContext6, 0);
        TrTagOpenContext trTagOpenContext0 = new TrTagOpenContext(trContext0, 0);
        CommonToken open6 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        trTagOpenContext0.addChild(open6);
        CommonToken trHtmlTagName0 = new CommonToken(JavadocTokenTypes.TR_HTML_TAG_NAME, "tr");
        trTagOpenContext0.addChild(trHtmlTagName0);
        CommonToken close4 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        trTagOpenContext0.addChild(close4);
        trContext0.addChild(trTagOpenContext0);
        TrTagCloseContext trTagCloseContext0 = new TrTagCloseContext(trContext0, 0);
        CommonToken open7 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        trTagCloseContext0.addChild(open7);
        CommonToken slash0 = new CommonToken(JavadocTokenTypes.SLASH, "/");
        trTagCloseContext0.addChild(slash0);
        CommonToken trHtmlTagName1 = new CommonToken(JavadocTokenTypes.TR_HTML_TAG_NAME, "TR");
        trTagCloseContext0.addChild(trHtmlTagName1);
        CommonToken close5 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        trTagCloseContext0.addChild(close5);
        trContext0.addChild(trTagCloseContext0);
        htmlElementContext6.addChild(trContext0);
        htmlTagContext0.addChild(htmlElementContext6);
        CommonToken newline6 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        htmlTagContext0.addChild(newline6);
        TextContext textContext1 = new TextContext(htmlTagContext0, 0);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, "\t");
        textContext1.addChild(ws1);
        htmlTagContext0.addChild(textContext1);
        HtmlElementContext htmlElementContext7 = new HtmlElementContext(htmlTagContext0, 0);
        TrContext trContext1 = new TrContext(htmlElementContext7, 0);
        TrTagOpenContext trTagOpenContext1 = new TrTagOpenContext(trContext1, 0);
        CommonToken open8 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        trTagOpenContext1.addChild(open8);
        CommonToken trHtmlTagName2 = new CommonToken(JavadocTokenTypes.TR_HTML_TAG_NAME, "TR");
        trTagOpenContext1.addChild(trHtmlTagName2);
        CommonToken close6 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        trTagOpenContext1.addChild(close6);
        trContext1.addChild(trTagOpenContext1);
        TrTagCloseContext trTagCloseContext1 = new TrTagCloseContext(trContext1, 0);
        CommonToken open9 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        trTagCloseContext1.addChild(open9);
        CommonToken slash1 = new CommonToken(JavadocTokenTypes.SLASH, "/");
        trTagCloseContext1.addChild(slash1);
        CommonToken trHtmlTagName3 = new CommonToken(JavadocTokenTypes.TR_HTML_TAG_NAME, "tr");
        trTagCloseContext1.addChild(trHtmlTagName3);
        CommonToken close7 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        trTagCloseContext1.addChild(close7);
        trContext1.addChild(trTagCloseContext1);
        htmlElementContext7.addChild(trContext1);
        htmlTagContext0.addChild(htmlElementContext7);
        CommonToken newline7 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        htmlTagContext0.addChild(newline7);
        HtmlElementCloseContext htmlElementCloseContext0 = new HtmlElementCloseContext(htmlTagContext0, 0);
        CommonToken open10 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementCloseContext0.addChild(open10);
        CommonToken slash2 = new CommonToken(JavadocTokenTypes.SLASH, "/");
        htmlElementCloseContext0.addChild(slash2);
        CommonToken htmlTagName1 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "table");
        htmlElementCloseContext0.addChild(htmlTagName1);
        CommonToken close8 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementCloseContext0.addChild(close8);
        htmlTagContext0.addChild(htmlElementCloseContext0);
        htmlElementContext5.addChild(htmlTagContext0);
        javadocContext0.addChild(htmlElementContext5);
        CommonToken newline8 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline8);
        HtmlElementContext htmlElementContext8 = new HtmlElementContext(javadocContext0, 0);
        PTagCloseContext pTagCloseContext0 = new PTagCloseContext(htmlElementContext8, 0);
        CommonToken open11 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        pTagCloseContext0.addChild(open11);
        CommonToken slash3 = new CommonToken(JavadocTokenTypes.SLASH, "/");
        pTagCloseContext0.addChild(slash3);
        CommonToken pHtmlTagName1 = new CommonToken(JavadocTokenTypes.P_HTML_TAG_NAME, "p");
        pTagCloseContext0.addChild(pHtmlTagName1);
        CommonToken close9 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        pTagCloseContext0.addChild(close9);
        htmlElementContext8.addChild(pTagCloseContext0);
        javadocContext0.addChild(htmlElementContext8);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeNegativeNumberInAttribute()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        HtmlElementContext htmlElementContext0 = new HtmlElementContext(javadocContext0, 0);
        HtmlTagContext htmlTagContext0 = new HtmlTagContext(htmlElementContext0, 0);
        HtmlElementOpenContext htmlElementOpenContext0 = new HtmlElementOpenContext(htmlTagContext0, 0);
        CommonToken open0 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementOpenContext0.addChild(open0);
        CommonToken htmlTagName0 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "font");
        htmlElementOpenContext0.addChild(htmlTagName0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        htmlElementOpenContext0.addChild(ws0);
        AttributeContext attributeContext0 = new AttributeContext(htmlElementOpenContext0, 0);
        CommonToken htmlTagName1 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "size");
        attributeContext0.addChild(htmlTagName1);
        CommonToken equals0 = new CommonToken(JavadocTokenTypes.EQUALS, "=");
        attributeContext0.addChild(equals0);
        CommonToken attrValue0 = new CommonToken(JavadocTokenTypes.ATTR_VALUE, "-2");
        attributeContext0.addChild(attrValue0);
        htmlElementOpenContext0.addChild(attributeContext0);
        CommonToken close0 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementOpenContext0.addChild(close0);
        htmlTagContext0.addChild(htmlElementOpenContext0);
        TextContext textContext0 = new TextContext(htmlTagContext0, 0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "T");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "M");
        textContext0.addChild(char1);
        htmlTagContext0.addChild(textContext0);
        HtmlElementCloseContext htmlElementCloseContext0 = new HtmlElementCloseContext(htmlTagContext0, 0);
        CommonToken open1 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementCloseContext0.addChild(open1);
        CommonToken slash0 = new CommonToken(JavadocTokenTypes.SLASH, "/");
        htmlElementCloseContext0.addChild(slash0);
        CommonToken htmlTagName2 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "font");
        htmlElementCloseContext0.addChild(htmlTagName2);
        CommonToken close1 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementCloseContext0.addChild(close1);
        htmlTagContext0.addChild(htmlElementCloseContext0);
        htmlElementContext0.addChild(htmlTagContext0);
        javadocContext0.addChild(htmlElementContext0);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeOneSimpleHtmlTag()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        HtmlElementContext htmlElementContext0 = new HtmlElementContext(javadocContext0, 0);
        HtmlTagContext htmlTagContext0 = new HtmlTagContext(htmlElementContext0, 0);
        HtmlElementOpenContext htmlElementOpenContext0 = new HtmlElementOpenContext(htmlTagContext0, 0);
        CommonToken open0 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementOpenContext0.addChild(open0);
        CommonToken htmlTagName0 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "g");
        htmlElementOpenContext0.addChild(htmlTagName0);
        CommonToken close0 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementOpenContext0.addChild(close0);
        htmlTagContext0.addChild(htmlElementOpenContext0);
        TextContext textContext0 = new TextContext(htmlTagContext0, 0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "b");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext0.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext0.addChild(char2);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "b");
        textContext0.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext0.addChild(char4);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext0.addChild(char5);
        htmlTagContext0.addChild(textContext0);
        HtmlElementCloseContext htmlElementCloseContext0 = new HtmlElementCloseContext(htmlTagContext0, 0);
        CommonToken open1 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementCloseContext0.addChild(open1);
        CommonToken slash0 = new CommonToken(JavadocTokenTypes.SLASH, "/");
        htmlElementCloseContext0.addChild(slash0);
        CommonToken htmlTagName1 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "g");
        htmlElementCloseContext0.addChild(htmlTagName1);
        CommonToken close1 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementCloseContext0.addChild(close1);
        htmlTagContext0.addChild(htmlElementCloseContext0);
        htmlElementContext0.addChild(htmlTagContext0);
        javadocContext0.addChild(htmlElementContext0);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeUnclosedAndClosedParagraphs()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        HtmlElementContext htmlElementContext0 = new HtmlElementContext(javadocContext0, 0);
        PTagOpenContext pTagOpenContext0 = new PTagOpenContext(htmlElementContext0, 0);
        CommonToken open0 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        pTagOpenContext0.addChild(open0);
        CommonToken pHtmlTagName0 = new CommonToken(JavadocTokenTypes.P_HTML_TAG_NAME, "p");
        pTagOpenContext0.addChild(pHtmlTagName0);
        CommonToken close0 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        pTagOpenContext0.addChild(close0);
        htmlElementContext0.addChild(pTagOpenContext0);
        javadocContext0.addChild(htmlElementContext0);
        CommonToken newline0 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline0);
        TextContext textContext0 = new TextContext(javadocContext0, 0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext0.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext0.addChild(char2);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext0.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext0.addChild(char4);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws0);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext0.addChild(char5);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext0.addChild(char6);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext0.addChild(char7);
        CommonToken char8 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext0.addChild(char8);
        CommonToken char9 = new CommonToken(JavadocTokenTypes.CHAR, "g");
        textContext0.addChild(char9);
        CommonToken char10 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext0.addChild(char10);
        CommonToken char11 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext0.addChild(char11);
        CommonToken char12 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext0.addChild(char12);
        CommonToken char13 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext0.addChild(char13);
        javadocContext0.addChild(textContext0);
        CommonToken newline1 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline1);
        HtmlElementContext htmlElementContext1 = new HtmlElementContext(javadocContext0, 0);
        ParagraphContext paragraphContext0 = new ParagraphContext(htmlElementContext1, 0);
        PTagOpenContext pTagOpenContext1 = new PTagOpenContext(paragraphContext0, 0);
        CommonToken open1 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        pTagOpenContext1.addChild(open1);
        CommonToken pHtmlTagName1 = new CommonToken(JavadocTokenTypes.P_HTML_TAG_NAME, "p");
        pTagOpenContext1.addChild(pHtmlTagName1);
        CommonToken close1 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        pTagOpenContext1.addChild(close1);
        paragraphContext0.addChild(pTagOpenContext1);
        CommonToken newline2 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        paragraphContext0.addChild(newline2);
        TextContext textContext1 = new TextContext(paragraphContext0, 0);
        CommonToken char14 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext1.addChild(char14);
        CommonToken char15 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext1.addChild(char15);
        CommonToken char16 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext1.addChild(char16);
        CommonToken char17 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext1.addChild(char17);
        CommonToken char18 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext1.addChild(char18);
        CommonToken char19 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext1.addChild(char19);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext1.addChild(ws1);
        CommonToken char20 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext1.addChild(char20);
        CommonToken char21 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext1.addChild(char21);
        CommonToken char22 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext1.addChild(char22);
        CommonToken char23 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext1.addChild(char23);
        CommonToken char24 = new CommonToken(JavadocTokenTypes.CHAR, "g");
        textContext1.addChild(char24);
        CommonToken char25 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext1.addChild(char25);
        CommonToken char26 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext1.addChild(char26);
        CommonToken char27 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext1.addChild(char27);
        CommonToken char28 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext1.addChild(char28);
        paragraphContext0.addChild(textContext1);
        CommonToken newline3 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        paragraphContext0.addChild(newline3);
        PTagCloseContext pTagCloseContext0 = new PTagCloseContext(paragraphContext0, 0);
        CommonToken open2 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        pTagCloseContext0.addChild(open2);
        CommonToken slash0 = new CommonToken(JavadocTokenTypes.SLASH, "/");
        pTagCloseContext0.addChild(slash0);
        CommonToken pHtmlTagName2 = new CommonToken(JavadocTokenTypes.P_HTML_TAG_NAME, "p");
        pTagCloseContext0.addChild(pHtmlTagName2);
        CommonToken close2 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        pTagCloseContext0.addChild(close2);
        paragraphContext0.addChild(pTagCloseContext0);
        htmlElementContext1.addChild(paragraphContext0);
        javadocContext0.addChild(htmlElementContext1);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeUnclosedParagraphFollowedByJavadocTag()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        HtmlElementContext htmlElementContext0 = new HtmlElementContext(javadocContext0, 0);
        PTagOpenContext pTagOpenContext0 = new PTagOpenContext(htmlElementContext0, 0);
        CommonToken open0 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        pTagOpenContext0.addChild(open0);
        CommonToken pHtmlTagName0 = new CommonToken(JavadocTokenTypes.P_HTML_TAG_NAME, "p");
        pTagOpenContext0.addChild(pHtmlTagName0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        pTagOpenContext0.addChild(ws0);
        AttributeContext attributeContext0 = new AttributeContext(pTagOpenContext0, 0);
        CommonToken htmlTagName0 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "style");
        attributeContext0.addChild(htmlTagName0);
        CommonToken equals0 = new CommonToken(JavadocTokenTypes.EQUALS, "=");
        attributeContext0.addChild(equals0);
        CommonToken attrValue0 = new CommonToken(JavadocTokenTypes.ATTR_VALUE, "\"color: red;\"");
        attributeContext0.addChild(attrValue0);
        pTagOpenContext0.addChild(attributeContext0);
        CommonToken close0 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        pTagOpenContext0.addChild(close0);
        htmlElementContext0.addChild(pTagOpenContext0);
        javadocContext0.addChild(htmlElementContext0);
        CommonToken newline0 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline0);
        TextContext textContext0 = new TextContext(javadocContext0, 0);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, "\t");
        textContext0.addChild(ws1);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "x");
        textContext0.addChild(char2);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext0.addChild(char3);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws2);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext0.addChild(char4);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char5);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "x");
        textContext0.addChild(char6);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext0.addChild(char7);
        javadocContext0.addChild(textContext0);
        CommonToken newline1 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline1);
        JavadocTagContext javadocTagContext0 = new JavadocTagContext(javadocContext0, 0);
        CommonToken authorLiteral0 = new CommonToken(JavadocTokenTypes.AUTHOR_LITERAL, "@author");
        javadocTagContext0.addChild(authorLiteral0);
        CommonToken ws3 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext0.addChild(ws3);
        DescriptionContext descriptionContext0 = new DescriptionContext(javadocTagContext0, 0);
        TextContext textContext1 = new TextContext(descriptionContext0, 0);
        CommonToken char8 = new CommonToken(JavadocTokenTypes.CHAR, "B");
        textContext1.addChild(char8);
        CommonToken char9 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext1.addChild(char9);
        CommonToken char10 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext1.addChild(char10);
        CommonToken char11 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext1.addChild(char11);
        CommonToken char12 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext1.addChild(char12);
        CommonToken char13 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext1.addChild(char13);
        CommonToken char14 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext1.addChild(char14);
        CommonToken char15 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext1.addChild(char15);
        descriptionContext0.addChild(textContext1);
        javadocTagContext0.addChild(descriptionContext0);
        javadocContext0.addChild(javadocTagContext0);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeAllJavadocInlineTags()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        JavadocInlineTagContext javadocInlineTagContext0 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext0.addChild(javadocInlineTagStart0);
        CommonToken codeLiteral0 = new CommonToken(JavadocTokenTypes.CODE_LITERAL, "@code");
        javadocInlineTagContext0.addChild(codeLiteral0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext0.addChild(ws0);
        TextContext textContext0 = new TextContext(javadocInlineTagContext0, 0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "<");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext0.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext0.addChild(char2);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext0.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char4);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, ">");
        textContext0.addChild(char5);
        javadocInlineTagContext0.addChild(textContext0);
        CommonToken javadocInlineTagEnd0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext0.addChild(javadocInlineTagEnd0);
        javadocContext0.addChild(javadocInlineTagContext0);
        TextContext textContext1 = new TextContext(javadocContext0, 0);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext1.addChild(ws1);
        javadocContext0.addChild(textContext1);
        JavadocInlineTagContext javadocInlineTagContext1 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart1 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext1.addChild(javadocInlineTagStart1);
        CommonToken literalLiteral0 = new CommonToken(JavadocTokenTypes.LITERAL_LITERAL, "@literal");
        javadocInlineTagContext1.addChild(literalLiteral0);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext1.addChild(ws2);
        TextContext textContext2 = new TextContext(javadocInlineTagContext1, 0);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "<");
        textContext2.addChild(char6);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext2.addChild(char7);
        CommonToken char8 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext2.addChild(char8);
        CommonToken char9 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext2.addChild(char9);
        CommonToken char10 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext2.addChild(char10);
        CommonToken char11 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext2.addChild(char11);
        CommonToken char12 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext2.addChild(char12);
        CommonToken char13 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext2.addChild(char13);
        CommonToken char14 = new CommonToken(JavadocTokenTypes.CHAR, ">");
        textContext2.addChild(char14);
        javadocInlineTagContext1.addChild(textContext2);
        CommonToken javadocInlineTagEnd1 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext1.addChild(javadocInlineTagEnd1);
        javadocContext0.addChild(javadocInlineTagContext1);
        TextContext textContext3 = new TextContext(javadocContext0, 0);
        CommonToken ws3 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext3.addChild(ws3);
        javadocContext0.addChild(textContext3);
        JavadocInlineTagContext javadocInlineTagContext2 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart2 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext2.addChild(javadocInlineTagStart2);
        CommonToken docRootLiteral0 = new CommonToken(JavadocTokenTypes.DOC_ROOT_LITERAL, "@docRoot");
        javadocInlineTagContext2.addChild(docRootLiteral0);
        CommonToken javadocInlineTagEnd2 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext2.addChild(javadocInlineTagEnd2);
        javadocContext0.addChild(javadocInlineTagContext2);
        TextContext textContext4 = new TextContext(javadocContext0, 0);
        CommonToken ws4 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext4.addChild(ws4);
        javadocContext0.addChild(textContext4);
        JavadocInlineTagContext javadocInlineTagContext3 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart3 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext3.addChild(javadocInlineTagStart3);
        CommonToken inheritDocLiteral0 = new CommonToken(JavadocTokenTypes.INHERIT_DOC_LITERAL, "@inheritDoc");
        javadocInlineTagContext3.addChild(inheritDocLiteral0);
        CommonToken javadocInlineTagEnd3 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext3.addChild(javadocInlineTagEnd3);
        javadocContext0.addChild(javadocInlineTagContext3);
        TextContext textContext5 = new TextContext(javadocContext0, 0);
        CommonToken ws5 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext5.addChild(ws5);
        javadocContext0.addChild(textContext5);
        JavadocInlineTagContext javadocInlineTagContext4 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart4 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext4.addChild(javadocInlineTagStart4);
        CommonToken linkLiteral0 = new CommonToken(JavadocTokenTypes.LINK_LITERAL, "@link");
        javadocInlineTagContext4.addChild(linkLiteral0);
        CommonToken ws6 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext4.addChild(ws6);
        ReferenceContext referenceContext0 = new ReferenceContext(javadocInlineTagContext4, 0);
        CommonToken class0 = new CommonToken(JavadocTokenTypes.CLASS, "A");
        referenceContext0.addChild(class0);
        javadocInlineTagContext4.addChild(referenceContext0);
        DescriptionContext descriptionContext0 = new DescriptionContext(javadocInlineTagContext4, 0);
        TextContext textContext6 = new TextContext(descriptionContext0, 0);
        CommonToken ws7 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext6.addChild(ws7);
        CommonToken char15 = new CommonToken(JavadocTokenTypes.CHAR, "A");
        textContext6.addChild(char15);
        CommonToken ws8 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext6.addChild(ws8);
        CommonToken char16 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext6.addChild(char16);
        CommonToken char17 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext6.addChild(char17);
        CommonToken char18 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext6.addChild(char18);
        CommonToken char19 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext6.addChild(char19);
        CommonToken char20 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext6.addChild(char20);
        descriptionContext0.addChild(textContext6);
        javadocInlineTagContext4.addChild(descriptionContext0);
        CommonToken javadocInlineTagEnd4 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext4.addChild(javadocInlineTagEnd4);
        javadocContext0.addChild(javadocInlineTagContext4);
        TextContext textContext7 = new TextContext(javadocContext0, 0);
        CommonToken ws9 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext7.addChild(ws9);
        javadocContext0.addChild(textContext7);
        JavadocInlineTagContext javadocInlineTagContext5 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart5 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext5.addChild(javadocInlineTagStart5);
        CommonToken linkplainLiteral0 = new CommonToken(JavadocTokenTypes.LINKPLAIN_LITERAL, "@linkplain");
        javadocInlineTagContext5.addChild(linkplainLiteral0);
        CommonToken ws10 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext5.addChild(ws10);
        ReferenceContext referenceContext1 = new ReferenceContext(javadocInlineTagContext5, 0);
        CommonToken class1 = new CommonToken(JavadocTokenTypes.CLASS, "A");
        referenceContext1.addChild(class1);
        javadocInlineTagContext5.addChild(referenceContext1);
        DescriptionContext descriptionContext1 = new DescriptionContext(javadocInlineTagContext5, 0);
        TextContext textContext8 = new TextContext(descriptionContext1, 0);
        CommonToken ws11 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext8.addChild(ws11);
        CommonToken char21 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext8.addChild(char21);
        CommonToken char22 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext8.addChild(char22);
        CommonToken char23 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext8.addChild(char23);
        CommonToken char24 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext8.addChild(char24);
        CommonToken char25 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext8.addChild(char25);
        CommonToken char26 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext8.addChild(char26);
        CommonToken char27 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext8.addChild(char27);
        CommonToken ws12 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext8.addChild(ws12);
        CommonToken char28 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext8.addChild(char28);
        CommonToken char29 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext8.addChild(char29);
        CommonToken char30 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext8.addChild(char30);
        CommonToken char31 = new CommonToken(JavadocTokenTypes.CHAR, "k");
        textContext8.addChild(char31);
        descriptionContext1.addChild(textContext8);
        javadocInlineTagContext5.addChild(descriptionContext1);
        CommonToken javadocInlineTagEnd5 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext5.addChild(javadocInlineTagEnd5);
        javadocContext0.addChild(javadocInlineTagContext5);
        TextContext textContext9 = new TextContext(javadocContext0, 0);
        CommonToken ws13 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext9.addChild(ws13);
        javadocContext0.addChild(textContext9);
        JavadocInlineTagContext javadocInlineTagContext6 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart6 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext6.addChild(javadocInlineTagStart6);
        CommonToken valueLiteral0 = new CommonToken(JavadocTokenTypes.VALUE_LITERAL, "@value");
        javadocInlineTagContext6.addChild(valueLiteral0);
        CommonToken ws14 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext6.addChild(ws14);
        ReferenceContext referenceContext2 = new ReferenceContext(javadocInlineTagContext6, 0);
        CommonToken package0 = new CommonToken(JavadocTokenTypes.PACKAGE, "lang");
        referenceContext2.addChild(package0);
        CommonToken dot0 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext2.addChild(dot0);
        CommonToken class2 = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        referenceContext2.addChild(class2);
        CommonToken hash0 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext2.addChild(hash0);
        CommonToken member0 = new CommonToken(JavadocTokenTypes.MEMBER, "MAX_VALUE");
        referenceContext2.addChild(member0);
        javadocInlineTagContext6.addChild(referenceContext2);
        CommonToken javadocInlineTagEnd6 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext6.addChild(javadocInlineTagEnd6);
        javadocContext0.addChild(javadocInlineTagContext6);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeAllStandardJavadocTags()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        CommonToken newline0 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline0);
        JavadocTagContext javadocTagContext0 = new JavadocTagContext(javadocContext0, 0);
        CommonToken authorLiteral0 = new CommonToken(JavadocTokenTypes.AUTHOR_LITERAL, "@author");
        javadocTagContext0.addChild(authorLiteral0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext0.addChild(ws0);
        DescriptionContext descriptionContext0 = new DescriptionContext(javadocTagContext0, 0);
        TextContext textContext0 = new TextContext(descriptionContext0, 0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "J");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext0.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext0.addChild(char2);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext0.addChild(char3);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws1);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "L");
        textContext0.addChild(char4);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext0.addChild(char5);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext0.addChild(char6);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, "k");
        textContext0.addChild(char7);
        CommonToken char8 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char8);
        descriptionContext0.addChild(textContext0);
        CommonToken newline1 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext0.addChild(newline1);
        javadocTagContext0.addChild(descriptionContext0);
        javadocContext0.addChild(javadocTagContext0);
        JavadocTagContext javadocTagContext1 = new JavadocTagContext(javadocContext0, 0);
        CommonToken authorLiteral1 = new CommonToken(JavadocTokenTypes.AUTHOR_LITERAL, "@author");
        javadocTagContext1.addChild(authorLiteral1);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext1.addChild(ws2);
        DescriptionContext descriptionContext1 = new DescriptionContext(javadocTagContext1, 0);
        TextContext textContext1 = new TextContext(descriptionContext1, 0);
        CommonToken char9 = new CommonToken(JavadocTokenTypes.CHAR, "M");
        textContext1.addChild(char9);
        CommonToken char10 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext1.addChild(char10);
        CommonToken char11 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext1.addChild(char11);
        CommonToken ws3 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext1.addChild(ws3);
        CommonToken char12 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext1.addChild(char12);
        CommonToken char13 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext1.addChild(char13);
        CommonToken ws4 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext1.addChild(ws4);
        CommonToken char14 = new CommonToken(JavadocTokenTypes.CHAR, "b");
        textContext1.addChild(char14);
        CommonToken char15 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext1.addChild(char15);
        CommonToken char16 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext1.addChild(char16);
        CommonToken char17 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext1.addChild(char17);
        CommonToken char18 = new CommonToken(JavadocTokenTypes.CHAR, "k");
        textContext1.addChild(char18);
        CommonToken char19 = new CommonToken(JavadocTokenTypes.CHAR, ",");
        textContext1.addChild(char19);
        CommonToken ws5 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext1.addChild(ws5);
        CommonToken char20 = new CommonToken(JavadocTokenTypes.CHAR, "S");
        textContext1.addChild(char20);
        CommonToken char21 = new CommonToken(JavadocTokenTypes.CHAR, "u");
        textContext1.addChild(char21);
        CommonToken char22 = new CommonToken(JavadocTokenTypes.CHAR, "b");
        textContext1.addChild(char22);
        CommonToken ws6 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext1.addChild(ws6);
        CommonToken char23 = new CommonToken(JavadocTokenTypes.CHAR, "Z");
        textContext1.addChild(char23);
        CommonToken char24 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext1.addChild(char24);
        CommonToken char25 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext1.addChild(char25);
        CommonToken char26 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext1.addChild(char26);
        descriptionContext1.addChild(textContext1);
        CommonToken newline2 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext1.addChild(newline2);
        javadocTagContext1.addChild(descriptionContext1);
        javadocContext0.addChild(javadocTagContext1);
        JavadocTagContext javadocTagContext2 = new JavadocTagContext(javadocContext0, 0);
        CommonToken authorLiteral2 = new CommonToken(JavadocTokenTypes.AUTHOR_LITERAL, "@author");
        javadocTagContext2.addChild(authorLiteral2);
        CommonToken ws7 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext2.addChild(ws7);
        DescriptionContext descriptionContext2 = new DescriptionContext(javadocTagContext2, 0);
        HtmlElementContext htmlElementContext0 = new HtmlElementContext(descriptionContext2, 0);
        HtmlTagContext htmlTagContext0 = new HtmlTagContext(htmlElementContext0, 0);
        HtmlElementOpenContext htmlElementOpenContext0 = new HtmlElementOpenContext(htmlTagContext0, 0);
        CommonToken open0 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementOpenContext0.addChild(open0);
        CommonToken htmlTagName0 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "a");
        htmlElementOpenContext0.addChild(htmlTagName0);
        CommonToken ws8 = new CommonToken(JavadocTokenTypes.WS, " ");
        htmlElementOpenContext0.addChild(ws8);
        AttributeContext attributeContext0 = new AttributeContext(htmlElementOpenContext0, 0);
        CommonToken htmlTagName1 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "href");
        attributeContext0.addChild(htmlTagName1);
        CommonToken equals0 = new CommonToken(JavadocTokenTypes.EQUALS, "=");
        attributeContext0.addChild(equals0);
        CommonToken attrValue0 = new CommonToken(JavadocTokenTypes.ATTR_VALUE, "\"mailto:meth@albuquerque.com\"");
        attributeContext0.addChild(attrValue0);
        htmlElementOpenContext0.addChild(attributeContext0);
        CommonToken close0 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementOpenContext0.addChild(close0);
        htmlTagContext0.addChild(htmlElementOpenContext0);
        TextContext textContext2 = new TextContext(htmlTagContext0, 0);
        CommonToken char27 = new CommonToken(JavadocTokenTypes.CHAR, "W");
        textContext2.addChild(char27);
        CommonToken char28 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext2.addChild(char28);
        CommonToken char29 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext2.addChild(char29);
        CommonToken char30 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext2.addChild(char30);
        CommonToken char31 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext2.addChild(char31);
        CommonToken char32 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext2.addChild(char32);
        CommonToken ws9 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext2.addChild(ws9);
        CommonToken char33 = new CommonToken(JavadocTokenTypes.CHAR, "W");
        textContext2.addChild(char33);
        CommonToken char34 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext2.addChild(char34);
        CommonToken char35 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext2.addChild(char35);
        CommonToken char36 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext2.addChild(char36);
        CommonToken char37 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext2.addChild(char37);
        htmlTagContext0.addChild(textContext2);
        HtmlElementCloseContext htmlElementCloseContext0 = new HtmlElementCloseContext(htmlTagContext0, 0);
        CommonToken open1 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementCloseContext0.addChild(open1);
        CommonToken slash0 = new CommonToken(JavadocTokenTypes.SLASH, "/");
        htmlElementCloseContext0.addChild(slash0);
        CommonToken htmlTagName2 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "a");
        htmlElementCloseContext0.addChild(htmlTagName2);
        CommonToken close1 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementCloseContext0.addChild(close1);
        htmlTagContext0.addChild(htmlElementCloseContext0);
        htmlElementContext0.addChild(htmlTagContext0);
        descriptionContext2.addChild(htmlElementContext0);
        CommonToken newline3 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext2.addChild(newline3);
        javadocTagContext2.addChild(descriptionContext2);
        javadocContext0.addChild(javadocTagContext2);
        JavadocTagContext javadocTagContext3 = new JavadocTagContext(javadocContext0, 0);
        CommonToken deprecatedLiteral0 = new CommonToken(JavadocTokenTypes.DEPRECATED_LITERAL, "@deprecated");
        javadocTagContext3.addChild(deprecatedLiteral0);
        CommonToken ws10 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext3.addChild(ws10);
        DescriptionContext descriptionContext3 = new DescriptionContext(javadocTagContext3, 0);
        TextContext textContext3 = new TextContext(descriptionContext3, 0);
        CommonToken char38 = new CommonToken(JavadocTokenTypes.CHAR, "T");
        textContext3.addChild(char38);
        CommonToken char39 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext3.addChild(char39);
        CommonToken char40 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext3.addChild(char40);
        CommonToken char41 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext3.addChild(char41);
        CommonToken ws11 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext3.addChild(ws11);
        CommonToken char42 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext3.addChild(char42);
        CommonToken char43 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext3.addChild(char43);
        CommonToken char44 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext3.addChild(char44);
        CommonToken char45 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext3.addChild(char45);
        CommonToken char46 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext3.addChild(char46);
        CommonToken char47 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext3.addChild(char47);
        CommonToken ws12 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext3.addChild(ws12);
        CommonToken char48 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext3.addChild(char48);
        CommonToken char49 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext3.addChild(char49);
        CommonToken ws13 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext3.addChild(ws13);
        CommonToken char50 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext3.addChild(char50);
        CommonToken char51 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext3.addChild(char51);
        CommonToken char52 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext3.addChild(char52);
        CommonToken char53 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext3.addChild(char53);
        CommonToken char54 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext3.addChild(char54);
        CommonToken char55 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext3.addChild(char55);
        CommonToken char56 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext3.addChild(char56);
        CommonToken char57 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext3.addChild(char57);
        CommonToken char58 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext3.addChild(char58);
        CommonToken char59 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext3.addChild(char59);
        descriptionContext3.addChild(textContext3);
        CommonToken newline4 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext3.addChild(newline4);
        TextContext textContext4 = new TextContext(descriptionContext3, 0);
        CommonToken char60 = new CommonToken(JavadocTokenTypes.CHAR, "b");
        textContext4.addChild(char60);
        CommonToken char61 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext4.addChild(char61);
        CommonToken char62 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext4.addChild(char62);
        CommonToken char63 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext4.addChild(char63);
        CommonToken char64 = new CommonToken(JavadocTokenTypes.CHAR, "u");
        textContext4.addChild(char64);
        CommonToken char65 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext4.addChild(char65);
        CommonToken char66 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext4.addChild(char66);
        CommonToken ws14 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext4.addChild(ws14);
        CommonToken char67 = new CommonToken(JavadocTokenTypes.CHAR, "w");
        textContext4.addChild(char67);
        CommonToken char68 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext4.addChild(char68);
        CommonToken ws15 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext4.addChild(ws15);
        CommonToken char69 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext4.addChild(char69);
        CommonToken char70 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext4.addChild(char70);
        CommonToken char71 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext4.addChild(char71);
        CommonToken char72 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext4.addChild(char72);
        CommonToken char73 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext4.addChild(char73);
        CommonToken char74 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext4.addChild(char74);
        CommonToken char75 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext4.addChild(char75);
        CommonToken ws16 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext4.addChild(ws16);
        CommonToken char76 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext4.addChild(char76);
        CommonToken char77 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext4.addChild(char77);
        CommonToken char78 = new CommonToken(JavadocTokenTypes.CHAR, "w");
        textContext4.addChild(char78);
        CommonToken ws17 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext4.addChild(ws17);
        CommonToken char79 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext4.addChild(char79);
        CommonToken char80 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext4.addChild(char80);
        CommonToken char81 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext4.addChild(char81);
        CommonToken char82 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext4.addChild(char82);
        descriptionContext3.addChild(textContext4);
        CommonToken newline5 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext3.addChild(newline5);
        javadocTagContext3.addChild(descriptionContext3);
        javadocContext0.addChild(javadocTagContext3);
        JavadocTagContext javadocTagContext4 = new JavadocTagContext(javadocContext0, 0);
        CommonToken exceptionLiteral0 = new CommonToken(JavadocTokenTypes.EXCEPTION_LITERAL, "@exception");
        javadocTagContext4.addChild(exceptionLiteral0);
        CommonToken ws18 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext4.addChild(ws18);
        CommonToken className0 = new CommonToken(JavadocTokenTypes.CLASS_NAME, "IOException");
        javadocTagContext4.addChild(className0);
        CommonToken ws19 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext4.addChild(ws19);
        DescriptionContext descriptionContext4 = new DescriptionContext(javadocTagContext4, 0);
        TextContext textContext5 = new TextContext(descriptionContext4, 0);
        CommonToken char83 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext5.addChild(char83);
        CommonToken char84 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext5.addChild(char84);
        CommonToken char85 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext5.addChild(char85);
        CommonToken char86 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext5.addChild(char86);
        CommonToken char87 = new CommonToken(JavadocTokenTypes.CHAR, "w");
        textContext5.addChild(char87);
        CommonToken char88 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext5.addChild(char88);
        CommonToken ws20 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext5.addChild(ws20);
        CommonToken char89 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext5.addChild(char89);
        CommonToken char90 = new CommonToken(JavadocTokenTypes.CHAR, "x");
        textContext5.addChild(char90);
        CommonToken char91 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext5.addChild(char91);
        CommonToken char92 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext5.addChild(char92);
        CommonToken char93 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext5.addChild(char93);
        CommonToken char94 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext5.addChild(char94);
        CommonToken char95 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext5.addChild(char95);
        CommonToken char96 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext5.addChild(char96);
        CommonToken char97 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext5.addChild(char97);
        CommonToken ws21 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext5.addChild(ws21);
        CommonToken char98 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext5.addChild(char98);
        CommonToken char99 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext5.addChild(char99);
        CommonToken ws22 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext5.addChild(ws22);
        CommonToken char100 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext5.addChild(char100);
        CommonToken char101 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext5.addChild(char101);
        CommonToken char102 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext5.addChild(char102);
        CommonToken char103 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext5.addChild(char103);
        CommonToken char104 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext5.addChild(char104);
        CommonToken char105 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext5.addChild(char105);
        CommonToken char106 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext5.addChild(char106);
        CommonToken char107 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext5.addChild(char107);
        CommonToken char108 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext5.addChild(char108);
        CommonToken char109 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext5.addChild(char109);
        CommonToken ws23 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext5.addChild(ws23);
        CommonToken char110 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext5.addChild(char110);
        CommonToken char111 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext5.addChild(char111);
        CommonToken char112 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext5.addChild(char112);
        CommonToken char113 = new CommonToken(JavadocTokenTypes.CHAR, "u");
        textContext5.addChild(char113);
        CommonToken char114 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext5.addChild(char114);
        CommonToken char115 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext5.addChild(char115);
        CommonToken char116 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext5.addChild(char116);
        CommonToken char117 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext5.addChild(char117);
        descriptionContext4.addChild(textContext5);
        CommonToken newline6 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext4.addChild(newline6);
        javadocTagContext4.addChild(descriptionContext4);
        javadocContext0.addChild(javadocTagContext4);
        JavadocTagContext javadocTagContext5 = new JavadocTagContext(javadocContext0, 0);
        CommonToken paramLiteral0 = new CommonToken(JavadocTokenTypes.PARAM_LITERAL, "@param");
        javadocTagContext5.addChild(paramLiteral0);
        CommonToken ws24 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext5.addChild(ws24);
        CommonToken parameterName0 = new CommonToken(JavadocTokenTypes.PARAMETER_NAME, "arg");
        javadocTagContext5.addChild(parameterName0);
        CommonToken ws25 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext5.addChild(ws25);
        DescriptionContext descriptionContext5 = new DescriptionContext(javadocTagContext5, 0);
        TextContext textContext6 = new TextContext(descriptionContext5, 0);
        CommonToken char118 = new CommonToken(JavadocTokenTypes.CHAR, "S");
        textContext6.addChild(char118);
        CommonToken char119 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext6.addChild(char119);
        CommonToken char120 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext6.addChild(char120);
        CommonToken char121 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext6.addChild(char121);
        CommonToken char122 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext6.addChild(char122);
        CommonToken char123 = new CommonToken(JavadocTokenTypes.CHAR, "g");
        textContext6.addChild(char123);
        CommonToken ws26 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext6.addChild(ws26);
        CommonToken char124 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext6.addChild(char124);
        CommonToken char125 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext6.addChild(char125);
        CommonToken char126 = new CommonToken(JavadocTokenTypes.CHAR, "g");
        textContext6.addChild(char126);
        CommonToken char127 = new CommonToken(JavadocTokenTypes.CHAR, "u");
        textContext6.addChild(char127);
        CommonToken char128 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext6.addChild(char128);
        CommonToken char129 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext6.addChild(char129);
        CommonToken char130 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext6.addChild(char130);
        CommonToken char131 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext6.addChild(char131);
        descriptionContext5.addChild(textContext6);
        CommonToken newline7 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext5.addChild(newline7);
        javadocTagContext5.addChild(descriptionContext5);
        javadocContext0.addChild(javadocTagContext5);
        JavadocTagContext javadocTagContext6 = new JavadocTagContext(javadocContext0, 0);
        CommonToken paramLiteral1 = new CommonToken(JavadocTokenTypes.PARAM_LITERAL, "@param");
        javadocTagContext6.addChild(paramLiteral1);
        CommonToken ws27 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext6.addChild(ws27);
        CommonToken parameterName1 = new CommonToken(JavadocTokenTypes.PARAMETER_NAME, "<E>");
        javadocTagContext6.addChild(parameterName1);
        CommonToken ws28 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext6.addChild(ws28);
        DescriptionContext descriptionContext6 = new DescriptionContext(javadocTagContext6, 0);
        TextContext textContext7 = new TextContext(descriptionContext6, 0);
        CommonToken char132 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext7.addChild(char132);
        CommonToken char133 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext7.addChild(char133);
        CommonToken ws29 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext7.addChild(ws29);
        CommonToken char134 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext7.addChild(char134);
        CommonToken char135 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext7.addChild(char135);
        CommonToken ws30 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext7.addChild(ws30);
        CommonToken char136 = new CommonToken(JavadocTokenTypes.CHAR, "g");
        textContext7.addChild(char136);
        CommonToken char137 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext7.addChild(char137);
        CommonToken char138 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext7.addChild(char138);
        CommonToken char139 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext7.addChild(char139);
        CommonToken char140 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext7.addChild(char140);
        CommonToken char141 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext7.addChild(char141);
        CommonToken char142 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext7.addChild(char142);
        descriptionContext6.addChild(textContext7);
        CommonToken newline8 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext6.addChild(newline8);
        javadocTagContext6.addChild(descriptionContext6);
        javadocContext0.addChild(javadocTagContext6);
        JavadocTagContext javadocTagContext7 = new JavadocTagContext(javadocContext0, 0);
        CommonToken paramLiteral2 = new CommonToken(JavadocTokenTypes.PARAM_LITERAL, "@param");
        javadocTagContext7.addChild(paramLiteral2);
        CommonToken ws31 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext7.addChild(ws31);
        CommonToken parameterName2 = new CommonToken(JavadocTokenTypes.PARAMETER_NAME, "type");
        javadocTagContext7.addChild(parameterName2);
        CommonToken ws32 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext7.addChild(ws32);
        DescriptionContext descriptionContext7 = new DescriptionContext(javadocTagContext7, 0);
        TextContext textContext8 = new TextContext(descriptionContext7, 0);
        CommonToken char143 = new CommonToken(JavadocTokenTypes.CHAR, "I");
        textContext8.addChild(char143);
        CommonToken ws33 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext8.addChild(ws33);
        CommonToken char144 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext8.addChild(char144);
        CommonToken char145 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext8.addChild(char145);
        CommonToken char146 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext8.addChild(char146);
        CommonToken ws34 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext8.addChild(ws34);
        CommonToken char147 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext8.addChild(char147);
        CommonToken char148 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext8.addChild(char148);
        CommonToken char149 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext8.addChild(char149);
        CommonToken char150 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext8.addChild(char150);
        CommonToken char151 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext8.addChild(char151);
        CommonToken char152 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext8.addChild(char152);
        CommonToken char153 = new CommonToken(JavadocTokenTypes.CHAR, "b");
        textContext8.addChild(char153);
        CommonToken char154 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext8.addChild(char154);
        CommonToken ws35 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext8.addChild(ws35);
        CommonToken char155 = new CommonToken(JavadocTokenTypes.CHAR, "'");
        textContext8.addChild(char155);
        CommonToken char156 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext8.addChild(char156);
        CommonToken char157 = new CommonToken(JavadocTokenTypes.CHAR, "y");
        textContext8.addChild(char157);
        CommonToken char158 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext8.addChild(char158);
        CommonToken char159 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext8.addChild(char159);
        CommonToken char160 = new CommonToken(JavadocTokenTypes.CHAR, "'");
        textContext8.addChild(char160);
        descriptionContext7.addChild(textContext8);
        CommonToken newline9 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext7.addChild(newline9);
        TextContext textContext9 = new TextContext(descriptionContext7, 0);
        CommonToken char161 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext9.addChild(char161);
        CommonToken char162 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext9.addChild(char162);
        CommonToken ws36 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext9.addChild(ws36);
        CommonToken char163 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext9.addChild(char163);
        CommonToken char164 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext9.addChild(char164);
        CommonToken char165 = new CommonToken(JavadocTokenTypes.CHAR, "v");
        textContext9.addChild(char165);
        CommonToken char166 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext9.addChild(char166);
        CommonToken char167 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext9.addChild(char167);
        CommonToken char168 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext9.addChild(char168);
        CommonToken char169 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext9.addChild(char169);
        CommonToken ws37 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext9.addChild(ws37);
        CommonToken char170 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext9.addChild(char170);
        CommonToken char171 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext9.addChild(char171);
        CommonToken char172 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext9.addChild(char172);
        CommonToken char173 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext9.addChild(char173);
        CommonToken char174 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext9.addChild(char174);
        CommonToken char175 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext9.addChild(char175);
        descriptionContext7.addChild(textContext9);
        CommonToken newline10 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext7.addChild(newline10);
        TextContext textContext10 = new TextContext(descriptionContext7, 0);
        CommonToken char176 = new CommonToken(JavadocTokenTypes.CHAR, "O");
        textContext10.addChild(char176);
        CommonToken char177 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext10.addChild(char177);
        CommonToken char178 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext10.addChild(char178);
        CommonToken ws38 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext10.addChild(ws38);
        CommonToken char179 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext10.addChild(char179);
        CommonToken char180 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext10.addChild(char180);
        CommonToken char181 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext10.addChild(char181);
        CommonToken char182 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext10.addChild(char182);
        CommonToken ws39 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext10.addChild(ws39);
        CommonToken char183 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext10.addChild(char183);
        CommonToken char184 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext10.addChild(char184);
        CommonToken char185 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext10.addChild(char185);
        CommonToken char186 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext10.addChild(char186);
        CommonToken ws40 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext10.addChild(ws40);
        CommonToken char187 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext10.addChild(char187);
        CommonToken char188 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext10.addChild(char188);
        CommonToken ws41 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext10.addChild(ws41);
        CommonToken char189 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext10.addChild(char189);
        CommonToken char190 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext10.addChild(char190);
        CommonToken char191 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext10.addChild(char191);
        CommonToken char192 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext10.addChild(char192);
        CommonToken char193 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext10.addChild(char193);
        CommonToken char194 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext10.addChild(char194);
        CommonToken char195 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext10.addChild(char195);
        CommonToken char196 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext10.addChild(char196);
        CommonToken char197 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext10.addChild(char197);
        CommonToken char198 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext10.addChild(char198);
        CommonToken char199 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext10.addChild(char199);
        CommonToken char200 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext10.addChild(char200);
        descriptionContext7.addChild(textContext10);
        CommonToken newline11 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext7.addChild(newline11);
        javadocTagContext7.addChild(descriptionContext7);
        javadocContext0.addChild(javadocTagContext7);
        JavadocTagContext javadocTagContext8 = new JavadocTagContext(javadocContext0, 0);
        CommonToken returnLiteral0 = new CommonToken(JavadocTokenTypes.RETURN_LITERAL, "@return");
        javadocTagContext8.addChild(returnLiteral0);
        CommonToken ws42 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext8.addChild(ws42);
        DescriptionContext descriptionContext8 = new DescriptionContext(javadocTagContext8, 0);
        TextContext textContext11 = new TextContext(descriptionContext8, 0);
        CommonToken char201 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext11.addChild(char201);
        CommonToken char202 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext11.addChild(char202);
        CommonToken char203 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext11.addChild(char203);
        CommonToken char204 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext11.addChild(char204);
        CommonToken char205 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext11.addChild(char205);
        CommonToken char206 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext11.addChild(char206);
        CommonToken char207 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext11.addChild(char207);
        CommonToken char208 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext11.addChild(char208);
        CommonToken char209 = new CommonToken(JavadocTokenTypes.CHAR, "g");
        textContext11.addChild(char209);
        descriptionContext8.addChild(textContext11);
        CommonToken newline12 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext8.addChild(newline12);
        javadocTagContext8.addChild(descriptionContext8);
        javadocContext0.addChild(javadocTagContext8);
        JavadocTagContext javadocTagContext9 = new JavadocTagContext(javadocContext0, 0);
        CommonToken returnLiteral1 = new CommonToken(JavadocTokenTypes.RETURN_LITERAL, "@return");
        javadocTagContext9.addChild(returnLiteral1);
        CommonToken ws43 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext9.addChild(ws43);
        DescriptionContext descriptionContext9 = new DescriptionContext(javadocTagContext9, 0);
        TextContext textContext12 = new TextContext(descriptionContext9, 0);
        CommonToken char210 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext12.addChild(char210);
        CommonToken ws44 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext12.addChild(ws44);
        CommonToken char211 = new CommonToken(JavadocTokenTypes.CHAR, "v");
        textContext12.addChild(char211);
        CommonToken char212 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext12.addChild(char212);
        CommonToken char213 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext12.addChild(char213);
        CommonToken char214 = new CommonToken(JavadocTokenTypes.CHAR, "u");
        textContext12.addChild(char214);
        CommonToken char215 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext12.addChild(char215);
        CommonToken ws45 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext12.addChild(ws45);
        CommonToken char216 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext12.addChild(char216);
        CommonToken char217 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext12.addChild(char217);
        CommonToken ws46 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext12.addChild(ws46);
        CommonToken char218 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext12.addChild(char218);
        CommonToken char219 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext12.addChild(char219);
        CommonToken char220 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext12.addChild(char220);
        CommonToken char221 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext12.addChild(char221);
        CommonToken char222 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext12.addChild(char222);
        CommonToken char223 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext12.addChild(char223);
        CommonToken char224 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext12.addChild(char224);
        descriptionContext9.addChild(textContext12);
        CommonToken newline13 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext9.addChild(newline13);
        TextContext textContext13 = new TextContext(descriptionContext9, 0);
        CommonToken char225 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext13.addChild(char225);
        CommonToken char226 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext13.addChild(char226);
        CommonToken char227 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext13.addChild(char227);
        CommonToken char228 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext13.addChild(char228);
        CommonToken ws47 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext13.addChild(ws47);
        CommonToken char229 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext13.addChild(char229);
        CommonToken char230 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext13.addChild(char230);
        CommonToken ws48 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext13.addChild(ws48);
        CommonToken char231 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext13.addChild(char231);
        CommonToken char232 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext13.addChild(char232);
        CommonToken char233 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext13.addChild(char233);
        CommonToken char234 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext13.addChild(char234);
        CommonToken char235 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext13.addChild(char235);
        CommonToken char236 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext13.addChild(char236);
        CommonToken ws49 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext13.addChild(ws49);
        CommonToken char237 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext13.addChild(char237);
        CommonToken char238 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext13.addChild(char238);
        CommonToken ws50 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext13.addChild(ws50);
        CommonToken char239 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext13.addChild(char239);
        CommonToken char240 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext13.addChild(char240);
        CommonToken char241 = new CommonToken(JavadocTokenTypes.CHAR, "g");
        textContext13.addChild(char241);
        CommonToken char242 = new CommonToken(JavadocTokenTypes.CHAR, "u");
        textContext13.addChild(char242);
        CommonToken char243 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext13.addChild(char243);
        CommonToken char244 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext13.addChild(char244);
        CommonToken char245 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext13.addChild(char245);
        CommonToken char246 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext13.addChild(char246);
        CommonToken char247 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext13.addChild(char247);
        descriptionContext9.addChild(textContext13);
        CommonToken newline14 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext9.addChild(newline14);
        javadocTagContext9.addChild(descriptionContext9);
        javadocContext0.addChild(javadocTagContext9);
        JavadocTagContext javadocTagContext10 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral0 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext10.addChild(seeLiteral0);
        CommonToken ws51 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext10.addChild(ws51);
        CommonToken string0 = new CommonToken(JavadocTokenTypes.STRING, "\"A book of that famous man\"");
        javadocTagContext10.addChild(string0);
        CommonToken newline15 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext10.addChild(newline15);
        javadocContext0.addChild(javadocTagContext10);
        JavadocTagContext javadocTagContext11 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral1 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext11.addChild(seeLiteral1);
        CommonToken ws52 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext11.addChild(ws52);
        HtmlElementContext htmlElementContext1 = new HtmlElementContext(javadocTagContext11, 0);
        HtmlTagContext htmlTagContext1 = new HtmlTagContext(htmlElementContext1, 0);
        HtmlElementOpenContext htmlElementOpenContext1 = new HtmlElementOpenContext(htmlTagContext1, 0);
        CommonToken open2 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementOpenContext1.addChild(open2);
        CommonToken htmlTagName3 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "a");
        htmlElementOpenContext1.addChild(htmlTagName3);
        CommonToken ws53 = new CommonToken(JavadocTokenTypes.WS, " ");
        htmlElementOpenContext1.addChild(ws53);
        AttributeContext attributeContext1 = new AttributeContext(htmlElementOpenContext1, 0);
        CommonToken htmlTagName4 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "href");
        attributeContext1.addChild(htmlTagName4);
        CommonToken equals1 = new CommonToken(JavadocTokenTypes.EQUALS, "=");
        attributeContext1.addChild(equals1);
        CommonToken attrValue1 = new CommonToken(JavadocTokenTypes.ATTR_VALUE, "\"http://google.com\"");
        attributeContext1.addChild(attrValue1);
        htmlElementOpenContext1.addChild(attributeContext1);
        CommonToken close2 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementOpenContext1.addChild(close2);
        htmlTagContext1.addChild(htmlElementOpenContext1);
        TextContext textContext14 = new TextContext(htmlTagContext1, 0);
        CommonToken char248 = new CommonToken(JavadocTokenTypes.CHAR, "G");
        textContext14.addChild(char248);
        CommonToken char249 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext14.addChild(char249);
        CommonToken char250 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext14.addChild(char250);
        CommonToken char251 = new CommonToken(JavadocTokenTypes.CHAR, "g");
        textContext14.addChild(char251);
        CommonToken char252 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext14.addChild(char252);
        CommonToken char253 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext14.addChild(char253);
        htmlTagContext1.addChild(textContext14);
        HtmlElementCloseContext htmlElementCloseContext1 = new HtmlElementCloseContext(htmlTagContext1, 0);
        CommonToken open3 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementCloseContext1.addChild(open3);
        CommonToken slash1 = new CommonToken(JavadocTokenTypes.SLASH, "/");
        htmlElementCloseContext1.addChild(slash1);
        CommonToken htmlTagName5 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "a");
        htmlElementCloseContext1.addChild(htmlTagName5);
        CommonToken close3 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementCloseContext1.addChild(close3);
        htmlTagContext1.addChild(htmlElementCloseContext1);
        htmlElementContext1.addChild(htmlTagContext1);
        javadocTagContext11.addChild(htmlElementContext1);
        CommonToken newline16 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext11.addChild(newline16);
        javadocContext0.addChild(javadocTagContext11);
        JavadocTagContext javadocTagContext12 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral2 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext12.addChild(seeLiteral2);
        CommonToken ws54 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext12.addChild(ws54);
        HtmlElementContext htmlElementContext2 = new HtmlElementContext(javadocTagContext12, 0);
        HtmlTagContext htmlTagContext2 = new HtmlTagContext(htmlElementContext2, 0);
        HtmlElementOpenContext htmlElementOpenContext2 = new HtmlElementOpenContext(htmlTagContext2, 0);
        CommonToken open4 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementOpenContext2.addChild(open4);
        CommonToken htmlTagName6 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "a");
        htmlElementOpenContext2.addChild(htmlTagName6);
        CommonToken ws55 = new CommonToken(JavadocTokenTypes.WS, " ");
        htmlElementOpenContext2.addChild(ws55);
        AttributeContext attributeContext2 = new AttributeContext(htmlElementOpenContext2, 0);
        CommonToken htmlTagName7 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "href");
        attributeContext2.addChild(htmlTagName7);
        CommonToken equals2 = new CommonToken(JavadocTokenTypes.EQUALS, "=");
        attributeContext2.addChild(equals2);
        CommonToken attrValue2 = new CommonToken(JavadocTokenTypes.ATTR_VALUE, "\"http://google.com\"");
        attributeContext2.addChild(attrValue2);
        htmlElementOpenContext2.addChild(attributeContext2);
        CommonToken close4 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementOpenContext2.addChild(close4);
        htmlTagContext2.addChild(htmlElementOpenContext2);
        CommonToken newline17 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        htmlTagContext2.addChild(newline17);
        TextContext textContext15 = new TextContext(htmlTagContext2, 0);
        CommonToken char254 = new CommonToken(JavadocTokenTypes.CHAR, "G");
        textContext15.addChild(char254);
        CommonToken char255 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext15.addChild(char255);
        CommonToken char256 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext15.addChild(char256);
        CommonToken char257 = new CommonToken(JavadocTokenTypes.CHAR, "g");
        textContext15.addChild(char257);
        CommonToken char258 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext15.addChild(char258);
        CommonToken char259 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext15.addChild(char259);
        htmlTagContext2.addChild(textContext15);
        HtmlElementCloseContext htmlElementCloseContext2 = new HtmlElementCloseContext(htmlTagContext2, 0);
        CommonToken open5 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementCloseContext2.addChild(open5);
        CommonToken slash2 = new CommonToken(JavadocTokenTypes.SLASH, "/");
        htmlElementCloseContext2.addChild(slash2);
        CommonToken htmlTagName8 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "a");
        htmlElementCloseContext2.addChild(htmlTagName8);
        CommonToken close5 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementCloseContext2.addChild(close5);
        htmlTagContext2.addChild(htmlElementCloseContext2);
        htmlElementContext2.addChild(htmlTagContext2);
        javadocTagContext12.addChild(htmlElementContext2);
        CommonToken newline18 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext12.addChild(newline18);
        javadocContext0.addChild(javadocTagContext12);
        JavadocTagContext javadocTagContext13 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral3 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext13.addChild(seeLiteral3);
        CommonToken ws56 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext13.addChild(ws56);
        ReferenceContext referenceContext0 = new ReferenceContext(javadocTagContext13, 0);
        CommonToken package0 = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        referenceContext0.addChild(package0);
        CommonToken dot0 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext0.addChild(dot0);
        CommonToken class0 = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        referenceContext0.addChild(class0);
        CommonToken hash0 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext0.addChild(hash0);
        CommonToken member0 = new CommonToken(JavadocTokenTypes.MEMBER, "valueOf");
        referenceContext0.addChild(member0);
        javadocTagContext13.addChild(referenceContext0);
        CommonToken newline19 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext13.addChild(newline19);
        javadocContext0.addChild(javadocTagContext13);
        JavadocTagContext javadocTagContext14 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral4 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext14.addChild(seeLiteral4);
        CommonToken ws57 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext14.addChild(ws57);
        ReferenceContext referenceContext1 = new ReferenceContext(javadocTagContext14, 0);
        CommonToken package1 = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        referenceContext1.addChild(package1);
        CommonToken dot1 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext1.addChild(dot1);
        CommonToken class1 = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        referenceContext1.addChild(class1);
        CommonToken hash1 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext1.addChild(hash1);
        CommonToken member1 = new CommonToken(JavadocTokenTypes.MEMBER, "Integer");
        referenceContext1.addChild(member1);
        javadocTagContext14.addChild(referenceContext1);
        CommonToken newline20 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext14.addChild(newline20);
        javadocContext0.addChild(javadocTagContext14);
        JavadocTagContext javadocTagContext15 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral5 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext15.addChild(seeLiteral5);
        CommonToken ws58 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext15.addChild(ws58);
        ReferenceContext referenceContext2 = new ReferenceContext(javadocTagContext15, 0);
        CommonToken package2 = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        referenceContext2.addChild(package2);
        CommonToken dot2 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext2.addChild(dot2);
        CommonToken class2 = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        referenceContext2.addChild(class2);
        CommonToken hash2 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext2.addChild(hash2);
        CommonToken member2 = new CommonToken(JavadocTokenTypes.MEMBER, "MAX_VALUE");
        referenceContext2.addChild(member2);
        javadocTagContext15.addChild(referenceContext2);
        CommonToken newline21 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext15.addChild(newline21);
        javadocContext0.addChild(javadocTagContext15);
        JavadocTagContext javadocTagContext16 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral6 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext16.addChild(seeLiteral6);
        CommonToken ws59 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext16.addChild(ws59);
        ReferenceContext referenceContext3 = new ReferenceContext(javadocTagContext16, 0);
        CommonToken package3 = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        referenceContext3.addChild(package3);
        CommonToken dot3 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext3.addChild(dot3);
        CommonToken class3 = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        referenceContext3.addChild(class3);
        CommonToken hash3 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext3.addChild(hash3);
        CommonToken member3 = new CommonToken(JavadocTokenTypes.MEMBER, "valueOf");
        referenceContext3.addChild(member3);
        javadocTagContext16.addChild(referenceContext3);
        CommonToken ws60 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext16.addChild(ws60);
        DescriptionContext descriptionContext10 = new DescriptionContext(javadocTagContext16, 0);
        TextContext textContext16 = new TextContext(descriptionContext10, 0);
        CommonToken char260 = new CommonToken(JavadocTokenTypes.CHAR, "v");
        textContext16.addChild(char260);
        CommonToken char261 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext16.addChild(char261);
        CommonToken char262 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext16.addChild(char262);
        CommonToken char263 = new CommonToken(JavadocTokenTypes.CHAR, "u");
        textContext16.addChild(char263);
        CommonToken char264 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext16.addChild(char264);
        CommonToken char265 = new CommonToken(JavadocTokenTypes.CHAR, "O");
        textContext16.addChild(char265);
        CommonToken char266 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext16.addChild(char266);
        CommonToken ws61 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext16.addChild(ws61);
        CommonToken char267 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext16.addChild(char267);
        CommonToken char268 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext16.addChild(char268);
        CommonToken char269 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext16.addChild(char269);
        CommonToken char270 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext16.addChild(char270);
        CommonToken char271 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext16.addChild(char271);
        CommonToken char272 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext16.addChild(char272);
        descriptionContext10.addChild(textContext16);
        CommonToken newline22 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext10.addChild(newline22);
        javadocTagContext16.addChild(descriptionContext10);
        javadocContext0.addChild(javadocTagContext16);
        JavadocTagContext javadocTagContext17 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral7 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext17.addChild(seeLiteral7);
        CommonToken ws62 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext17.addChild(ws62);
        ReferenceContext referenceContext4 = new ReferenceContext(javadocTagContext17, 0);
        CommonToken package4 = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        referenceContext4.addChild(package4);
        CommonToken dot4 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext4.addChild(dot4);
        CommonToken class4 = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        referenceContext4.addChild(class4);
        CommonToken hash4 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext4.addChild(hash4);
        CommonToken member4 = new CommonToken(JavadocTokenTypes.MEMBER, "Integer");
        referenceContext4.addChild(member4);
        javadocTagContext17.addChild(referenceContext4);
        CommonToken ws63 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext17.addChild(ws63);
        DescriptionContext descriptionContext11 = new DescriptionContext(javadocTagContext17, 0);
        TextContext textContext17 = new TextContext(descriptionContext11, 0);
        CommonToken char273 = new CommonToken(JavadocTokenTypes.CHAR, "I");
        textContext17.addChild(char273);
        CommonToken char274 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext17.addChild(char274);
        CommonToken char275 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext17.addChild(char275);
        CommonToken char276 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext17.addChild(char276);
        CommonToken char277 = new CommonToken(JavadocTokenTypes.CHAR, "g");
        textContext17.addChild(char277);
        CommonToken char278 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext17.addChild(char278);
        CommonToken char279 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext17.addChild(char279);
        descriptionContext11.addChild(textContext17);
        CommonToken newline23 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext11.addChild(newline23);
        javadocTagContext17.addChild(descriptionContext11);
        javadocContext0.addChild(javadocTagContext17);
        JavadocTagContext javadocTagContext18 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral8 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext18.addChild(seeLiteral8);
        CommonToken ws64 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext18.addChild(ws64);
        ReferenceContext referenceContext5 = new ReferenceContext(javadocTagContext18, 0);
        CommonToken package5 = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        referenceContext5.addChild(package5);
        CommonToken dot5 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext5.addChild(dot5);
        CommonToken class5 = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        referenceContext5.addChild(class5);
        CommonToken hash5 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext5.addChild(hash5);
        CommonToken member5 = new CommonToken(JavadocTokenTypes.MEMBER, "MAX_VALUE");
        referenceContext5.addChild(member5);
        javadocTagContext18.addChild(referenceContext5);
        CommonToken ws65 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext18.addChild(ws65);
        DescriptionContext descriptionContext12 = new DescriptionContext(javadocTagContext18, 0);
        TextContext textContext18 = new TextContext(descriptionContext12, 0);
        CommonToken char280 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext18.addChild(char280);
        CommonToken char281 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext18.addChild(char281);
        CommonToken char282 = new CommonToken(JavadocTokenTypes.CHAR, "x");
        textContext18.addChild(char282);
        CommonToken char283 = new CommonToken(JavadocTokenTypes.CHAR, "V");
        textContext18.addChild(char283);
        CommonToken char284 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext18.addChild(char284);
        CommonToken char285 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext18.addChild(char285);
        CommonToken char286 = new CommonToken(JavadocTokenTypes.CHAR, "u");
        textContext18.addChild(char286);
        CommonToken char287 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext18.addChild(char287);
        descriptionContext12.addChild(textContext18);
        CommonToken newline24 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext12.addChild(newline24);
        javadocTagContext18.addChild(descriptionContext12);
        javadocContext0.addChild(javadocTagContext18);
        JavadocTagContext javadocTagContext19 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral9 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext19.addChild(seeLiteral9);
        CommonToken ws66 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext19.addChild(ws66);
        ReferenceContext referenceContext6 = new ReferenceContext(javadocTagContext19, 0);
        CommonToken package6 = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        referenceContext6.addChild(package6);
        CommonToken dot6 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext6.addChild(dot6);
        CommonToken class6 = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        referenceContext6.addChild(class6);
        CommonToken hash6 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext6.addChild(hash6);
        CommonToken member6 = new CommonToken(JavadocTokenTypes.MEMBER, "intValue");
        referenceContext6.addChild(member6);
        javadocTagContext19.addChild(referenceContext6);
        CommonToken ws67 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext19.addChild(ws67);
        DescriptionContext descriptionContext13 = new DescriptionContext(javadocTagContext19, 0);
        TextContext textContext19 = new TextContext(descriptionContext13, 0);
        CommonToken char288 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext19.addChild(char288);
        CommonToken char289 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext19.addChild(char289);
        CommonToken char290 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext19.addChild(char290);
        CommonToken char291 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext19.addChild(char291);
        CommonToken char292 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext19.addChild(char292);
        CommonToken char293 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext19.addChild(char293);
        descriptionContext13.addChild(textContext19);
        CommonToken newline25 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext13.addChild(newline25);
        javadocTagContext19.addChild(descriptionContext13);
        javadocContext0.addChild(javadocTagContext19);
        JavadocTagContext javadocTagContext20 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral10 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext20.addChild(seeLiteral10);
        CommonToken ws68 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext20.addChild(ws68);
        ReferenceContext referenceContext7 = new ReferenceContext(javadocTagContext20, 0);
        CommonToken package7 = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        referenceContext7.addChild(package7);
        CommonToken dot7 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext7.addChild(dot7);
        CommonToken class7 = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        referenceContext7.addChild(class7);
        CommonToken hash7 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext7.addChild(hash7);
        CommonToken member7 = new CommonToken(JavadocTokenTypes.MEMBER, "intValue");
        referenceContext7.addChild(member7);
        ParametersContext parametersContext0 = new ParametersContext(referenceContext7, 0);
        CommonToken leftBrace0 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext0.addChild(leftBrace0);
        CommonToken rightBrace0 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext0.addChild(rightBrace0);
        referenceContext7.addChild(parametersContext0);
        javadocTagContext20.addChild(referenceContext7);
        CommonToken ws69 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext20.addChild(ws69);
        DescriptionContext descriptionContext14 = new DescriptionContext(javadocTagContext20, 0);
        TextContext textContext20 = new TextContext(descriptionContext14, 0);
        CommonToken char294 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext20.addChild(char294);
        CommonToken char295 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext20.addChild(char295);
        CommonToken char296 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext20.addChild(char296);
        CommonToken char297 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext20.addChild(char297);
        CommonToken char298 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext20.addChild(char298);
        CommonToken char299 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext20.addChild(char299);
        descriptionContext14.addChild(textContext20);
        CommonToken newline26 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext14.addChild(newline26);
        javadocTagContext20.addChild(descriptionContext14);
        javadocContext0.addChild(javadocTagContext20);
        JavadocTagContext javadocTagContext21 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral11 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext21.addChild(seeLiteral11);
        CommonToken ws70 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext21.addChild(ws70);
        ReferenceContext referenceContext8 = new ReferenceContext(javadocTagContext21, 0);
        CommonToken package8 = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        referenceContext8.addChild(package8);
        CommonToken dot8 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext8.addChild(dot8);
        CommonToken class8 = new CommonToken(JavadocTokenTypes.CLASS, "Void");
        referenceContext8.addChild(class8);
        CommonToken hash8 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext8.addChild(hash8);
        CommonToken member8 = new CommonToken(JavadocTokenTypes.MEMBER, "Void");
        referenceContext8.addChild(member8);
        javadocTagContext21.addChild(referenceContext8);
        CommonToken ws71 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext21.addChild(ws71);
        DescriptionContext descriptionContext15 = new DescriptionContext(javadocTagContext21, 0);
        TextContext textContext21 = new TextContext(descriptionContext15, 0);
        CommonToken char300 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext21.addChild(char300);
        CommonToken char301 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext21.addChild(char301);
        CommonToken char302 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext21.addChild(char302);
        CommonToken char303 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext21.addChild(char303);
        CommonToken char304 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext21.addChild(char304);
        CommonToken char305 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext21.addChild(char305);
        CommonToken char306 = new CommonToken(JavadocTokenTypes.CHAR, "u");
        textContext21.addChild(char306);
        CommonToken char307 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext21.addChild(char307);
        CommonToken char308 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext21.addChild(char308);
        CommonToken char309 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext21.addChild(char309);
        CommonToken char310 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext21.addChild(char310);
        descriptionContext15.addChild(textContext21);
        CommonToken newline27 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext15.addChild(newline27);
        javadocTagContext21.addChild(descriptionContext15);
        javadocContext0.addChild(javadocTagContext21);
        JavadocTagContext javadocTagContext22 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral12 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext22.addChild(seeLiteral12);
        CommonToken ws72 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext22.addChild(ws72);
        ReferenceContext referenceContext9 = new ReferenceContext(javadocTagContext22, 0);
        CommonToken package9 = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        referenceContext9.addChild(package9);
        CommonToken dot9 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext9.addChild(dot9);
        CommonToken class9 = new CommonToken(JavadocTokenTypes.CLASS, "Void");
        referenceContext9.addChild(class9);
        CommonToken hash9 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext9.addChild(hash9);
        CommonToken member9 = new CommonToken(JavadocTokenTypes.MEMBER, "Void");
        referenceContext9.addChild(member9);
        ParametersContext parametersContext1 = new ParametersContext(referenceContext9, 0);
        CommonToken leftBrace1 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext1.addChild(leftBrace1);
        CommonToken rightBrace1 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext1.addChild(rightBrace1);
        referenceContext9.addChild(parametersContext1);
        javadocTagContext22.addChild(referenceContext9);
        CommonToken ws73 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext22.addChild(ws73);
        DescriptionContext descriptionContext16 = new DescriptionContext(javadocTagContext22, 0);
        TextContext textContext22 = new TextContext(descriptionContext16, 0);
        CommonToken char311 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext22.addChild(char311);
        CommonToken char312 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext22.addChild(char312);
        CommonToken char313 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext22.addChild(char313);
        CommonToken char314 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext22.addChild(char314);
        CommonToken char315 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext22.addChild(char315);
        CommonToken char316 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext22.addChild(char316);
        CommonToken char317 = new CommonToken(JavadocTokenTypes.CHAR, "u");
        textContext22.addChild(char317);
        CommonToken char318 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext22.addChild(char318);
        CommonToken char319 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext22.addChild(char319);
        CommonToken char320 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext22.addChild(char320);
        CommonToken char321 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext22.addChild(char321);
        descriptionContext16.addChild(textContext22);
        CommonToken newline28 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext16.addChild(newline28);
        javadocTagContext22.addChild(descriptionContext16);
        javadocContext0.addChild(javadocTagContext22);
        JavadocTagContext javadocTagContext23 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral13 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext23.addChild(seeLiteral13);
        CommonToken ws74 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext23.addChild(ws74);
        ReferenceContext referenceContext10 = new ReferenceContext(javadocTagContext23, 0);
        CommonToken package10 = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        referenceContext10.addChild(package10);
        CommonToken dot10 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext10.addChild(dot10);
        CommonToken class10 = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        referenceContext10.addChild(class10);
        CommonToken hash10 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext10.addChild(hash10);
        CommonToken member10 = new CommonToken(JavadocTokenTypes.MEMBER, "valueOf");
        referenceContext10.addChild(member10);
        ParametersContext parametersContext2 = new ParametersContext(referenceContext10, 0);
        CommonToken leftBrace2 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext2.addChild(leftBrace2);
        CommonToken argument0 = new CommonToken(JavadocTokenTypes.ARGUMENT, "String");
        parametersContext2.addChild(argument0);
        CommonToken rightBrace2 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext2.addChild(rightBrace2);
        referenceContext10.addChild(parametersContext2);
        javadocTagContext23.addChild(referenceContext10);
        CommonToken ws75 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext23.addChild(ws75);
        DescriptionContext descriptionContext17 = new DescriptionContext(javadocTagContext23, 0);
        TextContext textContext23 = new TextContext(descriptionContext17, 0);
        CommonToken char322 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext23.addChild(char322);
        CommonToken char323 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext23.addChild(char323);
        CommonToken char324 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext23.addChild(char324);
        CommonToken char325 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext23.addChild(char325);
        CommonToken char326 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext23.addChild(char326);
        CommonToken char327 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext23.addChild(char327);
        descriptionContext17.addChild(textContext23);
        CommonToken newline29 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext17.addChild(newline29);
        javadocTagContext23.addChild(descriptionContext17);
        javadocContext0.addChild(javadocTagContext23);
        JavadocTagContext javadocTagContext24 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral14 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext24.addChild(seeLiteral14);
        CommonToken ws76 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext24.addChild(ws76);
        ReferenceContext referenceContext11 = new ReferenceContext(javadocTagContext24, 0);
        CommonToken package11 = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        referenceContext11.addChild(package11);
        CommonToken dot11 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext11.addChild(dot11);
        CommonToken class11 = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        referenceContext11.addChild(class11);
        CommonToken hash11 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext11.addChild(hash11);
        CommonToken member11 = new CommonToken(JavadocTokenTypes.MEMBER, "toString");
        referenceContext11.addChild(member11);
        ParametersContext parametersContext3 = new ParametersContext(referenceContext11, 0);
        CommonToken leftBrace3 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext3.addChild(leftBrace3);
        CommonToken argument1 = new CommonToken(JavadocTokenTypes.ARGUMENT, "int");
        parametersContext3.addChild(argument1);
        CommonToken comma0 = new CommonToken(JavadocTokenTypes.COMMA, ",");
        parametersContext3.addChild(comma0);
        CommonToken argument2 = new CommonToken(JavadocTokenTypes.ARGUMENT, "int");
        parametersContext3.addChild(argument2);
        CommonToken rightBrace3 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext3.addChild(rightBrace3);
        referenceContext11.addChild(parametersContext3);
        javadocTagContext24.addChild(referenceContext11);
        CommonToken ws77 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext24.addChild(ws77);
        DescriptionContext descriptionContext18 = new DescriptionContext(javadocTagContext24, 0);
        TextContext textContext24 = new TextContext(descriptionContext18, 0);
        CommonToken char328 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext24.addChild(char328);
        CommonToken char329 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext24.addChild(char329);
        CommonToken char330 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext24.addChild(char330);
        CommonToken char331 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext24.addChild(char331);
        CommonToken char332 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext24.addChild(char332);
        CommonToken char333 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext24.addChild(char333);
        descriptionContext18.addChild(textContext24);
        CommonToken newline30 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext18.addChild(newline30);
        javadocTagContext24.addChild(descriptionContext18);
        javadocContext0.addChild(javadocTagContext24);
        JavadocTagContext javadocTagContext25 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral15 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext25.addChild(seeLiteral15);
        CommonToken ws78 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext25.addChild(ws78);
        ReferenceContext referenceContext12 = new ReferenceContext(javadocTagContext25, 0);
        CommonToken package12 = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        referenceContext12.addChild(package12);
        CommonToken dot12 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext12.addChild(dot12);
        CommonToken class12 = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        referenceContext12.addChild(class12);
        CommonToken hash12 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext12.addChild(hash12);
        CommonToken member12 = new CommonToken(JavadocTokenTypes.MEMBER, "toString");
        referenceContext12.addChild(member12);
        ParametersContext parametersContext4 = new ParametersContext(referenceContext12, 0);
        CommonToken leftBrace4 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext4.addChild(leftBrace4);
        CommonToken argument3 = new CommonToken(JavadocTokenTypes.ARGUMENT, "int");
        parametersContext4.addChild(argument3);
        CommonToken comma1 = new CommonToken(JavadocTokenTypes.COMMA, ",");
        parametersContext4.addChild(comma1);
        CommonToken ws79 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext4.addChild(ws79);
        CommonToken argument4 = new CommonToken(JavadocTokenTypes.ARGUMENT, "int");
        parametersContext4.addChild(argument4);
        CommonToken rightBrace4 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext4.addChild(rightBrace4);
        referenceContext12.addChild(parametersContext4);
        javadocTagContext25.addChild(referenceContext12);
        CommonToken ws80 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext25.addChild(ws80);
        DescriptionContext descriptionContext19 = new DescriptionContext(javadocTagContext25, 0);
        TextContext textContext25 = new TextContext(descriptionContext19, 0);
        CommonToken char334 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext25.addChild(char334);
        CommonToken char335 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext25.addChild(char335);
        CommonToken char336 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext25.addChild(char336);
        CommonToken char337 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext25.addChild(char337);
        CommonToken char338 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext25.addChild(char338);
        CommonToken char339 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext25.addChild(char339);
        descriptionContext19.addChild(textContext25);
        CommonToken newline31 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext19.addChild(newline31);
        javadocTagContext25.addChild(descriptionContext19);
        javadocContext0.addChild(javadocTagContext25);
        JavadocTagContext javadocTagContext26 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral16 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext26.addChild(seeLiteral16);
        CommonToken ws81 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext26.addChild(ws81);
        ReferenceContext referenceContext13 = new ReferenceContext(javadocTagContext26, 0);
        CommonToken hash13 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext13.addChild(hash13);
        CommonToken member13 = new CommonToken(JavadocTokenTypes.MEMBER, "field");
        referenceContext13.addChild(member13);
        javadocTagContext26.addChild(referenceContext13);
        CommonToken newline32 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext26.addChild(newline32);
        javadocContext0.addChild(javadocTagContext26);
        JavadocTagContext javadocTagContext27 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral17 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext27.addChild(seeLiteral17);
        CommonToken ws82 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext27.addChild(ws82);
        ReferenceContext referenceContext14 = new ReferenceContext(javadocTagContext27, 0);
        CommonToken hash14 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext14.addChild(hash14);
        CommonToken member14 = new CommonToken(JavadocTokenTypes.MEMBER, "method");
        referenceContext14.addChild(member14);
        ParametersContext parametersContext5 = new ParametersContext(referenceContext14, 0);
        CommonToken leftBrace5 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext5.addChild(leftBrace5);
        CommonToken argument5 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext5.addChild(argument5);
        CommonToken comma2 = new CommonToken(JavadocTokenTypes.COMMA, ",");
        parametersContext5.addChild(comma2);
        CommonToken ws83 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext5.addChild(ws83);
        CommonToken argument6 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext5.addChild(argument6);
        CommonToken rightBrace5 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext5.addChild(rightBrace5);
        referenceContext14.addChild(parametersContext5);
        javadocTagContext27.addChild(referenceContext14);
        CommonToken newline33 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext27.addChild(newline33);
        javadocContext0.addChild(javadocTagContext27);
        JavadocTagContext javadocTagContext28 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral18 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext28.addChild(seeLiteral18);
        CommonToken ws84 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext28.addChild(ws84);
        ReferenceContext referenceContext15 = new ReferenceContext(javadocTagContext28, 0);
        CommonToken hash15 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext15.addChild(hash15);
        CommonToken member15 = new CommonToken(JavadocTokenTypes.MEMBER, "method");
        referenceContext15.addChild(member15);
        ParametersContext parametersContext6 = new ParametersContext(referenceContext15, 0);
        CommonToken leftBrace6 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext6.addChild(leftBrace6);
        CommonToken argument7 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext6.addChild(argument7);
        CommonToken ws85 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext6.addChild(ws85);
        CommonToken argument8 = new CommonToken(JavadocTokenTypes.ARGUMENT, "argname");
        parametersContext6.addChild(argument8);
        CommonToken comma3 = new CommonToken(JavadocTokenTypes.COMMA, ",");
        parametersContext6.addChild(comma3);
        CommonToken ws86 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext6.addChild(ws86);
        CommonToken argument9 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext6.addChild(argument9);
        CommonToken ws87 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext6.addChild(ws87);
        CommonToken argument10 = new CommonToken(JavadocTokenTypes.ARGUMENT, "argname");
        parametersContext6.addChild(argument10);
        CommonToken rightBrace6 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext6.addChild(rightBrace6);
        referenceContext15.addChild(parametersContext6);
        javadocTagContext28.addChild(referenceContext15);
        CommonToken newline34 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext28.addChild(newline34);
        javadocContext0.addChild(javadocTagContext28);
        JavadocTagContext javadocTagContext29 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral19 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext29.addChild(seeLiteral19);
        CommonToken ws88 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext29.addChild(ws88);
        ReferenceContext referenceContext16 = new ReferenceContext(javadocTagContext29, 0);
        CommonToken hash16 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext16.addChild(hash16);
        CommonToken member16 = new CommonToken(JavadocTokenTypes.MEMBER, "constructor");
        referenceContext16.addChild(member16);
        ParametersContext parametersContext7 = new ParametersContext(referenceContext16, 0);
        CommonToken leftBrace7 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext7.addChild(leftBrace7);
        CommonToken argument11 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext7.addChild(argument11);
        CommonToken comma4 = new CommonToken(JavadocTokenTypes.COMMA, ",");
        parametersContext7.addChild(comma4);
        CommonToken ws89 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext7.addChild(ws89);
        CommonToken argument12 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext7.addChild(argument12);
        CommonToken rightBrace7 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext7.addChild(rightBrace7);
        referenceContext16.addChild(parametersContext7);
        javadocTagContext29.addChild(referenceContext16);
        CommonToken newline35 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext29.addChild(newline35);
        javadocContext0.addChild(javadocTagContext29);
        JavadocTagContext javadocTagContext30 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral20 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext30.addChild(seeLiteral20);
        CommonToken ws90 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext30.addChild(ws90);
        ReferenceContext referenceContext17 = new ReferenceContext(javadocTagContext30, 0);
        CommonToken hash17 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext17.addChild(hash17);
        CommonToken member17 = new CommonToken(JavadocTokenTypes.MEMBER, "constructor");
        referenceContext17.addChild(member17);
        ParametersContext parametersContext8 = new ParametersContext(referenceContext17, 0);
        CommonToken leftBrace8 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext8.addChild(leftBrace8);
        CommonToken argument13 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext8.addChild(argument13);
        CommonToken ws91 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext8.addChild(ws91);
        CommonToken argument14 = new CommonToken(JavadocTokenTypes.ARGUMENT, "argname");
        parametersContext8.addChild(argument14);
        CommonToken comma5 = new CommonToken(JavadocTokenTypes.COMMA, ",");
        parametersContext8.addChild(comma5);
        CommonToken ws92 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext8.addChild(ws92);
        CommonToken argument15 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext8.addChild(argument15);
        CommonToken ws93 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext8.addChild(ws93);
        CommonToken argument16 = new CommonToken(JavadocTokenTypes.ARGUMENT, "argname");
        parametersContext8.addChild(argument16);
        CommonToken rightBrace8 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext8.addChild(rightBrace8);
        referenceContext17.addChild(parametersContext8);
        javadocTagContext30.addChild(referenceContext17);
        CommonToken newline36 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext30.addChild(newline36);
        javadocContext0.addChild(javadocTagContext30);
        JavadocTagContext javadocTagContext31 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral21 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext31.addChild(seeLiteral21);
        CommonToken ws94 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext31.addChild(ws94);
        ReferenceContext referenceContext18 = new ReferenceContext(javadocTagContext31, 0);
        CommonToken class13 = new CommonToken(JavadocTokenTypes.CLASS, "Class");
        referenceContext18.addChild(class13);
        CommonToken hash18 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext18.addChild(hash18);
        CommonToken member18 = new CommonToken(JavadocTokenTypes.MEMBER, "field");
        referenceContext18.addChild(member18);
        javadocTagContext31.addChild(referenceContext18);
        CommonToken newline37 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext31.addChild(newline37);
        javadocContext0.addChild(javadocTagContext31);
        JavadocTagContext javadocTagContext32 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral22 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext32.addChild(seeLiteral22);
        CommonToken ws95 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext32.addChild(ws95);
        ReferenceContext referenceContext19 = new ReferenceContext(javadocTagContext32, 0);
        CommonToken class14 = new CommonToken(JavadocTokenTypes.CLASS, "Class");
        referenceContext19.addChild(class14);
        CommonToken hash19 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext19.addChild(hash19);
        CommonToken member19 = new CommonToken(JavadocTokenTypes.MEMBER, "method");
        referenceContext19.addChild(member19);
        ParametersContext parametersContext9 = new ParametersContext(referenceContext19, 0);
        CommonToken leftBrace9 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext9.addChild(leftBrace9);
        CommonToken argument17 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext9.addChild(argument17);
        CommonToken comma6 = new CommonToken(JavadocTokenTypes.COMMA, ",");
        parametersContext9.addChild(comma6);
        CommonToken ws96 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext9.addChild(ws96);
        CommonToken argument18 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext9.addChild(argument18);
        CommonToken comma7 = new CommonToken(JavadocTokenTypes.COMMA, ",");
        parametersContext9.addChild(comma7);
        CommonToken ws97 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext9.addChild(ws97);
        CommonToken argument19 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext9.addChild(argument19);
        CommonToken rightBrace9 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext9.addChild(rightBrace9);
        referenceContext19.addChild(parametersContext9);
        javadocTagContext32.addChild(referenceContext19);
        CommonToken newline38 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext32.addChild(newline38);
        javadocContext0.addChild(javadocTagContext32);
        JavadocTagContext javadocTagContext33 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral23 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext33.addChild(seeLiteral23);
        CommonToken ws98 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext33.addChild(ws98);
        ReferenceContext referenceContext20 = new ReferenceContext(javadocTagContext33, 0);
        CommonToken class15 = new CommonToken(JavadocTokenTypes.CLASS, "Class");
        referenceContext20.addChild(class15);
        CommonToken hash20 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext20.addChild(hash20);
        CommonToken member20 = new CommonToken(JavadocTokenTypes.MEMBER, "method");
        referenceContext20.addChild(member20);
        ParametersContext parametersContext10 = new ParametersContext(referenceContext20, 0);
        CommonToken leftBrace10 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext10.addChild(leftBrace10);
        CommonToken argument20 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext10.addChild(argument20);
        CommonToken ws99 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext10.addChild(ws99);
        CommonToken argument21 = new CommonToken(JavadocTokenTypes.ARGUMENT, "argname");
        parametersContext10.addChild(argument21);
        CommonToken comma8 = new CommonToken(JavadocTokenTypes.COMMA, ",");
        parametersContext10.addChild(comma8);
        CommonToken ws100 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext10.addChild(ws100);
        CommonToken argument22 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext10.addChild(argument22);
        CommonToken ws101 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext10.addChild(ws101);
        CommonToken argument23 = new CommonToken(JavadocTokenTypes.ARGUMENT, "argname");
        parametersContext10.addChild(argument23);
        CommonToken rightBrace10 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext10.addChild(rightBrace10);
        referenceContext20.addChild(parametersContext10);
        javadocTagContext33.addChild(referenceContext20);
        CommonToken newline39 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext33.addChild(newline39);
        javadocContext0.addChild(javadocTagContext33);
        JavadocTagContext javadocTagContext34 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral24 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext34.addChild(seeLiteral24);
        CommonToken ws102 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext34.addChild(ws102);
        ReferenceContext referenceContext21 = new ReferenceContext(javadocTagContext34, 0);
        CommonToken class16 = new CommonToken(JavadocTokenTypes.CLASS, "Class");
        referenceContext21.addChild(class16);
        CommonToken hash21 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext21.addChild(hash21);
        CommonToken member21 = new CommonToken(JavadocTokenTypes.MEMBER, "constructor");
        referenceContext21.addChild(member21);
        ParametersContext parametersContext11 = new ParametersContext(referenceContext21, 0);
        CommonToken leftBrace11 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext11.addChild(leftBrace11);
        CommonToken argument24 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext11.addChild(argument24);
        CommonToken comma9 = new CommonToken(JavadocTokenTypes.COMMA, ",");
        parametersContext11.addChild(comma9);
        CommonToken ws103 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext11.addChild(ws103);
        CommonToken argument25 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext11.addChild(argument25);
        CommonToken rightBrace11 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext11.addChild(rightBrace11);
        referenceContext21.addChild(parametersContext11);
        javadocTagContext34.addChild(referenceContext21);
        CommonToken newline40 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext34.addChild(newline40);
        javadocContext0.addChild(javadocTagContext34);
        JavadocTagContext javadocTagContext35 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral25 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext35.addChild(seeLiteral25);
        CommonToken ws104 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext35.addChild(ws104);
        ReferenceContext referenceContext22 = new ReferenceContext(javadocTagContext35, 0);
        CommonToken class17 = new CommonToken(JavadocTokenTypes.CLASS, "Class");
        referenceContext22.addChild(class17);
        CommonToken hash22 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext22.addChild(hash22);
        CommonToken member22 = new CommonToken(JavadocTokenTypes.MEMBER, "constructor");
        referenceContext22.addChild(member22);
        ParametersContext parametersContext12 = new ParametersContext(referenceContext22, 0);
        CommonToken leftBrace12 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext12.addChild(leftBrace12);
        CommonToken argument26 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext12.addChild(argument26);
        CommonToken ws105 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext12.addChild(ws105);
        CommonToken argument27 = new CommonToken(JavadocTokenTypes.ARGUMENT, "argname");
        parametersContext12.addChild(argument27);
        CommonToken comma10 = new CommonToken(JavadocTokenTypes.COMMA, ",");
        parametersContext12.addChild(comma10);
        CommonToken ws106 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext12.addChild(ws106);
        CommonToken argument28 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext12.addChild(argument28);
        CommonToken ws107 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext12.addChild(ws107);
        CommonToken argument29 = new CommonToken(JavadocTokenTypes.ARGUMENT, "argname");
        parametersContext12.addChild(argument29);
        CommonToken rightBrace12 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext12.addChild(rightBrace12);
        referenceContext22.addChild(parametersContext12);
        javadocTagContext35.addChild(referenceContext22);
        CommonToken newline41 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext35.addChild(newline41);
        javadocContext0.addChild(javadocTagContext35);
        JavadocTagContext javadocTagContext36 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral26 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext36.addChild(seeLiteral26);
        CommonToken ws108 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext36.addChild(ws108);
        ReferenceContext referenceContext23 = new ReferenceContext(javadocTagContext36, 0);
        CommonToken class18 = new CommonToken(JavadocTokenTypes.CLASS, "Class");
        referenceContext23.addChild(class18);
        CommonToken dot13 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext23.addChild(dot13);
        CommonToken class19 = new CommonToken(JavadocTokenTypes.CLASS, "NestedClass");
        referenceContext23.addChild(class19);
        javadocTagContext36.addChild(referenceContext23);
        CommonToken newline42 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext36.addChild(newline42);
        javadocContext0.addChild(javadocTagContext36);
        JavadocTagContext javadocTagContext37 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral27 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext37.addChild(seeLiteral27);
        CommonToken ws109 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext37.addChild(ws109);
        ReferenceContext referenceContext24 = new ReferenceContext(javadocTagContext37, 0);
        CommonToken class20 = new CommonToken(JavadocTokenTypes.CLASS, "Class");
        referenceContext24.addChild(class20);
        javadocTagContext37.addChild(referenceContext24);
        CommonToken newline43 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext37.addChild(newline43);
        javadocContext0.addChild(javadocTagContext37);
        JavadocTagContext javadocTagContext38 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral28 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext38.addChild(seeLiteral28);
        CommonToken ws110 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext38.addChild(ws110);
        ReferenceContext referenceContext25 = new ReferenceContext(javadocTagContext38, 0);
        CommonToken package13 = new CommonToken(JavadocTokenTypes.PACKAGE, "com.github.checkstyle");
        referenceContext25.addChild(package13);
        CommonToken dot14 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext25.addChild(dot14);
        CommonToken class21 = new CommonToken(JavadocTokenTypes.CLASS, "Class");
        referenceContext25.addChild(class21);
        CommonToken hash23 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext25.addChild(hash23);
        CommonToken member23 = new CommonToken(JavadocTokenTypes.MEMBER, "field");
        referenceContext25.addChild(member23);
        javadocTagContext38.addChild(referenceContext25);
        CommonToken newline44 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext38.addChild(newline44);
        javadocContext0.addChild(javadocTagContext38);
        JavadocTagContext javadocTagContext39 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral29 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext39.addChild(seeLiteral29);
        CommonToken ws111 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext39.addChild(ws111);
        ReferenceContext referenceContext26 = new ReferenceContext(javadocTagContext39, 0);
        CommonToken package14 = new CommonToken(JavadocTokenTypes.PACKAGE, "com.github.checkstyle");
        referenceContext26.addChild(package14);
        CommonToken dot15 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext26.addChild(dot15);
        CommonToken class22 = new CommonToken(JavadocTokenTypes.CLASS, "Class");
        referenceContext26.addChild(class22);
        CommonToken hash24 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext26.addChild(hash24);
        CommonToken member24 = new CommonToken(JavadocTokenTypes.MEMBER, "method");
        referenceContext26.addChild(member24);
        ParametersContext parametersContext13 = new ParametersContext(referenceContext26, 0);
        CommonToken leftBrace13 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext13.addChild(leftBrace13);
        CommonToken argument30 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext13.addChild(argument30);
        CommonToken comma11 = new CommonToken(JavadocTokenTypes.COMMA, ",");
        parametersContext13.addChild(comma11);
        CommonToken ws112 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext13.addChild(ws112);
        CommonToken argument31 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext13.addChild(argument31);
        CommonToken rightBrace13 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext13.addChild(rightBrace13);
        referenceContext26.addChild(parametersContext13);
        javadocTagContext39.addChild(referenceContext26);
        CommonToken newline45 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext39.addChild(newline45);
        javadocContext0.addChild(javadocTagContext39);
        JavadocTagContext javadocTagContext40 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral30 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext40.addChild(seeLiteral30);
        CommonToken ws113 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext40.addChild(ws113);
        ReferenceContext referenceContext27 = new ReferenceContext(javadocTagContext40, 0);
        CommonToken package15 = new CommonToken(JavadocTokenTypes.PACKAGE, "com.github.checkstyle");
        referenceContext27.addChild(package15);
        CommonToken dot16 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext27.addChild(dot16);
        CommonToken class23 = new CommonToken(JavadocTokenTypes.CLASS, "Class");
        referenceContext27.addChild(class23);
        CommonToken hash25 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext27.addChild(hash25);
        CommonToken member25 = new CommonToken(JavadocTokenTypes.MEMBER, "method");
        referenceContext27.addChild(member25);
        ParametersContext parametersContext14 = new ParametersContext(referenceContext27, 0);
        CommonToken leftBrace14 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext14.addChild(leftBrace14);
        CommonToken argument32 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext14.addChild(argument32);
        CommonToken ws114 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext14.addChild(ws114);
        CommonToken argument33 = new CommonToken(JavadocTokenTypes.ARGUMENT, "argname");
        parametersContext14.addChild(argument33);
        CommonToken comma12 = new CommonToken(JavadocTokenTypes.COMMA, ",");
        parametersContext14.addChild(comma12);
        CommonToken ws115 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext14.addChild(ws115);
        CommonToken argument34 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext14.addChild(argument34);
        CommonToken ws116 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext14.addChild(ws116);
        CommonToken argument35 = new CommonToken(JavadocTokenTypes.ARGUMENT, "argname");
        parametersContext14.addChild(argument35);
        CommonToken rightBrace14 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext14.addChild(rightBrace14);
        referenceContext27.addChild(parametersContext14);
        javadocTagContext40.addChild(referenceContext27);
        CommonToken newline46 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext40.addChild(newline46);
        javadocContext0.addChild(javadocTagContext40);
        JavadocTagContext javadocTagContext41 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral31 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext41.addChild(seeLiteral31);
        CommonToken ws117 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext41.addChild(ws117);
        ReferenceContext referenceContext28 = new ReferenceContext(javadocTagContext41, 0);
        CommonToken package16 = new CommonToken(JavadocTokenTypes.PACKAGE, "com.github.checkstyle");
        referenceContext28.addChild(package16);
        CommonToken dot17 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext28.addChild(dot17);
        CommonToken class24 = new CommonToken(JavadocTokenTypes.CLASS, "Class");
        referenceContext28.addChild(class24);
        CommonToken hash26 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext28.addChild(hash26);
        CommonToken member26 = new CommonToken(JavadocTokenTypes.MEMBER, "constructor");
        referenceContext28.addChild(member26);
        ParametersContext parametersContext15 = new ParametersContext(referenceContext28, 0);
        CommonToken leftBrace15 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext15.addChild(leftBrace15);
        CommonToken argument36 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext15.addChild(argument36);
        CommonToken comma13 = new CommonToken(JavadocTokenTypes.COMMA, ",");
        parametersContext15.addChild(comma13);
        CommonToken ws118 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext15.addChild(ws118);
        CommonToken argument37 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext15.addChild(argument37);
        CommonToken rightBrace15 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext15.addChild(rightBrace15);
        referenceContext28.addChild(parametersContext15);
        javadocTagContext41.addChild(referenceContext28);
        CommonToken newline47 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext41.addChild(newline47);
        javadocContext0.addChild(javadocTagContext41);
        JavadocTagContext javadocTagContext42 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral32 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext42.addChild(seeLiteral32);
        CommonToken ws119 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext42.addChild(ws119);
        ReferenceContext referenceContext29 = new ReferenceContext(javadocTagContext42, 0);
        CommonToken package17 = new CommonToken(JavadocTokenTypes.PACKAGE, "com.github.checkstyle");
        referenceContext29.addChild(package17);
        CommonToken dot18 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext29.addChild(dot18);
        CommonToken class25 = new CommonToken(JavadocTokenTypes.CLASS, "Class");
        referenceContext29.addChild(class25);
        CommonToken hash27 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext29.addChild(hash27);
        CommonToken member27 = new CommonToken(JavadocTokenTypes.MEMBER, "constructor");
        referenceContext29.addChild(member27);
        ParametersContext parametersContext16 = new ParametersContext(referenceContext29, 0);
        CommonToken leftBrace16 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext16.addChild(leftBrace16);
        CommonToken argument38 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext16.addChild(argument38);
        CommonToken ws120 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext16.addChild(ws120);
        CommonToken argument39 = new CommonToken(JavadocTokenTypes.ARGUMENT, "argname");
        parametersContext16.addChild(argument39);
        CommonToken comma14 = new CommonToken(JavadocTokenTypes.COMMA, ",");
        parametersContext16.addChild(comma14);
        CommonToken ws121 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext16.addChild(ws121);
        CommonToken argument40 = new CommonToken(JavadocTokenTypes.ARGUMENT, "Type");
        parametersContext16.addChild(argument40);
        CommonToken ws122 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext16.addChild(ws122);
        CommonToken argument41 = new CommonToken(JavadocTokenTypes.ARGUMENT, "argname");
        parametersContext16.addChild(argument41);
        CommonToken rightBrace16 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext16.addChild(rightBrace16);
        referenceContext29.addChild(parametersContext16);
        javadocTagContext42.addChild(referenceContext29);
        CommonToken newline48 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext42.addChild(newline48);
        javadocContext0.addChild(javadocTagContext42);
        JavadocTagContext javadocTagContext43 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral33 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext43.addChild(seeLiteral33);
        CommonToken ws123 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext43.addChild(ws123);
        ReferenceContext referenceContext30 = new ReferenceContext(javadocTagContext43, 0);
        CommonToken package18 = new CommonToken(JavadocTokenTypes.PACKAGE, "com.github.checkstyle");
        referenceContext30.addChild(package18);
        CommonToken dot19 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext30.addChild(dot19);
        CommonToken class26 = new CommonToken(JavadocTokenTypes.CLASS, "Class");
        referenceContext30.addChild(class26);
        CommonToken dot20 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext30.addChild(dot20);
        CommonToken class27 = new CommonToken(JavadocTokenTypes.CLASS, "NestedClass");
        referenceContext30.addChild(class27);
        javadocTagContext43.addChild(referenceContext30);
        CommonToken newline49 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext43.addChild(newline49);
        javadocContext0.addChild(javadocTagContext43);
        JavadocTagContext javadocTagContext44 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral34 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext44.addChild(seeLiteral34);
        CommonToken ws124 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext44.addChild(ws124);
        ReferenceContext referenceContext31 = new ReferenceContext(javadocTagContext44, 0);
        CommonToken package19 = new CommonToken(JavadocTokenTypes.PACKAGE, "com.github.checkstyle");
        referenceContext31.addChild(package19);
        CommonToken dot21 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext31.addChild(dot21);
        CommonToken class28 = new CommonToken(JavadocTokenTypes.CLASS, "Class");
        referenceContext31.addChild(class28);
        javadocTagContext44.addChild(referenceContext31);
        CommonToken newline50 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext44.addChild(newline50);
        javadocContext0.addChild(javadocTagContext44);
        JavadocTagContext javadocTagContext45 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral35 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext45.addChild(seeLiteral35);
        CommonToken ws125 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext45.addChild(ws125);
        ReferenceContext referenceContext32 = new ReferenceContext(javadocTagContext45, 0);
        CommonToken package20 = new CommonToken(JavadocTokenTypes.PACKAGE, "com.github.checkstyle");
        referenceContext32.addChild(package20);
        javadocTagContext45.addChild(referenceContext32);
        CommonToken newline51 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext45.addChild(newline51);
        javadocContext0.addChild(javadocTagContext45);
        JavadocTagContext javadocTagContext46 = new JavadocTagContext(javadocContext0, 0);
        CommonToken serialLiteral0 = new CommonToken(JavadocTokenTypes.SERIAL_LITERAL, "@serial");
        javadocTagContext46.addChild(serialLiteral0);
        CommonToken ws126 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext46.addChild(ws126);
        DescriptionContext descriptionContext20 = new DescriptionContext(javadocTagContext46, 0);
        TextContext textContext26 = new TextContext(descriptionContext20, 0);
        CommonToken char340 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext26.addChild(char340);
        CommonToken char341 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext26.addChild(char341);
        CommonToken char342 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext26.addChild(char342);
        CommonToken char343 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext26.addChild(char343);
        CommonToken char344 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext26.addChild(char344);
        CommonToken ws127 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext26.addChild(ws127);
        CommonToken char345 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext26.addChild(char345);
        CommonToken char346 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext26.addChild(char346);
        CommonToken char347 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext26.addChild(char347);
        CommonToken char348 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext26.addChild(char348);
        CommonToken char349 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext26.addChild(char349);
        CommonToken char350 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext26.addChild(char350);
        CommonToken char351 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext26.addChild(char351);
        CommonToken char352 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext26.addChild(char352);
        CommonToken char353 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext26.addChild(char353);
        CommonToken char354 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext26.addChild(char354);
        CommonToken char355 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext26.addChild(char355);
        descriptionContext20.addChild(textContext26);
        CommonToken newline52 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext20.addChild(newline52);
        TextContext textContext27 = new TextContext(descriptionContext20, 0);
        CommonToken char356 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext27.addChild(char356);
        CommonToken char357 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext27.addChild(char357);
        CommonToken ws128 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext27.addChild(ws128);
        CommonToken char358 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext27.addChild(char358);
        CommonToken char359 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext27.addChild(char359);
        CommonToken char360 = new CommonToken(JavadocTokenTypes.CHAR, "w");
        textContext27.addChild(char360);
        CommonToken ws129 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext27.addChild(ws129);
        CommonToken char361 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext27.addChild(char361);
        CommonToken char362 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext27.addChild(char362);
        CommonToken char363 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext27.addChild(char363);
        CommonToken char364 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext27.addChild(char364);
        CommonToken char365 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext27.addChild(char365);
        descriptionContext20.addChild(textContext27);
        CommonToken newline53 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext20.addChild(newline53);
        TextContext textContext28 = new TextContext(descriptionContext20, 0);
        CommonToken char366 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext28.addChild(char366);
        CommonToken char367 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext28.addChild(char367);
        CommonToken char368 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext28.addChild(char368);
        CommonToken ws130 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext28.addChild(ws130);
        CommonToken char369 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext28.addChild(char369);
        CommonToken char370 = new CommonToken(JavadocTokenTypes.CHAR, "v");
        textContext28.addChild(char370);
        CommonToken char371 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext28.addChild(char371);
        CommonToken char372 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext28.addChild(char372);
        CommonToken ws131 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext28.addChild(ws131);
        CommonToken char373 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext28.addChild(char373);
        CommonToken char374 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext28.addChild(char374);
        CommonToken char375 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext28.addChild(char375);
        CommonToken char376 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext28.addChild(char376);
        descriptionContext20.addChild(textContext28);
        CommonToken newline54 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext20.addChild(newline54);
        javadocTagContext46.addChild(descriptionContext20);
        javadocContext0.addChild(javadocTagContext46);
        JavadocTagContext javadocTagContext47 = new JavadocTagContext(javadocContext0, 0);
        CommonToken serialLiteral1 = new CommonToken(JavadocTokenTypes.SERIAL_LITERAL, "@serial");
        javadocTagContext47.addChild(serialLiteral1);
        CommonToken ws132 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext47.addChild(ws132);
        CommonToken literalInclude0 = new CommonToken(JavadocTokenTypes.LITERAL_INCLUDE, "include");
        javadocTagContext47.addChild(literalInclude0);
        DescriptionContext descriptionContext21 = new DescriptionContext(javadocTagContext47, 0);
        CommonToken newline55 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext21.addChild(newline55);
        javadocTagContext47.addChild(descriptionContext21);
        javadocContext0.addChild(javadocTagContext47);
        JavadocTagContext javadocTagContext48 = new JavadocTagContext(javadocContext0, 0);
        CommonToken serialLiteral2 = new CommonToken(JavadocTokenTypes.SERIAL_LITERAL, "@serial");
        javadocTagContext48.addChild(serialLiteral2);
        CommonToken ws133 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext48.addChild(ws133);
        CommonToken literalExclude0 = new CommonToken(JavadocTokenTypes.LITERAL_EXCLUDE, "exclude");
        javadocTagContext48.addChild(literalExclude0);
        DescriptionContext descriptionContext22 = new DescriptionContext(javadocTagContext48, 0);
        CommonToken newline56 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext22.addChild(newline56);
        javadocTagContext48.addChild(descriptionContext22);
        javadocContext0.addChild(javadocTagContext48);
        JavadocTagContext javadocTagContext49 = new JavadocTagContext(javadocContext0, 0);
        CommonToken serialFieldLiteral0 = new CommonToken(JavadocTokenTypes.SERIAL_FIELD_LITERAL, "@serialField");
        javadocTagContext49.addChild(serialFieldLiteral0);
        CommonToken ws134 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext49.addChild(ws134);
        CommonToken fieldName0 = new CommonToken(JavadocTokenTypes.FIELD_NAME, "myField");
        javadocTagContext49.addChild(fieldName0);
        CommonToken ws135 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext49.addChild(ws135);
        CommonToken fieldType0 = new CommonToken(JavadocTokenTypes.FIELD_TYPE, "myObjectStreamField");
        javadocTagContext49.addChild(fieldType0);
        CommonToken ws136 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext49.addChild(ws136);
        DescriptionContext descriptionContext23 = new DescriptionContext(javadocTagContext49, 0);
        TextContext textContext29 = new TextContext(descriptionContext23, 0);
        CommonToken char377 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext29.addChild(char377);
        CommonToken char378 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext29.addChild(char378);
        CommonToken char379 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext29.addChild(char379);
        CommonToken char380 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext29.addChild(char380);
        CommonToken char381 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext29.addChild(char381);
        CommonToken char382 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext29.addChild(char382);
        CommonToken char383 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext29.addChild(char383);
        CommonToken char384 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext29.addChild(char384);
        CommonToken char385 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext29.addChild(char385);
        CommonToken char386 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext29.addChild(char386);
        CommonToken char387 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext29.addChild(char387);
        CommonToken ws137 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext29.addChild(ws137);
        CommonToken char388 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext29.addChild(char388);
        CommonToken char389 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext29.addChild(char389);
        CommonToken ws138 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext29.addChild(ws138);
        CommonToken char390 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext29.addChild(char390);
        CommonToken char391 = new CommonToken(JavadocTokenTypes.CHAR, "y");
        textContext29.addChild(char391);
        CommonToken ws139 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext29.addChild(ws139);
        CommonToken char392 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext29.addChild(char392);
        CommonToken char393 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext29.addChild(char393);
        CommonToken char394 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext29.addChild(char394);
        CommonToken char395 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext29.addChild(char395);
        CommonToken char396 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext29.addChild(char396);
        CommonToken char397 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext29.addChild(char397);
        CommonToken ws140 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext29.addChild(ws140);
        CommonToken char398 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext29.addChild(char398);
        CommonToken char399 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext29.addChild(char399);
        CommonToken char400 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext29.addChild(char400);
        CommonToken char401 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext29.addChild(char401);
        CommonToken char402 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext29.addChild(char402);
        descriptionContext23.addChild(textContext29);
        CommonToken newline57 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext23.addChild(newline57);
        javadocTagContext49.addChild(descriptionContext23);
        javadocContext0.addChild(javadocTagContext49);
        JavadocTagContext javadocTagContext50 = new JavadocTagContext(javadocContext0, 0);
        CommonToken serialDataLiteral0 = new CommonToken(JavadocTokenTypes.SERIAL_DATA_LITERAL, "@serialData");
        javadocTagContext50.addChild(serialDataLiteral0);
        CommonToken ws141 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext50.addChild(ws141);
        DescriptionContext descriptionContext24 = new DescriptionContext(javadocTagContext50, 0);
        TextContext textContext30 = new TextContext(descriptionContext24, 0);
        CommonToken char403 = new CommonToken(JavadocTokenTypes.CHAR, "T");
        textContext30.addChild(char403);
        CommonToken char404 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext30.addChild(char404);
        CommonToken char405 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char405);
        CommonToken ws142 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws142);
        CommonToken char406 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext30.addChild(char406);
        CommonToken char407 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char407);
        CommonToken char408 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char408);
        CommonToken char409 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char409);
        CommonToken char410 = new CommonToken(JavadocTokenTypes.CHAR, "-");
        textContext30.addChild(char410);
        CommonToken char411 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext30.addChild(char411);
        CommonToken char412 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char412);
        CommonToken char413 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext30.addChild(char413);
        CommonToken char414 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext30.addChild(char414);
        CommonToken char415 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext30.addChild(char415);
        CommonToken char416 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext30.addChild(char416);
        CommonToken char417 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext30.addChild(char417);
        CommonToken char418 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char418);
        CommonToken char419 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext30.addChild(char419);
        CommonToken char420 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext30.addChild(char420);
        CommonToken char421 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext30.addChild(char421);
        CommonToken ws143 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws143);
        CommonToken char422 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext30.addChild(char422);
        CommonToken char423 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext30.addChild(char423);
        CommonToken char424 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext30.addChild(char424);
        CommonToken char425 = new CommonToken(JavadocTokenTypes.CHAR, "u");
        textContext30.addChild(char425);
        CommonToken char426 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext30.addChild(char426);
        CommonToken char427 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char427);
        CommonToken char428 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext30.addChild(char428);
        CommonToken char429 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char429);
        CommonToken char430 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext30.addChild(char430);
        CommonToken ws144 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws144);
        CommonToken char431 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char431);
        CommonToken char432 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext30.addChild(char432);
        CommonToken char433 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char433);
        CommonToken ws145 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws145);
        CommonToken char434 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char434);
        CommonToken char435 = new CommonToken(JavadocTokenTypes.CHAR, "y");
        textContext30.addChild(char435);
        CommonToken char436 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext30.addChild(char436);
        CommonToken char437 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char437);
        CommonToken char438 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext30.addChild(char438);
        CommonToken ws146 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws146);
        CommonToken char439 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char439);
        CommonToken char440 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext30.addChild(char440);
        CommonToken char441 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext30.addChild(char441);
        CommonToken ws147 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws147);
        CommonToken char442 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext30.addChild(char442);
        CommonToken char443 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext30.addChild(char443);
        CommonToken char444 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext30.addChild(char444);
        CommonToken char445 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char445);
        CommonToken char446 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext30.addChild(char446);
        CommonToken ws148 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws148);
        CommonToken char447 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext30.addChild(char447);
        CommonToken char448 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext30.addChild(char448);
        CommonToken ws149 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws149);
        CommonToken char449 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext30.addChild(char449);
        CommonToken char450 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char450);
        CommonToken char451 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char451);
        CommonToken char452 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char452);
        CommonToken ws150 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws150);
        CommonToken char453 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext30.addChild(char453);
        CommonToken char454 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext30.addChild(char454);
        CommonToken ws151 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws151);
        CommonToken char455 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char455);
        CommonToken char456 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext30.addChild(char456);
        CommonToken char457 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char457);
        CommonToken ws152 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws152);
        CommonToken char458 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext30.addChild(char458);
        CommonToken char459 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char459);
        CommonToken char460 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext30.addChild(char460);
        CommonToken char461 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext30.addChild(char461);
        CommonToken char462 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char462);
        CommonToken char463 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext30.addChild(char463);
        CommonToken char464 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext30.addChild(char464);
        CommonToken char465 = new CommonToken(JavadocTokenTypes.CHAR, "z");
        textContext30.addChild(char465);
        CommonToken char466 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char466);
        CommonToken char467 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext30.addChild(char467);
        CommonToken ws153 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws153);
        CommonToken char468 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext30.addChild(char468);
        CommonToken char469 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext30.addChild(char469);
        CommonToken char470 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext30.addChild(char470);
        CommonToken char471 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext30.addChild(char471);
        CommonToken char472 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext30.addChild(char472);
        CommonToken ws154 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws154);
        CommonToken char473 = new CommonToken(JavadocTokenTypes.CHAR, "S");
        textContext30.addChild(char473);
        CommonToken char474 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext30.addChild(char474);
        CommonToken char475 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char475);
        CommonToken char476 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext30.addChild(char476);
        CommonToken char477 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext30.addChild(char477);
        CommonToken char478 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext30.addChild(char478);
        CommonToken char479 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext30.addChild(char479);
        CommonToken char480 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext30.addChild(char480);
        CommonToken char481 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char481);
        CommonToken char482 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext30.addChild(char482);
        CommonToken char483 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext30.addChild(char483);
        CommonToken char484 = new CommonToken(JavadocTokenTypes.CHAR, "y");
        textContext30.addChild(char484);
        CommonToken char485 = new CommonToken(JavadocTokenTypes.CHAR, ",");
        textContext30.addChild(char485);
        CommonToken ws155 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws155);
        CommonToken char486 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char486);
        CommonToken char487 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext30.addChild(char487);
        CommonToken char488 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext30.addChild(char488);
        CommonToken char489 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext30.addChild(char489);
        CommonToken ws156 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws156);
        CommonToken char490 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext30.addChild(char490);
        CommonToken char491 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char491);
        CommonToken char492 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char492);
        CommonToken char493 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char493);
        CommonToken ws157 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws157);
        CommonToken char494 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext30.addChild(char494);
        CommonToken char495 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext30.addChild(char495);
        CommonToken char496 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext30.addChild(char496);
        CommonToken char497 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext30.addChild(char497);
        CommonToken char498 = new CommonToken(JavadocTokenTypes.CHAR, "u");
        textContext30.addChild(char498);
        CommonToken char499 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext30.addChild(char499);
        CommonToken char500 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char500);
        CommonToken char501 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext30.addChild(char501);
        CommonToken ws158 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws158);
        CommonToken char502 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char502);
        CommonToken char503 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext30.addChild(char503);
        CommonToken char504 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char504);
        CommonToken ws159 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws159);
        CommonToken char505 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext30.addChild(char505);
        CommonToken char506 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext30.addChild(char506);
        CommonToken char507 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char507);
        CommonToken char508 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext30.addChild(char508);
        CommonToken char509 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext30.addChild(char509);
        CommonToken char510 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext30.addChild(char510);
        CommonToken char511 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char511);
        CommonToken char512 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext30.addChild(char512);
        CommonToken ws160 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws160);
        CommonToken char513 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext30.addChild(char513);
        CommonToken char514 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char514);
        CommonToken char515 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char515);
        CommonToken char516 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char516);
        CommonToken ws161 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws161);
        CommonToken char517 = new CommonToken(JavadocTokenTypes.CHAR, "w");
        textContext30.addChild(char517);
        CommonToken char518 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext30.addChild(char518);
        CommonToken char519 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext30.addChild(char519);
        CommonToken char520 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char520);
        CommonToken char521 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char521);
        CommonToken char522 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char522);
        CommonToken char523 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext30.addChild(char523);
        CommonToken ws162 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws162);
        CommonToken char524 = new CommonToken(JavadocTokenTypes.CHAR, "b");
        textContext30.addChild(char524);
        CommonToken char525 = new CommonToken(JavadocTokenTypes.CHAR, "y");
        textContext30.addChild(char525);
        CommonToken ws163 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws163);
        CommonToken char526 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char526);
        CommonToken char527 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext30.addChild(char527);
        CommonToken char528 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char528);
        CommonToken ws164 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws164);
        CommonToken char529 = new CommonToken(JavadocTokenTypes.CHAR, "w");
        textContext30.addChild(char529);
        CommonToken char530 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext30.addChild(char530);
        CommonToken char531 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext30.addChild(char531);
        CommonToken char532 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char532);
        CommonToken char533 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char533);
        CommonToken char534 = new CommonToken(JavadocTokenTypes.CHAR, "O");
        textContext30.addChild(char534);
        CommonToken char535 = new CommonToken(JavadocTokenTypes.CHAR, "b");
        textContext30.addChild(char535);
        CommonToken char536 = new CommonToken(JavadocTokenTypes.CHAR, "j");
        textContext30.addChild(char536);
        CommonToken char537 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char537);
        CommonToken char538 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext30.addChild(char538);
        CommonToken char539 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char539);
        CommonToken ws165 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws165);
        CommonToken char540 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext30.addChild(char540);
        CommonToken char541 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char541);
        CommonToken char542 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char542);
        CommonToken char543 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext30.addChild(char543);
        CommonToken char544 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext30.addChild(char544);
        CommonToken char545 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext30.addChild(char545);
        CommonToken ws166 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws166);
        CommonToken char546 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char546);
        CommonToken char547 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext30.addChild(char547);
        CommonToken char548 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext30.addChild(char548);
        CommonToken ws167 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws167);
        CommonToken char549 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char549);
        CommonToken char550 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext30.addChild(char550);
        CommonToken char551 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext30.addChild(char551);
        CommonToken ws168 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws168);
        CommonToken char552 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext30.addChild(char552);
        CommonToken char553 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char553);
        CommonToken char554 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char554);
        CommonToken char555 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char555);
        CommonToken ws169 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws169);
        CommonToken char556 = new CommonToken(JavadocTokenTypes.CHAR, "(");
        textContext30.addChild(char556);
        CommonToken char557 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext30.addChild(char557);
        CommonToken char558 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext30.addChild(char558);
        CommonToken char559 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext30.addChild(char559);
        CommonToken char560 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext30.addChild(char560);
        CommonToken char561 = new CommonToken(JavadocTokenTypes.CHAR, "u");
        textContext30.addChild(char561);
        CommonToken char562 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext30.addChild(char562);
        CommonToken char563 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext30.addChild(char563);
        CommonToken char564 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext30.addChild(char564);
        CommonToken char565 = new CommonToken(JavadocTokenTypes.CHAR, "g");
        textContext30.addChild(char565);
        CommonToken ws170 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws170);
        CommonToken char566 = new CommonToken(JavadocTokenTypes.CHAR, "b");
        textContext30.addChild(char566);
        CommonToken char567 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char567);
        CommonToken char568 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext30.addChild(char568);
        CommonToken char569 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char569);
        CommonToken ws171 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws171);
        CommonToken char570 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext30.addChild(char570);
        CommonToken char571 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext30.addChild(char571);
        CommonToken char572 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char572);
        CommonToken char573 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext30.addChild(char573);
        CommonToken char574 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext30.addChild(char574);
        CommonToken char575 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char575);
        CommonToken char576 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext30.addChild(char576);
        CommonToken char577 = new CommonToken(JavadocTokenTypes.CHAR, ")");
        textContext30.addChild(char577);
        CommonToken ws172 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws172);
        CommonToken char578 = new CommonToken(JavadocTokenTypes.CHAR, "w");
        textContext30.addChild(char578);
        CommonToken char579 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext30.addChild(char579);
        CommonToken char580 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext30.addChild(char580);
        CommonToken char581 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char581);
        CommonToken char582 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char582);
        CommonToken char583 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char583);
        CommonToken char584 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext30.addChild(char584);
        CommonToken ws173 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws173);
        CommonToken char585 = new CommonToken(JavadocTokenTypes.CHAR, "b");
        textContext30.addChild(char585);
        CommonToken char586 = new CommonToken(JavadocTokenTypes.CHAR, "y");
        textContext30.addChild(char586);
        CommonToken ws174 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws174);
        CommonToken char587 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char587);
        CommonToken char588 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext30.addChild(char588);
        CommonToken char589 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char589);
        CommonToken ws175 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws175);
        CommonToken char590 = new CommonToken(JavadocTokenTypes.CHAR, "E");
        textContext30.addChild(char590);
        CommonToken char591 = new CommonToken(JavadocTokenTypes.CHAR, "x");
        textContext30.addChild(char591);
        CommonToken char592 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char592);
        CommonToken char593 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char593);
        CommonToken char594 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext30.addChild(char594);
        CommonToken char595 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext30.addChild(char595);
        CommonToken char596 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char596);
        CommonToken char597 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext30.addChild(char597);
        CommonToken char598 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext30.addChild(char598);
        CommonToken char599 = new CommonToken(JavadocTokenTypes.CHAR, "z");
        textContext30.addChild(char599);
        CommonToken char600 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char600);
        CommonToken char601 = new CommonToken(JavadocTokenTypes.CHAR, "b");
        textContext30.addChild(char601);
        CommonToken char602 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext30.addChild(char602);
        CommonToken char603 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char603);
        CommonToken char604 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext30.addChild(char604);
        CommonToken char605 = new CommonToken(JavadocTokenTypes.CHAR, "w");
        textContext30.addChild(char605);
        CommonToken char606 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext30.addChild(char606);
        CommonToken char607 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext30.addChild(char607);
        CommonToken char608 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char608);
        CommonToken char609 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char609);
        CommonToken char610 = new CommonToken(JavadocTokenTypes.CHAR, "E");
        textContext30.addChild(char610);
        CommonToken char611 = new CommonToken(JavadocTokenTypes.CHAR, "x");
        textContext30.addChild(char611);
        CommonToken char612 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char612);
        CommonToken char613 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char613);
        CommonToken char614 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext30.addChild(char614);
        CommonToken char615 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext30.addChild(char615);
        CommonToken char616 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext30.addChild(char616);
        CommonToken char617 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext30.addChild(char617);
        CommonToken ws176 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext30.addChild(ws176);
        CommonToken char618 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext30.addChild(char618);
        CommonToken char619 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext30.addChild(char619);
        CommonToken char620 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext30.addChild(char620);
        CommonToken char621 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext30.addChild(char621);
        CommonToken char622 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext30.addChild(char622);
        CommonToken char623 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext30.addChild(char623);
        CommonToken char624 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext30.addChild(char624);
        descriptionContext24.addChild(textContext30);
        CommonToken newline58 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext24.addChild(newline58);
        javadocTagContext50.addChild(descriptionContext24);
        javadocContext0.addChild(javadocTagContext50);
        JavadocTagContext javadocTagContext51 = new JavadocTagContext(javadocContext0, 0);
        CommonToken sinceLiteral0 = new CommonToken(JavadocTokenTypes.SINCE_LITERAL, "@since");
        javadocTagContext51.addChild(sinceLiteral0);
        CommonToken ws177 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext51.addChild(ws177);
        DescriptionContext descriptionContext25 = new DescriptionContext(javadocTagContext51, 0);
        TextContext textContext31 = new TextContext(descriptionContext25, 0);
        CommonToken char625 = new CommonToken(JavadocTokenTypes.CHAR, "1");
        textContext31.addChild(char625);
        CommonToken char626 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext31.addChild(char626);
        CommonToken char627 = new CommonToken(JavadocTokenTypes.CHAR, "5");
        textContext31.addChild(char627);
        descriptionContext25.addChild(textContext31);
        CommonToken newline59 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext25.addChild(newline59);
        javadocTagContext51.addChild(descriptionContext25);
        javadocContext0.addChild(javadocTagContext51);
        JavadocTagContext javadocTagContext52 = new JavadocTagContext(javadocContext0, 0);
        CommonToken sinceLiteral1 = new CommonToken(JavadocTokenTypes.SINCE_LITERAL, "@since");
        javadocTagContext52.addChild(sinceLiteral1);
        CommonToken ws178 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext52.addChild(ws178);
        DescriptionContext descriptionContext26 = new DescriptionContext(javadocTagContext52, 0);
        TextContext textContext32 = new TextContext(descriptionContext26, 0);
        CommonToken char628 = new CommonToken(JavadocTokenTypes.CHAR, "R");
        textContext32.addChild(char628);
        CommonToken char629 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext32.addChild(char629);
        CommonToken char630 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext32.addChild(char630);
        CommonToken char631 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext32.addChild(char631);
        CommonToken char632 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext32.addChild(char632);
        CommonToken char633 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext32.addChild(char633);
        CommonToken char634 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext32.addChild(char634);
        CommonToken ws179 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext32.addChild(ws179);
        CommonToken char635 = new CommonToken(JavadocTokenTypes.CHAR, "3");
        textContext32.addChild(char635);
        CommonToken char636 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext32.addChild(char636);
        CommonToken char637 = new CommonToken(JavadocTokenTypes.CHAR, "4");
        textContext32.addChild(char637);
        CommonToken char638 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext32.addChild(char638);
        CommonToken char639 = new CommonToken(JavadocTokenTypes.CHAR, "5");
        textContext32.addChild(char639);
        descriptionContext26.addChild(textContext32);
        CommonToken newline60 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext26.addChild(newline60);
        javadocTagContext52.addChild(descriptionContext26);
        javadocContext0.addChild(javadocTagContext52);
        JavadocTagContext javadocTagContext53 = new JavadocTagContext(javadocContext0, 0);
        CommonToken throwsLiteral0 = new CommonToken(JavadocTokenTypes.THROWS_LITERAL, "@throws");
        javadocTagContext53.addChild(throwsLiteral0);
        CommonToken ws180 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext53.addChild(ws180);
        CommonToken className1 = new CommonToken(JavadocTokenTypes.CLASS_NAME, "IOException");
        javadocTagContext53.addChild(className1);
        CommonToken ws181 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext53.addChild(ws181);
        DescriptionContext descriptionContext27 = new DescriptionContext(javadocTagContext53, 0);
        TextContext textContext33 = new TextContext(descriptionContext27, 0);
        CommonToken char640 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext33.addChild(char640);
        CommonToken char641 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext33.addChild(char641);
        CommonToken char642 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext33.addChild(char642);
        CommonToken char643 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext33.addChild(char643);
        CommonToken char644 = new CommonToken(JavadocTokenTypes.CHAR, "w");
        textContext33.addChild(char644);
        CommonToken char645 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext33.addChild(char645);
        CommonToken ws182 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext33.addChild(ws182);
        CommonToken char646 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext33.addChild(char646);
        CommonToken char647 = new CommonToken(JavadocTokenTypes.CHAR, "x");
        textContext33.addChild(char647);
        CommonToken char648 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext33.addChild(char648);
        CommonToken char649 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext33.addChild(char649);
        CommonToken char650 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext33.addChild(char650);
        CommonToken char651 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext33.addChild(char651);
        CommonToken char652 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext33.addChild(char652);
        CommonToken char653 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext33.addChild(char653);
        CommonToken char654 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext33.addChild(char654);
        CommonToken ws183 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext33.addChild(ws183);
        CommonToken char655 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext33.addChild(char655);
        CommonToken char656 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext33.addChild(char656);
        CommonToken ws184 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext33.addChild(ws184);
        CommonToken char657 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext33.addChild(char657);
        CommonToken char658 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext33.addChild(char658);
        CommonToken char659 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext33.addChild(char659);
        CommonToken char660 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext33.addChild(char660);
        CommonToken char661 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext33.addChild(char661);
        CommonToken char662 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext33.addChild(char662);
        CommonToken char663 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext33.addChild(char663);
        CommonToken char664 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext33.addChild(char664);
        CommonToken char665 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext33.addChild(char665);
        CommonToken char666 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext33.addChild(char666);
        CommonToken ws185 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext33.addChild(ws185);
        CommonToken char667 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext33.addChild(char667);
        CommonToken char668 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext33.addChild(char668);
        CommonToken char669 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext33.addChild(char669);
        CommonToken char670 = new CommonToken(JavadocTokenTypes.CHAR, "u");
        textContext33.addChild(char670);
        CommonToken char671 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext33.addChild(char671);
        CommonToken char672 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext33.addChild(char672);
        CommonToken char673 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext33.addChild(char673);
        CommonToken char674 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext33.addChild(char674);
        descriptionContext27.addChild(textContext33);
        CommonToken newline61 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext27.addChild(newline61);
        javadocTagContext53.addChild(descriptionContext27);
        javadocContext0.addChild(javadocTagContext53);
        JavadocTagContext javadocTagContext54 = new JavadocTagContext(javadocContext0, 0);
        CommonToken versionLiteral0 = new CommonToken(JavadocTokenTypes.VERSION_LITERAL, "@version");
        javadocTagContext54.addChild(versionLiteral0);
        CommonToken ws186 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext54.addChild(ws186);
        DescriptionContext descriptionContext28 = new DescriptionContext(javadocTagContext54, 0);
        TextContext textContext34 = new TextContext(descriptionContext28, 0);
        CommonToken char675 = new CommonToken(JavadocTokenTypes.CHAR, "1");
        textContext34.addChild(char675);
        CommonToken char676 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext34.addChild(char676);
        CommonToken char677 = new CommonToken(JavadocTokenTypes.CHAR, "2");
        textContext34.addChild(char677);
        descriptionContext28.addChild(textContext34);
        CommonToken newline62 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext28.addChild(newline62);
        javadocTagContext54.addChild(descriptionContext28);
        javadocContext0.addChild(javadocTagContext54);
        JavadocTagContext javadocTagContext55 = new JavadocTagContext(javadocContext0, 0);
        CommonToken versionLiteral1 = new CommonToken(JavadocTokenTypes.VERSION_LITERAL, "@version");
        javadocTagContext55.addChild(versionLiteral1);
        CommonToken ws187 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext55.addChild(ws187);
        DescriptionContext descriptionContext29 = new DescriptionContext(javadocTagContext55, 0);
        TextContext textContext35 = new TextContext(descriptionContext29, 0);
        CommonToken char678 = new CommonToken(JavadocTokenTypes.CHAR, "R");
        textContext35.addChild(char678);
        CommonToken char679 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext35.addChild(char679);
        CommonToken char680 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext35.addChild(char680);
        CommonToken char681 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext35.addChild(char681);
        CommonToken char682 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext35.addChild(char682);
        CommonToken char683 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext35.addChild(char683);
        CommonToken char684 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext35.addChild(char684);
        CommonToken ws188 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext35.addChild(ws188);
        CommonToken char685 = new CommonToken(JavadocTokenTypes.CHAR, "1");
        textContext35.addChild(char685);
        CommonToken char686 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext35.addChild(char686);
        CommonToken char687 = new CommonToken(JavadocTokenTypes.CHAR, "1");
        textContext35.addChild(char687);
        CommonToken char688 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext35.addChild(char688);
        CommonToken char689 = new CommonToken(JavadocTokenTypes.CHAR, "1");
        textContext35.addChild(char689);
        descriptionContext29.addChild(textContext35);
        javadocTagContext55.addChild(descriptionContext29);
        javadocContext0.addChild(javadocTagContext55);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeAsteriskInJavadocInlineTag()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        JavadocInlineTagContext javadocInlineTagContext0 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext0.addChild(javadocInlineTagStart0);
        CommonToken linkLiteral0 = new CommonToken(JavadocTokenTypes.LINK_LITERAL, "@link");
        javadocInlineTagContext0.addChild(linkLiteral0);
        CommonToken newline0 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocInlineTagContext0.addChild(newline0);
        CommonToken leadingAsterisk0 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, "  *");
        javadocInlineTagContext0.addChild(leadingAsterisk0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext0.addChild(ws0);
        ReferenceContext referenceContext0 = new ReferenceContext(javadocInlineTagContext0, 0);
        CommonToken class0 = new CommonToken(JavadocTokenTypes.CLASS, "GwtIncompatible");
        referenceContext0.addChild(class0);
        javadocInlineTagContext0.addChild(referenceContext0);
        CommonToken javadocInlineTagEnd0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext0.addChild(javadocInlineTagEnd0);
        javadocContext0.addChild(javadocInlineTagContext0);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeAsteriskInLiteral()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        JavadocInlineTagContext javadocInlineTagContext0 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext0.addChild(javadocInlineTagStart0);
        CommonToken literalLiteral0 = new CommonToken(JavadocTokenTypes.LITERAL_LITERAL, "@literal");
        javadocInlineTagContext0.addChild(literalLiteral0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext0.addChild(ws0);
        TextContext textContext0 = new TextContext(javadocInlineTagContext0, 0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext0.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, LINE_SEPARATOR);
        textContext0.addChild(char2);
        javadocInlineTagContext0.addChild(textContext0);
        CommonToken leadingAsterisk0 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, "*");
        javadocInlineTagContext0.addChild(leadingAsterisk0);
        TextContext textContext1 = new TextContext(javadocInlineTagContext0, 0);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, " ");
        textContext1.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext1.addChild(char4);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext1.addChild(char5);
        javadocInlineTagContext0.addChild(textContext1);
        CommonToken javadocInlineTagEnd0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext0.addChild(javadocInlineTagEnd0);
        javadocContext0.addChild(javadocInlineTagContext0);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeAuthorWithMailto()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        JavadocTagContext javadocTagContext0 = new JavadocTagContext(javadocContext0, 0);
        CommonToken authorLiteral0 = new CommonToken(JavadocTokenTypes.AUTHOR_LITERAL, "@author");
        javadocTagContext0.addChild(authorLiteral0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext0.addChild(ws0);
        DescriptionContext descriptionContext0 = new DescriptionContext(javadocTagContext0, 0);
        HtmlElementContext htmlElementContext0 = new HtmlElementContext(descriptionContext0, 0);
        HtmlTagContext htmlTagContext0 = new HtmlTagContext(htmlElementContext0, 0);
        HtmlElementOpenContext htmlElementOpenContext0 = new HtmlElementOpenContext(htmlTagContext0, 0);
        CommonToken open0 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementOpenContext0.addChild(open0);
        CommonToken htmlTagName0 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "a");
        htmlElementOpenContext0.addChild(htmlTagName0);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        htmlElementOpenContext0.addChild(ws1);
        AttributeContext attributeContext0 = new AttributeContext(htmlElementOpenContext0, 0);
        CommonToken htmlTagName1 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "href");
        attributeContext0.addChild(htmlTagName1);
        CommonToken equals0 = new CommonToken(JavadocTokenTypes.EQUALS, "=");
        attributeContext0.addChild(equals0);
        CommonToken attrValue0 = new CommonToken(JavadocTokenTypes.ATTR_VALUE, "\"mailto:barataliba@gmail.com\"");
        attributeContext0.addChild(attrValue0);
        htmlElementOpenContext0.addChild(attributeContext0);
        CommonToken close0 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementOpenContext0.addChild(close0);
        htmlTagContext0.addChild(htmlElementOpenContext0);
        TextContext textContext0 = new TextContext(htmlTagContext0, 0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "B");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext0.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext0.addChild(char2);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext0.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext0.addChild(char4);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext0.addChild(char5);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext0.addChild(char6);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext0.addChild(char7);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws2);
        CommonToken char8 = new CommonToken(JavadocTokenTypes.CHAR, "I");
        textContext0.addChild(char8);
        CommonToken char9 = new CommonToken(JavadocTokenTypes.CHAR, "z");
        textContext0.addChild(char9);
        CommonToken char10 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext0.addChild(char10);
        CommonToken char11 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext0.addChild(char11);
        CommonToken char12 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext0.addChild(char12);
        CommonToken char13 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext0.addChild(char13);
        CommonToken char14 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext0.addChild(char14);
        CommonToken char15 = new CommonToken(JavadocTokenTypes.CHAR, "v");
        textContext0.addChild(char15);
        htmlTagContext0.addChild(textContext0);
        HtmlElementCloseContext htmlElementCloseContext0 = new HtmlElementCloseContext(htmlTagContext0, 0);
        CommonToken open1 = new CommonToken(JavadocTokenTypes.OPEN, "<");
        htmlElementCloseContext0.addChild(open1);
        CommonToken slash0 = new CommonToken(JavadocTokenTypes.SLASH, "/");
        htmlElementCloseContext0.addChild(slash0);
        CommonToken htmlTagName2 = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "a");
        htmlElementCloseContext0.addChild(htmlTagName2);
        CommonToken close1 = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        htmlElementCloseContext0.addChild(close1);
        htmlTagContext0.addChild(htmlElementCloseContext0);
        htmlElementContext0.addChild(htmlTagContext0);
        descriptionContext0.addChild(htmlElementContext0);
        javadocTagContext0.addChild(descriptionContext0);
        javadocContext0.addChild(javadocTagContext0);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeCustomJavadocTags()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        CommonToken leadingAsterisk0 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocContext0.addChild(leadingAsterisk0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocContext0.addChild(ws0);
        JavadocTagContext javadocTagContext0 = new JavadocTagContext(javadocContext0, 0);
        CommonToken customName0 = new CommonToken(JavadocTokenTypes.CUSTOM_NAME, "@myTag");
        javadocTagContext0.addChild(customName0);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext0.addChild(ws1);
        DescriptionContext descriptionContext0 = new DescriptionContext(javadocTagContext0, 0);
        TextContext textContext0 = new TextContext(descriptionContext0, 0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "y");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext0.addChild(char2);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws2);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext0.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext0.addChild(char4);
        CommonToken ws3 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws3);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext0.addChild(char5);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext0.addChild(char6);
        descriptionContext0.addChild(textContext0);
        CommonToken newline0 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext0.addChild(newline0);
        javadocTagContext0.addChild(descriptionContext0);
        javadocContext0.addChild(javadocTagContext0);
        CommonToken leadingAsterisk1 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocContext0.addChild(leadingAsterisk1);
        CommonToken ws4 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocContext0.addChild(ws4);
        JavadocTagContext javadocTagContext1 = new JavadocTagContext(javadocContext0, 0);
        CommonToken customName1 = new CommonToken(JavadocTokenTypes.CUSTOM_NAME, "@anotherTagWithoutParameter");
        javadocTagContext1.addChild(customName1);
        CommonToken newline1 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext1.addChild(newline1);
        javadocContext0.addChild(javadocTagContext1);
        CommonToken leadingAsterisk2 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocContext0.addChild(leadingAsterisk2);
        CommonToken ws5 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocContext0.addChild(ws5);
        JavadocTagContext javadocTagContext2 = new JavadocTagContext(javadocContext0, 0);
        CommonToken authorLiteral0 = new CommonToken(JavadocTokenTypes.AUTHOR_LITERAL, "@author");
        javadocTagContext2.addChild(authorLiteral0);
        CommonToken ws6 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext2.addChild(ws6);
        DescriptionContext descriptionContext1 = new DescriptionContext(javadocTagContext2, 0);
        TextContext textContext1 = new TextContext(descriptionContext1, 0);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, "I");
        textContext1.addChild(char7);
        descriptionContext1.addChild(textContext1);
        CommonToken newline2 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext1.addChild(newline2);
        TextContext textContext2 = new TextContext(descriptionContext1, 0);
        CommonToken ws7 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext2.addChild(ws7);
        descriptionContext1.addChild(textContext2);
        javadocTagContext2.addChild(descriptionContext1);
        javadocContext0.addChild(javadocTagContext2);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeDocRootInheritDoc()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        CommonToken newline0 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline0);
        CommonToken leadingAsterisk0 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocContext0.addChild(leadingAsterisk0);
        TextContext textContext0 = new TextContext(javadocContext0, 0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws0);
        javadocContext0.addChild(textContext0);
        JavadocInlineTagContext javadocInlineTagContext0 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext0.addChild(javadocInlineTagStart0);
        CommonToken docRootLiteral0 = new CommonToken(JavadocTokenTypes.DOC_ROOT_LITERAL, "@docRoot");
        javadocInlineTagContext0.addChild(docRootLiteral0);
        CommonToken javadocInlineTagEnd0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext0.addChild(javadocInlineTagEnd0);
        javadocContext0.addChild(javadocInlineTagContext0);
        CommonToken newline1 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline1);
        CommonToken leadingAsterisk1 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocContext0.addChild(leadingAsterisk1);
        TextContext textContext1 = new TextContext(javadocContext0, 0);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext1.addChild(ws1);
        javadocContext0.addChild(textContext1);
        JavadocInlineTagContext javadocInlineTagContext1 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart1 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext1.addChild(javadocInlineTagStart1);
        CommonToken docRootLiteral1 = new CommonToken(JavadocTokenTypes.DOC_ROOT_LITERAL, "@docRoot");
        javadocInlineTagContext1.addChild(docRootLiteral1);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext1.addChild(ws2);
        CommonToken javadocInlineTagEnd1 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext1.addChild(javadocInlineTagEnd1);
        javadocContext0.addChild(javadocInlineTagContext1);
        CommonToken newline2 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline2);
        CommonToken leadingAsterisk2 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocContext0.addChild(leadingAsterisk2);
        TextContext textContext2 = new TextContext(javadocContext0, 0);
        CommonToken ws3 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext2.addChild(ws3);
        javadocContext0.addChild(textContext2);
        JavadocInlineTagContext javadocInlineTagContext2 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart2 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext2.addChild(javadocInlineTagStart2);
        CommonToken docRootLiteral2 = new CommonToken(JavadocTokenTypes.DOC_ROOT_LITERAL, "@docRoot");
        javadocInlineTagContext2.addChild(docRootLiteral2);
        CommonToken newline3 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocInlineTagContext2.addChild(newline3);
        CommonToken leadingAsterisk3 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocInlineTagContext2.addChild(leadingAsterisk3);
        CommonToken ws4 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext2.addChild(ws4);
        CommonToken javadocInlineTagEnd2 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext2.addChild(javadocInlineTagEnd2);
        javadocContext0.addChild(javadocInlineTagContext2);
        CommonToken newline4 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline4);
        CommonToken leadingAsterisk4 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocContext0.addChild(leadingAsterisk4);
        TextContext textContext3 = new TextContext(javadocContext0, 0);
        CommonToken ws5 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext3.addChild(ws5);
        javadocContext0.addChild(textContext3);
        JavadocInlineTagContext javadocInlineTagContext3 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart3 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext3.addChild(javadocInlineTagStart3);
        CommonToken inheritDocLiteral0 = new CommonToken(JavadocTokenTypes.INHERIT_DOC_LITERAL, "@inheritDoc");
        javadocInlineTagContext3.addChild(inheritDocLiteral0);
        CommonToken javadocInlineTagEnd3 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext3.addChild(javadocInlineTagEnd3);
        javadocContext0.addChild(javadocInlineTagContext3);
        CommonToken newline5 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline5);
        CommonToken leadingAsterisk5 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocContext0.addChild(leadingAsterisk5);
        TextContext textContext4 = new TextContext(javadocContext0, 0);
        CommonToken ws6 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext4.addChild(ws6);
        javadocContext0.addChild(textContext4);
        JavadocInlineTagContext javadocInlineTagContext4 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart4 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext4.addChild(javadocInlineTagStart4);
        CommonToken inheritDocLiteral1 = new CommonToken(JavadocTokenTypes.INHERIT_DOC_LITERAL, "@inheritDoc");
        javadocInlineTagContext4.addChild(inheritDocLiteral1);
        CommonToken ws7 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext4.addChild(ws7);
        CommonToken javadocInlineTagEnd4 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext4.addChild(javadocInlineTagEnd4);
        javadocContext0.addChild(javadocInlineTagContext4);
        CommonToken newline6 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline6);
        CommonToken leadingAsterisk6 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocContext0.addChild(leadingAsterisk6);
        TextContext textContext5 = new TextContext(javadocContext0, 0);
        CommonToken ws8 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext5.addChild(ws8);
        javadocContext0.addChild(textContext5);
        JavadocInlineTagContext javadocInlineTagContext5 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart5 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext5.addChild(javadocInlineTagStart5);
        CommonToken inheritDocLiteral2 = new CommonToken(JavadocTokenTypes.INHERIT_DOC_LITERAL, "@inheritDoc");
        javadocInlineTagContext5.addChild(inheritDocLiteral2);
        CommonToken newline7 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocInlineTagContext5.addChild(newline7);
        CommonToken leadingAsterisk7 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocInlineTagContext5.addChild(leadingAsterisk7);
        CommonToken ws9 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext5.addChild(ws9);
        CommonToken javadocInlineTagEnd5 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext5.addChild(javadocInlineTagEnd5);
        javadocContext0.addChild(javadocInlineTagContext5);
        CommonToken newline8 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline8);
        TextContext textContext6 = new TextContext(javadocContext0, 0);
        CommonToken ws10 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext6.addChild(ws10);
        javadocContext0.addChild(textContext6);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeDollarInLink()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        JavadocInlineTagContext javadocInlineTagContext0 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext0.addChild(javadocInlineTagStart0);
        CommonToken linkLiteral0 = new CommonToken(JavadocTokenTypes.LINK_LITERAL, "@link");
        javadocInlineTagContext0.addChild(linkLiteral0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext0.addChild(ws0);
        ReferenceContext referenceContext0 = new ReferenceContext(javadocInlineTagContext0, 0);
        CommonToken class0 = new CommonToken(JavadocTokenTypes.CLASS, "My$Class");
        referenceContext0.addChild(class0);
        CommonToken hash0 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext0.addChild(hash0);
        CommonToken member0 = new CommonToken(JavadocTokenTypes.MEMBER, "$$simple_$Method");
        referenceContext0.addChild(member0);
        ParametersContext parametersContext0 = new ParametersContext(referenceContext0, 0);
        CommonToken leftBrace0 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext0.addChild(leftBrace0);
        CommonToken argument0 = new CommonToken(JavadocTokenTypes.ARGUMENT, "_A78");
        parametersContext0.addChild(argument0);
        CommonToken comma0 = new CommonToken(JavadocTokenTypes.COMMA, ",");
        parametersContext0.addChild(comma0);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext0.addChild(ws1);
        CommonToken argument1 = new CommonToken(JavadocTokenTypes.ARGUMENT, "$8$");
        parametersContext0.addChild(argument1);
        CommonToken rightBrace0 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext0.addChild(rightBrace0);
        referenceContext0.addChild(parametersContext0);
        javadocInlineTagContext0.addChild(referenceContext0);
        CommonToken javadocInlineTagEnd0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext0.addChild(javadocInlineTagEnd0);
        javadocContext0.addChild(javadocInlineTagContext0);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeFewWhiteSpacesAsSeparator()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        CommonToken leadingAsterisk0 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, "       *");
        javadocContext0.addChild(leadingAsterisk0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocContext0.addChild(ws0);
        JavadocTagContext javadocTagContext0 = new JavadocTagContext(javadocContext0, 0);
        CommonToken paramLiteral0 = new CommonToken(JavadocTokenTypes.PARAM_LITERAL, "@param");
        javadocTagContext0.addChild(paramLiteral0);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, "   ");
        javadocTagContext0.addChild(ws1);
        CommonToken parameterName0 = new CommonToken(JavadocTokenTypes.PARAMETER_NAME, "initialCapacity");
        javadocTagContext0.addChild(parameterName0);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, "     ");
        javadocTagContext0.addChild(ws2);
        DescriptionContext descriptionContext0 = new DescriptionContext(javadocTagContext0, 0);
        TextContext textContext0 = new TextContext(descriptionContext0, 0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext0.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char2);
        CommonToken ws3 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws3);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext0.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext0.addChild(char4);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext0.addChild(char5);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext0.addChild(char6);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext0.addChild(char7);
        CommonToken char8 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext0.addChild(char8);
        CommonToken char9 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext0.addChild(char9);
        CommonToken ws4 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws4);
        CommonToken char10 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext0.addChild(char10);
        CommonToken char11 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext0.addChild(char11);
        CommonToken char12 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext0.addChild(char12);
        CommonToken char13 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext0.addChild(char13);
        CommonToken char14 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext0.addChild(char14);
        CommonToken char15 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext0.addChild(char15);
        CommonToken char16 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext0.addChild(char16);
        CommonToken char17 = new CommonToken(JavadocTokenTypes.CHAR, "y");
        textContext0.addChild(char17);
        CommonToken ws5 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws5);
        CommonToken char18 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext0.addChild(char18);
        CommonToken char19 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext0.addChild(char19);
        CommonToken ws6 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws6);
        CommonToken char20 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext0.addChild(char20);
        CommonToken char21 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext0.addChild(char21);
        CommonToken char22 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char22);
        CommonToken ws7 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws7);
        CommonToken char23 = new CommonToken(JavadocTokenTypes.CHAR, "B");
        textContext0.addChild(char23);
        CommonToken char24 = new CommonToken(JavadocTokenTypes.CHAR, "y");
        textContext0.addChild(char24);
        CommonToken char25 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext0.addChild(char25);
        CommonToken char26 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char26);
        CommonToken char27 = new CommonToken(JavadocTokenTypes.CHAR, "B");
        textContext0.addChild(char27);
        CommonToken char28 = new CommonToken(JavadocTokenTypes.CHAR, "u");
        textContext0.addChild(char28);
        CommonToken char29 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext0.addChild(char29);
        CommonToken char30 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext0.addChild(char30);
        CommonToken char31 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char31);
        CommonToken char32 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext0.addChild(char32);
        CommonToken char33 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext0.addChild(char33);
        descriptionContext0.addChild(textContext0);
        javadocTagContext0.addChild(descriptionContext0);
        javadocContext0.addChild(javadocTagContext0);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeInnerBracesInCodeTag()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        JavadocInlineTagContext javadocInlineTagContext0 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext0.addChild(javadocInlineTagStart0);
        CommonToken codeLiteral0 = new CommonToken(JavadocTokenTypes.CODE_LITERAL, "@code");
        javadocInlineTagContext0.addChild(codeLiteral0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext0.addChild(ws0);
        TextContext textContext0 = new TextContext(javadocInlineTagContext0, 0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "{{{}}{{}}}");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, " ");
        textContext0.addChild(char1);
        javadocInlineTagContext0.addChild(textContext0);
        CommonToken javadocInlineTagEnd0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext0.addChild(javadocInlineTagEnd0);
        javadocContext0.addChild(javadocInlineTagContext0);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeJavadocTagDescriptionWithInlineTags()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        JavadocTagContext javadocTagContext0 = new JavadocTagContext(javadocContext0, 0);
        CommonToken deprecatedLiteral0 = new CommonToken(JavadocTokenTypes.DEPRECATED_LITERAL, "@deprecated");
        javadocTagContext0.addChild(deprecatedLiteral0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext0.addChild(ws0);
        DescriptionContext descriptionContext0 = new DescriptionContext(javadocTagContext0, 0);
        TextContext textContext0 = new TextContext(descriptionContext0, 0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "u");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext0.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char2);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws1);
        descriptionContext0.addChild(textContext0);
        JavadocInlineTagContext javadocInlineTagContext0 = new JavadocInlineTagContext(descriptionContext0, 0);
        CommonToken javadocInlineTagStart0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext0.addChild(javadocInlineTagStart0);
        CommonToken linkLiteral0 = new CommonToken(JavadocTokenTypes.LINK_LITERAL, "@link");
        javadocInlineTagContext0.addChild(linkLiteral0);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext0.addChild(ws2);
        ReferenceContext referenceContext0 = new ReferenceContext(javadocInlineTagContext0, 0);
        CommonToken package0 = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        referenceContext0.addChild(package0);
        CommonToken dot0 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext0.addChild(dot0);
        CommonToken class0 = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        referenceContext0.addChild(class0);
        javadocInlineTagContext0.addChild(referenceContext0);
        DescriptionContext descriptionContext1 = new DescriptionContext(javadocInlineTagContext0, 0);
        TextContext textContext1 = new TextContext(descriptionContext1, 0);
        CommonToken ws3 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext1.addChild(ws3);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "I");
        textContext1.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext1.addChild(char4);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext1.addChild(char5);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext1.addChild(char6);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, "g");
        textContext1.addChild(char7);
        CommonToken char8 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext1.addChild(char8);
        CommonToken char9 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext1.addChild(char9);
        descriptionContext1.addChild(textContext1);
        JavadocInlineTagContext javadocInlineTagContext1 = new JavadocInlineTagContext(descriptionContext1, 0);
        CommonToken javadocInlineTagStart1 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext1.addChild(javadocInlineTagStart1);
        CommonToken codeLiteral0 = new CommonToken(JavadocTokenTypes.CODE_LITERAL, "@code");
        javadocInlineTagContext1.addChild(codeLiteral0);
        CommonToken ws4 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext1.addChild(ws4);
        TextContext textContext2 = new TextContext(javadocInlineTagContext1, 0);
        CommonToken char10 = new CommonToken(JavadocTokenTypes.CHAR, "<");
        textContext2.addChild(char10);
        CommonToken char11 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext2.addChild(char11);
        CommonToken char12 = new CommonToken(JavadocTokenTypes.CHAR, ">");
        textContext2.addChild(char12);
        CommonToken char13 = new CommonToken(JavadocTokenTypes.CHAR, "W");
        textContext2.addChild(char13);
        CommonToken char14 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext2.addChild(char14);
        CommonToken char15 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext2.addChild(char15);
        CommonToken char16 = new CommonToken(JavadocTokenTypes.CHAR, "<");
        textContext2.addChild(char16);
        CommonToken char17 = new CommonToken(JavadocTokenTypes.CHAR, "/");
        textContext2.addChild(char17);
        CommonToken char18 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext2.addChild(char18);
        CommonToken char19 = new CommonToken(JavadocTokenTypes.CHAR, ">");
        textContext2.addChild(char19);
        javadocInlineTagContext1.addChild(textContext2);
        CommonToken javadocInlineTagEnd0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext1.addChild(javadocInlineTagEnd0);
        descriptionContext1.addChild(javadocInlineTagContext1);
        javadocInlineTagContext0.addChild(descriptionContext1);
        CommonToken javadocInlineTagEnd1 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext0.addChild(javadocInlineTagEnd1);
        descriptionContext0.addChild(javadocInlineTagContext0);
        TextContext textContext3 = new TextContext(descriptionContext0, 0);
        CommonToken ws5 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext3.addChild(ws5);
        CommonToken char20 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext3.addChild(char20);
        CommonToken char21 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext3.addChild(char21);
        CommonToken char22 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext3.addChild(char22);
        CommonToken char23 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext3.addChild(char23);
        CommonToken char24 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext3.addChild(char24);
        CommonToken char25 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext3.addChild(char25);
        CommonToken char26 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext3.addChild(char26);
        descriptionContext0.addChild(textContext3);
        javadocTagContext0.addChild(descriptionContext0);
        javadocContext0.addChild(javadocTagContext0);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeLinkInlineTags()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        JavadocInlineTagContext javadocInlineTagContext0 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext0.addChild(javadocInlineTagStart0);
        CommonToken linkLiteral0 = new CommonToken(JavadocTokenTypes.LINK_LITERAL, "@link");
        javadocInlineTagContext0.addChild(linkLiteral0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext0.addChild(ws0);
        ReferenceContext referenceContext0 = new ReferenceContext(javadocInlineTagContext0, 0);
        CommonToken package0 = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        referenceContext0.addChild(package0);
        CommonToken dot0 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext0.addChild(dot0);
        CommonToken class0 = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        referenceContext0.addChild(class0);
        CommonToken hash0 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext0.addChild(hash0);
        CommonToken member0 = new CommonToken(JavadocTokenTypes.MEMBER, "valueOf");
        referenceContext0.addChild(member0);
        javadocInlineTagContext0.addChild(referenceContext0);
        CommonToken javadocInlineTagEnd0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext0.addChild(javadocInlineTagEnd0);
        javadocContext0.addChild(javadocInlineTagContext0);
        CommonToken newline0 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline0);
        JavadocInlineTagContext javadocInlineTagContext1 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart1 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext1.addChild(javadocInlineTagStart1);
        CommonToken linkLiteral1 = new CommonToken(JavadocTokenTypes.LINK_LITERAL, "@link");
        javadocInlineTagContext1.addChild(linkLiteral1);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext1.addChild(ws1);
        ReferenceContext referenceContext1 = new ReferenceContext(javadocInlineTagContext1, 0);
        CommonToken package1 = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        referenceContext1.addChild(package1);
        CommonToken dot1 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext1.addChild(dot1);
        CommonToken class1 = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        referenceContext1.addChild(class1);
        CommonToken hash1 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext1.addChild(hash1);
        CommonToken member1 = new CommonToken(JavadocTokenTypes.MEMBER, "valueOf");
        referenceContext1.addChild(member1);
        javadocInlineTagContext1.addChild(referenceContext1);
        DescriptionContext descriptionContext0 = new DescriptionContext(javadocInlineTagContext1, 0);
        TextContext textContext0 = new TextContext(descriptionContext0, 0);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws2);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "v");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext0.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext0.addChild(char2);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "u");
        textContext0.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char4);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "O");
        textContext0.addChild(char5);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext0.addChild(char6);
        descriptionContext0.addChild(textContext0);
        javadocInlineTagContext1.addChild(descriptionContext0);
        CommonToken javadocInlineTagEnd1 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext1.addChild(javadocInlineTagEnd1);
        javadocContext0.addChild(javadocInlineTagContext1);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeNewlineAndAsteriskInParameters()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        CommonToken leadingAsterisk0 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, "  *");
        javadocContext0.addChild(leadingAsterisk0);
        TextContext textContext0 = new TextContext(javadocContext0, 0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws0);
        javadocContext0.addChild(textContext0);
        JavadocInlineTagContext javadocInlineTagContext0 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext0.addChild(javadocInlineTagStart0);
        CommonToken linkLiteral0 = new CommonToken(JavadocTokenTypes.LINK_LITERAL, "@link");
        javadocInlineTagContext0.addChild(linkLiteral0);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext0.addChild(ws1);
        ReferenceContext referenceContext0 = new ReferenceContext(javadocInlineTagContext0, 0);
        CommonToken class0 = new CommonToken(JavadocTokenTypes.CLASS, "ImmutableSortedMap");
        referenceContext0.addChild(class0);
        CommonToken hash0 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext0.addChild(hash0);
        CommonToken member0 = new CommonToken(JavadocTokenTypes.MEMBER, "of");
        referenceContext0.addChild(member0);
        ParametersContext parametersContext0 = new ParametersContext(referenceContext0, 0);
        CommonToken leftBrace0 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext0.addChild(leftBrace0);
        CommonToken newline0 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        parametersContext0.addChild(newline0);
        CommonToken leadingAsterisk1 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, "  *");
        parametersContext0.addChild(leadingAsterisk1);
        CommonToken newline1 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        parametersContext0.addChild(newline1);
        CommonToken leadingAsterisk2 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, "  *");
        parametersContext0.addChild(leadingAsterisk2);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext0.addChild(ws2);
        CommonToken rightBrace0 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext0.addChild(rightBrace0);
        referenceContext0.addChild(parametersContext0);
        javadocInlineTagContext0.addChild(referenceContext0);
        CommonToken javadocInlineTagEnd0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext0.addChild(javadocInlineTagEnd0);
        javadocContext0.addChild(javadocInlineTagContext0);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeParamWithGeneric()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        JavadocTagContext javadocTagContext0 = new JavadocTagContext(javadocContext0, 0);
        CommonToken paramLiteral0 = new CommonToken(JavadocTokenTypes.PARAM_LITERAL, "@param");
        javadocTagContext0.addChild(paramLiteral0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext0.addChild(ws0);
        CommonToken parameterName0 = new CommonToken(JavadocTokenTypes.PARAMETER_NAME, "<E>");
        javadocTagContext0.addChild(parameterName0);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext0.addChild(ws1);
        DescriptionContext descriptionContext0 = new DescriptionContext(javadocTagContext0, 0);
        TextContext textContext0 = new TextContext(descriptionContext0, 0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "y");
        textContext0.addChild(char1);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws2);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext0.addChild(char2);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext0.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "v");
        textContext0.addChild(char4);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext0.addChild(char5);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext0.addChild(char6);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext0.addChild(char7);
        CommonToken char8 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext0.addChild(char8);
        CommonToken char9 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char9);
        CommonToken ws3 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws3);
        CommonToken char10 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext0.addChild(char10);
        CommonToken char11 = new CommonToken(JavadocTokenTypes.CHAR, "y");
        textContext0.addChild(char11);
        CommonToken char12 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext0.addChild(char12);
        CommonToken char13 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char13);
        descriptionContext0.addChild(textContext0);
        javadocTagContext0.addChild(descriptionContext0);
        javadocContext0.addChild(javadocTagContext0);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeSeeReferenceWithFewNestedClasses()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        JavadocTagContext javadocTagContext0 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral0 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext0.addChild(seeLiteral0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext0.addChild(ws0);
        ReferenceContext referenceContext0 = new ReferenceContext(javadocTagContext0, 0);
        CommonToken package0 = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        referenceContext0.addChild(package0);
        CommonToken dot0 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext0.addChild(dot0);
        CommonToken class0 = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        referenceContext0.addChild(class0);
        CommonToken dot1 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext0.addChild(dot1);
        CommonToken class1 = new CommonToken(JavadocTokenTypes.CLASS, "Nested");
        referenceContext0.addChild(class1);
        CommonToken dot2 = new CommonToken(JavadocTokenTypes.DOT, ".");
        referenceContext0.addChild(dot2);
        CommonToken class2 = new CommonToken(JavadocTokenTypes.CLASS, "AnotherNested");
        referenceContext0.addChild(class2);
        CommonToken hash0 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext0.addChild(hash0);
        CommonToken member0 = new CommonToken(JavadocTokenTypes.MEMBER, "someMethod");
        referenceContext0.addChild(member0);
        ParametersContext parametersContext0 = new ParametersContext(referenceContext0, 0);
        CommonToken leftBrace0 = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        parametersContext0.addChild(leftBrace0);
        CommonToken argument0 = new CommonToken(JavadocTokenTypes.ARGUMENT, "String");
        parametersContext0.addChild(argument0);
        CommonToken comma0 = new CommonToken(JavadocTokenTypes.COMMA, ",");
        parametersContext0.addChild(comma0);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        parametersContext0.addChild(ws1);
        CommonToken argument1 = new CommonToken(JavadocTokenTypes.ARGUMENT, "int");
        parametersContext0.addChild(argument1);
        CommonToken rightBrace0 = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        parametersContext0.addChild(rightBrace0);
        referenceContext0.addChild(parametersContext0);
        javadocTagContext0.addChild(referenceContext0);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext0.addChild(ws2);
        DescriptionContext descriptionContext0 = new DescriptionContext(javadocTagContext0, 0);
        TextContext textContext0 = new TextContext(descriptionContext0, 0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "D");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext0.addChild(char2);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext0.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext0.addChild(char4);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext0.addChild(char5);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext0.addChild(char6);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext0.addChild(char7);
        CommonToken char8 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext0.addChild(char8);
        CommonToken char9 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext0.addChild(char9);
        CommonToken char10 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext0.addChild(char10);
        CommonToken ws3 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws3);
        CommonToken char11 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext0.addChild(char11);
        CommonToken char12 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext0.addChild(char12);
        CommonToken ws4 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws4);
        CommonToken char13 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext0.addChild(char13);
        CommonToken char14 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext0.addChild(char14);
        CommonToken char15 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char15);
        CommonToken ws5 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws5);
        CommonToken char16 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext0.addChild(char16);
        CommonToken char17 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext0.addChild(char17);
        CommonToken char18 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext0.addChild(char18);
        CommonToken char19 = new CommonToken(JavadocTokenTypes.CHAR, "k");
        textContext0.addChild(char19);
        descriptionContext0.addChild(textContext0);
        javadocTagContext0.addChild(descriptionContext0);
        javadocContext0.addChild(javadocTagContext0);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeSerial()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        JavadocTagContext javadocTagContext0 = new JavadocTagContext(javadocContext0, 0);
        CommonToken serialLiteral0 = new CommonToken(JavadocTokenTypes.SERIAL_LITERAL, "@serial");
        javadocTagContext0.addChild(serialLiteral0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext0.addChild(ws0);
        DescriptionContext descriptionContext0 = new DescriptionContext(javadocTagContext0, 0);
        TextContext textContext0 = new TextContext(descriptionContext0, 0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext0.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char2);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext0.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext0.addChild(char4);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws1);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext0.addChild(char5);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char6);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext0.addChild(char7);
        CommonToken char8 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext0.addChild(char8);
        CommonToken char9 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext0.addChild(char9);
        CommonToken char10 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext0.addChild(char10);
        CommonToken char11 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext0.addChild(char11);
        CommonToken char12 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext0.addChild(char12);
        CommonToken char13 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext0.addChild(char13);
        CommonToken char14 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext0.addChild(char14);
        CommonToken char15 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext0.addChild(char15);
        descriptionContext0.addChild(textContext0);
        CommonToken newline0 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext0.addChild(newline0);
        TextContext textContext1 = new TextContext(descriptionContext0, 0);
        CommonToken char16 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext1.addChild(char16);
        CommonToken char17 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext1.addChild(char17);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext1.addChild(ws2);
        CommonToken char18 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext1.addChild(char18);
        CommonToken char19 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext1.addChild(char19);
        CommonToken char20 = new CommonToken(JavadocTokenTypes.CHAR, "w");
        textContext1.addChild(char20);
        CommonToken ws3 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext1.addChild(ws3);
        CommonToken char21 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext1.addChild(char21);
        CommonToken char22 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext1.addChild(char22);
        CommonToken char23 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext1.addChild(char23);
        CommonToken char24 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext1.addChild(char24);
        CommonToken char25 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext1.addChild(char25);
        descriptionContext0.addChild(textContext1);
        CommonToken newline1 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext0.addChild(newline1);
        TextContext textContext2 = new TextContext(descriptionContext0, 0);
        CommonToken char26 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext2.addChild(char26);
        CommonToken char27 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext2.addChild(char27);
        CommonToken char28 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext2.addChild(char28);
        CommonToken ws4 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext2.addChild(ws4);
        CommonToken char29 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext2.addChild(char29);
        CommonToken char30 = new CommonToken(JavadocTokenTypes.CHAR, "v");
        textContext2.addChild(char30);
        CommonToken char31 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext2.addChild(char31);
        CommonToken char32 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext2.addChild(char32);
        CommonToken ws5 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext2.addChild(ws5);
        CommonToken char33 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext2.addChild(char33);
        CommonToken char34 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext2.addChild(char34);
        CommonToken char35 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext2.addChild(char35);
        CommonToken char36 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext2.addChild(char36);
        descriptionContext0.addChild(textContext2);
        CommonToken newline2 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext0.addChild(newline2);
        javadocTagContext0.addChild(descriptionContext0);
        javadocContext0.addChild(javadocTagContext0);
        JavadocTagContext javadocTagContext1 = new JavadocTagContext(javadocContext0, 0);
        CommonToken serialLiteral1 = new CommonToken(JavadocTokenTypes.SERIAL_LITERAL, "@serial");
        javadocTagContext1.addChild(serialLiteral1);
        CommonToken ws6 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext1.addChild(ws6);
        CommonToken literalInclude0 = new CommonToken(JavadocTokenTypes.LITERAL_INCLUDE, "include");
        javadocTagContext1.addChild(literalInclude0);
        DescriptionContext descriptionContext1 = new DescriptionContext(javadocTagContext1, 0);
        CommonToken newline3 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext1.addChild(newline3);
        javadocTagContext1.addChild(descriptionContext1);
        javadocContext0.addChild(javadocTagContext1);
        JavadocTagContext javadocTagContext2 = new JavadocTagContext(javadocContext0, 0);
        CommonToken serialLiteral2 = new CommonToken(JavadocTokenTypes.SERIAL_LITERAL, "@serial");
        javadocTagContext2.addChild(serialLiteral2);
        CommonToken ws7 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext2.addChild(ws7);
        CommonToken literalExclude0 = new CommonToken(JavadocTokenTypes.LITERAL_EXCLUDE, "exclude");
        javadocTagContext2.addChild(literalExclude0);
        DescriptionContext descriptionContext2 = new DescriptionContext(javadocTagContext2, 0);
        CommonToken newline4 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext2.addChild(newline4);
        javadocTagContext2.addChild(descriptionContext2);
        javadocContext0.addChild(javadocTagContext2);
        JavadocTagContext javadocTagContext3 = new JavadocTagContext(javadocContext0, 0);
        CommonToken serialFieldLiteral0 = new CommonToken(JavadocTokenTypes.SERIAL_FIELD_LITERAL, "@serialField");
        javadocTagContext3.addChild(serialFieldLiteral0);
        CommonToken ws8 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext3.addChild(ws8);
        CommonToken fieldName0 = new CommonToken(JavadocTokenTypes.FIELD_NAME, "myField");
        javadocTagContext3.addChild(fieldName0);
        CommonToken ws9 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext3.addChild(ws9);
        CommonToken fieldType0 = new CommonToken(JavadocTokenTypes.FIELD_TYPE, "myObjectStreamField");
        javadocTagContext3.addChild(fieldType0);
        CommonToken ws10 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext3.addChild(ws10);
        DescriptionContext descriptionContext3 = new DescriptionContext(javadocTagContext3, 0);
        TextContext textContext3 = new TextContext(descriptionContext3, 0);
        CommonToken char37 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext3.addChild(char37);
        CommonToken char38 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext3.addChild(char38);
        CommonToken char39 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext3.addChild(char39);
        CommonToken char40 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext3.addChild(char40);
        CommonToken char41 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext3.addChild(char41);
        CommonToken char42 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext3.addChild(char42);
        CommonToken char43 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext3.addChild(char43);
        CommonToken char44 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext3.addChild(char44);
        CommonToken char45 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext3.addChild(char45);
        CommonToken char46 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext3.addChild(char46);
        CommonToken char47 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext3.addChild(char47);
        CommonToken ws11 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext3.addChild(ws11);
        CommonToken char48 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext3.addChild(char48);
        CommonToken char49 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext3.addChild(char49);
        CommonToken ws12 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext3.addChild(ws12);
        CommonToken char50 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext3.addChild(char50);
        CommonToken char51 = new CommonToken(JavadocTokenTypes.CHAR, "y");
        textContext3.addChild(char51);
        CommonToken ws13 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext3.addChild(ws13);
        CommonToken char52 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext3.addChild(char52);
        CommonToken char53 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext3.addChild(char53);
        CommonToken char54 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext3.addChild(char54);
        CommonToken char55 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext3.addChild(char55);
        CommonToken char56 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext3.addChild(char56);
        CommonToken char57 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext3.addChild(char57);
        CommonToken ws14 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext3.addChild(ws14);
        CommonToken char58 = new CommonToken(JavadocTokenTypes.CHAR, "f");
        textContext3.addChild(char58);
        CommonToken char59 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext3.addChild(char59);
        CommonToken char60 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext3.addChild(char60);
        CommonToken char61 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext3.addChild(char61);
        CommonToken char62 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext3.addChild(char62);
        descriptionContext3.addChild(textContext3);
        CommonToken newline5 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext3.addChild(newline5);
        javadocTagContext3.addChild(descriptionContext3);
        javadocContext0.addChild(javadocTagContext3);
        JavadocTagContext javadocTagContext4 = new JavadocTagContext(javadocContext0, 0);
        CommonToken serialDataLiteral0 = new CommonToken(JavadocTokenTypes.SERIAL_DATA_LITERAL, "@serialData");
        javadocTagContext4.addChild(serialDataLiteral0);
        CommonToken ws15 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext4.addChild(ws15);
        DescriptionContext descriptionContext4 = new DescriptionContext(javadocTagContext4, 0);
        TextContext textContext4 = new TextContext(descriptionContext4, 0);
        CommonToken char63 = new CommonToken(JavadocTokenTypes.CHAR, "T");
        textContext4.addChild(char63);
        CommonToken char64 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext4.addChild(char64);
        CommonToken char65 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext4.addChild(char65);
        CommonToken ws16 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext4.addChild(ws16);
        CommonToken char66 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext4.addChild(char66);
        CommonToken char67 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext4.addChild(char67);
        CommonToken char68 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext4.addChild(char68);
        CommonToken char69 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext4.addChild(char69);
        CommonToken char70 = new CommonToken(JavadocTokenTypes.CHAR, "-");
        textContext4.addChild(char70);
        CommonToken char71 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext4.addChild(char71);
        CommonToken char72 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext4.addChild(char72);
        CommonToken char73 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext4.addChild(char73);
        CommonToken char74 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext4.addChild(char74);
        CommonToken char75 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext4.addChild(char75);
        CommonToken char76 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext4.addChild(char76);
        CommonToken char77 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext4.addChild(char77);
        CommonToken char78 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext4.addChild(char78);
        CommonToken char79 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext4.addChild(char79);
        CommonToken char80 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext4.addChild(char80);
        CommonToken char81 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext4.addChild(char81);
        CommonToken ws17 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext4.addChild(ws17);
        CommonToken char82 = new CommonToken(JavadocTokenTypes.CHAR, "d");
        textContext4.addChild(char82);
        CommonToken char83 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext4.addChild(char83);
        CommonToken char84 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext4.addChild(char84);
        CommonToken char85 = new CommonToken(JavadocTokenTypes.CHAR, "u");
        textContext4.addChild(char85);
        CommonToken char86 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext4.addChild(char86);
        CommonToken char87 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext4.addChild(char87);
        CommonToken char88 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext4.addChild(char88);
        CommonToken char89 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext4.addChild(char89);
        CommonToken char90 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext4.addChild(char90);
        descriptionContext4.addChild(textContext4);
        javadocTagContext4.addChild(descriptionContext4);
        javadocContext0.addChild(javadocTagContext4);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeSince()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        CommonToken leadingAsterisk0 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, "*");
        javadocContext0.addChild(leadingAsterisk0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocContext0.addChild(ws0);
        JavadocTagContext javadocTagContext0 = new JavadocTagContext(javadocContext0, 0);
        CommonToken sinceLiteral0 = new CommonToken(JavadocTokenTypes.SINCE_LITERAL, "@since");
        javadocTagContext0.addChild(sinceLiteral0);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext0.addChild(ws1);
        DescriptionContext descriptionContext0 = new DescriptionContext(javadocTagContext0, 0);
        TextContext textContext0 = new TextContext(descriptionContext0, 0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "1");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext0.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "5");
        textContext0.addChild(char2);
        descriptionContext0.addChild(textContext0);
        CommonToken newline0 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext0.addChild(newline0);
        javadocTagContext0.addChild(descriptionContext0);
        javadocContext0.addChild(javadocTagContext0);
        CommonToken leadingAsterisk1 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocContext0.addChild(leadingAsterisk1);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocContext0.addChild(ws2);
        JavadocTagContext javadocTagContext1 = new JavadocTagContext(javadocContext0, 0);
        CommonToken sinceLiteral1 = new CommonToken(JavadocTokenTypes.SINCE_LITERAL, "@since");
        javadocTagContext1.addChild(sinceLiteral1);
        CommonToken ws3 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext1.addChild(ws3);
        DescriptionContext descriptionContext1 = new DescriptionContext(javadocTagContext1, 0);
        TextContext textContext1 = new TextContext(descriptionContext1, 0);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "R");
        textContext1.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext1.addChild(char4);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext1.addChild(char5);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext1.addChild(char6);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext1.addChild(char7);
        CommonToken char8 = new CommonToken(JavadocTokenTypes.CHAR, "s");
        textContext1.addChild(char8);
        CommonToken char9 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext1.addChild(char9);
        CommonToken ws4 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext1.addChild(ws4);
        CommonToken char10 = new CommonToken(JavadocTokenTypes.CHAR, "3");
        textContext1.addChild(char10);
        CommonToken char11 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext1.addChild(char11);
        CommonToken char12 = new CommonToken(JavadocTokenTypes.CHAR, "4");
        textContext1.addChild(char12);
        CommonToken char13 = new CommonToken(JavadocTokenTypes.CHAR, ".");
        textContext1.addChild(char13);
        CommonToken char14 = new CommonToken(JavadocTokenTypes.CHAR, "5");
        textContext1.addChild(char14);
        descriptionContext1.addChild(textContext1);
        javadocTagContext1.addChild(descriptionContext1);
        javadocContext0.addChild(javadocTagContext1);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeTextBeforeJavadocTags()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        CommonToken newline0 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline0);
        CommonToken leadingAsterisk0 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocContext0.addChild(leadingAsterisk0);
        TextContext textContext0 = new TextContext(javadocContext0, 0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext0.addChild(char0);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws1);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "b");
        textContext0.addChild(char1);
        javadocContext0.addChild(textContext0);
        CommonToken newline1 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline1);
        CommonToken leadingAsterisk1 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocContext0.addChild(leadingAsterisk1);
        TextContext textContext1 = new TextContext(javadocContext0, 0);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext1.addChild(ws2);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "c");
        textContext1.addChild(char2);
        javadocContext0.addChild(textContext1);
        CommonToken newline2 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocContext0.addChild(newline2);
        CommonToken leadingAsterisk2 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocContext0.addChild(leadingAsterisk2);
        CommonToken ws3 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocContext0.addChild(ws3);
        JavadocTagContext javadocTagContext0 = new JavadocTagContext(javadocContext0, 0);
        CommonToken seeLiteral0 = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        javadocTagContext0.addChild(seeLiteral0);
        CommonToken ws4 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext0.addChild(ws4);
        ReferenceContext referenceContext0 = new ReferenceContext(javadocTagContext0, 0);
        CommonToken class0 = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        referenceContext0.addChild(class0);
        javadocTagContext0.addChild(referenceContext0);
        CommonToken ws5 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext0.addChild(ws5);
        DescriptionContext descriptionContext0 = new DescriptionContext(javadocTagContext0, 0);
        TextContext textContext2 = new TextContext(descriptionContext0, 0);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "I");
        textContext2.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext2.addChild(char4);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext2.addChild(char5);
        descriptionContext0.addChild(textContext2);
        CommonToken newline3 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext0.addChild(newline3);
        javadocTagContext0.addChild(descriptionContext0);
        javadocContext0.addChild(javadocTagContext0);
        CommonToken leadingAsterisk3 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocContext0.addChild(leadingAsterisk3);
        CommonToken ws6 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocContext0.addChild(ws6);
        JavadocTagContext javadocTagContext1 = new JavadocTagContext(javadocContext0, 0);
        CommonToken authorLiteral0 = new CommonToken(JavadocTokenTypes.AUTHOR_LITERAL, "@author");
        javadocTagContext1.addChild(authorLiteral0);
        CommonToken ws7 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext1.addChild(ws7);
        DescriptionContext descriptionContext1 = new DescriptionContext(javadocTagContext1, 0);
        TextContext textContext3 = new TextContext(descriptionContext1, 0);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "W");
        textContext3.addChild(char6);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, "a");
        textContext3.addChild(char7);
        CommonToken char8 = new CommonToken(JavadocTokenTypes.CHAR, "l");
        textContext3.addChild(char8);
        CommonToken char9 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext3.addChild(char9);
        CommonToken char10 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext3.addChild(char10);
        CommonToken char11 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext3.addChild(char11);
        CommonToken ws8 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext3.addChild(ws8);
        CommonToken char12 = new CommonToken(JavadocTokenTypes.CHAR, "W");
        textContext3.addChild(char12);
        CommonToken char13 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext3.addChild(char13);
        CommonToken char14 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext3.addChild(char14);
        CommonToken char15 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext3.addChild(char15);
        CommonToken char16 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext3.addChild(char16);
        descriptionContext1.addChild(textContext3);
        CommonToken newline4 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext1.addChild(newline4);
        javadocTagContext1.addChild(descriptionContext1);
        javadocContext0.addChild(javadocTagContext1);
        CommonToken leadingAsterisk4 = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        javadocContext0.addChild(leadingAsterisk4);
        CommonToken ws9 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocContext0.addChild(ws9);
        JavadocTagContext javadocTagContext2 = new JavadocTagContext(javadocContext0, 0);
        CommonToken authorLiteral1 = new CommonToken(JavadocTokenTypes.AUTHOR_LITERAL, "@author");
        javadocTagContext2.addChild(authorLiteral1);
        CommonToken ws10 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext2.addChild(ws10);
        DescriptionContext descriptionContext2 = new DescriptionContext(javadocTagContext2, 0);
        TextContext textContext4 = new TextContext(descriptionContext2, 0);
        CommonToken char17 = new CommonToken(JavadocTokenTypes.CHAR, "J");
        textContext4.addChild(char17);
        CommonToken char18 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext4.addChild(char18);
        CommonToken char19 = new CommonToken(JavadocTokenTypes.CHAR, "h");
        textContext4.addChild(char19);
        CommonToken char20 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext4.addChild(char20);
        CommonToken ws11 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext4.addChild(ws11);
        CommonToken char21 = new CommonToken(JavadocTokenTypes.CHAR, "S");
        textContext4.addChild(char21);
        CommonToken char22 = new CommonToken(JavadocTokenTypes.CHAR, "n");
        textContext4.addChild(char22);
        CommonToken char23 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext4.addChild(char23);
        CommonToken char24 = new CommonToken(JavadocTokenTypes.CHAR, "w");
        textContext4.addChild(char24);
        descriptionContext2.addChild(textContext4);
        CommonToken newline5 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext2.addChild(newline5);
        TextContext textContext5 = new TextContext(descriptionContext2, 0);
        CommonToken ws12 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext5.addChild(ws12);
        descriptionContext2.addChild(textContext5);
        javadocTagContext2.addChild(descriptionContext2);
        javadocContext0.addChild(javadocTagContext2);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

    public static ParseTree treeTwoLinkTagsInRow()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        JavadocInlineTagContext javadocInlineTagContext0 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext0.addChild(javadocInlineTagStart0);
        CommonToken linkLiteral0 = new CommonToken(JavadocTokenTypes.LINK_LITERAL, "@link");
        javadocInlineTagContext0.addChild(linkLiteral0);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext0.addChild(ws0);
        ReferenceContext referenceContext0 = new ReferenceContext(javadocInlineTagContext0, 0);
        CommonToken hash0 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext0.addChild(hash0);
        CommonToken member0 = new CommonToken(JavadocTokenTypes.MEMBER, "WHITESPACE");
        referenceContext0.addChild(member0);
        javadocInlineTagContext0.addChild(referenceContext0);
        DescriptionContext descriptionContext0 = new DescriptionContext(javadocInlineTagContext0, 0);
        TextContext textContext0 = new TextContext(descriptionContext0, 0);
        CommonToken ws1 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext0.addChild(ws1);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "W");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "H");
        textContext0.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "I");
        textContext0.addChild(char2);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "T");
        textContext0.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "E");
        textContext0.addChild(char4);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "S");
        textContext0.addChild(char5);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "P");
        textContext0.addChild(char6);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, "A");
        textContext0.addChild(char7);
        CommonToken char8 = new CommonToken(JavadocTokenTypes.CHAR, "C");
        textContext0.addChild(char8);
        CommonToken char9 = new CommonToken(JavadocTokenTypes.CHAR, "E");
        textContext0.addChild(char9);
        descriptionContext0.addChild(textContext0);
        javadocInlineTagContext0.addChild(descriptionContext0);
        CommonToken javadocInlineTagEnd0 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext0.addChild(javadocInlineTagEnd0);
        javadocContext0.addChild(javadocInlineTagContext0);
        JavadocInlineTagContext javadocInlineTagContext1 = new JavadocInlineTagContext(javadocContext0, 0);
        CommonToken javadocInlineTagStart1 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        javadocInlineTagContext1.addChild(javadocInlineTagStart1);
        CommonToken linkLiteral1 = new CommonToken(JavadocTokenTypes.LINK_LITERAL, "@link");
        javadocInlineTagContext1.addChild(linkLiteral1);
        CommonToken ws2 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocInlineTagContext1.addChild(ws2);
        ReferenceContext referenceContext1 = new ReferenceContext(javadocInlineTagContext1, 0);
        CommonToken hash1 = new CommonToken(JavadocTokenTypes.HASH, "#");
        referenceContext1.addChild(hash1);
        CommonToken member1 = new CommonToken(JavadocTokenTypes.MEMBER, "trimFrom");
        referenceContext1.addChild(member1);
        javadocInlineTagContext1.addChild(referenceContext1);
        DescriptionContext descriptionContext1 = new DescriptionContext(javadocInlineTagContext1, 0);
        TextContext textContext1 = new TextContext(descriptionContext1, 0);
        CommonToken ws3 = new CommonToken(JavadocTokenTypes.WS, " ");
        textContext1.addChild(ws3);
        CommonToken char10 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext1.addChild(char10);
        CommonToken char11 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext1.addChild(char11);
        CommonToken char12 = new CommonToken(JavadocTokenTypes.CHAR, "i");
        textContext1.addChild(char12);
        CommonToken char13 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext1.addChild(char13);
        CommonToken char14 = new CommonToken(JavadocTokenTypes.CHAR, "F");
        textContext1.addChild(char14);
        CommonToken char15 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext1.addChild(char15);
        CommonToken char16 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext1.addChild(char16);
        CommonToken char17 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext1.addChild(char17);
        descriptionContext1.addChild(textContext1);
        javadocInlineTagContext1.addChild(descriptionContext1);
        CommonToken javadocInlineTagEnd1 = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        javadocInlineTagContext1.addChild(javadocInlineTagEnd1);
        javadocContext0.addChild(javadocInlineTagContext1);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }
    
    public static ParseTree treeCustomTagWithDot()
    {
        JavadocContext javadocContext0 = new JavadocContext(null, 0);
        JavadocTagContext javadocTagContext0 = new JavadocTagContext(javadocContext0, 0);
        CommonToken customName0 = new CommonToken(JavadocTokenTypes.CUSTOM_NAME, "@ejb:bean");
        javadocTagContext0.addChild(customName0);
        CommonToken newline0 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext0.addChild(newline0);
        javadocContext0.addChild(javadocTagContext0);
        JavadocTagContext javadocTagContext1 = new JavadocTagContext(javadocContext0, 0);
        CommonToken customName1 = new CommonToken(JavadocTokenTypes.CUSTOM_NAME, "@hibernate.property");
        javadocTagContext1.addChild(customName1);
        CommonToken ws0 = new CommonToken(JavadocTokenTypes.WS, " ");
        javadocTagContext1.addChild(ws0);
        DescriptionContext descriptionContext0 = new DescriptionContext(javadocTagContext1, 0);
        TextContext textContext0 = new TextContext(descriptionContext0, 0);
        CommonToken char0 = new CommonToken(JavadocTokenTypes.CHAR, "m");
        textContext0.addChild(char0);
        CommonToken char1 = new CommonToken(JavadocTokenTypes.CHAR, "y");
        textContext0.addChild(char1);
        CommonToken char2 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext0.addChild(char2);
        CommonToken char3 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext0.addChild(char3);
        CommonToken char4 = new CommonToken(JavadocTokenTypes.CHAR, "o");
        textContext0.addChild(char4);
        CommonToken char5 = new CommonToken(JavadocTokenTypes.CHAR, "p");
        textContext0.addChild(char5);
        CommonToken char6 = new CommonToken(JavadocTokenTypes.CHAR, "e");
        textContext0.addChild(char6);
        CommonToken char7 = new CommonToken(JavadocTokenTypes.CHAR, "r");
        textContext0.addChild(char7);
        CommonToken char8 = new CommonToken(JavadocTokenTypes.CHAR, "t");
        textContext0.addChild(char8);
        CommonToken char9 = new CommonToken(JavadocTokenTypes.CHAR, "y");
        textContext0.addChild(char9);
        descriptionContext0.addChild(textContext0);
        CommonToken newline1 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        descriptionContext0.addChild(newline1);
        javadocTagContext1.addChild(descriptionContext0);
        javadocContext0.addChild(javadocTagContext1);
        JavadocTagContext javadocTagContext2 = new JavadocTagContext(javadocContext0, 0);
        CommonToken customName2 = new CommonToken(JavadocTokenTypes.CUSTOM_NAME, "@weblogic.cache-ref");
        javadocTagContext2.addChild(customName2);
        CommonToken newline2 = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        javadocTagContext2.addChild(newline2);
        javadocContext0.addChild(javadocTagContext2);
        JavadocTagContext javadocTagContext3 = new JavadocTagContext(javadocContext0, 0);
        CommonToken customName3 = new CommonToken(JavadocTokenTypes.CUSTOM_NAME, "@my_tag");
        javadocTagContext3.addChild(customName3);
        javadocContext0.addChild(javadocTagContext3);
        CommonToken eof0 = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        javadocContext0.addChild(eof0);
        return javadocContext0;
    }

}
