////////////////////////////////////////////////////////////////////////////////
// checkstyle: Checks Java source code for adherence to a set of rules.
// Copyright (C) 2001-2015 the original author or authors.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
////////////////////////////////////////////////////////////////////////////////

package com.puppycrawl.tools.checkstyle.grammars.javadoc;

import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.tree.ParseTree;

import com.puppycrawl.tools.checkstyle.api.JavadocTokenTypes;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.AttributeContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.BrTagContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.DescriptionContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.HtmlCommentContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.HtmlElementCloseContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.HtmlElementContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.HtmlElementOpenContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.HtmlTagContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.JavadocContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.JavadocInlineTagContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.JavadocTagContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.LiContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.LiTagCloseContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.LiTagOpenContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.PTagCloseContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.PTagOpenContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.ParagraphContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.ParametersContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.ReferenceContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.SingletonElementContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.TextContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.TrContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.TrTagCloseContext;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser.TrTagOpenContext;

//@formatter:off
final class ParseTreeBuilder {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private ParseTreeBuilder() {
    }

    public static ParseTree treeOneSimpleHtmlTag() {
        JavadocContext Rohae = new JavadocContext(null, 0);
        HtmlElementContext qazLp = new HtmlElementContext(Rohae, 0);
        HtmlTagContext tShZn = new HtmlTagContext(qazLp, 0);
        HtmlElementOpenContext mcNfy = new HtmlElementOpenContext(tShZn, 0);
        CommonToken skbCU = new CommonToken(JavadocTokenTypes.OPEN, "<");
        mcNfy.addChild(skbCU);
        CommonToken eOKbB = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "g");
        mcNfy.addChild(eOKbB);
        CommonToken kSmfa = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        mcNfy.addChild(kSmfa);
        tShZn.addChild(mcNfy);
        TextContext NyvuY = new TextContext(tShZn, 0);
        CommonToken vYGan = new CommonToken(JavadocTokenTypes.CHAR, "b");
        NyvuY.addChild(vYGan);
        CommonToken DjqdT = new CommonToken(JavadocTokenTypes.CHAR, "l");
        NyvuY.addChild(DjqdT);
        CommonToken jSNqm = new CommonToken(JavadocTokenTypes.CHAR, "a");
        NyvuY.addChild(jSNqm);
        CommonToken Sqmta = new CommonToken(JavadocTokenTypes.CHAR, "b");
        NyvuY.addChild(Sqmta);
        CommonToken ugpch = new CommonToken(JavadocTokenTypes.CHAR, "l");
        NyvuY.addChild(ugpch);
        CommonToken NIRMy = new CommonToken(JavadocTokenTypes.CHAR, "a");
        NyvuY.addChild(NIRMy);
        tShZn.addChild(NyvuY);
        HtmlElementCloseContext ttSqx = new HtmlElementCloseContext(tShZn, 0);
        CommonToken QJJgO = new CommonToken(JavadocTokenTypes.OPEN, "<");
        ttSqx.addChild(QJJgO);
        CommonToken tCdKm = new CommonToken(JavadocTokenTypes.SLASH, "/");
        ttSqx.addChild(tCdKm);
        CommonToken IvHnz = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "g");
        ttSqx.addChild(IvHnz);
        CommonToken iudHS = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        ttSqx.addChild(iudHS);
        tShZn.addChild(ttSqx);
        qazLp.addChild(tShZn);
        Rohae.addChild(qazLp);
        CommonToken okEpH = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        Rohae.addChild(okEpH);
        return Rohae;
    }
    public static ParseTree treeTextBeforeJavadocTags() {
        JavadocContext gfEDH = new JavadocContext(null, 0);
        CommonToken rpeYD = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        gfEDH.addChild(rpeYD);
        CommonToken QCYfG = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        gfEDH.addChild(QCYfG);
        TextContext tlLMb = new TextContext(gfEDH, 0);
        CommonToken JYrge = new CommonToken(JavadocTokenTypes.WS, " ");
        tlLMb.addChild(JYrge);
        CommonToken Vobgp = new CommonToken(JavadocTokenTypes.CHAR, "a");
        tlLMb.addChild(Vobgp);
        CommonToken BMvCq = new CommonToken(JavadocTokenTypes.WS, " ");
        tlLMb.addChild(BMvCq);
        CommonToken ZaeOY = new CommonToken(JavadocTokenTypes.CHAR, "b");
        tlLMb.addChild(ZaeOY);
        gfEDH.addChild(tlLMb);
        CommonToken csKKg = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        gfEDH.addChild(csKKg);
        CommonToken LxsKm = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        gfEDH.addChild(LxsKm);
        TextContext Shhcm = new TextContext(gfEDH, 0);
        CommonToken DcHmn = new CommonToken(JavadocTokenTypes.WS, " ");
        Shhcm.addChild(DcHmn);
        CommonToken aQnuA = new CommonToken(JavadocTokenTypes.CHAR, "c");
        Shhcm.addChild(aQnuA);
        gfEDH.addChild(Shhcm);
        CommonToken QPmcl = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        gfEDH.addChild(QPmcl);
        CommonToken HETZU = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        gfEDH.addChild(HETZU);
        CommonToken ZzZPO = new CommonToken(JavadocTokenTypes.WS, " ");
        gfEDH.addChild(ZzZPO);
        JavadocTagContext SjBMb = new JavadocTagContext(gfEDH, 0);
        CommonToken smqzs = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        SjBMb.addChild(smqzs);
        CommonToken bYsfI = new CommonToken(JavadocTokenTypes.WS, " ");
        SjBMb.addChild(bYsfI);
        ReferenceContext tWOgn = new ReferenceContext(SjBMb, 0);
        CommonToken yJSrg = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        tWOgn.addChild(yJSrg);
        SjBMb.addChild(tWOgn);
        CommonToken frxBx = new CommonToken(JavadocTokenTypes.WS, " ");
        SjBMb.addChild(frxBx);
        DescriptionContext HLhWc = new DescriptionContext(SjBMb, 0);
        TextContext VNWAJ = new TextContext(HLhWc, 0);
        CommonToken jjtPq = new CommonToken(JavadocTokenTypes.CHAR, "I");
        VNWAJ.addChild(jjtPq);
        CommonToken xOBWx = new CommonToken(JavadocTokenTypes.CHAR, "n");
        VNWAJ.addChild(xOBWx);
        CommonToken OGSiY = new CommonToken(JavadocTokenTypes.CHAR, "t");
        VNWAJ.addChild(OGSiY);
        HLhWc.addChild(VNWAJ);
        CommonToken FXyBf = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        HLhWc.addChild(FXyBf);
        SjBMb.addChild(HLhWc);
        gfEDH.addChild(SjBMb);
        CommonToken VVAcP = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        gfEDH.addChild(VVAcP);
        CommonToken WjPJx = new CommonToken(JavadocTokenTypes.WS, " ");
        gfEDH.addChild(WjPJx);
        JavadocTagContext evKhl = new JavadocTagContext(gfEDH, 0);
        CommonToken jZLvn = new CommonToken(JavadocTokenTypes.AUTHOR_LITERAL, "@author");
        evKhl.addChild(jZLvn);
        CommonToken odstf = new CommonToken(JavadocTokenTypes.WS, " ");
        evKhl.addChild(odstf);
        DescriptionContext kLuAB = new DescriptionContext(evKhl, 0);
        TextContext bvsMR = new TextContext(kLuAB, 0);
        CommonToken fcFlB = new CommonToken(JavadocTokenTypes.CHAR, "W");
        bvsMR.addChild(fcFlB);
        CommonToken iZyOh = new CommonToken(JavadocTokenTypes.CHAR, "a");
        bvsMR.addChild(iZyOh);
        CommonToken TsXte = new CommonToken(JavadocTokenTypes.CHAR, "l");
        bvsMR.addChild(TsXte);
        CommonToken hdyiE = new CommonToken(JavadocTokenTypes.CHAR, "t");
        bvsMR.addChild(hdyiE);
        CommonToken OldJO = new CommonToken(JavadocTokenTypes.CHAR, "e");
        bvsMR.addChild(OldJO);
        CommonToken PYvdd = new CommonToken(JavadocTokenTypes.CHAR, "r");
        bvsMR.addChild(PYvdd);
        CommonToken caQfZ = new CommonToken(JavadocTokenTypes.WS, " ");
        bvsMR.addChild(caQfZ);
        CommonToken ktrNT = new CommonToken(JavadocTokenTypes.CHAR, "W");
        bvsMR.addChild(ktrNT);
        CommonToken VfpDF = new CommonToken(JavadocTokenTypes.CHAR, "h");
        bvsMR.addChild(VfpDF);
        CommonToken NtTSj = new CommonToken(JavadocTokenTypes.CHAR, "i");
        bvsMR.addChild(NtTSj);
        CommonToken iqUhK = new CommonToken(JavadocTokenTypes.CHAR, "t");
        bvsMR.addChild(iqUhK);
        CommonToken UHgfY = new CommonToken(JavadocTokenTypes.CHAR, "e");
        bvsMR.addChild(UHgfY);
        kLuAB.addChild(bvsMR);
        CommonToken LiOmQ = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        kLuAB.addChild(LiOmQ);
        evKhl.addChild(kLuAB);
        gfEDH.addChild(evKhl);
        CommonToken tiegF = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        gfEDH.addChild(tiegF);
        CommonToken ktgJS = new CommonToken(JavadocTokenTypes.WS, " ");
        gfEDH.addChild(ktgJS);
        JavadocTagContext WyRvi = new JavadocTagContext(gfEDH, 0);
        CommonToken yItAZ = new CommonToken(JavadocTokenTypes.AUTHOR_LITERAL, "@author");
        WyRvi.addChild(yItAZ);
        CommonToken VsNbv = new CommonToken(JavadocTokenTypes.WS, " ");
        WyRvi.addChild(VsNbv);
        DescriptionContext KadGv = new DescriptionContext(WyRvi, 0);
        TextContext fsYhy = new TextContext(KadGv, 0);
        CommonToken QLquB = new CommonToken(JavadocTokenTypes.CHAR, "J");
        fsYhy.addChild(QLquB);
        CommonToken tpwVU = new CommonToken(JavadocTokenTypes.CHAR, "o");
        fsYhy.addChild(tpwVU);
        CommonToken QvluV = new CommonToken(JavadocTokenTypes.CHAR, "h");
        fsYhy.addChild(QvluV);
        CommonToken cQlIs = new CommonToken(JavadocTokenTypes.CHAR, "n");
        fsYhy.addChild(cQlIs);
        CommonToken ZQDPr = new CommonToken(JavadocTokenTypes.WS, " ");
        fsYhy.addChild(ZQDPr);
        CommonToken WMWeU = new CommonToken(JavadocTokenTypes.CHAR, "S");
        fsYhy.addChild(WMWeU);
        CommonToken xXCnc = new CommonToken(JavadocTokenTypes.CHAR, "n");
        fsYhy.addChild(xXCnc);
        CommonToken BGIhA = new CommonToken(JavadocTokenTypes.CHAR, "o");
        fsYhy.addChild(BGIhA);
        CommonToken XmTzP = new CommonToken(JavadocTokenTypes.CHAR, "w");
        fsYhy.addChild(XmTzP);
        KadGv.addChild(fsYhy);
        CommonToken NhsCl = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        KadGv.addChild(NhsCl);
        TextContext TZrfl = new TextContext(KadGv, 0);
        CommonToken QLNbu = new CommonToken(JavadocTokenTypes.WS, " ");
        TZrfl.addChild(QLNbu);
        KadGv.addChild(TZrfl);
        WyRvi.addChild(KadGv);
        gfEDH.addChild(WyRvi);
        CommonToken cnrjp = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        gfEDH.addChild(cnrjp);
        return gfEDH;
    }
    public static ParseTree treeCustomJavadocTags() {
        JavadocContext vqeRv = new JavadocContext(null, 0);
        CommonToken kUYEj = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        vqeRv.addChild(kUYEj);
        CommonToken VOJHC = new CommonToken(JavadocTokenTypes.WS, " ");
        vqeRv.addChild(VOJHC);
        JavadocTagContext DYThx = new JavadocTagContext(vqeRv, 0);
        CommonToken ctenR = new CommonToken(JavadocTokenTypes.CUSTOM_NAME, "@myTag");
        DYThx.addChild(ctenR);
        CommonToken ObxYB = new CommonToken(JavadocTokenTypes.WS, " ");
        DYThx.addChild(ObxYB);
        DescriptionContext WuoxQ = new DescriptionContext(DYThx, 0);
        TextContext FaQUX = new TextContext(WuoxQ, 0);
        CommonToken fpyzz = new CommonToken(JavadocTokenTypes.CHAR, "y");
        FaQUX.addChild(fpyzz);
        CommonToken lbwtC = new CommonToken(JavadocTokenTypes.CHAR, "e");
        FaQUX.addChild(lbwtC);
        CommonToken xCpJd = new CommonToken(JavadocTokenTypes.CHAR, "s");
        FaQUX.addChild(xCpJd);
        CommonToken OOdfd = new CommonToken(JavadocTokenTypes.WS, " ");
        FaQUX.addChild(OOdfd);
        CommonToken jTWwf = new CommonToken(JavadocTokenTypes.CHAR, "i");
        FaQUX.addChild(jTWwf);
        CommonToken tYuft = new CommonToken(JavadocTokenTypes.CHAR, "t");
        FaQUX.addChild(tYuft);
        CommonToken Rjpiw = new CommonToken(JavadocTokenTypes.WS, " ");
        FaQUX.addChild(Rjpiw);
        CommonToken eumTC = new CommonToken(JavadocTokenTypes.CHAR, "i");
        FaQUX.addChild(eumTC);
        CommonToken SUdyR = new CommonToken(JavadocTokenTypes.CHAR, "s");
        FaQUX.addChild(SUdyR);
        WuoxQ.addChild(FaQUX);
        CommonToken ZcIzE = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        WuoxQ.addChild(ZcIzE);
        DYThx.addChild(WuoxQ);
        vqeRv.addChild(DYThx);
        CommonToken kMCCR = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        vqeRv.addChild(kMCCR);
        CommonToken pFtfc = new CommonToken(JavadocTokenTypes.WS, " ");
        vqeRv.addChild(pFtfc);
        JavadocTagContext mYbvf = new JavadocTagContext(vqeRv, 0);
        CommonToken JUVPH = new CommonToken(JavadocTokenTypes.CUSTOM_NAME, "@anotherTagWithoutParameter");
        mYbvf.addChild(JUVPH);
        CommonToken mDykX = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        mYbvf.addChild(mDykX);
        vqeRv.addChild(mYbvf);
        CommonToken oHnTB = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        vqeRv.addChild(oHnTB);
        CommonToken aLlHU = new CommonToken(JavadocTokenTypes.WS, " ");
        vqeRv.addChild(aLlHU);
        JavadocTagContext MVTCW = new JavadocTagContext(vqeRv, 0);
        CommonToken ipxcL = new CommonToken(JavadocTokenTypes.AUTHOR_LITERAL, "@author");
        MVTCW.addChild(ipxcL);
        CommonToken AfLyL = new CommonToken(JavadocTokenTypes.WS, " ");
        MVTCW.addChild(AfLyL);
        DescriptionContext ZXuuK = new DescriptionContext(MVTCW, 0);
        TextContext uXOoV = new TextContext(ZXuuK, 0);
        CommonToken PzlFR = new CommonToken(JavadocTokenTypes.CHAR, "I");
        uXOoV.addChild(PzlFR);
        ZXuuK.addChild(uXOoV);
        CommonToken VNXPi = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        ZXuuK.addChild(VNXPi);
        TextContext vUStO = new TextContext(ZXuuK, 0);
        CommonToken yLjDi = new CommonToken(JavadocTokenTypes.WS, " ");
        vUStO.addChild(yLjDi);
        ZXuuK.addChild(vUStO);
        MVTCW.addChild(ZXuuK);
        vqeRv.addChild(MVTCW);
        CommonToken QNmAS = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        vqeRv.addChild(QNmAS);
        return vqeRv;
    }
    public static ParseTree treeJavadocTagDescriptionWithInlineTags() {
        JavadocContext ckejg = new JavadocContext(null, 0);
        JavadocTagContext HBaud = new JavadocTagContext(ckejg, 0);
        CommonToken YeyWs = new CommonToken(JavadocTokenTypes.DEPRECATED_LITERAL, "@deprecated");
        HBaud.addChild(YeyWs);
        CommonToken plGhl = new CommonToken(JavadocTokenTypes.WS, " ");
        HBaud.addChild(plGhl);
        DescriptionContext roovx = new DescriptionContext(HBaud, 0);
        TextContext lCvIq = new TextContext(roovx, 0);
        CommonToken OlFdS = new CommonToken(JavadocTokenTypes.CHAR, "u");
        lCvIq.addChild(OlFdS);
        CommonToken lCAos = new CommonToken(JavadocTokenTypes.CHAR, "s");
        lCvIq.addChild(lCAos);
        CommonToken hqFBO = new CommonToken(JavadocTokenTypes.CHAR, "e");
        lCvIq.addChild(hqFBO);
        CommonToken DWiAh = new CommonToken(JavadocTokenTypes.WS, " ");
        lCvIq.addChild(DWiAh);
        roovx.addChild(lCvIq);
        JavadocInlineTagContext FVbYW = new JavadocInlineTagContext(roovx, 0);
        CommonToken nHbXu = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        FVbYW.addChild(nHbXu);
        CommonToken jmpgq = new CommonToken(JavadocTokenTypes.LINK_LITERAL, "@link");
        FVbYW.addChild(jmpgq);
        CommonToken MDzSX = new CommonToken(JavadocTokenTypes.WS, " ");
        FVbYW.addChild(MDzSX);
        ReferenceContext HMaDA = new ReferenceContext(FVbYW, 0);
        CommonToken Jhqym = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        HMaDA.addChild(Jhqym);
        CommonToken PLrXL = new CommonToken(JavadocTokenTypes.DOT, ".");
        HMaDA.addChild(PLrXL);
        CommonToken ktXCU = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        HMaDA.addChild(ktXCU);
        FVbYW.addChild(HMaDA);
        DescriptionContext ztrDY = new DescriptionContext(FVbYW, 0);
        TextContext IGcNX = new TextContext(ztrDY, 0);
        CommonToken CyJjh = new CommonToken(JavadocTokenTypes.WS, " ");
        IGcNX.addChild(CyJjh);
        CommonToken YZFRh = new CommonToken(JavadocTokenTypes.CHAR, "I");
        IGcNX.addChild(YZFRh);
        CommonToken uuLgj = new CommonToken(JavadocTokenTypes.CHAR, "n");
        IGcNX.addChild(uuLgj);
        CommonToken hKAOH = new CommonToken(JavadocTokenTypes.CHAR, "t");
        IGcNX.addChild(hKAOH);
        CommonToken XeMhP = new CommonToken(JavadocTokenTypes.CHAR, "e");
        IGcNX.addChild(XeMhP);
        CommonToken JWZxb = new CommonToken(JavadocTokenTypes.CHAR, "g");
        IGcNX.addChild(JWZxb);
        CommonToken sXOYk = new CommonToken(JavadocTokenTypes.CHAR, "e");
        IGcNX.addChild(sXOYk);
        CommonToken NZnjU = new CommonToken(JavadocTokenTypes.CHAR, "r");
        IGcNX.addChild(NZnjU);
        ztrDY.addChild(IGcNX);
        JavadocInlineTagContext nUzga = new JavadocInlineTagContext(ztrDY, 0);
        CommonToken CRuAH = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        nUzga.addChild(CRuAH);
        CommonToken ZzRot = new CommonToken(JavadocTokenTypes.CODE_LITERAL, "@code");
        nUzga.addChild(ZzRot);
        CommonToken hzHqq = new CommonToken(JavadocTokenTypes.WS, " ");
        nUzga.addChild(hzHqq);
        TextContext zSjXd = new TextContext(nUzga, 0);
        CommonToken KTIhG = new CommonToken(JavadocTokenTypes.CHAR, "<");
        zSjXd.addChild(KTIhG);
        CommonToken oDeiQ = new CommonToken(JavadocTokenTypes.CHAR, "a");
        zSjXd.addChild(oDeiQ);
        CommonToken bCRuf = new CommonToken(JavadocTokenTypes.CHAR, ">");
        zSjXd.addChild(bCRuf);
        CommonToken WyGtD = new CommonToken(JavadocTokenTypes.CHAR, "W");
        zSjXd.addChild(WyGtD);
        CommonToken BUUWH = new CommonToken(JavadocTokenTypes.CHAR, "a");
        zSjXd.addChild(BUUWH);
        CommonToken gBlIs = new CommonToken(JavadocTokenTypes.CHAR, "t");
        zSjXd.addChild(gBlIs);
        CommonToken LIhFs = new CommonToken(JavadocTokenTypes.CHAR, "<");
        zSjXd.addChild(LIhFs);
        CommonToken uovUc = new CommonToken(JavadocTokenTypes.CHAR, "/");
        zSjXd.addChild(uovUc);
        CommonToken DZKDL = new CommonToken(JavadocTokenTypes.CHAR, "a");
        zSjXd.addChild(DZKDL);
        CommonToken gYaGe = new CommonToken(JavadocTokenTypes.CHAR, ">");
        zSjXd.addChild(gYaGe);
        nUzga.addChild(zSjXd);
        CommonToken FlbFQ = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        nUzga.addChild(FlbFQ);
        ztrDY.addChild(nUzga);
        FVbYW.addChild(ztrDY);
        CommonToken SwxUk = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        FVbYW.addChild(SwxUk);
        roovx.addChild(FVbYW);
        TextContext oGDof = new TextContext(roovx, 0);
        CommonToken fWqMz = new CommonToken(JavadocTokenTypes.WS, " ");
        oGDof.addChild(fWqMz);
        CommonToken HoYCn = new CommonToken(JavadocTokenTypes.CHAR, "i");
        oGDof.addChild(HoYCn);
        CommonToken dkbfF = new CommonToken(JavadocTokenTypes.CHAR, "n");
        oGDof.addChild(dkbfF);
        CommonToken TBKXz = new CommonToken(JavadocTokenTypes.CHAR, "s");
        oGDof.addChild(TBKXz);
        CommonToken RTDDh = new CommonToken(JavadocTokenTypes.CHAR, "t");
        oGDof.addChild(RTDDh);
        CommonToken IonJK = new CommonToken(JavadocTokenTypes.CHAR, "e");
        oGDof.addChild(IonJK);
        CommonToken JSCTa = new CommonToken(JavadocTokenTypes.CHAR, "a");
        oGDof.addChild(JSCTa);
        CommonToken waeey = new CommonToken(JavadocTokenTypes.CHAR, "d");
        oGDof.addChild(waeey);
        roovx.addChild(oGDof);
        HBaud.addChild(roovx);
        ckejg.addChild(HBaud);
        CommonToken mDnxb = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        ckejg.addChild(mDnxb);
        return ckejg;
    }
    public static ParseTree treeLeadingAsterisks() {
        JavadocContext ESHfJ = new JavadocContext(null, 0);
        CommonToken avwXT = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        ESHfJ.addChild(avwXT);
        CommonToken RlzJr = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, "  *");
        ESHfJ.addChild(RlzJr);
        TextContext mDTfc = new TextContext(ESHfJ, 0);
        CommonToken TCVnz = new CommonToken(JavadocTokenTypes.WS, " ");
        mDTfc.addChild(TCVnz);
        CommonToken Eecil = new CommonToken(JavadocTokenTypes.CHAR, "L");
        mDTfc.addChild(Eecil);
        CommonToken jiYGz = new CommonToken(JavadocTokenTypes.CHAR, "e");
        mDTfc.addChild(jiYGz);
        CommonToken dJXCd = new CommonToken(JavadocTokenTypes.CHAR, "a");
        mDTfc.addChild(dJXCd);
        CommonToken hcsGh = new CommonToken(JavadocTokenTypes.CHAR, "d");
        mDTfc.addChild(hcsGh);
        CommonToken HDIpw = new CommonToken(JavadocTokenTypes.CHAR, "i");
        mDTfc.addChild(HDIpw);
        CommonToken rIybq = new CommonToken(JavadocTokenTypes.CHAR, "n");
        mDTfc.addChild(rIybq);
        CommonToken vxdRh = new CommonToken(JavadocTokenTypes.CHAR, "g");
        mDTfc.addChild(vxdRh);
        CommonToken WMJXY = new CommonToken(JavadocTokenTypes.WS, " ");
        mDTfc.addChild(WMJXY);
        CommonToken zqREY = new CommonToken(JavadocTokenTypes.CHAR, "a");
        mDTfc.addChild(zqREY);
        CommonToken PdPMn = new CommonToken(JavadocTokenTypes.CHAR, "s");
        mDTfc.addChild(PdPMn);
        CommonToken nHhZd = new CommonToken(JavadocTokenTypes.CHAR, "t");
        mDTfc.addChild(nHhZd);
        CommonToken YACET = new CommonToken(JavadocTokenTypes.CHAR, "e");
        mDTfc.addChild(YACET);
        CommonToken GPryT = new CommonToken(JavadocTokenTypes.CHAR, "r");
        mDTfc.addChild(GPryT);
        CommonToken RMGmz = new CommonToken(JavadocTokenTypes.CHAR, "i");
        mDTfc.addChild(RMGmz);
        CommonToken pktyX = new CommonToken(JavadocTokenTypes.CHAR, "s");
        mDTfc.addChild(pktyX);
        CommonToken ihpJN = new CommonToken(JavadocTokenTypes.CHAR, "k");
        mDTfc.addChild(ihpJN);
        ESHfJ.addChild(mDTfc);
        CommonToken nuxOz = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        ESHfJ.addChild(nuxOz);
        CommonToken jqMyc = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, "    *");
        ESHfJ.addChild(jqMyc);
        TextContext wkaXz = new TextContext(ESHfJ, 0);
        CommonToken qwSBF = new CommonToken(JavadocTokenTypes.WS, " ");
        wkaXz.addChild(qwSBF);
        CommonToken Nkbgp = new CommonToken(JavadocTokenTypes.CHAR, "A");
        wkaXz.addChild(Nkbgp);
        CommonToken rDueW = new CommonToken(JavadocTokenTypes.CHAR, "n");
        wkaXz.addChild(rDueW);
        CommonToken tojhr = new CommonToken(JavadocTokenTypes.CHAR, "o");
        wkaXz.addChild(tojhr);
        CommonToken kuktV = new CommonToken(JavadocTokenTypes.CHAR, "t");
        wkaXz.addChild(kuktV);
        CommonToken SvKGl = new CommonToken(JavadocTokenTypes.CHAR, "h");
        wkaXz.addChild(SvKGl);
        CommonToken CRGcP = new CommonToken(JavadocTokenTypes.CHAR, "e");
        wkaXz.addChild(CRGcP);
        CommonToken laMGd = new CommonToken(JavadocTokenTypes.CHAR, "r");
        wkaXz.addChild(laMGd);
        CommonToken QIVBU = new CommonToken(JavadocTokenTypes.WS, " ");
        wkaXz.addChild(QIVBU);
        CommonToken inUyg = new CommonToken(JavadocTokenTypes.CHAR, "o");
        wkaXz.addChild(inUyg);
        CommonToken MrCDK = new CommonToken(JavadocTokenTypes.CHAR, "n");
        wkaXz.addChild(MrCDK);
        CommonToken ibqGj = new CommonToken(JavadocTokenTypes.CHAR, "e");
        wkaXz.addChild(ibqGj);
        ESHfJ.addChild(wkaXz);
        CommonToken CvXeG = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        ESHfJ.addChild(CvXeG);
        return ESHfJ;
    }
    public static ParseTree treeAuthorWithMailto() {
        JavadocContext TGTbm = new JavadocContext(null, 0);
        JavadocTagContext dzPuU = new JavadocTagContext(TGTbm, 0);
        CommonToken KeavR = new CommonToken(JavadocTokenTypes.AUTHOR_LITERAL, "@author");
        dzPuU.addChild(KeavR);
        CommonToken czLfR = new CommonToken(JavadocTokenTypes.WS, " ");
        dzPuU.addChild(czLfR);
        DescriptionContext bTGWe = new DescriptionContext(dzPuU, 0);
        HtmlElementContext aoBuh = new HtmlElementContext(bTGWe, 0);
        HtmlTagContext vFKpv = new HtmlTagContext(aoBuh, 0);
        HtmlElementOpenContext HMTTi = new HtmlElementOpenContext(vFKpv, 0);
        CommonToken SSVZC = new CommonToken(JavadocTokenTypes.OPEN, "<");
        HMTTi.addChild(SSVZC);
        CommonToken NnpgO = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "a");
        HMTTi.addChild(NnpgO);
        CommonToken iyonf = new CommonToken(JavadocTokenTypes.WS, " ");
        HMTTi.addChild(iyonf);
        AttributeContext vxDGj = new AttributeContext(HMTTi, 0);
        CommonToken OEFMv = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "href");
        vxDGj.addChild(OEFMv);
        CommonToken HrHJF = new CommonToken(JavadocTokenTypes.EQUALS, "=");
        vxDGj.addChild(HrHJF);
        CommonToken ntbkP = new CommonToken(JavadocTokenTypes.ATTR_VALUE, "\"mailto:barataliba@gmail.com\"");
        vxDGj.addChild(ntbkP);
        HMTTi.addChild(vxDGj);
        CommonToken xPeiD = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        HMTTi.addChild(xPeiD);
        vFKpv.addChild(HMTTi);
        TextContext Auskd = new TextContext(vFKpv, 0);
        CommonToken QZOWF = new CommonToken(JavadocTokenTypes.CHAR, "B");
        Auskd.addChild(QZOWF);
        CommonToken aHoKe = new CommonToken(JavadocTokenTypes.CHAR, "a");
        Auskd.addChild(aHoKe);
        CommonToken KmPGt = new CommonToken(JavadocTokenTypes.CHAR, "r");
        Auskd.addChild(KmPGt);
        CommonToken IkYYT = new CommonToken(JavadocTokenTypes.CHAR, "a");
        Auskd.addChild(IkYYT);
        CommonToken qHAgD = new CommonToken(JavadocTokenTypes.CHAR, "t");
        Auskd.addChild(qHAgD);
        CommonToken hzsoO = new CommonToken(JavadocTokenTypes.CHAR, "a");
        Auskd.addChild(hzsoO);
        CommonToken Ypeux = new CommonToken(JavadocTokenTypes.CHAR, "l");
        Auskd.addChild(Ypeux);
        CommonToken jjUpd = new CommonToken(JavadocTokenTypes.CHAR, "i");
        Auskd.addChild(jjUpd);
        CommonToken KgHqO = new CommonToken(JavadocTokenTypes.WS, " ");
        Auskd.addChild(KgHqO);
        CommonToken fwvwj = new CommonToken(JavadocTokenTypes.CHAR, "I");
        Auskd.addChild(fwvwj);
        CommonToken uPhgY = new CommonToken(JavadocTokenTypes.CHAR, "z");
        Auskd.addChild(uPhgY);
        CommonToken xTCuL = new CommonToken(JavadocTokenTypes.CHAR, "m");
        Auskd.addChild(xTCuL);
        CommonToken BwdLV = new CommonToken(JavadocTokenTypes.CHAR, "a");
        Auskd.addChild(BwdLV);
        CommonToken AdkMH = new CommonToken(JavadocTokenTypes.CHAR, "i");
        Auskd.addChild(AdkMH);
        CommonToken qNtQc = new CommonToken(JavadocTokenTypes.CHAR, "l");
        Auskd.addChild(qNtQc);
        CommonToken PFiZu = new CommonToken(JavadocTokenTypes.CHAR, "o");
        Auskd.addChild(PFiZu);
        CommonToken ZQZPQ = new CommonToken(JavadocTokenTypes.CHAR, "v");
        Auskd.addChild(ZQZPQ);
        vFKpv.addChild(Auskd);
        HtmlElementCloseContext SgyXZ = new HtmlElementCloseContext(vFKpv, 0);
        CommonToken KfwXW = new CommonToken(JavadocTokenTypes.OPEN, "<");
        SgyXZ.addChild(KfwXW);
        CommonToken FjjTR = new CommonToken(JavadocTokenTypes.SLASH, "/");
        SgyXZ.addChild(FjjTR);
        CommonToken RjDMC = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "a");
        SgyXZ.addChild(RjDMC);
        CommonToken bxeIt = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        SgyXZ.addChild(bxeIt);
        vFKpv.addChild(SgyXZ);
        aoBuh.addChild(vFKpv);
        bTGWe.addChild(aoBuh);
        dzPuU.addChild(bTGWe);
        TGTbm.addChild(dzPuU);
        CommonToken OPdHU = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        TGTbm.addChild(OPdHU);
        return TGTbm;
    }
    public static ParseTree treeHtmlTagsInParagraph() {
        JavadocContext GAVYr = new JavadocContext(null, 0);
        CommonToken rEvDw = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        GAVYr.addChild(rEvDw);
        CommonToken HuQwG = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        GAVYr.addChild(HuQwG);
        TextContext kTCYp = new TextContext(GAVYr, 0);
        CommonToken JvENn = new CommonToken(JavadocTokenTypes.WS, " ");
        kTCYp.addChild(JvENn);
        GAVYr.addChild(kTCYp);
        HtmlElementContext lMaBP = new HtmlElementContext(GAVYr, 0);
        ParagraphContext VJfJM = new ParagraphContext(lMaBP, 0);
        PTagOpenContext ETZjr = new PTagOpenContext(VJfJM, 0);
        CommonToken KMkyi = new CommonToken(JavadocTokenTypes.OPEN, "<");
        ETZjr.addChild(KMkyi);
        CommonToken SkNYf = new CommonToken(JavadocTokenTypes.P_HTML_TAG_NAME, "p");
        ETZjr.addChild(SkNYf);
        CommonToken fiGyP = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        ETZjr.addChild(fiGyP);
        VJfJM.addChild(ETZjr);
        CommonToken vANOl = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        VJfJM.addChild(vANOl);
        CommonToken hOBKf = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        VJfJM.addChild(hOBKf);
        TextContext nCSrv = new TextContext(VJfJM, 0);
        CommonToken ypYEx = new CommonToken(JavadocTokenTypes.WS, " ");
        nCSrv.addChild(ypYEx);
        VJfJM.addChild(nCSrv);
        HtmlTagContext mdIKq = new HtmlTagContext(VJfJM, 0);
        HtmlElementOpenContext gAuWp = new HtmlElementOpenContext(mdIKq, 0);
        CommonToken cNfXF = new CommonToken(JavadocTokenTypes.OPEN, "<");
        gAuWp.addChild(cNfXF);
        CommonToken JReVR = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "b");
        gAuWp.addChild(JReVR);
        CommonToken UEroP = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        gAuWp.addChild(UEroP);
        mdIKq.addChild(gAuWp);
        TextContext MHmsA = new TextContext(mdIKq, 0);
        CommonToken hMUIk = new CommonToken(JavadocTokenTypes.CHAR, "D");
        MHmsA.addChild(hMUIk);
        CommonToken KeTWR = new CommonToken(JavadocTokenTypes.CHAR, "e");
        MHmsA.addChild(KeTWR);
        CommonToken rtXnS = new CommonToken(JavadocTokenTypes.CHAR, "s");
        MHmsA.addChild(rtXnS);
        CommonToken JAFgc = new CommonToken(JavadocTokenTypes.CHAR, "c");
        MHmsA.addChild(JAFgc);
        CommonToken PvbLM = new CommonToken(JavadocTokenTypes.CHAR, "r");
        MHmsA.addChild(PvbLM);
        CommonToken wzZFJ = new CommonToken(JavadocTokenTypes.CHAR, "i");
        MHmsA.addChild(wzZFJ);
        CommonToken ecrVB = new CommonToken(JavadocTokenTypes.CHAR, "p");
        MHmsA.addChild(ecrVB);
        CommonToken EoWQC = new CommonToken(JavadocTokenTypes.CHAR, "t");
        MHmsA.addChild(EoWQC);
        CommonToken wBECH = new CommonToken(JavadocTokenTypes.CHAR, "i");
        MHmsA.addChild(wBECH);
        CommonToken yEVLE = new CommonToken(JavadocTokenTypes.CHAR, "o");
        MHmsA.addChild(yEVLE);
        CommonToken IeRpy = new CommonToken(JavadocTokenTypes.CHAR, "n");
        MHmsA.addChild(IeRpy);
        mdIKq.addChild(MHmsA);
        HtmlElementCloseContext lnLwP = new HtmlElementCloseContext(mdIKq, 0);
        CommonToken dsyIx = new CommonToken(JavadocTokenTypes.OPEN, "<");
        lnLwP.addChild(dsyIx);
        CommonToken ByJND = new CommonToken(JavadocTokenTypes.SLASH, "/");
        lnLwP.addChild(ByJND);
        CommonToken pMJUi = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "b");
        lnLwP.addChild(pMJUi);
        CommonToken UzqYH = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        lnLwP.addChild(UzqYH);
        mdIKq.addChild(lnLwP);
        VJfJM.addChild(mdIKq);
        TextContext dilJr = new TextContext(VJfJM, 0);
        CommonToken hruoj = new CommonToken(JavadocTokenTypes.WS, " ");
        dilJr.addChild(hruoj);
        VJfJM.addChild(dilJr);
        HtmlTagContext AAXLm = new HtmlTagContext(VJfJM, 0);
        HtmlElementOpenContext IXdVA = new HtmlElementOpenContext(AAXLm, 0);
        CommonToken AfTBP = new CommonToken(JavadocTokenTypes.OPEN, "<");
        IXdVA.addChild(AfTBP);
        CommonToken aiLsy = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "i");
        IXdVA.addChild(aiLsy);
        CommonToken AYjDn = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        IXdVA.addChild(AYjDn);
        AAXLm.addChild(IXdVA);
        TextContext mLewg = new TextContext(AAXLm, 0);
        CommonToken UYEUR = new CommonToken(JavadocTokenTypes.CHAR, "o");
        mLewg.addChild(UYEUR);
        CommonToken mKGhH = new CommonToken(JavadocTokenTypes.CHAR, "f");
        mLewg.addChild(mKGhH);
        AAXLm.addChild(mLewg);
        HtmlElementCloseContext VBmkt = new HtmlElementCloseContext(AAXLm, 0);
        CommonToken OLLhv = new CommonToken(JavadocTokenTypes.OPEN, "<");
        VBmkt.addChild(OLLhv);
        CommonToken HUGCV = new CommonToken(JavadocTokenTypes.SLASH, "/");
        VBmkt.addChild(HUGCV);
        CommonToken tWOaB = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "i");
        VBmkt.addChild(tWOaB);
        CommonToken RXdLh = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        VBmkt.addChild(RXdLh);
        AAXLm.addChild(VBmkt);
        VJfJM.addChild(AAXLm);
        TextContext WqkTu = new TextContext(VJfJM, 0);
        CommonToken hBQwt = new CommonToken(JavadocTokenTypes.WS, " ");
        WqkTu.addChild(hBQwt);
        CommonToken YAkEY = new CommonToken(JavadocTokenTypes.CHAR, "m");
        WqkTu.addChild(YAkEY);
        CommonToken Jxywu = new CommonToken(JavadocTokenTypes.CHAR, "y");
        WqkTu.addChild(Jxywu);
        CommonToken ZHNCp = new CommonToken(JavadocTokenTypes.WS, " ");
        WqkTu.addChild(ZHNCp);
        CommonToken ebPuR = new CommonToken(JavadocTokenTypes.CHAR, "c");
        WqkTu.addChild(ebPuR);
        CommonToken sjCYh = new CommonToken(JavadocTokenTypes.CHAR, "l");
        WqkTu.addChild(sjCYh);
        CommonToken ndQgs = new CommonToken(JavadocTokenTypes.CHAR, "a");
        WqkTu.addChild(ndQgs);
        CommonToken rNMlu = new CommonToken(JavadocTokenTypes.CHAR, "s");
        WqkTu.addChild(rNMlu);
        CommonToken xagsR = new CommonToken(JavadocTokenTypes.CHAR, "s");
        WqkTu.addChild(xagsR);
        CommonToken Ihivy = new CommonToken(JavadocTokenTypes.CHAR, ".");
        WqkTu.addChild(Ihivy);
        VJfJM.addChild(WqkTu);
        CommonToken WylwX = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        VJfJM.addChild(WylwX);
        CommonToken tpZma = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        VJfJM.addChild(tpZma);
        TextContext NBrTT = new TextContext(VJfJM, 0);
        CommonToken pgfvt = new CommonToken(JavadocTokenTypes.WS, " ");
        NBrTT.addChild(pgfvt);
        VJfJM.addChild(NBrTT);
        PTagCloseContext mrwRr = new PTagCloseContext(VJfJM, 0);
        CommonToken DSGYS = new CommonToken(JavadocTokenTypes.OPEN, "<");
        mrwRr.addChild(DSGYS);
        CommonToken NhROI = new CommonToken(JavadocTokenTypes.SLASH, "/");
        mrwRr.addChild(NhROI);
        CommonToken Epgpc = new CommonToken(JavadocTokenTypes.P_HTML_TAG_NAME, "p");
        mrwRr.addChild(Epgpc);
        CommonToken yTmrB = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        mrwRr.addChild(yTmrB);
        VJfJM.addChild(mrwRr);
        lMaBP.addChild(VJfJM);
        GAVYr.addChild(lMaBP);
        CommonToken ydCCN = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        GAVYr.addChild(ydCCN);
        CommonToken EIVXE = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        GAVYr.addChild(EIVXE);
        TextContext FHTtd = new TextContext(GAVYr, 0);
        CommonToken ROEZF = new CommonToken(JavadocTokenTypes.WS, " ");
        FHTtd.addChild(ROEZF);
        CommonToken CelZP = new CommonToken(JavadocTokenTypes.CHAR, "A");
        FHTtd.addChild(CelZP);
        CommonToken FlqMi = new CommonToken(JavadocTokenTypes.CHAR, "n");
        FHTtd.addChild(FlqMi);
        CommonToken GxqHT = new CommonToken(JavadocTokenTypes.CHAR, "o");
        FHTtd.addChild(GxqHT);
        CommonToken vrZWK = new CommonToken(JavadocTokenTypes.CHAR, "t");
        FHTtd.addChild(vrZWK);
        CommonToken LsrlV = new CommonToken(JavadocTokenTypes.CHAR, "h");
        FHTtd.addChild(LsrlV);
        CommonToken rtcPS = new CommonToken(JavadocTokenTypes.CHAR, "e");
        FHTtd.addChild(rtcPS);
        CommonToken rdVEq = new CommonToken(JavadocTokenTypes.CHAR, "r");
        FHTtd.addChild(rdVEq);
        CommonToken MhFIL = new CommonToken(JavadocTokenTypes.WS, " ");
        FHTtd.addChild(MhFIL);
        CommonToken fwjvl = new CommonToken(JavadocTokenTypes.CHAR, "l");
        FHTtd.addChild(fwjvl);
        CommonToken lhwtC = new CommonToken(JavadocTokenTypes.CHAR, "i");
        FHTtd.addChild(lhwtC);
        CommonToken pmTuO = new CommonToken(JavadocTokenTypes.CHAR, "n");
        FHTtd.addChild(pmTuO);
        CommonToken QfZjq = new CommonToken(JavadocTokenTypes.CHAR, "e");
        FHTtd.addChild(QfZjq);
        CommonToken eKctL = new CommonToken(JavadocTokenTypes.WS, " ");
        FHTtd.addChild(eKctL);
        CommonToken NgmFS = new CommonToken(JavadocTokenTypes.CHAR, "o");
        FHTtd.addChild(NgmFS);
        CommonToken HJTxt = new CommonToken(JavadocTokenTypes.CHAR, "f");
        FHTtd.addChild(HJTxt);
        CommonToken WoTri = new CommonToken(JavadocTokenTypes.WS, " ");
        FHTtd.addChild(WoTri);
        CommonToken TBgVL = new CommonToken(JavadocTokenTypes.CHAR, "t");
        FHTtd.addChild(TBgVL);
        CommonToken tNnPr = new CommonToken(JavadocTokenTypes.CHAR, "e");
        FHTtd.addChild(tNnPr);
        CommonToken veOAh = new CommonToken(JavadocTokenTypes.CHAR, "x");
        FHTtd.addChild(veOAh);
        CommonToken TTqzU = new CommonToken(JavadocTokenTypes.CHAR, "t");
        FHTtd.addChild(TTqzU);
        GAVYr.addChild(FHTtd);
        CommonToken esJKC = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        GAVYr.addChild(esJKC);
        TextContext foSFm = new TextContext(GAVYr, 0);
        CommonToken RkviD = new CommonToken(JavadocTokenTypes.WS, " ");
        foSFm.addChild(RkviD);
        GAVYr.addChild(foSFm);
        CommonToken ZdVEY = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        GAVYr.addChild(ZdVEY);
        return GAVYr;
    }
    public static ParseTree treeLinkInlineTags() {
        JavadocContext qUDSi = new JavadocContext(null, 0);
        JavadocInlineTagContext qrmKv = new JavadocInlineTagContext(qUDSi, 0);
        CommonToken nyjfF = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        qrmKv.addChild(nyjfF);
        CommonToken HXSDY = new CommonToken(JavadocTokenTypes.LINK_LITERAL, "@link");
        qrmKv.addChild(HXSDY);
        CommonToken LbsbA = new CommonToken(JavadocTokenTypes.WS, " ");
        qrmKv.addChild(LbsbA);
        ReferenceContext qNvtx = new ReferenceContext(qrmKv, 0);
        CommonToken cPKhb = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        qNvtx.addChild(cPKhb);
        CommonToken FXimU = new CommonToken(JavadocTokenTypes.DOT, ".");
        qNvtx.addChild(FXimU);
        CommonToken VmBeR = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        qNvtx.addChild(VmBeR);
        CommonToken ZQmZl = new CommonToken(JavadocTokenTypes.HASH, "#");
        qNvtx.addChild(ZQmZl);
        CommonToken LqBEr = new CommonToken(JavadocTokenTypes.MEMBER, "valueOf");
        qNvtx.addChild(LqBEr);
        qrmKv.addChild(qNvtx);
        CommonToken AMFgL = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        qrmKv.addChild(AMFgL);
        qUDSi.addChild(qrmKv);
        CommonToken Soygb = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        qUDSi.addChild(Soygb);
        JavadocInlineTagContext TkOkF = new JavadocInlineTagContext(qUDSi, 0);
        CommonToken PkzAI = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        TkOkF.addChild(PkzAI);
        CommonToken kFrQb = new CommonToken(JavadocTokenTypes.LINK_LITERAL, "@link");
        TkOkF.addChild(kFrQb);
        CommonToken fVQnP = new CommonToken(JavadocTokenTypes.WS, " ");
        TkOkF.addChild(fVQnP);
        ReferenceContext Mwbat = new ReferenceContext(TkOkF, 0);
        CommonToken oHQua = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        Mwbat.addChild(oHQua);
        CommonToken YvNhB = new CommonToken(JavadocTokenTypes.DOT, ".");
        Mwbat.addChild(YvNhB);
        CommonToken dsmbF = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        Mwbat.addChild(dsmbF);
        CommonToken HZVQi = new CommonToken(JavadocTokenTypes.HASH, "#");
        Mwbat.addChild(HZVQi);
        CommonToken FUOOd = new CommonToken(JavadocTokenTypes.MEMBER, "valueOf");
        Mwbat.addChild(FUOOd);
        TkOkF.addChild(Mwbat);
        DescriptionContext WchCg = new DescriptionContext(TkOkF, 0);
        TextContext fcThJ = new TextContext(WchCg, 0);
        CommonToken aDhfF = new CommonToken(JavadocTokenTypes.WS, " ");
        fcThJ.addChild(aDhfF);
        CommonToken vdvFW = new CommonToken(JavadocTokenTypes.CHAR, "v");
        fcThJ.addChild(vdvFW);
        CommonToken IHqck = new CommonToken(JavadocTokenTypes.CHAR, "a");
        fcThJ.addChild(IHqck);
        CommonToken xHjyx = new CommonToken(JavadocTokenTypes.CHAR, "l");
        fcThJ.addChild(xHjyx);
        CommonToken oKzoC = new CommonToken(JavadocTokenTypes.CHAR, "u");
        fcThJ.addChild(oKzoC);
        CommonToken wnkTX = new CommonToken(JavadocTokenTypes.CHAR, "e");
        fcThJ.addChild(wnkTX);
        CommonToken WAjRZ = new CommonToken(JavadocTokenTypes.CHAR, "O");
        fcThJ.addChild(WAjRZ);
        CommonToken mFsnr = new CommonToken(JavadocTokenTypes.CHAR, "f");
        fcThJ.addChild(mFsnr);
        WchCg.addChild(fcThJ);
        TkOkF.addChild(WchCg);
        CommonToken vtWLP = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        TkOkF.addChild(vtWLP);
        qUDSi.addChild(TkOkF);
        CommonToken NyyJM = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        qUDSi.addChild(NyyJM);
        return qUDSi;
    }
    public static ParseTree treeSeeReferenceWithFewNestedClasses() {
        JavadocContext CzKVl = new JavadocContext(null, 0);
        JavadocTagContext gokiA = new JavadocTagContext(CzKVl, 0);
        CommonToken grzaZ = new CommonToken(JavadocTokenTypes.SEE_LITERAL, "@see");
        gokiA.addChild(grzaZ);
        CommonToken DtaeI = new CommonToken(JavadocTokenTypes.WS, " ");
        gokiA.addChild(DtaeI);
        ReferenceContext vLDJC = new ReferenceContext(gokiA, 0);
        CommonToken BkKRp = new CommonToken(JavadocTokenTypes.PACKAGE, "java.lang");
        vLDJC.addChild(BkKRp);
        CommonToken yvOze = new CommonToken(JavadocTokenTypes.DOT, ".");
        vLDJC.addChild(yvOze);
        CommonToken ohJtl = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        vLDJC.addChild(ohJtl);
        CommonToken hNAVA = new CommonToken(JavadocTokenTypes.DOT, ".");
        vLDJC.addChild(hNAVA);
        CommonToken jdqIJ = new CommonToken(JavadocTokenTypes.CLASS, "Nested");
        vLDJC.addChild(jdqIJ);
        CommonToken vaNBW = new CommonToken(JavadocTokenTypes.DOT, ".");
        vLDJC.addChild(vaNBW);
        CommonToken PDCAI = new CommonToken(JavadocTokenTypes.CLASS, "AnotherNested");
        vLDJC.addChild(PDCAI);
        CommonToken CagoX = new CommonToken(JavadocTokenTypes.HASH, "#");
        vLDJC.addChild(CagoX);
        CommonToken WuYrh = new CommonToken(JavadocTokenTypes.MEMBER, "someMethod");
        vLDJC.addChild(WuYrh);
        ParametersContext udWrc = new ParametersContext(vLDJC, 0);
        CommonToken PJtRP = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        udWrc.addChild(PJtRP);
        CommonToken JwhMR = new CommonToken(JavadocTokenTypes.ARGUMENT, "String");
        udWrc.addChild(JwhMR);
        CommonToken DaAVO = new CommonToken(JavadocTokenTypes.COMMA, ",");
        udWrc.addChild(DaAVO);
        CommonToken QvLje = new CommonToken(JavadocTokenTypes.WS, " ");
        udWrc.addChild(QvLje);
        CommonToken BZorC = new CommonToken(JavadocTokenTypes.ARGUMENT, "int");
        udWrc.addChild(BZorC);
        CommonToken exiFE = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        udWrc.addChild(exiFE);
        vLDJC.addChild(udWrc);
        gokiA.addChild(vLDJC);
        CommonToken ximEY = new CommonToken(JavadocTokenTypes.WS, " ");
        gokiA.addChild(ximEY);
        DescriptionContext SXOzr = new DescriptionContext(gokiA, 0);
        TextContext BfJtl = new TextContext(SXOzr, 0);
        CommonToken wmLGH = new CommonToken(JavadocTokenTypes.CHAR, "D");
        BfJtl.addChild(wmLGH);
        CommonToken LINKE = new CommonToken(JavadocTokenTypes.CHAR, "e");
        BfJtl.addChild(LINKE);
        CommonToken DdOuv = new CommonToken(JavadocTokenTypes.CHAR, "s");
        BfJtl.addChild(DdOuv);
        CommonToken JDbnR = new CommonToken(JavadocTokenTypes.CHAR, "c");
        BfJtl.addChild(JDbnR);
        CommonToken FVehl = new CommonToken(JavadocTokenTypes.CHAR, "r");
        BfJtl.addChild(FVehl);
        CommonToken GxRCH = new CommonToken(JavadocTokenTypes.CHAR, "i");
        BfJtl.addChild(GxRCH);
        CommonToken XtRVj = new CommonToken(JavadocTokenTypes.CHAR, "p");
        BfJtl.addChild(XtRVj);
        CommonToken BCuFj = new CommonToken(JavadocTokenTypes.CHAR, "t");
        BfJtl.addChild(BCuFj);
        CommonToken oWHAD = new CommonToken(JavadocTokenTypes.CHAR, "i");
        BfJtl.addChild(oWHAD);
        CommonToken OnPFw = new CommonToken(JavadocTokenTypes.CHAR, "o");
        BfJtl.addChild(OnPFw);
        CommonToken MQjqh = new CommonToken(JavadocTokenTypes.CHAR, "n");
        BfJtl.addChild(MQjqh);
        CommonToken HzkOh = new CommonToken(JavadocTokenTypes.WS, " ");
        BfJtl.addChild(HzkOh);
        CommonToken ftfOv = new CommonToken(JavadocTokenTypes.CHAR, "o");
        BfJtl.addChild(ftfOv);
        CommonToken ieURc = new CommonToken(JavadocTokenTypes.CHAR, "f");
        BfJtl.addChild(ieURc);
        CommonToken CXbGx = new CommonToken(JavadocTokenTypes.WS, " ");
        BfJtl.addChild(CXbGx);
        CommonToken lYpCr = new CommonToken(JavadocTokenTypes.CHAR, "t");
        BfJtl.addChild(lYpCr);
        CommonToken gWUOV = new CommonToken(JavadocTokenTypes.CHAR, "h");
        BfJtl.addChild(gWUOV);
        CommonToken eXjmT = new CommonToken(JavadocTokenTypes.CHAR, "e");
        BfJtl.addChild(eXjmT);
        CommonToken ZQQin = new CommonToken(JavadocTokenTypes.WS, " ");
        BfJtl.addChild(ZQQin);
        CommonToken uGKkF = new CommonToken(JavadocTokenTypes.CHAR, "l");
        BfJtl.addChild(uGKkF);
        CommonToken gJoli = new CommonToken(JavadocTokenTypes.CHAR, "i");
        BfJtl.addChild(gJoli);
        CommonToken JGDoa = new CommonToken(JavadocTokenTypes.CHAR, "n");
        BfJtl.addChild(JGDoa);
        CommonToken qLyDc = new CommonToken(JavadocTokenTypes.CHAR, "k");
        BfJtl.addChild(qLyDc);
        SXOzr.addChild(BfJtl);
        gokiA.addChild(SXOzr);
        CzKVl.addChild(gokiA);
        CommonToken gjaAk = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        CzKVl.addChild(gjaAk);
        return CzKVl;
    }
    public static ParseTree treeParamWithGeneric() {
        JavadocContext QPFRD = new JavadocContext(null, 0);
        JavadocTagContext aGEJG = new JavadocTagContext(QPFRD, 0);
        CommonToken KeLjt = new CommonToken(JavadocTokenTypes.PARAM_LITERAL, "@param");
        aGEJG.addChild(KeLjt);
        CommonToken rOSWG = new CommonToken(JavadocTokenTypes.WS, " ");
        aGEJG.addChild(rOSWG);
        CommonToken lsjiD = new CommonToken(JavadocTokenTypes.PARAMETER_NAME, "<E>");
        aGEJG.addChild(lsjiD);
        CommonToken NffOe = new CommonToken(JavadocTokenTypes.WS, " ");
        aGEJG.addChild(NffOe);
        DescriptionContext xpcWl = new DescriptionContext(aGEJG, 0);
        TextContext YlCSA = new TextContext(xpcWl, 0);
        CommonToken DrEbu = new CommonToken(JavadocTokenTypes.CHAR, "m");
        YlCSA.addChild(DrEbu);
        CommonToken KZAJu = new CommonToken(JavadocTokenTypes.CHAR, "y");
        YlCSA.addChild(KZAJu);
        CommonToken dwXkJ = new CommonToken(JavadocTokenTypes.WS, " ");
        YlCSA.addChild(dwXkJ);
        CommonToken bckfp = new CommonToken(JavadocTokenTypes.CHAR, "f");
        YlCSA.addChild(bckfp);
        CommonToken kiXWZ = new CommonToken(JavadocTokenTypes.CHAR, "a");
        YlCSA.addChild(kiXWZ);
        CommonToken PfsCl = new CommonToken(JavadocTokenTypes.CHAR, "v");
        YlCSA.addChild(PfsCl);
        CommonToken svxAz = new CommonToken(JavadocTokenTypes.CHAR, "o");
        YlCSA.addChild(svxAz);
        CommonToken kusoJ = new CommonToken(JavadocTokenTypes.CHAR, "r");
        YlCSA.addChild(kusoJ);
        CommonToken XhYWE = new CommonToken(JavadocTokenTypes.CHAR, "i");
        YlCSA.addChild(XhYWE);
        CommonToken KLVPT = new CommonToken(JavadocTokenTypes.CHAR, "t");
        YlCSA.addChild(KLVPT);
        CommonToken yDyzh = new CommonToken(JavadocTokenTypes.CHAR, "e");
        YlCSA.addChild(yDyzh);
        CommonToken Jcrop = new CommonToken(JavadocTokenTypes.WS, " ");
        YlCSA.addChild(Jcrop);
        CommonToken NwSnD = new CommonToken(JavadocTokenTypes.CHAR, "t");
        YlCSA.addChild(NwSnD);
        CommonToken WocUM = new CommonToken(JavadocTokenTypes.CHAR, "y");
        YlCSA.addChild(WocUM);
        CommonToken pIlOU = new CommonToken(JavadocTokenTypes.CHAR, "p");
        YlCSA.addChild(pIlOU);
        CommonToken DzOSR = new CommonToken(JavadocTokenTypes.CHAR, "e");
        YlCSA.addChild(DzOSR);
        xpcWl.addChild(YlCSA);
        aGEJG.addChild(xpcWl);
        QPFRD.addChild(aGEJG);
        CommonToken TBVcX = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        QPFRD.addChild(TBVcX);
        return QPFRD;
    }
    public static ParseTree treeSerial() {
        JavadocContext LvQLs = new JavadocContext(null, 0);
        JavadocTagContext zgAMl = new JavadocTagContext(LvQLs, 0);
        CommonToken dbPvj = new CommonToken(JavadocTokenTypes.SERIAL_LITERAL, "@serial");
        zgAMl.addChild(dbPvj);
        CommonToken DRIij = new CommonToken(JavadocTokenTypes.WS, " ");
        zgAMl.addChild(DRIij);
        DescriptionContext uXKxL = new DescriptionContext(zgAMl, 0);
        TextContext qPraT = new TextContext(uXKxL, 0);
        CommonToken ZLilS = new CommonToken(JavadocTokenTypes.CHAR, "f");
        qPraT.addChild(ZLilS);
        CommonToken OZlGT = new CommonToken(JavadocTokenTypes.CHAR, "i");
        qPraT.addChild(OZlGT);
        CommonToken LWDAH = new CommonToken(JavadocTokenTypes.CHAR, "e");
        qPraT.addChild(LWDAH);
        CommonToken nDCGv = new CommonToken(JavadocTokenTypes.CHAR, "l");
        qPraT.addChild(nDCGv);
        CommonToken hfOJi = new CommonToken(JavadocTokenTypes.CHAR, "d");
        qPraT.addChild(hfOJi);
        CommonToken utdDS = new CommonToken(JavadocTokenTypes.WS, " ");
        qPraT.addChild(utdDS);
        CommonToken MVYkh = new CommonToken(JavadocTokenTypes.CHAR, "d");
        qPraT.addChild(MVYkh);
        CommonToken vMwZL = new CommonToken(JavadocTokenTypes.CHAR, "e");
        qPraT.addChild(vMwZL);
        CommonToken SRiIb = new CommonToken(JavadocTokenTypes.CHAR, "s");
        qPraT.addChild(SRiIb);
        CommonToken yuoQZ = new CommonToken(JavadocTokenTypes.CHAR, "c");
        qPraT.addChild(yuoQZ);
        CommonToken Zudaz = new CommonToken(JavadocTokenTypes.CHAR, "r");
        qPraT.addChild(Zudaz);
        CommonToken STXeh = new CommonToken(JavadocTokenTypes.CHAR, "i");
        qPraT.addChild(STXeh);
        CommonToken gmYRM = new CommonToken(JavadocTokenTypes.CHAR, "p");
        qPraT.addChild(gmYRM);
        CommonToken xWdnG = new CommonToken(JavadocTokenTypes.CHAR, "t");
        qPraT.addChild(xWdnG);
        CommonToken hsYvL = new CommonToken(JavadocTokenTypes.CHAR, "i");
        qPraT.addChild(hsYvL);
        CommonToken sIfpi = new CommonToken(JavadocTokenTypes.CHAR, "o");
        qPraT.addChild(sIfpi);
        CommonToken WktVb = new CommonToken(JavadocTokenTypes.CHAR, "n");
        qPraT.addChild(WktVb);
        uXKxL.addChild(qPraT);
        CommonToken Uyspp = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        uXKxL.addChild(Uyspp);
        TextContext yifGB = new TextContext(uXKxL, 0);
        CommonToken ULTcH = new CommonToken(JavadocTokenTypes.CHAR, "o");
        yifGB.addChild(ULTcH);
        CommonToken ZLgyj = new CommonToken(JavadocTokenTypes.CHAR, "n");
        yifGB.addChild(ZLgyj);
        CommonToken IoEIX = new CommonToken(JavadocTokenTypes.WS, " ");
        yifGB.addChild(IoEIX);
        CommonToken jVYKa = new CommonToken(JavadocTokenTypes.CHAR, "f");
        yifGB.addChild(jVYKa);
        CommonToken dDbNJ = new CommonToken(JavadocTokenTypes.CHAR, "e");
        yifGB.addChild(dDbNJ);
        CommonToken HyjuJ = new CommonToken(JavadocTokenTypes.CHAR, "w");
        yifGB.addChild(HyjuJ);
        CommonToken dndXf = new CommonToken(JavadocTokenTypes.WS, " ");
        yifGB.addChild(dndXf);
        CommonToken PRLDO = new CommonToken(JavadocTokenTypes.CHAR, "l");
        yifGB.addChild(PRLDO);
        CommonToken OfyTR = new CommonToken(JavadocTokenTypes.CHAR, "i");
        yifGB.addChild(OfyTR);
        CommonToken aCnSH = new CommonToken(JavadocTokenTypes.CHAR, "n");
        yifGB.addChild(aCnSH);
        CommonToken WQbTi = new CommonToken(JavadocTokenTypes.CHAR, "e");
        yifGB.addChild(WQbTi);
        CommonToken ggkUg = new CommonToken(JavadocTokenTypes.CHAR, "s");
        yifGB.addChild(ggkUg);
        uXKxL.addChild(yifGB);
        CommonToken HcLGZ = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        uXKxL.addChild(HcLGZ);
        TextContext wCPDd = new TextContext(uXKxL, 0);
        CommonToken jlmsv = new CommonToken(JavadocTokenTypes.CHAR, "a");
        wCPDd.addChild(jlmsv);
        CommonToken VkHlF = new CommonToken(JavadocTokenTypes.CHAR, "n");
        wCPDd.addChild(VkHlF);
        CommonToken ZEixZ = new CommonToken(JavadocTokenTypes.CHAR, "d");
        wCPDd.addChild(ZEixZ);
        CommonToken htlfA = new CommonToken(JavadocTokenTypes.WS, " ");
        wCPDd.addChild(htlfA);
        CommonToken zEwmF = new CommonToken(JavadocTokenTypes.CHAR, "e");
        wCPDd.addChild(zEwmF);
        CommonToken xBxPL = new CommonToken(JavadocTokenTypes.CHAR, "v");
        wCPDd.addChild(xBxPL);
        CommonToken NBmII = new CommonToken(JavadocTokenTypes.CHAR, "e");
        wCPDd.addChild(NBmII);
        CommonToken PDgHr = new CommonToken(JavadocTokenTypes.CHAR, "n");
        wCPDd.addChild(PDgHr);
        CommonToken DCHka = new CommonToken(JavadocTokenTypes.WS, " ");
        wCPDd.addChild(DCHka);
        CommonToken OZRlA = new CommonToken(JavadocTokenTypes.CHAR, "h");
        wCPDd.addChild(OZRlA);
        CommonToken rnSjj = new CommonToken(JavadocTokenTypes.CHAR, "e");
        wCPDd.addChild(rnSjj);
        CommonToken ujRwV = new CommonToken(JavadocTokenTypes.CHAR, "r");
        wCPDd.addChild(ujRwV);
        CommonToken JidCa = new CommonToken(JavadocTokenTypes.CHAR, "e");
        wCPDd.addChild(JidCa);
        uXKxL.addChild(wCPDd);
        CommonToken HGXSo = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        uXKxL.addChild(HGXSo);
        zgAMl.addChild(uXKxL);
        LvQLs.addChild(zgAMl);
        JavadocTagContext UEpeG = new JavadocTagContext(LvQLs, 0);
        CommonToken jRjUd = new CommonToken(JavadocTokenTypes.SERIAL_LITERAL, "@serial");
        UEpeG.addChild(jRjUd);
        CommonToken MauPY = new CommonToken(JavadocTokenTypes.WS, " ");
        UEpeG.addChild(MauPY);
        CommonToken MCtfs = new CommonToken(JavadocTokenTypes.LITERAL_INCLUDE, "include");
        UEpeG.addChild(MCtfs);
        DescriptionContext Xesvo = new DescriptionContext(UEpeG, 0);
        CommonToken SAcJI = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        Xesvo.addChild(SAcJI);
        UEpeG.addChild(Xesvo);
        LvQLs.addChild(UEpeG);
        JavadocTagContext byhHa = new JavadocTagContext(LvQLs, 0);
        CommonToken hRTgV = new CommonToken(JavadocTokenTypes.SERIAL_LITERAL, "@serial");
        byhHa.addChild(hRTgV);
        CommonToken lsZTf = new CommonToken(JavadocTokenTypes.WS, " ");
        byhHa.addChild(lsZTf);
        CommonToken xmTtW = new CommonToken(JavadocTokenTypes.LITERAL_EXCLUDE, "exclude");
        byhHa.addChild(xmTtW);
        DescriptionContext LozZq = new DescriptionContext(byhHa, 0);
        CommonToken LsuSn = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        LozZq.addChild(LsuSn);
        byhHa.addChild(LozZq);
        LvQLs.addChild(byhHa);
        JavadocTagContext WkhrE = new JavadocTagContext(LvQLs, 0);
        CommonToken mPZzA = new CommonToken(JavadocTokenTypes.SERIAL_FIELD_LITERAL, "@serialField");
        WkhrE.addChild(mPZzA);
        CommonToken uvrEg = new CommonToken(JavadocTokenTypes.WS, " ");
        WkhrE.addChild(uvrEg);
        CommonToken aIkVx = new CommonToken(JavadocTokenTypes.FIELD_NAME, "myField");
        WkhrE.addChild(aIkVx);
        CommonToken TuyMj = new CommonToken(JavadocTokenTypes.WS, " ");
        WkhrE.addChild(TuyMj);
        CommonToken EgsBp = new CommonToken(JavadocTokenTypes.FIELD_TYPE, "myObjectStreamField");
        WkhrE.addChild(EgsBp);
        CommonToken NMYXM = new CommonToken(JavadocTokenTypes.WS, " ");
        WkhrE.addChild(NMYXM);
        DescriptionContext hhzpC = new DescriptionContext(WkhrE, 0);
        TextContext zGdBL = new TextContext(hhzpC, 0);
        CommonToken Gwjnn = new CommonToken(JavadocTokenTypes.CHAR, "d");
        zGdBL.addChild(Gwjnn);
        CommonToken FdTsQ = new CommonToken(JavadocTokenTypes.CHAR, "e");
        zGdBL.addChild(FdTsQ);
        CommonToken buZAu = new CommonToken(JavadocTokenTypes.CHAR, "s");
        zGdBL.addChild(buZAu);
        CommonToken vKnrL = new CommonToken(JavadocTokenTypes.CHAR, "c");
        zGdBL.addChild(vKnrL);
        CommonToken iTgMV = new CommonToken(JavadocTokenTypes.CHAR, "r");
        zGdBL.addChild(iTgMV);
        CommonToken OetXa = new CommonToken(JavadocTokenTypes.CHAR, "i");
        zGdBL.addChild(OetXa);
        CommonToken bBVjn = new CommonToken(JavadocTokenTypes.CHAR, "p");
        zGdBL.addChild(bBVjn);
        CommonToken lEPyw = new CommonToken(JavadocTokenTypes.CHAR, "t");
        zGdBL.addChild(lEPyw);
        CommonToken cxPZo = new CommonToken(JavadocTokenTypes.CHAR, "i");
        zGdBL.addChild(cxPZo);
        CommonToken mUgvS = new CommonToken(JavadocTokenTypes.CHAR, "o");
        zGdBL.addChild(mUgvS);
        CommonToken tZuSm = new CommonToken(JavadocTokenTypes.CHAR, "n");
        zGdBL.addChild(tZuSm);
        CommonToken CZjXB = new CommonToken(JavadocTokenTypes.WS, " ");
        zGdBL.addChild(CZjXB);
        CommonToken iatjx = new CommonToken(JavadocTokenTypes.CHAR, "o");
        zGdBL.addChild(iatjx);
        CommonToken qFzoz = new CommonToken(JavadocTokenTypes.CHAR, "f");
        zGdBL.addChild(qFzoz);
        CommonToken SSyvy = new CommonToken(JavadocTokenTypes.WS, " ");
        zGdBL.addChild(SSyvy);
        CommonToken SCJTX = new CommonToken(JavadocTokenTypes.CHAR, "m");
        zGdBL.addChild(SCJTX);
        CommonToken vnNEr = new CommonToken(JavadocTokenTypes.CHAR, "y");
        zGdBL.addChild(vnNEr);
        CommonToken gRAfW = new CommonToken(JavadocTokenTypes.WS, " ");
        zGdBL.addChild(gRAfW);
        CommonToken BtaKP = new CommonToken(JavadocTokenTypes.CHAR, "s");
        zGdBL.addChild(BtaKP);
        CommonToken ICcPu = new CommonToken(JavadocTokenTypes.CHAR, "e");
        zGdBL.addChild(ICcPu);
        CommonToken EkuDz = new CommonToken(JavadocTokenTypes.CHAR, "r");
        zGdBL.addChild(EkuDz);
        CommonToken EbkiO = new CommonToken(JavadocTokenTypes.CHAR, "i");
        zGdBL.addChild(EbkiO);
        CommonToken xXCgE = new CommonToken(JavadocTokenTypes.CHAR, "a");
        zGdBL.addChild(xXCgE);
        CommonToken MyRqM = new CommonToken(JavadocTokenTypes.CHAR, "l");
        zGdBL.addChild(MyRqM);
        CommonToken EVAnU = new CommonToken(JavadocTokenTypes.WS, " ");
        zGdBL.addChild(EVAnU);
        CommonToken mirjt = new CommonToken(JavadocTokenTypes.CHAR, "f");
        zGdBL.addChild(mirjt);
        CommonToken qrXUD = new CommonToken(JavadocTokenTypes.CHAR, "i");
        zGdBL.addChild(qrXUD);
        CommonToken NfURD = new CommonToken(JavadocTokenTypes.CHAR, "e");
        zGdBL.addChild(NfURD);
        CommonToken MqiBb = new CommonToken(JavadocTokenTypes.CHAR, "l");
        zGdBL.addChild(MqiBb);
        CommonToken DJVTC = new CommonToken(JavadocTokenTypes.CHAR, "d");
        zGdBL.addChild(DJVTC);
        hhzpC.addChild(zGdBL);
        CommonToken LAQNT = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        hhzpC.addChild(LAQNT);
        WkhrE.addChild(hhzpC);
        LvQLs.addChild(WkhrE);
        JavadocTagContext xRNrk = new JavadocTagContext(LvQLs, 0);
        CommonToken SJUoL = new CommonToken(JavadocTokenTypes.SERIAL_DATA_LITERAL, "@serialData");
        xRNrk.addChild(SJUoL);
        CommonToken DlWOc = new CommonToken(JavadocTokenTypes.WS, " ");
        xRNrk.addChild(DlWOc);
        DescriptionContext jqmSx = new DescriptionContext(xRNrk, 0);
        TextContext PpvsC = new TextContext(jqmSx, 0);
        CommonToken HeGrl = new CommonToken(JavadocTokenTypes.CHAR, "T");
        PpvsC.addChild(HeGrl);
        CommonToken SYOSO = new CommonToken(JavadocTokenTypes.CHAR, "h");
        PpvsC.addChild(SYOSO);
        CommonToken JyLUh = new CommonToken(JavadocTokenTypes.CHAR, "e");
        PpvsC.addChild(JyLUh);
        CommonToken aCiib = new CommonToken(JavadocTokenTypes.WS, " ");
        PpvsC.addChild(aCiib);
        CommonToken zgZVm = new CommonToken(JavadocTokenTypes.CHAR, "d");
        PpvsC.addChild(zgZVm);
        CommonToken WcmSt = new CommonToken(JavadocTokenTypes.CHAR, "a");
        PpvsC.addChild(WcmSt);
        CommonToken DpAmW = new CommonToken(JavadocTokenTypes.CHAR, "t");
        PpvsC.addChild(DpAmW);
        CommonToken ILDhQ = new CommonToken(JavadocTokenTypes.CHAR, "a");
        PpvsC.addChild(ILDhQ);
        CommonToken VBhyT = new CommonToken(JavadocTokenTypes.CHAR, "-");
        PpvsC.addChild(VBhyT);
        CommonToken bwwxO = new CommonToken(JavadocTokenTypes.CHAR, "d");
        PpvsC.addChild(bwwxO);
        CommonToken CUCYe = new CommonToken(JavadocTokenTypes.CHAR, "e");
        PpvsC.addChild(CUCYe);
        CommonToken eLJfo = new CommonToken(JavadocTokenTypes.CHAR, "s");
        PpvsC.addChild(eLJfo);
        CommonToken LupgP = new CommonToken(JavadocTokenTypes.CHAR, "c");
        PpvsC.addChild(LupgP);
        CommonToken sdfFv = new CommonToken(JavadocTokenTypes.CHAR, "r");
        PpvsC.addChild(sdfFv);
        CommonToken HkxXq = new CommonToken(JavadocTokenTypes.CHAR, "i");
        PpvsC.addChild(HkxXq);
        CommonToken jqFoE = new CommonToken(JavadocTokenTypes.CHAR, "p");
        PpvsC.addChild(jqFoE);
        CommonToken jTwSJ = new CommonToken(JavadocTokenTypes.CHAR, "t");
        PpvsC.addChild(jTwSJ);
        CommonToken gfbAe = new CommonToken(JavadocTokenTypes.CHAR, "i");
        PpvsC.addChild(gfbAe);
        CommonToken pSoPO = new CommonToken(JavadocTokenTypes.CHAR, "o");
        PpvsC.addChild(pSoPO);
        CommonToken HYvXz = new CommonToken(JavadocTokenTypes.CHAR, "n");
        PpvsC.addChild(HYvXz);
        CommonToken OpEdq = new CommonToken(JavadocTokenTypes.WS, " ");
        PpvsC.addChild(OpEdq);
        CommonToken EpyRF = new CommonToken(JavadocTokenTypes.CHAR, "d");
        PpvsC.addChild(EpyRF);
        CommonToken KHnHf = new CommonToken(JavadocTokenTypes.CHAR, "o");
        PpvsC.addChild(KHnHf);
        CommonToken zRtDf = new CommonToken(JavadocTokenTypes.CHAR, "c");
        PpvsC.addChild(zRtDf);
        CommonToken mHGvX = new CommonToken(JavadocTokenTypes.CHAR, "u");
        PpvsC.addChild(mHGvX);
        CommonToken NjhfY = new CommonToken(JavadocTokenTypes.CHAR, "m");
        PpvsC.addChild(NjhfY);
        CommonToken sJsAg = new CommonToken(JavadocTokenTypes.CHAR, "e");
        PpvsC.addChild(sJsAg);
        CommonToken jCkuJ = new CommonToken(JavadocTokenTypes.CHAR, "n");
        PpvsC.addChild(jCkuJ);
        CommonToken jboPH = new CommonToken(JavadocTokenTypes.CHAR, "t");
        PpvsC.addChild(jboPH);
        CommonToken qxKeT = new CommonToken(JavadocTokenTypes.CHAR, "s");
        PpvsC.addChild(qxKeT);
        jqmSx.addChild(PpvsC);
        xRNrk.addChild(jqmSx);
        LvQLs.addChild(xRNrk);
        CommonToken lJyJx = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        LvQLs.addChild(lJyJx);
        return LvQLs;
    }
    public static ParseTree treeSince() {
        JavadocContext KzwtL = new JavadocContext(null, 0);
        CommonToken KBdjc = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, "*");
        KzwtL.addChild(KBdjc);
        CommonToken bumXm = new CommonToken(JavadocTokenTypes.WS, " ");
        KzwtL.addChild(bumXm);
        JavadocTagContext yxgFX = new JavadocTagContext(KzwtL, 0);
        CommonToken YHnJx = new CommonToken(JavadocTokenTypes.SINCE_LITERAL, "@since");
        yxgFX.addChild(YHnJx);
        CommonToken VnMhH = new CommonToken(JavadocTokenTypes.WS, " ");
        yxgFX.addChild(VnMhH);
        DescriptionContext hfUJs = new DescriptionContext(yxgFX, 0);
        TextContext KDFKH = new TextContext(hfUJs, 0);
        CommonToken HzQdJ = new CommonToken(JavadocTokenTypes.CHAR, "1");
        KDFKH.addChild(HzQdJ);
        CommonToken dQvjG = new CommonToken(JavadocTokenTypes.CHAR, ".");
        KDFKH.addChild(dQvjG);
        CommonToken xEdyg = new CommonToken(JavadocTokenTypes.CHAR, "5");
        KDFKH.addChild(xEdyg);
        hfUJs.addChild(KDFKH);
        CommonToken IXuHo = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        hfUJs.addChild(IXuHo);
        yxgFX.addChild(hfUJs);
        KzwtL.addChild(yxgFX);
        CommonToken PkBux = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        KzwtL.addChild(PkBux);
        CommonToken KpMIW = new CommonToken(JavadocTokenTypes.WS, " ");
        KzwtL.addChild(KpMIW);
        JavadocTagContext OcuEn = new JavadocTagContext(KzwtL, 0);
        CommonToken SehKa = new CommonToken(JavadocTokenTypes.SINCE_LITERAL, "@since");
        OcuEn.addChild(SehKa);
        CommonToken JURQC = new CommonToken(JavadocTokenTypes.WS, " ");
        OcuEn.addChild(JURQC);
        DescriptionContext NYzVK = new DescriptionContext(OcuEn, 0);
        TextContext KYmTj = new TextContext(NYzVK, 0);
        CommonToken XeINZ = new CommonToken(JavadocTokenTypes.CHAR, "R");
        KYmTj.addChild(XeINZ);
        CommonToken yaphV = new CommonToken(JavadocTokenTypes.CHAR, "e");
        KYmTj.addChild(yaphV);
        CommonToken fWGhu = new CommonToken(JavadocTokenTypes.CHAR, "l");
        KYmTj.addChild(fWGhu);
        CommonToken kWDEz = new CommonToken(JavadocTokenTypes.CHAR, "e");
        KYmTj.addChild(kWDEz);
        CommonToken xrhZk = new CommonToken(JavadocTokenTypes.CHAR, "a");
        KYmTj.addChild(xrhZk);
        CommonToken rrnjf = new CommonToken(JavadocTokenTypes.CHAR, "s");
        KYmTj.addChild(rrnjf);
        CommonToken hMbVu = new CommonToken(JavadocTokenTypes.CHAR, "e");
        KYmTj.addChild(hMbVu);
        CommonToken WEbWM = new CommonToken(JavadocTokenTypes.WS, " ");
        KYmTj.addChild(WEbWM);
        CommonToken NFvZb = new CommonToken(JavadocTokenTypes.CHAR, "3");
        KYmTj.addChild(NFvZb);
        CommonToken rWLUe = new CommonToken(JavadocTokenTypes.CHAR, ".");
        KYmTj.addChild(rWLUe);
        CommonToken sZzJq = new CommonToken(JavadocTokenTypes.CHAR, "4");
        KYmTj.addChild(sZzJq);
        CommonToken fpHMf = new CommonToken(JavadocTokenTypes.CHAR, ".");
        KYmTj.addChild(fpHMf);
        CommonToken ukVDH = new CommonToken(JavadocTokenTypes.CHAR, "5");
        KYmTj.addChild(ukVDH);
        NYzVK.addChild(KYmTj);
        OcuEn.addChild(NYzVK);
        KzwtL.addChild(OcuEn);
        CommonToken lWOPi = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        KzwtL.addChild(lWOPi);
        return KzwtL;
    }
    public static ParseTree treeUnclosedAndClosedParagraphs() {
        JavadocContext YgctO = new JavadocContext(null, 0);
        HtmlElementContext uErtB = new HtmlElementContext(YgctO, 0);
        PTagOpenContext GFcZu = new PTagOpenContext(uErtB, 0);
        CommonToken sGJxY = new CommonToken(JavadocTokenTypes.OPEN, "<");
        GFcZu.addChild(sGJxY);
        CommonToken NucrT = new CommonToken(JavadocTokenTypes.P_HTML_TAG_NAME, "p");
        GFcZu.addChild(NucrT);
        CommonToken RDdJM = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        GFcZu.addChild(RDdJM);
        uErtB.addChild(GFcZu);
        YgctO.addChild(uErtB);
        CommonToken FyXjz = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        YgctO.addChild(FyXjz);
        TextContext IeeMb = new TextContext(YgctO, 0);
        CommonToken bNebr = new CommonToken(JavadocTokenTypes.CHAR, "f");
        IeeMb.addChild(bNebr);
        CommonToken kmRZY = new CommonToken(JavadocTokenTypes.CHAR, "i");
        IeeMb.addChild(kmRZY);
        CommonToken lkBYc = new CommonToken(JavadocTokenTypes.CHAR, "r");
        IeeMb.addChild(lkBYc);
        CommonToken qNbrs = new CommonToken(JavadocTokenTypes.CHAR, "s");
        IeeMb.addChild(qNbrs);
        CommonToken ETzPx = new CommonToken(JavadocTokenTypes.CHAR, "t");
        IeeMb.addChild(ETzPx);
        CommonToken svoMq = new CommonToken(JavadocTokenTypes.WS, " ");
        IeeMb.addChild(svoMq);
        CommonToken rkEPh = new CommonToken(JavadocTokenTypes.CHAR, "p");
        IeeMb.addChild(rkEPh);
        CommonToken osfyp = new CommonToken(JavadocTokenTypes.CHAR, "a");
        IeeMb.addChild(osfyp);
        CommonToken UMrJI = new CommonToken(JavadocTokenTypes.CHAR, "r");
        IeeMb.addChild(UMrJI);
        CommonToken hhJNH = new CommonToken(JavadocTokenTypes.CHAR, "a");
        IeeMb.addChild(hhJNH);
        CommonToken YDrVU = new CommonToken(JavadocTokenTypes.CHAR, "g");
        IeeMb.addChild(YDrVU);
        CommonToken rpuIO = new CommonToken(JavadocTokenTypes.CHAR, "r");
        IeeMb.addChild(rpuIO);
        CommonToken svmqX = new CommonToken(JavadocTokenTypes.CHAR, "a");
        IeeMb.addChild(svmqX);
        CommonToken PAofj = new CommonToken(JavadocTokenTypes.CHAR, "p");
        IeeMb.addChild(PAofj);
        CommonToken kskXI = new CommonToken(JavadocTokenTypes.CHAR, "h");
        IeeMb.addChild(kskXI);
        YgctO.addChild(IeeMb);
        CommonToken BVeon = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        YgctO.addChild(BVeon);
        HtmlElementContext kpCbZ = new HtmlElementContext(YgctO, 0);
        ParagraphContext Gcoxj = new ParagraphContext(kpCbZ, 0);
        PTagOpenContext deNJt = new PTagOpenContext(Gcoxj, 0);
        CommonToken yIMdO = new CommonToken(JavadocTokenTypes.OPEN, "<");
        deNJt.addChild(yIMdO);
        CommonToken iWEcF = new CommonToken(JavadocTokenTypes.P_HTML_TAG_NAME, "p");
        deNJt.addChild(iWEcF);
        CommonToken UNDgj = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        deNJt.addChild(UNDgj);
        Gcoxj.addChild(deNJt);
        CommonToken UpOeJ = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        Gcoxj.addChild(UpOeJ);
        TextContext ehZXo = new TextContext(Gcoxj, 0);
        CommonToken SGFxd = new CommonToken(JavadocTokenTypes.CHAR, "s");
        ehZXo.addChild(SGFxd);
        CommonToken fJXkB = new CommonToken(JavadocTokenTypes.CHAR, "e");
        ehZXo.addChild(fJXkB);
        CommonToken NWrMe = new CommonToken(JavadocTokenTypes.CHAR, "c");
        ehZXo.addChild(NWrMe);
        CommonToken jGsrk = new CommonToken(JavadocTokenTypes.CHAR, "o");
        ehZXo.addChild(jGsrk);
        CommonToken wtvmu = new CommonToken(JavadocTokenTypes.CHAR, "n");
        ehZXo.addChild(wtvmu);
        CommonToken BAmnp = new CommonToken(JavadocTokenTypes.CHAR, "d");
        ehZXo.addChild(BAmnp);
        CommonToken QXpdx = new CommonToken(JavadocTokenTypes.WS, " ");
        ehZXo.addChild(QXpdx);
        CommonToken vfSMJ = new CommonToken(JavadocTokenTypes.CHAR, "p");
        ehZXo.addChild(vfSMJ);
        CommonToken CrmdJ = new CommonToken(JavadocTokenTypes.CHAR, "a");
        ehZXo.addChild(CrmdJ);
        CommonToken vtWes = new CommonToken(JavadocTokenTypes.CHAR, "r");
        ehZXo.addChild(vtWes);
        CommonToken bvVyo = new CommonToken(JavadocTokenTypes.CHAR, "a");
        ehZXo.addChild(bvVyo);
        CommonToken LanAa = new CommonToken(JavadocTokenTypes.CHAR, "g");
        ehZXo.addChild(LanAa);
        CommonToken HYbDb = new CommonToken(JavadocTokenTypes.CHAR, "r");
        ehZXo.addChild(HYbDb);
        CommonToken JvwBo = new CommonToken(JavadocTokenTypes.CHAR, "a");
        ehZXo.addChild(JvwBo);
        CommonToken lbfyR = new CommonToken(JavadocTokenTypes.CHAR, "p");
        ehZXo.addChild(lbfyR);
        CommonToken vKKaB = new CommonToken(JavadocTokenTypes.CHAR, "h");
        ehZXo.addChild(vKKaB);
        Gcoxj.addChild(ehZXo);
        CommonToken qmqSq = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        Gcoxj.addChild(qmqSq);
        PTagCloseContext fOGBD = new PTagCloseContext(Gcoxj, 0);
        CommonToken uXPjS = new CommonToken(JavadocTokenTypes.OPEN, "<");
        fOGBD.addChild(uXPjS);
        CommonToken ljvet = new CommonToken(JavadocTokenTypes.SLASH, "/");
        fOGBD.addChild(ljvet);
        CommonToken JbBQX = new CommonToken(JavadocTokenTypes.P_HTML_TAG_NAME, "p");
        fOGBD.addChild(JbBQX);
        CommonToken gOMRW = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        fOGBD.addChild(gOMRW);
        Gcoxj.addChild(fOGBD);
        kpCbZ.addChild(Gcoxj);
        YgctO.addChild(kpCbZ);
        CommonToken bSvLk = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        YgctO.addChild(bSvLk);
        return YgctO;
    }
    public static ParseTree treeListWithUnclosedItemInUnclosedParagraph() {
        JavadocContext cQkWm = new JavadocContext(null, 0);
        HtmlElementContext xNsDD = new HtmlElementContext(cQkWm, 0);
        PTagOpenContext BqpVW = new PTagOpenContext(xNsDD, 0);
        CommonToken FkBWc = new CommonToken(JavadocTokenTypes.OPEN, "<");
        BqpVW.addChild(FkBWc);
        CommonToken pGbVS = new CommonToken(JavadocTokenTypes.P_HTML_TAG_NAME, "p");
        BqpVW.addChild(pGbVS);
        CommonToken iCTxl = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        BqpVW.addChild(iCTxl);
        xNsDD.addChild(BqpVW);
        cQkWm.addChild(xNsDD);
        CommonToken ifvNd = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        cQkWm.addChild(ifvNd);
        HtmlElementContext Dwasm = new HtmlElementContext(cQkWm, 0);
        HtmlTagContext zKmgq = new HtmlTagContext(Dwasm, 0);
        HtmlElementOpenContext UJmda = new HtmlElementOpenContext(zKmgq, 0);
        CommonToken qAeVG = new CommonToken(JavadocTokenTypes.OPEN, "<");
        UJmda.addChild(qAeVG);
        CommonToken xwJDa = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "ul");
        UJmda.addChild(xwJDa);
        CommonToken bCakN = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        UJmda.addChild(bCakN);
        zKmgq.addChild(UJmda);
        CommonToken PbiAM = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        zKmgq.addChild(PbiAM);
        TextContext puddm = new TextContext(zKmgq, 0);
        CommonToken YwCWd = new CommonToken(JavadocTokenTypes.WS, "\t");
        puddm.addChild(YwCWd);
        zKmgq.addChild(puddm);
        HtmlElementContext SPdzM = new HtmlElementContext(zKmgq, 0);
        LiTagOpenContext WFeMQ = new LiTagOpenContext(SPdzM, 0);
        CommonToken NHBGq = new CommonToken(JavadocTokenTypes.OPEN, "<");
        WFeMQ.addChild(NHBGq);
        CommonToken ZIRFJ = new CommonToken(JavadocTokenTypes.LI_HTML_TAG_NAME, "li");
        WFeMQ.addChild(ZIRFJ);
        CommonToken eeonI = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        WFeMQ.addChild(eeonI);
        SPdzM.addChild(WFeMQ);
        zKmgq.addChild(SPdzM);
        TextContext dMWLw = new TextContext(zKmgq, 0);
        CommonToken UJcMj = new CommonToken(JavadocTokenTypes.CHAR, "i");
        dMWLw.addChild(UJcMj);
        CommonToken CBBTp = new CommonToken(JavadocTokenTypes.CHAR, "t");
        dMWLw.addChild(CBBTp);
        CommonToken MMQaK = new CommonToken(JavadocTokenTypes.CHAR, "e");
        dMWLw.addChild(MMQaK);
        CommonToken ItkBE = new CommonToken(JavadocTokenTypes.CHAR, "m");
        dMWLw.addChild(ItkBE);
        CommonToken utBdQ = new CommonToken(JavadocTokenTypes.WS, " ");
        dMWLw.addChild(utBdQ);
        CommonToken OOEjD = new CommonToken(JavadocTokenTypes.CHAR, "1");
        dMWLw.addChild(OOEjD);
        zKmgq.addChild(dMWLw);
        CommonToken lWorP = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        zKmgq.addChild(lWorP);
        TextContext jDxVf = new TextContext(zKmgq, 0);
        CommonToken PnoKJ = new CommonToken(JavadocTokenTypes.WS, "\t");
        jDxVf.addChild(PnoKJ);
        zKmgq.addChild(jDxVf);
        HtmlElementContext wjQOv = new HtmlElementContext(zKmgq, 0);
        LiContext pjUbB = new LiContext(wjQOv, 0);
        LiTagOpenContext UnLuf = new LiTagOpenContext(pjUbB, 0);
        CommonToken DXhyD = new CommonToken(JavadocTokenTypes.OPEN, "<");
        UnLuf.addChild(DXhyD);
        CommonToken iaVCp = new CommonToken(JavadocTokenTypes.LI_HTML_TAG_NAME, "li");
        UnLuf.addChild(iaVCp);
        CommonToken OPKTS = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        UnLuf.addChild(OPKTS);
        pjUbB.addChild(UnLuf);
        TextContext OdjuX = new TextContext(pjUbB, 0);
        CommonToken AUIXJ = new CommonToken(JavadocTokenTypes.CHAR, "i");
        OdjuX.addChild(AUIXJ);
        CommonToken iKVgk = new CommonToken(JavadocTokenTypes.CHAR, "t");
        OdjuX.addChild(iKVgk);
        CommonToken xfYtg = new CommonToken(JavadocTokenTypes.CHAR, "e");
        OdjuX.addChild(xfYtg);
        CommonToken qrNcC = new CommonToken(JavadocTokenTypes.CHAR, "m");
        OdjuX.addChild(qrNcC);
        CommonToken jyIKm = new CommonToken(JavadocTokenTypes.WS, " ");
        OdjuX.addChild(jyIKm);
        CommonToken GWlXZ = new CommonToken(JavadocTokenTypes.CHAR, "2");
        OdjuX.addChild(GWlXZ);
        pjUbB.addChild(OdjuX);
        LiTagCloseContext tawdc = new LiTagCloseContext(pjUbB, 0);
        CommonToken JMpwx = new CommonToken(JavadocTokenTypes.OPEN, "<");
        tawdc.addChild(JMpwx);
        CommonToken FnJCw = new CommonToken(JavadocTokenTypes.SLASH, "/");
        tawdc.addChild(FnJCw);
        CommonToken zYYWy = new CommonToken(JavadocTokenTypes.LI_HTML_TAG_NAME, "li");
        tawdc.addChild(zYYWy);
        CommonToken GYple = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        tawdc.addChild(GYple);
        pjUbB.addChild(tawdc);
        wjQOv.addChild(pjUbB);
        zKmgq.addChild(wjQOv);
        CommonToken WyYHG = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        zKmgq.addChild(WyYHG);
        HtmlElementCloseContext sXgAY = new HtmlElementCloseContext(zKmgq, 0);
        CommonToken VcTUH = new CommonToken(JavadocTokenTypes.OPEN, "<");
        sXgAY.addChild(VcTUH);
        CommonToken TOttT = new CommonToken(JavadocTokenTypes.SLASH, "/");
        sXgAY.addChild(TOttT);
        CommonToken gpiJj = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "ul");
        sXgAY.addChild(gpiJj);
        CommonToken Glqvw = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        sXgAY.addChild(Glqvw);
        zKmgq.addChild(sXgAY);
        Dwasm.addChild(zKmgq);
        cQkWm.addChild(Dwasm);
        CommonToken BDwlx = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        cQkWm.addChild(BDwlx);
        return cQkWm;
    }

    public static ParseTree treeUnclosedParagraphFollowedByJavadocTag() {
        JavadocContext toAar = new JavadocContext(null, 0);
        HtmlElementContext FmXNr = new HtmlElementContext(toAar, 0);
        PTagOpenContext ryFvE = new PTagOpenContext(FmXNr, 0);
        CommonToken HdDOX = new CommonToken(JavadocTokenTypes.OPEN, "<");
        ryFvE.addChild(HdDOX);
        CommonToken nYJUI = new CommonToken(JavadocTokenTypes.P_HTML_TAG_NAME, "p");
        ryFvE.addChild(nYJUI);
        CommonToken KDRaQ = new CommonToken(JavadocTokenTypes.WS, " ");
        ryFvE.addChild(KDRaQ);
        AttributeContext gTKLk = new AttributeContext(ryFvE, 0);
        CommonToken cqEmn = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "style");
        gTKLk.addChild(cqEmn);
        CommonToken ltvVB = new CommonToken(JavadocTokenTypes.EQUALS, "=");
        gTKLk.addChild(ltvVB);
        CommonToken VMpFN = new CommonToken(JavadocTokenTypes.ATTR_VALUE, "\"color: red;\"");
        gTKLk.addChild(VMpFN);
        ryFvE.addChild(gTKLk);
        CommonToken DqXAR = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        ryFvE.addChild(DqXAR);
        FmXNr.addChild(ryFvE);
        toAar.addChild(FmXNr);
        CommonToken gDtSy = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        toAar.addChild(gDtSy);
        TextContext AUKAx = new TextContext(toAar, 0);
        CommonToken yvWdA = new CommonToken(JavadocTokenTypes.WS, "\t");
        AUKAx.addChild(yvWdA);
        CommonToken OYedt = new CommonToken(JavadocTokenTypes.CHAR, "t");
        AUKAx.addChild(OYedt);
        CommonToken JzDTB = new CommonToken(JavadocTokenTypes.CHAR, "e");
        AUKAx.addChild(JzDTB);
        CommonToken oDIJN = new CommonToken(JavadocTokenTypes.CHAR, "x");
        AUKAx.addChild(oDIJN);
        CommonToken Rqlbw = new CommonToken(JavadocTokenTypes.CHAR, "t");
        AUKAx.addChild(Rqlbw);
        CommonToken tCDRR = new CommonToken(JavadocTokenTypes.WS, " ");
        AUKAx.addChild(tCDRR);
        CommonToken pffyu = new CommonToken(JavadocTokenTypes.CHAR, "t");
        AUKAx.addChild(pffyu);
        CommonToken NYaCv = new CommonToken(JavadocTokenTypes.CHAR, "e");
        AUKAx.addChild(NYaCv);
        CommonToken hqUjd = new CommonToken(JavadocTokenTypes.CHAR, "x");
        AUKAx.addChild(hqUjd);
        CommonToken KRkis = new CommonToken(JavadocTokenTypes.CHAR, "t");
        AUKAx.addChild(KRkis);
        toAar.addChild(AUKAx);
        CommonToken HqAee = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        toAar.addChild(HqAee);
        JavadocTagContext XFxtS = new JavadocTagContext(toAar, 0);
        CommonToken yXsKP = new CommonToken(JavadocTokenTypes.AUTHOR_LITERAL, "@author");
        XFxtS.addChild(yXsKP);
        CommonToken RmrHi = new CommonToken(JavadocTokenTypes.WS, " ");
        XFxtS.addChild(RmrHi);
        DescriptionContext SAUHr = new DescriptionContext(XFxtS, 0);
        TextContext mKYlo = new TextContext(SAUHr, 0);
        CommonToken zoqVb = new CommonToken(JavadocTokenTypes.CHAR, "B");
        mKYlo.addChild(zoqVb);
        CommonToken qltjj = new CommonToken(JavadocTokenTypes.CHAR, "a");
        mKYlo.addChild(qltjj);
        CommonToken FtRxi = new CommonToken(JavadocTokenTypes.CHAR, "r");
        mKYlo.addChild(FtRxi);
        CommonToken IJzqI = new CommonToken(JavadocTokenTypes.CHAR, "a");
        mKYlo.addChild(IJzqI);
        CommonToken FcrDM = new CommonToken(JavadocTokenTypes.CHAR, "t");
        mKYlo.addChild(FcrDM);
        CommonToken QNyou = new CommonToken(JavadocTokenTypes.CHAR, "a");
        mKYlo.addChild(QNyou);
        CommonToken qasHc = new CommonToken(JavadocTokenTypes.CHAR, "l");
        mKYlo.addChild(qasHc);
        CommonToken acnQH = new CommonToken(JavadocTokenTypes.CHAR, "i");
        mKYlo.addChild(acnQH);
        SAUHr.addChild(mKYlo);
        XFxtS.addChild(SAUHr);
        toAar.addChild(XFxtS);
        CommonToken tONCM = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        toAar.addChild(tONCM);
        return toAar;
    }

    public static ParseTree treeAllJavadocInlineTags() {
        JavadocContext XCFCp = new JavadocContext(null, 0);
        JavadocInlineTagContext vvMvz = new JavadocInlineTagContext(XCFCp, 0);
        CommonToken tyjLa = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        vvMvz.addChild(tyjLa);
        CommonToken KRltG = new CommonToken(JavadocTokenTypes.CODE_LITERAL, "@code");
        vvMvz.addChild(KRltG);
        CommonToken FGHtI = new CommonToken(JavadocTokenTypes.WS, " ");
        vvMvz.addChild(FGHtI);
        TextContext yGTsf = new TextContext(vvMvz, 0);
        CommonToken jnFVB = new CommonToken(JavadocTokenTypes.CHAR, "<");
        yGTsf.addChild(jnFVB);
        CommonToken JJqPx = new CommonToken(JavadocTokenTypes.CHAR, "c");
        yGTsf.addChild(JJqPx);
        CommonToken GVmVW = new CommonToken(JavadocTokenTypes.CHAR, "o");
        yGTsf.addChild(GVmVW);
        CommonToken rqpRz = new CommonToken(JavadocTokenTypes.CHAR, "d");
        yGTsf.addChild(rqpRz);
        CommonToken qWwRJ = new CommonToken(JavadocTokenTypes.CHAR, "e");
        yGTsf.addChild(qWwRJ);
        CommonToken miwjG = new CommonToken(JavadocTokenTypes.CHAR, ">");
        yGTsf.addChild(miwjG);
        vvMvz.addChild(yGTsf);
        CommonToken MBkdQ = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        vvMvz.addChild(MBkdQ);
        XCFCp.addChild(vvMvz);
        TextContext foQHe = new TextContext(XCFCp, 0);
        CommonToken kCgcb = new CommonToken(JavadocTokenTypes.WS, " ");
        foQHe.addChild(kCgcb);
        XCFCp.addChild(foQHe);
        JavadocInlineTagContext FyBGO = new JavadocInlineTagContext(XCFCp, 0);
        CommonToken lfXcG = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        FyBGO.addChild(lfXcG);
        CommonToken LOsYk = new CommonToken(JavadocTokenTypes.LITERAL_LITERAL, "@literal");
        FyBGO.addChild(LOsYk);
        CommonToken vfZxY = new CommonToken(JavadocTokenTypes.WS, " ");
        FyBGO.addChild(vfZxY);
        TextContext iQXrF = new TextContext(FyBGO, 0);
        CommonToken iWwOe = new CommonToken(JavadocTokenTypes.CHAR, "<");
        iQXrF.addChild(iWwOe);
        CommonToken LJzjh = new CommonToken(JavadocTokenTypes.CHAR, "l");
        iQXrF.addChild(LJzjh);
        CommonToken NldLf = new CommonToken(JavadocTokenTypes.CHAR, "i");
        iQXrF.addChild(NldLf);
        CommonToken lFviM = new CommonToken(JavadocTokenTypes.CHAR, "t");
        iQXrF.addChild(lFviM);
        CommonToken xJWOR = new CommonToken(JavadocTokenTypes.CHAR, "e");
        iQXrF.addChild(xJWOR);
        CommonToken Adfst = new CommonToken(JavadocTokenTypes.CHAR, "r");
        iQXrF.addChild(Adfst);
        CommonToken zFutg = new CommonToken(JavadocTokenTypes.CHAR, "a");
        iQXrF.addChild(zFutg);
        CommonToken crGkI = new CommonToken(JavadocTokenTypes.CHAR, "l");
        iQXrF.addChild(crGkI);
        CommonToken FAHoz = new CommonToken(JavadocTokenTypes.CHAR, ">");
        iQXrF.addChild(FAHoz);
        FyBGO.addChild(iQXrF);
        CommonToken LGgQr = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        FyBGO.addChild(LGgQr);
        XCFCp.addChild(FyBGO);
        TextContext HBepk = new TextContext(XCFCp, 0);
        CommonToken lXwuG = new CommonToken(JavadocTokenTypes.WS, " ");
        HBepk.addChild(lXwuG);
        XCFCp.addChild(HBepk);
        JavadocInlineTagContext BpaCl = new JavadocInlineTagContext(XCFCp, 0);
        CommonToken Sgsns = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        BpaCl.addChild(Sgsns);
        CommonToken JvJig = new CommonToken(JavadocTokenTypes.DOC_ROOT_LITERAL, "@docRoot");
        BpaCl.addChild(JvJig);
        CommonToken mWdmB = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        BpaCl.addChild(mWdmB);
        XCFCp.addChild(BpaCl);
        TextContext qcEFG = new TextContext(XCFCp, 0);
        CommonToken EdLPJ = new CommonToken(JavadocTokenTypes.WS, " ");
        qcEFG.addChild(EdLPJ);
        XCFCp.addChild(qcEFG);
        JavadocInlineTagContext NnMRn = new JavadocInlineTagContext(XCFCp, 0);
        CommonToken NfGZi = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        NnMRn.addChild(NfGZi);
        CommonToken WQTCA = new CommonToken(JavadocTokenTypes.INHERIT_DOC_LITERAL, "@inheritDoc");
        NnMRn.addChild(WQTCA);
        CommonToken gMbXT = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        NnMRn.addChild(gMbXT);
        XCFCp.addChild(NnMRn);
        TextContext xsdSg = new TextContext(XCFCp, 0);
        CommonToken AuLBM = new CommonToken(JavadocTokenTypes.WS, " ");
        xsdSg.addChild(AuLBM);
        XCFCp.addChild(xsdSg);
        JavadocInlineTagContext uDaZc = new JavadocInlineTagContext(XCFCp, 0);
        CommonToken mFELI = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        uDaZc.addChild(mFELI);
        CommonToken XNwqz = new CommonToken(JavadocTokenTypes.LINK_LITERAL, "@link");
        uDaZc.addChild(XNwqz);
        CommonToken qqVCG = new CommonToken(JavadocTokenTypes.WS, " ");
        uDaZc.addChild(qqVCG);
        ReferenceContext cnPBx = new ReferenceContext(uDaZc, 0);
        CommonToken bkuIn = new CommonToken(JavadocTokenTypes.CLASS, "A");
        cnPBx.addChild(bkuIn);
        uDaZc.addChild(cnPBx);
        DescriptionContext Nwwzw = new DescriptionContext(uDaZc, 0);
        TextContext aoYeF = new TextContext(Nwwzw, 0);
        CommonToken BbcMv = new CommonToken(JavadocTokenTypes.WS, " ");
        aoYeF.addChild(BbcMv);
        CommonToken wvBIr = new CommonToken(JavadocTokenTypes.CHAR, "A");
        aoYeF.addChild(wvBIr);
        CommonToken bIaEN = new CommonToken(JavadocTokenTypes.WS, " ");
        aoYeF.addChild(bIaEN);
        CommonToken WihsX = new CommonToken(JavadocTokenTypes.CHAR, "c");
        aoYeF.addChild(WihsX);
        CommonToken CYnHa = new CommonToken(JavadocTokenTypes.CHAR, "l");
        aoYeF.addChild(CYnHa);
        CommonToken mReSU = new CommonToken(JavadocTokenTypes.CHAR, "a");
        aoYeF.addChild(mReSU);
        CommonToken ZpHCT = new CommonToken(JavadocTokenTypes.CHAR, "s");
        aoYeF.addChild(ZpHCT);
        CommonToken gRXzZ = new CommonToken(JavadocTokenTypes.CHAR, "s");
        aoYeF.addChild(gRXzZ);
        Nwwzw.addChild(aoYeF);
        uDaZc.addChild(Nwwzw);
        CommonToken pjqJa = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        uDaZc.addChild(pjqJa);
        XCFCp.addChild(uDaZc);
        TextContext YNADS = new TextContext(XCFCp, 0);
        CommonToken IputF = new CommonToken(JavadocTokenTypes.WS, " ");
        YNADS.addChild(IputF);
        XCFCp.addChild(YNADS);
        JavadocInlineTagContext eAcRt = new JavadocInlineTagContext(XCFCp, 0);
        CommonToken iEPsH = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        eAcRt.addChild(iEPsH);
        CommonToken PcAvQ = new CommonToken(JavadocTokenTypes.LINKPLAIN_LITERAL, "@linkplain");
        eAcRt.addChild(PcAvQ);
        CommonToken IMvdy = new CommonToken(JavadocTokenTypes.WS, " ");
        eAcRt.addChild(IMvdy);
        ReferenceContext fqHhC = new ReferenceContext(eAcRt, 0);
        CommonToken qYmAk = new CommonToken(JavadocTokenTypes.CLASS, "A");
        fqHhC.addChild(qYmAk);
        eAcRt.addChild(fqHhC);
        DescriptionContext brtoS = new DescriptionContext(eAcRt, 0);
        TextContext dGiZw = new TextContext(brtoS, 0);
        CommonToken AbrxL = new CommonToken(JavadocTokenTypes.WS, " ");
        dGiZw.addChild(AbrxL);
        CommonToken WDSsS = new CommonToken(JavadocTokenTypes.CHAR, "a");
        dGiZw.addChild(WDSsS);
        CommonToken tPLRW = new CommonToken(JavadocTokenTypes.CHAR, "n");
        dGiZw.addChild(tPLRW);
        CommonToken cvRSk = new CommonToken(JavadocTokenTypes.CHAR, "o");
        dGiZw.addChild(cvRSk);
        CommonToken AbPnu = new CommonToken(JavadocTokenTypes.CHAR, "t");
        dGiZw.addChild(AbPnu);
        CommonToken WOWlF = new CommonToken(JavadocTokenTypes.CHAR, "h");
        dGiZw.addChild(WOWlF);
        CommonToken SYLiT = new CommonToken(JavadocTokenTypes.CHAR, "e");
        dGiZw.addChild(SYLiT);
        CommonToken AtRDz = new CommonToken(JavadocTokenTypes.CHAR, "r");
        dGiZw.addChild(AtRDz);
        CommonToken mmKkp = new CommonToken(JavadocTokenTypes.WS, " ");
        dGiZw.addChild(mmKkp);
        CommonToken ygfxc = new CommonToken(JavadocTokenTypes.CHAR, "l");
        dGiZw.addChild(ygfxc);
        CommonToken bJzTl = new CommonToken(JavadocTokenTypes.CHAR, "i");
        dGiZw.addChild(bJzTl);
        CommonToken LhWRW = new CommonToken(JavadocTokenTypes.CHAR, "n");
        dGiZw.addChild(LhWRW);
        CommonToken bmeId = new CommonToken(JavadocTokenTypes.CHAR, "k");
        dGiZw.addChild(bmeId);
        brtoS.addChild(dGiZw);
        eAcRt.addChild(brtoS);
        CommonToken fRkUC = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        eAcRt.addChild(fRkUC);
        XCFCp.addChild(eAcRt);
        TextContext cNtKT = new TextContext(XCFCp, 0);
        CommonToken gGmoz = new CommonToken(JavadocTokenTypes.WS, " ");
        cNtKT.addChild(gGmoz);
        XCFCp.addChild(cNtKT);
        JavadocInlineTagContext DcRUm = new JavadocInlineTagContext(XCFCp, 0);
        CommonToken kCjvD = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        DcRUm.addChild(kCjvD);
        CommonToken HUUCy = new CommonToken(JavadocTokenTypes.VALUE_LITERAL, "@value");
        DcRUm.addChild(HUUCy);
        CommonToken dixxI = new CommonToken(JavadocTokenTypes.WS, " ");
        DcRUm.addChild(dixxI);
        ReferenceContext NDRFQ = new ReferenceContext(DcRUm, 0);
        CommonToken ULKmS = new CommonToken(JavadocTokenTypes.PACKAGE, "lang");
        NDRFQ.addChild(ULKmS);
        CommonToken BLKoL = new CommonToken(JavadocTokenTypes.DOT, ".");
        NDRFQ.addChild(BLKoL);
        CommonToken uAzxT = new CommonToken(JavadocTokenTypes.CLASS, "Integer");
        NDRFQ.addChild(uAzxT);
        CommonToken chhNN = new CommonToken(JavadocTokenTypes.HASH, "#");
        NDRFQ.addChild(chhNN);
        CommonToken WQzYZ = new CommonToken(JavadocTokenTypes.MEMBER, "MAX_VALUE");
        NDRFQ.addChild(WQzYZ);
        DcRUm.addChild(NDRFQ);
        CommonToken emAFs = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        DcRUm.addChild(emAFs);
        XCFCp.addChild(DcRUm);
        CommonToken zqHMX = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        XCFCp.addChild(zqHMX);
        return XCFCp;
    }
    public static ParseTree treeDocRootInheritDoc() {
        JavadocContext CAWJW = new JavadocContext(null, 0);
        CommonToken yedSF = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        CAWJW.addChild(yedSF);
        CommonToken HyKaf = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        CAWJW.addChild(HyKaf);
        TextContext WCKlI = new TextContext(CAWJW, 0);
        CommonToken UujlQ = new CommonToken(JavadocTokenTypes.WS, " ");
        WCKlI.addChild(UujlQ);
        CAWJW.addChild(WCKlI);
        JavadocInlineTagContext ebZsC = new JavadocInlineTagContext(CAWJW, 0);
        CommonToken gdFio = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        ebZsC.addChild(gdFio);
        CommonToken IhYHt = new CommonToken(JavadocTokenTypes.DOC_ROOT_LITERAL, "@docRoot");
        ebZsC.addChild(IhYHt);
        CommonToken AJgDf = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        ebZsC.addChild(AJgDf);
        CAWJW.addChild(ebZsC);
        CommonToken gsDNo = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        CAWJW.addChild(gsDNo);
        CommonToken ygMhD = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        CAWJW.addChild(ygMhD);
        TextContext eqDaT = new TextContext(CAWJW, 0);
        CommonToken VmFHe = new CommonToken(JavadocTokenTypes.WS, " ");
        eqDaT.addChild(VmFHe);
        CAWJW.addChild(eqDaT);
        JavadocInlineTagContext NDzGJ = new JavadocInlineTagContext(CAWJW, 0);
        CommonToken arrQW = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        NDzGJ.addChild(arrQW);
        CommonToken oaYWJ = new CommonToken(JavadocTokenTypes.DOC_ROOT_LITERAL, "@docRoot");
        NDzGJ.addChild(oaYWJ);
        CommonToken jKhIo = new CommonToken(JavadocTokenTypes.WS, " ");
        NDzGJ.addChild(jKhIo);
        CommonToken dGiJA = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        NDzGJ.addChild(dGiJA);
        CAWJW.addChild(NDzGJ);
        CommonToken ddkKe = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        CAWJW.addChild(ddkKe);
        CommonToken TQjjV = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        CAWJW.addChild(TQjjV);
        TextContext UQHgC = new TextContext(CAWJW, 0);
        CommonToken PwuNM = new CommonToken(JavadocTokenTypes.WS, " ");
        UQHgC.addChild(PwuNM);
        CAWJW.addChild(UQHgC);
        JavadocInlineTagContext gwexf = new JavadocInlineTagContext(CAWJW, 0);
        CommonToken bpYBO = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        gwexf.addChild(bpYBO);
        CommonToken cvvJR = new CommonToken(JavadocTokenTypes.DOC_ROOT_LITERAL, "@docRoot");
        gwexf.addChild(cvvJR);
        CommonToken qLnrF = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        gwexf.addChild(qLnrF);
        CommonToken zoQlm = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        gwexf.addChild(zoQlm);
        CommonToken rvDVd = new CommonToken(JavadocTokenTypes.WS, " ");
        gwexf.addChild(rvDVd);
        CommonToken gPoTc = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        gwexf.addChild(gPoTc);
        CAWJW.addChild(gwexf);
        CommonToken BhBNy = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        CAWJW.addChild(BhBNy);
        CommonToken yayju = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        CAWJW.addChild(yayju);
        TextContext mPEov = new TextContext(CAWJW, 0);
        CommonToken wCOca = new CommonToken(JavadocTokenTypes.WS, " ");
        mPEov.addChild(wCOca);
        CAWJW.addChild(mPEov);
        JavadocInlineTagContext sNwft = new JavadocInlineTagContext(CAWJW, 0);
        CommonToken jAmAp = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        sNwft.addChild(jAmAp);
        CommonToken tKJbI = new CommonToken(JavadocTokenTypes.INHERIT_DOC_LITERAL, "@inheritDoc");
        sNwft.addChild(tKJbI);
        CommonToken WtIyH = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        sNwft.addChild(WtIyH);
        CAWJW.addChild(sNwft);
        CommonToken qUwTF = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        CAWJW.addChild(qUwTF);
        CommonToken bewgL = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        CAWJW.addChild(bewgL);
        TextContext BMFSS = new TextContext(CAWJW, 0);
        CommonToken IiXZA = new CommonToken(JavadocTokenTypes.WS, " ");
        BMFSS.addChild(IiXZA);
        CAWJW.addChild(BMFSS);
        JavadocInlineTagContext sQPCX = new JavadocInlineTagContext(CAWJW, 0);
        CommonToken rdCpq = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        sQPCX.addChild(rdCpq);
        CommonToken jHPxn = new CommonToken(JavadocTokenTypes.INHERIT_DOC_LITERAL, "@inheritDoc");
        sQPCX.addChild(jHPxn);
        CommonToken tHuBm = new CommonToken(JavadocTokenTypes.WS, " ");
        sQPCX.addChild(tHuBm);
        CommonToken XpuUV = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        sQPCX.addChild(XpuUV);
        CAWJW.addChild(sQPCX);
        CommonToken NQibo = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        CAWJW.addChild(NQibo);
        CommonToken aicIl = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        CAWJW.addChild(aicIl);
        TextContext vJtDV = new TextContext(CAWJW, 0);
        CommonToken JqMgW = new CommonToken(JavadocTokenTypes.WS, " ");
        vJtDV.addChild(JqMgW);
        CAWJW.addChild(vJtDV);
        JavadocInlineTagContext rpBUl = new JavadocInlineTagContext(CAWJW, 0);
        CommonToken EAMJR = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        rpBUl.addChild(EAMJR);
        CommonToken oRHfO = new CommonToken(JavadocTokenTypes.INHERIT_DOC_LITERAL, "@inheritDoc");
        rpBUl.addChild(oRHfO);
        CommonToken yRNLA = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        rpBUl.addChild(yRNLA);
        CommonToken jDlgz = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        rpBUl.addChild(jDlgz);
        CommonToken SNisJ = new CommonToken(JavadocTokenTypes.WS, " ");
        rpBUl.addChild(SNisJ);
        CommonToken wtLbm = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        rpBUl.addChild(wtLbm);
        CAWJW.addChild(rpBUl);
        CommonToken cBiEm = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        CAWJW.addChild(cBiEm);
        TextContext JvFEl = new TextContext(CAWJW, 0);
        CommonToken zZnAN = new CommonToken(JavadocTokenTypes.WS, " ");
        JvFEl.addChild(zZnAN);
        CAWJW.addChild(JvFEl);
        CommonToken qNjgf = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        CAWJW.addChild(qNjgf);
        return CAWJW;
    }
    public static ParseTree treeFewWhiteSpacesAsSeparator() {
        JavadocContext zKyCD = new JavadocContext(null, 0);
        CommonToken WeoVx = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, "       *");
        zKyCD.addChild(WeoVx);
        CommonToken QteMJ = new CommonToken(JavadocTokenTypes.WS, " ");
        zKyCD.addChild(QteMJ);
        JavadocTagContext phPgN = new JavadocTagContext(zKyCD, 0);
        CommonToken wYBWS = new CommonToken(JavadocTokenTypes.PARAM_LITERAL, "@param");
        phPgN.addChild(wYBWS);
        CommonToken iETjL = new CommonToken(JavadocTokenTypes.WS, "   ");
        phPgN.addChild(iETjL);
        CommonToken jGVhZ = new CommonToken(JavadocTokenTypes.PARAMETER_NAME, "initialCapacity");
        phPgN.addChild(jGVhZ);
        CommonToken cynpc = new CommonToken(JavadocTokenTypes.WS, "     ");
        phPgN.addChild(cynpc);
        DescriptionContext kNtol = new DescriptionContext(phPgN, 0);
        TextContext zjtGu = new TextContext(kNtol, 0);
        CommonToken wUQJx = new CommonToken(JavadocTokenTypes.CHAR, "t");
        zjtGu.addChild(wUQJx);
        CommonToken RPclX = new CommonToken(JavadocTokenTypes.CHAR, "h");
        zjtGu.addChild(RPclX);
        CommonToken JGrRW = new CommonToken(JavadocTokenTypes.CHAR, "e");
        zjtGu.addChild(JGrRW);
        CommonToken pYSMU = new CommonToken(JavadocTokenTypes.WS, " ");
        zjtGu.addChild(pYSMU);
        CommonToken nGslU = new CommonToken(JavadocTokenTypes.CHAR, "i");
        zjtGu.addChild(nGslU);
        CommonToken qzSja = new CommonToken(JavadocTokenTypes.CHAR, "n");
        zjtGu.addChild(qzSja);
        CommonToken vJKCZ = new CommonToken(JavadocTokenTypes.CHAR, "i");
        zjtGu.addChild(vJKCZ);
        CommonToken zQFvS = new CommonToken(JavadocTokenTypes.CHAR, "t");
        zjtGu.addChild(zQFvS);
        CommonToken mHDMH = new CommonToken(JavadocTokenTypes.CHAR, "i");
        zjtGu.addChild(mHDMH);
        CommonToken ZJFWk = new CommonToken(JavadocTokenTypes.CHAR, "a");
        zjtGu.addChild(ZJFWk);
        CommonToken qRgTv = new CommonToken(JavadocTokenTypes.CHAR, "l");
        zjtGu.addChild(qRgTv);
        CommonToken lfDIk = new CommonToken(JavadocTokenTypes.WS, " ");
        zjtGu.addChild(lfDIk);
        CommonToken ltHHj = new CommonToken(JavadocTokenTypes.CHAR, "c");
        zjtGu.addChild(ltHHj);
        CommonToken SfvKC = new CommonToken(JavadocTokenTypes.CHAR, "a");
        zjtGu.addChild(SfvKC);
        CommonToken wzveD = new CommonToken(JavadocTokenTypes.CHAR, "p");
        zjtGu.addChild(wzveD);
        CommonToken zUCyE = new CommonToken(JavadocTokenTypes.CHAR, "a");
        zjtGu.addChild(zUCyE);
        CommonToken rloQS = new CommonToken(JavadocTokenTypes.CHAR, "c");
        zjtGu.addChild(rloQS);
        CommonToken MuTvI = new CommonToken(JavadocTokenTypes.CHAR, "i");
        zjtGu.addChild(MuTvI);
        CommonToken fewur = new CommonToken(JavadocTokenTypes.CHAR, "t");
        zjtGu.addChild(fewur);
        CommonToken igxlx = new CommonToken(JavadocTokenTypes.CHAR, "y");
        zjtGu.addChild(igxlx);
        CommonToken beBno = new CommonToken(JavadocTokenTypes.WS, " ");
        zjtGu.addChild(beBno);
        CommonToken avZOW = new CommonToken(JavadocTokenTypes.CHAR, "o");
        zjtGu.addChild(avZOW);
        CommonToken XUQGy = new CommonToken(JavadocTokenTypes.CHAR, "f");
        zjtGu.addChild(XUQGy);
        CommonToken BSIkL = new CommonToken(JavadocTokenTypes.WS, " ");
        zjtGu.addChild(BSIkL);
        CommonToken wIFNM = new CommonToken(JavadocTokenTypes.CHAR, "t");
        zjtGu.addChild(wIFNM);
        CommonToken wJSuh = new CommonToken(JavadocTokenTypes.CHAR, "h");
        zjtGu.addChild(wJSuh);
        CommonToken KUQLO = new CommonToken(JavadocTokenTypes.CHAR, "e");
        zjtGu.addChild(KUQLO);
        CommonToken ElRYS = new CommonToken(JavadocTokenTypes.WS, " ");
        zjtGu.addChild(ElRYS);
        CommonToken gUTyH = new CommonToken(JavadocTokenTypes.CHAR, "B");
        zjtGu.addChild(gUTyH);
        CommonToken xCkwE = new CommonToken(JavadocTokenTypes.CHAR, "y");
        zjtGu.addChild(xCkwE);
        CommonToken qzUYG = new CommonToken(JavadocTokenTypes.CHAR, "t");
        zjtGu.addChild(qzUYG);
        CommonToken UGNjY = new CommonToken(JavadocTokenTypes.CHAR, "e");
        zjtGu.addChild(UGNjY);
        CommonToken QgUhb = new CommonToken(JavadocTokenTypes.CHAR, "B");
        zjtGu.addChild(QgUhb);
        CommonToken RVnZl = new CommonToken(JavadocTokenTypes.CHAR, "u");
        zjtGu.addChild(RVnZl);
        CommonToken yXxEO = new CommonToken(JavadocTokenTypes.CHAR, "f");
        zjtGu.addChild(yXxEO);
        CommonToken LuMth = new CommonToken(JavadocTokenTypes.CHAR, "f");
        zjtGu.addChild(LuMth);
        CommonToken kYaOA = new CommonToken(JavadocTokenTypes.CHAR, "e");
        zjtGu.addChild(kYaOA);
        CommonToken DIeTP = new CommonToken(JavadocTokenTypes.CHAR, "r");
        zjtGu.addChild(DIeTP);
        CommonToken WJHrR = new CommonToken(JavadocTokenTypes.CHAR, ".");
        zjtGu.addChild(WJHrR);
        kNtol.addChild(zjtGu);
        phPgN.addChild(kNtol);
        zKyCD.addChild(phPgN);
        CommonToken JrVuu = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        zKyCD.addChild(JrVuu);
        return zKyCD;
    }
    public static ParseTree treeMixedCaseOfHtmlTags() {
        JavadocContext iWKZR = new JavadocContext(null, 0);
        HtmlElementContext fcyyo = new HtmlElementContext(iWKZR, 0);
        PTagOpenContext UKnca = new PTagOpenContext(fcyyo, 0);
        CommonToken XAMcR = new CommonToken(JavadocTokenTypes.OPEN, "<");
        UKnca.addChild(XAMcR);
        CommonToken xrTlP = new CommonToken(JavadocTokenTypes.P_HTML_TAG_NAME, "P");
        UKnca.addChild(xrTlP);
        CommonToken zyyyF = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        UKnca.addChild(zyyyF);
        fcyyo.addChild(UKnca);
        iWKZR.addChild(fcyyo);
        CommonToken OmCfP = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        iWKZR.addChild(OmCfP);
        HtmlElementContext aVnVE = new HtmlElementContext(iWKZR, 0);
        SingletonElementContext COIii = new SingletonElementContext(aVnVE, 0);
        BrTagContext pwdAu = new BrTagContext(COIii, 0);
        CommonToken jmHHr = new CommonToken(JavadocTokenTypes.OPEN, "<");
        pwdAu.addChild(jmHHr);
        CommonToken jfwgB = new CommonToken(JavadocTokenTypes.BR_HTML_TAG_NAME, "br");
        pwdAu.addChild(jfwgB);
        CommonToken RcwAS = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        pwdAu.addChild(RcwAS);
        COIii.addChild(pwdAu);
        aVnVE.addChild(COIii);
        iWKZR.addChild(aVnVE);
        CommonToken gMBGa = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        iWKZR.addChild(gMBGa);
        HtmlElementContext vRfGV = new HtmlElementContext(iWKZR, 0);
        SingletonElementContext qGQrO = new SingletonElementContext(vRfGV, 0);
        BrTagContext KiLID = new BrTagContext(qGQrO, 0);
        CommonToken nXCGP = new CommonToken(JavadocTokenTypes.OPEN, "<");
        KiLID.addChild(nXCGP);
        CommonToken WYgcd = new CommonToken(JavadocTokenTypes.BR_HTML_TAG_NAME, "br");
        KiLID.addChild(WYgcd);
        CommonToken hSevb = new CommonToken(JavadocTokenTypes.SLASH_CLOSE, "/>");
        KiLID.addChild(hSevb);
        qGQrO.addChild(KiLID);
        vRfGV.addChild(qGQrO);
        iWKZR.addChild(vRfGV);
        CommonToken rUaNb = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        iWKZR.addChild(rUaNb);
        HtmlElementContext vJpux = new HtmlElementContext(iWKZR, 0);
        SingletonElementContext ONaVf = new SingletonElementContext(vJpux, 0);
        BrTagContext eIkvB = new BrTagContext(ONaVf, 0);
        CommonToken nziuT = new CommonToken(JavadocTokenTypes.OPEN, "<");
        eIkvB.addChild(nziuT);
        CommonToken PTbiF = new CommonToken(JavadocTokenTypes.BR_HTML_TAG_NAME, "BR");
        eIkvB.addChild(PTbiF);
        CommonToken ALhtL = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        eIkvB.addChild(ALhtL);
        ONaVf.addChild(eIkvB);
        vJpux.addChild(ONaVf);
        iWKZR.addChild(vJpux);
        CommonToken XTOYg = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        iWKZR.addChild(XTOYg);
        HtmlElementContext ZYoHu = new HtmlElementContext(iWKZR, 0);
        SingletonElementContext ftheU = new SingletonElementContext(ZYoHu, 0);
        BrTagContext Jwgnv = new BrTagContext(ftheU, 0);
        CommonToken iXKFh = new CommonToken(JavadocTokenTypes.OPEN, "<");
        Jwgnv.addChild(iXKFh);
        CommonToken TKFsU = new CommonToken(JavadocTokenTypes.BR_HTML_TAG_NAME, "BR");
        Jwgnv.addChild(TKFsU);
        CommonToken rPsaG = new CommonToken(JavadocTokenTypes.SLASH_CLOSE, "/>");
        Jwgnv.addChild(rPsaG);
        ftheU.addChild(Jwgnv);
        ZYoHu.addChild(ftheU);
        iWKZR.addChild(ZYoHu);
        CommonToken zxDCq = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        iWKZR.addChild(zxDCq);
        HtmlElementContext MJUQw = new HtmlElementContext(iWKZR, 0);
        HtmlTagContext CDWDd = new HtmlTagContext(MJUQw, 0);
        HtmlElementOpenContext mjIHv = new HtmlElementOpenContext(CDWDd, 0);
        CommonToken fJdVi = new CommonToken(JavadocTokenTypes.OPEN, "<");
        mjIHv.addChild(fJdVi);
        CommonToken AsDEE = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "TABLE");
        mjIHv.addChild(AsDEE);
        CommonToken zGfzL = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        mjIHv.addChild(zGfzL);
        CDWDd.addChild(mjIHv);
        CommonToken sHICO = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        CDWDd.addChild(sHICO);
        TextContext Apukr = new TextContext(CDWDd, 0);
        CommonToken UbyVP = new CommonToken(JavadocTokenTypes.WS, "\t");
        Apukr.addChild(UbyVP);
        CDWDd.addChild(Apukr);
        HtmlElementContext skMou = new HtmlElementContext(CDWDd, 0);
        TrContext xEPjY = new TrContext(skMou, 0);
        TrTagOpenContext vXsny = new TrTagOpenContext(xEPjY, 0);
        CommonToken IUMkk = new CommonToken(JavadocTokenTypes.OPEN, "<");
        vXsny.addChild(IUMkk);
        CommonToken tTVAD = new CommonToken(JavadocTokenTypes.TR_HTML_TAG_NAME, "tr");
        vXsny.addChild(tTVAD);
        CommonToken gFXXE = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        vXsny.addChild(gFXXE);
        xEPjY.addChild(vXsny);
        TrTagCloseContext bGFGg = new TrTagCloseContext(xEPjY, 0);
        CommonToken GJxfQ = new CommonToken(JavadocTokenTypes.OPEN, "<");
        bGFGg.addChild(GJxfQ);
        CommonToken ZsVqW = new CommonToken(JavadocTokenTypes.SLASH, "/");
        bGFGg.addChild(ZsVqW);
        CommonToken UOZJv = new CommonToken(JavadocTokenTypes.TR_HTML_TAG_NAME, "TR");
        bGFGg.addChild(UOZJv);
        CommonToken PaVuy = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        bGFGg.addChild(PaVuy);
        xEPjY.addChild(bGFGg);
        skMou.addChild(xEPjY);
        CDWDd.addChild(skMou);
        CommonToken WwOSH = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        CDWDd.addChild(WwOSH);
        TextContext lxufe = new TextContext(CDWDd, 0);
        CommonToken zVXtI = new CommonToken(JavadocTokenTypes.WS, "\t");
        lxufe.addChild(zVXtI);
        CDWDd.addChild(lxufe);
        HtmlElementContext KHArY = new HtmlElementContext(CDWDd, 0);
        TrContext vUNkt = new TrContext(KHArY, 0);
        TrTagOpenContext NLtsg = new TrTagOpenContext(vUNkt, 0);
        CommonToken mJQNR = new CommonToken(JavadocTokenTypes.OPEN, "<");
        NLtsg.addChild(mJQNR);
        CommonToken mYTax = new CommonToken(JavadocTokenTypes.TR_HTML_TAG_NAME, "TR");
        NLtsg.addChild(mYTax);
        CommonToken iCjrM = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        NLtsg.addChild(iCjrM);
        vUNkt.addChild(NLtsg);
        TrTagCloseContext tNsiD = new TrTagCloseContext(vUNkt, 0);
        CommonToken bDRHE = new CommonToken(JavadocTokenTypes.OPEN, "<");
        tNsiD.addChild(bDRHE);
        CommonToken ioVxv = new CommonToken(JavadocTokenTypes.SLASH, "/");
        tNsiD.addChild(ioVxv);
        CommonToken YMIDT = new CommonToken(JavadocTokenTypes.TR_HTML_TAG_NAME, "tr");
        tNsiD.addChild(YMIDT);
        CommonToken LjVWd = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        tNsiD.addChild(LjVWd);
        vUNkt.addChild(tNsiD);
        KHArY.addChild(vUNkt);
        CDWDd.addChild(KHArY);
        CommonToken RISaK = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        CDWDd.addChild(RISaK);
        HtmlElementCloseContext mqaGZ = new HtmlElementCloseContext(CDWDd, 0);
        CommonToken SqSNI = new CommonToken(JavadocTokenTypes.OPEN, "<");
        mqaGZ.addChild(SqSNI);
        CommonToken GJDIc = new CommonToken(JavadocTokenTypes.SLASH, "/");
        mqaGZ.addChild(GJDIc);
        CommonToken bDitP = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "table");
        mqaGZ.addChild(bDitP);
        CommonToken uldXk = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        mqaGZ.addChild(uldXk);
        CDWDd.addChild(mqaGZ);
        MJUQw.addChild(CDWDd);
        iWKZR.addChild(MJUQw);
        CommonToken WTQzF = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        iWKZR.addChild(WTQzF);
        HtmlElementContext YhgCO = new HtmlElementContext(iWKZR, 0);
        PTagCloseContext METvc = new PTagCloseContext(YhgCO, 0);
        CommonToken CeBJB = new CommonToken(JavadocTokenTypes.OPEN, "<");
        METvc.addChild(CeBJB);
        CommonToken tmkjM = new CommonToken(JavadocTokenTypes.SLASH, "/");
        METvc.addChild(tmkjM);
        CommonToken BPLVF = new CommonToken(JavadocTokenTypes.P_HTML_TAG_NAME, "p");
        METvc.addChild(BPLVF);
        CommonToken PcolG = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        METvc.addChild(PcolG);
        YhgCO.addChild(METvc);
        iWKZR.addChild(YhgCO);
        CommonToken iclNb = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        iWKZR.addChild(iclNb);
        return iWKZR;
    }
    public static ParseTree treeComments() {
        JavadocContext kbtaA = new JavadocContext(null, 0);
        CommonToken Tiacl = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        kbtaA.addChild(Tiacl);
        TextContext bBREf = new TextContext(kbtaA, 0);
        CommonToken SsCzG = new CommonToken(JavadocTokenTypes.WS, " ");
        bBREf.addChild(SsCzG);
        CommonToken WVwTr = new CommonToken(JavadocTokenTypes.CHAR, "U");
        bBREf.addChild(WVwTr);
        CommonToken JPJOo = new CommonToken(JavadocTokenTypes.CHAR, "s");
        bBREf.addChild(JPJOo);
        CommonToken EdUnY = new CommonToken(JavadocTokenTypes.CHAR, "e");
        bBREf.addChild(EdUnY);
        CommonToken Qlkhf = new CommonToken(JavadocTokenTypes.WS, " ");
        bBREf.addChild(Qlkhf);
        kbtaA.addChild(bBREf);
        HtmlCommentContext LCIXU = new HtmlCommentContext(kbtaA, 0);
        CommonToken lSOjO = new CommonToken(JavadocTokenTypes.HTML_COMMENT_START, "<!--");
        LCIXU.addChild(lSOjO);
        TextContext kCboV = new TextContext(LCIXU, 0);
        CommonToken phgvJ = new CommonToken(JavadocTokenTypes.WS, " ");
        kCboV.addChild(phgvJ);
        CommonToken ijFZy = new CommonToken(JavadocTokenTypes.CHAR, "s");
        kCboV.addChild(ijFZy);
        CommonToken SvgWX = new CommonToken(JavadocTokenTypes.CHAR, "t");
        kCboV.addChild(SvgWX);
        CommonToken khSeV = new CommonToken(JavadocTokenTypes.CHAR, "a");
        kCboV.addChild(khSeV);
        CommonToken HpdsX = new CommonToken(JavadocTokenTypes.CHAR, "n");
        kCboV.addChild(HpdsX);
        CommonToken byUpo = new CommonToken(JavadocTokenTypes.CHAR, "d");
        kCboV.addChild(byUpo);
        CommonToken ejrVd = new CommonToken(JavadocTokenTypes.CHAR, "a");
        kCboV.addChild(ejrVd);
        CommonToken SACAY = new CommonToken(JavadocTokenTypes.CHAR, "r");
        kCboV.addChild(SACAY);
        CommonToken vhRxs = new CommonToken(JavadocTokenTypes.CHAR, "d");
        kCboV.addChild(vhRxs);
        LCIXU.addChild(kCboV);
        CommonToken dIidq = new CommonToken(JavadocTokenTypes.NEWLINE, LINE_SEPARATOR);
        LCIXU.addChild(dIidq);
        CommonToken Pnmfd = new CommonToken(JavadocTokenTypes.LEADING_ASTERISK, " *");
        LCIXU.addChild(Pnmfd);
        TextContext ruWbh = new TextContext(LCIXU, 0);
        CommonToken bPeNs = new CommonToken(JavadocTokenTypes.WS, " ");
        ruWbh.addChild(bPeNs);
        CommonToken ejJDn = new CommonToken(JavadocTokenTypes.CHAR, "j");
        ruWbh.addChild(ejJDn);
        CommonToken XNwPC = new CommonToken(JavadocTokenTypes.CHAR, "a");
        ruWbh.addChild(XNwPC);
        CommonToken DLtbb = new CommonToken(JavadocTokenTypes.CHAR, "v");
        ruWbh.addChild(DLtbb);
        CommonToken ucCCq = new CommonToken(JavadocTokenTypes.CHAR, "a");
        ruWbh.addChild(ucCCq);
        CommonToken vwoBx = new CommonToken(JavadocTokenTypes.WS, " ");
        ruWbh.addChild(vwoBx);
        CommonToken fqkbz = new CommonToken(JavadocTokenTypes.CHAR, "t");
        ruWbh.addChild(fqkbz);
        CommonToken tDnUV = new CommonToken(JavadocTokenTypes.CHAR, "y");
        ruWbh.addChild(tDnUV);
        CommonToken zTKNB = new CommonToken(JavadocTokenTypes.CHAR, "p");
        ruWbh.addChild(zTKNB);
        CommonToken LEzJL = new CommonToken(JavadocTokenTypes.CHAR, "e");
        ruWbh.addChild(LEzJL);
        CommonToken KWDwS = new CommonToken(JavadocTokenTypes.WS, " ");
        ruWbh.addChild(KWDwS);
        LCIXU.addChild(ruWbh);
        CommonToken LTByZ = new CommonToken(JavadocTokenTypes.HTML_COMMENT_END, "-->");
        LCIXU.addChild(LTByZ);
        kbtaA.addChild(LCIXU);
        TextContext glSuR = new TextContext(kbtaA, 0);
        CommonToken QgXTG = new CommonToken(JavadocTokenTypes.WS, " ");
        glSuR.addChild(QgXTG);
        kbtaA.addChild(glSuR);
        HtmlElementContext oRcel = new HtmlElementContext(kbtaA, 0);
        HtmlTagContext UhfHH = new HtmlTagContext(oRcel, 0);
        HtmlElementOpenContext DedYq = new HtmlElementOpenContext(UhfHH, 0);
        CommonToken rhJNK = new CommonToken(JavadocTokenTypes.OPEN, "<");
        DedYq.addChild(rhJNK);
        CommonToken lpWPM = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "b");
        DedYq.addChild(lpWPM);
        CommonToken eUuDS = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        DedYq.addChild(eUuDS);
        UhfHH.addChild(DedYq);
        TextContext HiteM = new TextContext(UhfHH, 0);
        CommonToken SJbtR = new CommonToken(JavadocTokenTypes.CHAR, "S");
        HiteM.addChild(SJbtR);
        CommonToken PnWOY = new CommonToken(JavadocTokenTypes.CHAR, "t");
        HiteM.addChild(PnWOY);
        CommonToken QflON = new CommonToken(JavadocTokenTypes.CHAR, "r");
        HiteM.addChild(QflON);
        CommonToken MRxLQ = new CommonToken(JavadocTokenTypes.CHAR, "i");
        HiteM.addChild(MRxLQ);
        CommonToken zXygz = new CommonToken(JavadocTokenTypes.CHAR, "n");
        HiteM.addChild(zXygz);
        CommonToken weOIq = new CommonToken(JavadocTokenTypes.CHAR, "g");
        HiteM.addChild(weOIq);
        UhfHH.addChild(HiteM);
        HtmlElementCloseContext rNLDy = new HtmlElementCloseContext(UhfHH, 0);
        CommonToken tkpfX = new CommonToken(JavadocTokenTypes.OPEN, "<");
        rNLDy.addChild(tkpfX);
        CommonToken rKfgq = new CommonToken(JavadocTokenTypes.SLASH, "/");
        rNLDy.addChild(rKfgq);
        CommonToken OKZCw = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "b");
        rNLDy.addChild(OKZCw);
        CommonToken bZkaD = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        rNLDy.addChild(bZkaD);
        UhfHH.addChild(rNLDy);
        oRcel.addChild(UhfHH);
        kbtaA.addChild(oRcel);
        CommonToken jHAfX = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        kbtaA.addChild(jHAfX);
        return kbtaA;
    }

    public static ParseTree treeNegativeNumberInAttribute() {
        JavadocContext vfDcF = new JavadocContext(null, 0);
        HtmlElementContext wKROF = new HtmlElementContext(vfDcF, 0);
        HtmlTagContext EYqee = new HtmlTagContext(wKROF, 0);
        HtmlElementOpenContext aSmSu = new HtmlElementOpenContext(EYqee, 0);
        CommonToken xNCtb = new CommonToken(JavadocTokenTypes.OPEN, "<");
        aSmSu.addChild(xNCtb);
        CommonToken imaPh = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "font");
        aSmSu.addChild(imaPh);
        CommonToken ogMrA = new CommonToken(JavadocTokenTypes.WS, " ");
        aSmSu.addChild(ogMrA);
        AttributeContext KmAMH = new AttributeContext(aSmSu, 0);
        CommonToken KJHXR = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "size");
        KmAMH.addChild(KJHXR);
        CommonToken DdHka = new CommonToken(JavadocTokenTypes.EQUALS, "=");
        KmAMH.addChild(DdHka);
        CommonToken VZrDv = new CommonToken(JavadocTokenTypes.ATTR_VALUE, "-2");
        KmAMH.addChild(VZrDv);
        aSmSu.addChild(KmAMH);
        CommonToken SfwJg = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        aSmSu.addChild(SfwJg);
        EYqee.addChild(aSmSu);
        TextContext CVQte = new TextContext(EYqee, 0);
        CommonToken aNhAy = new CommonToken(JavadocTokenTypes.CHAR, "T");
        CVQte.addChild(aNhAy);
        CommonToken PMnir = new CommonToken(JavadocTokenTypes.CHAR, "M");
        CVQte.addChild(PMnir);
        EYqee.addChild(CVQte);
        HtmlElementCloseContext TaBhY = new HtmlElementCloseContext(EYqee, 0);
        CommonToken FPzZT = new CommonToken(JavadocTokenTypes.OPEN, "<");
        TaBhY.addChild(FPzZT);
        CommonToken UGqrj = new CommonToken(JavadocTokenTypes.SLASH, "/");
        TaBhY.addChild(UGqrj);
        CommonToken TnwEH = new CommonToken(JavadocTokenTypes.HTML_TAG_NAME, "font");
        TaBhY.addChild(TnwEH);
        CommonToken naGPO = new CommonToken(JavadocTokenTypes.CLOSE, ">");
        TaBhY.addChild(naGPO);
        EYqee.addChild(TaBhY);
        wKROF.addChild(EYqee);
        vfDcF.addChild(wKROF);
        CommonToken rrjXS = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        vfDcF.addChild(rrjXS);
        return vfDcF;
    }

    public static ParseTree treeDollarInLink() {
        JavadocContext yCrNh = new JavadocContext(null, 0);
        JavadocInlineTagContext yZEPk = new JavadocInlineTagContext(yCrNh, 0);
        CommonToken QaRFV = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_START, "{");
        yZEPk.addChild(QaRFV);
        CommonToken LnzvV = new CommonToken(JavadocTokenTypes.LINK_LITERAL, "@link");
        yZEPk.addChild(LnzvV);
        CommonToken WcdhT = new CommonToken(JavadocTokenTypes.WS, " ");
        yZEPk.addChild(WcdhT);
        ReferenceContext yPHKq = new ReferenceContext(yZEPk, 0);
        CommonToken tfKuW = new CommonToken(JavadocTokenTypes.CLASS, "My$Class");
        yPHKq.addChild(tfKuW);
        CommonToken asCBP = new CommonToken(JavadocTokenTypes.HASH, "#");
        yPHKq.addChild(asCBP);
        CommonToken VfpBA = new CommonToken(JavadocTokenTypes.MEMBER, "$$simple_$Method");
        yPHKq.addChild(VfpBA);
        ParametersContext zUjHC = new ParametersContext(yPHKq, 0);
        CommonToken evbHg = new CommonToken(JavadocTokenTypes.LEFT_BRACE, "(");
        zUjHC.addChild(evbHg);
        CommonToken mpzxn = new CommonToken(JavadocTokenTypes.ARGUMENT, "_A78");
        zUjHC.addChild(mpzxn);
        CommonToken kOOdW = new CommonToken(JavadocTokenTypes.COMMA, ",");
        zUjHC.addChild(kOOdW);
        CommonToken LvnuO = new CommonToken(JavadocTokenTypes.WS, " ");
        zUjHC.addChild(LvnuO);
        CommonToken IScAu = new CommonToken(JavadocTokenTypes.ARGUMENT, "$8$");
        zUjHC.addChild(IScAu);
        CommonToken aULsN = new CommonToken(JavadocTokenTypes.RIGHT_BRACE, ")");
        zUjHC.addChild(aULsN);
        yPHKq.addChild(zUjHC);
        yZEPk.addChild(yPHKq);
        CommonToken DCMuM = new CommonToken(JavadocTokenTypes.JAVADOC_INLINE_TAG_END, "}");
        yZEPk.addChild(DCMuM);
        yCrNh.addChild(yZEPk);
        CommonToken AcQbE = new CommonToken(JavadocTokenTypes.EOF, "<EOF>");
        yCrNh.addChild(AcQbE);
        return yCrNh;
    }

}
