#include <stdlib.h>
#include "chinese.h"
#include "input.h"
/* Phone */
static void Phone_loadtable();
static CHAR *Phone_key(CHAR *,CHAR);
static void Phone_display();
static CHAR *Phone_select(CHAR *dbuf,CHAR);
static void Phone_redisplay();
#include "phone.h"
static PHONE *PhoneTable;
static int PhoneTableSize;
static CHAR phonetr[4][128];
static int mul1,mul2;
int Phone_inputmethod(CHAR *sbuf,CHAR *dbuf,int len)
{
  CHAR *dd = dbuf;
  int i;


  /* ----------------- INTERFACE PART ------------------------*/
  /*****************************/
  /* Initialize phonetic table */
  /*****************************/
  SYSERR3("sbuf = %p dbuf = %p len = %d",sbuf,dbuf,len);

  if ((sbuf == NULL) && (dbuf == NULL) && (len == 0))
    {
      Phone_loadtable();
      return 0;
    }

  /**********************/
  /* switch to phonetic */
  /**********************/

  if ((sbuf == NULL) && (dbuf == NULL) && (len == -1))
    {
      parn = 0;

      for(i=0;i<4;i++) mbuf[i] = 255;
      mark_inputmethod("[`]");

      SYSERR("Enter phonetic input method");
      return 0;
    }

  /* ----------------- DRIVER PART ------------------------*/

  /*************/
  /* main loop */
  /*************/
  
  while(len > 0)
    {
      len--;
      switch(parn)
	{
	case 0:
	case 1:
	  dbuf = Phone_key(dbuf,*sbuf);
	  break;
	case 3:
	  if (*sbuf != 255)
	    *dbuf++=*sbuf;
	  else
	    parn = bakparn;
	  break;

	default:
	  if (parn >=6)
	    dbuf = Phone_select(dbuf,*sbuf);
	  break;
	}
      sbuf++;
    }
  return dbuf - dd;
}

static CHAR *Phone_key(CHAR *dbuf,CHAR c)
{
  int i;
  CHAR cc;

  switch(c)
    {
    case '\b':
    case 127:
      for(i=3;i>=0;i--)
	if (mbuf[i] != 255)
	  {
	    mbuf[i] = 255;
	    break;
	  }
      if (i == -1)
	*dbuf++ = '\b';
      else
	Phone_redisplay();
      return dbuf;
    case 27:
      if (parn != 0)
	{
	  for(i=0;i<4;i++)
	    mbuf[i] = 255;
	  Phone_redisplay();
	  clear_inputmethod();
	  clearslot_inputmethod();
	  parn = 0;
	}
      else
	*dbuf++ = c;
      return dbuf;
    case 255:
      bakparn = parn;
      parn = 3;
      return dbuf;
    default:
      cc = toupper(c);
      if (cc >= 128)
	*dbuf++ = c;
      else
	{
	  if (phonetr[0][cc] != 255)
	    {
	      mbuf[0] = cc;
	      parn = 1;
	    }
	  else if (phonetr[1][cc] != 255)
	    {
	      mbuf[1] = cc;
	      parn = 1;
	    }
	  else if (phonetr[2][cc] != 255)
	    {
	      mbuf[2] = cc;
	      parn = 1;
	    }
	  else if (phonetr[3][cc] != 255)
	    {
	      parn = 1;
	      mbuf[3] = cc;
	      Phone_redisplay();
	      for(i=0;i<PhoneTableSize;i++)
		if (memcmp(mbuf,PhoneTable[i].seqs,4)==0)
		  break;
	      if (i == PhoneTableSize)
		{
		  alert_inputmethod();
		  for(i=0;i<4;i++)
		    mbuf[i] = 255;
		  error_inputmethod();
		  clear_inputmethod();
		  clearslot_inputmethod();
		  parn = 0;
		}
	      else
		{
		  parn = 5;
		  starti = firstmatch = i;
		  Phone_display();
		  /* if there is only one word match this pattern,
		  ** send it immediately
		  */
		  if (memcmp(mbuf,PhoneTable[i+1].seqs,4)!=0)
		    {
		      return Phone_select(dbuf,'1');
		    }
		  return dbuf;
		}
	    }
	  else
	    *dbuf++ = c;
	}
      Phone_redisplay();
      
      return dbuf;
    }
}
	  
static void Phone_display()
{
  int i;

  clearslot_inputmethod();

  for(i=0;i<9;i++)
    if (memcmp(PhoneTable[starti+i].seqs,mbuf,4)!=0)
      break;
    else
      {
	mloc[i] = PhoneTable[starti+i].chinese.big5;
	slot_inputmethod(i,mloc[i]);
      }
       
  if (i == 9)
    starti += 9;
  else
    starti = firstmatch;
  parn = 6+i;
}

static CHAR *Phone_select(CHAR *dbuf,CHAR c)
{
  int i;

  switch(c)
    {
    case ' ':
      Phone_display();
      return dbuf;
    case 27:
    case 127:
      for(i=0;i<4;i++)
	mbuf[i] = 255;
      Phone_redisplay();
      clear_inputmethod();
      clearslot_inputmethod();
      parn = 0;
      return dbuf;
    case 255:
      bakparn = parn;
      parn = 3;
      break;
    default:
      if (c >='1' && c <='9')
	if (c-'1'< parn-6)
	  {
	    c = c-'1';
	    if (mule)
	      {
		if (ch_codesystem() == CODE_BIG5)
		  {
		    int b1,b2,ccc;
		    b1 = ((CHAR *)&mloc[c])[1];
		    b2 = *(CHAR*)&mloc[c];
		    ccc = (b1-0xa1)*(0xff-0xa1+0x7f-0x40)+b2-
		          (b2<0x7f? 0x40:0x62);
		    *dbuf++=27;*dbuf++='$';*dbuf++='(';
		    if (ch_codesystem() == CODE_BIG5)
		      if (mloc[c] >= 0xc6a1)
			*dbuf++ = '1';
		      else
			*dbuf++ = '0';
		    *dbuf++ = ccc / (0xff-0xa1)+0x21;
		    *dbuf++ = (ccc % (0xff-0xa1))+0x21;
		    *dbuf++=27;*dbuf++='(';*dbuf++='B';
		    for(i=0;i<4;i++)
		      mbuf[i] = ' ';
		    clearslot_inputmethod();
		    Phone_redisplay();
		    parn = 0;
		    return dbuf;
		  }
	      }

	    *dbuf++ = ((CHAR *)&mloc[c])[1];
	    *dbuf++ = *(CHAR *)&mloc[c];
	    for(i=0;i<4;i++)
	      mbuf[i] = 255;
	    clearslot_inputmethod();
	    clear_inputmethod();
	    Phone_redisplay();
	    parn = 0;
	    return dbuf;
	  }
      *dbuf++ = c;
      return dbuf;
    }
}
      
static void Phone_redisplay()
{

  if (mbuf[0] == 255)
    show_inputmethod(0xa140,0);
  else
    show_inputmethod(char_to_phone[phonetr[0][mbuf[0]]],0);
  if (mbuf[1] == 255)
    show_inputmethod(0xa140,1);
  else
    show_inputmethod(char_to_phone[phonetr[1][mbuf[1]]+21],1);
  if (mbuf[2] == 255)
    show_inputmethod(0xa140,2);
  else
    show_inputmethod(char_to_phone[phonetr[2][mbuf[2]]+24],2);
  if (mbuf[3] == 255)
    show_inputmethod(0xa140,3);
  else
    show_inputmethod(char_to_phone[phonetr[3][mbuf[3]]+37],3);
}
      
static char phone_v[] = "1QAZ2WSXEDCRFV5TGBYHN";
static char phone_j1[] = "UJM";
static char phone_j2[] = "8IK,9OL.0P;/-";
static char phone_k[] = "7 634";

static void Phone_loadtable()
{
  int i,j;
  char *phone;
  FILE *in;
  unsigned char buf[128];
  char cc[128][4],*dd;

  phone = getenv("PHONETABLE");
  if (phone == NULL)
    phone = CHSYS"phone.def";
  in = fopen(phone,"r");
  if (in == NULL)
    {
      fprintf(debugfile,"Can't load phone table %s\n",phone);
      PhoneTable = NULL;
      return;
    }
  fprintf(debugfile,"klsdfjgeiowfjopwefjkpow\n");
  memset(phonetr,255,128*4);
  dd = phone_v;
  mul1=0;
  while(*dd)
    phonetr[0][*dd++] = mul1++;
  dd = phone_j1;
  i = 0;
  while(*dd)
    phonetr[1][*dd++] = i++;
  dd = phone_j2;
  mul2 = 0;
  while(*dd)
    phonetr[2][*dd++] = mul2++;
  dd = phone_k;
  i = 0;
  while(*dd)
    phonetr[3][*dd++] = i++;
  
  
  PhoneTable = (PHONE *) malloc(sizeof(PHONE)*20000);
  if (PhoneTable == NULL)
    {
      fprintf(debugfile,"Out of memory in allocate phone table\n");
      return;
    }
  i = 0;
  while(fgets(buf,100,in))
    {
      buf[0] = toupper(buf[0]);
      buf[1] = toupper(buf[1]);
      buf[2] = toupper(buf[2]);
      if (buf[0] == ' ')
	buf[0] = 255;
      if (buf[1] == ' ')
	buf[1] = 255;
      if (buf[2] == ' ')
	buf[2] = 255;

      memcpy(PhoneTable[i].seqs,buf,4);
      PhoneTable[i].chinese.code[0] = buf[6];
      PhoneTable[i].chinese.code[1] = buf[5];
      i++;
    }
  PhoneTableSize = i;
  fclose(in);
  PhoneTable = (PHONE *) realloc(PhoneTable,i*sizeof(PHONE));
  if (phone = getenv("PHONETIC_KBD"))
    {
      sprintf(buf,CHSYS"%s",phone);
      in = fopen(buf,"r");
      fprintf(debugfile,"Set Keyboard to %s\n",buf);
      if (in != NULL)
	{
	  if (fread(buf,21+3+13+5,1,in))
	    {
	      fprintf(debugfile,"Read entry from it\n");
	      for(i=0;i<128;i++) for(j=0;j<4;j++)
		cc[j][i] = phonetr[j][i];
	      for(i=0;i<21;i++)
		  phonetr[0][buf[i]] = i;
	      for(i=21;i<24;i++)
		phonetr[1][buf[i]] = i - 21;
	      for(i=24;i<37;i++)
		phonetr[2][buf[i]] = i - 24;
	      for(i=37;i<42;i++)
		phonetr[3][buf[i]] = i - 37;
	    }
	}
      fclose(in);
    }
  fprintf(debugfile,"Phone table loaded size = %d\n",PhoneTableSize);
}








