#define CHINESE_SYSTEM
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stdarg.h>
#include <string.h>
#include "chinese.h"
struct termstatus{
  int inverted:1;
  int underline:1;
  int bold:1;
  int color;
  int scroll_upper,scroll_lower;
  int ox,oy;
  int state,esc_state;
  char cmdbuf[100];
  int cmdlen;
} _termstate[CONS_NUM] = {{0,0,0,0,0,0,0}},*termstate;
#define max(a,b) (((a) > (b))? (a):(b))
#define min(a,b) (((a) > (b))? (b):(a))

#define NORMAL 0
#define ESC    1
#define BRA    2
#define SEND   3
#define RSEND  4
#define LINE   5
#define CHINESE 6
  
#define PARN   1
#define INIT   2

static void state_esc(char c);
static void state_bra(int,char c);
static void save_cursor(),restore_cursor();
static void set_attribute();
static void state_collect(char c);
static void reset_con(struct termstatus *);
static int chconsole;
void con_init();

void con_init()
{
  int i;
  termstate = &_termstate[0];
  chconsole = 0;
  for(i=0;i<CONS_NUM;i++)
    {
      reset_con(_termstate+i);
    }
}

static void reset_con(struct termstatus *term)
{
  term->inverted = term->underline = 0;
  term->color = 15;
  term->scroll_upper = 0;
  term->scroll_lower = ch_DimY()-1;
  term->ox = termstate->oy = 0;
  term->cmdlen = 0;
}
Read_Output_Config()
{
}


int con_change_console(int con)
{
  termstate = &(_termstate[con]);
  chconsole = con;
}
int _cwrite(int con,const char *buf,int len)
{
  int i;
#ifdef CODE_TRANSPORT
  char *buf1,bbuf[256];
#endif
  
  _ch_swap_console(con);
#ifdef CODE_TRANSPORT
  buf1 = buf;buf = bbuf;
  code_transport(con,bbuf,buf1);
#endif

#if 0
  {
      extern FILE *stddebug;

      fprintf(stddebug,"@{");
      fwrite(buf,1,len,stddebug);
      fprintf(stddebug,"@}");
      fflush(stddebug);
  }
#endif
  for(i=0;i<len;i++,buf++)
    {
      switch(termstate->state) 
	{
	case ESC:
	  state_esc(*buf);
	  continue;
	case BRA:
	  state_bra(con,*buf);
	  continue;
	case SEND:
	  printf("\033(%c",*buf);
	  break;
	case RSEND:
	  printf("\033)%c",*buf);
	  break;
	case LINE:
	  /* NO FUNCTION */
	  break;
	case CHINESE:
	  state_collect(*buf);
	  continue;
	default:
	  if (*buf == 27)
	    {
	      termstate->state = ESC;
	      continue;
	    }
	  else
	    ch_showch(*buf);
	}
      termstate->state = NORMAL;
    }
  _ch_swap_console(-1);
  return len;
}

static void state_collect(char c)
{
  extern void chinese_command(char c);
  int i;

  if ( (c != '\n')&&(c!= '@'))
    {
      if (termstate->cmdlen < 100)
	termstate->cmdbuf[termstate->cmdlen++] = c;
    }
  else
    {
      for(i=0;i<termstate->cmdlen;i++)
	{
	  chinese_command(termstate->cmdbuf[i]);
	  printf("%c\n",termstate->cmdbuf[i]);
	}
      termstate->cmdlen = 0;
      termstate->state = NORMAL;
    }
}

  
static void state_esc(char c)
{
  /* Control char can be use in escape sequence */
  if (c < 32)
    {
      ch_showch(c);
      return;
    }
  switch(c)
    {
    case '[':
      termstate->state = BRA;
      return;
    case '(':
      termstate->state = SEND;
      return;
    case ')':
      termstate->state = RSEND;
      return;
    case '<':
      /* ANSI mode */
      break;
    case '#':
      /* NO FUNCTION*/
      termstate->state = LINE;
      return;
    case '%':
      termstate->state = CHINESE;
      return;
    case '*':
      reset_con(termstate);
      break;
    case 'c':
      con_init();
      break;
    case 'D':
      ch_scroll(termstate->scroll_upper,termstate->scroll_lower,1);
      break;
    case 'E':
      ch_gotoxy(0,min(ch_wherey()+1,ch_DimY()-1));
      break;
    case 'M':
      ch_rscroll(termstate->scroll_upper,termstate->scroll_lower,1);
      break;
    case '7':
      save_cursor();
      break;
    case '8':
      restore_cursor();
      break;
    case 'Z': /* Respond to terminal identify (VT102) */
      /* NO FUNCTION */
      break;
    case '=':
      /*dump_screen();*/
    }
  termstate->state = NORMAL;
  termstate->esc_state = NORMAL;
}

static void save_cursor()
{
  termstate->ox = ch_wherex();
  termstate->oy = ch_wherey();
}

static void restore_cursor()
{
  ch_gotoxy(termstate->ox,termstate->oy);
}

/*
   prototype in input.c
 */

void input_insert_left(int);  
void input_insert_right(int);
void input_nsert_any(int);

static void state_bra(int con,char c)
{
  static int par[16]={0,0},parn=0,cm,i;


  if (termstate->esc_state == NORMAL)
    if ((c>='0') && (c <='9'))
      {
	parn = 1;
	termstate->esc_state = PARN;
      }

  if ((c >='0') && (c <= '9'))
    {
      par[parn-1] = par[parn-1]*10 + c - '0';
      return;
    }
  else 
    {
      if (termstate->esc_state == INIT)
	{
	  switch(c)
	    {
	    case 'l':
	      ch_have_cursor(0);
	      break;
	    case 'h':
	      ch_have_cursor(1);
	      break;
	    }
	}
      else
	{
	  switch(c)
	    {
	    case ';':
	      parn++;
	      par[parn-1]=0;
	      return;
	    case 'c': /* Request terminal to identify itself */
	      /* NO FUNCTION */
	      break;
	      
	    case 'i':
	      /* NO FUNCTION */
	      break;
	    case 'q':
	      /* NO FUNCTION */
	      break;
	    case  'r':
	      if (parn == 2)
		{
		  if (!par[0])
		    par[0]++;
		  if (par[1] - par[0] < 2)
		    par[1] = par[0]+2;
		  ch_setscroll(par[0]-1,par[1]-1);
		  termstate->scroll_upper = par[0]-1;
		  termstate->scroll_lower = par[1]-1;
		  ch_gotoxy(0,0);
		}
	      break;
	    case 'm':
	      if (parn > 0)
		for(i=0;i<parn;i++)
		  set_attribute(par[i]);
	      else
		set_attribute(0);

	      break;
	      
	    case 'g':
	      /* NO FUNCTION */
	      break;
	    case 'A':
	      if (parn == 0)
		cm = 1;
	      else
		cm = par[0];
	      ch_gotoxy(ch_wherex(),max(ch_wherey()-cm,0));
	      break;
	    case 'B':
	      if (parn == 0)
		cm = 1;
	      else
		cm = par[0];
	      ch_gotoxy(ch_wherex(),min(ch_wherey()+cm,ch_DimY()-1));
	      
	      break;
	    case 'C':
	      if (parn == 0)
		cm = 1;
	      else
		cm = par[0];
	      ch_gotoxy(min(ch_wherex()+cm,ch_DimX()-1),ch_wherey());
	      if (ch_needadjust(con))
		input_insert_any(con);
	      SYSERR("right insert");
	      break;
	    case 'G':
	      if (parn == 0)
		cm = 1;
	      else
		cm = par[0];

	      ch_gotoxy(cm-1,ch_wherey());
	      if (ch_needadjust(con))
		input_insert_any(con);
	      SYSERR("right insert");
	      break;
	    case 'D':
	      if (parn == 0)
		cm = 1;
	      else
		cm = par[0];
	      ch_gotoxy(max(ch_wherex()-cm,0),ch_wherey());
	      if (ch_needadjust(con))
		input_insert_any(con);
	      SYSERR("left insert");
	      break;
	    case 'J':
	      if (parn == 0|| (parn == 1&& par[0]==0))
		ch_clearblock(0,ch_wherey(),ch_DimX()-1,ch_DimY()-1);
	      else if (parn == 1)
		{
		  if (par[0] == 1)
		    ch_clearblock(0,0,ch_DimX()-1,ch_wherey()-1);
		  else if (par[0] == 2)
		    {
		      ch_clearblock(0,0,ch_DimX()-1,ch_DimY()-1);
		      ch_gotoxy(0,0);
		    }
		}
	      break;
	      /* through pass */
	    case 'K':
	      if (parn == 0|| (parn == 1&& par[0]==0))
		ch_clearblock(ch_wherex(),ch_wherey(),ch_DimX()-1,ch_wherey());
	      else if (parn == 1)
		{
		  if (par[0] == 1)
		    ch_clearblock(0,ch_wherey(),ch_wherex(),ch_wherey());
		  else if (par[0] == 2)
		    ch_clearblock(0,ch_wherey(),ch_DimX()-1,ch_DimY()-1);
		}
	      break;
	    case 'L':
	      if (parn == 0||(parn == 1 && par[0]==0))
		ch_insertline();
	      else if (parn == 1)
		{
		  for(i=0;i<par[0];i++)
		    ch_insertline();
		}
	      break;
	    case 'H':
	      if (parn == 0)
		ch_gotoxy(0,0);
	      else 
		{
		  if (parn == 1)
		    par[1] = 1;
		  ch_gotoxy(par[1]-1,par[0]-1);
		}
	      if (ch_needadjust(con))
		input_insert_any(con);
	      SYSERR("insert any");
	      break;
	    case 'd':
	      if (parn == 0)
		cm = 0;
	      else
		cm = par[0]-1;
	      ch_gotoxy(ch_wherex(),cm);
	      if (ch_needadjust(con))
		input_insert_any(con);
	      SYSERR("left insert");
	      break;
	
	    case 'M':
	      if (parn == 0 || (parn==1 && par[0] == 0))
		par[0] = 1;
	      for(i=0;i<par[0];i++)
		ch_deleteline();
	      break;
	    case 'P':
	      if (parn==0 || (parn==1 && par[0]==0))
		ch_deletechar();
	      else
		{
		  for(i=0;i<par[0];i++)
		    ch_deletechar();
		}
	      break;
	    case 'Y': /* SELF TEST */
	      /* NO FUNCTION */
	      break;
	    case '@':
	      if (parn==0)
		ch_insertchar();
	      else
		{
		  if (par[0]==0)
		    par[0] = 1;
		  for(i=0;i<par[0];i++)
		    ch_insertchar();
		}
	      break;
	      
	    case '=':
	      printf("\033=");
	      break;
	    case '>':
	      printf("\033>");
	      break;
	    case '?':
	      termstate->esc_state = INIT;
	      return;
	    }
	}
      termstate->state = NORMAL;
      termstate->esc_state = NORMAL;
      parn = 0;
      par[0] = par[1] = 0;
    }
}
	  
static void set_attribute(int p1)
{

  switch(p1)
    {
    case 0:
      termstate->inverted = 0;
      termstate->underline = 0;
      ch_invert(0);
      ch_underline(0);
      ch_ansicolor(-3,0);
      break;
    case 1:
      ch_ansicolor(-2,0);
      break;
    case 4:
      ch_underline(1);
      termstate->underline = 0;
      break;
    case 7:
      ch_invert(1);
      termstate->inverted = 1;
      break;
    case 10:
      ch_disablealternative();
      break;
    case 11:
      ch_enablealternative();
      break;
    case 24:
      ch_underline(0);
      termstate->underline = 0;
      break;
    case 27:
      ch_invert(0);
      termstate->inverted = 0;
      break;
    default:
      if ((p1 >=30) && (p1 <= 37))
	{
	  SYSERR1("New foreground %d\n",p1-30);
	  ch_ansicolor(p1-30,-1);
	}
      else if ((p1 >=40) &&(p1<=47))
	{
	  ch_ansicolor(-1,p1-40);
	}
    }
}
