/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 * GtkColorButton Copyright (C) 2000 Stefan Ondrejicka <ondrej@idata.sk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GTK_COLOR_BUTTON_H__
#define __GTK_COLOR_BUTTON_H__

#include <gtk/gtkbutton.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_TYPE_COLOR_BUTTON		(gtk_color_button_get_type ())
#define GTK_COLOR_BUTTON(obj)		(GTK_CHECK_CAST ((obj), GTK_TYPE_COLOR_BUTTON, GtkColorButton))
#define GTK_COLOR_BUTTON_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_COLOR_BUTTON, GtkColorButtonClass))
#define GTK_IS_COLOR_BUTTON(obj)	(GTK_CHECK_TYPE ((obj), GTK_TYPE_COLOR_BUTTON))
#define GTK_IS_COLOR_BUTTON_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_COLOR_BUTTON))

typedef struct _GtkColorButton		GtkColorButton;
typedef struct _GtkColorButtonClass	GtkColorButtonClass;

struct _GtkColorButton
{
	GtkButton	button;

	GdkColor	color;
	GtkWidget	*preview;
	GtkWidget	*colorsel;
	gchar		*title;

	gboolean	had_colorsel;
};


struct _GtkColorButtonClass
{
	GtkButtonClass	parent_class;

	void (* color_changed)  (GtkColorButton *cbutton);
};


GtkType		gtk_color_button_get_type	(void);
GtkWidget*	gtk_color_button_new		(void);
void		gtk_color_button_set_title	(GtkColorButton *cbutton, gchar *title);
void		gtk_color_button_set_color	(GtkColorButton *cbutton, GdkColor *color);
void		gtk_color_button_get_color	(GtkColorButton *cbutton, GdkColor *color);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_COLOR_BUTTON_H__ */

