/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999 - 2001 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "config.h"
#include "absimg.h"

static banner_t *banner_find(name)
char *name;
{
	GList *ptr;

	if ((!strcasecmp(name, "random") ||
	     !strcmp(name, gettext("Random"))) &&
	     cfg.banners)
	{
		int n = g_list_length(cfg.banners);

		n = chbg_rand()%n;

		return (banner_t *) (g_list_nth(cfg.banners, n))->data;
	}

	for (ptr = cfg.banners; ptr; ptr = ptr->next)
	{
		banner_t *bn = ptr->data;

		if (!strcmp(bn->name, name))
			return bn;
	}

	return NULL;
}

static void banner_effect_pixel(bg, fg, rx, ry, ix, iy, effect)
absimg_rgb_t *bg;
absimg_rgb_t *fg;
int rx;
int ry;
int ix;
int iy;
int effect;
{
	int tmp;
	int ri = ry * 3 * bg->width + 3 * rx;
	int ii = iy * 3 * fg->width  + 3 * ix;
	int bgr,bgg,bgb;
	int or,og,ob;
	int fgr,fgg,fgb,fga;

	bgr = bg->rgb[ri];
	bgg = bg->rgb[ri+1];
	bgb = bg->rgb[ri+2];

	fgr = fg->rgb[ii];
	fgg = fg->rgb[ii+1];
	fgb = fg->rgb[ii+2];
	if (fg->alpha)
		fga = fg->alpha[iy * fg->width + ix];
	else
		fga = 255;

	switch (effect)
	{
	    /* average */
	    case 1:
		or = (bgr + fgr) / 2;
		og = (bgg + fgg) / 2;
		ob = (bgb + fgb) / 2;
	    break;
	    /* lighten only */
	    case 2:
		or = MAX(bgr, fgr);
		og = MAX(bgg, fgg);
		ob = MAX(bgb, fgb);
	    break;
	    /* darken only */
	    case 3:
		or = MIN(bgr, fgr);
		og = MIN(bgg, fgg);
		ob = MIN(bgb, fgb);
	    break;
	    /* divide */
	    case 4:
		or = MIN(255, (bgr * 256) / (1 + fgr));
		og = MIN(255, (bgg * 256) / (1 + fgg));
		ob = MIN(255, (bgb * 256) / (1 + fgb));
	    break;
	    case 5:
		or =  (bgr * fgr) >> 8;
		og =  (bgg * fgg) >> 8;
		ob =  (bgb * fgb) >> 8;
	    break;
	    /* change level */
	    case 6:
		tmp = (bgr + bgg + bgb) / 3;
		or =  (tmp * fgr) >> 8;
		og =  (tmp * fgg) >> 8;
		ob =  (tmp * fgb) >> 8;
	    break;
	    /* change level2 */
	    case 7:
		tmp = (fgr + fgg + fgb) / 3;
		or = (tmp * bgr) >> 8;
		og = (tmp * bgg) >> 8;
		ob = (tmp * bgb) >> 8;
	    break;
	    /* add */
	    case 8:
		or = MIN(255, bgr + fgr);
		og = MIN(255, bgg + fgg);
		ob = MIN(255, bgb + fgb);
	    break;
	    /* subtract bg */
	    case 9:
		or = MAX(0, fgr - bgr);
                og = MAX(0, fgg - bgg);
                ob = MAX(0, fgb - bgb);
	    break;
	    /* subtract fg */
	    case 10:
		or = MAX(0, bgr - fgr);
                og = MAX(0, bgg - fgg);
                ob = MAX(0, bgb - fgb);
	    break;
	    case 11:
		tmp = (fgr + fgg + fgb)/3;
		or = tmp;
		og = tmp;
		ob = tmp;
	    break;
	    default:
		or = fgr;
		og = fgg;
		ob = fgb;
	    break;
	}

	if (fg->alpha)
	{
		ABSIMG_ALPHA(or, bgr, fga);
		ABSIMG_ALPHA(og, bgg, fga);
		ABSIMG_ALPHA(ob, bgb, fga);
		or = bgr;
		og = bgg;
		ob = bgb;
	}

	bg->rgb[ri] = (unsigned char)or;
	bg->rgb[ri+1] = (unsigned char)og;
	bg->rgb[ri+2] = (unsigned char)ob;
}

void banner_effect(bg, fg, x, y, effect)
absimg_rgb_t *bg;
absimg_rgb_t *fg;
int x;
int y;
int effect;
{
	int rx,ry,ix,iy;

	for (iy = MAX(0, -y), ry = MAX(0, y);
	     iy < fg->height && ry < bg->height;
	     iy++, ry++)
	{
		for (ix = MAX(0, -x), rx = MAX(0, x);
		     ix < fg->width && rx < bg->width;
		     ix++, rx++)
		{
			banner_effect_pixel(bg, fg, rx, ry, ix, iy, effect);
		}
	}
}

/*
 * bumpmap effect based on GIMP bumpmap plug-in sources from gimp1.2 by 
 *
 * Copyright (C) 1997 Federico Mena Quintero <federico@nuclecu.unam.mx>
 * Copyright (C) 1997-2000 Jens Lautenbacher <jtl@gimp.org>
 * Copyright (C) 2000 Sven Neumann <sven@gimp.org>
 */

static void banner_bumpmap_row(bg, alpha, inbm, width, row1, row2, row3, emboss)
unsigned char *bg;
unsigned char *alpha;
int inbm;
int width;
unsigned char *row1;
unsigned char *row2;
unsigned char *row3;
gboolean emboss;
{
	int xofs1;
	int xofs2;
	int xofs3;
	int nx,ny,nz,x;
	int shade;
	int lx,ly,lz;

	lx = -133;
	ly = 11;
	lz = 230;
	nz = 256;

	xofs1 = 0;
	xofs2 = 3;
	xofs3 = 6;

	for (x = 0; x < width; x++)
	{
		if (inbm && (x < width - 2))
		{
			nx = row1[xofs1] + row2[xofs1] + row3[xofs1] -
				row1[xofs3] - row2[xofs3] - row3[xofs3];
			ny = row3[xofs1] + row3[xofs2] + row3[xofs3] -
				row1[xofs1] - row1[xofs2] - row1[xofs3];
		}
		else
		{
			nx = 0;
			ny = 0;
		}

		if (!nx && !ny)
			shade = lz;
		else
		{
			int ndotl = nx * lx + ny * ly + nz*lz;

			if (ndotl < 0)
				shade = 0;
			else
				shade = ndotl / sqrt(nx*nx + ny*ny + nz*nz);
		}
		if (emboss)
		{
			bg[3*x] = shade;
			bg[3*x+1] = shade;
			bg[3*x+2] = shade;
		}
		else
		{
			if (alpha)
			{
				ABSIMG_ALPHA(((bg[3*x] * shade) >> 8),
					bg[3*x], alpha[x]);
				ABSIMG_ALPHA(((bg[3*x+1] * shade) >> 8),
					bg[3*x+1], alpha[x]);
				ABSIMG_ALPHA(((bg[3*x+2] * shade) >> 8),
					bg[3*x+2], alpha[x]);
			}
			else
			{
				bg[3*x] = (bg[3*x] * shade) >> 8;
				bg[3*x+1] = (bg[3*x+1] * shade) >> 8;
				bg[3*x+2] = (bg[3*x+2] * shade) >> 8;
			}
		}
		xofs1 += 3;
		xofs2 += 3;
		xofs3 += 3;
		if (xofs1 == 3*width)
			xofs1 = 0;
		if (xofs2 == 3*width)
			xofs2 = 0;
		if (xofs3 == 3*width)
			xofs3 = 0;
	}

}

void banner_bumpmap(bg, fg, x, y, emboss)
absimg_rgb_t *bg;
absimg_rgb_t *fg;
int x;
int y;
gboolean emboss;
{
	int ry,iy;
	int bx,by,bofs;
	int sx,sy,sofs;
	int width;
	unsigned char *row1;
	unsigned char *row2;
	unsigned char *row3;

	if (fg->height < 4 || fg->width < 4 || bg->width < 4 || fg->width < 4)
		return;

	sx = MAX(0, x);
	sofs = sy = MAX(0, y);

	bofs = by = MAX(0, -y);
	bx = MAX(0, -x);
	width = MIN(fg->width, bg->width);

	row1 = fg->rgb + 3 * fg->width * bofs + 3 * bx;
	row2 = fg->rgb + 3 * fg->width * (bofs+1) + 3 * bx;
	row3 = fg->rgb + 3 * fg->width * (bofs+2) + 3 * bx;

        for (iy = by, ry = sy;
             iy < fg->height && ry < bg->height;
             sofs++, bofs++, iy++, ry++)
        {
		int inbm = ((bofs+2) <= fg->height);

		banner_bumpmap_row(bg->rgb + (3*sofs*bg->width + 3*sx),
			fg->alpha ? (fg->alpha + bofs * fg->width + bx) : NULL,
				   inbm, width, row1, row2, row3, emboss);

		row1 = row2;
		row2 = row3;
		row3 = fg->rgb + 3 * fg->width * (inbm ? (bofs+2) : 0) + 3 * bx;
	}
}

void banner_render_to_rgb(rgb, banner_name)
absimg_rgb_t *rgb;
char *banner_name;
{
	banner_t *bn;
	banner_prop_t *bprop;
	absimg_image_t *img;
	gfloat ratio;
	int pw, ph;

	bn = banner_find(banner_name);
	if (bn && bn->prop)
		bprop = bn->prop;
	else
		bprop = &cfg.properties.banner_prop;

	if (bn)
		banner_name = bn->name;

	img = absimg_load(banner_name);
	if (!img)
		return;

	ratio = MIN((gfloat)((rgb->width * bprop->max_size)/100.0) / (gfloat)img->rgb_width ,
		    (gfloat)((rgb->height * bprop->max_size)/100.0) / (gfloat)img->rgb_height);
	ratio = MIN(bprop->max_grow, ratio);

	pw = (guint)(ratio * img->rgb_width);
	ph = (guint)(ratio * img->rgb_height);

	if (!bprop->mode)
		absimg_render_to_rgb(rgb, img, pw, ph, bprop->xpos, bprop->ypos);
	else
	{
		absimg_rgb_t *trgb;
		absimg_image_t *timg;
		int x,y;

		x = (int) ((gfloat)(rgb->width - pw) * bprop->xpos);
		y = (int) ((gfloat)(rgb->height - ph) * bprop->ypos);

		timg = absimg_scale(img, pw, ph);
		trgb = absimg_to_rgba(timg);
		absimg_destroy(timg);

		if (bprop->mode == 12)
		{
			absimg_rgb_grayfy(trgb);
			banner_bumpmap(rgb, trgb, x, y, FALSE);
		}
		else if (bprop->mode == 13)
		{
			banner_effect(rgb, trgb, x, y, 0);
			absimg_rgb_grayfy(trgb);
			banner_bumpmap(rgb, trgb, x+1, y+1, FALSE);
		}
		else if (bprop->mode == 14)
		{
			absimg_rgb_grayfy(trgb);
			banner_bumpmap(rgb, trgb, x, y, TRUE);
		}
		else
			banner_effect(rgb, trgb, x, y, bprop->mode);

		absimg_rgb_free(trgb);
	}

	absimg_destroy(img);
}

