/*
 * libusb example program for hotplug API
 * Copyright (C) 2012-2013 Nathan Hjelm <hjelmn@mac.ccom>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <stdlib.h>
#include <stdio.h>
#include <sched.h>
#include <unistd.h>

#include <libusb.h>

int done = 0;
libusb_device_handle *handle;

static int hotplug_callback (libusb_context *ctx, libusb_device *dev, libusb_hotplug_event event, void *user_data) {
  struct libusb_device_descriptor desc;
  int rc;

  rc = libusb_get_device_descriptor(dev, &desc);
  if (LIBUSB_SUCCESS != rc) {
    fprintf (stderr, "Error getting device descriptor\n");
  }

  printf ("Device attach: %04x:%04x\n", desc.idVendor, desc.idProduct);

  libusb_open (dev, &handle);

  done++;

  return 0;
}

static int hotplug_callback_detach (libusb_context *ctx, libusb_device *dev, libusb_hotplug_event event, void *user_data) {
  printf ("Device detached\n");

  libusb_close (handle);

  done++;
  return 0;
}

int main (int argc, char *argv[]) {
  libusb_hotplug_callback_handle hp[2];
  int product_id, vendor_id, class_id;
  int rc;

  vendor_id  = (argc > 1) ? strtol (argv[1], NULL, 0) : 0x045a;
  product_id = (argc > 2) ? strtol (argv[2], NULL, 0) : 0x5005;
  class_id   = (argc > 3) ? strtol (argv[3], NULL, 0) : LIBUSB_HOTPLUG_MATCH_ANY;

  libusb_init (NULL);

  if (!libusb_has_capability (LIBUSB_CAP_HAS_HOTPLUG)) {
    printf ("Hotplug not supported by this build of libusb\n");
    libusb_exit (NULL);
    return EXIT_FAILURE;
  }

  rc = libusb_hotplug_register_callback (NULL, LIBUSB_HOTPLUG_EVENT_DEVICE_ARRIVED, 0, vendor_id,
                                         product_id, class_id, hotplug_callback, NULL, &hp[0]);
  if (LIBUSB_SUCCESS != rc) {
    fprintf (stderr, "Error registering callback 0\n");
    libusb_exit (NULL);
    return EXIT_FAILURE;
  }

  rc = libusb_hotplug_register_callback (NULL, LIBUSB_HOTPLUG_EVENT_DEVICE_LEFT, 0, vendor_id,
                                         product_id,class_id, hotplug_callback_detach, NULL, &hp[1]);
  if (LIBUSB_SUCCESS != rc) {
    fprintf (stderr, "Error registering callback 1\n");
    libusb_exit (NULL);
    return EXIT_FAILURE;
  }

  while (done < 2) {
    libusb_handle_events (NULL);
  }

  libusb_exit (NULL);
}
