#
#    Copyright (C) 2007 Marco Ferragina <marco.ferragina@gmail.com>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import gtk

from statuslistener import StatusListener

from lib.gconfhelper import GconfHelper
from lib import utils
from lib import resources
from lib.utils import log
from lib.common import *
import pynotify

class StatusNotifier(StatusListener):

	capabilities = {'actions':             False,
	                'body':                False,
	                'body-hyperlinks':     False,
	                'body-images':         False,
	                'body-markup':         False,
	                'icon-multi':          False,
	                'icon-static':         False,
	                'sound':               False,
	                'image/svg+xml':       False,
	                'private-synchronous': False,
	                'append':              False,
	                'private-icon-only':   False
					}

	def __init__(self, crunner):
		StatusListener.__init__(self, crunner)
		pynotify.init("cGmail")

	def initCaps (self):
	        caps = pynotify.get_server_caps ()
	        if caps is None:
	                log("Failed to receive server caps.")
	                sys.exit (1)
	
	        for cap in caps:
	                self.capabilities[cap] = True
	
	def on_status_changed(self, crunner, checker):
		gtk.gdk.threads_enter()

		status = checker.get_status()
		if status["count"] > 0 \
			and status["description"].strip() != "" and status["title"].strip() != "":

			mustnotify = GconfHelper().get_key("display_notifications")
			if mustnotify:
				content = "\342\200\242 " + \
							status["title"] + \
							"\n" + status["description"]
				notifier = pynotify.Notification("cGmail", content,
				 "notification-message-email")
				if self.capabilities["actions"]:
					notifier.set_actions(checker.get_notifier_actions())
				notifier.show()
				
			mustplaysound = GconfHelper().get_key("play_sounds_on_new_mails")
			if mustplaysound:
				utils.playsnd(resources.get_data_file("notify.wav"))

			runcommand = GconfHelper().get_key("exec_command")
			if runcommand:
				cmd = GconfHelper().get_key("new_mail_command")
				if cmd != "":
					utils.invoke_subprocess(cmd.split())

		gtk.gdk.threads_leave()

