import urllib2 

from lib.common import *
from basechecker import BaseChecker
from lib import feedparser

class GmailChecker(BaseChecker):
	def __init__(self, notifier, account_id, status_cb, user, password):
		self.username = user
		self.password = password
		self.notified = []
		BaseChecker.__init__(self, notifier, account_id, status_cb)
	
	def reset(self):
		# do not reset while checking
		if self.checking: return
		self.notified = []

	def getfeed(self):
		ah = urllib2.HTTPBasicAuthHandler()
		ah.add_password('New mail feed', GMAIL_URL, \
					self.username, self.password)
		op = urllib2.build_opener(ah)
		urllib2.install_opener(op)
		res = urllib2.urlopen(GMAIL_ATOM_URL)
		return ''.join(res.readlines())
	
	def update_info(self, account):
		self.username = account["username"]
		self.password = account["password"]
	
	def check(self):
		"""
		Check for new mails.
		"""
		# prevent recalling
		if self.checking: return
		self.start_check()

		print "BEGIN checking gmail account %s ..." % self.username

		try:
			feed = self.getfeed()
		except urllib2.HTTPError, e:
			if str(e) == "HTTP Error 401: Unauthorized":
				msg = _("Invalid username or password! Please check your settings!")
			else:
				msg = str(e)
			
			error = _("Gmail Error on account %s") % self.username
			self.notify_error(error, msg, True)
			self.stop_check()
			return
		except Exception, e:
			print "Warning:", e
			self.notify_error("Warning", str(e), False)
			self.stop_check()
			return

		try:
			atom = feedparser.parse(feed)
		except Exception, detail:
			print "Warning: Exception while parsing gmail feeds", detail
			self.notify_error(_("Gmail Warning"), _("Exception while parsing gmail feeds", False))
			self.stop_check()
			return

		count = len(atom.entries)
		
		mailbox = "%s@gmail.com" % self.username
		mails = []

		if count == 0:
			self.stop_check()
			self.notify_msg(mailbox, count, mails)
			#return mailbox, 0, mails
			print "END checking gmail account %s ..." % self.username
			return

		if count < MAX_NOTIFIED_MAILS:
			loop = count
		else:
			loop = MAX_NOTIFIED_MAILS
		
		mustnotify = False

		for i in xrange(loop):
			link = atom.entries[i].link
			tmp = link[link.find("message_id"):]
			message_id =  tmp[:tmp.find("&")].split("=")[1]

			if message_id not in self.notified:
				mustnotify = True
				self.notified.append(message_id)
				title  = atom.entries[i].title
				author = atom.entries[i].author
				mails.append([author, title])
		
		if not mustnotify:
			self.notify_msg(mailbox, count, [])
		else:
			self.notify_msg(mailbox, count, mails)

		self.stop_check()

		print "END checking gmail account %s ..." % self.username

