
import gconf
import gnomekeyring

from baseaccountmanager import BaseAccountManager, CannotSaveError

GCONF_AUTH_KEY = "/apps/cgmail/keyring_auth_token"

class KeyringAccounts(BaseAccountManager):
	
	def __init__(self):
		self.accounts_dicts = []
		try:
			self.__retrieve_accounts_dicts()
		except ValueError:
			# 
			pass

	def get_accounts_dicts(self):
		return self.accounts_dicts

	def __retrieve_accounts_dicts(self): 
		keyring = "default"  
		try:  
			gnomekeyring.create_sync(keyring, None)  
		except gnomekeyring.AlreadyExistsError:  
			pass 
	
		auth_token = gconf.client_get_default().get_int(GCONF_AUTH_KEY)
		if auth_token > 0:
			try:
				secret = gnomekeyring.item_get_info_sync(keyring, 
							auth_token).get_secret()
				accounts = secret.split("\n")
				for account in accounts:
					if account == "": continue
					dict = {}
					params = account.split(";")
					for element in params:
						#param, value = element.split("=")
						couple = element.split()
						if len(couple) == 2:
							param = couple[0]
							value = couple[1]
						else:
							param = couple[0]
							value = ""
						dict[param] = value
					self.accounts_dicts.append(dict)
			except gnomekeyring.DeniedError:
				auth_token = 0

	def remove_account(self, id): 
		i = 0
		id = str(id)
		for a in self.accounts_dicts:
			if a["id"] == id:
				break
			i += 1
		del self.accounts_dicts[i]

		self.__store()

	def add_account(self, dic, force_id = None):
		if force_id is None:
			maxid = 0
			for d in self.accounts_dicts:
				if int(d["id"]) > maxid:
					maxid = int(d["id"])

			dic["id"] = str(maxid + 1)
		else:
			dic["id"] = force_id

		self.accounts_dicts.append(dic)
		self.__store()

		return dic["id"]
	
	def reset(self):
		self.accounts_dicts = []
		self.__store()
	
	def __store(self):
		keyring = "default"
		try:
			gnomekeyring.create_sync(keyring, None)
		except gnomekeyring.AlreadyExistsError:
			pass
		
		key = ""

		for dic in self.accounts_dicts:
			for param, value in dic.iteritems():
				if value.find(" ") != -1 or value.find(";") != -1 \
						or value.find("\n") != -1:
					print "Warning: reserved chars founded on ", value
					print "You cannot use '=' or ';' or '\\n'"
					print "trying to strip it"
					value.replace("=", "").replace(";", "").replace("\n", "")
				key += param + " " + value + ";"

			# remove last ";"
			key = key[:len(key) - 1]
			key += "\n"
		# remove last "\n"
		key = key[:len(key) - 1]

		try:
		   	auth_token = gnomekeyring.item_create_sync(
				keyring,
				gnomekeyring.ITEM_GENERIC_SECRET,
				"cgmail checker login informations",
				dict(appname="cgmail, gmail checker"),
				key, True)
			gconf.client_get_default().set_int(GCONF_AUTH_KEY, auth_token)
		except:
			raise CannotSaveError()


if __name__ == "__main__":
	import gtk
	k = KeyringAccounts()
#	k.add_account({"username": "tesiot", "type": "gmail"})
#	k.remove_account(2)
	print k.get_accounts_dicts()
