#include <fenv.h>
#include <stdio.h>

double stop_constant_propagation(double x)
{
    // asm volatile ("" : "+mx"(x)); return x;
    asm volatile ("" : "=m"(x) : "m"(x)); return x;
    // volatile double y = x; return y;   
}

int main()
{
    fesetround(FE_DOWNWARD);
    double lhs = -((-1.1) * stop_constant_propagation(10.1));
    double rhs =  (( 1.1) * stop_constant_propagation(10.1));
    printf( "%s\n", lhs != rhs ? "lhs != rhs (correct)" : "lhs == rhs (error)");
    return lhs != rhs ? 0 : 1;
}
