/* { dg-do run } */
/* { dg-options "-O2" } */

#include <stdio.h>

typedef __attribute__((vector_size(16))) signed int vsi4;
typedef __attribute__((vector_size(16))) unsigned int vui4;
typedef __attribute__((vector_size(16))) float vf4;

union U {
  vsi4 _vsi4;
  vui4 _vui4;
  vf4 _vf4;
  signed int vsi4_a[4];
  unsigned int vui4_a[4];
  float vf4_a[4];
};

int fail;
#define FAIL do { printf ("%c FAILED\n", __func__); fail++; } while (0)

#define TEST_SHIFT(TYPE,NAME,OP) \
void \
do_##TYPE##_##NAME(TYPE a, TYPE b) \
{ \
  union U ua, ub, actual, expected; \
  int i; \
  ua._##TYPE = a; \
  ub._##TYPE = b; \
  actual._##TYPE = (a OP b); \
  for (i = 0; i < 4; i++) \
    expected.TYPE##_a[i] = (ua.TYPE##_a[i] OP ub.TYPE##_a[i]); \
  if (!(actual._##TYPE == expected._##TYPE)) \
  { \
    FAIL; \
    for (i = 0; i < 4; i++) \
      printf ("%x " #OP " %d = actual %x expected %x\n", ua.TYPE##_a[i], ub.TYPE##_a[i], actual.TYPE##_a[i], expected.TYPE##_a[i]); \
  } \
}  \
void \
test_##TYPE##_##NAME() \
{ \
  TYPE a = {1, 2, 3, 4}; \
  TYPE b = {5, 6, 7, 8}; \
  TYPE c = {33, 32, 31, 0}; \
  do_##TYPE##_##NAME(a,a); \
  do_##TYPE##_##NAME(a,b); \
  do_##TYPE##_##NAME(a,c); \
  do_##TYPE##_##NAME(b,a); \
  do_##TYPE##_##NAME(b,b); \
  do_##TYPE##_##NAME(b,c); \
  do_##TYPE##_##NAME(c,a); \
  do_##TYPE##_##NAME(c,b); \
  do_##TYPE##_##NAME(c,c); \
}

#define DEFINE_TESTS(TYPE) \
TEST_SHIFT(TYPE,shl,<<) \
TEST_SHIFT(TYPE,shr,>>) 

#define CALL_TESTS(TYPE) \
  test_##TYPE##_shl(); \
  test_##TYPE##_shr(); 

DEFINE_TESTS(vsi4)
DEFINE_TESTS(vui4)

#ifdef __cplusplus
#define _C_ "C"
#else
#define _C_ 
#endif

extern _C_ void exit (int);
extern _C_ void abort (void);

int
main()
{
  CALL_TESTS(vsi4)
  CALL_TESTS(vui4)

  if (fail > 0)
    abort();
  exit (0);
}
