
/* (C) Copyright
   Sony Computer Entertainment, Inc.,
   2001,2002,2003,2004,2005,2006.

   This file is free software; you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option) 
   any later version.

   This file is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with this file; see the file COPYING.  If not, write to the Free
   Software Foundation, 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301, USA.  */

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "tm.h"
#include "cpplib.h"
#include "tree.h"
#include "c-tree.h"
#include "c-pragma.h"
#include "function.h"
#include "rtl.h"
#include "expr.h"
#include "errors.h"
#include "tm_p.h"
#include "langhooks.h"
#include "insn-config.h"
#include "insn-codes.h"
#include "recog.h"
#include "optabs.h"
/* APPLE LOCAL begin AltiVec */
#include "c-common.h"
#include "../libcpp/internal.h"
#include "target.h"
#include "spu_types.h"
#include "spu-builtins.h"

static cpp_hashnode *spu_categorize_keyword (const cpp_token *);
static void spu_init_vector_keywords (cpp_reader *pfile);
/* APPLE LOCAL end AltiVec */

tree spu_resolve_overloaded_builtin (tree, tree);


/*
 * Helper for spu_resolve_overloaded_builtin.
 */
static tree
spu_build_overload_builtin (tree fndecl, tree fnargs)
{
  tree param, param_type;
  tree ret_type = TREE_TYPE (TREE_TYPE (fndecl));
  tree arg, arglist = NULL_TREE;
  tree val;

  for (param = TYPE_ARG_TYPES (TREE_TYPE (fndecl)), arg = fnargs;
       param != void_list_node;
       param = TREE_CHAIN (param), arg = TREE_CHAIN (arg))
    {
      gcc_assert (arg != NULL_TREE);
      param_type = TREE_VALUE (param);
      val = fold_convert (param_type, TREE_VALUE (arg));

      arglist = tree_cons (NULL_TREE, val, arglist);
    }
  gcc_assert (arg == NULL_TREE);
  arglist = nreverse (arglist);

  return fold_convert (ret_type, build_function_call_expr (fndecl, arglist));
}

/*
 * target hook for resolve_overloaded_builtin(). Returns a
 * function call RTX if we can resolve the overloaded builtin
 */
tree
spu_resolve_overloaded_builtin (tree fndecl, tree fnargs)
{
#define SCALAR_TYPE_P(t) (INTEGRAL_TYPE_P (t) \
                          || SCALAR_FLOAT_TYPE_P (t) \
                          || POINTER_TYPE_P (t))

  spu_function_code new_fcode, fcode = DECL_FUNCTION_CODE (fndecl) - END_BUILTINS;
  struct spu_builtin_description *desc;
  tree match = NULL_TREE; 

  /* The vector types are not available if the backend is not initalized */
  gcc_assert (!flag_preprocess_only);

  desc = &spu_builtins[fcode];
  if (desc->type != B_OVERLOAD)
     return NULL_TREE;

  /* Compare the signature of each internal builtin function with the
     function arguments until a match found. */

  for (new_fcode = fcode+1; spu_builtins[new_fcode].type == B_INTERNAL; new_fcode++)
    {
       tree decl = spu_builtins[new_fcode].fndecl;
       tree params = TYPE_ARG_TYPES (TREE_TYPE (decl));
       tree arg, param;
       int p;

       for (param = params, arg = fnargs, p = 0;
            param != void_list_node;
            param = TREE_CHAIN (param), arg = TREE_CHAIN (arg), p++)
         {
            tree var, arg_type, param_type = TREE_VALUE (param);

            if (!arg)
              {
                error("insufficient arguments to overloaded function %s",
                      desc->name);
                return error_mark_node;
              }

            var = TREE_VALUE (arg);

            if (TREE_CODE (var) == NON_LVALUE_EXPR)
              var = TREE_OPERAND (var, 0);

            if (TREE_CODE (var) == ERROR_MARK)
              return NULL_TREE; /* Let somebody else deal with the problem. */

            arg_type = TREE_TYPE (var);

	    /* This crazy compiler has two TREE_CODE's for each integer
	       type.  We call type_for_mode() to make sure we're getting
	       the same types for the arguments and the parameters. */
	    if (INTEGRAL_TYPE_P(arg_type))
	      arg_type = (*lang_hooks.types.type_for_mode)(TYPE_MODE (arg_type), TYPE_UNSIGNED (arg_type));

	    /* The intrinsics spec does not specify precisely how to
	       resolve generic intrinsics.  We require an exact match
	       for vector types and let C do it's usual parameter type
	       checking/promotions for scalar arguments, except for the
	       first argument of spu_splats and spu_promote which have
	       no vector parameters. */
            if ((!SCALAR_TYPE_P (param_type)
		 || !SCALAR_TYPE_P (arg_type)
		 || ((fcode == SPU_SPLATS || fcode == SPU_PROMOTE
		      || fcode == SPU_HCMPEQ || fcode == SPU_HCMPGT
		      || fcode == SPU_MASKB || fcode == SPU_MASKH || fcode == SPU_MASKW)
		     && p == 0))
		/* In gcc4 comptypes only accepts 2 arguments */
		&& !comptypes (TYPE_MAIN_VARIANT(param_type),TYPE_MAIN_VARIANT(arg_type)))
              break;
         }
         if (param == void_list_node)
           {
             if (arg)
               {
                 error("too many arguments to overloaded function %s",
                        desc->name);
                 return error_mark_node;
               }

             match = decl;
             break;
           }
    }

  if (match == NULL_TREE)
    {
      error ("parameter list does not match a valid signature for %s()", 
      	     desc->name);
      return error_mark_node;
    }

  return spu_build_overload_builtin (match, fnargs);
}

/* The following are originally Apple's code in their 4.0.0 port. I adapted
 * and simplified it for the SPU.
 */
#define builtin_define(TXT) cpp_define (pfile, TXT)

/* APPLE LOCAL begin AltiVec */
/* Keep the AltiVec keywords handy for fast comparisons.  */

static cpp_hashnode *
spu_categorize_keyword (const cpp_token *tok)
{
  if (tok->type == CPP_NAME)
    {
      cpp_hashnode *ident = tok->val.node;
      cpp_hashnode *vector_cpp_hashnode =
	CPP_HASHNODE (GCC_IDENT_TO_HT_IDENT (vector_keyword));
      cpp_hashnode *__vector_cpp_hashnode =
	CPP_HASHNODE (GCC_IDENT_TO_HT_IDENT (__vector_keyword));

      if (ident == vector_cpp_hashnode || ident == __vector_cpp_hashnode)
	return __vector_cpp_hashnode;

      return ident;
    }

  return 0;
}

/* Called to decide whether a conditional macro should be expanded.
   Since we have exactly one such macro (i.e, 'vector'), we do not
   need to examine the 'tok' parameter.  */

cpp_hashnode *
spu_macro_to_expand (cpp_reader *pfile, const cpp_token *tok)
{
  static bool vector_keywords_init = false;
  cpp_hashnode *expand_this = tok->val.node;
  cpp_hashnode *ident;
  cpp_hashnode *__vector_cpp_hashnode;

  if (!vector_keywords_init)
    {
      spu_init_vector_keywords (pfile);
      vector_keywords_init = true;
    }

  ident = spu_categorize_keyword (tok);
  __vector_cpp_hashnode =
    CPP_HASHNODE (GCC_IDENT_TO_HT_IDENT (__vector_keyword));

  if (ident == __vector_cpp_hashnode)
    {
      tok = _cpp_peek_token (pfile, 0);
      ident = spu_categorize_keyword (tok);

      if (ident)
	{
	  enum rid rid_code = (enum rid)(ident->rid_code);
	  if (ident->type == NT_MACRO)
	    {
	      (void)cpp_get_token (pfile);
	      tok = _cpp_peek_token (pfile, 0);
	      ident = spu_categorize_keyword (tok);
	      if (ident)
		rid_code = (enum rid)(ident->rid_code);
	    }

	  /* we requires integer types to be either signed or unsigned.
	     in other words, "vector signed int" is legal but not
	     "vector int" */
	  if (rid_code == RID_UNSIGNED || rid_code == RID_SIGNED
	      || rid_code == RID_FLOAT || rid_code == RID_DOUBLE)
	    {
	      expand_this = __vector_cpp_hashnode;
	    }
	}
    }

  return expand_this;
}

static void
spu_init_vector_keywords (cpp_reader *pfile)
{
  cpp_hashnode *node;

  /* Keywords without two leading underscores are context-sensitive, and
     hence implemented as conditional macros, controlled by the
     spu_macro_to_expand() function above.  */

  node = cpp_lookup (pfile, DSC ("__vector"));
  node->flags |= NODE_CONDITIONAL;
  __vector_keyword = HT_IDENT_TO_GCC_IDENT (& node->ident);

  node = cpp_lookup (pfile, DSC ("vector"));
  node->flags |= NODE_CONDITIONAL;
  vector_keyword = HT_IDENT_TO_GCC_IDENT (& node->ident);

  return;
}

/* APPLE LOCAL end AltiVec */

/* Defined in c-cppbuiltin.c and not declared in any header. */
extern void builtin_define_std (const char *);

void
spu_cpu_cpp_builtins (cpp_reader *pfile)
{
  builtin_define_std ("__SPU__");
  cpp_assert (pfile, "cpu=spu");
  cpp_assert (pfile, "machine=spu");

  if (spu_arch == PROCESSOR_CELLEDP)
  {
	builtin_define_std ("__SPU_EDP__");
  }

  /* Define the AltiVec syntactic elements. */
  builtin_define ("__vector=__attribute__((spu_vector))");

  /* APPLE LOCAL begin AltiVec */
  builtin_define ("vector=vector");
  spu_init_vector_keywords (pfile);

  /* Enable context-sensitive macros. */
  cpp_get_callbacks (pfile)->macro_to_expand = spu_macro_to_expand;
  /* APPLE LOCAL end AltiVec */
}

void
spu_c_common_override_options(void)
{
 /* Don't give warnings about the main() function. */
  if (!TARGET_STD_MAIN)
  {
    warn_main = 0;
  }
}

