#
# 	Gestion des lignes des graphs
# 	(c) 1995-7 Alexandre Burton
# 	v. 1.80a (10/08/97)
#

proc soloGraph { cible }  {
    global path  couleur data
    foreach victime [array names data] {
	$path(area) itemconfig line.$victime -fill $couleur(bg)
	$path(area) lower $victime
	$path(param).select$victime config -state disabled
    $path(param).check$victime deselect
    }
    $path(area) itemconfig line.$cible -fill $couleur($cible)
    $path(param).select$cible config -state normal
    $path(param).select$cible invoke
}

proc changeIndex {index way} {
    global path
    switch -glob -- $way {
	n* {set index [incr index]}
	p* {set index [incr index -1]}
    }
    if {$index > [llength [winfo child $path(param)]]} { set index 0 }
    if {$index < 0} { set index [expr [llength [winfo child $path(param)]] / 4 ] }
    return $index
}

proc grabLine {cible y} {
    global path plot limite data couleur actif dragging
    update
    set dragging 1
    if {$cible != $actif} { $path(param).select$cible invoke}
    set plot(lastY) $y
    set plot(origY) $y

    set range [expr $limite(supY) -[floatToScreenY [getMinY $data($cible)]]]
    set plot(maxY) [expr $y + $range]

    set range [expr [floatToScreenY [getMaxY $data($cible)]] -$limite(pad)]
    set plot(minY) [expr $y - $range]


    array set dataCourant $data($cible)
    set listeCourante [lsort  -real [array names dataCourant] ]
    foreach point $listeCourante { 
	    set x [expr [floatToScreenX $point] + 0]
   	    set y [expr [floatToScreenY $dataCourant($point) ] + 0]
	    lappend currenpathh  $x $y
    }	
    set graph $currenpathh
    $path(area) create line 0 0 0 0 -fill $couleur(fg) -tags linesel -width 0
    eval {$path(area) coords linesel } $graph

}

proc releaseLine {cible} {
    global path plot dragging
    update
    unset dragging 
    nodge $cible [expr $plot(lastY) - $plot(origY)]
    $path(area) delete linesel 
    
}

proc lineMove {y} {
    global plot limite actif path
    if {[$path(area) find withtag linesel] > 0} {
	set y [$path(area) canvasy  $y]
	if {$y < $plot(minY)} {set y $plot(minY)}
	if {$y > $plot(maxY)} {set y $plot(maxY)}
	set diffY [expr $y - $plot(lastY)]
	$path(area) move linesel 0 $diffY
	set plot(lastY) $y
   }
}

proc focusGraph {way} {
    global actif path data idx graphidx myidx

    set i $myidx($actif)
    incr i $way
    if ![info exists idx($i)] {set idx($i) __dummy}
    while ![info exists data($idx($i))] {
	incr i $way
	if ![info exists idx($i)] {set idx($i) __dummy}
	if {$i<0} {
	    set i $graphidx
	} elseif {$i>$graphidx} {
	    set i 1
	}   
    }
    $path(param).select$idx($i) invoke
}

proc toggleSpline { cible } { 
    global splineLine path dragging
    set dragging 1
    set splineLine($cible) [expr abs($splineLine($cible) - 1)]
    $path(area) itemconfig line.$cible -smooth $splineLine($cible)
}

proc toggleGraph { cible } {
    global couleur actif path 
    if { $cible == $actif } then { 
	$path(param).check$cible select
    } else {
	if { [$path(area) itemcget line.$cible -fill] == $couleur(bg) } then {
	    $path(area) itemconfig line.$cible -fill $couleur($cible)
	    $path(param).select$cible config -state normal
	    bind $path(param).check$cible <3>  "setFade $cible %y"
	    bind $path(param).check$cible <B3-Motion>  "darken $cible  %y"
	    bind $path(param).check$cible <ButtonRelease-3>  "unsetFade $cible"
	} else {
	    $path(area) itemconfig line.$cible -fill $couleur(bg)
	    $path(area) lower $cible
	    $path(param).select$cible config -state disabled
	    bind $path(param).check$cible <3>  {}
	    bind $path(param).check$cible <B3-Motion>  {}
	    bind $path(param).check$cible <ButtonRelease-3>  {}
	}
    }
}

proc selectGraph {cible} {
    global couleur actif unite path xUnite
    $path(area) delete point
    $path(area) itemconfig $actif -fill $couleur(bg) -outline $couleur(bg)
    set actif $cible
    $path(area) itemconfig $actif -fill $couleur($actif) -outline black
    $path(area) raise line.$actif
#    redrawLine $cible
    updatePoints $actif
    $path(area) raise $actif
    drawYGrid
}

proc updateLine { cible } {
    global data path
    array set dataCourant $data($cible)
    set listeCourante [lsort  -real [array names dataCourant] ]
    foreach point $listeCourante { 
	    set x [expr [floatToScreenX $point] + 0]
   	    set y [expr [floatToScreenY $dataCourant($point) ] + 0]
	    lappend currenpathh  $x $y
    }	
    set graph $currenpathh
    eval {$path(area) coords line.$cible } $graph
}

proc redrawLine {cible} {
    global actif path
    updatePoints $cible
    updateLine  $cible
    $path(area) lower point
    if {$actif == $cible} {
	$path(area) raise $cible
	selectGraph $cible        
    }
}

		     ##############################
		     #                            #
		     #   Commandes du menu edit   #
		     #                            #
		     ##############################

proc gcopie {  } {
    global data actif buffer
    set buffer $data($actif)
    .clip.e delete 0 1000
    .clip.e insert 0 $buffer
}

proc gpaste { } {
    global data actif path buffer
    if [catch {set data($actif) $buffer} res] {
	return
	}
    $path(area) raise $actif
    updatePoints $actif
    updateLine  $actif
    selectGraph $actif
}

proc gclear {  } {
    global actif
    greset  $actif
    selectGraph $actif
}

proc gcut {  } {
    gcopie
    gclear
}
