#
# 	Construction et gestion de la fenetre de graph
# 	(c) 1995-7 Alexandre Burton 
# 	v. 1.80a (10/08/97)
#

proc subView {axe args} {
    global path

    set a [lindex $args 0]
    set b [lindex $args 1]

    switch -- [llength $args] {
	2 {
	    switch -- $axe {
		x {
		    $path(area) xview $a $b
		    $path(rulerX) xview $a $b
		}
		y {
		    $path(area) yview $a $b
		    $path(rulerY) yview $a $b
		}
	    }
	}
	3 {
	    set c [lindex $args 2]
	    switch -- $axe {
		x {
		    $path(area) xview $a $b $c
		    $path(rulerX) xview $a $b $c
		}
		y {
		    $path(area) yview $a $b $c
		    $path(rulerY) yview $a $b $c
		}
	    }	    
	}
    }
}

proc initGraph {  } {
    modebug "building graphwindow" ""

    global limite  path couleur tcl_precision tableSize nchnls
    global couleur path utilframe lan prefs prefs
    global fenetre zoom tcl_platform globalAssist _db
    
    set font(graph) [font create -family times -size 12]     

    set t [toplevel .pre  -bd 2]
    wm protocol .pre WM_DELETE_WINDOW {closeInterface 0}
    wm withdraw .pre
    frame $path(top)
    
    set i [menu .pre.intermenubar]
    menu $i.edit -tearoff 0
    menu $i.edit.process -tearoff 0
    menu $i.edit.process.proc -tearoff 0
     menu $i.help -tearoff 0
   
    if {$tcl_platform(platform) == "macintosh"} {
		$i add cascade -menu $i.apple -label Apple
		menu $i.apple -tearoff 0
		$i.apple add command  -label "About Cecilia..."  -command getAbout
    }
    
    $i add cascade -label File -menu .menubar.file
    $i add cascade -label Edit -menu $i.edit
    
    modebug "building graphwindow:" "menu (edit)"
    $i.edit add command -label "Cut Graph"  -accelerator $_db(mod,a)-X -command gcut
    $i.edit add command -label "Copy Graph"  -accelerator $_db(mod,a)-C -command gcopie
    $i.edit add command -label "Paste Graph" -accelerator $_db(mod,a)-V -command gpaste
    $i.edit add command -label "Clear Graph"  -command gclear
    $i.edit add separator
    $i.edit add command -label "Import Graph..." -command openActifGraph
    $i.edit add command -label "Export Graph..." -command saveActifGraph
    $i.edit add separator
    $i.edit add command -label "Nudge Down" -command "nodge actif -1"
    $i.edit add command -label "Nudge Up" -command "nodge actif 1"
    $i.edit add separator
    $i.edit add cascade -label "Processings" -menu $i.edit.process
    
    modebug "building graphwindow:" "menu (process)"
    $i.edit.process  add command -label "Sine Wave"  \
	    -command {sine $fDat(sinpoints) $fDat(sinfreq) $fDat(sinamp) $fDat(sinphase)}
    $i.edit.process add command -label "Other Wave" \
	    -command {linseg $fDat(sawfreq) $fDat(sawamp) $fDat(osctype) $fDat(sawwidth) $fDat(inv)}
    $i.edit.process add command -label "Drunk Walk"      \
	    -command {drunk  $fDat(drunkpoints) $fDat(drunkwalk) $fDat(drunktype) }
    $i.edit.process add command -label "Noise"      \
	    -command {noise $fDat(noisepoints) $fDat(noiseamp)}
    $i.edit.process add command -label "Scatter/Resample"    \
	    -command {randomize actif  $fDat(ampx) $fDat(ampy)}
    $i.edit.process add command -label "y-axis Normalize/Gain" \
	    -command {normalize actif $fDat(scaley)}   
    $i.edit.process add command -label "x-axis Compress" \
	    -command {compress actif $fDat(scalex)}   
    $i.edit.process add separator
    $i.edit.process add cascade -label "Processing Parameters" -menu $i.edit.process.proc

    $i.edit.process.proc add command -label "Sine Wave..."  -command makesinesBox
    $i.edit.process.proc add command -label "Other Wave..." -command makesawBox
    $i.edit.process.proc add command -label "Drunk Walk..."      -command makedrunksBox
    $i.edit.process.proc add command -label "Noise..."      -command makerandBox
    $i.edit.process.proc add command -label "Scatter/Resample..."    -command makescattBox
    $i.edit.process.proc add command -label "Normalize/Gain..."  -command makenormBox
    $i.edit.process.proc add command -label "x-axis Compress..." -command makecompBox
    
    $i add cascade -label Csound -menu .menubar.option
#   $i add cascade -label Analysis -menu .menubar.util
    $i add cascade -label Windows -menu .menubar.wind
    $i add cascade -label Help -menu $i.help
  
    modebug "building graphwindow:" "menu (help)"
    $i.help add command  -label "Cecilia Basics"  -state disabled	
    $i.help add command  -label "   Help Index"  -command "Helpme [file join html index.$_db(html)]" 	
    $i.help add command  -label "   Jumpstart"  -command "Helpme [file join html jump.$_db(html)]" 	
    $i.help add command  -label "   Concepts"  -command "Helpme [file join html main.$_db(html)]" 		
    $i.help add separator
    $i.help add command  -label "Using Cecilia"  -state disabled	
    $i.help add command  -label "   The Tools Palette" -command " Helpme [file join html tools.$_db(html)] "
    $i.help add command  -label "   The Interface"     -command " Helpme [file join html interfac.$_db(html)] "
    $i.help add separator
    $i.help add command  -label "About this Module" -command { showInfo }
    $i.help add separator
    $i.help add check	 -label "Assistance" -variable prefs(assist) -command toggleAssist
    $i.help add command  -label "About Cecilia..."  -command getAbout
   
    bind $i <Enter> windowsMenu

    .pre config -menu $i

    frame $path(droit)     
    frame $path(canvas) -bd 4 -relief ridge 
    pack [frame $path(bas) -height 20] -side bottom -fill x 

    # Assistance
    frame .pre.help -relief groove -bd 2
    pack [label $path(graphHelp) -justify left -anchor w -textvariable globalAssist] -fill x -anchor w
    bindHelp $path(graphHelp) LWinHelp    
    if $prefs(assist) { pack .pre.help -side bottom -anchor w -fill x}
    
        modebug "building graphwindow:" "interface containers"

    grid columnconfig $path(canvas) 1 -weight 1
    grid rowconfig    $path(canvas) 2 -weight 1

    scrollbar $path(scrollY) -orient vertical \
		-relief sunken -border 1 -command "subView y"
	
    scrollbar $path(scrollX) -orient horizontal \
		-relief sunken -border 1 -command "subView x"

    grid $path(scrollY) -column 2 -row 2 -sticky ns
    grid $path(scrollX) -column 1 -row 3 -sticky ew

    bindHelp $path(scrollY) sScrollY
    bindHelp $path(scrollX) sScrollX
    
    canvas $path(area) -relief sunken -border 1 -bg gray90 \
	    -xscrollcommand "$path(scrollX) set" \
	    -yscrollcommand "$path(scrollY) set"
    
    grid [canvas $path(rulerX)  -height 13 \
	    -xscrollcommand "$path(scrollX) set" ] -column 1 -row 0 -sticky ew
    
    grid [canvas $path(rulerY)   -width 30 \
	    -yscrollcommand "$path(scrollY) set" ]  -column 0 -row 2 -sticky ns
    
    $path(area)  bind line <Any-Enter> "allumeLigne"
    $path(area)  bind point <Any-Enter> "allume"
    
    $path(area)  bind line <Any-Leave> "eteintLigne"
    $path(area)  bind point <Any-Leave> "eteint"
    
    bind $path(area)  <1> "plotDown %x %y"
    bind $path(area)  <B1-Motion> "plotMove %x %y " 
    bind $path(area)  <ButtonRelease-1> "updateArrays"
    bind $path(area)  <Configure> "userFit"
    bindHelp $path(area) cArea
    
    bindgraph
    
    set fenetre(maxX) [$path(area) cget -width]
    set fenetre(maxY) [$path(area) cget -height]
    $path(area) configure -scrollregion [list 0 0 $fenetre(maxX) $fenetre(maxY)]
    $path(rulerY) configure -scrollregion [list 0 0 0 $fenetre(maxY)]
    $path(rulerX) configure -scrollregion [list 0 0 $fenetre(maxX) 0]
    
    set limite(supX) [expr $fenetre(maxX) - $limite(pad)]
    set limite(supY) [expr $fenetre(maxY) - $limite(pad)]
    set limite(rangeX) [expr $limite(supX) - $limite(pad)]
    set limite(rangeY) [expr $limite(supY) - $limite(pad)]
    
    set couleur(bg) [$path(area) cget -bg] 
    foreach n {X Y C} {set couleur(pre$n) 90}
    frame $path(gauche)  
    frame $path(param) 

    set zoom(x) 1 ; set zoom(y) 1
    
    modebug "building graphwindow:" "zoom and stuff"
    pack [frame $path(gauche).zzz]  -side bottom -anchor s -padx 6 -pady 3 -fill x 
    pack [label $path(gauche).zzz.t -justify center -anchor s -text "   zoom"] \
	    -fill x -expand y -pady 0

    pack [frame $path(gauche).zzz.a]  -fill x -pady 0
    pack [label $path(gauche).zzz.a.l -width 2 -text "x"] \
	    -side left -pady 0
    
    pack [scale $path(zoomX)  -from 1 -to 10 -bigincrement 1 \
	    -resolution .1 -variable zoom(x) \
	    -highlightthickness 0 -orient h -showvalue 0 -length 35 -width 5 ] \
	    -fill x -expand y -anchor s -pady 0
    
    pack [frame $path(gauche).zzz.b ]  -fill x -pady 0
    pack [label $path(gauche).zzz.b.l -width 2  -text "y"]  -side left -pady 0
    
    pack [scale $path(zoomY)  -from 1 -to 10 -bigincrement 1 \
	    -resolution .1 -variable zoom(y) \
	    -highlightthickness 0 -orient h -showvalue 0 -length 35 -width 5 ] \
	    -fill x -expand y -anchor s -pady 0
    
    bind $path(zoomY) <ButtonRelease-1> {preZoom $zoom(x) $zoom(y)}
    bind $path(zoomX) <ButtonRelease-1> {preZoom $zoom(x) $zoom(y)}
    bind $path(zoomX) <Double-Button-1> {set zoom(x) 1; preZoom $zoom(x) $zoom(y)}
    bind $path(zoomY) <Double-Button-1> {set zoom(y) 1; preZoom $zoom(x) $zoom(y)}
    
    bindHelp $path(zoomY) sZoomY
    bindHelp $path(zoomX) sZoomX
    
    pack [frame $path(gauche).sss]  -side bottom -anchor s -padx 6 -pady 0 -fill x -expand y
    pack [label $path(gauche).sss.t  -justify center -text "   display"] \
	    -fill x -expand y -anchor s

    pack [frame $path(gauche).sss.a ]  -fill x -pady 0
    pack [label $path(gauche).sss.a.l -width 2 -text "x"]  -side left -pady 0
    pack [scale $path(colorX)  -from 99 -to 29 -bigincrement 10 \
	-resolution 1 -variable couleur(preX)  \
	-highlightthickness 0 -orient h -showvalue 0 -length 100 -width 5 -command "setGridColor X"] \
	 -fill x -expand y -pady 0 -anchor s 

    pack [frame $path(gauche).sss.b]  -fill x -pady 0
    pack [label $path(gauche).sss.b.l -width 2 -text "y"]  -side left -pady 0
    pack [scale $path(colorY)  -from 99 -to 29 -bigincrement 10 \
	-resolution 1 -variable couleur(preY)   \
	-highlightthickness 0 -orient h -showvalue 0 -length 100 -width 5 -command "setGridColor Y"] \
	 -fill x -expand y -pady 0 -anchor s 

    pack [frame $path(gauche).sss.c]  -fill x -pady 0
    pack [label $path(gauche).sss.c.l -width 2 -text "p"]  -side left -pady 0
    pack [scale $path(colorP)  -from 99 -to 29 -bigincrement 10 \
	-resolution 1 -variable couleur(preC) \
	-highlightthickness 0 -orient h -showvalue 0 -length 100 -width 5 -command "setGridColor C"] \
	 -fill x -expand y -pady 0 -anchor s 
	 
    bind $path(colorP) <Double-Button-1> {set couleur(preC) 90; setGridColor C}
    bind $path(colorX) <Double-Button-1> {set couleur(preX) 90; setGridColor X}
    bind $path(colorY) <Double-Button-1> {set couleur(preY) 90; setGridColor Y}
    bind $path(colorP) <Button-1> {fakeCursor on}
    bind $path(colorP) <ButtonRelease-1> {fakeCursor off}

    bindHelp $path(gauche).sss bGraphUtils

    grid $path(area)	-column 1 -row 2 -sticky nswe
    
    pack $path(param)	-side top -expand n -fill y -pady 20    
    pack $path(droit)	-expand y -fill both -side right -anchor e
    
    wm geometry .pre $prefs(geom,pre)
    
    toplevel .clip
    entry .clip.e 
    pack .clip.e -expand y -fill x
    wm withdraw .clip
    makeTools
    bind .pre <Leave> windowsMenu
    set couleur(preX) 75
    set couleur(preY) 75
    set couleur(preC) 25
     modebug "building graphwindow:" "done"

}


proc fakeCursor {mode} {
    global path plot  limite couleur fenetre cfont
    switch -- $mode {
	on {
	    $path(area) create text $plot(lastX) 5 -anchor n -justify c -font $cfont(small)\
		    -tags [list coorX ruleC] -fill $couleur(gridC)

	    $path(area) create text 1 $plot(lastY) -anchor w -justify c -font $cfont(small) \
		    -tags [list coorY ruleC] -fill  $couleur(gridC)

	    $path(area) create text $plot(lastX) $plot(lastY) -anchor se -justify c  -font $cfont(small) \
		    -tags [list coor ruleC] -fill  $couleur(gridC)

	    $path(area) create line $plot(lastX)  $limite(pad) $plot(lastX) [expr $fenetre(maxY) -$limite(pad)]  \
		    -tags [list coorLX ruleC] -fill  $couleur(gridC)

	    $path(area) create line $limite(pad) $plot(lastY) [expr $fenetre(maxX) -$limite(pad)] $plot(lastY)  \
		    -tags [list coorLY ruleC] -fill  $couleur(gridC)

	    temoin [screenToFloatX $plot(lastX)] [screenToFloatY $plot(lastY)]	
	}
	off { 
	    $path(area) delete tempLine coor coorX coorY coorLX coorLY
	}
    }
}

proc setGridColor {axe args} {
    global path couleur
    set couleur(grid$axe) gray$couleur(pre$axe)
    $path(area) itemconfigure rule$axe -fill $couleur(grid$axe)
    if {$couleur(preX) < $couleur(preY)} {
	 $path(area) lower ruleY
    } else {
	 $path(area) lower ruleX
    }
}

proc toggleClipBoard { } {
    global buffer
    if {[wm state .clip] == "normal"} {
	wm withdraw .clip
    } else {
	wm deiconify .clip
	if [info exists buffer] { .clip.e insert 0 $buffer }
    }
}

		    ################################
		    #                              #
		    #   Manipulation des donnees   #
		    #                              #
		    ################################

proc destroyData {} {
    global data items path initGraph graphidx paramode typeList prefs midiinfo
    global value a b listeSons module soundInInfo soundOutInfo longnom _db genBank
    pack forget $path(top) $path(winIn)  $path(top) 

    foreach sub [winfo child $path(winIn).f]  {destroy $sub} 
    foreach win {param} {
	eval destroy [winfo child $path($win)]  
    }
	if [winfo exists $path(bas).sw] {destroy $path(bas).sw}
	if [winfo exists $path(hsli)] {destroy $path(hsli)}
	if [winfo exists .vslide]  {destroy $path(vsli);wm withdraw .vslide}
	if [winfo exists .vslide.sw]  {destroy .vslide.sw}
	if [winfo exists $path(opti)] {destroy $path(opti)} 
	if [winfo exists $path(togli)] {destroy $path(togli)}

	pack forget $path(gauche) $path(canvas) 
	grid forget $path(winIn) 
	$path(area) delete all 
	if [info exists midiinfo] {unset midiinfo} 
	if [info exists isRealTime] {unset isRealTime} 
	if [info exists paramode] { unset paramode} 
	if [info exists initGraph] { unset initGraph} 
	# if [info exists listeSons] { unset listeSons } 
	if [array exists data] { unset data items } 
	if [array exists module] { unset module} 
	if [array exists gensize] { unset gensize} 
	if [array exists soundInInfo] { pack forget $path(winIn) 
	if $prefs(keep) { 
		set _db(sound,previous) $value([lindex [array names soundInInfo] 0]) 
	} { 
		set _db(sound,previous) ""
	} 
	unset soundInInfo } 
	if [array exists value] { unset value } 
	if [array exists type] { unset type } 
	set b 0 
	set longnom 0 
#	set genBank 1 
	set _db(time,reset) 0 
	set graphidx 0 
	set typeList(cec_irateSlider) {} 
	set a 0 
	pack forget .pre.too 
	update
    
}

proc updateArrays {} {
    global liste items data actif plot path module dragging
    if [info exists dragging] {releaseLine $actif; return}
    if {$module(nom) == ""} { return }
    set itemSelection [$path(area) find withtag selected]
    if { $itemSelection > 0}  {
	array set itemsCourant $items($actif)
	array set dataCourant $data($actif)
	set locFloat(x) [screenToFloatX $plot(lastX)]
	set locFloat(y) [screenToFloatY $plot(lastY)]
	if { $plot(origX) == $plot(lastX) || $plot(fixed) } { 
	    set dataCourant($plot(float)) $locFloat(y)
	} else {
	    unset dataCourant($plot(float))
	    set dataCourant($locFloat(x)) $locFloat(y)
	    set itemsCourant($itemSelection) $locFloat(x)
	}
	set items($actif) [array get itemsCourant]
	set data($actif) [array get dataCourant]
	$path(area) dtag selected	
    }	
    updateLine $actif    
    $path(area) delete tempLine coor coorX coorY coorLX coorLY
    $path(rulerX) delete tempLine coor coorX coorY coorLX coorLY
    $path(rulerY) delete tempLine coor coorX coorY coorLX coorLY
}

			   ##################
			   #                #
			   #   In and out   #
			   #                #
			   ##################

proc changePos {x y} {
    global flag plot  couleur path cfont
    set dir  [$path(area) itemcget coor -anchor]
    if {$x >= 0.1 && $y < 0.9} {set pos 1}
    if {$x < 0.1 && $y < 0.9} {set pos 2}
    if {$x < 0.1 && $y < 0.1} {set pos 3}
    if {$x >= 0.1 && $y >= 0.9} {set pos 2}
    if {$x >= 0.9 && $y >= 0.9} {set pos 4}
    if {$x < 0.1 && $y >= 0.9} {set pos 2}
    switch $pos {
	1 {
	    if {$dir == "nw" | $dir == "sw" | $dir == "ne"} {	
		$path(area) delete coor
		$path(area) create text $plot(lastX) $plot(lastY) -anchor se -justify r -font $cfont(small) -tags [list coor ruleC] -fill  $couleur(gridC)
	    }
	} 2 {
	    if {$dir == "se" | $dir == "sw" | $dir == "ne"} {	
		$path(area) delete coor
		$path(area) create text $plot(lastX) $plot(lastY) -anchor nw -justify r   -font $cfont(small) -tags [list coor ruleC] -fill  $couleur(gridC)
	    }
	} 3 {
	    if {$dir == "se" | $dir == "nw" | $dir == "ne"} {	
		$path(area) delete coor
		$path(area) create text $plot(lastX) $plot(lastY) -anchor sw -justify r   -font $cfont(small) -tags [list coor ruleC] -fill  $couleur(gridC)
	    }
	} 4 {
	    if {$dir == "se" | $dir == "nw" | $dir == "nw"} {	
		$path(area) delete coor
		$path(area) create text $plot(lastX) $plot(lastY) -anchor ne -justify r   -font $cfont(small) -tags [list coor ruleC] -fill  $couleur(gridC)
	    }
	}
    }
}

proc temoin {x y} {
    global actif path unite flag
    $path(area) itemconfig coor -text "[format %.3f [floatToTime $x $actif]] s.\n[floatToParam $y $actif] $unite($actif)"
    changePos $x $y
    $path(area) itemconfig coorX -text "[floatToTime $x $actif]"
    set y [floatToParam $y $actif]
    regsub -- {-} $y "-\n" y
    $path(area) itemconfig coorY -text $y
}

proc greset {cible} {
    global actif resetValue data
    set data($cible) $resetValue($cible)
     updateLine $cible
}

proc greset2 {cible} {
    global actif resetValue data
    if { $cible == "actif" } {cible $actif}
    set newValue [paramToFloat $resetValue($cible) $cible]
    set data($cible) [list 0.0 $newValue 1.0 $newValue]
    updateLine $cible
}

proc scoredump {cible} {
    global data actif ambitus seuil petitNom soundOutInfo
    global genID relation splineLine tableSize name gensize
    if { $cible == "actif" } then { set cible $actif } { if { $cible == "all" } { set cible [array names data] } }
 
   set i 1
    foreach graphique $cible {	
	set parametreCourant $graphique
        array set boo $data($parametreCourant)
        set past 0; set totTime 0
	switch -glob -- $relation($parametreCourant) {
	    li* {	if {$splineLine($parametreCourant)} { set GEN -8 }  { set GEN -7 } }
	    lo* { set GEN -5 }
	    ra* { set GEN -2 }
	    default { bell ;  puts "$relation($parametreCourant)?" }
	}
	foreach ordPoint [lsort [array names boo]] {
	    set curTime     [expr $ordPoint-$past]
	    lappend dog [floatToTable $curTime $parametreCourant]
	    lappend dog [floatToParam $boo($ordPoint) $parametreCourant]
	    set past [expr $past + $curTime]
	}
	if ![info exists gensize($parametreCourant)] {
	    set tableSize $soundOutInfo(userGEN)
	} else {
	    set tableSize $gensize($parametreCourant)
	}

	lappend enveloppes [concat f $genID($graphique) 0 $tableSize $GEN [lrange $dog 1 end]] 
	lappend enveloppes " ; $graphique\n"
	unset boo past curTime dog GEN 	tableSize
	incr i
    }
    return [join  $enveloppes]
}


#ftgen 0, 0, 4096, 7,-1, 2048, -1, 0, 1, 2048, 1 

proc dump {cible} {
    global data actif ambitus seuil petitNom soundOutInfo
    global genID relation splineLine tableSize name gensize
    if { $cible == "actif" } then { set cible $actif } { if { $cible == "all" } { set cible [array names data] } }
    
    set i 1
    set enveloppes ""
    foreach graphique $cible {	
	set parametreCourant $graphique
	array set boo $data($parametreCourant)
	set past 0 ; set totTime 0
	switch -glob -- $relation($parametreCourant) {
	    li* {	if {$splineLine($parametreCourant)} { set GEN -8 }  { set GEN -7 } }
	    lo* { set GEN -5 }
	    ra* { set GEN -2 }
	    default { bell ;  puts "$relation($parametreCourant)?" }
	}
	foreach ordPoint [lsort [array names boo]] {
	    set curTime     [expr $ordPoint-$past]
	    lappend dog [floatToTable $curTime $parametreCourant],
	    lappend dog [floatToParam $boo($ordPoint) $parametreCourant],
	    set past [expr $past + $curTime]
	}
	if ![info exists gensize($parametreCourant)] {
	    set tableSize $soundOutInfo(userGEN)
	} else {
	    set tableSize $gensize($parametreCourant)
	}
	set dog [string trimright $dog ,]
	
	append enveloppes "0, 0, $tableSize, $GEN, [lrange $dog 1 end]"
	unset boo past curTime dog GEN 	tableSize
	incr i
    }
    return $enveloppes
}


			      ############
			      #          #
			      #   Zoom   #
			      #          #
			      ############

proc userFit {} {
    update
    global tcl_platform
    if {$tcl_platform(os) == "dummy"} {
	if {[wm positionfrom .] != "program"} {return}	
    } { if {[wm positionfrom .] == "program"} {return} }
    fit
}

proc preZoom {x y} {
    global fenetre limite data path actif
    update
    set large [expr 1.0 * $x * ( 1.0 * [winfo width $path(area) ] -  6 )]
    set haut [expr 1.0 * $y * ( 1.0 * [winfo height $path(area) ] - 6 )] 
    $path(area) configure -scrollregion  [list 0 0 $large $haut ]
    $path(rulerX) configure -scrollregion  [list 0 0 $large 0 ]
    $path(rulerY) configure -scrollregion  [list 0 0 0 $haut]
    set limite(supX) [expr $large - $limite(pad)]
    set limite(supY) [expr $haut - $limite(pad)]
    set limite(rangeX) [expr $limite(supX) - $limite(pad)]
    set limite(rangeY) [expr $limite(supY) - $limite(pad)]
    foreach ligne [array names data]  { updateLine $ligne }
    updatePoints $actif
    set fenetre(maxX) $large
    set fenetre(maxY) $haut
    drawXGrid
    drawYGrid
}

proc fit {} {
    global fenetre limite data path actif ffont tcl_platform
    if ![info exists data] {return 0}
    set large [expr 1.0 * ( [winfo width $path(area) ] -  6 )]
    set haut [expr 1.0 * ( [winfo height $path(area) ] - 6 )] 
    $path(area) configure -scrollregion  [list 0 0 $large $haut ]
    $path(rulerX) configure -scrollregion  [list 0 0 $large 0 ]
    $path(rulerY) configure -scrollregion  [list 0 0 0 $haut  ]
    set limite(supX) [expr $large - $limite(pad)]
    set limite(supY) [expr $haut - $limite(pad)]
    set limite(rangeX) [expr $limite(supX) - $limite(pad)]
    set limite(rangeY) [expr $limite(supY) - $limite(pad)]
    foreach ligne [array names data]  { updateLine $ligne }
    updatePoints $actif
    set fenetre(maxX) $large
    set fenetre(maxY) $haut
    drawXGrid
    drawYGrid
    $path(rulerX) delete info
#    $path(rulerX) create text [expr [winfo width $path(rulerX)]/2] 6 \
#	    -text "Time scale will match soundIn duration" -font $ffont -fill gray25 
#    if {$tcl_platform(os) == "Linux"} { wm positionfrom . program }
}

proc drawYGrid {} {
    global path fenetre limite soundOutInfo ffont ambitus cfont actif couleur relation seuil
    set cm [winfo pixels .pre 1c] 
    $path(area) delete ruleY
    $path(rulerY) delete ruleY
    switch -glob -- $relation($actif) {
	li* {
	    set ranges ".01 .025 .05 .1 .2 .5 1 2 5 10 25 50 100 200 500 1000 2000 5000 10000 20000 50000 100000 200000 500000"
	    set index [lsearch $ranges 1]
	    set echelle [lindex $ranges $index]
	    set unite [expr $ambitus($actif) * $echelle]
	    set nbr [expr  1.0 * ($fenetre(maxY)-2*$limite(pad)) / $unite *$echelle]
	    while {($nbr < $cm) && ($index < [llength $ranges])} {
		set echelle [lindex $ranges [incr index]]
		set nbr [expr  1.0 * ($fenetre(maxY)-2*$limite(pad)) / $unite*$echelle]
	    }
	    while {($nbr > 2*$cm) && ($index >0)} {
		set echelle [lindex $ranges [incr index -1]]
		set nbr [expr  1.0 * ($fenetre(maxY)-2*$limite(pad)) / $unite*$echelle]
	    }
	    for {set r 0} {$r<=($ambitus($actif)/$echelle)} {incr r 1} {
		set float [expr 1.0 - (1.0 * $r*$echelle/$ambitus($actif))]
		set val [string trim [string trimright [floatToParam $float $actif] 0] .]
		regsub -- {-} $val "-\n" val
		$path(area) create line  $limite(pad) [expr $r*$nbr+$limite(pad)] [expr $fenetre(maxX) -$limite(pad)] [expr $r*$nbr+$limite(pad)]\
			-tags ruleY -fill $couleur(bg)
		$path(rulerY) create text 1 [expr $r*$nbr+$limite(pad)] -font $cfont(small) -justify center \
			    -text $val -tags ruleY  -anchor w  -fill grey40
	    }
	}
	ra* {
	    set ranges ".01 .025 .05 .1 .2 .5 1 2 5 10 25 50 100 200 500 1000 2000 5000 10000 20000 50000 100000 200000 500000"
	    set index [lsearch $ranges 1]
	    set echelle [lindex $ranges $index]
	    set unite [expr $ambitus($actif) * $echelle]
	    set nbr [expr  1.0 * ($fenetre(maxY)-2*$limite(pad)) / $unite *$echelle]
	    while {($nbr < $cm) && ($index < [llength $ranges])} {
		set echelle [lindex $ranges [incr index]]
		set nbr [expr  1.0 * ($fenetre(maxY)-2*$limite(pad)) / $unite*$echelle]
	    }
	    while {($nbr > 2*$cm) && ($index >0)} {
		set echelle [lindex $ranges [incr index -1]]
		set nbr [expr  1.0 * ($fenetre(maxY)-2*$limite(pad)) / $unite*$echelle]
	    }
	    for {set r 0} {$r<=($ambitus($actif)/$echelle)} {incr r 1} {
		set float [expr 1.0 - (1.0 * $r*$echelle/$ambitus($actif))]
		set val [string trim [string trimright [floatToParam $float $actif] 0] .]
		regsub -- {-} $val "-\n" val
		$path(area) create line  $limite(pad) [expr $r*$nbr+$limite(pad)] [expr $fenetre(maxX) -$limite(pad)] [expr $r*$nbr+$limite(pad)]\
			-tags ruleY -fill $couleur(bg)
		$path(rulerY) create text 1 [expr $r*$nbr+$limite(pad)] -font $cfont(small) -justify center \
			    -text $val -tags ruleY  -anchor w  -fill grey40
	    }
	}
	lo* {
	    set div $seuil($actif)
	    set max [expr $ambitus($actif) + $seuil($actif)]
	    while {$div < $max} {
		foreach inc {1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0 7.5} {
		    if {[set p [expr $inc*$div]] < $max} {
			set y [floatToScreenY [paramToFloat $p $actif]]
			$path(area) create line  $limite(pad) $y [expr $fenetre(maxX) -$limite(pad)] $y  -tags ruleY -fill   $couleur(bg)
			if { $inc==1.0||$inc==2.5||$inc==5.0||$inc==7.5 } { 	
			     $path(rulerY) create text 1 [expr $y] -font $cfont(small)  -justify center -text $p -tags ruleY  \
						-anchor w  -fill grey40
			     $path(rulerY) create line 27 [expr $y] 40 [expr $y] -tags ruleY   -fill grey40
			}
		    }
		}
		set div [expr 10.0*$div]
	    }
	    set y [floatToScreenY [paramToFloat $max $actif]]
	    $path(area) create line  $limite(pad) $y [expr $fenetre(maxX) -$limite(pad)] $y  -tags ruleY -fill   $couleur(bg)
	    $path(rulerY) create text 1 [expr $y] -justify center -font $cfont(small)  -text $max -tags ruleY  -anchor w  -fill grey40
	    $path(rulerY) create line 27 [expr $y] 40 [expr $y] -tags ruleY   -fill grey40
	}
    }
    $path(area) lower ruleY
    setGridColor Y 
}
proc drawXGrid {} {
    global path fenetre limite soundOutInfo  couleur cfont
    $path(area) delete ruleX
    $path(rulerX) delete ruleX
    $path(rulerX) delete info
    if {$soundOutInfo(duree) <=0} {
		$path(zoomX) config -state disabled
		$path(colorX) config -state disabled
		bind $path(zoomX) <Double-Button-1> {}
		bind $path(colorX) <Double-Button-1> {}
    	update
#		$path(rulerX) create text [expr [winfo width $path(rulerX)]/2] 6 \
#			create text  -font $cfont(small) -text "Time scale will match soundIn duration"  -fill gray25 \
#			-tag info
		return 0
    }
    bind $path(zoomX) <Double-Button-1> {set zoom(x) 1; preZoom $zoom(x) $zoom(y)}
    bind $path(colorX) <Double-Button-1> {set couleur(preX) 90; setGridColor X}
    $path(zoomX) config -state normal
    $path(colorX) config -state normal
    set ranges ".1 .2 .5 1 2 5 10 20 30 60"
    set index [lsearch $ranges 1]
    set cm [winfo pixels .pre 1c] 
    set echelle [lindex $ranges $index]
    set nbr [expr  1.0 * ($fenetre(maxX)-2*$limite(pad)) / $soundOutInfo(duree) * $echelle]
    while {($nbr < $cm) && ($index < [llength $ranges])} {
	set echelle [lindex $ranges [incr index]]
	set nbr [expr  1.0 * ($fenetre(maxX)-2*$limite(pad)) / $soundOutInfo(duree) * $echelle]
    }
    while {($nbr > 2*$cm) && ($index >0)} {
	set echelle [lindex $ranges [incr index -1]]
	set nbr [expr  1.0 * ($fenetre(maxX)-2*$limite(pad)) / $soundOutInfo(duree) * $echelle]
    }
    for {set r 0} {$r<=$soundOutInfo(duree)/$echelle} {incr r 1} {
    	$path(area) create line [expr $r*$nbr+$limite(pad)] $limite(pad) [expr $r*$nbr+$limite(pad)] [expr $fenetre(maxY) -$limite(pad)] -tags ruleX -fill  $couleur(bg)
    	$path(rulerX) create line [expr $r*$nbr+$limite(pad)] 9 [expr $r*$nbr+$limite(pad)] 20 -tags ruleX -fill  grey50
	$path(rulerX) create text [expr $r*$nbr+$limite(pad)] 10 -font $cfont(small) -anchor sw \
	  -text "[cleanFormat [format %.2f [expr $r*$echelle]]] s." -tags ruleX  -fill grey40
    }
    $path(area) lower ruleX
    setGridColor X 
}

proc zoom { facteurX facteurY } {
    global  fenetre limite data path actif limite 
    update
    set fenetre(maxX) [expr 1.0 * [lindex [$path(area) cget -scrollregion] 2]* $facteurX]
    set fenetre(maxY) [expr 1.0 * [lindex [$path(area) cget -scrollregion] 3]* $facteurY]
    $path(area) configure -scrollregion [list 0 0 $fenetre(maxX) $fenetre(maxY)] 
    $path(rulerX) configure -scrollregion  [list 0 0 [expr $fenetre(maxX) - [winfo width $path(juice).pad]] 0 ]
    $path(rulerY) configure -scrollregion  [list 0 0 0 [expr $fenetre(maxY) ] ]
    set limite(supX) [expr $fenetre(maxX) - $limite(pad)]
    set limite(supY) [expr $fenetre(maxY) - $limite(pad)]
    set limite(rangeX) [expr $limite(supX) - $limite(pad)]
    set limite(rangeY) [expr $limite(supY) - $limite(pad)]
    foreach ligne [array names data]  { updateLine $ligne }
    updatePoints $actif

    drawXGrid
    drawYGrid

}

proc dimcolor {rgb} {
	set rgb [string trim $rgb \#]
	set i 0
	foreach c {r g b} {	
		set $c 0x[string range $rgb $i [incr i]]	
		set $c [expr int([set $c] + (0xFF - [set $c]) / 1.5)]
		incr i 
	}		
	return \#[format %x%x%x $r $g $b]
}	

proc darken { target  y} {
    global plot couleur cl amount path

    set max 150
    set amount [expr (1.0 * ($y - $plot(origY))/$max)+$plot(amount)]

    if {$amount < 0} {set amount 0} ; if {$amount > 1} {set amount 1}

    set couleur($target)  [format "#%02x%02x%02x" \
	[expr round((($cl(min,r)-$cl(std,r)) * $amount) + $cl(fad,r)) ]\
	[expr round((($cl(min,g)-$cl(std,g)) * $amount) + $cl(fad,g)) ]\
	[expr round((($cl(min,b)-$cl(std,b)) * $amount) + $cl(fad,b)) ] ]
    $path(area) itemconfig line.$target -fill $couleur($target)
    $path(area) itemconfig $target -fill  $couleur($target)
    $path(area) itemconfig $target -fill  $couleur($target)
    $path(param).check$target config  -selectcolor  $couleur($target)
}

proc setFade {target y} {
    global plot  couleur cl path amount
    set plot(origY) $y
    set plot(amount) $couleur(off,$target)
    set couleur($target)  $couleur(std,$target)
    $path(area) itemconfig line.$target -fill  $couleur($target)
    $path(area) itemconfig $target -fill  $couleur($target)
    $path(param).check$target config  -selectcolor  $couleur($target)
    set stdrgb [winfo rgb . $couleur(std,$target)]
    set minrgb [winfo rgb . $couleur(bg)]
    set fadrgb [winfo rgb . $couleur($target)]

    set i 0
    foreach c {r g b} {
	set cl(std,$c) [expr [lindex $stdrgb $i] /256]
	set cl(min,$c) [expr [lindex $minrgb $i] /256]
	set cl(fad,$c) [expr [lindex $fadrgb $i] /256]
	incr i
    }
    set amount 0
    return
    darken $target $y
}

proc unsetFade {target} {
    global  amount couleur
    set couleur(off,$target) $amount
    unset amount
    bind $path(param).check$nom <Button-Release-1> ""
    bind $path(param).check$nom <Motion>  "" 
}
