#ifndef H_CDW_FORM
#define H_CDW_FORM

#include <stdbool.h>
#include <stddef.h>

#include <ncursesw/ncurses.h>
#include <ncursesw/form.h>

#include "main.h"
#include "cdw_ncurses.h"
#include "cdw_config.h"
#include "cdw_widgets.h"


/* this data structure is in "draft" version, it may change many times */
typedef struct {
	int widget_type;    /* widget type from cdw_widgets.h */
	size_t begin_y;     /* start row in parent window */
	size_t begin_x;     /* start col in parent window */
	size_t n_cols;      /* number of columns occupied by widget */
	int n_lines;        /* number of lines occupied by widget */
	int field_enum;     /* field index, useful when widgets are placed in ncurses form */
	void *data1;        /* e.g. for initial label string or for widget associated with field */
	size_t data2;       /* generic int, usage depends on type of widget */
} cdw_form_descr_t;


struct cdw_form_type;
typedef struct cdw_form_type cdw_form_t;

struct cdw_form_type {
	/* these three fields are "foreign" - they are just pointers
	   to data provided and managed by client's code */
	WINDOW *window;
	WINDOW *subwindow;
	FIELD **fields;

	/* this is pointer to memory allocated by cdw form, but it's
	   client's responsibility to free this memory */
	FORM *form;

	/* TODO: make "form" and "fields" fields fully "owned" by cdw form */

	int n_fields;
	int *field_widget_types; /* table of widget types/IDs, allocated at runtime */

	int form_id; /* useful when client code uses several forms */

	int return_keys[N_RETURN_KEYS_MAX];
	int n_return_keys;

	/* this one you have to initialize yourself */
	void (* handle_enter)(cdw_form_t *cdw_form, int fi, void *data);

	/* these are set up by cdw form module when calling
	   cdw_form_set_up(); */
	void (* toggle_focus)(cdw_form_t *cdw_form, int fi, bool off); /* toggle focus (highlight) of all elements in given page */
	void (* toggle_checkbox)(cdw_form_t *cdw_form, int fi);
	bool (* is_checkbox_field_index)(cdw_form_t *cdw_form, int fi);
	bool (* is_dropdown_field_index)(cdw_form_t *cdw_form, int fi);
	bool (* is_button_field_index)(cdw_form_t *cdw_form, int fi);
	bool (* is_input_field_index)(cdw_form_t *cdw_form, int fi);
	CDW_BUTTON *(* get_button_from_form)(cdw_form_t *cdw_form, int fi);
	CDW_DROPDOWN *(* get_dropdown_from_form)(cdw_form_t *cdw_form, int fi);

	/* *** private *** */

	void (* focus_on)(cdw_form_t *cdw_form, int fi);
	void (* focus_off)(cdw_form_t *cdw_form, int fi);

};

/* these are for "cdw form" data structure */
cdw_form_t *cdw_form_new(int n_fields);
void        cdw_form_delete_form_objects(cdw_form_t *cdw_form);
void        cdw_form_delete(cdw_form_t **cdw_form);
int         cdw_form_driver(cdw_form_t *cdw_form, int initial_fi, void *data);
cdw_rv_t    cdw_form_description_to_fields(cdw_form_descr_t descr[], void *cdw_form);
void        cdw_form_add_return_char(cdw_form_t *form, int key);

bool     cdw_form_is_movement_key(int key);

/* these are for "regular" ncurses form */
FORM    *cdw_form_new_form(WINDOW *window, WINDOW *subwindow, FIELD *field[]);
bool     cdw_form_get_field_bit(FIELD *field);
char    *cdw_form_get_field_string(FIELD *field);



#endif /* H_CDW_FORM */
