#ifndef FACTORY_H
#define FACTORY_H
#include <vector>
#include <iostream>
#include <map>
#include <memory>
#include <functional>
#include "modules.h"
#include "process.h"

std::map<const std::string, std::function<std::shared_ptr<Process>(int p_ID, const std::string &p_operatorNamme,
                                                                   const std::vector<std::string> &operatorArguments)>> &
get_factory();

template <typename T>
struct CdoModule
{

  std::string name;
  std::vector<oper_t> operators;  // Operator names
  std::vector<Alias> aliases;
  std::vector<char **> help;
  short mode;    // Module mode: 0:intern 1:extern
  short number;  // Allowed number type
  module_constraints constraints;

  struct RegisterEntry
  {
  public:
    RegisterEntry(CdoModule *t)
    {
      for (auto &oper : t->operators)
        {
          get_factory()[oper.name] = [](int p_ID, const std::string &p_operatorNamme,
                                        const std::vector<std::string> &operatorArguments) -> std::shared_ptr<T> {
            auto new_mod = std::make_shared<T>();
            new_mod->m_ID = p_ID;
            new_mod->operatorName = p_operatorNamme;
            new_mod->init_process(p_operatorNamme, operatorArguments);
            /* START  Temporary workaround, replace by proper sys */
            /* END  Temporary workaround, replace by proper sys */
            return new_mod;
          };
          std::cerr << "added " << oper.name << std::endl;
        }
    };
  };

  int
  get_id(std::string oper)
  {
    for (size_t i = 0; i < operators.size(); i++)
      {
        if (oper == operators[i].name) { return i; }
      }
    return -1;
  }

  RegisterEntry registration = RegisterEntry(this);
};

#endif
