/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2020 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/
#include <algorithm>

#include "cdo_output.h"
#include "string_utilities.h"
#include "util_string.h"

#define DBG 0

int
cstr_split_with_seperator(const char *source_string, const char *seperator, std::vector<std::string> &split_string)
{
  std::stringstream ss(source_string);
  std::string token;
  std::vector<std::string> tokens;
  while (std::getline(ss, token, *seperator))
    {
      tokens.push_back(token);
    }
  split_string = tokens;
  return split_string.size();
}

int
cstr_split_with_seperator(const char *source_string, const char *seperator, char ***ptr_split_string)
{
  char **temp_list = nullptr, *temp_str = nullptr, *saveptr;
  int n = 0, i;
  int str_len = 0, sep_count = 0;

  str_len = strlen(source_string);

  if (!str_len) return 0;

  if (DBG) fprintf(stderr, "cstr_split_with_seperator Input str %s , seperator %s \n", source_string, seperator);

  char *duplicate_src = strdup(source_string);

  for (i = 0; i < str_len; i++)
    {
      if (duplicate_src[i] == *seperator) sep_count++;
    }

  temp_list = (char **) malloc(sizeof(char *) * (sep_count + 1));

  if (DBG) fprintf(stderr, "Input str %s, seperator '%s' sep count %d\n", duplicate_src, seperator, sep_count);

  char *tmpstr = duplicate_src;
  while ((temp_str = strtok_r(tmpstr, seperator, &saveptr)))
    {
      temp_list[n] = temp_str;
      n++;
      tmpstr = saveptr;
    }

  if (DBG)
    {
      for (i = 0; i < n; i++) fprintf(stderr, "str  %s \n", temp_list[i]);
    }

  *ptr_split_string = temp_list;

  return n;
}

int
cstr_is_numeric(const char *s)
{
  char *ptr;
  if (s == nullptr || *s == '\0' || isspace(*s)) return 0;

  strtod(s, &ptr);
  return *ptr == '\0';
}

/* To replace a single char with another single char in a given string */

void
cstr_replace_char(char *str_in, char orig_char, char rep_char)
{

  char *ref = nullptr;

  if (DBG) ref = str_in;

  if (strchr(str_in, orig_char) == nullptr) return;

  if (DBG) fprintf(stderr, "Before %s\n", ref);

  while (*str_in != '\0')
    {
      if (*str_in == orig_char) *str_in = rep_char;
      str_in++;
    }
  if (DBG) fprintf(stderr, "After %s\n", ref);

  return;
}
