/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2020 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/

#ifndef FIELD_VINTERP_H
#define FIELD_VINTERP_H

#include "field.h"
#include "vertical_interp.h"

void genind(std::vector<int> &vert_index, Varray<double> &plev, Field3D &full_press, size_t gridsize);

void genindmiss(std::vector<int> &vert_index, Varray<double> &plev, size_t gridsize, Field &ps_prog, std::vector<size_t> &pnmiss);

void vertical_interp_T(size_t nlevels, Field3D &full_press, Field3D &half_press, Field3D &field1, Field3D &field2, Field &sgeopot, std::vector<int> &vert_index, Varray<double> &plev, size_t gridsize);

void vertical_interp_Z(size_t nlevels, Field3D &full_press, Field3D &half_press, Field3D &field1, Field3D &field2, Field3D &temp, Field &sgeopot, std::vector<int> &vert_index, Varray<double> &plev, size_t gridsize);

void vertical_interp_X(size_t nlevels, Field3D &full_press, Field3D &half_press, Field3D &field1, Field3D &field2, std::vector<int> &vert_index, Varray<double> &plev, size_t gridsize);

#endif
