/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2020 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/
#ifndef CDO_VARLIST_H
#define CDO_VARLIST_H

#include <vector>

#include <cdi.h>

#include "cdo_varlist.h"
#include "cdo_options.h"

struct CdoVar
{
  char name[CDI_MAX_NAME];
  MemType memType;
  int gridID;
  int zaxisID;
  size_t gridsize;
  int nlevels;
  int datatype;
  double missval;
  int timetype;
  int code;
  int param;
  int nwpv;   // number of words per value; real:1  complex:2

CdoVar() : memType(MemType::Native), gridID(-1), zaxisID(-1), gridsize(0), nlevels(0), datatype(-1), missval(0), timetype(-1), code(0), param(0), nwpv(1)
  {
    name[0] = 0;
  };
};

using VarList = std::vector<CdoVar>;
void varListInit(VarList &vl, int vlistID);
void varListSetUniqueMemtype(VarList &vl);
void varListSetMemtype(VarList &vl, MemType memType);

#endif
