#ifndef MATRIX_VIEW_H
#define MATRIX_VIEW_H

// Modified code from https://github.com/pwwiur/Matrix

template <class T, int R = 0, int C = 0>
class // MatrixView
#ifdef __GNUG__
__attribute__((warn_unused))
#endif
MatrixView
{
private:
  T *arr;
  class Proxy
  {
  public:
    Proxy(T *arr, int width, int x) : px_arr(arr), px_width(width), px_x(x) {}
    T &operator[](int y) { return px_arr[y + px_width * px_x]; }

  private:
    T *px_arr;
    int px_width, px_x;
  };

public:
  int width, height;
  MatrixView(T *array, int rows = 0, int columns = 0)
  {
    if (rows > 0 && columns > 0)
      {
        height = rows;
        width = columns;
      }
    else if (R > 0 && C > 0)
      {
        height = R;
        width = C;
      }
    else
      {
        throw "Matrix initialization should have height and width arguments and must be greater than zero.";
      }

    arr = array;
  }

  Proxy operator[](int x) { return Proxy(arr, width, x); }
};

#endif  // MATRIX_VIEW_H
