/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2019 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/

#ifndef PROCESS_INT_H
#define PROCESS_INT_H

#include "processManager.h"
#include "process.h"

Process &processSelf(void);
bool cdoAssertFilesOnly();
bool cdoStreamIsPipe(CdoStreamID streamID);
bool unchangedRecord();
char **operatorArgv(void);
const std::string & cdoOperatorArgv(int p_idx);
std::vector<std::string> &cdoGetOperArgv();
char *cdoVlistInqVarName(int vlistID, int varID, char *name);
const char *cdoGetObase();
const char *cdoGetStreamName(int p_streamIndex);
const char *cdoOperatorEnter(int operID);
const char *cdoOperatorName(int operID);
const char *processInqPrompt(void);
int cdoFileID(CdoStreamID streamID);
int cdoFiletype(void);
int cdoInqByteorder(CdoStreamID streamID);
int cdoInqFiletype(CdoStreamID streamID);
int cdoStreamCnt(void);
int cdoStreamNumber();
int operatorArgc(void);
int cdoOperatorArgc(void);
int processInqVarNum();
void cdoCloseAllStreams();
void nospec(int vlistID);
void operatorCheckArgc(int numargs);
void operatorInputArg(const char *enter);
void processDefVarNum(int nvars);
void cdoInqGRIBinfo(CdoStreamID streamID, int *intnum, float *fltnum, off_t *bignum);
const char *cdoGetCommandFromInStream(int p_streamIndex);

void cdoSetNAN(double missval, size_t gridsize, double *array);
// ***********************************************************

void cdoInqRecord(CdoStreamID streamID, int *varID, int *levelID);
void cdoDefRecord(CdoStreamID streamID, int varID, int levelID);

void cdoReadRecord(CdoStreamID streamID, Field *data, size_t *nmiss);
void cdoReadRecord(CdoStreamID streamID, double *data, size_t *nmiss);
void cdoReadRecordF(CdoStreamID streamID, float *data, size_t *nmiss);

void cdoWriteRecord(CdoStreamID streamID, Field *data, size_t nmiss);
void cdoWriteRecord(CdoStreamID streamID, double *data, size_t nmiss);
void cdoWriteRecordF(CdoStreamID streamID, float *data, size_t nmiss);
void cdoCopyRecord(CdoStreamID streamIDdest, CdoStreamID streamIDsrc);

int cdoStreamInqTimestep(CdoStreamID streamID, int tsID);
void cdoDefTimestep(CdoStreamID streamID, int tsID);
int cdoStreamInqVlist(CdoStreamID streamID);
void cdoDefVlist(CdoStreamID streamID, int vlistID);

void cdoStreamClose(CdoStreamID streamID);

// ***********************************************************
void cdoDefCompType(CdoStreamID p_streamID, int p_cdi_compression_type);
// ***********************************************************
CdoStreamID cdoOpenAppend(int outStreamIDX);
CdoStreamID cdoOpenRead(int inStreamIDX);
CdoStreamID cdoOpenWrite(int outStreamIDX, int filetype = CDI_UNDEFID);
CdoStreamID cdoOpenWrite(std::string p_filename, int filetype = CDI_UNDEFID);
int cdoOperatorAdd(const char *name, int f1, int f2, const char *enter);
int cdoOperatorF1(int operID);
int cdoOperatorF2(int operID);
int cdoOperatorID(void);
void cdoFinish();
void cdoInitialize(void *process);

#endif
