/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2019 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/
#ifndef VINTERP_H
#define VINTERP_H

#include <cstddef>

void height2pressure(double *phlev, const double *hlev, long nphlev);

void presh(double *fullp, double *halfp, const double *vct, const double *ps, long nhlev, long ngp);

void genind(int *nx, const double *plev, const double *fullp, long ngp, long nplev, long nhlev);
void genindmiss(int *nx, const double *plev, int ngp, int nplev, const double *ps_prog, size_t *pnmiss);

void extra_P(double *slp, const double *halfp, const double *fullp, const double *geop, const double *temp, long ngp);

void interp_T(const double *geop, const double *gt, double *pt, const double *fullp, const double *halfp, const int *nx,
              const double *plev, long nplev, long ngp, long nhlev, double missval);
void interp_Z(const double *geop, const double *gz, double *pz, const double *fullp, const double *halfp, const int *nx,
              const double *gt, const double *plev, long nplev, long ngp, long nhlev, double missval);
void interp_X(const double *gt, double *pt, const double *hyb_press, const int *nx, const double *plev, long nplev, long ngp,
              long nhlev, double missval);

#endif /* VINTERP_H */
