#include "mpmo.h"

namespace MpMO
{

bool silentMode = false;
bool warningsEnabled = true;
bool verbose = false;
bool pedantic = false;
bool exitOnError = true;
int DebugLevel = 0;

void
Debug_(const char *p_func, int p_debugScope, std::function<void()> p_function)
{
  if (p_debugScope) p_function();
}
void
Debug_(const char *p_func, std::function<void()> p_function)
{
  if (DebugLevel > 0) p_function();
}

void
Verbose_(bool p_verbose, std::function<void()> p_function) noexcept
{
  if (p_verbose) p_function();
}

void
enableSilentMode(bool enable)
{
  silentMode = enable;
}

void
enableWarnings(bool enable)
{
    warningsEnabled = enable;
}

void
enablePedantic(bool enable)
{
    pedantic = enable;
}
void
enableVerbose(bool enable)
{
    verbose = enable;
}
}  // namespace MpMO

std::string
argvToString(int argc, const char **argv)
{
  std::string input_string = "";
  for (int i = 0; i < argc; i++)
    {
      input_string += argv[i];
      input_string += " ";
    }
  return input_string;
}
