#ifndef GRID_CONVERT_H
#define GRID_CONVERT_H

#include <cmath>

#ifndef M_PI
#define M_PI 3.14159265358979323846264338327950288  // pi
#endif

constexpr double RAD2DEG = 180. / M_PI;  // conversion for rad to deg
constexpr double DEG2RAD = M_PI / 180.;  // conversion for deg to rad

inline void
gcLLtoXYZ(double lon, double lat, double *xyz)
{
  double cos_lat = cos(lat);
  xyz[0] = cos_lat * cos(lon);
  xyz[1] = cos_lat * sin(lon);
  xyz[2] = sin(lat);
}

inline void
gcLLtoXYZdeg(double lon, double lat, double *xyz)
{
  gcLLtoXYZ(lon * DEG2RAD, lat * DEG2RAD, xyz);
}

#endif
