/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2019 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_LIBNETCDF
#include "netcdf.h"
#endif

#include "cdo_int.h"


#ifdef HAVE_LIBNETCDF
static void
nce(int istat)
{
  // This routine provides a simple interface to NetCDF error message routine.
  if (istat != NC_NOERR) cdoAbort(nc_strerror(istat));
}

static
void verifyWeights(const char *weights_file)
{
  // int nc_file_id = cdf_openread(weights_file);
  // nce(nc_close(nc_file_id));

  //remapReadDataScrip(weights_file, gridID1, gridID2, &mapType, &submapType, &numNeighbors, remapOrder, remaps[0].src_grid,
  //                   remaps[0].tgt_grid, remaps[0].vars);
}
#endif

void *
Remapweights(void *argument)
{
  cdoInitialize(argument);

#ifdef HAVE_LIBNETCDF
  int VERIFYWEIGHTS = cdoOperatorAdd("verifyweights", 0, 0, nullptr);

  int operatorID = cdoOperatorID();

  const char *weights_file = cdoGetStreamName(0);

  if (operatorID == VERIFYWEIGHTS) verifyWeights(weights_file);
#else
  cdoAbort("NetCDF support not compiled in!");
#endif

  cdoFinish();

  return nullptr;
}
