/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


#ifndef _INTERPOLATOR_H_
#define _INTERPOLATOR_H_

#include "amr_defs.H"

//
// This is the base class for all amr_interpolators.  Currently these
// are self-contained, i.e., they don't need to talk to boundary conditions
// or interface objects or whatever.  Tell box what fine area you want
// filled, and it will tell you how much coarse data it needs.  Just
// fill the requested patch with coarse data and call fill.  How you
// get the coarse data is your problem.
//

class amr_interpolator
{
public:
    virtual ~amr_interpolator () = 0;
    virtual Box box (const Box&, const IntVect&) const = 0;
    virtual void fill (FArrayBox&, const Box&,
		       const FArrayBox&, const Box&, const IntVect&) const = 0;
};

class bilinear_interpolator
    : public amr_interpolator
{
public:
    virtual Box box (const Box&, const IntVect&) const;
    virtual void fill (FArrayBox&, const Box&,
		       const FArrayBox&, const Box&, const IntVect&) const;
};

#endif /*_INTERPOLATOR_H_*/
